/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class MiniMore
extends MiniGame {
    private static final int MORETHANBEFORE = 10;
    private static final int FLOCKCOUNT = 4;
    private static final int NUMDIRECTIONS = 8;
    private static final int CHANGEDIRECTION = 4;
    private static final int NORTH = 0;
    private static final int NORTHEAST = 1;
    private static final int EAST = 2;
    private static final int SUDEAST = 3;
    private static final int SUD = 4;
    private static final int SUDWEST = 5;
    private static final int WEST = 6;
    private static final int NORTHWEST = 7;
    private static final int FLOCK_LEFT = 0;
    private static final int FLOCK_RIGHT = 1;
    private static final int NUMBERS = 2;
    private static final int BUGS_SPEED = 1;
    private static final int MAX_TIME_WATCH = 2000;
    private static final int MAX_BUGS = 9;
    private static final int MIN_BUGS = 2;
    private int mAnswerNum;
    private int mNumBugsLeft;
    private int mNumBugsRight;
    private int mNumBugsBefore;
    private int[] mBugsX = new int[]{-100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100};
    private int[] mBugsY = new int[]{-100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100, -100};
    private int[] mBugsSpeedX = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int[] mBugsSpeedY = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int[] mBugsDirection = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int[] mRealDirection = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int mWatchTime;
    private boolean mWatchFirstTime;
    private boolean mNewWatch;
    private int mNumCorrects;
    private int mMinBugs;
    private int mMaxBugs;
    private int mMargin;

    public MiniMore(int n, int n2) {
        this.mBackground = new SpriteObject(SpriteObject.loadAnimation(720903), false);
        this.initialize(n, n2);
        if (mMiniGameID == 10) {
            this.createButtons(SpriteObject.loadAnimations(new int[]{655413, 589877, 589876}), SpriteObject.loadAnimations(new int[]{655415, 589879, 655361}));
            this.mWatchTime = 0;
            this.mWatchFirstTime = true;
            this.mSpritesPool = new SpriteObject[8];
            this.mSpritesPool[0] = new SpriteObject(SpriteObject.loadAnimation(589845), true);
            this.mSpritesPool[1] = new SpriteObject(SpriteObject.loadAnimation(589844), true);
            this.mSpritesPool[2] = new SpriteObject(SpriteObject.loadAnimation(458778), true);
            this.mSpritesPool[3] = new SpriteObject(SpriteObject.loadAnimation(589855), true);
            this.mSpritesPool[4] = new SpriteObject(SpriteObject.loadAnimation(589848), true);
            this.mSpritesPool[5] = new SpriteObject(SpriteObject.loadAnimation(589852), true);
            this.mSpritesPool[6] = new SpriteObject(SpriteObject.loadAnimation(589851), true);
            this.mSpritesPool[7] = new SpriteObject(SpriteObject.loadAnimation(589843), true);
        } else {
            this.createButtons(SpriteObject.loadAnimations(new int[]{917529, 589867, 589874}), SpriteObject.loadAnimations(new int[]{655444, 589869, 589870}));
            this.mWatchTime = 2003;
            this.mWatchFirstTime = false;
            this.mSpritesPool = new SpriteObject[3];
            this.mSpritesPool[0] = new SpriteObject(SpriteObject.loadAnimation(655389), true);
            this.mSpritesPool[1] = new SpriteObject(SpriteObject.loadAnimation(655384), true);
            this.mSpritesPool[2] = new SpriteObject(SpriteObject.loadAnimation(655400), false);
        }
        this.mNumCorrects = 0;
        this.mMinBugs = 2;
        this.mMaxBugs = 6;
        this.mMargin = this.mSpritesPool[0].getWidth() / 2;
        this.mDrawButtons = false;
        this.mDrawWatchIcon = true;
    }

    protected boolean checkAnswer(int n) {
        return this.mHudConfirmationTicks <= 0;
    }

    protected void drawGame(Graphics graphics) {
        for (int i = 0; i < this.mNumBugsLeft + this.mNumBugsRight; ++i) {
            this.mSpritesPool[this.mRealDirection[i]].draw(graphics, this.mBugsX[i], this.mBugsY[i]);
        }
        if (mMiniGameID == 4) {
            graphics.setColor(0);
            graphics.drawRect(this.mCanvasX, this.mCanvasY, this.mCanvasWidth, this.mCanvasHeight);
            graphics.drawLine(this.mCanvasX + this.mCanvasWidth / 2, this.mCanvasY, this.mCanvasX + this.mCanvasWidth / 2, this.mCanvasY + this.mCanvasHeight - this.mSpritesPool[2].getHeight());
            this.mSpritesPool[2].draw(graphics, Toolkit.getScreenWidth() / 2, this.mCanvasY + this.mCanvasHeight - this.mSpritesPool[2].getPivotY());
        }
    }

    protected void initNextQuestion() {
        int n;
        int n2;
        if (mMiniGameID == 10) {
            this.mNumBugsBefore = this.mNumBugsLeft;
            if (this.mNumCorrects % 4 == 0 && this.mMaxBugs < 9) {
                ++this.mMinBugs;
                ++this.mMaxBugs;
            }
            do {
                this.mNumBugsLeft = MiniMore.rnd(this.mMaxBugs - this.mMinBugs + 1) + this.mMinBugs;
            } while (this.mNumBugsLeft == this.mNumBugsBefore);
            this.mNumBugsRight = 0;
        } else {
            this.mNumBugsLeft = MiniMore.rnd(5) + 3;
            do {
                this.mNumBugsRight = MiniMore.rnd(5) + 3;
            } while (this.mNumBugsLeft == this.mNumBugsRight);
            this.mAnswerNum = this.mNumBugsLeft;
            if (MiniMore.rnd(100) < 50) {
                this.mAnswerNum = this.mNumBugsRight;
            }
        }
        this.mSpritesPool[2].setAnimationFrame(this.mAnswerNum);
        for (n2 = 0; n2 < this.mNumBugsLeft; ++n2) {
            this.changeBugDirection(n2, MiniMore.rnd(8));
            n = this.mCanvasWidth;
            if (mMiniGameID == 4) {
                n /= 2;
            }
            this.mBugsX[n2] = this.mCanvasX + MiniMore.rnd(n -= this.mMargin * 2) + this.mMargin;
            this.mBugsY[n2] = this.mCanvasY + MiniMore.rnd(this.mCanvasWidth - this.mMargin * 2) + this.mMargin;
        }
        if (mMiniGameID == 4) {
            for (n2 = 0; n2 < this.mNumBugsRight; ++n2) {
                int n3 = n2 + this.mNumBugsLeft;
                this.changeBugDirection(n3, MiniMore.rnd(8));
                n = this.mCanvasWidth / 2 - this.mMargin * 2;
                this.mBugsX[n3] = this.mCanvasX + MiniMore.rnd(n) + this.mMargin + this.mCanvasWidth / 2;
                this.mBugsY[n3] = this.mCanvasY + MiniMore.rnd(this.mCanvasWidth - this.mMargin * 2) + this.mMargin;
            }
        }
        if (mMiniGameID == 10) {
            if (this.mNewWatch) {
                this.mNumCorrects = 0;
                this.mWatchTime = 0;
                this.mWatchFirstTime = true;
                this.mNewWatch = false;
                if (this.mMinBugs > 2) {
                    --this.mMinBugs;
                    --this.mMaxBugs;
                }
            }
            this.mHudConfirmationTicks = 0;
        }
    }

    private void changeBugDirection(int n, int n2) {
        this.mBugsDirection[n] = n2;
        switch (n2) {
            case 0: {
                this.mBugsSpeedX[n] = 0;
                this.mBugsSpeedY[n] = -1;
                break;
            }
            case 1: {
                this.mBugsSpeedX[n] = 1;
                this.mBugsSpeedY[n] = -1;
                break;
            }
            case 2: {
                this.mBugsSpeedX[n] = 1;
                this.mBugsSpeedY[n] = 0;
                break;
            }
            case 3: {
                this.mBugsSpeedX[n] = 1;
                this.mBugsSpeedY[n] = 1;
                break;
            }
            case 4: {
                this.mBugsSpeedX[n] = 0;
                this.mBugsSpeedY[n] = 1;
                break;
            }
            case 5: {
                this.mBugsSpeedX[n] = -1;
                this.mBugsSpeedY[n] = 1;
                break;
            }
            case 6: {
                this.mBugsSpeedX[n] = -1;
                this.mBugsSpeedY[n] = 0;
                break;
            }
            case 7: {
                this.mBugsSpeedX[n] = -1;
                this.mBugsSpeedY[n] = -1;
            }
        }
        this.mRealDirection[n] = this.mBugsDirection[n];
        if (mMiniGameID == 4) {
            switch (this.mBugsDirection[n]) {
                case 1: 
                case 2: 
                case 3: {
                    this.mRealDirection[n] = 0;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    this.mRealDirection[n] = 1;
                    break;
                }
                default: {
                    this.mRealDirection[n] = MiniMore.rnd(2);
                }
            }
        }
    }

    protected int isCorrectAnswer(int n) {
        if (n != 0) {
            int n2 = Toolkit.getToolkitGameAction(n);
            if (n2 == 52 || n == 52) {
                if (mMiniGameID == 10) {
                    this.mHudConfirmationTicks = 2000;
                    this.pressButton(0, this.mNumBugsLeft > this.mNumBugsBefore, true);
                    if (this.mNumBugsLeft > this.mNumBugsBefore) {
                        if (mMiniGameID == 10) {
                            this.registerParticle(Toolkit.getScreenWidth() >> 1, Toolkit.getScreenHeight() >> 1);
                        } else {
                            this.registerParticle(this.mCanvasX + (this.mCanvasWidth >> 2), Toolkit.getScreenHeight() >> 1, true);
                        }
                        return 0;
                    }
                    this.mNewWatch = true;
                    return 1;
                }
                this.pressButton(0, this.mAnswerNum == this.mNumBugsLeft, true);
                if (this.mAnswerNum == this.mNumBugsLeft) {
                    ++this.mNumCorrects;
                    if (mMiniGameID == 10) {
                        this.registerParticle(Toolkit.getScreenWidth() >> 1, Toolkit.getScreenHeight() >> 1);
                    } else {
                        this.registerParticle(this.mCanvasX + (this.mCanvasWidth >> 2), Toolkit.getScreenHeight() >> 1, true);
                    }
                    return 0;
                }
                return 1;
            }
            if (n2 == 54 || n == 54) {
                if (mMiniGameID == 10) {
                    this.mHudConfirmationTicks = 2000;
                    this.pressButton(1, this.mNumBugsLeft < this.mNumBugsBefore, true);
                    if (this.mNumBugsLeft < this.mNumBugsBefore) {
                        ++this.mNumCorrects;
                        if (mMiniGameID == 10) {
                            this.registerParticle(Toolkit.getScreenWidth() >> 1, Toolkit.getScreenHeight() >> 1);
                        } else {
                            this.registerParticle(this.mCanvasX + (this.mCanvasWidth >> 1) + (this.mCanvasWidth >> 2), Toolkit.getScreenHeight() >> 1, true);
                        }
                        return 0;
                    }
                    this.mNewWatch = true;
                    return 1;
                }
                this.pressButton(1, this.mAnswerNum == this.mNumBugsRight, true);
                if (this.mAnswerNum == this.mNumBugsRight) {
                    if (mMiniGameID == 10) {
                        this.registerParticle(Toolkit.getScreenWidth() >> 1, Toolkit.getScreenHeight() >> 1);
                    } else {
                        this.registerParticle(this.mCanvasX + (this.mCanvasWidth >> 1) + (this.mCanvasWidth >> 2), Toolkit.getScreenHeight() >> 1, true);
                    }
                    return 0;
                }
                return 1;
            }
        }
        return 3;
    }

    protected void updateGame(int n) {
        this.updateBug(n);
    }

    protected boolean updateWatch(int n) {
        if (!this.mWatchFirstTime) {
            this.mDrawButtons = true;
            return true;
        }
        this.mHudConfirmationPosX = -100;
        this.mHudConfirmationPosY = -100;
        this.mDrawButtons = false;
        this.mDrawWatchIcon = true;
        this.updateBug(n);
        this.mWatchTime += n;
        if (this.mWatchTime >= 2000) {
            this.initNextQuestion();
            this.mWatchFirstTime = false;
            this.mDrawButtons = true;
            return true;
        }
        return false;
    }

    private void updateBug(int n) {
        int n2;
        if (mMiniGameID == 4) {
            for (n2 = 0; n2 < 2; ++n2) {
                this.mSpritesPool[n2].logicUpdate(n);
            }
        } else {
            for (n2 = 0; n2 < 8; ++n2) {
                this.mSpritesPool[n2].logicUpdate(n);
            }
        }
        while (this.mProcessedTime < this.mElapsedTime) {
            for (n2 = 0; n2 < this.mNumBugsLeft + this.mNumBugsRight; ++n2) {
                int n3;
                if (MiniMore.rnd(100) < 10) {
                    if (MiniMore.rnd(2) == 0) {
                        n3 = (this.mBugsDirection[n2] + 1) % 8;
                    } else {
                        n3 = this.mBugsDirection[n2] - 1;
                        if (n3 < 0) {
                            n3 = 7;
                        }
                    }
                    this.changeBugDirection(n2, n3);
                }
                n3 = this.mCanvasX;
                int n4 = this.mCanvasX + (this.mCanvasWidth >> 1);
                int n5 = this.mBugsX[n2] + this.mBugsSpeedX[n2];
                int n6 = this.mBugsY[n2] + this.mBugsSpeedY[n2];
                if (mMiniGameID == 10) {
                    n4 += this.mCanvasWidth >> 1;
                } else if (n2 >= this.mNumBugsLeft) {
                    n3 += this.mCanvasWidth >> 1;
                    n4 += this.mCanvasWidth >> 1;
                }
                if (n5 - this.mMargin <= n3 || n5 + this.mMargin >= n4 || n6 - this.mMargin <= this.mCanvasY || n6 + this.mMargin >= this.mCanvasY + this.mCanvasHeight) {
                    this.changeBugDirection(n2, (this.mBugsDirection[n2] + 4) % 8);
                }
                int n7 = n2;
                this.mBugsX[n7] = this.mBugsX[n7] + this.mBugsSpeedX[n2];
                int n8 = n2;
                this.mBugsY[n8] = this.mBugsY[n8] + this.mBugsSpeedY[n2];
            }
            this.mProcessedTime += 50;
        }
    }
}

