/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class MiniLogicMammals
extends MiniGame {
    private static final int SPRITE_ANIMAL_1 = 0;
    private static final int SPRITE_ANIMAL_2 = 1;
    private static final int SPRITE_ANIMAL_3 = 2;
    private static final int NUM_SPRITES = 3;
    private static final int LOOK_LEFT_MIRROR = 0;
    private static final int LOOK_RIGHT_MIRROR = 1;
    private static final int LOOK_LEFT = 2;
    private static final int LOOK_RIGHT = 3;
    static final int NUM_COLUMNS = 3;
    static final int NUM_ROWS = 3;
    static final int OP_EQUAL = 0;
    static final int OP_FLIPX = 1;
    static final int OP_FLIPY = 2;
    int[][] matrix = new int[3][3];
    int mLocalHudConfirmationPosX;
    int mLocalHudConfirmationPosY;
    int[] rowOperations = new int[2];
    int[] columnOperations = new int[2];
    boolean showConfirmation;
    boolean createParticle;
    boolean wanted;
    int guessX;
    int guessY;
    int chosenAnimal = 1;
    int possibleSolution;
    int mAnswer;
    int status;
    int solutionSize;

    public int getFlipX(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return 0;
        }
        if (n == 2) {
            return 3;
        }
        return 2;
    }

    public int getFlipY(int n) {
        if (n == 0) {
            return 2;
        }
        if (n == 1) {
            return 3;
        }
        if (n == 2) {
            return 0;
        }
        return 1;
    }

    public MiniLogicMammals(int n, int n2) {
        this.mBackground = new SpriteObject(SpriteObject.loadAnimation(655450), false);
        this.initialize(n, n2);
        this.createButtons(SpriteObject.loadAnimations(new int[]{655413, 589877, 589876}), SpriteObject.loadAnimations(new int[]{655415, 589879, 655361}));
        this.mSpritesPool = new SpriteObject[3];
        int n3 = 0;
        int n4 = 0;
        this.mSpritesPool[0] = new SpriteObject(SpriteObject.loadAnimation(131086), false);
        this.mSpritesPool[1] = new SpriteObject(SpriteObject.loadAnimation(131085), false);
        this.mSpritesPool[2] = new SpriteObject(SpriteObject.loadAnimation(131084), false);
        this.mSpritesPool[2].setAnimationFrame(0);
        n3 = Math.abs(this.mSpritesPool[2].getPivotX()) * 2;
        n4 = Math.abs(this.mSpritesPool[2].getPivotY()) * 2;
        this.solutionSize = Math.max(n3, n4);
    }

    public void updateGame(int n) {
        for (int i = 0; i < 3; ++i) {
            this.mSpritesPool[i].logicUpdate(n);
        }
        if (this.status == 1 && this.mAnswer != 3 && this.mHudConfirmationTicks <= 0) {
            this.keyEvent(54, 0);
        }
    }

    protected boolean checkAnswer(int n) {
        return this.mHudConfirmationTicks <= 0;
    }

    public void drawGame(Graphics graphics) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = -13;
        int n5 = 0;
        int n6 = 9;
        graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
        int n7 = this.solutionSize + 6;
        int n8 = this.mCanvasWidth / 3;
        int n9 = (this.mCanvasHeight - n7) / 3;
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                int n10 = n6 - n5 << 12;
                n10 = n2 * n10 / 3 >> 12;
                int n11 = n4 - n3 << 12;
                n11 = n * (n11 / 3) >> 12;
                int n12 = this.mCanvasX + n * n8 + (n8 >> 1);
                int n13 = this.mCanvasY + n2 * n9 + (n9 >> 1) - 0;
                n12 += n10;
                n13 += n11;
                if (this.status == 1 || this.guessX != n2 || this.guessY != n) {
                    if (n2 == this.guessX && n == this.guessY) {
                        this.mLocalHudConfirmationPosX = n12;
                        this.mLocalHudConfirmationPosY = n13;
                        if (this.createParticle) {
                            this.registerParticle(this.mLocalHudConfirmationPosX, this.mLocalHudConfirmationPosY);
                            this.createParticle = false;
                        }
                    }
                    this.mSpritesPool[this.chosenAnimal].setAnimationFrame(this.matrix[n2][n]);
                    this.mSpritesPool[this.chosenAnimal].draw(graphics, n12, n13);
                    continue;
                }
                smFont.drawString(graphics, "?", n12, (n13 -= smFont.getHeight()) + 0, 17);
            }
        }
        n2 = this.mCanvasWidth - this.solutionSize >> 1;
        n = n9 * 3 + this.solutionSize / 2;
        n -= this.mSpritesPool[2].getPivotY();
        graphics.setColor(0);
        graphics.drawRect(this.mCanvasX + n2 - 1 - 0, this.mCanvasY + this.mCanvasHeight - this.solutionSize - 0, this.solutionSize + 2 + 0, this.solutionSize + 0);
        this.mSpritesPool[this.chosenAnimal].setAnimationFrame(this.possibleSolution);
        this.mSpritesPool[this.chosenAnimal].draw(graphics, this.mCanvasX + (this.mCanvasWidth >> 1), this.mCanvasY + 0 + this.mCanvasHeight - (this.solutionSize >> 1));
        if (this.showConfirmation) {
            if (this.mAnswer == 0) {
                this.mCorrectSprite.draw(graphics, this.mLocalHudConfirmationPosX, this.mLocalHudConfirmationPosY);
            } else {
                this.mWrongSprite.draw(graphics, this.mLocalHudConfirmationPosX, this.mLocalHudConfirmationPosY);
            }
        }
        graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
    }

    protected void initNextQuestion() {
        int n;
        int n2;
        this.createParticle = false;
        this.status = 0;
        this.chosenAnimal = MiniLogicMammals.rnd(3);
        this.showConfirmation = false;
        this.mHudConfirmationPosX = -100;
        this.mHudConfirmationPosY = -100;
        this.mLocalHudConfirmationPosX = -1000;
        this.mLocalHudConfirmationPosY = -1000;
        this.wanted = this.rndBin();
        int n3 = 1;
        int n4 = 1;
        if (this.mDifficulty >= 2) {
            n4 = 2;
        }
        if (this.mDifficulty >= 4) {
            n3 = 2;
        }
        if (this.mDifficulty >= 6) {
            n4 = 3;
        }
        if (this.mDifficulty >= 8) {
            n3 = 3;
        }
        this.guessX = 1;
        this.guessY = 1;
        while (this.guessX == 1 && this.guessY == 1) {
            this.guessX = MiniLogicMammals.rnd(3);
            this.guessY = MiniLogicMammals.rnd(3);
        }
        this.matrix[0][0] = n2 = MiniLogicMammals.rnd(4);
        for (n = 0; n < this.rowOperations.length; ++n) {
            this.rowOperations[n] = MiniLogicMammals.rnd(n4);
        }
        for (n = 0; n < this.columnOperations.length; ++n) {
            this.columnOperations[n] = MiniLogicMammals.rnd(n3);
        }
        for (n = 1; n < 3; ++n) {
            this.matrix[0][n] = this.operate(this.matrix[0][n - 1], this.columnOperations[n - 1]);
        }
        for (n = 0; n < 3; ++n) {
            this.matrix[1][n] = this.operate(this.matrix[0][n], this.rowOperations[0]);
            this.matrix[2][n] = this.operate(this.matrix[1][n], this.rowOperations[1]);
        }
        this.possibleSolution = this.matrix[this.guessX][this.guessY];
        if (!this.wanted) {
            while (this.possibleSolution == this.matrix[this.guessX][this.guessY]) {
                this.possibleSolution = this.operate(this.matrix[this.guessX][this.guessY], 1 + MiniLogicMammals.rnd(2));
            }
        }
    }

    public int operate(int n, int n2) {
        switch (n2) {
            case 0: {
                return n;
            }
            case 1: {
                return this.getFlipX(n);
            }
            case 2: {
                return this.getFlipY(n);
            }
        }
        return n;
    }

    protected int isCorrectAnswer(int n) {
        if (this.status == 1) {
            this.mHudConfirmationTicks = this.mAnswer == 0 ? 500 : 1000;
            return this.mAnswer;
        }
        if (n != 0) {
            int n2 = Toolkit.getToolkitGameAction(n);
            if (n2 == 52 || n == 52) {
                this.pressButton(0, this.wanted, true);
                this.showConfirmation = true;
                if (this.wanted) {
                    this.status = 1;
                    this.createParticle = true;
                    this.mAnswer = 0;
                } else {
                    this.status = 1;
                    this.mAnswer = 1;
                }
            } else if (n2 == 54 || n == 54) {
                this.pressButton(1, !this.wanted, true);
                this.showConfirmation = true;
                if (!this.wanted) {
                    this.status = 1;
                    this.createParticle = true;
                    this.mAnswer = 0;
                } else {
                    this.status = 1;
                    this.mAnswer = 1;
                }
            }
        }
        return 3;
    }
}

