/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class MiniKeys
extends MiniGame {
    private static final int NUM_KEYS = 15;
    private static final byte[][] KEYS = new byte[][]{{4, 1, 1, 1, 4}, {4, 1, 3, 1, 4}, {4, 3, 2, 1, 4}, {4, 1, 2, 4, 4}, {1, 1, 4, 1, 3}, {2, 1, 2, 1, 3}, {2, 3, 4, 2, 1}, {3, 1, 4, 1, 4}, {2, 3, 3, 4, 3}, {2, 3, 4, 3, 2}, {2, 2, 2, 4, 4}, {3, 2, 1, 1, 4}, {1, 4, 4, 1, 4}, {4, 3, 4, 3, 4}, {3, 4, 3, 2, 1}};
    private static final byte[][] MIRROR_KEYS = new byte[][]{{28, 4, 28, 12, 7}, {31, 7, 6, 12, 8}, {31, 4, 15, 4, 31}, {15, 28, 14, 4, 14}, {14, 2, 6, 14, 31}, {31, 28, 4, 12, 15}, {31, 3, 14, 7, 31}, {17, 17, 27, 30, 8}, {14, 4, 15, 4, 28}, {28, 24, 31, 16, 16}, {14, 2, 6, 12, 31}, {28, 6, 7, 15, 30}, {6, 12, 24, 12, 7}, {31, 1, 31, 16, 31}, {15, 9, 13, 1, 31}};
    private static final int BAR = 0;
    private static final int EXTRALINES = 4;
    private static final int PIXEL_SIZE = 7;
    private static final int NUM_PIXELS = 5;
    private static final int KEY_RIGHT = 0;
    private static final int KEY_LEFT = 1;
    private int[] mKeyColumnLeft;
    private int[] mKeyColumnRight;
    private int[] mKeyColumnMiddle;
    private int[] mkeySide;
    private int mKeysRows;
    private int mKeysHeight;
    private int mScrollDown;
    private boolean doScroll;
    private int mKeyWidth;
    private int mPosXInit;
    private int mPosYInit;

    public MiniKeys(int n, int n2) {
        this.initialize(n, n2);
        this.createButtons(SpriteObject.loadAnimations(new int[]{917529, 589868}), SpriteObject.loadAnimations(new int[]{655444, 589875}));
        this.mSpritesPool = new SpriteObject[1];
        this.mSpritesPool[0] = new SpriteObject(SpriteObject.loadAnimation(589873), true);
        this.mKeysHeight = 41;
        this.mKeysRows = this.mCanvasHeight / this.mKeysHeight;
        this.mKeyColumnLeft = new int[this.mKeysRows + 4];
        this.mKeyColumnRight = new int[this.mKeysRows + 4];
        this.mKeyColumnMiddle = new int[this.mKeysRows + 4];
        this.mkeySide = new int[this.mKeysRows + 4];
        for (int i = 0; i < this.mKeysRows + 4; ++i) {
            this.createNewKey(i);
        }
        this.doScroll = false;
        this.mKeyWidth = 35;
        if (mMiniGameID == 15) {
            this.mBackground = new SpriteObject(SpriteObject.loadAnimation(786435), false);
            this.mPosXInit = (this.mCanvasWidth - this.mKeyWidth * 4) / 2 + this.mCanvasX;
        } else {
            this.mBackground = new SpriteObject(SpriteObject.loadAnimation(655450), false);
            this.mPosXInit = (this.mCanvasWidth - (this.mKeyWidth * 3 + 24)) / 2 + this.mCanvasX;
        }
        this.mPosYInit = this.mCanvasY + this.mCanvasHeight - this.mKeysHeight - (this.mCanvasHeight - this.mKeysHeight * this.mKeysRows) / 2;
    }

    private void drawKey(Graphics graphics, int n, int n2, int n3, boolean bl) {
        graphics.setColor(0);
        for (int i = 0; i < 5; ++i) {
            int n4 = 0;
            int n5 = 0;
            for (int j = 4; j >= 0; --j) {
                int n6 = MIRROR_KEYS[n3][i] & 1 << j;
                if (n6 == 0 || j == 0) {
                    if (j == 0 && n6 == 1) {
                        n5 += 7;
                    }
                    if (n5 > 0) {
                        int n7 = n + n4;
                        if (bl) {
                            n7 = n + (this.mKeyWidth - n5 - n4);
                        }
                        graphics.fillRect(n7, n2 + i * 7, n5, 7);
                        n4 += n5;
                        n5 = 0;
                    }
                    n4 += 7;
                    continue;
                }
                n5 += 7;
            }
        }
    }

    private void drawKey(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        graphics.setColor(0);
        for (int i = 0; i < 5; ++i) {
            if (bl) {
                if (n4 == 1) {
                    graphics.fillRect(n + (5 - KEYS[n3][i]) * 7, n2 + i * 7, KEYS[n3][i] * 7, 7);
                    continue;
                }
                graphics.fillRect(n, n2 + i * 7, (5 - KEYS[n3][i]) * 7, 7);
                continue;
            }
            if (n4 == 1) {
                graphics.fillRect(n, n2 + i * 7, KEYS[n3][i] * 7, 7);
                continue;
            }
            graphics.fillRect(n + KEYS[n3][i] * 7, n2 + i * 7, (5 - KEYS[n3][i]) * 7, 7);
        }
    }

    protected boolean checkAnswer(int n) {
        this.mSpritesPool[0].logicUpdate(n);
        if (this.mGameMode == 1) {
            return this.mHudConfirmationTicks <= 0;
        }
        return true;
    }

    protected void drawGame(Graphics graphics) {
        int n = this.mPosYInit = this.mCanvasY + this.mCanvasHeight - this.mKeysHeight - (this.mCanvasHeight - this.mKeysHeight * this.mKeysRows) / 2;
        graphics.setClip(this.mCanvasX, n - this.mKeysRows * this.mKeysHeight + this.mKeysHeight, this.mCanvasWidth, this.mKeysRows * this.mKeysHeight - 0);
        n -= this.mScrollDown;
        n += this.mKeysHeight;
        this.mSpritesPool[0].draw(graphics, this.mCanvasX + this.mCanvasWidth / 2 + 3, this.mPosYInit + this.mSpritesPool[0].getPivotY() - 0);
        if (mMiniGameID == 15) {
            for (int i = 0; i < this.mKeysRows + 2; ++i) {
                int n2 = this.mPosXInit;
                this.drawKey(graphics, n2, n, this.mKeyColumnLeft[i + 2], 1, false);
                n2 += this.mKeyWidth;
                if (this.mkeySide[i + 2] == 1) {
                    this.drawKey(graphics, n2, n, this.mKeyColumnLeft[i + 2], 0, false);
                    this.drawKey(graphics, n2 += this.mKeyWidth + 1, n, this.mKeyColumnMiddle[i + 2], 1, false);
                } else {
                    this.drawKey(graphics, n2, n, this.mKeyColumnMiddle[i + 2], 0, false);
                    this.drawKey(graphics, n2 += this.mKeyWidth + 1, n, this.mKeyColumnRight[i + 2], 1, false);
                }
                this.drawKey(graphics, n2 += this.mKeyWidth, n, this.mKeyColumnRight[i + 2], 0, false);
                n -= this.mKeysHeight;
            }
            graphics.setClip(this.mCanvasX, this.mCanvasY, this.mCanvasWidth, this.mCanvasHeight);
            graphics.setColor(0xFF0000);
            graphics.drawLine(this.mCanvasX + this.mCanvasWidth / 2, this.mCanvasY, this.mCanvasX + this.mCanvasWidth / 2, this.mCanvasY + this.mCanvasHeight);
        } else {
            for (int i = 0; i < this.mKeysRows + 2; ++i) {
                int n3 = this.mPosXInit;
                this.drawKey(graphics, n3, n, this.mKeyColumnLeft[i + 2], false);
                this.drawKey(graphics, n3 += this.mKeyWidth + 12, n, this.mKeyColumnMiddle[i + 2], true);
                this.drawKey(graphics, n3 += this.mKeyWidth + 12, n, this.mKeyColumnRight[i + 2], false);
                n -= this.mKeysHeight;
            }
        }
    }

    private void createNewKey(int n) {
        this.mKeyColumnLeft[n] = MiniKeys.rnd(15);
        this.mkeySide[n] = 1;
        if (MiniKeys.rnd(100) < 50) {
            this.mkeySide[n] = 0;
        }
        do {
            this.mKeyColumnRight[n] = MiniKeys.rnd(15);
        } while (this.mKeyColumnLeft[n] == this.mKeyColumnRight[n]);
        if (mMiniGameID == 15) {
            do {
                this.mKeyColumnMiddle[n] = MiniKeys.rnd(15);
            } while (this.mKeyColumnMiddle[n] == this.mKeyColumnRight[n] || this.mKeyColumnLeft[n] == this.mKeyColumnMiddle[n]);
        } else {
            this.mKeyColumnMiddle[n] = this.mKeyColumnLeft[n];
            if (this.mkeySide[n] == 0) {
                this.mKeyColumnMiddle[n] = this.mKeyColumnRight[n];
            }
        }
    }

    protected void initNextQuestion() {
        for (int i = 0; i < this.mKeysRows - 1 + 4; ++i) {
            this.mKeyColumnLeft[i] = this.mKeyColumnLeft[i + 1];
            this.mKeyColumnRight[i] = this.mKeyColumnRight[i + 1];
            this.mKeyColumnMiddle[i] = this.mKeyColumnMiddle[i + 1];
            this.mkeySide[i] = this.mkeySide[i + 1];
        }
        this.createNewKey(this.mKeysRows - 1 + 4);
        if (this.doScroll) {
            this.mScrollDown = this.mKeysHeight;
            this.doScroll = false;
        }
    }

    protected int isCorrectAnswer(int n) {
        if (n != 0) {
            int n2 = Toolkit.getToolkitGameAction(n);
            if (n2 == 52 || n == 52) {
                this.pressButton(0, this.mkeySide[3] == 1, false);
                this.mHudConfirmationPosX = this.mPosXInit + this.mKeyWidth + 6;
                this.mHudConfirmationPosY = this.mPosYInit + this.mKeysHeight / 2;
                this.doScroll = true;
                if (this.mkeySide[3] == 1) {
                    this.registerParticle(this.mHudConfirmationPosX, this.mHudConfirmationPosY);
                    return 0;
                }
                return 1;
            }
            if (n2 == 54 || n == 54) {
                this.pressButton(1, this.mkeySide[3] == 0, false);
                this.mHudConfirmationPosX = this.mPosXInit + this.mKeyWidth * 3 + 6;
                this.mHudConfirmationPosY = this.mPosYInit + this.mKeysHeight / 2;
                this.doScroll = true;
                if (this.mkeySide[3] == 0) {
                    this.registerParticle(this.mHudConfirmationPosX, this.mHudConfirmationPosY);
                    return 0;
                }
                return 1;
            }
        }
        return 3;
    }

    protected void updateGame(int n) {
        this.mSpritesPool[0].logicUpdate(n);
        if (this.mScrollDown > 0) {
            while (this.mProcessedTime < this.mElapsedTime) {
                this.mScrollDown -= this.mKeysHeight / 6;
                this.mProcessedTime += 50;
            }
            if (this.mScrollDown < 0) {
                this.mScrollDown = 0;
            }
        }
    }
}

