/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class MiniMusic
extends MiniGame {
    private static final int MAX_NOTES = 7;
    private static final int MIN_NOTES = 4;
    private static final int SHOW_WAIT = 250;
    private static final int TIME_TO_REMOVE = 10;
    private static final int NOTE_LEFT = -1;
    private static final int NOTE_RIGHT = 1;
    private static final int NOTE = 0;
    private static final int NOTE_CORRECT = 1;
    private static final int NOTE_FALSE = 2;
    private int[] mNotes = new int[7];
    private int mNoteIndex;
    private int mNoteActualIndex;
    private int mShowNoteIndex;
    private int mShowNoteTick;
    private boolean mNoteCorrect;
    private int[] mNotesAnswer = new int[]{0, 0, 0, 0, 0, 0, 0};
    private int mNumNotes;

    public MiniMusic(int n, int n2) {
        this.mBackground = new SpriteObject(SpriteObject.loadAnimation(786433), false);
        this.initialize(n, n2);
        this.createButtons(SpriteObject.loadAnimations(new int[]{917529, 589867, 589874}), SpriteObject.loadAnimations(new int[]{655444, 589869, 589870}));
        this.mSpritesPool = new SpriteObject[3];
        this.mSpritesPool[0] = new SpriteObject(SpriteObject.loadAnimation(655412), true);
        this.mSpritesPool[1] = new SpriteObject(SpriteObject.loadAnimation(655408), true);
        this.mSpritesPool[2] = new SpriteObject(SpriteObject.loadAnimation(655404), true);
        this.mNumNotes = 4;
        this.initNotes();
        this.mDrawButtons = false;
        this.mDrawWatchIcon = true;
    }

    private void initNotes() {
        this.mNoteIndex = this.mNumNotes;
        this.mNoteCorrect = true;
        this.mNotes[0] = MiniMusic.rnd(7);
        for (int i = 1; i < this.mNumNotes; ++i) {
            int n;
            if (MiniMusic.rnd(100) < 50) {
                n = 1;
                if (this.mNotes[i - 1] + n >= 7) {
                    n = -1;
                }
            } else {
                n = -1;
                if (this.mNotes[i - 1] + n < 0) {
                    n = 1;
                }
            }
            this.mNotes[i] = this.mNotes[i - 1] + n;
        }
    }

    protected void initNextQuestion() {
        this.mShowNoteIndex = 0;
        this.mNoteActualIndex = 1;
        this.mShowNoteTick = 250 - 10 * this.mDifficulty;
    }

    protected void updateGame(int n) {
        this.mSpritesPool[0].logicUpdate(n);
        this.mSpritesPool[1].logicUpdate(n);
        this.mSpritesPool[2].logicUpdate(n);
    }

    protected boolean updateWatch(int n) {
        this.mSpritesPool[0].logicUpdate(n);
        this.mSpritesPool[1].logicUpdate(n);
        this.mSpritesPool[2].logicUpdate(n);
        this.mShowNoteTick -= n;
        if (this.mShowNoteTick <= 0) {
            ++this.mShowNoteIndex;
            this.mShowNoteTick = 250 - 10 * this.mDifficulty;
            if (this.mShowNoteIndex > this.mNumNotes) {
                this.mDrawButtons = true;
                return true;
            }
        }
        return false;
    }

    protected void drawGame(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4 = this.mCanvasWidth / 8;
        int n5 = n3 = this.mCanvasX + n4;
        for (n2 = 0; n2 < 7; ++n2) {
            n = -13 * n2 / 7;
            graphics.setColor(0x808080);
            graphics.drawLine(n5 + -13, this.mCanvasY + n, n5, this.mCanvasY + this.mCanvasHeight + n);
            graphics.setColor(0xD5D5D5);
            graphics.drawLine(n5 + -13 + 1, this.mCanvasY + n, n5 + 1, this.mCanvasY + this.mCanvasHeight + n);
            graphics.drawLine(n5 + -13 - 1, this.mCanvasY + n, n5 - 1, this.mCanvasY + this.mCanvasHeight + n);
            n5 += n4;
        }
        n2 = this.mSpritesPool[1].getHeight();
        n = n2 + 3;
        int n6 = n3;
        int n7 = this.mCanvasY + 3 + 0;
        switch (this.mState[this.mGameMode]) {
            case 3: {
                if (this.mShowNoteIndex > 0) {
                    int n8 = n7;
                    for (int i = 0; i < this.mShowNoteIndex; ++i) {
                        int n9 = -13 * (7 - i) / 7;
                        this.mSpritesPool[0].draw(graphics, n6 + this.mNotes[i] * n4 + n9, n8);
                        n8 += n;
                    }
                }
                this.mHudConfirmationPosX = -100;
                this.mHudConfirmationPosY = -100;
                break;
            }
            case 4: 
            case 5: {
                if (this.mNoteActualIndex - 1 <= -1) break;
                int n10 = n7;
                for (int i = 0; i <= this.mNoteActualIndex - 1; ++i) {
                    int n11 = -13 * (7 - i) / 7;
                    this.mSpritesPool[this.mNotesAnswer[i]].draw(graphics, n6 + this.mNotes[i] * n4 + n11, n10);
                    n10 += n;
                }
                break;
            }
        }
    }

    protected int isCorrectAnswer(int n) {
        if (n != 0) {
            int n2 = Toolkit.getToolkitGameAction(n);
            int n3 = this.mCanvasX + this.mCanvasWidth / 8 + this.mNotes[this.mNoteActualIndex] * (this.mCanvasWidth / 8);
            int n4 = this.mCanvasY + 3 + (this.mSpritesPool[1].getHeight() + 3) * this.mNoteActualIndex;
            if (n2 == 52 || n == 52) {
                this.pressButton(0, this.mNotes[this.mNoteActualIndex - 1] > this.mNotes[this.mNoteActualIndex], true);
                this.mHudConfirmationTicks = 500;
                if (this.mNotes[this.mNoteActualIndex - 1] > this.mNotes[this.mNoteActualIndex]) {
                    if (this.mNoteActualIndex > 0) {
                        this.mNotesAnswer[this.mNoteActualIndex - 1] = 0;
                    }
                    this.mNotesAnswer[this.mNoteActualIndex] = 1;
                    ++this.mNoteActualIndex;
                    this.registerParticle(n3, n4, this.mNoteIndex <= this.mNoteActualIndex);
                    if (this.mNoteIndex > this.mNoteActualIndex) {
                        return 2;
                    }
                    this.mDrawButtons = false;
                    this.mDrawWatchIcon = true;
                    return 0;
                }
                this.mNotesAnswer[this.mNoteActualIndex] = 2;
                this.mNoteCorrect = false;
                ++this.mNoteActualIndex;
                if (this.mNumNotes > 4) {
                    --this.mNumNotes;
                }
                return 1;
            }
            if (n2 == 54 || n == 54) {
                this.pressButton(1, this.mNotes[this.mNoteActualIndex - 1] < this.mNotes[this.mNoteActualIndex], true);
                this.mHudConfirmationTicks = 500;
                if (this.mNotes[this.mNoteActualIndex - 1] < this.mNotes[this.mNoteActualIndex]) {
                    if (this.mNoteActualIndex > 0) {
                        this.mNotesAnswer[this.mNoteActualIndex - 1] = 0;
                    }
                    this.mNotesAnswer[this.mNoteActualIndex] = 1;
                    ++this.mNoteActualIndex;
                    this.registerParticle(n3, n4, this.mNoteIndex <= this.mNoteActualIndex);
                    if (this.mNoteIndex > this.mNoteActualIndex) {
                        return 2;
                    }
                    this.mDrawButtons = false;
                    this.mDrawWatchIcon = true;
                    return 0;
                }
                this.mNoteCorrect = false;
                this.mNotesAnswer[this.mNoteActualIndex] = 2;
                ++this.mNoteActualIndex;
                return 1;
            }
        }
        return 3;
    }

    protected boolean checkAnswer(int n) {
        this.mSpritesPool[0].logicUpdate(n);
        this.mSpritesPool[1].logicUpdate(n);
        this.mSpritesPool[2].logicUpdate(n);
        if (!(this.mTicks[this.mGameMode] < 200 || this.mNoteCorrect && this.mNoteIndex < this.mNumNotes)) {
            if (this.mNoteCorrect && this.mNumNotes < 7) {
                ++this.mNumNotes;
            }
            this.initNotes();
            return true;
        }
        return false;
    }
}

