/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class MiniMaze
extends MiniGame {
    private static final int CELL_TREE = -4;
    private static final int CELL_OUT = -3;
    private static final int CELL_WALL = -2;
    private static final int CELL_VOID = -1;
    private static final int CELL_EMPTY = 0;
    private static final int CELL_1_NUT = 2;
    private static final int CELL_2_NUT = 4;
    private static final int CELL_HONEY = 5;
    private static final int CELL_EXIT = 6;
    private static final int CELL_TRAP = 7;
    private static final int CELL_WALKED = 8;
    private static final int MAX_NUT_SEGMENTS = 5;
    private static final int MAX_NUT_LENGTH = 12;
    private static final int MAX_HUNGRY_BEAR_HONEY_STEPS = 3;
    private static final int MAX_HUNGRY_BEAR_LENGTH = 9;
    private static final int MIN_PLANT_TREES_LENGTH = 10;
    private static final int MAX_PLANT_TREES_LENGTH = 20;
    private static final int SPRITES_MAP = 0;
    private static final int SPRITES_PLAYER = 2;
    private static final int SPRITES_ITEMS_A = 3;
    private static final int SPRITES_ITEMS_B = 4;
    private static final int SPRITES_EXIT = 5;
    private static final int SPRITES_PLAYER_STEPS = 6;
    private static final int WATCH_TIME = 1000;
    private int[] mMaze;
    private int mMazePosX;
    private int mMazePosY;
    private int mMazeSize;
    private int mMazeTiles;
    private int mTileSize;
    private int mPlayerTile;
    private int mInitX;
    private int mInitY;
    private int mExitX;
    private int mExitY;
    private boolean mMoving;
    private int mWatchTime = 1000;
    private int mCellMin;
    private int mCellMax;
    private int mTreesPlanted;

    public MiniMaze(int n, int n2) {
        if (mMiniGameID == 22) {
            this.mBackground = new SpriteObject(SpriteObject.loadAnimation(786443), false);
            this.mSpritesPool = new SpriteObject[7];
            this.mSpritesPool[0] = new SpriteObject(SpriteObject.loadAnimation(131172), false);
            this.mSpritesPool[2] = new SpriteObject(SpriteObject.loadAnimations(new int[]{131182, 131175}), true);
            this.mSpritesPool[5] = new SpriteObject(SpriteObject.loadAnimation(131184), false);
            this.mSpritesPool[3] = new SpriteObject(SpriteObject.loadAnimation(131178), true);
            this.mCellMin = 1;
            this.mCellMax = 6;
            this.mMazeTiles = 7;
        } else if (mMiniGameID == 9) {
            this.mBackground = new SpriteObject(SpriteObject.loadAnimation(720901), false);
            this.mSpritesPool = new SpriteObject[7];
            this.mSpritesPool[0] = new SpriteObject(SpriteObject.loadAnimation(131146), false);
            this.mSpritesPool[2] = new SpriteObject(SpriteObject.loadAnimations(new int[]{131150, 131154}), true);
            this.mSpritesPool[6] = new SpriteObject(SpriteObject.loadAnimation(131157), false);
            this.mSpritesPool[3] = new SpriteObject(SpriteObject.loadAnimation(131145), true);
            this.mSpritesPool[4] = new SpriteObject(SpriteObject.loadAnimation(131156), true);
            this.mCellMin = 0;
            this.mCellMax = 5;
            this.mMazeTiles = 5;
        } else if (mMiniGameID == 20) {
            this.mBackground = new SpriteObject(SpriteObject.loadAnimation(720907), false);
            this.mSpritesPool = new SpriteObject[27];
            this.mSpritesPool[0] = new SpriteObject(SpriteObject.loadAnimation(131143), false);
            this.mSpritesPool[2] = new SpriteObject(SpriteObject.loadAnimations(new int[]{131137, 131137}), true);
            this.mSpritesPool[5] = new SpriteObject(SpriteObject.loadAnimation(131133), false);
            this.mSpritesPool[3] = new SpriteObject(SpriteObject.loadAnimation(131131), true);
            for (int i = 0; i < 20; ++i) {
                this.mSpritesPool[6 + i] = new SpriteObject(SpriteObject.loadAnimation(131142), false);
            }
            this.mCellMin = 1;
            this.mCellMax = 6;
            this.mMazeTiles = 7;
        }
        this.initialize(n, n2);
        this.mMaze = new int[this.mMazeTiles * this.mMazeTiles];
        this.resetMap();
        this.mTileSize = 26;
        this.mMazeSize = this.mMazeTiles * this.mTileSize;
        this.mMazePosX = this.mCanvasWidth - this.mMazeSize >> 1;
        this.mMazePosY = this.mCanvasHeight - this.mMazeSize >> 1;
        this.mPlayerTile = 0;
    }

    protected void initNextQuestion() {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = this.mDifficulty / 3;
        this.mMoving = false;
        this.mSpritesPool[2].setAnimation(0, -1, false);
        for (n = 0; n < 1800; ++n) {
            this.resetMap();
            if (mMiniGameID == 9) {
                this.generateHungryBearMap();
                bl = false;
            } else if (mMiniGameID == 20) {
                n2 = this.generatePlantTreesMap();
            } else if (mMiniGameID == 22) {
                this.generateNutEaterMap();
            }
            if (this.isMapValid(n2)) break;
        }
        this.mPlayerTile = this.mInitX + this.mInitY * this.mMazeTiles;
        if (bl) {
            this.mMaze[this.mExitX + this.mExitY * this.mMazeTiles] = 6;
        }
        for (n = 0; n < this.mMaze.length; ++n) {
            if (mMiniGameID == 9) {
                if (n3 > 0 && this.mMaze[n] == 0 && n != this.mPlayerTile && MiniMaze.rnd(200) > 150 - n3 * 10) {
                    this.mMaze[n] = 7;
                    --n3;
                }
            } else if (mMiniGameID == 20 && this.mMaze[n] == 0) {
                this.mMaze[n] = -2;
            }
            if (this.mMaze[n] < 8) continue;
            this.mMaze[n] = 0;
        }
        if (mMiniGameID == 20) {
            for (n = 0; n < 20; ++n) {
                this.mSpritesPool[6 + n].setAnimationFrame(0);
            }
        }
    }

    protected void updateGame(int n) {
        this.mSpritesPool[2].logicUpdate(n);
        if (mMiniGameID == 9) {
            this.mSpritesPool[3].logicUpdate(n);
            if (this.mState[this.mGameMode] == 3) {
                this.mDrawWatchIcon = true;
            }
        } else if (mMiniGameID == 20) {
            int n2 = this.mPlayerTile % this.mMazeTiles;
            int n3 = this.mPlayerTile / this.mMazeTiles;
            if (this.getCell(n2 - 1, n3) < 0 && this.getCell(n2, n3 - 1) < 0 && this.getCell(n2 + 1, n3) < 0 && this.getCell(n2, n3 + 1) < 0) {
                this.setHudConfirmation();
                this.mForceFailure = true;
            }
            for (int i = 0; i < this.mTreesPlanted; ++i) {
                this.mSpritesPool[6 + i].logicUpdate(n);
            }
        }
        if (this.mMoving && this.mSpritesPool[2].isFinishedAnimation()) {
            this.mMoving = false;
            this.mSpritesPool[2].setAnimation(0, -1, false);
        }
    }

    protected void drawGame(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.mSpritesPool[0].draw(graphics, this.mCanvasX + this.mMazePosX, this.mCanvasY + this.mMazePosY);
        block11: for (n = 0; n < this.mMaze.length; ++n) {
            n2 = this.mCanvasX + this.mMazePosX + n % this.mMazeTiles * this.mTileSize + (this.mTileSize >> 1);
            n3 = this.mCanvasY + this.mMazePosY + n / this.mMazeTiles * this.mTileSize + (this.mTileSize >> 1);
            switch (this.mMaze[n]) {
                case -3: {
                    continue block11;
                }
                case -2: {
                    this.mSpritesPool[3].draw(graphics, n2, n3);
                    continue block11;
                }
                case -1: 
                case 0: {
                    continue block11;
                }
                case 2: {
                    this.mSpritesPool[3].setAnimationFrame(0);
                    this.mSpritesPool[3].draw(graphics, n2, n3);
                    continue block11;
                }
                case 4: {
                    this.mSpritesPool[3].setAnimationFrame(1);
                    this.mSpritesPool[3].draw(graphics, n2, n3);
                    continue block11;
                }
                case 5: {
                    if (this.mState[this.mGameMode] != 3) continue block11;
                    this.mSpritesPool[3].draw(graphics, n2, n3);
                    continue block11;
                }
                case 6: {
                    this.mSpritesPool[5].draw(graphics, n2, n3);
                    continue block11;
                }
                case 8: {
                    this.mSpritesPool[6].draw(graphics, n2, n3);
                    continue block11;
                }
                case 7: {
                    if (this.mState[this.mGameMode] != 3) continue block11;
                    this.mSpritesPool[4].draw(graphics, n2, n3);
                    continue block11;
                }
                default: {
                    if (this.mMaze[n] > -4 || this.mSpritesPool[6 - this.mMaze[n] + -4] == null) continue block11;
                    this.mSpritesPool[6 - this.mMaze[n] + -4].draw(graphics, n2, n3);
                }
            }
        }
        if (this.mState[this.mGameMode] != 3) {
            n2 = this.mPlayerTile % this.mMazeTiles;
            n3 = this.mPlayerTile / this.mMazeTiles;
            this.mSpritesPool[2].draw(graphics, this.mCanvasX + this.mMazePosX + n2 * this.mTileSize + (this.mTileSize >> 1), this.mCanvasY + this.mMazePosY + n3 * this.mTileSize + (this.mTileSize >> 1));
        }
    }

    protected boolean updateWatch(int n) {
        if (mMiniGameID == 9) {
            this.mWatchTime -= n;
            if (this.mWatchTime <= 0) {
                this.mWatchTime = 1000;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    protected int isCorrectAnswer(int n) {
        if (n != 0) {
            int n2 = Toolkit.getToolkitGameAction(n);
            int n3 = this.mPlayerTile;
            if (n2 == 52 || n == 52) {
                this.moveLeft();
            } else if (n2 == 50 || n == 50) {
                this.moveUp();
            } else if (n2 == 54 || n == 54) {
                this.moveRight();
            } else if (n2 == 56 || n == 56) {
                this.moveDown();
            } else {
                return 3;
            }
            if (this.mMoving) {
                boolean bl = false;
                if (this.mMaze[this.mPlayerTile] == 6) {
                    bl = true;
                }
                if (mMiniGameID == 9) {
                    this.mMaze[n3] = 8;
                } else if (mMiniGameID == 20) {
                    if (this.mMaze[n3] == 0) {
                        this.mMaze[n3] = -4 - this.mTreesPlanted;
                        ++this.mTreesPlanted;
                    }
                } else if (mMiniGameID == 22 && this.mMaze[this.mPlayerTile] == 0) {
                    bl = true;
                }
                if (bl) {
                    this.setHudConfirmation();
                    if (this.isMapSolved()) {
                        this.registerParticle(this.mHudConfirmationPosX, this.mHudConfirmationPosY, true);
                        return 0;
                    }
                    return 1;
                }
                if (this.endMove() > 0) {
                    if (mMiniGameID == 9) {
                        this.setHudConfirmation();
                        this.registerParticle(this.mHudConfirmationPosX, this.mHudConfirmationPosY, true);
                        if (this.isMapSolved()) {
                            return 0;
                        }
                    }
                    return 2;
                }
                if (this.mMaze[this.mPlayerTile] == 7) {
                    this.setHudConfirmation();
                    return 1;
                }
                if (mMiniGameID == 20) {
                    return 2;
                }
            } else if (this.mSpritesPool[2].getCurrentAnimationIndex() != 0) {
                this.mSpritesPool[2].setAnimation(0, -1, false);
            }
        }
        return 3;
    }

    protected boolean checkAnswer(int n) {
        if (mMiniGameID == 20) {
            for (int i = 0; i < this.mTreesPlanted; ++i) {
                this.mSpritesPool[6 + i].logicUpdate(n);
            }
        }
        return this.mHudConfirmationTicks <= 0;
    }

    private void moveLeft() {
        this.mMoving = false;
        if (this.mPlayerTile % this.mMazeTiles != 0 && this.canMove(this.mPlayerTile - 1)) {
            --this.mPlayerTile;
            this.mMoving = true;
        }
    }

    private void moveUp() {
        this.mMoving = false;
        if (this.mPlayerTile / this.mMazeTiles != 0 && this.canMove(this.mPlayerTile - this.mMazeTiles)) {
            this.mPlayerTile -= this.mMazeTiles;
            this.mMoving = true;
        }
    }

    private void moveRight() {
        this.mMoving = false;
        if (this.mPlayerTile % this.mMazeTiles != this.mMazeTiles - 1 && this.canMove(this.mPlayerTile + 1)) {
            ++this.mPlayerTile;
            this.mMoving = true;
        }
    }

    private void moveDown() {
        this.mMoving = false;
        if (this.mPlayerTile / this.mMazeTiles != this.mMazeTiles - 1 && this.canMove(this.mPlayerTile + this.mMazeTiles)) {
            this.mPlayerTile += this.mMazeTiles;
            this.mMoving = true;
        }
    }

    private boolean canMove(int n) {
        return n < 0 || n >= this.mMaze.length || this.mMaze[n] > -1;
    }

    private int endMove() {
        switch (this.mMaze[this.mPlayerTile]) {
            case 2: {
                this.mSpritesPool[2].setAnimation(1, 2, false);
                this.mMaze[this.mPlayerTile] = 0;
                return 2;
            }
            case 4: {
                this.mSpritesPool[2].setAnimation(1, 2, false);
                this.mMaze[this.mPlayerTile] = 2;
                return 4;
            }
            case 5: {
                this.mSpritesPool[2].setAnimation(1, 2, false);
                this.mMaze[this.mPlayerTile] = 0;
                return 5;
            }
        }
        this.mMoving = false;
        return 0;
    }

    private void resetMap() {
        int n = 0;
        this.mTreesPlanted = 0;
        this.mPlayerTile = 0;
        this.mInitX = 0;
        this.mInitY = 0;
        this.mExitX = 0;
        this.mExitY = 0;
        for (n = 0; n < this.mMaze.length; ++n) {
            this.mMaze[n] = 0;
            if (mMiniGameID == 9 || n / this.mMazeTiles != 0 && n / this.mMazeTiles != this.mMazeTiles - 1 && n % this.mMazeTiles != 0 && n % this.mMazeTiles != this.mMazeTiles - 1) continue;
            this.mMaze[n] = -3;
        }
    }

    private void generateNutEaterMap() {
        boolean bl = false;
        int n = MiniMaze.rnd(20);
        int n2 = 0;
        int n3 = 0;
        int n4 = MiniMaze.rnd(4);
        int n5 = 0;
        int n6 = 0;
        if (n < 5) {
            this.mInitY = 0;
            this.mInitX = 1 + n;
        } else if (n < 10) {
            this.mInitY = 6;
            this.mInitX = 1 + n - 5;
        } else if (n < 15) {
            this.mInitX = 0;
            this.mInitY = 1 + n - 10;
        } else if (n < 20) {
            this.mInitX = 6;
            this.mInitY = 1 + n - 15;
        }
        int n7 = this.mInitX;
        int n8 = this.mInitY;
        while (!bl) {
            int n9;
            int n10;
            n5 = 1 + MiniMaze.rnd(5);
            n6 = -1;
            while (n6 == -1) {
                if (n3 >= 5 && n2 > 12) {
                    n6 = n4;
                    n5 = 5;
                    continue;
                }
                n6 = MiniMaze.rnd(4);
                n10 = 0;
                switch (n6) {
                    case 0: {
                        n10 = this.getCell(n7, n8 - 1) >> 1;
                        break;
                    }
                    case 1: {
                        n10 = this.getCell(n7 + 1, n8) >> 1;
                        break;
                    }
                    case 2: {
                        n10 = this.getCell(n7, n8 + 1) >> 1;
                        break;
                    }
                    case 3: {
                        n10 = this.getCell(n7 - 1, n8) >> 1;
                    }
                }
                for (n9 = 0; n9 < n10; ++n9) {
                    if (MiniMaze.rnd(2) != 0) continue;
                    n6 = -1;
                }
                if (n6 != n4) continue;
                n6 = -1;
            }
            ++n3;
            for (n10 = 0; n10 < n5 && !bl; ++n10) {
                n9 = n7++;
                int n11 = n8--;
                switch (n6) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        ++n8;
                        break;
                    }
                    case 3: {
                        --n7;
                    }
                }
                if (n7 >= 1 && n7 < 6 && n8 >= 1 && n8 < 6) {
                    int n12 = n7 + n8 * this.mMazeTiles;
                    this.mMaze[n12] = this.mMaze[n12] + 2;
                    ++n2;
                    continue;
                }
                if (n2 > 12) {
                    this.mExitX = n7;
                    this.mExitY = n8;
                    bl = true;
                    continue;
                }
                n7 = n9;
                n8 = n11;
            }
            n4 = n6;
        }
    }

    private void generateHungryBearMap() {
        boolean bl = false;
        this.mInitX = MiniMaze.rnd(5);
        this.mInitY = MiniMaze.rnd(5);
        int n = this.mInitX;
        int n2 = this.mInitY;
        int n3 = 0;
        int n4 = MiniMaze.rnd(4);
        while (!bl) {
            int n5 = 1 + MiniMaze.rnd(5);
            int n6 = -1;
            while ((n6 = MiniMaze.rnd(4)) == n4) {
            }
            for (int i = 0; i < n5 && !bl; ++i) {
                int n7 = n++;
                int n8 = n2--;
                switch (n6) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        ++n2;
                        break;
                    }
                    case 3: {
                        --n;
                    }
                }
                if (n >= 0 && n < 5 && n2 >= 0 && n2 < 5) {
                    if (this.mMaze[n + n2 * this.mMazeTiles] == 0) {
                        this.mMaze[n + n2 * this.mMazeTiles] = 8;
                        if (++n3 % 3 == 0) {
                            this.mMaze[n + n2 * this.mMazeTiles] = 5;
                        }
                        if (n3 <= 9) continue;
                        bl = true;
                        continue;
                    }
                    if (this.getCell(n + 1, n2) != 0 && this.getCell(n, n2 + 1) != 0 && this.getCell(n - 1, n2) != 0 && this.getCell(n, n2 - 1) != 0) {
                        bl = true;
                        continue;
                    }
                    n = n7;
                    n2 = n8;
                    n5 = 0;
                    continue;
                }
                n = n7;
                n2 = n8;
                n5 = 0;
            }
            n4 = n6;
        }
    }

    private int generatePlantTreesMap() {
        boolean bl = false;
        int n = MiniMaze.rnd(20);
        int n2 = 0;
        int n3 = 0;
        if (n < 5) {
            this.mInitY = 0;
            this.mInitX = 1 + n;
        } else if (n < 10) {
            this.mInitY = 6;
            this.mInitX = 1 + n - 5;
        } else if (n < 15) {
            this.mInitX = 0;
            this.mInitY = 1 + n - 10;
        } else if (n < 20) {
            this.mInitX = 6;
            this.mInitY = 1 + n - 15;
        }
        int n4 = this.mInitX;
        int n5 = this.mInitY;
        while (!bl) {
            int n6 = n4++;
            int n7 = n5--;
            n3 = MiniMaze.rnd(4);
            switch (n3) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    ++n5;
                    break;
                }
                case 3: {
                    --n4;
                }
            }
            if (n4 < 1 || n4 > 5 || n5 < 1 || n5 > 5) {
                if (n2 < 10) {
                    this.mExitX = n4;
                    this.mExitY = n5;
                    n4 = n6;
                    n5 = n7;
                    bl = this.getCell(n4 - 1, n5) != 0 && this.getCell(n4, n5 - 1) != 0 && this.getCell(n4 + 1, n5) != 0 && this.getCell(n4, n5 + 1) != 0;
                    if (bl) continue;
                    this.mExitX = -1;
                    this.mExitY = -1;
                    continue;
                }
                bl = true;
                this.mExitX = n4;
                this.mExitY = n5;
                continue;
            }
            if (this.mMaze[n4 + n5 * this.mMazeTiles] != 0) {
                n4 = n6;
                n5 = n7;
                continue;
            }
            int n8 = 0;
            switch (n4) {
                case 1: 
                case 5: {
                    n8 += 30;
                    break;
                }
                case 2: 
                case 4: {
                    n8 += 20;
                }
            }
            switch (n5) {
                case 1: 
                case 5: {
                    n8 += 30;
                    break;
                }
                case 2: 
                case 4: {
                    n8 += 20;
                }
            }
            if (MiniMaze.rnd(100) < n8) {
                n4 = n6;
                n5 = n7;
                continue;
            }
            this.mMaze[n4 + n5 * this.mMazeTiles] = 8;
            ++n2;
            bl = this.getCell(n4 - 1, n5) == 8 && this.getCell(n4, n5 - 1) == 8 && this.getCell(n4 + 1, n5) == 8 && this.getCell(n4, n5 + 1) == 8;
        }
        return n2;
    }

    private int getCell(int n, int n2) {
        int n3 = n + n2 * this.mMazeTiles;
        if (this.mExitX == n && this.mExitY == n2) {
            return 6;
        }
        if (n >= this.mCellMin && n < this.mCellMax && n2 >= this.mCellMin && n2 < this.mCellMax) {
            return this.mMaze[n3];
        }
        return -1;
    }

    private boolean isMapValid(int n) {
        int n2 = 0;
        if (this.mInitX == this.mExitX && this.mInitY == this.mExitY || this.mExitX < 0 || this.mExitY < 0) {
            return false;
        }
        if (mMiniGameID == 22) {
            for (int i = 0; i < this.mMaze.length; ++i) {
                if (this.mMaze[i] > 4) {
                    return false;
                }
                if (this.mMaze[i] != 4) continue;
                ++n2;
            }
            if (this.mDifficulty < 2) {
                return n2 == 0;
            }
            if (this.mDifficulty < 4) {
                return n2 > 0 && n2 < 4;
            }
            return n2 > 3;
        }
        if (mMiniGameID == 9 ? this.mMaze[this.mInitX + this.mInitY * this.mMazeTiles] != 0 : n < 10 || n > 20) {
            return false;
        }
        n2 = 0;
        for (int i = 0; i < this.mMaze.length; ++i) {
            int n3 = i + 1;
            if (this.mMaze[i] < 0) {
                n3 = 100;
            }
            n2 += (Math.abs(this.mMaze[i]) + 1) * n3;
        }
        if (this.isPreviouslyAnswered(n2)) {
            return false;
        }
        this.mLastQuestions[this.mLastQuestionsIndex] = n2;
        this.mLastQuestionsIndex = (this.mLastQuestionsIndex + 1) % this.mLastQuestions.length;
        return true;
    }

    private boolean isMapSolved() {
        if (mMiniGameID == 22 && this.mMaze[this.mPlayerTile] != 6) {
            return false;
        }
        for (int i = 0; i < this.mMaze.length; ++i) {
            if (!(mMiniGameID == 22 ? this.mMaze[i] >= 2 && this.mMaze[i] < 6 : (mMiniGameID == 20 ? this.mMaze[i] == 0 : this.mMaze[i] == 5))) continue;
            return false;
        }
        return true;
    }

    private void setHudConfirmation() {
        this.mHudConfirmationTicks = 1000;
        this.mHudConfirmationPosX = this.mCanvasX + this.mMazePosX + this.mPlayerTile % this.mMazeTiles * this.mTileSize + (this.mTileSize >> 1);
        this.mHudConfirmationPosY = this.mCanvasY + this.mMazePosY + this.mPlayerTile / this.mMazeTiles * this.mTileSize + (this.mTileSize >> 1);
    }
}

