/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class MiniBird
extends MiniGame {
    private static final int BIRD_RIGHT = 0;
    private static final int BIRD_LEFT = 1;
    private static final int PAIR_WHEELS = 0;
    private static final int UNPAIR_WHEELS = 1;
    private static final int MOVE_RIGHT = 0;
    private static final int MOVE_LEFT = 1;
    private static final int SPRITE_BIRD = 0;
    private static final int SPRITE_FEED = 1;
    private static final int SPRITE_RED_GEAR = 2;
    private static final int SPRITE_BLACK_GEAR = 3;
    private static final int SPRITE_SMALL_GEAR = 4;
    private static final int MAX_WHEELS = 8;
    private static final int MIN_WHEELS = 3;
    private int mNumWheels;
    private int mBirdPos;
    private int mGateAnswer;
    private int[] mWheelX = new int[10];
    private int[] mWheelY = new int[10];
    private int mWheelMoving;
    private int mMinWheels;
    private int mMaxWheels;
    private int[] mBirdPosX = new int[]{0, 0};
    private int[] mBirdPosY = new int[]{0, 0};
    private int[] mWheelsFrames = new int[]{1, 0, 1, 0, 1, 0};
    private int mLastFrame;
    private int mNumCorrects;
    private int mWaitCheck;
    private boolean mIsCorrectAnswer;

    public MiniBird(int n, int n2) {
        this.mBackground = new SpriteObject(SpriteObject.loadAnimation(655452), false);
        this.initialize(n, n2);
        this.createButtons(SpriteObject.loadAnimations(new int[]{917529, 589867, 589874}), SpriteObject.loadAnimations(new int[]{655444, 589869, 589870}));
        this.mSpritesPool = new SpriteObject[5];
        this.mSpritesPool[0] = new SpriteObject(SpriteObject.loadAnimations(new int[]{458837, 589828, 458839, 589836}), true);
        this.mSpritesPool[1] = new SpriteObject(SpriteObject.loadAnimations(new int[]{458832, 589838}), true);
        this.mSpritesPool[2] = new SpriteObject(SpriteObject.loadAnimations(new int[]{458831, 589832}), true);
        this.mSpritesPool[4] = new SpriteObject(SpriteObject.loadAnimation(458836), true);
        this.mSpritesPool[3] = new SpriteObject(SpriteObject.loadAnimations(new int[]{458838, 589842}), true);
        this.mSpritesPool[0].setAnimation(0, -1, true);
        this.mMinWheels = 3;
        this.mMaxWheels = 6;
        this.mLastFrame = this.mSpritesPool[3].getCurrentFrameIndex();
    }

    protected boolean checkAnswer(int n) {
        this.mSpritesPool[2].logicUpdate(n);
        this.mSpritesPool[3].logicUpdate(n);
        if (!this.mSpritesPool[3].isFinishedAnimation()) {
            if (this.mLastFrame != this.mSpritesPool[3].getCurrentFrameIndex()) {
                if (this.mWheelMoving == 1) {
                    for (int i = 0; i < this.mNumWheels - 2; ++i) {
                        int n2 = i;
                        this.mWheelsFrames[n2] = this.mWheelsFrames[n2] - 1;
                        if (this.mWheelsFrames[i] >= 0) continue;
                        this.mWheelsFrames[i] = this.mSpritesPool[4].getFrameCount() - 1;
                    }
                } else {
                    for (int i = 0; i < this.mNumWheels - 2; ++i) {
                        int n3 = i;
                        this.mWheelsFrames[n3] = this.mWheelsFrames[n3] + 1;
                        if (this.mWheelsFrames[i] < this.mSpritesPool[4].getFrameCount()) continue;
                        this.mWheelsFrames[i] = 0;
                    }
                }
                this.mLastFrame = this.mSpritesPool[3].getCurrentFrameIndex();
            }
            this.mWaitCheck = 0;
        } else {
            if (this.mIsCorrectAnswer) {
                if (this.mWaitCheck == 0) {
                    int n4 = this.mSpritesPool[0].getCurrentAnimationIndex() + 2;
                    this.mSpritesPool[0].setAnimation(n4, -1, true);
                }
                if (this.mBirdPos == 0) {
                    this.mBirdPosX[0] = this.mBirdPosX[1] + this.mSpritesPool[0].getPivotX();
                } else {
                    this.mBirdPosX[1] = this.mBirdPosX[0] - this.mSpritesPool[0].getPivotX();
                }
            } else if (this.mBirdPos == 0) {
                this.mBirdPosX[0] = this.mBirdPosX[0] + this.mSpritesPool[0].getWidth();
            } else {
                this.mBirdPosX[1] = this.mBirdPosX[1] - this.mSpritesPool[0].getWidth();
            }
            this.mSpritesPool[0].logicUpdate(n);
            this.mSpritesPool[1].logicUpdate(n);
            this.mWaitCheck += n;
        }
        return this.mWaitCheck >= 500;
    }

    protected void drawGame(Graphics graphics) {
        this.mSpritesPool[2].draw(graphics, this.mWheelX[0], this.mWheelY[0]);
        for (int i = 1; i < this.mNumWheels - 1; ++i) {
            this.mSpritesPool[4].setAnimationFrame(this.mWheelsFrames[i - 1]);
            this.mSpritesPool[4].draw(graphics, this.mWheelX[i], this.mWheelY[i]);
        }
        this.mSpritesPool[3].draw(graphics, this.mWheelX[this.mNumWheels - 1], this.mWheelY[this.mNumWheels - 1]);
        if (this.mBirdPos == 0) {
            this.mSpritesPool[0].draw(graphics, this.mBirdPosX[0], this.mBirdPosY[0]);
            this.mSpritesPool[1].draw(graphics, this.mBirdPosX[1], this.mBirdPosY[1]);
        } else {
            this.mSpritesPool[0].draw(graphics, this.mBirdPosX[1], this.mBirdPosY[1]);
            this.mSpritesPool[1].draw(graphics, this.mBirdPosX[0], this.mBirdPosY[0]);
        }
    }

    protected void initNextQuestion() {
        int n;
        int n2;
        ++this.mNumCorrects;
        if (this.mNumCorrects > 4) {
            this.mNumCorrects = 0;
            if (this.mMaxWheels < 8) {
                ++this.mMinWheels;
                ++this.mMaxWheels;
            }
        }
        this.mNumWheels = MiniBird.rnd(this.mMaxWheels - this.mMinWheels + 1) + this.mMinWheels;
        this.mBirdPos = 1;
        if (MiniBird.rnd(100) < 50) {
            this.mBirdPos = 0;
        }
        this.mSpritesPool[0].setAnimation(this.mBirdPos, -1, true);
        this.mSpritesPool[1].setAnimationFrame(0);
        int n3 = this.mSpritesPool[0].getWidth();
        boolean bl = false;
        int n4 = 0;
        while (!bl) {
            int n5;
            int n6;
            for (n4 = 0; n4 < 10; ++n4) {
                this.mWheelX[n4] = -1;
                this.mWheelY[n4] = -1;
            }
            this.mWheelX[0] = 0;
            this.mWheelY[0] = 0;
            int n7 = 2;
            n2 = 0;
            n = 0;
            int n8 = 0;
            int n9 = -1;
            int n10 = this.mSpritesPool[4].getWidth();
            int n11 = this.mSpritesPool[2].getWidth() - (this.mSpritesPool[2].getWidth() - this.mSpritesPool[4].getWidth());
            for (n4 = 1; n4 < this.mNumWheels; ++n4) {
                n6 = n10;
                if (n4 == 1) {
                    n6 = n11;
                }
                n5 = n6 * GameEngine.trigon_cos(32) >> 10;
                n9 = -1;
                while (n9 == -1) {
                    n9 = n7 - 1 + MiniBird.rnd(3);
                    if (n9 == 0 || n9 == 5) {
                        n9 = -1;
                    }
                    if (n9 == 1) {
                        n9 = -1;
                    }
                    if (n4 != this.mNumWheels - 1 && n4 != 1 || n9 != 1) continue;
                    n9 = -1;
                }
                n7 = n9;
                switch (n9) {
                    case 1: {
                        this.mWheelX[n4] = this.mWheelX[n4 - 1] + n5;
                        this.mWheelY[n4] = this.mWheelY[n4 - 1] - n5;
                        break;
                    }
                    case 2: {
                        this.mWheelX[n4] = this.mWheelX[n4 - 1] + n6;
                        this.mWheelY[n4] = this.mWheelY[n4 - 1];
                        break;
                    }
                    case 3: {
                        this.mWheelX[n4] = this.mWheelX[n4 - 1] + n5;
                        this.mWheelY[n4] = this.mWheelY[n4 - 1] + n5;
                        break;
                    }
                    case 4: {
                        this.mWheelX[n4] = this.mWheelX[n4 - 1];
                        this.mWheelY[n4] = this.mWheelY[n4 - 1] + n6;
                    }
                }
                if (n2 < this.mWheelX[n4]) {
                    n2 = this.mWheelX[n4];
                }
                if (n8 < this.mWheelY[n4]) {
                    n8 = this.mWheelY[n4];
                }
                if (n <= this.mWheelY[n4]) continue;
                n = this.mWheelY[n4];
            }
            if (n2 + n3 >= this.mCanvasWidth || n8 - n + n3 >= this.mCanvasHeight) continue;
            bl = true;
            n6 = this.mCanvasX - (n2 >> 1) + (this.mCanvasWidth >> 1);
            n5 = this.mCanvasY - (n8 - n >> 1) + (this.mCanvasHeight >> 1);
            n4 = 0;
            while (n4 < this.mNumWheels) {
                int n12 = n4;
                this.mWheelX[n12] = this.mWheelX[n12] + n6;
                int n13 = n4++;
                this.mWheelY[n13] = this.mWheelY[n13] + n5;
            }
        }
        this.mSpritesPool[2].setAnimation(0, 1, true);
        this.mSpritesPool[3].setAnimation(0, 1, true);
        short[] sArray = this.mSpritesPool[3].getCurrentAnimationData();
        n2 = this.mSpritesPool[3].getCollisionBoxes();
        n2 += 2;
        for (n = 0; n < 2; ++n) {
            this.mBirdPosX[n] = sArray[n2++] + this.mWheelX[this.mNumWheels - 1];
            this.mBirdPosY[n] = sArray[n2++] + this.mWheelY[this.mNumWheels - 1];
            n2 += 3;
        }
        for (n = 0; n < 6; ++n) {
            this.mWheelsFrames[n] = 0;
            if (n % 2 != 0) continue;
            this.mWheelsFrames[n] = 1;
        }
        this.mGateAnswer = this.mNumWheels % 2;
    }

    protected int isCorrectAnswer(int n) {
        if (n != 0) {
            int n2 = Toolkit.getToolkitGameAction(n);
            if (n2 == 52 || n == 52) {
                this.mHudConfirmationPosX = this.mWheelX[this.mNumWheels - 1];
                this.mHudConfirmationPosY = this.mWheelY[this.mNumWheels - 1];
                boolean bl = this.mBirdPos == 1 && this.mGateAnswer == 1 || this.mBirdPos == 0 && this.mGateAnswer == 0;
                this.pressButton(0, bl, true);
                if (this.mGateAnswer == 0) {
                    this.mSpritesPool[3].setAnimation(1, 1, true);
                }
                this.mWheelMoving = 1;
                if (bl) {
                    ++this.mNumCorrects;
                    this.mIsCorrectAnswer = true;
                    this.registerParticle(this.mHudConfirmationPosX, this.mHudConfirmationPosY);
                    return 0;
                }
                this.mNumCorrects = 0;
                if (this.mMinWheels > 3) {
                    --this.mMaxWheels;
                    --this.mMinWheels;
                }
                this.mIsCorrectAnswer = false;
                return 1;
            }
            if (n2 == 54 || n == 54) {
                boolean bl = this.mBirdPos == 1 && this.mGateAnswer == 0 || this.mBirdPos == 0 && this.mGateAnswer == 1;
                this.pressButton(1, bl, true);
                this.mHudConfirmationPosX = this.mWheelX[this.mNumWheels - 1];
                this.mHudConfirmationPosY = this.mWheelY[this.mNumWheels - 1];
                this.mWheelMoving = 0;
                this.mSpritesPool[2].setAnimation(1, 1, true);
                if (this.mGateAnswer == 1) {
                    this.mSpritesPool[3].setAnimation(1, 1, true);
                }
                if (bl) {
                    ++this.mNumCorrects;
                    this.mIsCorrectAnswer = true;
                    this.registerParticle(this.mHudConfirmationPosX, this.mHudConfirmationPosY);
                    return 0;
                }
                this.mNumCorrects = 0;
                if (this.mMinWheels > 3) {
                    --this.mMaxWheels;
                    --this.mMinWheels;
                }
                this.mIsCorrectAnswer = false;
                return 1;
            }
        }
        return 3;
    }

    protected void updateGame(int n) {
        this.mSpritesPool[0].logicUpdate(n);
    }
}

