/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SpriteObject {
    public static final boolean USE_ENVIRONMENT = true;
    public static final int TYPE_ANIMATION = 0;
    public static final int TYPE_SPRITE = 1;
    public static final int RENDERABLE_TYPE_IMAGE = 0;
    public static final int RENDERABLE_TYPE_FILLEDRECT = 1;
    public static final int RENDERABLE_TYPE_RECT = 2;
    public static final int RENDERABLE_TYPE_LINE = 3;
    public static final int RENDERABLE_TYPE_FILLEDCIRCLE = 4;
    public static final int RENDERABLE_TYPE_FILLEDTRIANGLE = 5;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int WIDTH = 2;
    public static final int HEIGHT = 3;
    public static final int FRAMECOUNT = 4;
    public static final int FRAME_POINTER_START = 5;
    private static final int TRANSFORMATION_BIT = 13;
    private static final int SCALING_BIT = 11;
    private static final int PALETTE_ID_MASK = 2047;
    private static final int FRAMEPOINTER_MASK = Short.MAX_VALUE;
    public static final int SMALL_COORDINATE_BIT = 32768;
    public static final int ANIMATION_BIT = 16384;
    public static final int COLLISION_BOX_LEN = 5;
    public static final int TRANSFORMATION_NONE = 0;
    public static final int TRANSFORMATION_FLIP_HORIZONTAL = 1;
    public static final int TRANSFORMATION_FLIP_VERTICAL = 2;
    private static final boolean USE_NOKIAUI_TRANSFORMATIONS = false;
    private static final boolean USE_MIDP2_TRANSFORMATIONS = true;
    private static final boolean USE_REALTIME_TRANSFORMATIONS = true;
    private static final boolean USE_REALTIME_TRANSFORMATIONS_FOR_ALPHA_IMAGES = true;
    private static final boolean BREW_TRANSPARENCY = false;
    private short[][] mAnimations;
    private int mCurrentAnimationIndex;
    private int mCurrentFrameIndex;
    private int mCurrentFramePointer;
    private int mDelay;
    private int mElapsedTime;
    private boolean mForceEachFrame;
    private int mLoopCount;
    private int mLoopCounter;
    private short[] movement;
    private int mMovementX;
    private int mMovementY;
    private static final int CIRCLE_ACCURANCY = 1;
    private static final int TRIANGLE_ACCURANCY = 1;
    public static final int LOOP_FOREVER = -1;
    private static final short[] EMPTY_ANIMATION = new short[]{0, 0, 0, 0, 1, 7, Short.MAX_VALUE, 0, 0};
    private static final boolean USE_IMAGE_CACHING = false;
    private static Hashtable smImageCache;
    public int timer;
    public int x;
    public int y;
    public int angle;
    private static Image[] smImages;
    private static Vector smImageReferences;
    private static Vector smImageIDs;
    private static Vector smPaletteIndices;
    private static int[][] smPalettes;
    public static final int PIXELS_24BIT = 254;
    public static final int PIXELS_32BIT = 255;
    public static final int PIXELS_RAW_FORMAT = 253;
    public static final int PIXELS_INDEXED = -1;
    private static int[] smCrcTable;

    public SpriteObject(short[][] sArray, boolean bl) {
        this.mAnimations = sArray;
        int n = sArray.length;
        while (--n >= 0) {
            short[] sArray2 = sArray[n];
            if (sArray2 == null) continue;
            SpriteObject.modImgRefCounter(sArray2, 1);
        }
        this.setAnimation(0, bl ? -1 : 1, false);
    }

    public SpriteObject(short[] sArray, boolean bl) {
        this(new short[][]{sArray}, bl);
    }

    public final int getFrameCount() {
        return this.mAnimations[this.mCurrentAnimationIndex][4];
    }

    public static short[] loadAnimation(int n) {
        if (n == -1) {
            return EMPTY_ANIMATION;
        }
        byte[] byArray = Toolkit.getResourceBytes(n);
        int n2 = byArray[0] << 8 | byArray[1] & 0xFF;
        boolean bl = (n2 & 0x4000) == 16384;
        boolean bl2 = (n2 & 0x8000) == 32768;
        n2 = (short)(n2 & 0xFFFF3FFF);
        short[] sArray = new short[n2];
        int n3 = 2;
        sArray[4] = 1;
        if (bl) {
            sArray[4] = byArray[n3++];
        }
        if (bl2) {
            sArray[0] = byArray[n3++];
            sArray[1] = byArray[n3++];
            sArray[2] = (short)(byArray[n3++] & 0xFF);
            sArray[3] = (short)(byArray[n3++] & 0xFF);
        } else {
            sArray[0] = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
            sArray[1] = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
            sArray[2] = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
            sArray[3] = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
        }
        short s = (short)(5 + (sArray[4] << 1));
        for (int i = 0; i < sArray[4]; ++i) {
            short s2 = s;
            int n4 = -1;
            int n5 = Short.MAX_VALUE;
            if (bl) {
                n4 = byArray[n3++];
                n5 = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
            }
            if (n4 == -1) {
                short s3 = (short)(byArray[n3++] & 0xFF);
                short s4 = (short)(byArray[n3++] & 0xFF);
                short s5 = s;
                s = (short)(s + 1);
                sArray[s5] = s4;
                while ((s4 = (short)(s4 - 1)) >= 0) {
                    short s6 = s;
                    s = (short)(s + 1);
                    sArray[s6] = (short)(byArray[n3++] & 0xFF);
                    if (bl2) {
                        short s7 = s;
                        s = (short)(s + 1);
                        sArray[s7] = byArray[n3++];
                        short s8 = s;
                        s = (short)(s + 1);
                        sArray[s8] = byArray[n3++];
                        short s9 = s;
                        s = (short)(s + 1);
                        sArray[s9] = (short)(byArray[n3++] & 0xFF);
                        short s10 = s;
                        s = (short)(s + 1);
                        sArray[s10] = (short)(byArray[n3++] & 0xFF);
                        continue;
                    }
                    short s11 = s;
                    s = (short)(s + 1);
                    sArray[s11] = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
                    short s12 = s;
                    s = (short)(s + 1);
                    sArray[s12] = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
                    short s13 = s;
                    s = (short)(s + 1);
                    sArray[s13] = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
                    short s14 = s;
                    s = (short)(s + 1);
                    sArray[s14] = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
                }
                short s15 = s;
                s = (short)(s + 1);
                sArray[s15] = s3;
                while ((s3 = (short)(s3 - 1)) >= 0) {
                    short s16 = (short)(byArray[n3] & 7);
                    short s17 = s;
                    s = (short)(s + 1);
                    sArray[s17] = s16;
                    int n6 = (byArray[n3] >> 3 & 7) + 1;
                    int n7 = byArray[n3++] >> 6 & 3;
                    if (s16 == 0) {
                        int n8 = (byArray[n3++] & 0xFF) << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
                        int n9 = byArray[n3++] & 0xFF;
                        if (bl2) {
                            short s18 = s;
                            s = (short)(s + 1);
                            sArray[s18] = byArray[n3++];
                            short s19 = s;
                            s = (short)(s + 1);
                            sArray[s19] = byArray[n3++];
                        } else {
                            short s20 = s;
                            s = (short)(s + 1);
                            sArray[s20] = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
                            short s21 = s;
                            s = (short)(s + 1);
                            sArray[s21] = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
                        }
                        short s22 = s;
                        s = (short)(s + 1);
                        sArray[s22] = (short)SpriteObject.loadImageIntoCache(n8, n9, n7, n6);
                        continue;
                    }
                    short s23 = s;
                    s = (short)(s + 1);
                    sArray[s23] = (short)(byArray[n3++] & 0xFFFF);
                    short s24 = s;
                    s = (short)(s + 1);
                    sArray[s24] = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
                    if (bl2) {
                        short s25 = s;
                        s = (short)(s + 1);
                        sArray[s25] = byArray[n3++];
                        short s26 = s;
                        s = (short)(s + 1);
                        sArray[s26] = byArray[n3++];
                        if (s16 == 5) {
                            short s27 = s;
                            s = (short)(s + 1);
                            sArray[s27] = byArray[n3++];
                            short s28 = s;
                            s = (short)(s + 1);
                            sArray[s28] = byArray[n3++];
                            short s29 = s;
                            s = (short)(s + 1);
                            sArray[s29] = byArray[n3++];
                            short s30 = s;
                            s = (short)(s + 1);
                            sArray[s30] = byArray[n3++];
                            continue;
                        }
                        if (s16 == 3) {
                            short s31 = s;
                            s = (short)(s + 1);
                            sArray[s31] = byArray[n3++];
                            short s32 = s;
                            s = (short)(s + 1);
                            sArray[s32] = byArray[n3++];
                            continue;
                        }
                        short s33 = s;
                        s = (short)(s + 1);
                        sArray[s33] = (short)(byArray[n3++] & 0xFF);
                        short s34 = s;
                        s = (short)(s + 1);
                        sArray[s34] = (short)(byArray[n3++] & 0xFF);
                        continue;
                    }
                    short s35 = s;
                    s = (short)(s + 1);
                    sArray[s35] = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
                    short s36 = s;
                    s = (short)(s + 1);
                    sArray[s36] = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
                    short s37 = s;
                    s = (short)(s + 1);
                    sArray[s37] = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
                    short s38 = s;
                    s = (short)(s + 1);
                    sArray[s38] = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
                    if (s16 != 5) continue;
                    short s39 = s;
                    s = (short)(s + 1);
                    sArray[s39] = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
                    short s40 = s;
                    s = (short)(s + 1);
                    sArray[s40] = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
                }
            } else {
                s2 = (short)(sArray[5 + (n4 << 1)] | 0x8000);
            }
            sArray[5 + (i << 1)] = s2;
            sArray[6 + (i << 1)] = n5;
        }
        return sArray;
    }

    public void setMovement(byte[] byArray, int n) {
        if (n != -1) {
            int n2 = n << 1;
            n2 = byArray[n2++] << 8 | byArray[n2] & 0xFF;
            if (byArray[n2++] == 0) {
                this.mMovementX = (short)(byArray[n2++] << 8 | byArray[n2++] & 0xFF);
                this.mMovementY = (short)(byArray[n2++] << 8 | byArray[n2] & 0xFF);
            }
        }
    }

    public static short[][] loadAnimations(int[] nArray) {
        short[][] sArrayArray = new short[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            sArrayArray[i] = SpriteObject.loadAnimation(nArray[i]);
        }
        return sArrayArray;
    }

    public short[] getCurrentAnimationData() {
        return this.mAnimations[this.mCurrentAnimationIndex];
    }

    public final int getCollisionBoxes() {
        return this.mCurrentFramePointer;
    }

    public void logicUpdate(int n) {
        if (this.movement != null) {
            // empty if block
        }
        this.mElapsedTime += n;
        while (this.mElapsedTime >= this.mDelay) {
            short[] sArray;
            short s;
            this.mElapsedTime -= this.mDelay;
            if (this.mForceEachFrame) {
                this.mElapsedTime = 0;
            }
            if (++this.mCurrentFrameIndex >= (s = (sArray = this.mAnimations[this.mCurrentAnimationIndex])[4])) {
                if (this.mLoopCounter > 0) {
                    --this.mLoopCounter;
                }
                this.mCurrentFrameIndex = 0;
                if (this.mLoopCounter == 0) {
                    this.mCurrentFrameIndex = s - 1;
                }
            }
            int n2 = 5 + (this.mCurrentFrameIndex << 1);
            this.mCurrentFramePointer = sArray[n2++] & Short.MAX_VALUE;
            this.mDelay = sArray[n2];
        }
    }

    public final void draw(Graphics graphics, int n, int n2) {
        short[] sArray = this.mAnimations[this.mCurrentAnimationIndex];
        n -= sArray[0];
        n2 -= sArray[1];
        n += this.mMovementX;
        n2 += this.mMovementY;
        int n3 = this.mCurrentFramePointer + sArray[this.mCurrentFramePointer] * 5;
        int n4 = sArray[++n3];
        while (--n4 >= 0) {
            short s;
            if ((s = sArray[++n3]) == 0) {
                int n5 = sArray[++n3] + n;
                int n6 = sArray[++n3] + n2;
                int n7 = sArray[++n3];
                Image image = smImages[n7 & 0x7FF];
                int n8 = n7 >>> 13;
                if (n8 != 0) {
                    n7 = 0;
                    if ((n8 & 1) != 0) {
                        n7 = 2;
                    }
                    if ((n8 & 2) != 0) {
                        n7 |= 1;
                    }
                    graphics.drawRegion(image, 0, 0, image.getWidth(), image.getHeight(), n7, n5, n6, 20);
                    continue;
                }
                graphics.drawImage(image, n5, n6, 20);
                continue;
            }
            graphics.setColor(sArray[++n3] << 16 | sArray[++n3] & 0xFFFF);
            if (s == 3) {
                graphics.drawLine(n + sArray[++n3], n2 + sArray[++n3], n + sArray[++n3], n2 + sArray[++n3]);
                continue;
            }
            if (s == 2) {
                graphics.drawRect(n + sArray[++n3], n2 + sArray[++n3], (int)sArray[++n3], (int)sArray[++n3]);
                continue;
            }
            if (s == 1) {
                graphics.fillRect(n + sArray[++n3], n2 + sArray[++n3], (int)sArray[++n3], (int)sArray[++n3]);
                continue;
            }
            if (s == 4) {
                SpriteObject.fillEllipse(graphics, n + sArray[++n3], n2 + sArray[++n3], sArray[++n3], sArray[++n3], 1);
                continue;
            }
            SpriteObject.fillTriangle(graphics, n + sArray[++n3], n2 + sArray[++n3], n + sArray[++n3], n2 + sArray[++n3], n + sArray[++n3], n2 + sArray[++n3], 1);
        }
    }

    public void setAnimation(int n, int n2, boolean bl) {
        this.mCurrentAnimationIndex = n;
        this.mLoopCount = n2;
        this.mLoopCounter = n2;
        this.setAnimationFrame(0);
        this.mForceEachFrame = bl;
    }

    public final int getCurrentAnimationIndex() {
        return this.mCurrentAnimationIndex;
    }

    public int getAnimationCount() {
        return this.mAnimations.length;
    }

    public void setAnimationFrame(int n) {
        short[] sArray = this.mAnimations[this.mCurrentAnimationIndex];
        this.mCurrentFrameIndex = n;
        this.mCurrentFramePointer = sArray[5 + (this.mCurrentFrameIndex << 1)] & Short.MAX_VALUE;
        this.mDelay = sArray[5 + (this.mCurrentFrameIndex << 1) + 1];
        this.mLoopCounter = this.mLoopCount;
        this.mElapsedTime = 0;
    }

    public final int getCurrentFrameIndex() {
        return this.mCurrentFrameIndex;
    }

    public final boolean isFinishedAnimation() {
        return this.mLoopCounter == 0;
    }

    public int getPivotX() {
        return this.mAnimations[this.mCurrentAnimationIndex][0];
    }

    public int getPivotY() {
        return this.mAnimations[this.mCurrentAnimationIndex][1];
    }

    public final int getWidth() {
        return this.mAnimations[this.mCurrentAnimationIndex][2];
    }

    public final int getHeight() {
        return this.mAnimations[this.mCurrentAnimationIndex][3];
    }

    public final void freeResources() {
        if (this.mAnimations != null) {
            int n = this.mAnimations.length;
            while (--n >= 0) {
                if (this.mAnimations[n] == null) continue;
                SpriteObject.modImgRefCounter(this.mAnimations[n], -1);
            }
            n = smImageReferences.size();
            while (--n >= 0) {
                int n2 = (Integer)smImageReferences.elementAt(n);
                if (n2 > 0 || smImages[n] == null) continue;
                smImageReferences.setElementAt(new Integer(0), n);
                SpriteObject.smImages[n] = null;
                smImageIDs.setElementAt(new Integer(-1), n);
            }
            this.mAnimations = null;
        }
    }

    public static void initialize() {
        byte[] byArray = Toolkit.getResourceBytes(65584);
        int n = 0;
        smPalettes = new int[(byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF][];
        for (int i = 0; i < smPalettes.length; ++i) {
            byte[] byArray2 = Toolkit.getResourceBytes((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
            int n2 = byArray2.length / 3;
            SpriteObject.smPalettes[i] = new int[n2];
            while (--n2 >= 0) {
                SpriteObject.smPalettes[i][n2] = (byArray2[n2 * 3] & 0xFF) << 24 | (byArray2[n2 * 3 + 1] & 0xFF) << 16 | (byArray2[n2 * 3 + 2] & 0xFF) << 8 | 0xFF;
            }
        }
    }

    public static Image getImage(int n, int n2, int n3) {
        Image image = null;
        if (n != -1) {
            byte[] byArray = Toolkit.getResourceBytes(n);
            int n4 = (byArray[0] >> 3 & 7) + 1;
            int n5 = (byArray[1] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 8 | byArray[4] & 0xFF;
            int n6 = byArray[5] & 0xFF;
            image = SpriteObject.getImage(n5, n6, n2, n3 * n4);
        }
        return image;
    }

    public static void freeImageResources() {
    }

    private static int loadImageIntoCache(int n, int n2, int n3, int n4) {
        boolean bl = true;
        int n5 = 0;
        int n6 = SpriteObject.findIndex(n, n2 |= n4 - 1 << 11);
        if (n6 == -1) {
            n6 = SpriteObject.findIndex(-1, 0);
            if (n6 != -1) {
                smImageIDs.setElementAt(new Integer(n), n6);
                smPaletteIndices.setElementAt(new Integer(n2), n6);
            } else {
                n6 = smImages.length;
                Image[] imageArray = new Image[n6 + 1];
                System.arraycopy(smImages, 0, imageArray, 0, n6);
                smImages = imageArray;
                smImageIDs.addElement(new Integer(n));
                smPaletteIndices.addElement(new Integer(n2));
                smImageReferences.addElement(new Integer(0));
            }
        } else {
            if (bl) {
                return n6 | n3 << 13;
            }
            return n6;
        }
        SpriteObject.smImages[n6] = n2 == 253 ? Toolkit.getImage(n) : SpriteObject.getImage(n, n2, n5, n4);
        smPaletteIndices.setElementAt(new Integer(n2), n6);
        if (bl) {
            return n6 | n3 << 13;
        }
        return n6;
    }

    private static Image getImage(int n, int n2, int n3, int n4) {
        if (n2 == 253) {
            return Toolkit.getImage(n);
        }
        byte[] byArray = Toolkit.getResourceBytes(n);
        int n5 = byArray[0] << 8 | byArray[1] & 0xFF;
        int n6 = byArray[2] << 8 | byArray[3] & 0xFF;
        byte[] byArray2 = (n2 & 0x7FF) < 254 ? SpriteObject.createPng(smPalettes[n2 & 0x7FF], byArray, n5, n6, -1, 12, n3, n4) : SpriteObject.createPng(null, byArray, n5, n6, n2 & 0x7FF, 4, n3, n4);
        return Image.createImage((byte[])byArray2, (int)0, (int)byArray2.length);
    }

    private static final void modImgRefCounter(short[] sArray, int n) {
        int n2 = sArray[4];
        while (--n2 >= 0) {
            int n3 = sArray[5 + (n2 << 1)];
            if (n3 < 0) continue;
            n3 += sArray[n3] * 5 + 1;
            int n4 = sArray[n3++];
            while (--n4 >= 0) {
                short s = sArray[n3];
                if (s == 0) {
                    n3 += 3;
                    int n5 = sArray[n3++] & 0x7FF;
                    int n6 = (Integer)smImageReferences.elementAt(n5);
                    smImageReferences.setElementAt(new Integer(n6 + n), n5);
                    continue;
                }
                n3 += 7;
                if (s != 5) continue;
                n3 += 2;
            }
        }
    }

    private static int findIndex(int n, int n2) {
        int n3 = smImageIDs.size();
        while (--n3 >= 0 && ((Integer)smImageIDs.elementAt(n3) != n || n != -1 && n2 != (Integer)smPaletteIndices.elementAt(n3))) {
        }
        return n3;
    }

    private static void fillEllipse(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n3 == 0) {
            n3 = 1;
        }
        if (n4 == 0) {
            n4 = 1;
        }
        int n6 = n4 * n4;
        int n7 = (n4 << 8) / n3;
        n7 *= n7;
        block0: for (int i = -n4; i <= 0; i += n5) {
            int n8 = n6 - i * i;
            for (int j = n3; j >= 0; j -= n5) {
                if (j * j * n7 >> 16 > n8) continue;
                graphics.fillRect(n - j - 1, n2 + i, (j << 1) + 1, n5);
                graphics.fillRect(n - j - 1, n2 - i - (n5 - 1), (j << 1) + 1, n5);
                continue block0;
            }
        }
    }

    public static void fillTriangle(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10 = n2;
        if (n10 > n6) {
            n2 = n6;
            n6 = n10;
            n10 = n;
            n = n5;
            n5 = n10;
        }
        if (n2 > n4) {
            n10 = n4;
            n4 = n2;
            n2 = n10;
            n10 = n3;
            n3 = n;
            n = n10;
        }
        if (n4 > n6) {
            n10 = n4;
            n4 = n6;
            n6 = n10;
            n10 = n3;
            n3 = n5;
            n5 = n10;
        }
        int n11 = ((n5 <<= 16) - (n <<= 16)) * n7 / Math.max(n6 - n2, 1);
        int n12 = ((n3 <<= 16) - n) * n7 / Math.max(n4 - n2, 1);
        int n13 = (n5 - n3) * n7 / Math.max(n6 - n4, 1);
        int n14 = n9 = n;
        int n15 = n4;
        if (n11 <= n12) {
            for (n8 = n2; n8 < n15; n8 += n7) {
                graphics.fillRect(n9 >> 16, n8, (n14 >> 16) - (n9 >> 16), n7);
                n9 += n11;
                n14 += n12;
            }
        } else {
            while (n8 < n15) {
                graphics.fillRect(n14 >> 16, n8, (n9 >> 16) - (n14 >> 16), n7);
                n9 += n11;
                n14 += n12;
                n8 += n7;
            }
        }
        n15 = n6;
        n14 = n3;
        if (n14 >= n9) {
            while (n8 < n15) {
                graphics.fillRect(n9 >> 16, n8, (n14 >> 16) - (n9 >> 16), n7);
                n9 += n11;
                n14 += n13;
                n8 += n7;
            }
        } else {
            while (n8 < n15) {
                graphics.fillRect(n14 >> 16, n8, (n9 >> 16) - (n14 >> 16), n7);
                n9 += n11;
                n14 += n13;
                n8 += n7;
            }
        }
    }

    public static byte[] createPng(int[] nArray, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        boolean bl = (n5 & 1) > 0;
        boolean bl2 = (n5 & 2) > 0;
        boolean bl3 = n3 == -1 && n4 != 0;
        int n9 = 4;
        int n10 = 4;
        int n11 = 0;
        if (n3 == -1) {
            n9 = 1;
            n10 = 1;
            n11 = 3 * nArray.length + 4 + 4 + 4 + 1 + 4 + 4 + 4;
        } else if (n3 == 254) {
            n10 = 3;
        }
        int n12 = 65531;
        int n13 = n;
        n12 -= n12 % ((n *= n6) * n9 + 1);
        int n14 = n * (n2 *= n6) * n9 + n2;
        int n15 = (n14 - 1) / n12 + 1;
        int n16 = 6 + n14 + n15 * 5;
        byte[] byArray2 = new byte[57 + n16 + n11];
        byArray2[0] = -119;
        byArray2[1] = 80;
        byArray2[2] = 78;
        byArray2[3] = 71;
        byArray2[4] = 13;
        byArray2[5] = 10;
        byArray2[6] = 26;
        byArray2[7] = 10;
        byArray2[11] = 13;
        byArray2[12] = 73;
        byArray2[13] = 72;
        byArray2[14] = 68;
        byArray2[15] = 82;
        byArray2[18] = (byte)(n >> 8);
        byArray2[19] = (byte)n;
        byArray2[22] = (byte)(n2 >> 8);
        byArray2[23] = (byte)n2;
        byArray2[24] = 8;
        byArray2[25] = (byte)(n3 == -1 ? 3 : 6);
        int n17 = SpriteObject.crc32(byArray2, 12, 17);
        byArray2[29] = (byte)(n17 >> 24);
        byArray2[30] = (byte)(n17 >> 16);
        byArray2[31] = (byte)(n17 >> 8);
        byArray2[32] = (byte)n17;
        int n18 = 33;
        if (n3 == -1) {
            n8 = nArray.length * 3;
            byArray2[35] = (byte)(n8 >> 8);
            byArray2[36] = (byte)n8;
            byArray2[37] = 80;
            byArray2[38] = 76;
            byArray2[39] = 84;
            byArray2[40] = 69;
            n18 = 41;
            for (n7 = 0; n7 < nArray.length; ++n7) {
                byArray2[n18++] = (byte)(nArray[n7] >> 24);
                byArray2[n18++] = (byte)(nArray[n7] >> 16);
                byArray2[n18++] = (byte)(nArray[n7] >> 8);
            }
            n17 = SpriteObject.crc32(byArray2, n18 - n8 - 4, n8 + 4);
            byArray2[n18++] = (byte)(n17 >>> 24);
            byArray2[n18++] = (byte)(n17 >>> 16);
            byArray2[n18++] = (byte)(n17 >>> 8);
            byArray2[n18++] = (byte)n17;
            n18 += 3;
            byArray2[n18++] = 1;
            byArray2[n18++] = 116;
            byArray2[n18++] = 82;
            byArray2[n18++] = 78;
            byArray2[n18++] = 83;
            n17 = SpriteObject.crc32(byArray2, ++n18 - 5, 5);
            byArray2[n18++] = (byte)(n17 >>> 24);
            byArray2[n18++] = (byte)(n17 >>> 16);
            byArray2[n18++] = (byte)(n17 >>> 8);
            byArray2[n18++] = (byte)n17;
        }
        byArray2[n18++] = (byte)(n16 >> 24);
        byArray2[n18++] = (byte)(n16 >> 16);
        byArray2[n18++] = (byte)(n16 >> 8);
        byArray2[n18++] = (byte)n16;
        n8 = n18;
        byArray2[n18++] = 73;
        byArray2[n18++] = 68;
        byArray2[n18++] = 65;
        byArray2[n18++] = 84;
        byArray2[n18++] = 120;
        byArray2[n18++] = 1;
        n7 = 1;
        int n19 = n12;
        int n20 = 0;
        boolean bl4 = n6 == 1 && n5 == 0 && bl3;
        n9 *= n;
        for (int i = 0; i < n15; ++i) {
            if (i == n15 - 1) {
                byArray2[n18] = 1;
                n19 = n14 % n12;
            }
            int n21 = ++n18;
            byArray2[n21] = (byte)n19;
            int n22 = ++n18;
            byArray2[n22] = (byte)(n19 >> 8);
            int n23 = n19 ^ 0xFFFF;
            int n24 = ++n18;
            byArray2[n24] = (byte)n23;
            int n25 = ++n18;
            ++n18;
            byArray2[n25] = (byte)(n23 >> 8);
            for (int j = 0; n20 < n2 && j < n19; j += n9, ++n20) {
                int n26;
                ++j;
                ++n18;
                int n27 = n26 = bl2 ? n2 - n20 - 1 : n20;
                if (n6 != 1) {
                    n26 /= n6;
                }
                n26 *= n13;
                for (int k = 0; k < n; ++k) {
                    int n28;
                    int n29 = n28 = bl ? n - k - 1 : k;
                    if (n6 != 1) {
                        n28 /= n6;
                    }
                    int n30 = n4 + (n26 + n28) * n10;
                    byArray2[n18++] = byArray[n30];
                    if (n3 == -1) continue;
                    byArray2[n18++] = byArray[++n30];
                    byArray2[n18++] = byArray[++n30];
                    byArray2[n18++] = n3 == 255 ? byArray[++n30] : -1;
                }
            }
            if (bl4) continue;
            n7 = SpriteObject.adler32(byArray2, n18 - n19, n19, n7);
        }
        if (bl4) {
            byArray2[n18++] = byArray[4];
            byArray2[n18++] = byArray[5];
            byArray2[n18++] = byArray[6];
            byArray2[n18++] = byArray[7];
            byArray2[n18++] = byArray[8];
            byArray2[n18++] = byArray[9];
            byArray2[n18++] = byArray[10];
            byArray2[n18] = byArray[11];
        } else {
            byArray2[n18++] = (byte)(n7 >>> 24);
            byArray2[n18++] = (byte)(n7 >>> 16);
            byArray2[n18++] = (byte)(n7 >>> 8);
            byArray2[n18++] = (byte)n7;
            n17 = SpriteObject.crc32(byArray2, n8, n18 - n8);
            byArray2[n18++] = (byte)(n17 >>> 24);
            byArray2[n18++] = (byte)(n17 >>> 16);
            byArray2[n18++] = (byte)(n17 >>> 8);
            byArray2[n18] = (byte)n17;
        }
        n18 += 5;
        byArray2[n18++] = 73;
        byArray2[n18++] = 69;
        byArray2[n18++] = 78;
        byArray2[n18++] = 68;
        byArray2[n18++] = -82;
        byArray2[n18++] = 66;
        byArray2[n18++] = 96;
        byArray2[n18] = -126;
        return byArray2;
    }

    public static int adler32(byte[] byArray, int n, int n2, int n3) {
        int n4 = n3 >>> 16;
        int n5 = n3 & 0xFFFF;
        n2 += n;
        while (n < n2) {
            n5 = (n5 + (byArray[n] & 0xFF)) % 65521;
            n4 = (n4 + n5) % 65521;
            ++n;
        }
        return (n4 << 16) + n5;
    }

    private static int crc32(byte[] byArray, int n, int n2) {
        int n3;
        if (smCrcTable == null) {
            smCrcTable = new int[256];
            for (int i = 0; i < 256; ++i) {
                n3 = i;
                for (int j = 0; j < 8; ++j) {
                    n3 = (n3 & 1) != 0 ? 0xEDB88320 ^ n3 >>> 1 : (n3 >>>= 1);
                    SpriteObject.smCrcTable[i] = n3;
                }
            }
        }
        n3 = -1;
        n2 += n;
        while (n < n2) {
            n3 = smCrcTable[(n3 ^ byArray[n]) & 0xFF] ^ n3 >>> 8;
            ++n;
        }
        return ~n3;
    }

    public static void freeCRCTable() {
        smCrcTable = null;
    }

    static {
        smImages = new Image[0];
        smImageReferences = new Vector();
        smImageIDs = new Vector();
        smPaletteIndices = new Vector();
    }
}

