/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class MiniSpit
extends MiniGame {
    static final int MAX_FLIES = 6;
    int angle;
    int[] flyX = new int[6];
    int[] flyY = new int[6];
    int spitX;
    int spitY;
    int spitVX;
    int spitVY;
    int killedFlies;
    boolean[] flyAlive = new boolean[6];
    static final int SPRITE_BACKGROUND = 0;
    static final int SPRITE_FISH = 1;
    static final int SPRITE_FLY = 2;
    static final int SPRITE_BUBBLE = 3;
    static final int SPRITE_SPLASH_CENTER = 4;
    static final int SPRITE_SPLASH_RIGHT = 5;
    static final int SPRITE_SPLASH_LEFT = 6;
    static final int NUM_SPRITES = 7;
    static final int STATUS_AIMING = 1;
    static final int STATUS_SHOW = 2;
    int status;
    int numFlies = 3;
    int[] mColX = new int[6];
    int[] mColY = new int[6];
    int[] mColWidth = new int[6];
    int[] mColHeight = new int[6];
    boolean showSplash = false;
    static final int MAX_PARTICLES = 20;
    static final int PARTICLE_INTERVAL = 100;
    static final int PARTICLE_LIVING_TIME = 500;
    static final int GRAVITY = 2;
    int particlesTimeInterval;
    int particlesTimer;
    int[] particlesTimeAlive = new int[20];
    int[] particlesX = new int[20];
    int[] particlesY = new int[20];
    int[] particlesXs = new int[20];
    int[] particlesYs = new int[20];
    int groundY;
    int mUpdateTime;
    int hspitSize;
    int mAngleSpeed;
    private static final int MIN_UPDATE_TIME = 50;
    private static final int MAX_UPDATES_PER_CALL = 2;
    private static final int MAX_UPDATE_TIME = 100;
    static final int DEATH_ANGLE = 64;
    static final int DEATH_ANGLE_GFX = 32;
    int fishOffsetY;
    boolean leftPressed;
    boolean rightPressed;
    boolean fakeKeyPress;

    public MiniSpit(int n, int n2) {
        this.mBackground = new SpriteObject(SpriteObject.loadAnimation(720907), false);
        this.initialize(n, n2);
        this.mSpritesPool = new SpriteObject[7];
        this.mSpritesPool[0] = new SpriteObject(SpriteObject.loadAnimation(131103), true);
        this.mSpritesPool[1] = new SpriteObject(SpriteObject.loadAnimation(131129), true);
        this.mSpritesPool[2] = new SpriteObject(SpriteObject.loadAnimation(458813), true);
        this.mSpritesPool[3] = new SpriteObject(SpriteObject.loadAnimation(131102), true);
        this.mSpritesPool[4] = new SpriteObject(SpriteObject.loadAnimation(131096), false);
        this.mSpritesPool[5] = new SpriteObject(SpriteObject.loadAnimation(131097), false);
        this.mSpritesPool[6] = new SpriteObject(SpriteObject.loadAnimation(131104), false);
        this.fishOffsetY = this.mCanvasHeight << 6;
        this.mSpritesPool[0].setAnimationFrame(0);
        short[] sArray = this.mSpritesPool[0].getCurrentAnimationData();
        int n3 = this.mSpritesPool[0].getCollisionBoxes();
        n3 += 3;
        this.groundY = this.mCanvasHeight + sArray[n3++];
        this.mUpdateTime = 0;
    }

    public void updateGame(int n) {
        int n2;
        this.mUpdateTime += n;
        if (this.mUpdateTime > 100) {
            this.mUpdateTime = 100;
        }
        while (this.mUpdateTime >= 50) {
            if (this.status == 1) {
                if (this.leftPressed) {
                    this.angle -= 50 * (this.mAngleSpeed + this.mDifficulty * 7);
                }
                if (this.rightPressed) {
                    this.angle += 50 * (this.mAngleSpeed + this.mDifficulty * 7);
                }
                if (this.angle < 655360) {
                    this.angle = 655360;
                    this.rightPressed = true;
                    this.leftPressed = false;
                }
                if (this.angle > 917504) {
                    this.angle = 917504;
                    this.rightPressed = false;
                    this.leftPressed = true;
                }
            } else {
                n2 = this.spitX;
                int n3 = this.spitY;
                this.spitX += this.spitVX * 50;
                this.spitY += this.spitVY * 50;
                if (this.spitX < this.hspitSize << 12 || this.spitX >= this.mCanvasWidth - this.hspitSize << 12) {
                    this.spitVX = -this.spitVX;
                }
                boolean bl = false;
                for (int i = 0; i < this.numFlies; ++i) {
                    boolean bl2 = bl = this.flyAlive[i] && Math.abs(this.spitX - this.flyX[i]) < this.hspitSize << 12 && Math.abs(this.spitY - this.flyY[i]) < this.hspitSize << 12;
                    if (!bl) {
                        int n4 = n3 - this.flyY[i] >> 12;
                        int n5 = this.spitY - this.flyY[i] >> 12;
                        if (this.flyAlive[i] && n4 * n5 < 0) {
                            n4 = n2 - this.flyX[i] >> 12;
                            n5 = this.spitX - this.flyX[i] >> 12;
                            boolean bl3 = bl = n4 * n5 <= 0;
                        }
                    }
                    if (bl) {
                        this.flyAlive[i] = false;
                        this.fakeKeyPress = true;
                        this.registerParticle(this.mCanvasX + (this.flyX[i] >> 12), this.mCanvasY + (this.flyY[i] >> 12));
                        this.keyEvent(53, 0);
                        this.fakeKeyPress = false;
                    }
                    bl = false;
                }
                if (!this.showSplash && this.spitY >> 12 < this.groundY) {
                    this.showSplash = true;
                    this.mSpritesPool[4].setAnimationFrame(0);
                    this.mSpritesPool[6].setAnimationFrame(0);
                    this.mSpritesPool[5].setAnimationFrame(0);
                }
                if (this.spitY < 0) {
                    this.showSplash = false;
                    this.fakeKeyPress = true;
                    this.keyEvent(56, 0);
                    this.fakeKeyPress = false;
                }
            }
            this.mUpdateTime -= 50;
        }
        this.updateParticles(n);
        for (n2 = 0; n2 < 7; ++n2) {
            this.mSpritesPool[n2].logicUpdate(n);
        }
        this.fishOffsetY = this.mSpritesPool[0].getHeight() << 10;
    }

    private void updateParticles(int n) {
        int n2;
        for (n2 = 0; n2 < 20; ++n2) {
            if (this.particlesTimeAlive[n2] <= 0) continue;
            int n3 = n2;
            this.particlesTimeAlive[n3] = this.particlesTimeAlive[n3] - (n + 1);
            this.particlesXs[n2] = this.particlesXs[n2] * 90 / 100;
            int n4 = n2;
            this.particlesYs[n4] = this.particlesYs[n4] + 2 * n;
            int n5 = n2;
            this.particlesX[n5] = this.particlesX[n5] + this.particlesXs[n2] * n;
            int n6 = n2;
            this.particlesY[n6] = this.particlesY[n6] + this.particlesYs[n2] * n;
            if (this.particlesY[n2] >> 12 <= this.groundY) continue;
            this.particlesTimeAlive[n2] = -1;
        }
        if (this.status != 1) {
            this.particlesTimer += n;
            block1: while (this.particlesTimer > this.particlesTimeInterval) {
                this.particlesTimer -= this.particlesTimeInterval;
                this.particlesTimeInterval = MiniSpit.rnd(100);
                for (n2 = 0; n2 < 20; ++n2) {
                    if (this.particlesTimeAlive[n2] > 0) continue;
                    this.particlesTimeAlive[n2] = 500;
                    this.particlesX[n2] = this.spitX;
                    this.particlesY[n2] = this.spitY;
                    this.particlesXs[n2] = this.spitVX;
                    this.particlesYs[n2] = 0;
                    continue block1;
                }
            }
        }
    }

    protected boolean checkAnswer(int n) {
        return true;
    }

    public void drawGame(Graphics graphics) {
        int n;
        int n2;
        int n3 = this.mCanvasX + (this.mCanvasWidth >> 1);
        int n4 = this.mCanvasY + this.mCanvasHeight - (this.fishOffsetY >> 12) - 0;
        graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
        this.mSpritesPool[0].draw(graphics, this.mCanvasX + 0, this.mCanvasY + this.mCanvasHeight);
        graphics.setColor(7649760);
        int n5 = GameEngine.trigon_cos(this.angle >> 12) * this.mCanvasWidth >> 11;
        int n6 = GameEngine.trigon_sin(this.angle >> 12) * this.mCanvasHeight >> 11;
        graphics.drawLine(n3, n4, n3 + n5, n4 + n6);
        int n7 = GameEngine.trigon_cos(this.mElapsedTime >> 2) >> 9;
        int n8 = GameEngine.trigon_sin(this.mElapsedTime >> 2) >> 9;
        for (n2 = 0; n2 < this.numFlies; ++n2) {
            if (!this.flyAlive[n2]) continue;
            this.mSpritesPool[2].draw(graphics, n7 + this.mCanvasX + (this.flyX[n2] >> 12), n8 + this.mCanvasY + (this.flyY[n2] >> 12));
        }
        if (this.status == 2) {
            this.mSpritesPool[3].draw(graphics, this.mCanvasX + (this.spitX >> 12), this.mCanvasY + (this.spitY >> 12));
        }
        n2 = this.mSpritesPool[1].getFrameCount();
        int n9 = (n2 << 12) / 96;
        int n10 = 0;
        int n11 = n10 + (-16 + (this.angle >> 12) - 128) * n9 >> 12;
        this.mSpritesPool[1].setAnimationFrame(n11);
        int n12 = this.mCanvasHeight / 12;
        n12 = Math.abs(GameEngine.trigon_sin(this.mElapsedTime >> 3) * n12 >> 12);
        this.mSpritesPool[1].draw(graphics, n3, n4 - n12);
        if (this.showSplash) {
            n = 4;
            if (this.angle >> 12 < 180) {
                n = 6;
            }
            if (this.angle >> 12 > 212) {
                n = 5;
            }
            this.mSpritesPool[n].draw(graphics, this.mCanvasX, this.mCanvasY + this.mCanvasHeight);
        }
        for (n = 0; n < 20; ++n) {
            if (this.particlesTimeAlive[n] <= 0) continue;
            graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
            graphics.setColor(33023);
            graphics.fillRect(this.mCanvasX + (this.particlesX[n] >> 12), this.mCanvasY + (this.particlesY[n] >> 12), 2, 2);
        }
        graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
    }

    protected void initNextQuestion() {
        int n;
        int n2;
        int n3;
        this.killedFlies = 0;
        this.fakeKeyPress = false;
        this.numFlies = Math.max(Math.min(3 + this.mDifficulty, 6), 3);
        this.mAngleSpeed = Math.max(100, 100 + this.mDifficulty * 5);
        int n4 = 3;
        if (n4 < 0) {
            n4 = 0;
        }
        this.hspitSize = this.mCanvasWidth / 21;
        int n5 = 0;
        for (n3 = 0; n3 < this.numFlies; ++n3) {
            this.flyAlive[n3] = true;
            n2 = 160 + MiniSpit.rnd(64);
            if (n5 != 0) {
                while (Math.abs(n2 - n5) > this.numFlies * 10) {
                    n2 = 160 + MiniSpit.rnd(64);
                }
            }
            n5 = n2;
            this.spitX = this.mCanvasWidth >> 1 << 12;
            this.spitY = (this.mCanvasHeight << 12) - this.fishOffsetY;
            this.spitVX = GameEngine.trigon_cos(n2) * 15;
            this.spitVY = GameEngine.trigon_sin(n2) * 15;
            for (n = 0; n < 20 + MiniSpit.rnd(Math.min(40, this.mDifficulty * 5)); ++n) {
                this.spitX += this.spitVX;
                this.spitY += this.spitVY;
                if (this.spitX < this.hspitSize << 12) {
                    this.spitVX = -this.spitVX;
                }
                if (this.spitX >= this.mCanvasWidth - this.hspitSize << 12) {
                    this.spitVX = -this.spitVX;
                }
                if (this.spitY >= this.hspitSize) continue;
                this.spitX -= this.spitVX;
                this.spitY -= this.spitVY;
                break;
            }
            this.flyX[n3] = this.spitX;
            this.flyY[n3] = this.spitY;
        }
        this.status = 1;
        this.spitX = this.mCanvasWidth >> 1 << 12;
        this.spitY = (this.mCanvasHeight << 12) - this.fishOffsetY;
        n3 = 0;
        n2 = 0;
        for (n = 0; n < this.numFlies; ++n) {
            n3 += this.flyX[n];
            n2 += this.flyY[n];
        }
        this.angle = GameEngine.trigon_atan((n2 /= this.numFlies) - this.spitY, (n3 /= this.numFlies) - this.spitX) << 12;
        this.rightPressed = n3 >> 12 >= this.mCanvasWidth >> 1;
        this.leftPressed = !this.rightPressed;
    }

    public boolean collision(int n, int n2, int n3, int n4, int n5, int n6) {
        n3 += this.mColY[n];
        n6 += this.mColY[n4];
        int n7 = this.mColWidth[n];
        int n8 = this.mColWidth[n4];
        return (n5 += this.mColX[n4]) <= (n2 += this.mColX[n]) + n7 && n5 + n8 >= n2;
    }

    protected int isCorrectAnswer(int n) {
        if (n != 0) {
            int n2 = Toolkit.getToolkitGameAction(n);
            if (this.status == 1) {
                if (n2 == 53) {
                    this.status = 2;
                    this.spitVX = GameEngine.trigon_cos(this.angle >> 12);
                    this.spitVY = GameEngine.trigon_sin(this.angle >> 12);
                    this.rightPressed = !this.rightPressed;
                    this.leftPressed = !this.leftPressed;
                }
            } else {
                if (this.fakeKeyPress && n2 == 53) {
                    ++this.killedFlies;
                    if (this.killedFlies == this.numFlies) {
                        return 0;
                    }
                    return 2;
                }
                if (this.fakeKeyPress && n2 == 56) {
                    this.status = 1;
                    this.spitX = this.mCanvasWidth >> 1 << 12;
                    this.spitY = (this.mCanvasHeight << 12) - this.fishOffsetY;
                }
            }
        }
        return 3;
    }
}

