/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MiniStroop
extends MiniGame {
    private String[] COLORNAMES = new String[]{Toolkit.getText(90), Toolkit.getText(91), Toolkit.getText(92), Toolkit.getText(93), Toolkit.getText(94), Toolkit.getText(95)};
    private static final int[] COLORVALUES = new int[]{0xFF0000, 65280, 255, 0xFFFF00, 16028167, 0};
    private static final int[] COLORBOLD = new int[]{0x880000, 34816, 136, 0x888800, 8536323, 0x808080};
    private static final int EXTRALINES = 4;
    private static final int BAR = 0;
    private int[] mColorsNameIndex;
    private int[] mColorsIndex;
    private Font heavyFont;
    private int mFontHeight;
    private int mNumVisibleLines;
    private int mScrollDown;
    private boolean doScroll;
    private int mNumColors;

    public MiniStroop(int n, int n2) {
        this.mBackground = new SpriteObject(SpriteObject.loadAnimation(720899), false);
        this.initialize(n, n2);
        this.heavyFont = Font.getFont((int)64, (int)1, (int)16);
        this.createButtons(SpriteObject.loadAnimations(new int[]{655413, 589877, 589876}), SpriteObject.loadAnimations(new int[]{655415, 589879, 655361}));
        this.mFontHeight = this.heavyFont.getHeight();
        this.mNumVisibleLines = this.mCanvasHeight / this.mFontHeight;
        this.mColorsNameIndex = new int[this.mNumVisibleLines + 4];
        this.mColorsIndex = new int[this.mNumVisibleLines + 4];
        this.mNumColors = 2;
        for (int i = 0; i < this.mNumVisibleLines + 4; ++i) {
            this.newWord(i);
        }
        this.doScroll = false;
    }

    public void newWord(int n) {
        if (MiniStroop.rnd(100) < 50) {
            this.mColorsIndex[n] = this.mColorsNameIndex[n] = MiniStroop.rnd(this.mNumColors);
        } else {
            this.mColorsNameIndex[n] = MiniStroop.rnd(this.mNumColors);
            do {
                this.mColorsIndex[n] = MiniStroop.rnd(this.mNumColors);
            } while (this.mColorsIndex[n] == this.mColorsNameIndex[n]);
        }
    }

    public void updateGame(int n) {
        if (this.mScrollDown > 0) {
            while (this.mProcessedTime < this.mElapsedTime) {
                this.mScrollDown -= this.mFontHeight / 6;
                this.mProcessedTime += 50;
            }
            if (this.mScrollDown < 0) {
                this.mScrollDown = 0;
            }
        }
    }

    protected boolean checkAnswer(int n) {
        return true;
    }

    public void drawGame(Graphics graphics) {
        int n = this.mCanvasY + this.mCanvasHeight - (this.mCanvasHeight - this.mFontHeight * this.mNumVisibleLines >> 1) - this.mFontHeight;
        graphics.setFont(this.heavyFont);
        graphics.setColor(52479);
        graphics.drawRect(this.mCanvasX + 12, n - 3, this.mCanvasWidth - 24, this.mFontHeight);
        graphics.setClip(this.mCanvasX, n - this.mNumVisibleLines * this.mFontHeight + this.mFontHeight, this.mCanvasWidth, this.mNumVisibleLines * this.mFontHeight);
        n -= this.mScrollDown;
        n += this.mFontHeight;
        for (int i = 0; i < this.mNumVisibleLines + 2; ++i) {
            String string = this.COLORNAMES[this.mColorsNameIndex[i + 2]];
            int n2 = this.mCanvasX + (this.mCanvasWidth - this.heavyFont.stringWidth(string) >> 1);
            graphics.setColor(COLORVALUES[this.mColorsIndex[i + 2]]);
            graphics.drawString(string, n2, n, 20);
            n -= this.mFontHeight;
        }
        graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
    }

    protected void initNextQuestion() {
        this.mNumColors = this.mDifficulty < 3 ? 2 : (this.mDifficulty < 6 ? 4 : 6);
        for (int i = 0; i < this.mNumVisibleLines + 4 - 1; ++i) {
            this.mColorsIndex[i] = this.mColorsIndex[i + 1];
            this.mColorsNameIndex[i] = this.mColorsNameIndex[i + 1];
        }
        this.newWord(this.mNumVisibleLines + 4 - 1);
        if (this.doScroll) {
            this.mScrollDown = this.mFontHeight;
            this.doScroll = false;
        }
    }

    protected int isCorrectAnswer(int n) {
        if (n != 0) {
            int n2 = Toolkit.getToolkitGameAction(n);
            if (n2 == 52 || n == 52) {
                this.pressButton(0, this.mColorsIndex[3] == this.mColorsNameIndex[3], true);
                if (this.mScrollDown != this.mFontHeight) {
                    this.doScroll = true;
                }
                if (this.mColorsIndex[3] == this.mColorsNameIndex[3]) {
                    this.registerParticle(Toolkit.getScreenWidth() >> 1, this.mCanvasY + this.mCanvasHeight - this.mFontHeight / 2 - 6);
                    return 0;
                }
                return 1;
            }
            if (n2 == 54 || n == 54) {
                this.pressButton(1, this.mColorsIndex[3] != this.mColorsNameIndex[3], true);
                if (this.mScrollDown != this.mFontHeight) {
                    this.doScroll = true;
                }
                if (this.mColorsIndex[3] != this.mColorsNameIndex[3]) {
                    this.registerParticle(Toolkit.getScreenWidth() >> 1, this.mCanvasY + this.mCanvasHeight - this.mFontHeight / 2 - 6);
                    return 0;
                }
                return 1;
            }
        }
        return 3;
    }
}

