/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class MiniStars
extends MiniGame {
    static final int SPRITE_BACKGROUND = 0;
    static final int SPRITE_CLOUD_BACKGROUND = 1;
    static final int SPRITE_CLOUD = 2;
    static final int SPRITE_BIGCLOUD = 3;
    static final int SPRITE_STAR = 4;
    static final int SPRITE_SMOKE = 5;
    static final int NUM_SPRITES = 6;
    static final int MAX_STARS = 3;
    static final int MAX_CLOUDS = 3;
    static final int MAX_TRACES = 15;
    int[] starX = new int[3];
    int[] starY = new int[3];
    int[] starSX = new int[3];
    int[] starSY = new int[3];
    int[][] traceX = new int[3][15];
    int[][] traceY = new int[3][15];
    int[] starCollisionX = new int[3];
    int[] cloudX = new int[3];
    int[] cloudY = new int[3];
    int numStars = 1;
    int numClouds = 3;
    static final int STATUS_SAMPLE = 1;
    static final int STATUS_SHOW = 2;
    static final int STATUS_HOLD = -1;
    int status;
    int traceTimer;
    boolean willHitUser;
    boolean willHitPrediction;
    boolean fakeKeyPress;
    int[] mColX = new int[3];
    int[] mColY = new int[3];
    int[] mColWidth = new int[3];
    int[] mColHeight = new int[3];
    static final int COL_STAR = 0;
    static final int COL_CLOUD = 0;

    public MiniStars(int n, int n2) {
        this.mBackground = new SpriteObject(SpriteObject.loadAnimation(655450), false);
        this.initialize(n, n2);
        this.createButtons(SpriteObject.loadAnimations(new int[]{655413, 589877, 589876}), SpriteObject.loadAnimations(new int[]{655415, 589879, 655361}));
        this.mSpritesPool = new SpriteObject[6];
        this.mSpritesPool[0] = new SpriteObject(SpriteObject.loadAnimation(131163), true);
        this.mSpritesPool[1] = new SpriteObject(SpriteObject.loadAnimation(131164), true);
        this.mSpritesPool[2] = new SpriteObject(SpriteObject.loadAnimation(131161), true);
        this.mSpritesPool[3] = new SpriteObject(SpriteObject.loadAnimation(131159), true);
        this.mSpritesPool[4] = new SpriteObject(SpriteObject.loadAnimation(131165), true);
        this.mSpritesPool[5] = new SpriteObject(SpriteObject.loadAnimation(131171), false);
        this.mSpritesPool[4].setAnimationFrame(0);
        short[] sArray = this.mSpritesPool[4].getCurrentAnimationData();
        int n3 = this.mSpritesPool[4].getCollisionBoxes();
        n3 += 2;
        this.mColX[0] = sArray[n3++];
        this.mColY[0] = sArray[n3++];
        this.mColWidth[0] = sArray[n3++];
        this.mColHeight[0] = sArray[n3++];
        this.mSpritesPool[2].setAnimationFrame(0);
        sArray = this.mSpritesPool[2].getCurrentAnimationData();
        n3 = this.mSpritesPool[2].getCollisionBoxes();
        n3 += 2;
        this.mColX[0] = sArray[n3++];
        this.mColY[0] = sArray[n3++];
        this.mColWidth[0] = sArray[n3++];
        this.mColHeight[0] = sArray[n3++];
    }

    public void updateGame(int n) {
        int n2;
        boolean bl = false;
        this.traceTimer += n;
        if (this.traceTimer > 100) {
            this.traceTimer -= 100;
            bl = true;
        }
        for (n2 = 0; n2 < this.numStars; ++n2) {
            if (this.status == 2) {
                int n3 = n2;
                this.starX[n3] = this.starX[n3] + this.starSX[n2] * n / 50;
                int n4 = n2;
                this.starY[n4] = this.starY[n4] + this.starSY[n2] * n / 50;
            } else {
                int n5 = n2;
                this.starX[n5] = this.starX[n5] + this.starSX[n2] * n / 250;
                int n6 = n2;
                this.starY[n6] = this.starY[n6] + this.starSY[n2] * n / 250;
                if (this.starY[n2] > 3 * (this.mCanvasHeight << 12) / 4) {
                    if (this.willHitPrediction) {
                        this.keyEvent(54, 0);
                    } else {
                        this.keyEvent(52, 0);
                    }
                }
            }
            if (this.starY[n2] > this.mCanvasHeight << 12) {
                this.fakeKeyPress = true;
                this.keyEvent(53, 0);
            }
            if (!bl) continue;
            for (int i = 14; i >= 1; --i) {
                this.traceX[n2][i] = this.traceX[n2][i - 1];
                this.traceY[n2][i] = this.traceY[n2][i - 1];
            }
            this.traceX[n2][0] = this.starX[n2] - this.starSX[n2] * n / 100;
            this.traceY[n2][0] = this.starY[n2] - this.starSY[n2] * n / 100;
            this.traceTimer = 0;
        }
        for (n2 = 0; n2 < 6; ++n2) {
            this.mSpritesPool[n2].logicUpdate(n);
        }
    }

    protected boolean checkAnswer(int n) {
        return true;
    }

    public void drawGame(Graphics graphics) {
        int n;
        int n2;
        int n3;
        graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
        this.mSpritesPool[0].draw(graphics, this.mCanvasX + 0, this.mCanvasY + this.mCanvasHeight - 0);
        this.mSpritesPool[1].draw(graphics, this.mCanvasX + 0, this.mCanvasY + this.mCanvasHeight - 0);
        graphics.setClip(this.mCanvasX, this.mCanvasY, this.mCanvasWidth, this.mCanvasHeight);
        for (n3 = 0; n3 < this.numStars; ++n3) {
            for (n2 = 14; n2 >= 0; --n2) {
                n = this.mCanvasX + (this.traceX[n3][n2] >> 12);
                int n4 = this.mCanvasY + (this.traceY[n3][n2] >> 12);
                if (this.traceX[n3][n2] == 0) continue;
                int n5 = n2 * 5 / 15;
                if (n5 >= 5) {
                    n5 = 4;
                }
                this.mSpritesPool[5].setAnimationFrame(n5);
                this.mSpritesPool[5].draw(graphics, n, n4);
            }
            n2 = this.mCanvasX + (this.starX[n3] >> 12);
            n = this.mCanvasY + (this.starY[n3] >> 12);
            this.mSpritesPool[4].draw(graphics, n2, n);
        }
        for (n3 = 0; n3 < this.numClouds; ++n3) {
            n2 = this.mCanvasX + (this.cloudX[n3] >> 12);
            n = this.mCanvasY + (this.cloudY[n3] >> 12);
            this.mSpritesPool[2].draw(graphics, n2, n);
        }
        graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
    }

    protected void initNextQuestion() {
        int n;
        int n2;
        int n3;
        this.numStars = this.mDifficulty / 5 + 1;
        if (this.numStars > 3) {
            this.numStars = 3;
        }
        this.status = 1;
        this.willHitPrediction = this.rndBin();
        for (n3 = 0; n3 < this.numStars; ++n3) {
            for (n2 = 14; n2 >= 0; --n2) {
                this.traceX[n3][n2] = 0;
            }
            n2 = this.mCanvasWidth / 4 + MiniStars.rnd(this.mCanvasWidth - this.mCanvasWidth / 2) << 12;
            n = 0;
            this.starX[n3] = n2;
            this.starY[n3] = n;
            this.starSX[n3] = this.starX[n3] > this.mCanvasWidth / 2 << 12 ? -MiniStars.rnd((this.mCanvasWidth << 12) / 18) : MiniStars.rnd((this.mCanvasWidth << 12) / 18);
            this.starSY[n3] = (this.mCanvasHeight << 12) / 16;
            while (n < (3 * this.mCanvasHeight << 12) / 4) {
                n2 += this.starSX[n3] * 50 / 100;
                if ((n += this.starSY[n3] * 50 / 100) < (3 * this.mCanvasHeight << 12) / 4) continue;
                this.starCollisionX[n3] = n2;
            }
        }
        n3 = 0;
        n2 = 0;
        for (n = 0; n < this.numClouds; ++n) {
            this.cloudX[n] = MiniStars.rnd(this.mCanvasWidth) << 12;
            this.cloudY[n] = this.mCanvasHeight * 3 / 4 << 12;
        }
        while (n3 == 0) {
            n = 0;
            n3 = !this.willHitPrediction ? 1 : 0;
            for (int i = 0; i < this.numClouds; ++i) {
                for (int j = 0; j < this.numStars; ++j) {
                    boolean bl = this.collision(this.willHitPrediction, 0, this.cloudX[i] >> 12, 0, this.starCollisionX[j] >> 12);
                    if (bl && !this.willHitPrediction) {
                        n3 = 0;
                        this.cloudX[i] = MiniStars.rnd(this.mCanvasWidth) << 12;
                    }
                    if (bl && this.willHitPrediction) {
                        n3 = 1;
                    }
                    if (bl || !this.willHitPrediction || n != 0) continue;
                    this.cloudX[i] = this.starCollisionX[j];
                    n = 1;
                }
            }
            if (++n2 <= 20) continue;
            this.willHitPrediction = !this.willHitPrediction;
            n2 = 0;
        }
    }

    public boolean collision(boolean bl, int n, int n2, int n3, int n4) {
        n2 += this.mColX[n];
        n4 += this.mColX[n3];
        int n5 = this.mColWidth[n];
        int n6 = this.mColWidth[n3];
        if (!bl) {
            int n7 = this.mColX[n] >> 1;
            n2 += n7;
            n5 -= n7 << 1;
            n7 = this.mColX[n3] >> 1;
            n4 += n7;
            n6 -= n7 << 1;
        } else {
            int n8 = this.mColX[n] >> 1;
            n2 -= n8;
            n5 += n8 << 1;
            n8 = this.mColX[n3] >> 1;
            n4 -= n8;
            n6 += n8 << 1;
        }
        return n4 <= n2 + n5 && n4 + n6 >= n2;
    }

    protected int isCorrectAnswer(int n) {
        if (n != 0) {
            int n2 = Toolkit.getToolkitGameAction(n);
            if (this.fakeKeyPress && n2 == 53) {
                this.fakeKeyPress = false;
                if (this.willHitUser == this.willHitPrediction) {
                    return 0;
                }
                return 1;
            }
            if (n2 == 52 || n == 52) {
                if (this.status == 1) {
                    this.willHitUser = true;
                    this.pressButton(0, this.willHitPrediction, true);
                    this.status = 2;
                }
            } else if ((n2 == 54 || n == 54) && this.status == 1) {
                this.pressButton(1, !this.willHitPrediction, true);
                this.willHitUser = false;
                this.status = 2;
            }
        }
        return 3;
    }
}

