/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;

public class blocksEngine {
    static final int SIZE_X = 10;
    static final int SIZE_Y = 15;
    public static final byte BLOCK_TYPE_EMPTY = 0;
    public static final byte BLOCK_TYPE_RED = 1;
    public static final byte BLOCK_TYPE_YELLOW = 2;
    public static final byte BLOCK_TYPE_BLUE = 3;
    public static final byte BLOCK_TYPE_PURPLE = 4;
    public static final byte BLOCK_TYPE_CYAN = 5;
    public static final byte BLOCK_TYPE_GREEN = 6;
    public static final byte BLOCK_TYPE_WILD = 7;
    public static final byte BLOCK_TYPE_BOOSTER = 8;
    public static final byte BLOCK_TYPE_BOMB = 9;
    public static final byte BLOCK_TYPE_NUM2 = 10;
    public static final byte BLOCK_TYPE_NUM3 = 11;
    public static final byte BLOCK_TYPE_NUM4 = 12;
    public static final byte BLOCK_TYPE_NUM5 = 13;
    public static final byte BLOCK_TYPE_NUM6 = 14;
    public static final int BLOCKS_NUM_TYPES = 15;
    public static final byte PARTICLE_TYPE_SPARKLE = 15;
    static final int SPARKLES_NUM_FRAMES = 3;
    public static final int BLOCKS_NUM_TYPES_REGULAR = 7;
    public static final int BLOCKS_NUM_TYPES_SPECIAL = 8;
    short[] in_match = new short[15];
    short[] out_match = new short[15];
    public short[][] block = new short[10][15];
    public static final short BLOCK_MASK_TYPE = 15;
    public static final short BLOCK_IMASK_TYPE = -16;
    public static final short BLOCK_MASK_ISSPECIAL = 8;
    public static final short BLOCK_MASK_MARK = 16384;
    public static final short BLOCK_IMASK_MARK = -16385;
    public static final short BLOCK_MASK_SCRATCH1 = 8192;
    public static final short BLOCK_IMASK_SCRATCH1 = -8193;
    public static final short BLOCK_MASK_SCRATCH2 = 4096;
    public static final short BLOCK_IMASK_SCRATCH2 = -4097;
    public static final short BLOCK_MASK_EXPAND = 2048;
    public static final short BLOCK_IMASK_EXPAND = -2049;
    public static final short BLOCK_MASK_POPULATE_MARK = 64;
    public static final short BLOCK_CLEAR = -30785;
    public short dirty;
    public int[] column_height = new int[10];
    public int width;
    public int block_count;
    int collapse_stage;
    public int cursor_x;
    public int cursor_y;
    static final short SPECIAL_MAX = 25;
    short[] special = new short[25];
    int special_next;
    public int marked_score;
    public int marked_count;
    public int marked_mult;
    public int marked_mult_blocks;
    public static Random rand = new Random();
    private static int shift_column = 0;
    public int bCount = 0;
    public int rCount = 0;
    public int yCount = 0;
    public boolean populating = false;

    public void writeField(DataOutputStream dataOutputStream) {
        try {
            int n;
            dataOutputStream.writeInt(this.cursor_x);
            dataOutputStream.writeInt(this.cursor_y);
            for (n = 0; n < this.column_height.length; ++n) {
                dataOutputStream.writeInt(this.column_height[n]);
            }
            dataOutputStream.writeInt(this.block_count);
            dataOutputStream.writeInt(this.width);
            for (n = 0; n < this.block.length; ++n) {
                for (int i = 0; i < 15; ++i) {
                    dataOutputStream.writeShort(this.block[n][i]);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void readField(DataInputStream dataInputStream) {
        try {
            int n;
            this.cursor_x = dataInputStream.readInt();
            this.cursor_y = dataInputStream.readInt();
            for (n = 0; n < this.column_height.length; ++n) {
                this.column_height[n] = dataInputStream.readInt();
            }
            this.block_count = dataInputStream.readInt();
            this.width = dataInputStream.readInt();
            for (n = 0; n < this.block.length; ++n) {
                for (int i = 0; i < 15; ++i) {
                    this.block[n][i] = dataInputStream.readShort();
                }
            }
            this.dirty = Short.MAX_VALUE;
            this.collapse_stage = 1;
            while (this.collapse()) {
            }
            this.moveCursor(this.cursor_x, this.cursor_y);
            this.mark();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    blocksEngine() {
        int n;
        this.in_match[0] = 0;
        this.out_match[0] = 0;
        for (n = 1; n <= 6; ++n) {
            this.in_match[n] = (short)(1 << n - 1);
            this.out_match[n] = this.in_match[n];
        }
        this.in_match[7] = -1;
        this.out_match[7] = -1;
        for (n = 8; n <= 14; ++n) {
            this.in_match[n] = -1;
            this.out_match[n] = 0;
        }
    }

    public void populate(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.populating = true;
        shift_column = 0;
        int n6 = n % 5;
        int n7 = n6 > 0 ? 1 : 0;
        int n8 = n6 > 0 ? 2 : 0;
        int n9 = (n6 - 1 & 3) < 2 ? 2 : n6;
        int n10 = n6 > 0 ? n6 - 1 & 3 : 0;
        int n11 = 0;
        n11 = destGame.timedMode ? 3 : (n < 15 ? n / 5 + 3 : 6);
        for (n5 = 0; n5 < 15; ++n5) {
            for (n4 = 0; n4 < 10; ++n4) {
                this.block[n4][n5] = (short)(0x40 | (rand.nextInt() & Integer.MAX_VALUE) % n11 + 1);
            }
        }
        for (n5 = n8; n5 <= n9; ++n5) {
            for (n4 = 0; n4 < n7; ++n4) {
                int n12;
                while ((this.block[n3 = (n2 = rand.nextInt() & Integer.MAX_VALUE) % 10][n12 = n2 % 15] & 0xF) >= 8) {
                }
                this.block[n3][n12] = (short)(0x40 | n5 + 8);
            }
        }
        for (n5 = 0; n5 < n10; ++n5) {
            while ((this.block[n2 = (n4 = rand.nextInt() & Integer.MAX_VALUE) % 10][n3 = n4 % 15] & 0xF) >= 8) {
            }
            this.block[n2][n3] = 72;
        }
        for (n5 = 0; n5 < 10; ++n5) {
            this.column_height[n5] = 15;
        }
        this.block_count = 150;
        this.width = 10;
        this.dirty = Short.MAX_VALUE;
        this.collapse_stage = 3;
        widgetField.fall_position = widgetField.field_starty + 11;
        widgetField.fall_time = 0L;
        widgetField.clock_last = System.currentTimeMillis();
    }

    public void repopulate(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        this.populating = true;
        int n9 = (10 - this.width) / 2;
        for (n8 = this.width - 1; n8 >= 0; --n8) {
            System.arraycopy(this.block[n8], 0, this.block[n8 + n9], 0, 15);
            this.column_height[n8 + n9] = this.column_height[n8];
        }
        for (n8 = n9 - 1; n8 >= 0; --n8) {
            for (n7 = 0; n7 < this.column_height[n8]; ++n7) {
                this.block[n8][n7] = 0;
            }
        }
        for (n8 = 0; n8 < 15; ++n8) {
            for (n7 = 0; n7 < 10; ++n7) {
                if (this.block[n7][n8] != 0) continue;
                this.block[n7][n8] = (short)(0x40 | (rand.nextInt() & Integer.MAX_VALUE) % 3 + 1);
            }
        }
        n8 = 10;
        for (n7 = 0; n7 < n; ++n7) {
            while ((this.block[n6 = (n5 = rand.nextInt() & Integer.MAX_VALUE) % 10][n4 = n5 % 15] & 0x40) == 0 || (this.block[n6][n4] & 0xF) >= 8) {
            }
            this.block[n6][n4] = (short)(0x40 | n8);
            n8 = n8 == 14 ? 10 : (int)((short)(n8 + 1));
        }
        for (n7 = 0; n7 < n2; ++n7) {
            while ((this.block[n6 = (n5 = rand.nextInt() & Integer.MAX_VALUE) % 10][n4 = n5 % 15] & 0x40) == 0 || (this.block[n6][n4] & 0xF) >= 8) {
            }
            this.block[n6][n4] = 72;
        }
        for (n7 = 0; n7 < n3; ++n7) {
            while ((this.block[n6 = (n5 = rand.nextInt() & Integer.MAX_VALUE) % 10][n4 = n5 % 15] & 0x40) == 0 || (this.block[n6][n4] & 0xF) >= 8) {
            }
            this.block[n6][n4] = 73;
        }
        for (n7 = 0; n7 < 10; ++n7) {
            this.column_height[n7] = 15;
        }
        this.block_count = 150;
        this.width = 10;
        shift_column = 0;
        this.dirty = Short.MAX_VALUE;
        this.collapse_stage = 3;
        widgetField.fall_position = widgetField.field_starty + 11;
        widgetField.fall_time = 0L;
        widgetField.clock_last = System.currentTimeMillis();
    }

    public boolean moveCursor(int n, int n2) {
        int n3 = this.cursor_x + n;
        if (n3 < 0 || n3 >= this.width) {
            return false;
        }
        int n4 = this.cursor_y + n2;
        if (n4 < 0 || n4 >= 15) {
            return false;
        }
        this.cursor_x = n3;
        this.cursor_y = n4;
        short s = this.block[this.cursor_x][this.cursor_y];
        if ((s & 0x40) == 0 && ((s & 0x4000) == 0 || (s & 0x4800) == 18432 || (s & 8) != 0)) {
            this.mark();
        }
        return true;
    }

    public boolean remove(widgetField widgetField2) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.marked_count >= 2) {
            for (int i = 0; i < 10; ++i) {
                int n = 0;
                for (int j = 0; j < 15; ++j) {
                    short s = (short)(this.block[i][j] & 0x4000);
                    if (s == 0) continue;
                    short s2 = (short)(this.block[i][j] & 0xF);
                    if (s2 == 3) {
                        ++this.bCount;
                    } else if (s2 == 1) {
                        ++this.rCount;
                    } else if (s2 == 2) {
                        ++this.yCount;
                    }
                    if (s2 == 9) {
                        bl2 = true;
                        widgetField2.addBomb(i, j);
                    } else if (this.marked_score < 3000) {
                        widgetField2.explodeBlock(i, j, (short)(this.block[i][j] & 0xF));
                    } else {
                        int n2 = (rand.nextInt() & 3) - 1;
                        widgetField2.explodeBlock(i, j, (short)(15 + (n2 & 3)));
                    }
                    this.block[i][j] = 0;
                    ++n;
                }
                if (n <= 0) continue;
                this.dirty = (short)(this.dirty | 1 << i);
                bl = true;
                this.block_count -= n;
            }
            if (bl && bl2) {
                widgetField2.detonateBombs();
            }
            this.collapse_stage = 1;
        }
        return bl;
    }

    public boolean tallyRemove(widgetField widgetField2) {
        int n;
        int n2 = -1;
        int n3 = 0;
        for (n = 0; n < 10; ++n) {
            if (this.column_height[n] <= n3) continue;
            n2 = n;
            n3 = this.column_height[n];
        }
        if (n3 == 0) {
            return false;
        }
        n = this.column_height[n2] - 1;
        if (this.block[n2][n] != 0) {
            widgetField2.explodeBlock(n2, n, (short)(this.block[n2][n] & 0xF));
            this.block[n2][n] = 0;
            int n4 = n2;
            this.column_height[n4] = this.column_height[n4] - 1;
            --this.block_count;
            this.dirty = (short)(this.dirty | 1 << n2);
            return true;
        }
        return false;
    }

    public int tallyRemoveAll(widgetField widgetField2) {
        int n = 0;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < this.column_height[i]; ++j) {
                widgetField2.explodeBlock(i, j, (short)(this.block[i][j] & 0xF));
                this.block[i][j] = 0;
                ++n;
                --this.block_count;
            }
            this.column_height[i] = 0;
        }
        this.dirty = Short.MAX_VALUE;
        return n;
    }

    public boolean placeWild() {
        short s = (short)(this.block[this.cursor_x][this.cursor_y] & 0xF);
        if (s == 0 || s == 7) {
            return false;
        }
        this.block[this.cursor_x][this.cursor_y] = 7;
        this.dirty = (short)(this.dirty | 1 << this.cursor_x);
        this.mark();
        return true;
    }

    public boolean mark() {
        short s;
        int n;
        int n2;
        int n3;
        this.clearMarks();
        this.marked_count = 0;
        this.marked_mult = 1;
        this.special_next = 0;
        this.marked_mult_blocks = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.block[this.cursor_x][this.cursor_y] == 0) {
            return false;
        }
        this.doMark(this.cursor_x, this.cursor_y);
        if (this.special_next > 0 && this.marked_count >= 2) {
            for (n3 = 0; n3 < this.special_next; ++n3) {
                n2 = this.special[n3] >>> 8;
                n = this.special[n3] & 0xF;
                s = (short)(this.block[n2][n] & 0xF);
                if (s == 8) {
                    this.processBooster(n2, n);
                    ++n4;
                }
                if (s != 9) continue;
                this.processBomb(n2, n);
                ++n5;
            }
        }
        if (this.special_next > 0 && this.marked_count >= 2) {
            for (n3 = 0; n3 < this.special_next; ++n3) {
                n2 = this.special[n3] >>> 8;
                n = this.special[n3] & 0xF;
                s = (short)(this.block[n2][n] & 0xF);
                if (s < 10) continue;
                this.processNum(n2, n, s);
            }
        }
        if (this.marked_count >= 2) {
            this.marked_count += n4 + n5 + this.marked_mult_blocks;
        }
        this.marked_score = (this.marked_count - this.marked_mult_blocks) * (this.marked_count - this.marked_mult_blocks) * this.marked_mult;
        return true;
    }

    private void processBooster(int n, int n2) {
        short s;
        short[] sArray = this.block[n];
        int n3 = n2;
        sArray[n3] = (short)(sArray[n3] | 0x4000);
        for (n = 0; n < 10; ++n) {
            for (n2 = 0; n2 < this.column_height[n]; ++n2) {
                s = this.block[n][n2];
                if ((s & 0x4000) != 0) continue;
                int n4 = 0;
                if (n >= 1 && (this.block[n - 1][n2] & 0xF) < 9) {
                    n4 = (short)(n4 | this.block[n - 1][n2]);
                }
                if (n < 9 && (this.block[n + 1][n2] & 0xF) < 9) {
                    n4 = (short)(n4 | this.block[n + 1][n2]);
                }
                if (n2 >= 1 && (this.block[n][n2 - 1] & 0xF) < 9) {
                    n4 = (short)(n4 | this.block[n][n2 - 1]);
                }
                if (n2 < 14 && (this.block[n][n2 + 1] & 0xF) < 9) {
                    n4 = (short)(n4 | this.block[n][n2 + 1]);
                }
                if ((n4 & 0x4000) == 0) continue;
                short[] sArray2 = this.block[n];
                int n5 = n2;
                sArray2[n5] = (short)(sArray2[n5] | 0x2000);
                if ((s & 8) == 0) continue;
                this.addSpecial(n, n2);
            }
        }
        for (n = 0; n < 10; ++n) {
            for (n2 = 0; n2 < this.column_height[n]; ++n2) {
                s = this.block[n][n2];
                if ((s & 0x2000) == 0) continue;
                s = (short)(s & 0xFFFFDFFF);
                this.block[n][n2] = (short)(s | 0x4000 | 0x800);
                if ((s & 8) != 0) continue;
                ++this.marked_count;
            }
        }
    }

    private void processBomb(int n, int n2) {
        short[] sArray = this.block[n];
        int n3 = n2;
        sArray[n3] = (short)(sArray[n3] | 0x4000);
        this.expandBomb(n, n2, 0, 1);
        this.expandBomb(n, n2, 1, 1);
        this.expandBomb(n, n2, 1, 0);
        this.expandBomb(n, n2, 1, -1);
        this.expandBomb(n, n2, 0, -1);
        this.expandBomb(n, n2, -1, -1);
        this.expandBomb(n, n2, -1, 0);
        this.expandBomb(n, n2, -1, 1);
    }

    private void expandBomb(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        for (int i = 0; i < 2; ++i) {
            if ((n5 += n3) < 0 || n5 >= 10 || (n6 += n4) < 0 || n6 >= 15 || this.block[n5][n6] == 0) continue;
            if ((this.block[n5][n6] & 0x4000) == 0) {
                if ((this.block[n5][n6] & 8) != 0) {
                    this.addSpecial(n5, n6);
                } else {
                    ++this.marked_count;
                }
            }
            short[] sArray = this.block[n5];
            int n7 = n6;
            sArray[n7] = (short)(sArray[n7] | 0x4800);
        }
    }

    private void processNum(int n, int n2, short s) {
        int n3 = s - 10 + 2;
        if (this.marked_count >= n3) {
            short[] sArray = this.block[n];
            int n4 = n2;
            sArray[n4] = (short)(sArray[n4] | 0x4000);
            ++this.marked_mult_blocks;
            this.marked_mult = this.marked_mult > 1 ? (this.marked_mult += n3) : n3;
        }
    }

    private void doMark(int n, int n2) {
        short s = (short)(this.block[n][n2] & 0xF);
        if ((s & 8) != 0) {
            this.addSpecial(n, n2);
            return;
        }
        short[] sArray = this.block[n];
        int n3 = n2;
        sArray[n3] = (short)(sArray[n3] | 0x4000);
        ++this.marked_count;
        short s2 = this.out_match[s];
        if (n >= 1 && this.validMatch(s2, n - 1, n2)) {
            this.doMark(n - 1, n2);
        }
        if (n < 9 && this.validMatch(s2, n + 1, n2)) {
            this.doMark(n + 1, n2);
        }
        if (n2 >= 1 && this.validMatch(s2, n, n2 - 1)) {
            this.doMark(n, n2 - 1);
        }
        if (n2 < 14 && this.validMatch(s2, n, n2 + 1)) {
            this.doMark(n, n2 + 1);
        }
    }

    private boolean validMatch(short s, int n, int n2) {
        short s2 = this.block[n][n2];
        if ((s2 & 0x4000) != 0) {
            return false;
        }
        return (s & this.in_match[s2 & 0xF]) != 0;
    }

    private void addSpecial(int n, int n2) {
        if ((this.block[n][n2] & 0x1000) != 0) {
            return;
        }
        short[] sArray = this.block[n];
        int n3 = n2;
        sArray[n3] = (short)(sArray[n3] | 0x1000);
        this.special[this.special_next++] = (short)(n << 8 | n2);
    }

    public boolean hasPlay() {
        short s;
        short s2;
        int n;
        int n2;
        int n3;
        int n4 = this.width;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = this.column_height[n3] - 1;
            for (n = 0; n < n2; ++n) {
                s2 = (short)(this.block[n3][n] & 0xF);
                if ((s2 & 8) != 0 || ((s = (short)(this.block[n3][n + 1] & 0xF)) & 8) != 0 || (this.out_match[s2] & this.in_match[s]) == 0) continue;
                return true;
            }
        }
        n4 = this.width - 1;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = this.column_height[n3];
            for (n = 0; n < n2; ++n) {
                s2 = (short)(this.block[n3][n] & 0xF);
                if ((s2 & 8) != 0 || ((s = (short)(this.block[n3 + 1][n] & 0xF)) & 8) != 0 || (this.out_match[s2] & this.in_match[s]) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean collapse() {
        boolean bl = false;
        if (this.block_count <= 0) {
            return false;
        }
        switch (this.collapse_stage) {
            case 0: {
                return false;
            }
            case 1: {
                block6: for (int i = 0; i < this.width; ++i) {
                    int n = this.column_height[i];
                    if (n <= 0) continue;
                    for (int j = 0; j < n; ++j) {
                        short s = this.block[i][j];
                        if (s != 0) continue;
                        --n;
                        for (int k = j; k < n; ++k) {
                            this.block[i][k] = this.block[i][k + 1];
                        }
                        this.block[i][k] = 0;
                        this.column_height[i] = n;
                        this.dirty = this.column_height[i] >= 15 ? (short)Short.MAX_VALUE : (short)(this.dirty | 1 << i);
                        bl = true;
                        continue block6;
                    }
                }
                break;
            }
            case 2: {
                int n = this.width - 1;
                for (int i = 0; i < n; ++i) {
                    int n2;
                    if (this.column_height[i] > 0) continue;
                    for (n2 = i; n2 < n; ++n2) {
                        System.arraycopy(this.block[n2 + 1], 0, this.block[n2], 0, 15);
                        this.column_height[n2] = this.column_height[n2 + 1];
                    }
                    for (n2 = 0; n2 < 15; ++n2) {
                        this.block[n][n2] = 0;
                    }
                    this.column_height[n] = 0;
                    this.dirty = Short.MAX_VALUE;
                    bl = true;
                    break;
                }
                if (this.column_height[n] <= 0) {
                    --this.width;
                    ++shift_column;
                    this.dirty = Short.MAX_VALUE;
                }
                if (this.cursor_x < this.width) break;
                this.cursor_x = this.width - 1;
                break;
            }
            case 3: {
                if (!this.populating) break;
                this.dirty = Short.MAX_VALUE;
                bl = true;
            }
        }
        if (!bl) {
            ++this.collapse_stage;
            if (this.collapse_stage > 2 && this.collapse_stage < 4) {
                this.collapse_stage = 0;
                this.mark();
                return false;
            }
            if (this.collapse_stage > 3) {
                this.collapse_stage = 0;
                this.clearMarks();
                this.moveCursor(0, 0);
                return false;
            }
        }
        return this.collapse_stage != 0;
    }

    public short getBlockType(int n, int n2) {
        return (short)(this.block[n][n2] & 0xF);
    }

    private void clearMarks() {
        for (int i = 0; i < this.width; ++i) {
            int n = this.column_height[i];
            int n2 = 0;
            while (n2 < n) {
                short[] sArray = this.block[i];
                int n3 = n2++;
                sArray[n3] = (short)(sArray[n3] & 0xFFFF87BF);
            }
        }
    }

    public boolean isMarked(int n, int n2) {
        short s = this.block[n][n2];
        return (s & 0x4000) != 0;
    }

    public boolean isNew(int n, int n2) {
        short s = this.block[n][n2];
        return (s & 0x40) != 0;
    }

    public boolean markOnly(int n, int n2) {
        this.clearMarks();
        if (this.block[n][n2] == 0) {
            return false;
        }
        short[] sArray = this.block[n];
        int n3 = n2;
        sArray[n3] = (short)(sArray[n3] | 0x4000);
        return true;
    }

    public boolean removeOnly(int n, int n2, widgetField widgetField2) {
        short s = (short)(this.block[n][n2] & 0x4000);
        if (s != 0) {
            widgetField2.explodeBlock(n, n2, (short)(this.block[n][n2] & 0xF));
            this.block[n][n2] = 0;
            --this.block_count;
            return true;
        }
        return false;
    }

    public int getBlueCount() {
        int n = this.bCount;
        n = n * n * this.marked_mult;
        this.bCount = 0;
        return n;
    }

    public int getRedCount() {
        int n = this.rCount;
        n = n * n * this.marked_mult;
        this.rCount = 0;
        return n;
    }

    public int getYellowCount() {
        int n = this.yCount;
        n = n * n * this.marked_mult;
        this.yCount = 0;
        return n;
    }
}

