/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class korFont {
    public static final int KOR_FONT_ALIGN_LEFT = 0;
    public static final int KOR_FONT_ALIGN_CENTER = 1;
    public static final int KOR_FONT_ALIGN_RIGHT = 2;
    public static final int KOR_FONT_BASE_BASELINE = 0;
    public static final int KOR_FONT_BASE_IMAGETOP = 1;
    public static final int KOR_FONT_BASE_ASCENTTOP = 2;
    public static final int KOR_FONT_BASE_IMAGEBOTTOM = 3;
    public static final int KOR_FONT_BASE_CENTERED = 4;
    Image img;
    int font_version;
    int font_height;
    int font_width;
    int font_widest;
    int font_ascent;
    int font_descent;
    int font_baseline;
    int font_tracking;
    int tracking_adjust;
    short[] glyph = new short[256];
    byte[] glyph_width;
    int glyph_count;
    boolean fixed_width;
    static Hashtable fonts;

    public static void register(String string, korFont korFont2) {
        if (fonts == null) {
            fonts = new Hashtable();
        }
        fonts.put(string, korFont2);
    }

    public static void remove(String string) {
        fonts.remove(string);
    }

    public static korFont getFont(String string) {
        return (korFont)fonts.get(string);
    }

    public korFont(korImage korImage2) {
        this.img = korImage2.getImage();
        try {
            int n;
            DataInputStream dataInputStream = korImage2.getChunk(1716473428);
            this.font_version = dataInputStream.readUnsignedByte();
            this.font_height = dataInputStream.readUnsignedByte();
            this.font_tracking = dataInputStream.readByte();
            this.font_ascent = dataInputStream.readUnsignedByte();
            this.font_descent = dataInputStream.readUnsignedByte();
            this.font_baseline = this.font_height - this.font_descent - 1;
            int n2 = dataInputStream.readUnsignedByte();
            for (int i = 0; i < n2; ++i) {
                dataInputStream.readByte();
            }
            byte[] byArray = new byte[32];
            for (n = 4; n < 16; ++n) {
                byArray[n] = dataInputStream.readByte();
            }
            for (n = 20; n < 32; ++n) {
                byArray[n] = dataInputStream.readByte();
            }
            boolean bl = this.fixed_width = dataInputStream.readByte() == 1;
            if (this.fixed_width) {
                this.glyph_width = new byte[256];
                this.font_widest = n = (int)dataInputStream.readByte();
                this.glyph_width[0] = (byte)n;
                int n3 = 0;
                for (int n4 = 0; n4 < 256; n4 = (int)((short)(n4 + 1))) {
                    byte by = (byte)(128 >>> (n4 & 7));
                    if ((byArray[n4 >>> 3] & by) != by) continue;
                    this.glyph[n4] = (short)n3;
                    this.glyph_width[n4] = (byte)n;
                    n3 += n;
                    ++this.glyph_count;
                }
            } else {
                this.glyph_width = new byte[256];
                n = 0;
                this.font_widest = 0;
                for (int n5 = 0; n5 < 256; n5 = (int)((short)(n5 + 1))) {
                    byte by = (byte)(128 >>> (n5 & 7));
                    if ((byArray[n5 >>> 3] & by) != by) continue;
                    this.glyph[n5] = (short)n;
                    byte by2 = dataInputStream.readByte();
                    if (by2 > this.font_widest) {
                        this.font_widest = by2;
                    }
                    this.glyph_width[n5] = by2;
                    n += this.glyph_width[n5];
                    ++this.glyph_count;
                }
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.font_width = this.img.getWidth() / this.glyph_count;
    }

    public void setTrackingAdjustment(int n) {
        this.tracking_adjust = n;
    }

    public int getTrackingAdjustment() {
        return this.tracking_adjust;
    }

    public int getHeight() {
        return this.font_height;
    }

    public int getAscent() {
        return this.font_ascent;
    }

    public int getBaseline() {
        return this.font_baseline;
    }

    public int getWidth() {
        return this.font_width;
    }

    public int getWidest() {
        return this.font_widest;
    }

    public void drawString(Graphics graphics, int n, int n2, String string) {
        this.drawString(graphics, n, n2, string.toCharArray(), 0, string.length() - 1);
    }

    public void drawString(Graphics graphics, int n, int n2, String string, int n3) {
        char[] cArray = string.toCharArray();
        int n4 = string.length() - 1;
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                n -= this.getStringWidth(cArray, 0, n4) / 2;
                break;
            }
            case 2: {
                n -= this.getStringWidth(cArray, 0, n4);
            }
        }
        this.drawString(graphics, n, n2 -= this.font_baseline, cArray, 0, n4);
    }

    public void drawString(Graphics graphics, int n, int n2, String string, int n3, int n4) {
        switch (n4) {
            case 0: {
                break;
            }
            case 1: {
                n2 += this.font_baseline;
                break;
            }
            case 2: {
                n2 += this.font_ascent - 1;
                break;
            }
            case 3: {
                n2 -= this.font_descent;
                break;
            }
            case 4: {
                n2 += this.font_ascent / 2;
            }
        }
        this.drawString(graphics, n, n2, string, n3);
    }

    public void drawString(Graphics graphics, int n, int n2, char[] cArray, int n3, int n4) {
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        int n9 = this.font_height;
        int n10 = this.font_tracking + this.tracking_adjust;
        for (int i = n3; i <= n4; ++i) {
            char c = cArray[i];
            byte by = this.glyph_width[c];
            graphics.setClip(n, n2, (int)by, n9);
            graphics.drawImage(this.img, n - this.glyph[c], n2, 20);
            n += by + n10;
        }
        graphics.setClip(n5, n6, n7, n8);
    }

    public void drawMultilineText(Graphics graphics, int n, int n2, char[][] cArray, int n3, int n4, int n5) {
        int n6 = graphics.getClipX();
        int n7 = graphics.getClipY();
        int n8 = graphics.getClipWidth();
        int n9 = graphics.getClipHeight();
        int n10 = this.font_height;
        int n11 = this.font_tracking;
        int n12 = n4 + n5;
        int n13 = cArray.length;
        if (n12 > n13) {
            n12 = n13;
        }
        for (int i = n4; i < n12; ++i) {
            char[] cArray2 = cArray[i];
            if (cArray2 != null) {
                int n14 = cArray2.length - 1;
                int n15 = n;
                switch (n3) {
                    case 1: {
                        n15 -= this.getStringWidth(cArray2, 0, n14) / 2;
                        break;
                    }
                    case 2: {
                        n15 -= this.getStringWidth(cArray2, 0, n14);
                    }
                }
                for (int j = 0; j <= n14; ++j) {
                    char c = cArray2[j];
                    byte by = this.glyph_width[c];
                    graphics.setClip(n15, n2, (int)by, n10);
                    graphics.drawImage(this.img, n15 - this.glyph[c], n2, 20);
                    n15 += by + n11;
                }
            }
            n2 += this.font_height;
        }
        graphics.setClip(n6, n7, n8, n9);
    }

    public int getStringWidth(String string) {
        if (this.fixed_width) {
            return (string.length() - 1) * (this.glyph_width[0] + this.font_tracking + this.tracking_adjust) + this.glyph_width[0];
        }
        return this.getStringWidth(string.toCharArray(), 0, string.length() - 1);
    }

    public int getStringWidth(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = this.font_tracking + this.tracking_adjust;
        if (this.fixed_width) {
            n3 = (n2 - n) * (this.glyph_width[0] + n4) + this.glyph_width[0];
        } else {
            for (int i = n; i < n2; ++i) {
                n3 += this.glyph_width[cArray[i]] + n4;
            }
            n3 += this.glyph_width[cArray[n2]];
        }
        return n3;
    }

    public char[][] wrapString(String string, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        char[] cArray = string.toCharArray();
        int n6 = cArray.length;
        int n7 = 0;
        block0: while (n7 < n6) {
            n5 = n7;
            n4 = 0;
            for (n3 = n7; n3 < n6; ++n3) {
                if (cArray[n3] == '\n') {
                    n7 = n3 + 1;
                    continue block0;
                }
                while (cArray[n3] <= ' ' && ++n3 < n6) {
                }
                if (n3 >= n6) {
                    n7 = n6;
                    continue block0;
                }
                while (cArray[n3] > ' ' && ++n3 < n6) {
                }
                if (n3 >= n6) {
                    n7 = n6;
                }
                if (n4 + (n2 = this.getStringWidth(cArray, n5, --n3)) > n) {
                    cArray[n5] = 10;
                    n7 = n5 + 1;
                    continue block0;
                }
                n4 += n2;
                n5 = n3 + 1;
            }
        }
        n5 = 1;
        n3 = cArray.length - 1;
        for (n4 = 0; n4 < n3; ++n4) {
            if (cArray[n4] != '\n') continue;
            ++n5;
        }
        char[][] cArray2 = new char[n5][0];
        n2 = 0;
        int n8 = cArray.length;
        for (int i = 0; i < n5; ++i) {
            int n9;
            for (n9 = n2; n9 < n8 && cArray[n9] != '\n'; ++n9) {
            }
            int n10 = n9 - n2;
            if (n10 > 0) {
                char[] cArray3 = new char[n10];
                System.arraycopy(cArray, n2, cArray3, 0, n10);
                cArray2[i] = cArray3;
            }
            n2 = n9 + 1;
        }
        return cArray2;
    }
}

