/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class WorldPattern {
    private int[][] tiles = new int[9][3];
    private int[][] decor = new int[9][3];
    private int patternPaintX;
    private int patternPosX;
    private int iReturnPosition;
    private int iFrame;
    private int iPortalFrame;
    private int iTime;
    private int iCoinIdx;
    private boolean bHasGate = false;
    private boolean bLevelDone = false;
    private boolean bCheckpoint = false;
    private boolean bJumpPadActive = false;
    private int iGateIdx;
    private int iJumpPadIdx;
    private int iPileIndex;
    private int iTmpVal;
    private int _idx;
    private int iPortalType;
    private int iErrorPerc;
    private int iErrorPerc2;
    private int iIndex;
    private int iGateY;
    private int iPortalY;
    int coinFrame;
    int tmpPile;

    int getPosY(int val, int idx) {
        if (val >= 100) {
            return Resources.iGroundPosY - Resources.BLOCK_H * (9 - idx - 1) - (Resources.BLOCK_H >> 1) - (Resources.iPortalHeight >> 1);
        }
        if (val == 99) {
            return Resources.iGroundPosY - Resources.BLOCK_H * (9 - idx - 1) - Resources.iCoinH;
        }
        if (val == 47) {
            return Resources.iGroundPosY - Resources.BLOCK_H * (9 - idx - 2) - Resources.iLight1H - Resources.BLOCK_H;
        }
        if (val == 48) {
            return Resources.iGroundPosY - Resources.BLOCK_H * (9 - idx - 1) - Resources.iChainH;
        }
        if (val == 49) {
            return Resources.iGroundPosY - Resources.BLOCK_H * (9 - idx - 2) - Resources.iLight1H;
        }
        if (val == 50) {
            return Resources.iGroundPosY - Resources.BLOCK_H * (9 - idx - 1) - Resources.iJumpPadH;
        }
        if (val == 51) {
            return Resources.iGroundPosY - Resources.BLOCK_H * (9 - idx) + (Resources.BLOCK_H - Resources.iJumpPad2H >> 1);
        }
        if (val == 52) {
            return Resources.iGroundPosY - Resources.BLOCK_H * (9 - idx);
        }
        if (val == 10) {
            return Resources.iGroundPosY - Resources.BLOCK_H * (9 - idx);
        }
        if (val == 60) {
            return Resources.iGroundPosY - Resources.BLOCK_H * (9 - idx - 1) - Resources.iFakeSpikeH;
        }
        if (val == 70) {
            return Resources.iGroundPosY - Resources.BLOCK_H * (9 - idx - 1) - Resources.iFakeSpikeH;
        }
        return Resources.iGroundPosY - Resources.BLOCK_H * (9 - idx) + Resources.getPatternDiffH(this.tiles[idx][0]);
    }

    int getPosY2(int val, int idx) {
        if (val == -1) {
            return 0;
        }
        if (val == 47) {
            return 0;
        }
        if (val == 48) {
            return 0;
        }
        if (val == 49) {
            return 0;
        }
        if (val == 50) {
            return Resources.iJumpPadH;
        }
        if (val == 51) {
            return Resources.iJumpPad2H;
        }
        if (val == 52) {
            return Resources.iJumpPadH;
        }
        if (val == 60) {
            return 0;
        }
        if (val == 70) {
            return 0;
        }
        if (val == 99) {
            return Resources.iCoinH;
        }
        if (val >= 100) {
            return Resources.iPortalHeight;
        }
        return Resources.patternsH[this.tiles[idx][0]];
    }

    WorldPattern(byte[] arr, int from, int x) {
        this.patternPosX = x;
        this.bHasGate = false;
        this.bLevelDone = false;
        this.bCheckpoint = false;
        this.bJumpPadActive = false;
        this.iErrorPerc = 0;
        if (Defines.WIDTH == 480) {
            this.iErrorPerc = 21 * Resources.patternsH[16] / 100;
            this.iErrorPerc2 = 10 * Resources.BLOCK_H / 100;
        }
        for (int i = 0; i < 9; ++i) {
            this.tiles[i][0] = arr[from * 9 + i];
            this.decor[i][0] = -1;
            if (this.tiles[i][0] >= 100 && this.tiles[i][0] < 105) {
                this.iGateIdx = this.tiles[i][0];
                this.bHasGate = true;
                this.iPortalType = this.tiles[i][0] - 100;
            }
            if (this.tiles[i][0] == 105) {
                this.tiles[i][0] = -1;
                this.bLevelDone = true;
            }
            if (this.tiles[i][0] == 106) {
                this.bCheckpoint = true;
                this._idx = from - 2;
            }
            if (this.tiles[i][0] == 50 || this.tiles[i][0] == 52) {
                this.bJumpPadActive = true;
            }
            this._idx = from - 1;
            if (!this.idxIsDecor(this.tiles[i][0])) {
                this.tiles[i][1] = this.getPosY(this.tiles[i][0], i);
                this.tiles[i][2] = this.tiles[i][1] + this.getPosY2(this.tiles[i][0], i);
                if (this.tiles[i][0] >= 100) {
                    this.iGateY = this.tiles[i][1];
                }
            } else if (this.isMultiplePile(this.tiles[i][0])) {
                this.decor[i][0] = this.getFakePile(this.tiles[i][0]);
                this.tiles[i][0] = this.getRealPile(this.tiles[i][0]);
                this.tiles[i][1] = this.getPosY(this.tiles[i][0], i);
                this.tiles[i][2] = this.tiles[i][1] + this.getPosY2(this.tiles[i][0], i);
                this.decor[i][1] = this.getPosY(this.decor[i][0], i);
            } else if (this.isCoinWithBack(this.tiles[i][0])) {
                this.decor[i][0] = this.tiles[i][0] == 98 ? 3 : 22;
                this.decor[i][1] = this.getPosY(this.decor[i][0], i);
                this.tiles[i][0] = 99;
                this.tiles[i][1] = this.getPosY(this.tiles[i][0], i);
                this.tiles[i][2] = this.tiles[i][1] + this.getPosY2(this.tiles[i][0], i);
            } else {
                this.decor[i][0] = this.tiles[i][0];
                this.tiles[i][1] = this.getPosY(this.tiles[i][0], i);
                this.tiles[i][2] = this.tiles[i][1] + this.getPosY2(this.tiles[i][0], i);
                this.tiles[i][0] = -1;
                this.decor[i][1] = this.tiles[i][1];
            }
            if (this.tiles[i][0] == 51) {
                this.iJumpPadIdx = i;
            }
            if (this.tiles[i][0] != 99) continue;
            Globals.updateArrIndex();
        }
    }

    void updatePattern(byte[] arr, int from, int x) {
        this.patternPosX = x;
        this.bHasGate = false;
        this.bLevelDone = false;
        this.bCheckpoint = false;
        this.bJumpPadActive = false;
        for (int i = 0; i < 9; ++i) {
            this.tiles[i][0] = arr[from * 9 + i];
            this.decor[i][0] = -1;
            if (this.tiles[i][0] >= 100 && this.tiles[i][0] < 105) {
                this.iGateIdx = this.tiles[i][0];
                this.bHasGate = true;
                this.iPortalType = this.tiles[i][0] - 100;
            }
            if (this.tiles[i][0] == 105) {
                this.tiles[i][0] = -1;
                this.bLevelDone = true;
            }
            if (this.tiles[i][0] == 106) {
                this.bCheckpoint = true;
                this._idx = from - 2;
            }
            if (this.tiles[i][0] == 50 || this.tiles[i][0] == 52) {
                this.bJumpPadActive = true;
            }
            this._idx = from - 1;
            if (!this.idxIsDecor(this.tiles[i][0])) {
                this.tiles[i][1] = this.getPosY(this.tiles[i][0], i);
                this.tiles[i][2] = this.tiles[i][1] + this.getPosY2(this.tiles[i][0], i);
                if (this.tiles[i][0] >= 100) {
                    this.iGateY = this.tiles[i][1];
                }
            } else if (this.isMultiplePile(this.tiles[i][0])) {
                this.decor[i][0] = this.getFakePile(this.tiles[i][0]);
                this.tiles[i][0] = this.getRealPile(this.tiles[i][0]);
                this.tiles[i][1] = this.getPosY(this.tiles[i][0], i);
                this.tiles[i][2] = this.tiles[i][1] + this.getPosY2(this.tiles[i][0], i);
                this.decor[i][1] = this.getPosY(this.decor[i][0], i);
            } else if (this.isCoinWithBack(this.tiles[i][0])) {
                this.decor[i][0] = this.tiles[i][0] == 98 ? 3 : 22;
                this.decor[i][1] = this.getPosY(this.decor[i][0], i);
                this.tiles[i][0] = 99;
                this.tiles[i][1] = this.getPosY(this.tiles[i][0], i);
                this.tiles[i][2] = this.tiles[i][1] + this.getPosY2(this.tiles[i][0], i);
            } else {
                this.decor[i][0] = this.tiles[i][0];
                this.tiles[i][1] = this.getPosY(this.tiles[i][0], i);
                this.tiles[i][2] = this.tiles[i][1] + this.getPosY2(this.tiles[i][0], i);
                this.tiles[i][0] = -1;
                this.decor[i][1] = this.tiles[i][1];
            }
            if (this.tiles[i][0] == 51) {
                this.iJumpPadIdx = i;
            }
            if (this.tiles[i][0] != 99 || !Globals.updateArrIndex()) continue;
            this.tiles[i][0] = -1;
        }
    }

    void paint(Graphics g) {
        for (int i = 0; i < 9; ++i) {
            if (this.decor[i][0] == 49) {
                g.drawImage(Resources.imgLight1, this.patternPaintX + Resources.iLightDiff, this.decor[i][1] - Resources.iLight1H, 0);
            } else if (this.decor[i][0] == 47) {
                g.drawImage(Resources.imgLight2, this.patternPaintX + Resources.iLightDiff, this.decor[i][1], 0);
            } else if (this.decor[i][0] == 48) {
                g.drawImage(Resources.imgChain, this.patternPaintX + Resources.iChainDiff, this.decor[i][1], 0);
            } else if (this.decor[i][0] == 60) {
                Resources.sprFakeSpike.setFrame(0);
                Resources.sprFakeSpike.setPosition(this.patternPaintX, this.decor[i][1]);
                Resources.sprFakeSpike.paint(g);
            } else if (this.decor[i][0] == 70) {
                Resources.sprFakeSpike.setFrame(1);
                Resources.sprFakeSpike.setPosition(this.patternPaintX, this.decor[i][1]);
                Resources.sprFakeSpike.paint(g);
            } else if (this.decor[i][0] == 3) {
                g.drawImage(Resources.patterns[this.decor[i][0]], this.patternPaintX, this.decor[i][1], 0);
            } else if (this.decor[i][0] == 22) {
                g.drawImage(Resources.patterns[this.decor[i][0]], this.patternPaintX - 1, this.decor[i][1], 0);
            }
            if (this.tiles[i][0] == -1) continue;
            if (this.tiles[i][0] < 50) {
                g.drawImage(Resources.patterns[this.tiles[i][0]], this.tiles[i][0] > 10 ? this.patternPaintX - 1 : this.patternPaintX, this.tiles[i][1], 0);
                continue;
            }
            if (this.tiles[i][0] == 50) {
                Resources.sprJumpPad.setFrame(this.iFrame);
                Resources.sprJumpPad.setPosition(this.patternPaintX, this.tiles[i][1]);
                Resources.sprJumpPad.paint(g);
                continue;
            }
            if (this.tiles[i][0] == 51) {
                Resources.sprJumpPad2.setFrame(this.iFrame);
                Resources.sprJumpPad2.setPosition(this.patternPaintX + Resources.iJumpad2Col, this.tiles[i][1]);
                Resources.sprJumpPad2.paint(g);
                continue;
            }
            if (this.tiles[i][0] == 52) {
                Resources.sprJumpPadRot.setFrame(this.iFrame);
                Resources.sprJumpPadRot.setPosition(this.patternPaintX, this.tiles[i][1]);
                Resources.sprJumpPadRot.paint(g);
                continue;
            }
            if (this.tiles[i][0] == 99) {
                Resources.sprCoin.setFrame(this.coinFrame >> 1);
                Resources.sprCoin.setPosition(this.patternPaintX, this.tiles[i][1]);
                Resources.sprCoin.paint(g);
                if (++this.coinFrame <= 7) continue;
                this.coinFrame = 0;
                continue;
            }
            if (this.tiles[i][0] < 100) continue;
            Globals.bPoratlExist = true;
            this.iPortalY = this.tiles[i][1];
            this.paintPortal(g, this.patternPaintX, this.tiles[i][1]);
        }
    }

    void shiftPosX(int val) {
        this.patternPosX -= val;
    }

    void updatePosX(int x) {
        this.patternPaintX = this.patternPosX - x;
    }

    boolean isOut() {
        return this.patternPosX <= -Resources.BLOCK_W;
    }

    boolean isInPattern(int x) {
        return x >= this.patternPaintX && x <= this.patternPaintX + Resources.BLOCK_W;
    }

    int inCollission(int iActY1, int iActY2, int iNxtY1, int iNxtY2, int iActPosY1, int iActPosY2, int iNxtPosY1, int iNxtPosY2, int iGravity) {
        if (iActY1 < 0 || iActY2 < 0 || iNxtY1 < 0 || iNxtY2 < 0 || iActY1 > 8 || iActY2 > 8 || iNxtY1 > 8 || iNxtY2 > 8) {
            return -1;
        }
        if (this.bHasGate) {
            return 8;
        }
        if (iActPosY1 > iNxtPosY1 && this.tiles[iNxtY1][0] == 1 && this.isInPxCollission(iActY1, iActPosY1, iActPosY2)) {
            this.iReturnPosition = this.tiles[iNxtY1][2];
            return 1;
        }
        if (this.tiles[iActY2][0] == 99) {
            if (this.isInPxCollission(iActY2, iActPosY1, iActPosY2)) {
                this.iReturnPosition = this.tiles[iActY2][2];
                this.iCoinIdx = iActY2;
                return 6;
            }
            return -1;
        }
        if (this.tiles[iNxtY2][0] == 99) {
            if (iNxtY2 > iActY2 && this.isInPxCollission(iNxtY2, iNxtPosY1, iNxtPosY2)) {
                this.iReturnPosition = this.tiles[iNxtY2][2];
                this.iCoinIdx = iNxtY2;
                return 6;
            }
            return -1;
        }
        if (this.tiles[iActY2][0] == 51 && this.isInPxCollission(iActY2, iActPosY1, iActPosY2)) {
            this.iReturnPosition = this.tiles[iActY2][2];
            this.iCoinIdx = iActY2;
            return 7;
        }
        if (this.tiles[iNxtY2][0] == 51) {
            if (iNxtY2 > iActY2 && this.isInPxCollission(iNxtY2, iNxtPosY1, iNxtPosY2)) {
                this.iReturnPosition = this.tiles[iNxtY2][2];
                this.iCoinIdx = iNxtY2;
                return 7;
            }
            return -1;
        }
        int n = this.iIndex = iGravity == 1 ? iActY2 : iActY1;
        if (this.tiles[this.iIndex][0] == 50 || this.tiles[this.iIndex][0] == 52) {
            if (this.isOnJumpPad(iActPosY1, iActPosY2, this.iIndex, iGravity)) {
                this.iReturnPosition = this.tiles[this.iIndex][2];
                return 5;
            }
            return -1;
        }
        int n2 = this.iIndex = iGravity == 1 ? iNxtY2 : iNxtY1;
        if (this.tiles[this.iIndex][0] == 50 || this.tiles[this.iIndex][0] == 52) {
            if (iNxtY2 > iActY2 && this.isOnJumpPad(iNxtPosY1, iNxtPosY2, this.iIndex, iGravity)) {
                this.iReturnPosition = this.tiles[this.iIndex][2];
                return 5;
            }
            return -1;
        }
        if (this.tiles[iActY1][0] == 50 || this.tiles[iActY1][0] == 52) {
            if (this.isOnJumpPad(iActPosY1, iActPosY2, iActY1, iGravity)) {
                this.iReturnPosition = this.tiles[iActY1][2];
                return 5;
            }
            return -1;
        }
        if (this.tiles[iActY1][0] != -1 && this.tiles[iActY1][0] != 3 && !this.isDecor(this.tiles[iActY1][0]) && this.tiles[iActY1][0] != 50 && this.tiles[iActY1][0] != 52 && this.isInPxCollission(iActY1, iActPosY1, iActPosY2)) {
            if (this.isRotatedPile(this.tiles[iActY1][0])) {
                return this.bHitPile(iActY1, iActPosY1, iActPosY2) ? 0 : -1;
            }
            return this.tiles[iActY1][0] == 51 ? 7 : 0;
        }
        if (this.tiles[iActY2][0] != -1 && this.tiles[iActY2][0] != 3 && !this.isDecor(this.tiles[iActY2][0]) && this.tiles[iActY2][0] != 50 && this.tiles[iActY2][0] != 52 && this.isInPxCollission(iActY2, iActPosY1, iActPosY2)) {
            if (this.isRotatedPile(this.tiles[iActY2][0])) {
                return this.bHitPile(iActY2, iActPosY1, iActPosY2) ? 0 : -1;
            }
            return this.tiles[iActY2][0] == 51 ? 7 : 0;
        }
        if (this.tiles[iActY1][0] == -1 && this.tiles[iActY2][0] == -1) {
            if (this.tiles[iNxtY1][0] != -1 && !this.isDecor(this.tiles[iNxtY1][0]) && iActPosY1 > iNxtPosY1) {
                this.iReturnPosition = this.tiles[iNxtY1][2];
                this.iPileIndex = this.tiles[iNxtY1][0];
                if (this.isPile(this.tiles[iNxtY1][0])) {
                    if (this.isInPxCollission(iActY1, iActPosY1, iActPosY2)) {
                        return 3;
                    }
                    return -1;
                }
                if (this.tiles[iNxtY1][0] == 10) {
                    return this.isInPxCollission(iActY1, iActPosY1, iActPosY2) ? 1 : -1;
                }
                return 1;
            }
            if (this.tiles[iNxtY2][0] != -1 && !this.isDecor(this.tiles[iNxtY2][0]) && this.tiles[iNxtY2][0] != 50 && this.tiles[iNxtY2][0] != 52) {
                this.iReturnPosition = this.tiles[iNxtY2][1];
                this.iPileIndex = this.tiles[iNxtY2][0];
                if (this.isPile(this.tiles[iNxtY2][0])) {
                    if (this.isInPxCollission(iNxtY2, iNxtPosY1, iNxtPosY2)) {
                        return 4;
                    }
                    return -1;
                }
                return 2;
            }
        }
        return -1;
    }

    boolean takeCoin() {
        if (this.iCoinIdx == -1) {
            return false;
        }
        this.tiles[this.iCoinIdx][0] = -1;
        this.iCoinIdx = -1;
        return true;
    }

    boolean isPile(int val) {
        return val >= Resources.PILE_IDX && val <= Resources.PILE_IDX + 8 || val == 28 || val == 29;
    }

    boolean hasInverseGround(int idx) {
        if (idx <= 0) {
            return true;
        }
        return this.tiles[idx - 1][0] != -1 && !this.isPile(this.tiles[idx - 1][0]);
    }

    boolean hasGround(int idx) {
        if (idx >= 8) {
            return true;
        }
        return this.tiles[idx + 1][0] != -1 && !this.isPile(this.tiles[idx + 1][0]);
    }

    int getPosition() {
        return this.iReturnPosition;
    }

    boolean isInPxCollission(int idx, int x1, int x2) {
        if (this.tiles[idx][0] == 16) {
            return x1 < this.tiles[idx][2] - this.iErrorPerc && x2 > this.tiles[idx][1];
        }
        return x1 < this.tiles[idx][2] && x2 > this.tiles[idx][1];
    }

    void updateAnimation(int tick) {
        if ((this.iTime += tick) > 50) {
            this.iTime -= 50;
            if (++this.iFrame > 3) {
                this.iFrame = 0;
            }
            if (++this.iPortalFrame > 2) {
                this.iPortalFrame = 0;
            }
        }
    }

    boolean isOnJumpPad(int y1, int y2, int idx, int gravity) {
        if (gravity == 1) {
            return y1 <= this.tiles[idx][2] && y2 >= this.tiles[idx][2] - Resources.iJumpadCol;
        }
        return y1 >= this.tiles[idx][1] && y1 <= this.tiles[idx][1] + Resources.iJumpadCol;
    }

    boolean isDecor(int val) {
        if (val == 99) {
            return true;
        }
        if (val == 51) {
            return true;
        }
        return val >= 100;
    }

    void deactivateGate() {
        this.bHasGate = false;
    }

    int getGateIdx() {
        return this.iGateIdx;
    }

    void deactivateJumpPad() {
        if (this.iJumpPadIdx == -1) {
            return;
        }
        if (this.tiles[this.iJumpPadIdx][0] == 51) {
            this.tiles[this.iJumpPadIdx][0] = -1;
            this.iJumpPadIdx = -1;
        }
    }

    int getMddleX() {
        return this.patternPaintX + (Resources.BLOCK_W >> 1);
    }

    int getPileIDx() {
        return this.iPileIndex;
    }

    boolean idxIsDecor(int val) {
        if (val == 48) {
            return true;
        }
        if (val == 49) {
            return true;
        }
        if (val == 47) {
            return true;
        }
        if (val == 3) {
            return true;
        }
        if (val == 22) {
            return true;
        }
        if (val == 97) {
            return true;
        }
        if (val == 98) {
            return true;
        }
        return val >= 60 && val < 80;
    }

    boolean isOnlyFake(int val) {
        return val == 60 || val == 70;
    }

    boolean isMultiplePile(int val) {
        return (val >= 60 || val >= 70) && val < 80;
    }

    boolean isCoinWithBack(int val) {
        return val == 97 || val == 98;
    }

    int getRealPile(int val) {
        if (val >= 70) {
            this.tmpPile = val - 70;
        } else if (val >= 60) {
            this.tmpPile = val - 60;
        }
        if (this.tmpPile == 1) {
            this.tmpPile = 13;
        } else if (this.tmpPile == 2) {
            this.tmpPile = 14;
        } else if (this.tmpPile == 0) {
            this.tmpPile = -1;
        }
        return this.tmpPile;
    }

    int getFakePile(int val) {
        if (val >= 60) {
            return 60;
        }
        if (val >= 70) {
            return 70;
        }
        return -1;
    }

    void paintPortal(Graphics g, int x, int y) {
        Globals.iPortalPosX = x;
        Globals.iPortalPosY = y;
        this.paintPortalBottom(g, x, y);
    }

    void paintPortalBottom(Graphics g, int x, int y) {
        if (Resources.imgPortal != null) {
            g.drawImage(Resources.imgPortal, x, y, 0);
        }
    }

    void paintPortalUp(Graphics g, int x, int y) {
        this.paintPortalTop(g, x, y);
    }

    void paintPortalTop(Graphics g, int x, int y) {
        if (Resources.imgPortalTop != null) {
            g.drawImage(Resources.imgPortalTop, x, y, 0);
        }
        this.paintPortalLights(g, x, y);
    }

    void paintPortalLights(Graphics g, int x, int y) {
        for (int i = 0; i < 10; ++i) {
            Resources.sprDiods.setFrame(this.iPortalType << 1);
            Resources.sprDiods.setPosition(x + Resources.iLightsPos[i][0], y + Resources.iLightsPos[i][1]);
            Resources.sprDiods.paint(g);
        }
    }

    boolean hasLevelEndTag() {
        return this.bLevelDone;
    }

    boolean isCheckpoint() {
        return this.bCheckpoint;
    }

    int getIndex() {
        return this._idx;
    }

    boolean isJumpPadActive() {
        return this.bJumpPadActive;
    }

    void disableJumpPad() {
        this.bJumpPadActive = false;
    }

    boolean isRotatedPile(int val) {
        return val == 28 || val == 29;
    }

    boolean bHitPile(int idx, int y1, int y2) {
        return y1 < this.tiles[idx][2] - this.iErrorPerc && y2 > this.tiles[idx][1] + this.iErrorPerc;
    }

    int getGatePosY() {
        return this.iGateY + Resources.iPortalHeight2;
    }
}

