/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BmpFont {
    public short[] iSupChar;
    public short[] iSupCharXPos;
    public byte[] iSupCharWidth;
    public Image iImg;
    public int iHeight;
    public int iHSpacing;
    public int iMaxNumChrWidth;
    public int iMaxTxtChrWidth;
    public static final char KChrFormat = '\\';
    private byte[] abSupportedCharsWidth;
    private short[] asSupportedChars;
    private int iHorizontalSpacing;
    private static final char cChrFormat = '\\';

    public static short[] SortArray(short[] aArray, boolean aCreateIndexTable) {
        int i;
        short[] indexTable = null;
        if (aCreateIndexTable) {
            i = aArray.length;
            indexTable = new short[i];
            while (i-- != 0) {
                indexTable[i] = (short)i;
            }
        }
        for (i = 0; i < aArray.length - 1; ++i) {
            int j;
            int k = i;
            for (j = i + 1; j < aArray.length; ++j) {
                if (aArray[j] >= aArray[k]) continue;
                k = j;
            }
            j = aArray[k];
            aArray[k] = aArray[i];
            aArray[i] = (short)j;
            if (indexTable == null) continue;
            j = indexTable[k];
            indexTable[k] = indexTable[i];
            indexTable[i] = (short)j;
        }
        return indexTable;
    }

    public BmpFont(Image aImg, short[] aSupChar, short[] aSupCharXPos, byte[] aSupCharWidth, int aHSpacing, boolean aFastNumFont) {
        this.iImg = aImg;
        this.iHeight = aImg.getHeight();
        this.iHSpacing = aHSpacing;
        this.iSupChar = aSupChar;
        this.iSupCharXPos = aSupCharXPos;
        this.iSupCharWidth = aSupCharWidth;
        this.iMaxTxtChrWidth = 0;
        this.iMaxNumChrWidth = 0;
        if (!aFastNumFont) {
            short[] indexTable = BmpFont.SortArray(aSupChar, true);
            int i = indexTable.length;
            short[] chrXPos = new short[i];
            byte[] chrWidth = new byte[i];
            System.arraycopy(aSupCharXPos, 0, chrXPos, 0, i);
            System.arraycopy(aSupCharWidth, 0, chrWidth, 0, i);
            while (i-- != 0) {
                this.iSupCharXPos[i] = chrXPos[indexTable[i]];
                this.iSupCharWidth[i] = chrWidth[indexTable[i]];
            }
            i = this.iSupChar.length;
            while (i-- != 0) {
                int chrW = this.iSupCharWidth[i];
                short chr = this.iSupChar[i];
                if (chr < 48 || chr > 57) {
                    if (chrW <= this.iMaxTxtChrWidth) continue;
                    this.iMaxTxtChrWidth = chrW;
                    continue;
                }
                if (chrW <= this.iMaxNumChrWidth) continue;
                this.iMaxNumChrWidth = chrW;
            }
        } else {
            int i = this.iSupCharWidth.length;
            while (i-- != 0) {
                if (this.iSupCharWidth[i] <= this.iMaxNumChrWidth) continue;
                this.iMaxNumChrWidth = this.iSupCharWidth[i];
            }
        }
        this.iHorizontalSpacing = this.iHSpacing;
        this.abSupportedCharsWidth = aSupCharWidth;
        this.asSupportedChars = aSupChar;
    }

    public static int BinarySearchA(short[] aArray, short aKey) {
        int off = 0;
        int hi = aArray.length - 1;
        while (off <= hi) {
            int m = off + hi >>> 1;
            short v = aArray[m];
            if (v < aKey) {
                off = m + 1;
                continue;
            }
            if (v > aKey) {
                hi = m - 1;
                continue;
            }
            return m;
        }
        return ~off;
    }

    public int GetCharWidth(char aChar) {
        int i = BmpFont.BinarySearchA(this.iSupChar, (short)aChar);
        if (i >= 0) {
            return this.iSupCharWidth[i];
        }
        return 0;
    }

    public int GetTextWidth(String aText) {
        return this.GetTextWidth(aText, 0, aText.length());
    }

    public int GetTextWidth(String aText, int aFrom, int aLen) {
        int txtWidth = 0;
        while (aLen-- > 0) {
            short chr;
            if ((chr = (short)aText.charAt(aFrom++)) != 92) {
                int chrId = BmpFont.BinarySearchA(this.iSupChar, chr);
                if (chrId < 0) continue;
                txtWidth += this.iSupCharWidth[chrId] + this.iHSpacing;
                continue;
            }
            ++aFrom;
            --aLen;
        }
        return txtWidth - this.iHSpacing;
    }

    public int DrawText(Graphics aG, int aX, int aY, String aText) {
        return this.DrawText(aG, aX, aY, aText, 0, aText.length());
    }

    public static void BitBlt(Image aSrc, Graphics aDes, int aSrcX, int aSrcY, int aSrcW, int aSrcH, int aDesX, int aDesY) {
        aDes.setClip(aDesX, aDesY, aSrcW, aSrcH);
        aDes.drawImage(aSrc, aDesX - aSrcX, aDesY - aSrcY, 20);
    }

    public int DrawText(Graphics aG, int aX, int aY, String aText, int aFrom, int aLen) {
        int cY = aG.getClipY();
        int cH = aG.getClipHeight();
        int cX = aG.getClipX();
        int cW = aG.getClipWidth();
        int pos = aX;
        while (aLen-- > 0) {
            short chr;
            if ((chr = (short)aText.charAt(aFrom++)) != 92) {
                int chrId = BmpFont.BinarySearchA(this.iSupChar, chr);
                if (chrId < 0) continue;
                byte chrWidth = this.iSupCharWidth[chrId];
                if (chr != 32) {
                    BmpFont.BitBlt(this.iImg, aG, this.iSupCharXPos[chrId], 0, chrWidth, this.iHeight, pos, aY);
                }
                pos += chrWidth + this.iHSpacing;
                continue;
            }
            ++aFrom;
            --aLen;
        }
        aG.setClip(cX, cY, cW, cH);
        return pos;
    }

    public static void ConvertNum2FastNumFontArray(int aValue, byte[] aArray, int aOffset) {
        int pos = 1;
        do {
            aArray[aOffset + pos++] = (byte)(aValue % 10);
        } while ((aValue /= 10) != 0);
        aArray[0] = (byte)(aOffset + pos - 1);
    }

    public int GetFastNumFontArrayWidth(byte[] aArray) {
        int width = 0;
        int i = aArray[0];
        while (i-- != 0) {
            width += this.iSupCharWidth[aArray[1 + i]] + this.iHSpacing;
        }
        return width - this.iHSpacing;
    }

    public int getCharsWidth(char[] acText, int iFrom, int iLen) {
        int iTextWidth = 0;
        while (iLen-- > 0) {
            short sChar;
            if ((sChar = (short)acText[iFrom++]) != 92) {
                int iCharId = BmpFont.BinarySearchA(this.asSupportedChars, sChar);
                if (iCharId < 0) continue;
                iTextWidth += this.abSupportedCharsWidth[iCharId] + this.iHorizontalSpacing;
                continue;
            }
            ++iFrom;
            --iLen;
        }
        return iTextWidth - this.iHorizontalSpacing;
    }
}

