/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.rms.RecordStore;

public class Common {
    static final Random randGenerator = new Random();
    public static int iClipX;
    public static int iClipY;
    public static int iClipW;
    public static int iClipH;
    public static Class _class;
    static int[] SIN_TABLE;
    static int iGCCnt;

    static int SIN(long angle) {
        if ((angle %= 360L) < 0L) {
            angle = 360L + angle;
        }
        return SIN_TABLE[(int)angle];
    }

    static int COS(long angle) {
        return Common.SIN(angle += 90L);
    }

    static final int barValue(int value, int maxValue, int stretchVal) {
        return (value << 8 << 8) / (maxValue << 8) * (stretchVal << 8) >> 8 >> 8;
    }

    static final int getRandomInt(int max) {
        return randGenerator.nextInt() % max;
    }

    static final int getRandomUInt(int max) {
        if (max == 1) {
            return 0;
        }
        return Math.abs(randGenerator.nextInt() % max);
    }

    static final byte getRandomByte(int max) {
        return (byte)Math.abs(Common.getRandomInt(max));
    }

    static final void saveClipState(Graphics g) {
        iClipX = g.getClipX();
        iClipY = g.getClipY();
        iClipW = g.getClipWidth();
        iClipH = g.getClipHeight();
    }

    static final void restoreClipState(Graphics g) {
        g.setClip(iClipX, iClipY, iClipW, iClipH);
    }

    static final Image createImage(String imageName) {
        StringBuffer sbRes = new StringBuffer();
        sbRes.append(MainCanvas.strPrefixRes).append(imageName);
        Image RetVal = null;
        try {
            RetVal = Image.createImage((String)sbRes.toString());
        }
        catch (Throwable t) {
            Debug.trace("Common.createImage(" + imageName + ") exception : " + t.getMessage());
        }
        sbRes = null;
        System.gc();
        return RetVal;
    }

    static final Image createOther(String imageName) {
        StringBuffer sbRes = new StringBuffer();
        sbRes.append(MainCanvas.strPrefixResOther).append(imageName);
        Image RetVal = null;
        try {
            RetVal = Image.createImage((String)sbRes.toString());
        }
        catch (Throwable t) {
            Debug.trace("Common.createOther(" + imageName + ") exception : " + t.getMessage());
        }
        sbRes = null;
        System.gc();
        return RetVal;
    }

    static final Image createSplash(String imageName) {
        Image RetVal = null;
        try {
            RetVal = Image.createImage((String)imageName);
        }
        catch (Throwable t) {
            Debug.trace("Common.createImage(" + imageName + ") exception : " + t.getMessage());
        }
        System.gc();
        return RetVal;
    }

    static final Sprite createSprite(String fname, int slicesX, int slicesY) {
        Sprite RetVal = null;
        Image resImage = null;
        try {
            resImage = Common.createImage(fname);
            int sprWidth = resImage.getWidth() / slicesX;
            int sprHeight = resImage.getHeight() / slicesY;
            RetVal = new Sprite(resImage, sprWidth, sprHeight);
        }
        catch (Throwable t) {
            Debug.trace("Common.createSprite(" + fname + ", " + slicesX + ", " + slicesY + ") exception : " + t.getMessage());
            RetVal = null;
        }
        resImage = null;
        System.gc();
        return RetVal;
    }

    static final Sprite createOtherSprite(String fname, int slicesX, int slicesY) {
        Sprite RetVal = null;
        Image resImage = null;
        try {
            resImage = Common.createOther(fname);
            int sprWidth = resImage.getWidth() / slicesX;
            int sprHeight = resImage.getHeight() / slicesY;
            RetVal = new Sprite(resImage, sprWidth, sprHeight);
        }
        catch (Throwable t) {
            Debug.trace("Common.createSprite(" + fname + ", " + slicesX + ", " + slicesY + ") exception : " + t.getMessage());
            RetVal = null;
        }
        resImage = null;
        System.gc();
        return RetVal;
    }

    static final Sprite createSprite(Image resImage, int slicesX, int slicesY) {
        Sprite RetVal = null;
        try {
            int sprWidth = resImage.getWidth() / slicesX;
            int sprHeight = resImage.getHeight() / slicesY;
            RetVal = new Sprite(resImage, sprWidth, sprHeight);
        }
        catch (Throwable t) {
            RetVal = null;
        }
        return RetVal;
    }

    static final void deleteRecordStore(String rstoreName) {
        Debug.traceIn("> Common.deleteRecordStore(" + rstoreName + ")");
        try {
            RecordStore.deleteRecordStore((String)rstoreName);
        }
        catch (Exception e) {
            Debug.trace(e.getMessage());
        }
        Debug.traceOut("< Common.deleteRecordStore()");
    }

    static final boolean recordStoreExists(String rstoreName) {
        Debug.traceIn("> Common.recordStoreExists(" + rstoreName + ")");
        boolean bRetVal = true;
        try {
            RecordStore rsobj = RecordStore.openRecordStore((String)rstoreName, (boolean)false);
            rsobj.closeRecordStore();
        }
        catch (Exception e) {
            Debug.trace(e.getMessage());
            bRetVal = false;
        }
        Debug.traceOut("< Common.recordStoreExists() = " + bRetVal);
        return bRetVal;
    }

    static final void callGC() {
        if (++iGCCnt > 20) {
            iGCCnt = 0;
            System.gc();
        }
    }

    static {
        _class = null;
        SIN_TABLE = new int[]{0, 4, 8, 13, 17, 22, 26, 31, 35, 40, 44, 48, 53, 57, 61, 66, 70, 74, 79, 83, 87, 91, 95, 100, 104, 108, 112, 116, 120, 124, 127, 131, 135, 139, 143, 146, 150, 154, 157, 161, 164, 167, 171, 174, 177, 181, 184, 187, 190, 193, 196, 198, 201, 204, 207, 209, 212, 214, 217, 219, 221, 223, 226, 228, 230, 232, 233, 235, 237, 238, 240, 242, 243, 244, 246, 247, 248, 249, 250, 251, 252, 252, 253, 254, 254, 255, 255, 255, 255, 255, 256, 255, 255, 255, 255, 255, 254, 254, 253, 252, 252, 251, 250, 249, 248, 247, 246, 244, 243, 242, 240, 238, 237, 235, 233, 232, 230, 228, 226, 223, 221, 219, 217, 214, 212, 209, 207, 204, 201, 198, 196, 193, 190, 187, 184, 181, 177, 174, 171, 167, 164, 161, 157, 154, 150, 146, 143, 139, 135, 131, 127, 124, 120, 116, 112, 108, 104, 100, 95, 91, 87, 83, 79, 74, 70, 66, 61, 57, 53, 48, 44, 40, 35, 31, 26, 22, 17, 13, 8, 4, 0, -4, -8, -13, -17, -22, -26, -31, -35, -40, -44, -48, -53, -57, -61, -66, -70, -74, -79, -83, -87, -91, -95, -100, -104, -108, -112, -116, -120, -124, -127, -131, -135, -139, -143, -146, -150, -154, -157, -161, -164, -167, -171, -174, -177, -181, -184, -187, -190, -193, -196, -198, -201, -204, -207, -209, -212, -214, -217, -219, -221, -223, -226, -228, -230, -232, -233, -235, -237, -238, -240, -242, -243, -244, -246, -247, -248, -249, -250, -251, -252, -252, -253, -254, -254, -255, -255, -255, -255, -255, -256, -255, -255, -255, -255, -255, -254, -254, -253, -252, -252, -251, -250, -249, -248, -247, -246, -244, -243, -242, -240, -238, -237, -235, -233, -232, -230, -228, -226, -223, -221, -219, -217, -214, -212, -209, -207, -204, -201, -198, -196, -193, -190, -187, -184, -181, -177, -174, -171, -167, -164, -161, -157, -154, -150, -146, -143, -139, -135, -131, -128, -124, -120, -116, -112, -108, -104, -100, -95, -91, -87, -83, -79, -74, -70, -66, -61, -57, -53, -48, -44, -40, -35, -31, -26, -22, -17, -13, -8, -4};
        iGCCnt = 0;
    }
}

