/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.ResourceBundle;

public class Resources {
    private static String graphicsBaseDir = "/";
    private static String graphicsDisplayDir = "/";
    public static final int COLOR_BG = 0xFFFFFF;
    public static final int COLOR_FLASH = 0;
    public static final int IMG_ROTATE = 0;
    public static final int IMG_SPLASH = 1;
    public static final int IMG_INLOGIC = 2;
    public static final int IMG_FAIL = 3;
    public static final int IMG_WIN = 4;
    public static final int IMG_BG = 5;
    public static final int IMG_PAUSE = 6;
    public static final int IMG_CIRCLE = 7;
    public static final int IMG_CIRCLE_BG = 8;
    public static final int TOTAL_IMGS = 9;
    public static Image[] resImgs = new Image[9];
    public static final int SPR_LANGUAGE = 0;
    public static final int SPR_DIALOG = 1;
    public static final int SPR_DIALOG_GREEN = 2;
    public static final int SPR_DIALOG_RED = 3;
    public static final int SPR_ICONS_BIG = 4;
    public static final int SPR_ICONS = 5;
    public static final int SPR_ARROWS = 6;
    public static final int SPR_COVER_0 = 7;
    public static final int SPR_COVER_45 = 8;
    public static final int SPR_BUTTONS_BG = 9;
    public static final int SPR_BUTTONS_MENU = 10;
    public static final int SPR_DOTS_BG = 11;
    public static final int TOTAL_SPRS = 12;
    public static Sprite[] resSprs = new Sprite[12];
    public static final int GFONT_MAIN_1 = 0;
    public static final int TOTAL_GFONTS = 1;
    public static GFont[] resGFonts = new GFont[1];
    public static final int TEXT_MAIN = 0;
    public static final int TOTAL_TEXTS = 1;
    private static String langDir = "/";
    public static String langCode = "";
    public static ResourceBundle[] resTexts = new ResourceBundle[1];
    public static final int TEXT_MAIN_ENABLE_MUSIC_QUESTION = 2;
    public static final int TEXT_MAIN_MENU = 5;
    public static final int TEXT_MAIN_BACK = 6;
    public static final int TEXT_MAIN_VERSION = 17;
    public static final int TEXT_MAIN_EXIT_APP_QUESTION = 12;
    public static final int TEXT_MAIN_CONTINUE = 19;
    public static final int TEXT_MAIN_CONTROLS_TEXT_TOUCH = 26;
    public static final int TEXT_MAIN_CONTROLS_TEXT_KEYBOARD = 27;
    public static final int TEXT_MAIN_INSTRUCTIONS_TEXT = 8;
    public static final int TEXT_MAIN_RETRY = 54;
    public static final int TEXT_MAIN_INSTRUCTIONS = 36;
    public static final int TEXT_MAIN_ABOUT = 10;
    public static final int TEXT_MAIN_BACKTOMENU = 13;
    public static final int TEXT_MAIN_SOUND = 9;
    public static final int TEXT_MAIN_ON = 15;
    public static final int TEXT_MAIN_OFF = 16;
    public static final int TEXT_MAIN_LEVEL = 52;
    public static final int TEXT_MAIN_NEXTLEVEL = 53;
    public static final int TEXT_MAIN_GAMECOMPLETED = 55;
    public static boolean sysFont;

    public static void initGraphicsDirs(int width, int height) {
        graphicsBaseDir = "/";
        graphicsDisplayDir = "/";
    }

    public static Image createImage(String imgName) {
        Image image = null;
        try {
            System.out.println(imgName);
            image = Image.createImage((String)imgName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (image == null) {
            System.out.println("null");
        }
        return image;
    }

    public static Sprite createSprite(Image image, int slicesX, int slicesY) {
        Sprite sprite = null;
        try {
            int sprWidth = image.getWidth() / slicesX;
            int sprHeight = image.getHeight() / slicesY;
            sprite = new Sprite(image, sprWidth, sprHeight);
        }
        catch (Exception e) {
            sprite = null;
        }
        return sprite;
    }

    public static void loadImage(int imgIdx) {
        String imgPath = null;
        switch (imgIdx) {
            case 0: {
                imgPath = graphicsBaseDir + "rot.png";
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "logo.png";
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "I.png";
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "FAIL.png";
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "WIN.png";
                break;
            }
            case 5: {
                imgPath = graphicsDisplayDir + "game_bg.png";
                break;
            }
            case 6: {
                imgPath = graphicsBaseDir + "pause.png";
                break;
            }
            case 7: {
                imgPath = graphicsBaseDir + "circle.png";
                break;
            }
            case 8: {
                imgPath = graphicsBaseDir + "circle_bg.png";
                break;
            }
        }
        if (imgPath != null && resImgs[imgIdx] == null) {
            Resources.resImgs[imgIdx] = Resources.createImage(imgPath);
        }
    }

    public static void freeImage(int imgIdx) {
        Resources.resImgs[imgIdx] = null;
    }

    public static void loadImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.loadImage(imgsIdx[i]);
        }
    }

    public static void freeImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.resImgs[imgsIdx[i]] = null;
        }
    }

    public static void loadSprite(int sprIdx) {
        String imgPath = null;
        int slicesX = 1;
        int slicesY = 1;
        switch (sprIdx) {
            case 0: {
                imgPath = graphicsBaseDir + "language.png";
                slicesX = 4;
                slicesY = 3;
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "dialog_alpha.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "dialog_green.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "dialog_red.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 10: {
                imgPath = graphicsBaseDir + "buttons_menu.png";
                slicesX = 1;
                slicesY = 2;
                break;
            }
            case 11: {
                imgPath = graphicsBaseDir + "dots_bg.png";
                slicesX = 1;
                slicesY = 2;
                break;
            }
            case 5: {
                imgPath = graphicsBaseDir + "icons.png";
                slicesX = 12;
                slicesY = 1;
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "icons_big.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 6: {
                imgPath = graphicsBaseDir + "arows.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 7: {
                imgPath = graphicsBaseDir + "cover1.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 8: {
                imgPath = graphicsBaseDir + "cover2.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 9: {
                imgPath = graphicsBaseDir + "buttons_bg.png";
                slicesX = 3;
                slicesY = 1;
                break;
            }
        }
        if (imgPath != null && resSprs[sprIdx] == null) {
            Resources.resSprs[sprIdx] = Resources.createSprite(Resources.createImage(imgPath), slicesX, slicesY);
        }
    }

    public static void freeSprite(int sprIdx) {
        Resources.resSprs[sprIdx] = null;
    }

    public static void loadSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.loadSprite(sprsIdx[i]);
        }
    }

    public static void freeSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.resSprs[sprsIdx[i]] = null;
        }
    }

    private static GFont createGFontMain(Image gFontImg) {
        char[] fontChars = new char[]{'A', '\u00c6', 'B', 'C', 'D', '\u00d0', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', '\u00d8', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u011a', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u0130', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u010c', '\u011e', '\u015e', '\u00dd', '\u00df', '$', '\u00a3', '\u00a5', '#', '&', '*', '@', '\\', '\\', '\u20ac', '\u00a9', '\u00ae', '\u2122', '[', '(', '{', '}', ')', ']', '|', '%', '\u00b0', '<', '>', '+', '=', '\u00f7', '~', '^', '\u2019', '.', ',', ':', ';', '/', '/', '`', '\u201c', '!', '?', '\u00a1', '\u00bf', '_', '-', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 0;
        switch (gFontImg.getHeight()) {
            case 11: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{4, 4, 4, 4, 4, 4, 4, 4, 1, 3, 4, 3, 7, 4, 4, 4, 4, 4, 4, 3, 4, 4, 7, 4, 4, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 2, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 4, 4, 5, 5, 5, 5, 6, 2, 2, 5, 3, 5, 4, 3, 4, 3, 1, 2, 1, 2, 2, 3, 1, 4, 1, 4, 4, 3, 4, 2, 4, 4, 4, 4, 4, 3, 4, 4, 1};
                break;
            }
            case 13: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{5, 7, 5, 5, 5, 6, 5, 5, 5, 5, 2, 5, 5, 4, 7, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 7, 5, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 2, 2, 3, 3, 2, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 4, 5, 5, 6, 5, 5, 5, 5, 5, 6, 5, 7, 4, 4, 4, 7, 7, 8, 2, 3, 3, 3, 3, 2, 1, 7, 3, 3, 3, 5, 5, 5, 4, 5, 2, 1, 2, 1, 2, 4, 4, 2, 4, 1, 5, 1, 5, 6, 4, 4, 5, 5, 6, 5, 5, 5, 5, 5, 5};
                break;
            }
            case 16: {
                spaceBetweenChars = 2;
                fontCharsWidth = new short[]{9, 11, 7, 8, 8, 10, 6, 6, 9, 8, 3, 5, 8, 6, 10, 9, 10, 10, 7, 9, 7, 6, 7, 7, 8, 13, 7, 8, 8, 8, 8, 9, 8, 9, 9, 8, 7, 9, 6, 6, 6, 6, 6, 3, 3, 5, 4, 3, 6, 8, 9, 9, 10, 9, 10, 9, 8, 8, 8, 8, 7, 7, 7, 7, 6, 7, 8, 8, 9, 6, 8, 7, 6, 6, 8, 7, 9, 6, 10, 4, 4, 8, 9, 5, 8, 3, 3, 3, 3, 3, 3, 2, 11, 5, 8, 7, 7, 7, 7, 7, 8, 3, 3, 3, 2, 3, 4, 5, 3, 5, 3, 5, 2, 5, 7, 4, 4, 7, 6, 7, 7, 7, 7, 7, 7, 7};
                break;
            }
            case 21: {
                spaceBetweenChars = 3;
                fontCharsWidth = new short[]{11, 15, 9, 10, 11, 13, 8, 8, 11, 10, 3, 7, 10, 8, 13, 10, 12, 13, 9, 11, 8, 9, 9, 10, 10, 16, 10, 10, 10, 11, 11, 11, 10, 11, 11, 10, 10, 11, 8, 8, 8, 8, 8, 4, 4, 6, 5, 3, 8, 11, 10, 12, 12, 12, 12, 12, 10, 10, 10, 10, 10, 9, 9, 8, 8, 10, 9, 10, 11, 8, 10, 9, 8, 9, 8, 8, 11, 6, 12, 5, 5, 9, 11, 7, 11, 4, 4, 5, 4, 4, 4, 2, 15, 5, 9, 9, 10, 9, 9, 10, 9, 3, 3, 3, 3, 3, 5, 5, 3, 6, 3, 6, 3, 7, 9, 5, 5, 8, 8, 9, 8, 9, 8, 9, 8, 9};
                break;
            }
            case 24: {
                spaceBetweenChars = 3;
                fontCharsWidth = new short[]{12, 17, 10, 12, 12, 14, 9, 9, 12, 11, 4, 7, 11, 9, 16, 12, 14, 14, 10, 15, 9, 10, 12, 12, 12, 18, 11, 11, 11, 13, 13, 13, 13, 13, 13, 12, 11, 12, 9, 9, 9, 9, 9, 5, 5, 8, 6, 4, 9, 11, 12, 14, 14, 14, 14, 14, 11, 12, 11, 11, 12, 10, 10, 11, 10, 11, 11, 11, 12, 10, 12, 11, 9, 10, 11, 10, 13, 9, 15, 6, 7, 11, 14, 8, 13, 5, 5, 6, 6, 5, 5, 3, 17, 6, 11, 10, 11, 11, 11, 11, 11, 4, 3, 4, 4, 4, 7, 7, 4, 8, 3, 8, 4, 7, 10, 6, 6, 10, 9, 11, 10, 11, 9, 10, 11, 10};
                break;
            }
            case 32: {
                spaceBetweenChars = 3;
                fontCharsWidth = new short[]{17, 22, 14, 14, 16, 19, 12, 11, 17, 16, 4, 10, 15, 12, 21, 16, 18, 18, 13, 18, 14, 13, 15, 16, 17, 24, 16, 16, 15, 17, 16, 17, 17, 16, 17, 15, 15, 17, 12, 13, 12, 12, 12, 7, 7, 9, 9, 5, 11, 15, 17, 18, 18, 19, 18, 19, 15, 15, 16, 15, 16, 14, 14, 13, 13, 15, 15, 15, 17, 13, 16, 14, 12, 13, 15, 14, 17, 12, 19, 9, 9, 15, 18, 10, 17, 6, 6, 8, 7, 6, 6, 4, 22, 8, 14, 14, 15, 15, 15, 15, 14, 6, 5, 5, 5, 6, 9, 11, 5, 10, 5, 10, 4, 10, 15, 7, 8, 13, 13, 15, 13, 14, 13, 14, 13, 14};
                break;
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, (int)fontCharsWidth[0]);
    }

    public static void loadGFont(int gFontIdx) {
        Image gFontImg = null;
        if (resGFonts[gFontIdx] != null) {
            return;
        }
        switch (gFontIdx) {
            case 0: {
                gFontImg = Resources.createImage(graphicsBaseDir + "font.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontMain(gFontImg);
                break;
            }
        }
    }

    public static void freeGFont(int gFontIdx) {
        Resources.resGFonts[gFontIdx] = null;
    }

    public static void loadGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.loadGFont(gFontsIdx[i]);
        }
    }

    public static void freeGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.resGFonts[gFontsIdx[i]] = null;
        }
    }

    public static void initLangDirs(String langCode) {
        Resources.langCode = langCode;
        langDir = "/lang/" + langCode + "/";
        sysFont = langCode == "ru";
    }

    public static void loadText(int textIdx) {
        String textPath = null;
        switch (textIdx) {
            case 0: {
                textPath = langDir + "m.csr";
            }
        }
        Resources.resTexts[textIdx] = new ResourceBundle(X.singleton, textPath);
    }

    public static void freeText(int textIdx) {
        Resources.resTexts[textIdx] = null;
    }

    public static void freeAllResources() {
        int i;
        for (i = 0; i < resImgs.length; ++i) {
            Resources.resImgs[i] = null;
        }
        for (i = 0; i < resSprs.length; ++i) {
            Resources.resSprs[i] = null;
        }
        for (i = 0; i < resGFonts.length; ++i) {
            Resources.resGFonts[i] = null;
        }
    }
}

