/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.GameTile;
import sk.inlogic.Levels;
import sk.inlogic.Resources;
import sk.inlogic.rms.RMSHandler;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Particles;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Game
implements RMSHandler {
    private static final int _STATUS_INITLEVEL = 0;
    private static final int _STATUS_READY = 1;
    private static final int _STATUS_LEVELDONE = 2;
    private static final int _STATUS_GAMEOVER = 3;
    private static final int _MODE_CLASSIC = 0;
    private static final int _MODE_MAX_VALUE = 1;
    private static final int _MODE_MOVES = 2;
    private static final int _MODE_PUZZLE = 3;
    private static final int _MODE_SCORE = 4;
    private static final int _MODE_TIME = 5;
    public static final int _MOVE_NONE = 0;
    public static final int _MOVE_UP = 1;
    public static final int _MOVE_DOWN = 2;
    public static final int _MOVE_LEFT = 3;
    public static final int _MOVE_RIGHT = 4;
    public static final int _INPUT_FREE = 0;
    public static final int _INPUT_SELECT = 1;
    public static final int _INPUT_LUMP = 2;
    public static Rectangle _rectGameArea;
    private Rectangle _rectChar;
    private Rectangle[][] _rectWorld;
    private int _iGameMode;
    private int _iInputState;
    private int _iMaxTileValue;
    private int _iStatus;
    private int _iScore;
    private int _iTmpShift = 50;
    private int _iTmpPositionX = 0;
    private int _iTotalTiles = 0;
    private int _iTotalMovingTiles = 0;
    private int _iTotalWaitingTiles = 0;
    private int _iTotalCheckedTiles = 0;
    private int _iSelectorPosX = 0;
    private int _iSelectorPosY = 0;
    private int _iSelectorOffsetX = 0;
    private int _iSelectorOffsetY = 0;
    private int _iSteps = 0;
    private int _iSelectedType = -1;
    private int[] _iFirstGameSequence;
    private int[][] _iWorld;
    private int[][] _iScores;
    private boolean _bFirstTimeGame = true;
    private boolean _stsrtMoveLeft = false;
    private boolean _stsrtMoveRight = false;
    private boolean _bCheck = false;
    private Levels _lActuallevel;
    private GameTile[][] _gtGameTiles;
    private GameTile[] _selectedGameTiles;
    private Sprite _sprGameTileBg;
    private Sprite _sprSelector;
    private PreparedText _tapToStart;
    private PreparedText _ptNumber;
    private boolean _bLumpProgress = false;
    private boolean _bDownProgress = false;
    private boolean _bFillProgress = false;
    private boolean _bCheckGameOver = false;
    private int _iScoreInc = 0;
    private int _iScoreDelimiter = 2;
    private int _iLocalDownCheck = 0;
    int _iLocalFeelCheck = 0;
    private int _iCount = 0;
    private boolean _pressed = false;

    public Game() {
        this.init();
    }

    private void init() {
        this._sprGameTileBg = Resources.resSprs[13];
        this._sprSelector = Resources.resSprs[19];
        this._tapToStart = new PreparedText(Resources.resGFonts[0]);
        this._ptNumber = new PreparedText(Resources.resGFonts[0]);
        this._iSelectorOffsetX = this._sprGameTileBg.getWidth() - this._sprSelector.getWidth() >> 1;
        this._iSelectorOffsetY = this._sprGameTileBg.getHeight() - this._sprSelector.getHeight() >> 1;
        this._selectedGameTiles = new GameTile[0];
    }

    private void setGameMode() {
        this._iGameMode = this._lActuallevel._bModeMaxValue ? 1 : (this._lActuallevel._bModeMoves ? 2 : (this._lActuallevel._bModePuzzle ? 3 : (this._lActuallevel._bModeTime ? 5 : (this._lActuallevel._bModeScore ? 4 : 0))));
    }

    public void restartGame(Levels _levels, Rectangle _rectArea, int mode, boolean _bFirstTimePlaying) {
        this._lActuallevel = _levels;
        this._iTotalTiles = 0;
        this.setGameMode();
        this._bFirstTimeGame = _bFirstTimePlaying;
        this.init();
        this._iFirstGameSequence = new int[]{1, 3, 1, 2, 3, 3, 1, 1, 1, 2, 2, 1, 1, 1, 4, 3, 1, 2, 3, 2, 2, 3, 1, 2, 1};
        this._rectWorld = new Rectangle[this._lActuallevel._iTOTAL_COLS][this._lActuallevel._iTOTAL_ROWS];
        this._iWorld = new int[this._lActuallevel._iTOTAL_COLS][this._lActuallevel._iTOTAL_ROWS];
        this._iScores = new int[this._lActuallevel._iTOTAL_COLS][this._lActuallevel._iTOTAL_ROWS];
        this._iStatus = 0;
        _rectGameArea = _rectArea;
        this._gtGameTiles = new GameTile[this._lActuallevel._iTOTAL_COLS][this._lActuallevel._iTOTAL_ROWS];
        this.createWorld();
        this._iScore = 0;
        this._iStatus = 1;
        this._iInputState = 0;
        this._iMaxTileValue = 0;
        this._iSelectorPosX = 2;
        this._iSelectorPosY = 2;
    }

    private void createWorld() {
        int _iTmpIdxW = 0;
        for (int _iY = this._lActuallevel._iTOTAL_ROWS - 1; _iY >= 0; --_iY) {
            for (int _iX = 0; _iX < this._lActuallevel._iTOTAL_COLS; ++_iX) {
                this._iWorld[_iX][_iY] = this._lActuallevel._iWorld[_iTmpIdxW];
                ++_iTmpIdxW;
            }
        }
        int _iTmpIdx = 0;
        for (int _iY = this._lActuallevel._iTOTAL_ROWS - 1; _iY >= 0; --_iY) {
            for (int _iX = 0; _iX < this._lActuallevel._iTOTAL_COLS; ++_iX) {
                if (this.IsPosssibleGamePos(_iX, _iY)) {
                    this.createTile(_iX, _iY, this._lActuallevel._iGameTile[_iTmpIdx]);
                }
                ++_iTmpIdx;
            }
        }
    }

    private void createTile(int _iX, int _iY, int _iType) {
        this._gtGameTiles[_iX][_iY] = new GameTile(this, _rectGameArea);
        int _iTmpType = _iType;
        if (_iTmpType == 0) {
            _iTmpType = Math.abs(RandomNum.getRandomInt(this._lActuallevel._iStart_Number + this._lActuallevel._iGenerator_Range - 1, this._lActuallevel._iStart_Number));
        }
        this.SetMaxTileValue(_iTmpType);
        this._gtGameTiles[_iX][_iY].create(_iX, _iY, _iTmpType);
        ++this._iTotalTiles;
    }

    public void SetMaxTileValue(int _iType) {
        if (this._iMaxTileValue >= _iType) {
            return;
        }
        this._iMaxTileValue = _iType;
    }

    public boolean IsPosssibleGamePos(int _iX, int _iY) {
        if (!this.IsPossiblePosX(_iX)) {
            return false;
        }
        if (!this.IsPossiblePosY(_iY)) {
            return false;
        }
        return this._iWorld[_iX][_iY] == 0;
    }

    public boolean IsPossiblePosX(int _iX) {
        if (_iX < 0) {
            return false;
        }
        return _iX <= this._lActuallevel._iTOTAL_COLS - 1;
    }

    public boolean IsPossiblePosY(int _iY) {
        if (_iY < 0) {
            return false;
        }
        return _iY <= this._lActuallevel._iTOTAL_ROWS - 1;
    }

    public void update(long lastRunLenght) {
        if (this._iStatus == 1) {
            // empty if block
        }
        Particles.update();
        this.updateScore();
        if (this._bLumpProgress) {
            this.updateMove();
            return;
        }
        if (this._bDownProgress) {
            this.updateDown();
            return;
        }
        if (this._bFillProgress) {
            this.fillNewTile();
            return;
        }
        if (this._bCheckGameOver) {
            this._bCheckGameOver = !this._bCheckGameOver;
            this.IsPossibleCombination();
        }
        if (this._iStatus != 3) {
            if (this._stsrtMoveLeft) {
                // empty if block
            }
            if (this._stsrtMoveRight) {
                // empty if block
            }
        }
    }

    private void updateScore() {
        if (this._iScoreInc <= 0) {
            return;
        }
        if (this._iScoreInc > 0) {
            if (this._iScoreInc % this._iScoreDelimiter == 0) {
                this.incScoreLocal(this._iScoreInc / this._iScoreDelimiter);
                this._iScoreInc -= this._iScoreInc / this._iScoreDelimiter;
            } else {
                this.incScoreLocal(this._iScoreInc % this._iScoreDelimiter);
                this._iScoreInc -= this._iScoreInc % this._iScoreDelimiter;
            }
        }
    }

    private void incScore(int _iValue) {
        this._iScoreInc += _iValue;
    }

    private void incScoreLocal(int _iValue) {
        this._iScore += _iValue;
    }

    private void updateMove() {
        if (!this._bLumpProgress) {
            return;
        }
        System.out.println("updateMove");
        for (int _iIdx = 0; _iIdx < this._selectedGameTiles.length; ++_iIdx) {
            if (this._selectedGameTiles[_iIdx].GetOrder() != this._iSteps) continue;
            if (this._selectedGameTiles[_iIdx].IsEnable()) {
                this._selectedGameTiles[_iIdx].moveToCenter();
            }
            if (this._iSteps == 0) {
                this._selectedGameTiles[_iIdx].SetWarriorType();
                this.createParticles(_iIdx);
                this.createParticles(_iIdx);
                this.createParticles(_iIdx);
                this.createParticles(_iIdx);
                this.createParticles(_iIdx);
                this.createParticles(_iIdx);
                this.createParticles(_iIdx);
                this.createParticles(_iIdx);
                this._bLumpProgress = false;
                this._bDownProgress = true;
                this._iLocalDownCheck = 0;
                this._iLocalFeelCheck = 0;
            }
            if (this._iSteps >= 0) continue;
            this._bLumpProgress = false;
            this._bDownProgress = true;
            this._iLocalDownCheck = 0;
            this._iLocalFeelCheck = 0;
        }
        this.checkSteps();
    }

    public void createParticles(int _iIdx) {
        Particles.createParticle(this._selectedGameTiles[_iIdx].GetCenterX(), this._selectedGameTiles[_iIdx].GetCenterY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, this.getParticleColor(this._selectedGameTiles[_iIdx].GetWarriorType()), RandomNum.getRandomUInt(10) + 15, 0);
        Particles.createParticle(this._selectedGameTiles[_iIdx].GetCenterX(), this._selectedGameTiles[_iIdx].GetCenterY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, this.getParticleColor(this._selectedGameTiles[_iIdx].GetWarriorType()), RandomNum.getRandomUInt(10) + 15, 0);
        Particles.createParticle(this._selectedGameTiles[_iIdx].GetCenterX(), this._selectedGameTiles[_iIdx].GetCenterY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, this.getParticleColor(this._selectedGameTiles[_iIdx].GetWarriorType()), RandomNum.getRandomUInt(10) + 15, 0);
        Particles.createParticle(this._selectedGameTiles[_iIdx].GetCenterX(), this._selectedGameTiles[_iIdx].GetCenterY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, this.getParticleColor(this._selectedGameTiles[_iIdx].GetWarriorType()), RandomNum.getRandomUInt(10) + 15, 0);
        Particles.createParticle(this._selectedGameTiles[_iIdx].GetCenterX(), this._selectedGameTiles[_iIdx].GetCenterY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, this.getParticleColor(this._selectedGameTiles[_iIdx].GetWarriorType()), RandomNum.getRandomUInt(10) + 15, 0);
        Particles.createParticle(this._selectedGameTiles[_iIdx].GetCenterX(), this._selectedGameTiles[_iIdx].GetCenterY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, this.getParticleColor(this._selectedGameTiles[_iIdx].GetWarriorType()), RandomNum.getRandomUInt(10) + 15, 0);
        Particles.createParticle(this._selectedGameTiles[_iIdx].GetCenterX(), this._selectedGameTiles[_iIdx].GetCenterY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 20, 3, this.getParticleColor(this._selectedGameTiles[_iIdx].GetWarriorType()), RandomNum.getRandomUInt(10) + 15, 0);
        Particles.createParticle(this._selectedGameTiles[_iIdx].GetCenterX(), this._selectedGameTiles[_iIdx].GetCenterY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, this.getParticleColor(this._selectedGameTiles[_iIdx].GetWarriorType()), RandomNum.getRandomUInt(10) + 15, 0);
    }

    public int getParticleColor(int _iType) {
        switch (_iType) {
            case 1: {
                return 2782763;
            }
            case 2: {
                return 13148974;
            }
            case 3: {
                return 6335460;
            }
            case 4: {
                return 15623219;
            }
            case 5: {
                return 4875724;
            }
            case 6: {
                return 9125803;
            }
            case 7: {
                return 13977707;
            }
            case 8: {
                return 13554237;
            }
            case 9: {
                return 12397104;
            }
            case 10: {
                return 5680427;
            }
            case 11: {
                return 12707816;
            }
            case 12: {
                return 3623030;
            }
            case 13: {
                return 1314;
            }
        }
        return 1314;
    }

    private void updateDown() {
        System.out.println("updateDown");
        for (int _iY = this._lActuallevel._iTOTAL_ROWS - 1; _iY >= 0; --_iY) {
            for (int _iX = 0; _iX < this._lActuallevel._iTOTAL_COLS; ++_iX) {
                if (!this._gtGameTiles[_iX][_iY].IsEnable()) continue;
                this._gtGameTiles[_iX][_iY].updateFindDownPosition();
            }
        }
        ++this._iLocalDownCheck;
        if (this._iLocalDownCheck >= 5) {
            this._bDownProgress = false;
            this._bFillProgress = true;
        }
    }

    public void SwichTiles(int _iX1, int _iY1, int _iX2, int _iY2) {
        GameTile _gtTmp = this._gtGameTiles[_iX1][_iY1];
        GameTile _gtTmp2 = this._gtGameTiles[_iX2][_iY2];
        this._gtGameTiles[_iX2][_iY2] = _gtTmp;
        this._gtGameTiles[_iX1][_iY1] = _gtTmp2;
        this._gtGameTiles[_iX2][_iY2].SetX(_iX2);
        this._gtGameTiles[_iX2][_iY2].SetY(_iY2);
        this._gtGameTiles[_iX1][_iY1].SetX(_iX1);
        this._gtGameTiles[_iX1][_iY1].SetY(_iY1);
    }

    private void fillNewTile() {
        System.out.println("feelTile");
        int _iTmpY = 0;
        for (int _iX = 0; _iX < this._lActuallevel._iTOTAL_COLS; ++_iX) {
            if (this._gtGameTiles[_iX][_iTmpY] == null || this._gtGameTiles[_iX][_iTmpY].IsEnable()) continue;
            this._gtGameTiles[_iX][_iTmpY].Restart(_iX, _iTmpY, Math.abs(this.GetTileType()));
            this._iLocalDownCheck = 0;
            this._iLocalFeelCheck = 0;
            while (this._gtGameTiles[_iX][_iTmpY].updateFindDownPosition()) {
                System.out.println("Wait");
            }
        }
        ++this._iLocalFeelCheck;
        if (this._iLocalFeelCheck > 5) {
            this._bFillProgress = false;
            this._bCheckGameOver = true;
            this.clear();
        }
    }

    private void checkSteps() {
        for (int _iIdx = 0; _iIdx < this._selectedGameTiles.length; ++_iIdx) {
            if (this._selectedGameTiles[_iIdx].GetOrder() != this._iSteps || this._selectedGameTiles[_iIdx].IsEnable()) continue;
            --this._iSteps;
        }
        if (this._iSteps < 0) {
            this._iSteps = 0;
            this._iLocalDownCheck = 0;
            this._iLocalFeelCheck = 0;
        }
    }

    private boolean checkGameOver(int _iX, int _iY) {
        return false;
    }

    public void paint(Graphics g, int status) {
        this.paintWorld(g);
        this.paintGameTiles(g);
        this.paintSelector(g);
    }

    private void paintWorld(Graphics g) {
        int _iTmpIdx = 0;
        for (int _iY = this._lActuallevel._iTOTAL_ROWS - 1; _iY >= 0; --_iY) {
            for (int _iX = 0; _iX < this._lActuallevel._iTOTAL_COLS; ++_iX) {
                if (this._lActuallevel._iWorld[_iTmpIdx] < 0) {
                    ++_iTmpIdx;
                    continue;
                }
                if (_iTmpIdx % 2 == 0) {
                    this._sprGameTileBg.setFrame(1);
                    this._sprGameTileBg.setPosition(Game._rectGameArea.x + _iX * this._sprGameTileBg.getWidth(), Game._rectGameArea.y + _iY * this._sprGameTileBg.getHeight());
                    this._sprGameTileBg.paint(g);
                } else {
                    this._sprGameTileBg.setFrame(0);
                    this._sprGameTileBg.setPosition(Game._rectGameArea.x + _iX * this._sprGameTileBg.getWidth(), Game._rectGameArea.y + _iY * this._sprGameTileBg.getHeight());
                    this._sprGameTileBg.paint(g);
                }
                ++_iTmpIdx;
            }
        }
    }

    private void paintGameTiles(Graphics g) {
        for (int _iX = 0; _iX < this._lActuallevel._iTOTAL_COLS; ++_iX) {
            for (int _iY = 0; _iY < this._lActuallevel._iTOTAL_ROWS; ++_iY) {
                if (this._gtGameTiles[_iX][_iY] == null || !this._gtGameTiles[_iX][_iY].IsActive()) continue;
                this._gtGameTiles[_iX][_iY].paint(g);
            }
        }
        Particles.paint(g, 0);
    }

    private void paintSelector(Graphics g) {
        this._sprSelector.setFrame(0);
        this._sprSelector.setPosition(Game._rectGameArea.x + this._iSelectorPosX * this._sprGameTileBg.getWidth() + this._iSelectorOffsetX, Game._rectGameArea.y + this._iSelectorPosY * this._sprGameTileBg.getHeight() + this._iSelectorOffsetY);
    }

    public int GetTileType() {
        if (this._lActuallevel._iRange_Min != 0 && this._lActuallevel._iRange_Max != 0) {
            return RandomNum.getRandomInt(this._lActuallevel._iRange_Max, this._lActuallevel._iRange_Min);
        }
        int[] _iTileTypes = new int[]{1, 1, 1, 1, 1, 2, 2, 2, 3};
        if (this._iMaxTileValue == 4) {
            int _iIDx;
            _iTileTypes = new int[12];
            for (_iIDx = 0; _iIDx < 5; ++_iIDx) {
                _iTileTypes[_iIDx] = 1;
            }
            for (_iIDx = 5; _iIDx < 10; ++_iIDx) {
                _iTileTypes[_iIDx] = 2;
            }
            for (_iIDx = 10; _iIDx < 12; ++_iIDx) {
                _iTileTypes[_iIDx] = 3;
            }
        } else if (this._iMaxTileValue == 5) {
            int _iIDx;
            _iTileTypes = new int[15];
            for (_iIDx = 0; _iIDx < 5; ++_iIDx) {
                _iTileTypes[_iIDx] = 1;
            }
            for (_iIDx = 5; _iIDx < 10; ++_iIDx) {
                _iTileTypes[_iIDx] = 2;
            }
            for (_iIDx = 10; _iIDx < 14; ++_iIDx) {
                _iTileTypes[_iIDx] = 3;
            }
            _iTileTypes[14] = 4;
        } else if (this._iMaxTileValue == 6) {
            int _iIDx;
            _iTileTypes = new int[17];
            for (_iIDx = 0; _iIDx < 5; ++_iIDx) {
                _iTileTypes[_iIDx] = 1;
            }
            for (_iIDx = 5; _iIDx < 10; ++_iIDx) {
                _iTileTypes[_iIDx] = 2;
            }
            for (_iIDx = 10; _iIDx < 15; ++_iIDx) {
                _iTileTypes[_iIDx] = 3;
            }
            _iTileTypes[15] = 4;
            _iTileTypes[16] = 4;
        } else if (this._iMaxTileValue == 7) {
            int _iIDx;
            _iTileTypes = new int[18];
            for (_iIDx = 0; _iIDx < 3; ++_iIDx) {
                _iTileTypes[_iIDx] = 1;
            }
            for (_iIDx = 3; _iIDx < 8; ++_iIDx) {
                _iTileTypes[_iIDx] = 2;
            }
            for (_iIDx = 8; _iIDx < 13; ++_iIDx) {
                _iTileTypes[_iIDx] = 3;
            }
            for (_iIDx = 13; _iIDx < 17; ++_iIDx) {
                _iTileTypes[_iIDx] = 4;
            }
            _iTileTypes[17] = 5;
        } else if (this._iMaxTileValue == 8) {
            int _iIDx;
            _iTileTypes = new int[19];
            for (_iIDx = 0; _iIDx < 3; ++_iIDx) {
                _iTileTypes[_iIDx] = 1;
            }
            for (_iIDx = 3; _iIDx < 6; ++_iIDx) {
                _iTileTypes[_iIDx] = 2;
            }
            for (_iIDx = 6; _iIDx < 10; ++_iIDx) {
                _iTileTypes[_iIDx] = 3;
            }
            for (_iIDx = 10; _iIDx < 16; ++_iIDx) {
                _iTileTypes[_iIDx] = 4;
            }
            for (_iIDx = 16; _iIDx < 18; ++_iIDx) {
                _iTileTypes[_iIDx] = 5;
            }
            _iTileTypes[18] = 6;
        } else if (this._iMaxTileValue == 9) {
            int _iIDx;
            _iTileTypes = new int[20];
            for (_iIDx = 0; _iIDx < 3; ++_iIDx) {
                _iTileTypes[_iIDx] = 1;
            }
            for (_iIDx = 3; _iIDx < 6; ++_iIDx) {
                _iTileTypes[_iIDx] = 2;
            }
            for (_iIDx = 6; _iIDx < 10; ++_iIDx) {
                _iTileTypes[_iIDx] = 3;
            }
            for (_iIDx = 10; _iIDx < 16; ++_iIDx) {
                _iTileTypes[_iIDx] = 4;
            }
            for (_iIDx = 16; _iIDx < 18; ++_iIDx) {
                _iTileTypes[_iIDx] = 5;
            }
            _iTileTypes[18] = 6;
            _iTileTypes[19] = 7;
        } else if (this._iMaxTileValue == 10) {
            int _iIDx;
            _iTileTypes = new int[21];
            for (_iIDx = 0; _iIDx < 3; ++_iIDx) {
                _iTileTypes[_iIDx] = 1;
            }
            for (_iIDx = 3; _iIDx < 6; ++_iIDx) {
                _iTileTypes[_iIDx] = 2;
            }
            for (_iIDx = 6; _iIDx < 10; ++_iIDx) {
                _iTileTypes[_iIDx] = 3;
            }
            for (_iIDx = 10; _iIDx < 16; ++_iIDx) {
                _iTileTypes[_iIDx] = 4;
            }
            for (_iIDx = 16; _iIDx < 18; ++_iIDx) {
                _iTileTypes[_iIDx] = 5;
            }
            _iTileTypes[18] = 6;
            _iTileTypes[19] = 7;
            _iTileTypes[20] = 8;
        } else if (this._iMaxTileValue == 11) {
            int _iIDx;
            _iTileTypes = new int[22];
            for (_iIDx = 0; _iIDx < 3; ++_iIDx) {
                _iTileTypes[_iIDx] = 1;
            }
            for (_iIDx = 3; _iIDx < 6; ++_iIDx) {
                _iTileTypes[_iIDx] = 2;
            }
            for (_iIDx = 6; _iIDx < 10; ++_iIDx) {
                _iTileTypes[_iIDx] = 3;
            }
            for (_iIDx = 10; _iIDx < 16; ++_iIDx) {
                _iTileTypes[_iIDx] = 4;
            }
            for (_iIDx = 16; _iIDx < 18; ++_iIDx) {
                _iTileTypes[_iIDx] = 5;
            }
            _iTileTypes[18] = 6;
            _iTileTypes[19] = 7;
            _iTileTypes[20] = 8;
            _iTileTypes[21] = 9;
        } else if (this._iMaxTileValue == 12) {
            int _iIDx;
            _iTileTypes = new int[23];
            for (_iIDx = 0; _iIDx < 3; ++_iIDx) {
                _iTileTypes[_iIDx] = 1;
            }
            for (_iIDx = 3; _iIDx < 6; ++_iIDx) {
                _iTileTypes[_iIDx] = 2;
            }
            for (_iIDx = 6; _iIDx < 10; ++_iIDx) {
                _iTileTypes[_iIDx] = 3;
            }
            for (_iIDx = 10; _iIDx < 16; ++_iIDx) {
                _iTileTypes[_iIDx] = 4;
            }
            for (_iIDx = 16; _iIDx < 18; ++_iIDx) {
                _iTileTypes[_iIDx] = 5;
            }
            _iTileTypes[18] = 6;
            _iTileTypes[19] = 7;
            _iTileTypes[20] = 8;
            _iTileTypes[21] = 9;
            _iTileTypes[22] = 10;
        } else {
            return Math.abs(RandomNum.getRandomInt(this._iMaxTileValue, this._lActuallevel._iStart_Number));
        }
        System.out.println("_iTileTypes: " + (_iTileTypes.length - 1));
        return _iTileTypes[Math.abs(RandomNum.getRandomInt(_iTileTypes.length - 1, 0))];
    }

    public void selectTile(GameTile _scrTile) {
        this._selectedGameTiles = new GameTile[this._lActuallevel._iTOTAL_COLS * this._lActuallevel._iTOTAL_ROWS];
    }

    private boolean isTileOnArray(GameTile _scrTile) {
        for (int _iIDx = 0; _iIDx < this._selectedGameTiles.length; ++_iIDx) {
            if (this._selectedGameTiles[_iIDx] == null || this._selectedGameTiles[_iIDx].GetX() != _scrTile.GetX() || this._selectedGameTiles[_iIDx].GetY() != _scrTile.GetY() || this._selectedGameTiles[_iIDx].GetWarriorType() != _scrTile.GetWarriorType()) continue;
            return true;
        }
        return false;
    }

    public boolean prepareAroundTiles(int _iX, int _iY, int _iOrder) {
        if (this._gtGameTiles[_iX][_iY] == null) {
            return false;
        }
        if (this.IsTileChecked()) {
            return false;
        }
        int _iUpX = _iX;
        int _iUpY = _iY - 1;
        int _iDownX = _iX;
        int _iDownY = _iY + 1;
        int _iLeftX = _iX - 1;
        int _iLeftY = _iY;
        int _iRightX = _iX + 1;
        int _iRightY = _iY;
        if (this.IsPosssibleGamePos(_iUpX, _iUpY)) {
            this.checkThisTile(_iUpX, _iUpY, _iX, _iY, _iOrder);
        }
        if (this.IsPosssibleGamePos(_iDownX, _iDownY)) {
            this.checkThisTile(_iDownX, _iDownY, _iX, _iY, _iOrder);
        }
        if (this.IsPosssibleGamePos(_iLeftX, _iLeftY)) {
            this.checkThisTile(_iLeftX, _iLeftY, _iX, _iY, _iOrder);
        }
        if (this.IsPosssibleGamePos(_iRightX, _iRightY)) {
            this.checkThisTile(_iRightX, _iRightY, _iX, _iY, _iOrder);
        }
        return this._selectedGameTiles.length > 1;
    }

    private void checkThisTile(int _iX, int _iY, int _iParentX, int _iParentY, int _iOrder) {
        if (this._gtGameTiles[_iX][_iY] == null) {
            return;
        }
        if (!this.IsActiveGameTile(_iX, _iY)) {
            return;
        }
        if (this._gtGameTiles[_iX][_iY].GetWarriorType() != this._iSelectedType) {
            return;
        }
        if (this.isTileOnArray(this._gtGameTiles[_iX][_iY])) {
            return;
        }
        if (!this._gtGameTiles[_iX][_iY].IsChecked()) {
            this.AddSelectedTile(this._gtGameTiles[_iX][_iY]);
        }
        this._gtGameTiles[_iX][_iY].SetOrder(_iOrder + 1);
        this._gtGameTiles[_iX][_iY].SetParent(_iParentX, _iParentY);
        this.prepareAroundTiles(_iX, _iY, _iOrder + 1);
    }

    public boolean IsTileChecked() {
        for (int _iX = 0; _iX < this._lActuallevel._iTOTAL_COLS; ++_iX) {
            for (int _iY = 0; _iY < this._lActuallevel._iTOTAL_ROWS; ++_iY) {
                if (!this.IsPosssibleGamePos(_iX, _iY) || this._gtGameTiles[_iX][_iY] == null || !this._gtGameTiles[_iX][_iY].IsActive() || this._gtGameTiles[_iX][_iY].IsChecked()) continue;
                return false;
            }
        }
        return true;
    }

    public void AddSelectedTile(GameTile _scrTile) {
        int _iIdx;
        _scrTile.SetCheckedTile(true);
        if (this._selectedGameTiles.length >= 1 && this._selectedGameTiles[0].GetWarriorType() != _scrTile.GetWarriorType()) {
            return;
        }
        int _iLenght = this._selectedGameTiles.length + 1;
        GameTile[] _tmpGameTile = new GameTile[_iLenght];
        for (_iIdx = 0; _iIdx < this._selectedGameTiles.length; ++_iIdx) {
            _tmpGameTile[_iIdx] = this._selectedGameTiles[_iIdx];
        }
        _tmpGameTile[_iLenght - 1] = _scrTile;
        this._selectedGameTiles = new GameTile[_iLenght];
        for (_iIdx = 0; _iIdx < _tmpGameTile.length; ++_iIdx) {
            this._selectedGameTiles[_iIdx] = _tmpGameTile[_iIdx];
        }
    }

    public boolean IsActiveGameTile(int _iX, int _iY) {
        if (!this.IsPossiblePosX(_iX)) {
            return false;
        }
        if (!this.IsPossiblePosY(_iY)) {
            return false;
        }
        if (!this.IsPosssibleGamePos(_iX, _iY)) {
            return false;
        }
        if (this._gtGameTiles[_iX][_iY] == null) {
            return false;
        }
        return this._gtGameTiles[_iX][_iY].IsEnable();
    }

    public void GetTileInfo() {
        System.out.println("CALL TILE INFO");
        if (!this.IsPosssibleGamePos(this._iSelectorPosX, this._iSelectorPosY)) {
            return;
        }
        System.out.println("_gtGameTiles[_iSelectorPosX][_iSelectorPosY].GetX(): " + this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].GetX());
        System.out.println("_gtGameTiles[_iSelectorPosX][_iSelectorPosY].GetY(): " + this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].GetY());
        System.out.println("_gtGameTiles[_iSelectorPosX][_iSelectorPosY].GetWarriorType(): " + this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].GetWarriorType());
        System.out.println("_gtGameTiles[_iSelectorPosX][_iSelectorPosY].IsEnable(): " + this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].IsEnable());
        System.out.println("_gtGameTiles[_iSelectorPosX][_iSelectorPosY].GetName(): " + this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].GetName());
        System.out.println("_gtGameTiles[_iSelectorPosX][_iSelectorPosY].GetOrder(): " + this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].GetOrder());
        System.out.println("_gtGameTiles[_iSelectorPosX][_iSelectorPosY].IsRoot(): " + this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].IsRoot());
    }

    public void SelectTileTouch(int _iPosX, int _iPosY) {
        for (int _iX = 0; _iX < this._lActuallevel._iTOTAL_COLS; ++_iX) {
            for (int _iY = 0; _iY < this._lActuallevel._iTOTAL_ROWS; ++_iY) {
                Rectangle rect = new Rectangle(this._gtGameTiles[_iX][_iY].GetPostionX(), this._gtGameTiles[_iX][_iY].GetPostionY(), this._gtGameTiles[_iX][_iY].GetWidth(), this._gtGameTiles[_iX][_iY].GetHeight());
                if (!rect.contains(_iPosX, _iPosY)) continue;
                this._iSelectorPosX = this._gtGameTiles[_iX][_iY].GetX();
                this._iSelectorPosY = this._gtGameTiles[_iX][_iY].GetY();
                this.SelectTile();
                return;
            }
        }
    }

    public void SelectTile() {
        if (!this.IsEnableInput()) {
            return;
        }
        if (!this.IsPosssibleGamePos(this._iSelectorPosX, this._iSelectorPosY)) {
            return;
        }
        System.out.println(this._iSelectorPosX + "-x y-" + this._iSelectorPosY);
        if (this._iInputState == 0) {
            if (!this.isTileOnArray(this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY])) {
                this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].SetRoot(true);
                this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].SetOrder(0);
                this.AddSelectedTile(this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY]);
            }
            this._iSelectedType = this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].GetWarriorType();
            if (this.prepareAroundTiles(this._iSelectorPosX, this._iSelectorPosY, 0)) {
                for (int _iIdx = 0; _iIdx < this._selectedGameTiles.length; ++_iIdx) {
                    this._selectedGameTiles[_iIdx].Select();
                }
            }
            if (this._selectedGameTiles.length > 1) {
                this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].SetOrder(0);
                this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].SetRoot(true);
                this._iInputState = 1;
            } else {
                this.clear();
            }
        } else if (this._iInputState == 1) {
            if (this._selectedGameTiles[0].GetX() == this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].GetX() && this._selectedGameTiles[0].GetY() == this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].GetY() && this._selectedGameTiles[0].GetWarriorType() == this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].GetWarriorType()) {
                this.LumpTiles();
            } else if (this._selectedGameTiles[0].GetWarriorType() == this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].GetWarriorType()) {
                this.Unselect();
                this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].SetRoot(true);
                this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].SetOrder(0);
                this.AddSelectedTile(this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY]);
                this.prepareAroundTiles(this._iSelectorPosX, this._iSelectorPosY, 0);
            } else {
                this.Unselect();
                if (!this.isTileOnArray(this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY])) {
                    this.AddSelectedTile(this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY]);
                    this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].SetRoot(true);
                    this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].SetOrder(0);
                }
                this._iSelectedType = this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].GetWarriorType();
                if (this.prepareAroundTiles(this._iSelectorPosX, this._iSelectorPosY, 0)) {
                    for (int _iIdx = 0; _iIdx < this._selectedGameTiles.length; ++_iIdx) {
                        this._selectedGameTiles[_iIdx].Select();
                    }
                } else {
                    this._iInputState = 0;
                }
            }
        } else if (this._iInputState == 2) {
            // empty if block
        }
        this._iSelectedType = this._gtGameTiles[this._iSelectorPosX][this._iSelectorPosY].GetWarriorType();
    }

    private void LumpTiles() {
        System.out.println("call lump tiles");
        for (int _iIdx = 0; _iIdx < this._selectedGameTiles.length; ++_iIdx) {
            this._selectedGameTiles[_iIdx].SetFinalPositions();
            if (this._iSteps >= this._selectedGameTiles[_iIdx].GetOrder()) continue;
            this._iSteps = this._selectedGameTiles[_iIdx].GetOrder();
        }
        this.incScore(this._selectedGameTiles[0].GetWarriorType() * this._selectedGameTiles.length * 5);
        this._bLumpProgress = true;
        this._iInputState = 0;
    }

    public void Unselect() {
        for (int _iIdx = 0; _iIdx < this._selectedGameTiles.length; ++_iIdx) {
            this._selectedGameTiles[_iIdx].Unselect();
        }
        this._selectedGameTiles = new GameTile[0];
    }

    public void clear() {
        for (int _iIdx = 0; _iIdx < this._selectedGameTiles.length; ++_iIdx) {
            this._selectedGameTiles[_iIdx].Unselect();
        }
        this._selectedGameTiles = new GameTile[0];
        this._bLumpProgress = false;
        this._iInputState = 0;
    }

    private boolean IsEnableInput() {
        if (this._bCheckGameOver) {
            return false;
        }
        if (this._bLumpProgress) {
            return false;
        }
        if (this._bFillProgress) {
            return false;
        }
        return !this._bDownProgress;
    }

    public void MoveSelector(int _iNewPos) {
        switch (_iNewPos) {
            case 1: {
                this.moveSelectorDown();
                return;
            }
            case 2: {
                this.moveSelectorUp();
                return;
            }
            case 4: {
                this.moveSelectorRight();
                return;
            }
            case 3: {
                this.moveSelectorLeft();
                return;
            }
        }
    }

    private void moveSelectorUp() {
        if (this._iSelectorPosY + 1 < this._lActuallevel._iTOTAL_ROWS) {
            int _iIdy;
            for (_iIdy = this._iSelectorPosY + 1; _iIdy < this._lActuallevel._iTOTAL_ROWS; ++_iIdy) {
                if (!this.IsPosssibleGamePos(this._iSelectorPosX, _iIdy)) continue;
                this._iSelectorPosY = _iIdy;
                return;
            }
            for (_iIdy = 0; _iIdy < this._lActuallevel._iTOTAL_ROWS; ++_iIdy) {
                if (!this.IsPosssibleGamePos(this._iSelectorPosX, _iIdy)) continue;
                this._iSelectorPosY = _iIdy;
                return;
            }
        } else {
            for (int _iIdy = 0; _iIdy < this._lActuallevel._iTOTAL_ROWS; ++_iIdy) {
                if (!this.IsPosssibleGamePos(this._iSelectorPosX, _iIdy)) continue;
                this._iSelectorPosY = _iIdy;
                return;
            }
        }
    }

    private void moveSelectorDown() {
        if (this._iSelectorPosY - 1 >= 0) {
            int _iIdy;
            for (_iIdy = this._iSelectorPosY - 1; _iIdy >= 0; --_iIdy) {
                if (!this.IsPosssibleGamePos(this._iSelectorPosX, _iIdy)) continue;
                this._iSelectorPosY = _iIdy;
                return;
            }
            for (_iIdy = this._lActuallevel._iTOTAL_ROWS - 1; _iIdy >= 0; --_iIdy) {
                if (!this.IsPosssibleGamePos(this._iSelectorPosX, _iIdy)) continue;
                this._iSelectorPosY = _iIdy;
                return;
            }
        } else {
            for (int _iIdy = this._lActuallevel._iTOTAL_ROWS - 1; _iIdy >= 0; --_iIdy) {
                if (!this.IsPosssibleGamePos(this._iSelectorPosX, _iIdy)) continue;
                this._iSelectorPosY = _iIdy;
                return;
            }
        }
    }

    private void moveSelectorLeft() {
        if (this._iSelectorPosX - 1 >= 0) {
            int _iIdx;
            for (_iIdx = this._iSelectorPosX - 1; _iIdx >= 0; --_iIdx) {
                if (!this.IsPosssibleGamePos(_iIdx, this._iSelectorPosY)) continue;
                this._iSelectorPosX = _iIdx;
                return;
            }
            for (_iIdx = this._lActuallevel._iTOTAL_COLS - 1; _iIdx >= 0; --_iIdx) {
                if (!this.IsPosssibleGamePos(_iIdx, this._iSelectorPosY)) continue;
                this._iSelectorPosX = _iIdx;
                return;
            }
        } else {
            for (int _iIdx = this._lActuallevel._iTOTAL_COLS - 1; _iIdx >= 0; --_iIdx) {
                if (!this.IsPosssibleGamePos(_iIdx, this._iSelectorPosY)) continue;
                this._iSelectorPosX = _iIdx;
                return;
            }
        }
    }

    private void moveSelectorRight() {
        if (this._iSelectorPosX + 1 < this._lActuallevel._iTOTAL_COLS) {
            int _iIdx;
            for (_iIdx = this._iSelectorPosX + 1; _iIdx < this._lActuallevel._iTOTAL_COLS; ++_iIdx) {
                if (!this.IsPosssibleGamePos(_iIdx, this._iSelectorPosY)) continue;
                this._iSelectorPosX = _iIdx;
                return;
            }
            for (_iIdx = 0; _iIdx < this._lActuallevel._iTOTAL_COLS; ++_iIdx) {
                if (!this.IsPosssibleGamePos(_iIdx, this._iSelectorPosY)) continue;
                this._iSelectorPosX = _iIdx;
                return;
            }
        } else {
            for (int _iIdx = 0; _iIdx < this._lActuallevel._iTOTAL_COLS; ++_iIdx) {
                if (!this.IsPosssibleGamePos(_iIdx, this._iSelectorPosY)) continue;
                this._iSelectorPosX = _iIdx;
                return;
            }
        }
    }

    public GameTile[][] GetGameTiles() {
        return this._gtGameTiles;
    }

    public void AddCheckedTile() {
        ++this._iTotalCheckedTiles;
    }

    public void RemoveCheckedTile() {
        --this._iTotalCheckedTiles;
    }

    public void AddMovingTile() {
        ++this._iTotalMovingTiles;
    }

    public void RemoveMovingTile() {
        --this._iTotalMovingTiles;
    }

    public void AddWaitingTile() {
        ++this._iTotalWaitingTiles;
    }

    public void RemoveWaitingTile() {
        --this._iTotalWaitingTiles;
    }

    private void checkScore() {
    }

    public void rotate() {
        if (this._iStatus == 0) {
            this._iStatus = 1;
            return;
        }
    }

    public void DragOrDrop() {
    }

    public void releaaseControls() {
        this._pressed = false;
    }

    public void pointerPressed(int x, int y) {
        if (!this._pressed) {
            this._pressed = true;
            this.SelectTileTouch(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        if (this._pressed) {
            this._pressed = false;
        }
    }

    private boolean IsPossibleCombination() {
        if (this._iMaxTileValue == 13) {
            this._iStatus = 3;
            return false;
        }
        for (int _iX = 0; _iX < this._lActuallevel._iTOTAL_COLS; ++_iX) {
            for (int _iY = 0; _iY < this._lActuallevel._iTOTAL_ROWS; ++_iY) {
                if (!this.IsActiveGameTile(_iX, _iY)) continue;
                if (this.IsActiveGameTile(_iX + 1, _iY) && this._gtGameTiles[_iX][_iY].GetWarriorType() == this._gtGameTiles[_iX + 1][_iY].GetWarriorType()) {
                    return true;
                }
                if (this.IsActiveGameTile(_iX - 1, _iY) && this._gtGameTiles[_iX][_iY].GetWarriorType() == this._gtGameTiles[_iX - 1][_iY].GetWarriorType()) {
                    return true;
                }
                if (this.IsActiveGameTile(_iX, _iY + 1) && this._gtGameTiles[_iX][_iY].GetWarriorType() == this._gtGameTiles[_iX][_iY + 1].GetWarriorType()) {
                    return true;
                }
                if (!this.IsActiveGameTile(_iX, _iY - 1) || this._gtGameTiles[_iX][_iY].GetWarriorType() != this._gtGameTiles[_iX][_iY - 1].GetWarriorType()) continue;
                return true;
            }
        }
        this._iStatus = 3;
        return false;
    }

    public int GetMaxTile() {
        return this._iMaxTileValue;
    }

    public int getScore() {
        return this._iScore;
    }

    public boolean isGameOver() {
        return this._iStatus == 3;
    }

    public boolean isLevelDone() {
        return this._iStatus == 2;
    }

    public boolean isInitGame() {
        return this._iStatus == 0;
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
    }
}

