/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.DDMath;

public class MicroGame {
    public static int m_state;
    public static final int STATE_FINISHED = 0;
    public static final int STATE_WAITING_INPUT = 1;
    public static final int STATE_WAITING_TIMED_OUT = 2;
    public static final int STATE_PAUSED = 3;
    public static final int RESULT_PENDING = 0;
    public static final int RESULT_BAD = 1;
    public static final int RESULT_GOOD = 2;
    public static int m_type;
    public static final int TYPE_CATCH = 0;
    public static final int TYPE_THROW = 1;
    public static final int TYPE_BOWL = 2;
    public static final int TYPE_BAT = 3;
    private static final int ONE_UNIT_DURATION_IN_MS = 4;
    private static long m_timerLastFrame;
    private static long m_cumulativeDuration;
    private static long m_currentFrameDuration;
    private static long m_maximumDuration;
    public static final int TOTAL_MARKER_RANGE = 256;
    public static int[] m_markerPoints;
    public static int m_numMarkerPoints;
    public static int m_markerPosition;
    private static boolean m_markerPositionIncreasing;
    private static final int MOTION_CONTROL_SENSITIVITY = 2;
    public static final int MARKER_PEAK = 1;
    public static final int MARKER_TROUGH = 0;
    public static final int MICROGAME_MAX_MARKER_POINTS = 15;

    public static void oneTimeInit() {
        m_markerPoints = new int[30];
    }

    public static void init(int n2, int n3) {
        m_numMarkerPoints = 2;
        MicroGame.m_markerPoints[0] = 0;
        MicroGame.m_markerPoints[1] = 0;
        MicroGame.m_markerPoints[2] = 255;
        MicroGame.m_markerPoints[3] = 0;
        m_maximumDuration = n2 * 3 / 2;
        m_type = n3;
        MicroGame.setState(1);
        m_timerLastFrame = System.currentTimeMillis();
        m_currentFrameDuration = 0L;
        m_cumulativeDuration = 0L;
        m_markerPosition = 0;
    }

    public static void setEvenRanges(int n2, int n3) {
        int n4 = 0;
        m_numMarkerPoints = 2 + n2 * 4;
        if (m_numMarkerPoints < 2) {
            m_numMarkerPoints = 2;
        }
        MicroGame.m_markerPoints[n4 + 0] = 0;
        MicroGame.m_markerPoints[n4 + 1] = 0;
        n4 += 2;
        if (n2 > 0) {
            int n5 = 256 / n2;
            int n6 = n5 / 2;
            int n7 = (256 - n2 * (n3 * 2)) / (n2 * 4);
            int n8 = 0;
            while (n8 < n2) {
                MicroGame.m_markerPoints[n4 + 0] = n6 - n3 - n7;
                MicroGame.m_markerPoints[n4 + 1] = 0;
                MicroGame.m_markerPoints[(n4 += 2) + 0] = n6 - n3;
                MicroGame.m_markerPoints[n4 + 1] = 1;
                MicroGame.m_markerPoints[(n4 += 2) + 0] = n6 + n3;
                MicroGame.m_markerPoints[n4 + 1] = 1;
                MicroGame.m_markerPoints[(n4 += 2) + 0] = n6 + n3 + n7;
                MicroGame.m_markerPoints[n4 + 1] = 0;
                n4 += 2;
                ++n8;
                n6 += n5;
            }
        }
        MicroGame.m_markerPoints[n4 + 0] = 255;
        MicroGame.m_markerPoints[n4 + 1] = 0;
    }

    public static void updateTimeAllowed(int n2) {
        m_maximumDuration = n2;
        m_timerLastFrame = System.currentTimeMillis();
        m_currentFrameDuration = 0L;
        m_cumulativeDuration = 0L;
    }

    public static void resetTimeAllowed() {
        m_timerLastFrame = System.currentTimeMillis();
        m_currentFrameDuration = 0L;
        m_cumulativeDuration = 0L;
        m_markerPosition = 0;
    }

    public static void update() {
        if (m_state == 1) {
            m_currentFrameDuration = System.currentTimeMillis() - m_timerLastFrame;
            m_timerLastFrame = System.currentTimeMillis();
            if ((m_cumulativeDuration += m_currentFrameDuration) >= m_maximumDuration) {
                m_markerPosition = 0;
                MicroGame.setState(2);
                return;
            }
            MicroGame.updateMarker(m_currentFrameDuration);
        }
    }

    private static void updateMarker(long l2) {
        l2 /= 6L;
        if (m_markerPositionIncreasing) {
            if ((m_markerPosition = (int)((long)m_markerPosition + l2)) >= 256) {
                m_markerPosition = 255;
                m_markerPositionIncreasing = !m_markerPositionIncreasing;
            }
        } else if ((m_markerPosition = (int)((long)m_markerPosition - l2)) < 0) {
            m_markerPosition = 0;
            m_markerPositionIncreasing = !m_markerPositionIncreasing;
        }
    }

    public static void setAIResult(int n2) {
        m_markerPosition = n2 == 2 ? m_markerPoints[1] + m_markerPoints[2] >> 1 : m_markerPoints[2] + 5;
    }

    public static void setMark() {
        if (m_state == 1) {
            MicroGame.setState(0);
        }
    }

    public static void cancelMicroGame() {
        MicroGame.setState(2);
    }

    private static void setState(int n2) {
        m_state = n2;
    }

    public static int getResult() {
        if (m_state == 0) {
            if (MicroGame.markerPositionIsAccurate()) {
                return 2;
            }
            return 1;
        }
        if (m_state == 1 || m_state == 3) {
            return 0;
        }
        return 1;
    }

    public static boolean inProgress() {
        return m_state == 1;
    }

    private static boolean markerPositionIsAccurate() {
        for (int i2 = 0; i2 < m_numMarkerPoints - 1; ++i2) {
            if (m_markerPosition < m_markerPoints[i2 * 2] || m_markerPosition > m_markerPoints[(i2 + 1) * 2] || m_markerPoints[i2 * 2 + 1] != 1 || m_markerPoints[(i2 + 1) * 2 + 1] != 1) continue;
            return true;
        }
        return false;
    }

    public static int getMarkerAccuracy() {
        return MicroGame.getAccuracy(m_markerPosition);
    }

    public static int getNearestZone() {
        int n2 = 0;
        int n3 = 999;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        for (int i2 = 0; i2 < m_numMarkerPoints; ++i2) {
            if (m_markerPoints[i2 * 2 + 1] == 1) {
                bl = true;
                n2 = DDMath.abs(m_markerPosition - m_markerPoints[i2 * 2]);
                if (n2 >= n3) continue;
                n5 = n4;
                n3 = n2;
                continue;
            }
            if (!bl) continue;
            ++n4;
            bl = false;
        }
        return n5;
    }

    public static int getAccuracy(int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < m_numMarkerPoints) {
            if (n2 < m_markerPoints[n4 * 2]) {
                if (m_markerPoints[n4 * 2 + 1] == 1) {
                    if (m_markerPoints[n3 * 2 + 1] == 1) {
                        return 255;
                    }
                    int n5 = m_markerPoints[n4 * 2 + 0] - m_markerPoints[n3 * 2 + 0];
                    int n6 = n2 - m_markerPoints[n3 * 2 + 0];
                    int n7 = (n6 << 8) / n5;
                    return n7;
                }
                if (m_markerPoints[n3 * 2 + 1] == 1) {
                    int n8 = m_markerPoints[n4 * 2 + 0] - m_markerPoints[n3 * 2 + 0];
                    int n9 = m_markerPoints[n4 * 2 + 0] - n2;
                    int n10 = (n9 << 8) / n8;
                    return n10;
                }
                return 0;
            }
            n3 = n4++;
        }
        return 0;
    }

    public static int[] getMarkerRanges() {
        return m_markerPoints;
    }
}

