/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.DDDebug;
import com.ea.game.DDFile;
import com.ea.game.DDImage;
import com.ea.game.DDMath;
import com.ea.game.Game;
import com.ea.game.MainFrame;
import com.ea.game.MicroGame;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKMIDlet;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;

class XMLMenuSystem {
    private static final int G_LEFT = 4;
    private static final int G_RIGHT = 8;
    private static final int G_HCENTER = 1;
    private static final int G_VCENTER = 2;
    private static final int G_TOP = 16;
    private static final int G_BOTTOM = 32;
    private static final int RECT_SHADOWOFFSET = 1;
    private static final int MENU_MAX_FILENAME = 32;
    private static final int ACTION_LINK = 0;
    private static final int ACTION_LINKNOSAVE = 1;
    private static final int ACTION_RETURN = 2;
    private static final int ACTION_RETURNNOSAVE = 3;
    private static final int ACTION_INC = 4;
    private static final int ACTION_DEC = 5;
    private static final int ACTION_EXIT = 6;
    private static final int ACTION_STORETEXT = 7;
    private static final int ACTION_STOREMENU = 8;
    private static final int ACTION_STORENUMBER = 9;
    private static final int SCROLLVALUE_SCROLLINDEX = 0;
    private static final int SCROLLVALUE_SCROLLPOS = 1;
    private static final int SCROLLVALUE_SCROLLMAXNUMBER = 2;
    private static final int SCROLLVALUE_SCROLLMAXPOS = 3;
    private static final int SCROLLVALUE_SCROLLDATA = 4;
    private static final int SCROLLVALUE_SIZE = 5;
    private static final int SCROLLVALUE_XVALUES = 0;
    private static final int SCROLLVALUE_YVALUES = 5;
    private static final int XMLMENUDATA_OFFSET_MENUS = 2;
    private static final int XMLMENUDATA_OFFSET_CONTROLS = 4;
    private static final int XMLMENUDATA_OFFSET_ENTITY = 6;
    private static final int XMLMENUDATA_OFFSET_FONTS = 8;
    private static final int XMLMENUDATA_OFFSET_TEXT = 10;
    private static final int XMLMENUDATA_OFFSET_RESOURCES = 12;
    private static final int XMLMENUDATA_OFFSET_BREWRESOURCES = 14;
    private static final int XMLMENUDATA_OFFSET_STARTMENU = 16;
    private static final int XMLMENUDATA_OFFSET_MAXSTRING = 17;
    public static final int MENUID_FRONTEND = 1;
    public static final int MENUID_LANGSELECT = 2;
    public static final int MENUID_INGAME = 3;
    private static final int MENUENTITY_SPRITE = 1;
    private static final int MENUENTITY_IMAGE = 3;
    private static final int MENUENTITY_GRID = 4;
    private static final int MENUENTITY_RECT = 5;
    private static final int MENUENTITY_BAR = 6;
    private static final int MENUENTITY_TEXTLINE = 7;
    private static final int MENUENTITY_TEXTBLOCK = 8;
    private static final int MENUENTITY_HREP = 10;
    private static final int MENUENTITY_VREP = 11;
    private static final int MENUENTITY_TEXTNUMBER = 12;
    private static final int MENUENTITY_OWNERDRAW = 16;
    private static final char ARROW_LEFT = '<';
    private static final char ARROW_RIGHT = '>';
    private static final char ARROW_UP = '{';
    private static final char ARROW_DOWN = '}';
    private static final int TOUCH_ARROW_DOWN_OFFSET_Y = 62;
    public static final int TOUCH_FINGER_MARGIN = 0;
    private static final int LOADING_IMAGE_HEIGHT = 20;
    private static final int LOADING_COLOUR_BG = 0xFFFFFF;
    private static final int LOADING_COLOUR_BAR = 0;
    private static final int COLOUR_LINEUP_CURRENT = 15218230;
    private static final int COLOUR_LINEUP_BAR1 = 4288390;
    private static final int COLOUR_LINEUP_BAR2 = 3233127;
    private static final int COLOUR_LINEUP_GREYED = 1715510;
    private static final int COLOUR_LINEUP_MARKED = 12069932;
    private static final int COLOUR_FIXTURE_BAR = 15218230;
    private static final int COLOUR_LEAGUE_BAR1 = 4288390;
    private static final int COLOUR_LEAGUE_BAR2 = 3233127;
    public static long m_soundTimeout;
    public static int m_menuRefreshCount;
    public static int m_menuSystemId;
    private static StringBuffer m_filename1;
    private static StringBuffer m_filename2;
    private static byte[] m_compiledData;
    private static int m_compiledDataPos;
    private static int m_compiledDataActionPos;
    private static int m_compiledDataControls;
    private static int m_compiledDataObjects;
    private static int m_compiledDataFonts;
    private static int m_compiledMenuDataPos;
    private static byte[] m_entityData;
    private static short[] m_softKeyText;
    private static boolean m_delaySoftkeys;
    public static SDKString m_tempSDKString;
    private static char[] m_menuTempBytes;
    public static SDKGraphics m_menuGraphics;
    private static DDImage[] m_resourceImages;
    private static SDKImage m_scrollArrows;
    private static final short NEWLINE = 124;
    private static final boolean BYTE_TEXT_IDS = false;
    private static short[] m_menuTextBlockLineOffsets;
    private static int m_menuTextBlockCurrentLine;
    private static int m_menuTextBlockTotalLines;
    private static int m_menuTextBlockVisibleLines;
    private static int m_menuTextBlockCachedBlock;
    public static int[] m_globalArray;
    private static final int GLOBAL_ARRAY_LENGTH = 256;
    private static final int GLOBAL_OPTION_LANGUAGE = 0;
    private static final int GLOBAL_OPTION_SOUND = 1;
    private static final int GLOBAL_OPTION_VIBRATION = 2;
    private static final int GLOBAL_FIRST_RUN = 3;
    private static final int GLOBAL_OPTION_HAWKEYE = 4;
    public static int[] m_workArray;
    private static byte[] m_workRangeArray;
    private static int m_selection;
    private static int m_selectionNumber;
    private static boolean m_selected;
    private static int m_selectedActionDataPos;
    public static int m_prevMenu;
    public static int m_currMenu;
    private static int[] m_scrollValues;
    private static int[] m_posArray;
    private static final int POSARRAY_OBJECT_XPOS = 0;
    private static final int POSARRAY_OBJECT_YPOS = 1;
    private static final int POSARRAY_OBJECT_WIDTH = 2;
    private static final int POSARRAY_OBJECT_HEIGHT = 3;
    private static final int POSARRAY_CONTAINER_XPOS = 4;
    private static final int POSARRAY_CONTAINER_YPOS = 5;
    private static final int POSARRAY_CONTAINER_WIDTH = 6;
    private static final int POSARRAY_CONTAINER_HEIGHT = 7;
    private static boolean m_alphaEnabled;
    private static int m_horOffset;
    private static int m_verOffset;
    private static int m_offsetDraw;
    private static int m_tickerOff;
    private static SDKImage m_loadingImage;
    private static SDKGraphics m_loadingImageGraphics;
    private static int m_loadingFontHeight;
    private static int[] m_rgbArray;
    private static int m_flashCounter;
    public static boolean m_backFromGame;
    public static boolean m_musicLoadInterruped;
    private static int m_currentFontId;
    private static int m_currentPaletteId;
    private static int FONT_SMALL;
    private static int FONT_MEDIUM;
    private static int FONT_LARGE;
    private static int FONTPAL_DEFAULT;
    private static int FONTPAL_SELECTED_BUTTON;
    private static int FONTPAL_UNSELECTED_BUTTON;
    private static int FONTPAL_MOREGAMES;
    private static int FONTPAL_BLACK;
    private static boolean m_showLanguageSelect;
    private static final int RMS_ID_MENU = 99;
    private static final int NUM_SAVED_OPTIONS = 16;
    private static final int NUM_SAVED_HIGHSCORES = 0;
    private static final int RMS_BYTES_MENU = 16;
    private static final int MAX_CONTROLS = 32;
    private static int[][] m_controlInfo;
    private static int m_pointerPosX;
    private static int m_pointerPosY;
    private static int m_pointerDrag;
    public static boolean m_soundMenuRestart;
    public static int m_soundRestartCounter;
    private static int m_scrollUp;
    private static int m_scrollDown;
    public static int LSKposX;
    public static int RSKposX;
    public static int LSKRSKposY;
    private static final boolean DEVICE_TOUCHSCREEN = false;
    public static DDImage m_touchArrowsImage;
    public static int m_touchHeaderImageHeight;
    public static boolean dontLetToPointButton;
    public static int[] m_playerNameIds;
    public static final int[] m_playerNameIdsFull;
    public static final int[] m_playerNameIdsS40;
    private static int[][] LarrowCoords;
    private static int[][] RarrowCoords;
    private static int arrowsCoordsIndex;
    private static boolean touchUpArrow;
    private static boolean touchDownArrow;
    private static boolean touchLeftArrow;
    private static boolean touchRightArrow;

    XMLMenuSystem() {
    }

    public static boolean isSoundEnabled() {
        return m_globalArray[1] == 0;
    }

    public static boolean isVibrationEnabled() {
        return m_globalArray[2] == 0;
    }

    public static boolean isHawkeyeEnabled() {
        return m_globalArray[4] == 0;
    }

    private static final int ARGB(int n2, int n3, int n4) {
        return n2 << 16 | n3 << 8 | n4;
    }

    public static void menuInit() {
        m_filename1 = new StringBuffer(32);
        m_filename2 = new StringBuffer(32);
        m_loadingImage = SDKUtils.createImage(352, 20);
        m_loadingImageGraphics = m_loadingImage.getGraphics();
        m_globalArray = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            XMLMenuSystem.m_globalArray[i2] = 0;
        }
        boolean bl = XMLMenuSystem.readRMSMenu();
        m_showLanguageSelect = XMLMenuSystem.initEASDK(bl ? m_globalArray[0] : -1);
        m_playerNameIds = m_playerNameIdsFull;
    }

    private static void loadMenuText() {
        switch (m_menuSystemId) {
            case 1: {
                SDKUtils.loadStringsChunk(2);
                break;
            }
            case 2: {
                SDKUtils.loadStringsChunk(3);
                break;
            }
            case 3: {
                SDKUtils.loadStringsChunk(4);
            }
        }
    }

    private static void freeMenuText() {
        switch (m_menuSystemId) {
            case 1: {
                SDKUtils.freeStringsChunk(2);
                break;
            }
            case 2: {
                SDKUtils.freeStringsChunk(3);
                break;
            }
            case 3: {
                SDKUtils.freeStringsChunk(4);
            }
        }
    }

    public static void load(int n2, int n3, int n4) {
        try {
            switch (n3) {
                case 0: {
                    m_menuSystemId = n2;
                    m_menuTempBytes = new char[128];
                    m_workArray = new int[256];
                    m_workRangeArray = new byte[256];
                    m_menuTextBlockLineOffsets = new short[128];
                    m_tempSDKString = new SDKString();
                    m_currentFontId = -1;
                    m_currentPaletteId = -1;
                    m_alphaEnabled = false;
                    m_filename1.setLength(0);
                    m_filename1.insert(0, "/menu00.bin");
                    m_filename1.setCharAt(5, (char)(48 + m_menuSystemId / 10));
                    m_filename1.setCharAt(6, (char)(48 + m_menuSystemId % 10));
                    m_compiledData = DDFile.loadFileBytes(m_filename1.toString());
                    XMLMenuSystem.loadMenuText();
                    m_compiledDataPos = m_compiledData[12] & 0xFF | (m_compiledData[13] & 0xFF) << 8;
                    int n5 = XMLMenuSystem.CompiledGetByte();
                    m_resourceImages = new DDImage[n5];
                    for (int i2 = 0; i2 < n5; ++i2) {
                        int n6 = -1;
                        int n7 = -1;
                        XMLMenuSystem.GetResourceFilename(m_filename1);
                        XMLMenuSystem.GetResourceFilename(m_filename2);
                        if (m_filename1.length() > 0) {
                            if (m_filename2.length() > 0) {
                                byte[] byArray = DDFile.loadFileBytes(m_filename2.toString());
                                int n8 = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8;
                                int n9 = (byArray.length - 8) / n8;
                                XMLMenuSystem.m_resourceImages[i2] = DDImage.createSprite(m_filename1.toString(), byArray, 8, n8 / 3, n9, true);
                                byArray = null;
                                System.gc();
                            } else {
                                XMLMenuSystem.m_resourceImages[i2] = DDImage.createSprite(m_filename1.toString());
                            }
                        }
                        XMLMenuSystem.GetResourceFilename(m_filename1);
                    }
                    System.gc();
                    break;
                }
                case 1: {
                    int n10 = (m_compiledData[8] & 0xFF | (m_compiledData[9] & 0xFF) << 8) - (m_compiledData[6] & 0xFF | (m_compiledData[7] & 0xFF) << 8);
                    m_entityData = new byte[n10];
                    n4 = XMLMenuSystem.onCreate(m_menuSystemId, n4);
                    if (n4 <= 0) {
                        n4 = m_compiledData[16] & 0xFF;
                    }
                    m_currMenu = -1;
                    XMLMenuSystem.SetMenu(n4);
                    m_menuRefreshCount = 10;
                    System.gc();
                }
            }
        }
        catch (Exception exception) {
            MainFrame.m_loadError = 1;
            DDDebug.msg("Exception in XMLMenuSystem.load()");
        }
    }

    public static void unload() {
        if (m_compiledData != null) {
            XMLMenuSystem.onDestroy(m_menuSystemId);
        }
        if (m_resourceImages != null) {
            for (int i2 = 0; i2 < m_resourceImages.length; ++i2) {
                if (m_resourceImages[i2] == null) continue;
                m_resourceImages[i2].dispose();
                XMLMenuSystem.m_resourceImages[i2] = null;
            }
        }
        m_resourceImages = null;
        m_compiledData = null;
        m_tempSDKString = null;
        m_entityData = null;
        m_menuTempBytes = null;
        m_menuTextBlockLineOffsets = null;
        m_workArray = null;
        m_workRangeArray = null;
        m_rgbArray = null;
        System.gc();
    }

    public static void update(long l2, int n2, boolean bl) {
        if (bl) {
            m_menuRefreshCount = 4;
        }
        if ((n2 & 0x10) != 0) {
            n2 |= 0x40;
        }
        XMLMenuSystem.HandleJoystick(n2);
        if (n2 != 0) {
            m_menuRefreshCount = 1;
        }
        XMLMenuSystem.checkMusicRestart();
    }

    public static void checkMusicRestart() {
        if (m_soundMenuRestart && --m_soundRestartCounter < 0) {
            MainFrame.soundPlay(13, 2);
            m_soundRestartCounter = 2;
            m_soundMenuRestart = false;
        }
    }

    public static void setPointerPosition(int n2, int n3) {
    }

    public static void setPointerDrag(int n2) {
    }

    private static boolean arrowsTouched(int n2, int n3) {
        return false;
    }

    private static void checkPointerCollision() {
    }

    private static int getContainerControlInfo(int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int[] nArray = m_posArray;
        int n8 = XMLMenuSystem.CompiledGetActionByte();
        for (n7 = 0; n7 < 4; ++n7) {
            nArray[n7] = XMLMenuSystem.CompiledGetActionShort();
        }
        if ((n3 & 1) != 0) {
            n3 = 0;
            nArray[0] = nArray[0] - m_scrollValues[1];
            nArray[1] = nArray[1] - m_scrollValues[6];
            if (m_scrollValues[7] > 0 && (nArray[1] < 0 || nArray[1] >= m_scrollValues[8])) {
                n3 = 2;
            }
        }
        nArray[0] = nArray[0] + n4;
        nArray[1] = nArray[1] + n5;
        int n9 = nArray[0];
        int n10 = nArray[1];
        if ((n8 & 3) < 2) {
            n6 = XMLMenuSystem.CompiledGetActionByte();
            if ((n8 & 0x80) != 0) {
                ++m_compiledDataActionPos;
            }
            if ((n8 & 0x40) != 0) {
                ++m_compiledDataActionPos;
            }
            if ((n8 & 0x20) != 0) {
                ++m_compiledDataActionPos;
                n3 = 1;
            }
            if ((n8 & 0x10) != 0) {
                n9 -= m_scrollValues[1];
            }
            System.arraycopy(nArray, 0, nArray, 4, 4);
        } else {
            if ((n8 & 3) == 3) {
                ++m_compiledDataActionPos;
                int n11 = XMLMenuSystem.CompiledGetActionByte();
                for (n7 = 0; n7 < n11; ++n7) {
                    m_compiledDataActionPos += 2;
                    int n12 = XMLMenuSystem.CompiledGetActionByte();
                    if ((n12 & 0x80) != 0) {
                        ++m_compiledDataActionPos;
                        continue;
                    }
                    if ((n12 & 0x80) != 0) continue;
                    m_compiledDataActionPos += n12 & 7;
                }
                if ((n8 & 0x80) != 0) {
                    if (n2 < 32) {
                        XMLMenuSystem.m_controlInfo[n2][0] = m_compiledDataActionPos;
                        XMLMenuSystem.m_controlInfo[n2][1] = nArray[0];
                        XMLMenuSystem.m_controlInfo[n2][2] = nArray[1];
                        XMLMenuSystem.m_controlInfo[n2][3] = nArray[2];
                        XMLMenuSystem.m_controlInfo[n2][4] = nArray[3];
                    }
                    m_compiledDataActionPos += 4;
                    n7 = XMLMenuSystem.CompiledGetActionByte();
                    m_compiledDataActionPos += n7;
                    ++n2;
                }
                return n2;
            }
            m_compiledDataActionPos += 2;
            n6 = 0;
        }
        for (n7 = 0; n7 < n6; ++n7) {
            n2 = XMLMenuSystem.getContainerControlInfo(n2, n3, n9, n10);
        }
        return n2;
    }

    public static void draw(SDKGraphics sDKGraphics) {
        m_menuGraphics = sDKGraphics;
        if (m_menuRefreshCount > 0) {
            --m_menuRefreshCount;
            m_scrollUp = 0;
            m_scrollDown = 0;
            if (m_compiledMenuDataPos >= 0) {
                m_compiledDataPos = m_compiledMenuDataPos;
                int n2 = XMLMenuSystem.CompiledGetByte();
                int n3 = XMLMenuSystem.CompiledGetByte();
                XMLMenuSystem.CompiledGetByte();
                XMLMenuSystem.CompiledGetByte();
                XMLMenuSystem.CompiledGetByte();
                XMLMenuSystem.CompiledGetByte();
                int n4 = XMLMenuSystem.CompiledGetByte();
                int n5 = XMLMenuSystem.CompiledGetByte();
                XMLMenuSystem.CompiledGetByte();
                int n6 = XMLMenuSystem.CompiledGetByte();
                m_compiledDataPos += n6;
                m_compiledDataPos += 2;
                n6 = XMLMenuSystem.CompiledGetByte();
                m_compiledDataPos += n6;
                n6 = XMLMenuSystem.CompiledGetByte();
                m_compiledDataPos += n6;
                XMLMenuSystem.CopyEntityData();
                XMLMenuSystem.DrawContainer(0, 0, 0, 0);
                XMLMenuSystem.drawSoftKeys(sDKGraphics, n2, n3, n4, n5);
                if (m_scrollArrows != null && (m_scrollValues[7] > 0 || m_menuTextBlockTotalLines > m_menuTextBlockVisibleLines)) {
                    m_menuGraphics.setClip(0, 0, 352, 416);
                    m_menuGraphics.drawImage(m_scrollArrows, 176, 416, 33);
                }
            }
            if (m_scrollUp != m_workArray[235] || m_scrollDown != m_workArray[236]) {
                XMLMenuSystem.m_workArray[235] = m_scrollUp;
                XMLMenuSystem.m_workArray[236] = m_scrollDown;
                m_menuRefreshCount = 1;
            }
        }
    }

    public static void drawSoftKeys(SDKGraphics sDKGraphics) {
        XMLMenuSystem.drawSoftKeys(sDKGraphics, FONT_SMALL, 0, 255, 1);
    }

    private static void drawSoftKeys(SDKGraphics sDKGraphics, int n2, int n3, int n4, int n5) {
        m_menuGraphics = sDKGraphics;
        if (n4 != 255) {
            XMLMenuSystem.CopyEntityData();
            int n6 = m_entityData[(n4 << 1) + 0] & 0xFF | (m_entityData[(n4 << 1) + 1] & 0xFF) << 8;
            int n7 = XMLMenuSystem.GetMenuEntityHeight(n6);
            XMLMenuSystem.DrawMenuEntity(n6, true, 0, 416 - n7, 352, n7, 0, 0);
        }
        m_menuGraphics.setClip(0, 0, 352, 416);
        m_tempSDKString = XMLMenuSystem.GetMenuString(m_tempSDKString, m_softKeyText[0], 0);
        XMLMenuSystem.DrawMenuText(n5 & 0xF, 416 - (n5 >> 4), n2, m_tempSDKString, 0, m_tempSDKString.length(), n3, 255, 36);
        m_tempSDKString = XMLMenuSystem.GetMenuString(m_tempSDKString, m_softKeyText[1], 0);
        XMLMenuSystem.DrawMenuText(352 - (n5 & 0xF), 416 - (n5 >> 4), n2, m_tempSDKString, 0, m_tempSDKString.length(), n3, 255, 40);
    }

    public static void drawText(SDKGraphics sDKGraphics, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        m_menuGraphics = sDKGraphics;
        m_tempSDKString = XMLMenuSystem.GetMenuString(m_tempSDKString, n6, n7);
        XMLMenuSystem.DrawMenuText(n2, n3, n4, m_tempSDKString, 0, m_tempSDKString.length(), n5, 255, n8);
    }

    private static String GetResourceFilename(StringBuffer stringBuffer) {
        char c2;
        stringBuffer.setLength(0);
        int n2 = 0;
        while ((c2 = (char)XMLMenuSystem.CompiledGetByte()) != '\u0000') {
            stringBuffer.insert(n2, c2);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static int CompiledGetActionByte() {
        int n2 = m_compiledData[m_compiledDataActionPos] & 0xFF;
        ++m_compiledDataActionPos;
        return n2;
    }

    private static int CompiledGetActionShort() {
        int n2 = m_compiledData[m_compiledDataActionPos + 0] & 0xFF | (m_compiledData[m_compiledDataActionPos + 1] & 0xFF) << 8;
        m_compiledDataActionPos += 2;
        return n2;
    }

    private static int CompiledGetActionInt() {
        int n2 = m_compiledData[m_compiledDataActionPos + 0] & 0xFF | (m_compiledData[m_compiledDataActionPos + 1] & 0xFF) << 8 | (m_compiledData[m_compiledDataActionPos + 2] & 0xFF) << 16 | (m_compiledData[m_compiledDataActionPos + 3] & 0xFF) << 24;
        m_compiledDataActionPos += 4;
        return n2;
    }

    private static int CompiledGetByte() {
        int n2 = m_compiledData[m_compiledDataPos] & 0xFF;
        ++m_compiledDataPos;
        return n2;
    }

    private static int CompiledGetShort() {
        int n2 = m_compiledData[m_compiledDataPos + 0] & 0xFF | (m_compiledData[m_compiledDataPos + 1] & 0xFF) << 8;
        m_compiledDataPos += 2;
        return n2;
    }

    private static int CompiledGetInt() {
        int n2 = m_compiledData[m_compiledDataPos + 0] & 0xFF | (m_compiledData[m_compiledDataPos + 1] & 0xFF) << 8 | (m_compiledData[m_compiledDataPos + 2] & 0xFF) << 16 | (m_compiledData[m_compiledDataPos + 3] & 0xFF) << 24;
        m_compiledDataPos += 4;
        return n2;
    }

    public static SDKString GetMenuString(SDKString sDKString, int n2, int n3) {
        sDKString = SDKUtils.getString(n2 + n3, sDKString);
        SDKString[] sDKStringArray = null;
        switch (n2) {
            case 463: {
                sDKStringArray = new SDKString[]{new SDKString(SDKMIDlet.getAppProp("MIDlet-Version"))};
                break;
            }
            case 655: {
                sDKStringArray = new SDKString[]{new SDKString("" + m_workArray[30]), new SDKString("" + m_workArray[31]), new SDKString("" + m_workArray[32]), new SDKString("" + m_workArray[33])};
                break;
            }
            case 656: {
                sDKStringArray = new SDKString[]{new SDKString("" + m_workArray[2]), new SDKString("" + m_workArray[3])};
                break;
            }
            case 516: {
                int n4 = Game.maxOvers - Game.currentOver;
                int n5 = Game.bowlsLeft;
                if (n5 == 6) {
                    ++n4;
                    n5 = 0;
                }
                sDKStringArray = new SDKString[]{new SDKString("" + n4), new SDKString("" + n5)};
                break;
            }
            case 505: {
                sDKStringArray = new SDKString[]{new SDKString("" + Game.m_challengeCounter[n3])};
                break;
            }
            case 497: {
                int n6 = Game.maxOvers - Game.currentOver;
                int n7 = Game.bowlsLeft;
                if (n7 == 6) {
                    ++n6;
                    n7 = 0;
                }
                sDKStringArray = new SDKString[]{new SDKString("" + n6), new SDKString("" + n7)};
                break;
            }
            case 490: {
                sDKStringArray = new SDKString[]{new SDKString("" + Game.m_testMatchCounter[n3])};
                break;
            }
            case 577: {
                sDKStringArray = new SDKString[]{XMLMenuSystem.GetMenuString(null, 589, 0)};
            }
        }
        if (sDKStringArray != null) {
            sDKString = sDKString.replace(sDKStringArray);
        }
        return sDKString;
    }

    public static int TextWidth(int n2, SDKString sDKString, int n3, int n4) {
        XMLMenuSystem.setFont(n2);
        return SDKUtils.getSubStringSize(sDKString, n3, n4);
    }

    public static int stringTextWidth(int n2, int n3, int n4, int n5, int n6) {
        m_tempSDKString = XMLMenuSystem.GetMenuString(m_tempSDKString, n3, n4);
        int n7 = m_tempSDKString.length();
        if (n6 != -1) {
            n7 = n6;
        }
        return XMLMenuSystem.TextWidth(n2, m_tempSDKString, n5, n7 -= n5);
    }

    private static void DrawMenuText(int n2, int n3, int n4, SDKString sDKString, int n5, int n6, int n7, int n8, int n9) {
        SDKUtils.setGraphics(m_menuGraphics);
        XMLMenuSystem.setFont(n4, n7);
        SDKUtils.drawSubString(sDKString, n5, n6, n2, n3, n9);
    }

    private static void CalcLineWrap(int n2, SDKString sDKString, int n3, int n4, int n5, int n6) {
        XMLMenuSystem.setFont(n2);
        m_menuTextBlockLineOffsets = SDKUtils.wrapSubString(sDKString, n3, n4, m_menuTextBlockLineOffsets, n5, (short)124);
        m_menuTextBlockTotalLines = m_menuTextBlockLineOffsets[0];
        int n7 = SDKUtils.getLineSize();
        m_menuTextBlockVisibleLines = n6 / n7;
    }

    public static int GetMenuFontHeight(int n2) {
        XMLMenuSystem.setFont(n2);
        return SDKUtils.getLineSize();
    }

    private static void DrawMenuTextBlock(int n2, int n3, int n4, int n5, SDKString sDKString, int n6, int n7, int n8, int n9, int n10) {
        SDKUtils.setGraphics(m_menuGraphics);
        XMLMenuSystem.setFont(n5, n8);
        int n11 = DDMath.min(m_menuTextBlockVisibleLines, m_menuTextBlockTotalLines - n2);
        SDKUtils.drawWrappedString(sDKString, m_menuTextBlockLineOffsets, n2 + 1, n11, n3, n4, n10);
    }

    private static int NumberToString(int n2, int n3, int n4) {
        int n5;
        int n6 = 0;
        if (n2 < 0) {
            XMLMenuSystem.m_menuTempBytes[0] = 45;
            n2 = -n2;
            n6 = 1;
        }
        int n7 = 1;
        for (n5 = n3 - 1; n5 > 0; --n5) {
            n7 *= 10;
        }
        for (n5 = n3; n5 > 0; --n5) {
            int n8 = n2 / n7 % 10;
            if (n5 == 1 || n4 != 0 || n8 != 0) {
                XMLMenuSystem.m_menuTempBytes[n6] = (char)(n8 + 48);
                n4 = 1;
                ++n6;
            }
            n7 /= 10;
        }
        return n6;
    }

    private static void DrawRepeat(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        int n11;
        int[] nArray = new int[]{0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0};
        int n12 = n2 += 2;
        for (n11 = 0; n11 < n8; ++n11) {
            for (n10 = 0; n10 < n7; ++n10) {
                if (n11 == 0) {
                    nArray[n10] = XMLMenuSystem.GetMenuEntityWidth(n2);
                }
                if (n10 == 0) {
                    nArray2[n11] = XMLMenuSystem.GetMenuEntityHeight(n2);
                }
                n2 += XMLMenuSystem.GetMenuEntityLen(n2);
            }
        }
        n2 = n12;
        int n13 = n4;
        for (n11 = 0; n11 < n8; ++n11) {
            int n14 = 1;
            if (n11 == 1) {
                n14 = (n6 - (nArray2[0] + nArray2[2])) / nArray2[1] + 1;
            }
            n12 = n2;
            while (n14 > 0) {
                int n15 = n3;
                n2 = n12;
                for (n10 = 0; n10 < n7; ++n10) {
                    int n16 = 1;
                    if (n10 == 1) {
                        n16 = (n5 - (nArray[0] + nArray[2])) / nArray[1] + 1;
                    }
                    while (n16 > 0) {
                        XMLMenuSystem.DrawMenuEntity(n2, false, n15, n13, nArray[n10], nArray2[n11], 0, n9);
                        n15 += nArray[n10];
                        --n16;
                    }
                    if (n10 == 1) {
                        n15 = n3 + n5 - nArray[2];
                    }
                    n2 += XMLMenuSystem.GetMenuEntityLen(n2);
                }
                n13 += nArray2[n11];
                --n14;
            }
            if (n11 != 1) continue;
            n13 = n4 + n6 - nArray2[2];
        }
    }

    private static int GetMenuEntityWidth(int n2) {
        int n3 = 0;
        switch (m_entityData[n2] & 0xFF) {
            case 1: {
                n3 = m_resourceImages[m_entityData[n2 + 2] & 0xFF].getFrameWidth(m_entityData[n2 + 3] & 0xFF);
                break;
            }
            case 3: {
                n3 = m_resourceImages[m_entityData[n2 + 2] & 0xFF].getFrameWidth(0);
                break;
            }
            case 4: 
            case 10: {
                n2 += 2;
                for (int i2 = 0; i2 < 3; ++i2) {
                    n3 += XMLMenuSystem.GetMenuEntityWidth(n2);
                    n2 += XMLMenuSystem.GetMenuEntityLen(n2);
                }
                break;
            }
            case 5: {
                n3 = m_entityData[n2 + 2] & 0xFF;
                break;
            }
            case 6: {
                n3 = m_resourceImages[m_entityData[n2 + 2] & 0xFF].getFrameWidth(0) * (m_entityData[n2 + 3] & 0xFF);
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                n3 = m_entityData[n2 + 2] & 0xFF;
                break;
            }
            case 11: {
                n3 += XMLMenuSystem.GetMenuEntityWidth(n2 += 2);
                break;
            }
            case 16: {
                n3 = (m_entityData[n2 + 2] & 0xFF) << 0;
            }
        }
        return n3;
    }

    private static int GetMenuEntityHeight(int n2) {
        int n3 = 0;
        switch (m_entityData[n2] & 0xFF) {
            case 1: {
                n3 = m_resourceImages[m_entityData[n2 + 2] & 0xFF].getFrameHeight(m_entityData[n2 + 3] & 0xFF);
                break;
            }
            case 3: {
                n3 = m_resourceImages[m_entityData[n2 + 2] & 0xFF].getFrameHeight(0);
                break;
            }
            case 4: {
                n2 += 2;
                for (int i2 = 0; i2 < 3; ++i2) {
                    n3 += XMLMenuSystem.GetMenuEntityHeight(n2);
                    for (int i3 = 0; i3 < 3; ++i3) {
                        n2 += XMLMenuSystem.GetMenuEntityLen(n2);
                    }
                }
                break;
            }
            case 5: {
                n3 = m_entityData[n2 + 3] & 0xFF;
                break;
            }
            case 6: {
                n3 = m_resourceImages[m_entityData[n2 + 2] & 0xFF].getFrameHeight(0);
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                n3 = m_entityData[n2 + 3] & 0xFF;
                break;
            }
            case 10: {
                n3 += XMLMenuSystem.GetMenuEntityHeight(n2 += 2);
                break;
            }
            case 11: {
                n2 += 2;
                for (int i4 = 0; i4 < 3; ++i4) {
                    n3 += XMLMenuSystem.GetMenuEntityHeight(n2);
                    n2 += XMLMenuSystem.GetMenuEntityLen(n2);
                }
                break;
            }
            case 16: {
                n3 = (m_entityData[n2 + 3] & 0xFF) << 0;
            }
        }
        return n3;
    }

    private static void DrawMenuEntity(int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, int n8) {
        boolean bl2 = false;
        m_menuGraphics.setClip(n3, n4, n5, n6);
        if (n7 == 1) {
            n3 += n5;
            n7 = 8;
        } else if (n7 == 2) {
            n3 += n5 / 2;
            n7 = 1;
        } else {
            n7 = 4;
        }
        switch (m_entityData[n2] & 0xFF) {
            case 1: {
                if (m_entityData[n2 + 1] == 0) break;
                DDImage dDImage = m_resourceImages[m_entityData[n2 + 2] & 0xFF];
                int n9 = m_entityData[n2 + 3] & 0xFF;
                dDImage.drawFrame(m_menuGraphics, n3, n4, n9, m_entityData[n2 + 4] & 0xFF, n7 | 0x10, 0);
                break;
            }
            case 3: {
                if (m_entityData[n2 + 1] == 0) break;
                m_resourceImages[m_entityData[n2 + 2] & 0xFF].drawFrame(m_menuGraphics, n3, n4, 0, m_entityData[n2 + 3] & 0xFF, n7 | 0x10, 0);
                break;
            }
            case 4: {
                if (m_entityData[n2 + 1] == 0) break;
                XMLMenuSystem.DrawRepeat(n2, n3, n4, n5, n6, 3, 3, n8);
                break;
            }
            case 5: {
                if (m_entityData[n2 + 1] == 0) break;
                if (!bl) {
                    n5 = m_entityData[n2 + 2] & 0xFF;
                    n6 = m_entityData[n2 + 3] & 0xFF;
                }
                m_menuGraphics.setClip(0, 0, 352, 416);
                if (m_entityData[n2 + 13] < 0) {
                    m_menuGraphics.setColor(XMLMenuSystem.ARGB(m_entityData[n2 + 10] & 0xFF, m_entityData[n2 + 11] & 0xFF, m_entityData[n2 + 12] & 0xFF));
                    m_menuGraphics.fillRect(n3 + 1, n4 + 1, n5, n6);
                }
                if (!m_alphaEnabled || (m_entityData[n2 + 14] & 0xFF) == 255) {
                    m_menuGraphics.setColor(XMLMenuSystem.ARGB(m_entityData[n2 + 4] & 0xFF, m_entityData[n2 + 5] & 0xFF, m_entityData[n2 + 6] & 0xFF));
                    m_menuGraphics.fillRect(n3, n4, n5, n6);
                    m_menuGraphics.setColor(XMLMenuSystem.ARGB(m_entityData[n2 + 7] & 0xFF, m_entityData[n2 + 8] & 0xFF, m_entityData[n2 + 9] & 0xFF));
                    m_menuGraphics.drawRect(n3, n4, n5 - 1, n6 - 1);
                    break;
                }
                for (int i2 = 0; i2 < n5 * n6; ++i2) {
                    XMLMenuSystem.m_rgbArray[i2] = (m_entityData[n2 + 14] & 0xFF) << 24 | (m_entityData[n2 + 4] & 0xFF) << 16 | (m_entityData[n2 + 5] & 0xFF) << 8 | (m_entityData[n2 + 6] & 0xFF) << 0;
                }
                break;
            }
            case 6: {
                if (m_entityData[n2 + 1] == 0) break;
                int n10 = (m_entityData[n2 + 5] & 0xFF) << 24 | (m_entityData[n2 + 6] & 0xFF) << 16 | (m_entityData[n2 + 7] & 0xFF) << 8 | (m_entityData[n2 + 8] & 0xFF) << 0;
                if (n10 < m_entityData[n2 + 4]) {
                    n5 = n10 * n5 / m_entityData[n2 + 4];
                }
                m_menuGraphics.setClip(n3, n4, n5, n6);
                for (n10 = m_entityData[n2 + 3] & 0xFF; n10 > 0; --n10) {
                    m_resourceImages[m_entityData[n2 + 2] & 0xFF].drawFrame(m_menuGraphics, n3, n4, 0, m_entityData[n2 + 9] & 0xFF, n7, 0);
                    n3 += m_resourceImages[m_entityData[n2 + 2] & 0xFF].getFrameWidth(0);
                }
                break;
            }
            case 7: {
                if (m_entityData[n2 + 1] == 0) break;
                m_tempSDKString = XMLMenuSystem.GetMenuString(m_tempSDKString, (m_entityData[n2 + 4] & 0xFF) << 8 | (m_entityData[n2 + 5] & 0xFF) << 0, m_entityData[n2 + 6] & 0xFF);
                XMLMenuSystem.DrawMenuText(n3, n4, m_entityData[n2 + 7] & 0xFF, m_tempSDKString, 0, m_tempSDKString.length(), m_entityData[n2 + 8] & 0xFF, 255, 0x10 | n7);
                break;
            }
            case 8: {
                if (m_entityData[n2 + 1] == 0) break;
                n7 |= 0x10;
                m_tempSDKString = XMLMenuSystem.GetMenuString(m_tempSDKString, (m_entityData[n2 + 4] & 0xFF) << 8 | (m_entityData[n2 + 5] & 0xFF) << 0, m_entityData[n2 + 6] & 0xFF);
                if (m_menuTextBlockCachedBlock != (n2 << 24 | ((m_entityData[n2 + 4] & 0xFF) << 8 | m_entityData[n2 + 5] & 0xFF) | (m_entityData[n2 + 6] & 0xFF) << 16)) {
                    m_menuTextBlockCachedBlock = n2 << 24 | ((m_entityData[n2 + 4] & 0xFF) << 8 | m_entityData[n2 + 5] & 0xFF) | (m_entityData[n2 + 6] & 0xFF) << 16;
                    XMLMenuSystem.CalcLineWrap(m_entityData[n2 + 7] & 0xFF, m_tempSDKString, 0, m_tempSDKString.length(), n5, n6);
                }
                XMLMenuSystem.DrawMenuTextBlock(m_menuTextBlockCurrentLine, n3, n4, m_entityData[n2 + 7] & 0xFF, m_tempSDKString, 0, m_tempSDKString.length(), m_entityData[n2 + 8] & 0xFF, 255, n7);
                break;
            }
            case 10: {
                if (m_entityData[n2 + 1] == 0) break;
                XMLMenuSystem.DrawRepeat(n2, n3, n4, n5, n6, 3, 1, n8);
                break;
            }
            case 11: {
                if (m_entityData[n2 + 1] == 0) break;
                XMLMenuSystem.DrawRepeat(n2, n3, n4, n5, n6, 1, 3, n8);
                break;
            }
            case 12: {
                if (m_entityData[n2 + 1] == 0) break;
                int n11 = (m_entityData[n2 + 6] & 0xFF) << 24 | (m_entityData[n2 + 7] & 0xFF) << 16 | (m_entityData[n2 + 8] & 0xFF) << 8 | (m_entityData[n2 + 9] & 0xFF) << 0;
                n11 = XMLMenuSystem.NumberToString(n11, m_entityData[n2 + 2], m_entityData[n2 + 3]);
                XMLMenuSystem.DrawMenuText(n3, n4, m_entityData[n2 + 4] & 0xFF, new SDKString(m_menuTempBytes, 0, n11), 0, n11, m_entityData[n2 + 5] & 0xFF, 255, 0x10 | n7);
                break;
            }
            case 16: {
                if (m_entityData[n2 + 1] == 0) break;
                n5 = (m_entityData[n2 + 2] & 0xFF) << 0;
                n6 = (m_entityData[n2 + 3] & 0xFF) << 0;
                XMLMenuSystem.onOwnerDraw(m_entityData[n2 + 4] & 0xFF, n3, n4, n5, n6, (m_entityData[n2 + 5] & 0xFF) << 24 | (m_entityData[n2 + 6] & 0xFF) << 16 | (m_entityData[n2 + 7] & 0xFF) << 8 | (m_entityData[n2 + 8] & 0xFF) << 0, (m_entityData[n2 + 9] & 0xFF) << 24 | (m_entityData[n2 + 10] & 0xFF) << 16 | (m_entityData[n2 + 11] & 0xFF) << 8 | (m_entityData[n2 + 12] & 0xFF) << 0, (m_entityData[n2 + 13] & 0xFF) << 24 | (m_entityData[n2 + 14] & 0xFF) << 16 | (m_entityData[n2 + 15] & 0xFF) << 8 | (m_entityData[n2 + 16] & 0xFF) << 0, (m_entityData[n2 + 17] & 0xFF) << 24 | (m_entityData[n2 + 18] & 0xFF) << 16 | (m_entityData[n2 + 19] & 0xFF) << 8 | (m_entityData[n2 + 20] & 0xFF) << 0);
                break;
            }
        }
    }

    private static int GetMenuEntityLen(int n2) {
        int n3 = 0;
        switch (m_entityData[n2] & 0xFF) {
            case 1: {
                n3 = 5;
                break;
            }
            case 3: {
                n3 = 4;
                break;
            }
            case 4: {
                n2 += 2;
                n3 += 2;
                for (int i2 = 0; i2 < 9; ++i2) {
                    n3 += XMLMenuSystem.GetMenuEntityLen(n2);
                }
                break;
            }
            case 5: {
                n3 = 15;
                break;
            }
            case 6: {
                n3 = 10;
                break;
            }
            case 7: {
                n3 = 9;
                break;
            }
            case 8: {
                n3 = 13;
                break;
            }
            case 10: 
            case 11: {
                n2 += 2;
                n3 += 2;
                for (int i3 = 0; i3 < 3; ++i3) {
                    n3 += XMLMenuSystem.GetMenuEntityLen(n2);
                }
                break;
            }
            case 16: {
                n3 = 21;
            }
        }
        return n3;
    }

    private static void CopyEntityData() {
        int n2 = m_compiledDataFonts - m_compiledDataObjects;
        System.arraycopy(m_compiledData, m_compiledDataObjects, m_entityData, 0, n2);
    }

    private static void GetParameters(boolean bl) {
        int n2 = XMLMenuSystem.CompiledGetByte();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = XMLMenuSystem.CompiledGetByte();
            int n4 = XMLMenuSystem.CompiledGetByte() + 1;
            n4 += m_entityData[(n3 << 1) + 0] & 0xFF | (m_entityData[(n3 << 1) + 1] & 0xFF) << 8;
            int n5 = XMLMenuSystem.CompiledGetByte();
            n3 = 0;
            if ((n5 & 0x80) != 0) {
                n3 = XMLMenuSystem.CompiledGetByte();
            }
            int n6 = 0;
            while (n6 < (n5 & 7)) {
                int n7 = (n5 & 0x80) != 0 ? m_workArray[n3] >> ((n5 & 7) - 1 - n6) * 8 & 0xFF : XMLMenuSystem.CompiledGetByte();
                if (bl) {
                    if ((n5 & 0x20) != 0) {
                        int n8 = n4;
                        m_entityData[n8] = (byte)(m_entityData[n8] | (byte)n7);
                    } else {
                        XMLMenuSystem.m_entityData[n4] = (byte)n7;
                    }
                }
                ++n6;
                ++n4;
            }
        }
    }

    private static int DrawContainer(int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int[] nArray = m_posArray;
        int n9 = XMLMenuSystem.CompiledGetByte();
        for (n8 = 0; n8 < 4; ++n8) {
            nArray[n8] = XMLMenuSystem.CompiledGetShort();
        }
        if ((n3 & 1) != 0) {
            n3 = 0;
            nArray[0] = nArray[0] - m_scrollValues[1];
            nArray[1] = nArray[1] - m_scrollValues[6];
            if (m_scrollValues[7] > 0 && (nArray[1] < 0 || nArray[1] >= m_scrollValues[8])) {
                n3 = 2;
                if (nArray[1] < 0) {
                    m_scrollUp = 1;
                } else {
                    m_scrollDown = 1;
                }
            }
        }
        nArray[0] = nArray[0] + n4;
        nArray[1] = nArray[1] + n5;
        int n10 = nArray[0];
        int n11 = nArray[1];
        if ((n9 & 3) < 2) {
            n8 = 255;
            n7 = 255;
            n6 = XMLMenuSystem.CompiledGetByte();
            if ((n9 & 0x80) != 0) {
                n7 = XMLMenuSystem.CompiledGetByte();
            }
            if ((n9 & 0x40) != 0) {
                n8 = XMLMenuSystem.CompiledGetByte();
            }
            if (m_selected && n8 != 255) {
                n7 = n8;
            }
            if ((n9 & 0x20) != 0) {
                XMLMenuSystem.CompiledGetByte();
                n3 = 1;
            }
            if ((n9 & 0x10) != 0) {
                n10 -= m_scrollValues[1];
            }
            System.arraycopy(nArray, 0, nArray, 4, 4);
            n9 = 0;
        } else {
            if ((n9 & 3) == 3) {
                int n12 = XMLMenuSystem.CompiledGetByte();
                XMLMenuSystem.CopyEntityData();
                XMLMenuSystem.GetParameters(true);
                if ((n9 & 0x80) != 0) {
                    if (m_selectionNumber == 0 || m_selection == n2) {
                        m_selected = true;
                        m_selectedActionDataPos = m_compiledDataPos;
                    }
                    m_compiledDataPos += 4;
                    n8 = XMLMenuSystem.CompiledGetByte();
                    m_compiledDataPos += n8;
                    ++n2;
                }
                int n13 = m_compiledDataPos;
                m_compiledDataPos = m_compiledData[m_compiledDataControls + n12 * 2 + 0] & 0xFF | (m_compiledData[m_compiledDataControls + n12 * 2 + 1] & 0xFF) << 8;
                XMLMenuSystem.CompiledGetByte();
                XMLMenuSystem.GetParameters(m_selected);
                XMLMenuSystem.DrawContainer(n2, n3, n10, n11);
                m_selected = false;
                XMLMenuSystem.CopyEntityData();
                m_compiledDataPos = n13;
                return n2;
            }
            n7 = XMLMenuSystem.CompiledGetByte();
            n9 = XMLMenuSystem.CompiledGetByte();
            n6 = 0;
        }
        if (n7 != 255 && (n3 & 2) == 0) {
            n8 = m_entityData[(n7 << 1) + 0] & 0xFF | (m_entityData[(n7 << 1) + 1] & 0xFF) << 8;
            int n14 = n9 >> 2;
            XMLMenuSystem.onPositionOverride(m_menuSystemId, nArray, n14);
            XMLMenuSystem.DrawMenuEntity(n8, n9 != 2, nArray[0], nArray[1], nArray[2], nArray[3], n9 & 3, n14);
        }
        for (n8 = 0; n8 < n6; ++n8) {
            n2 = XMLMenuSystem.DrawContainer(n2, n3, n10, n11);
        }
        return n2;
    }

    private static void SetupArrays(boolean bl) {
        if (m_compiledMenuDataPos >= 0) {
            int n2 = m_compiledDataActionPos;
            m_compiledDataActionPos = m_compiledMenuDataPos;
            m_compiledDataActionPos += 9;
            int n3 = XMLMenuSystem.CompiledGetActionByte() / 6;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = XMLMenuSystem.CompiledGetActionByte();
                int n5 = XMLMenuSystem.CompiledGetActionByte();
                XMLMenuSystem.m_workRangeArray[n4] = (byte)n5;
                int n6 = XMLMenuSystem.CompiledGetActionInt();
                if ((n5 & 0x40) != 0) {
                    if (bl) {
                        XMLMenuSystem.m_globalArray[n6] = m_workArray[n4];
                        continue;
                    }
                    XMLMenuSystem.m_workArray[n4] = m_globalArray[n6];
                    continue;
                }
                if (bl) continue;
                XMLMenuSystem.m_workArray[n4] = n6;
            }
            m_compiledDataActionPos = n2;
        }
    }

    public static void setSoftKeys(int n2, int n3) {
        XMLMenuSystem.m_softKeyText[0] = (short)n2;
        XMLMenuSystem.m_softKeyText[1] = (short)n3;
    }

    public static void resetSoftKeys() {
    }

    public static void SetMenu(int n2) {
        int n3;
        XMLMenuSystem.onMenuExit(m_menuSystemId, m_currMenu);
        if (m_menuSystemId == 1 && n2 == 0) {
            n2 = MainFrame.isMoreGamesEnabled() ? 1 : 0;
        }
        m_menuTextBlockTotalLines = 0;
        m_menuTextBlockCurrentLine = 0;
        m_menuTextBlockVisibleLines = 0;
        m_selection = 0;
        if (n2 == 1 && m_menuSystemId == 1) {
            m_selection = 1;
        }
        m_selected = false;
        m_selectedActionDataPos = -1;
        m_menuTextBlockCachedBlock = -1;
        m_currMenu = n2;
        m_menuRefreshCount = 1;
        m_compiledDataControls = m_compiledData[4] & 0xFF | (m_compiledData[5] & 0xFF) << 8;
        m_compiledDataObjects = m_compiledData[6] & 0xFF | (m_compiledData[7] & 0xFF) << 8;
        m_compiledDataFonts = m_compiledData[8] & 0xFF | (m_compiledData[9] & 0xFF) << 8;
        m_compiledDataActionPos = m_compiledData[2] & 0xFF | (m_compiledData[3] & 0xFF) << 8;
        if (m_currMenu < (m_compiledData[m_compiledDataActionPos] & 0xFF)) {
            ++m_compiledDataActionPos;
            m_compiledDataActionPos = m_compiledMenuDataPos = m_compiledData[m_compiledDataActionPos + m_currMenu * 2 + 0] & 0xFF | (m_compiledData[m_compiledDataActionPos + m_currMenu * 2 + 1] & 0xFF) << 8;
            m_compiledDataActionPos += 8;
            m_selectionNumber = XMLMenuSystem.CompiledGetActionByte();
            n3 = XMLMenuSystem.CompiledGetActionByte();
            m_compiledDataActionPos += n3;
            m_compiledDataActionPos += 2;
            XMLMenuSystem.setSoftKeys((m_compiledData[m_compiledMenuDataPos + 2] & 0xFF) << 8 | (m_compiledData[m_compiledMenuDataPos + 3] & 0xFF) << 0, (m_compiledData[m_compiledMenuDataPos + 4] & 0xFF) << 8 | (m_compiledData[m_compiledMenuDataPos + 5] & 0xFF) << 0);
            int n4 = 0;
            int n5 = 0;
            while (n4 < 2) {
                XMLMenuSystem.m_scrollValues[n5 + 0] = 0;
                XMLMenuSystem.m_scrollValues[n5 + 1] = 0;
                XMLMenuSystem.m_scrollValues[n5 + 2] = -1;
                n3 = XMLMenuSystem.CompiledGetActionByte();
                if (n3 > 0) {
                    XMLMenuSystem.m_scrollValues[n5 + 2] = XMLMenuSystem.CompiledGetActionByte();
                    XMLMenuSystem.m_scrollValues[n5 + 3] = XMLMenuSystem.CompiledGetActionShort();
                    XMLMenuSystem.m_scrollValues[n5 + 4] = m_compiledDataActionPos;
                    m_compiledDataActionPos += n3 - 3;
                }
                ++n4;
                n5 += 5;
            }
        } else {
            m_compiledMenuDataPos = -1;
        }
        for (n3 = 0; n3 < 256; ++n3) {
            XMLMenuSystem.m_workArray[n3] = 0;
            XMLMenuSystem.m_workRangeArray[n3] = 0;
        }
        XMLMenuSystem.onMenuInit(m_menuSystemId, m_currMenu);
        XMLMenuSystem.SetupArrays(false);
    }

    private static int HandleJoystick(int n2) {
        if (m_selectedActionDataPos > 0) {
            m_compiledDataActionPos = m_selectedActionDataPos;
            boolean bl = false;
            int n3 = 0;
            int n4 = -1;
            int n5 = 0;
            int n6 = XMLMenuSystem.CompiledGetActionInt();
            int n7 = n6 >> 24 & 0xFF;
            for (int i2 = XMLMenuSystem.CompiledGetActionByte(); i2 > 0; i2 -= 2) {
                int n8 = XMLMenuSystem.CompiledGetActionByte();
                int n9 = XMLMenuSystem.CompiledGetActionByte();
                int n10 = 0;
                if ((n8 & 0x80) != 0) {
                    int n11 = XMLMenuSystem.CompiledGetActionByte();
                    n10 = XMLMenuSystem.CompiledGetActionByte();
                    i2 -= 2;
                    if (m_workArray[n11] == 0) {
                        n9 = n10;
                    }
                }
                int n12 = n8 & 0xF;
                n8 = n8 >> 4 & 7;
                if (n12 == 7 || n12 == 9 || n12 == 8) {
                    n10 = XMLMenuSystem.CompiledGetActionByte();
                    --i2;
                }
                if ((n2 & 1 << n8) == 0) continue;
                switch (n12) {
                    case 0: {
                        XMLMenuSystem.SetupArrays(true);
                    }
                    case 1: {
                        m_prevMenu = m_currMenu;
                        n4 = n9;
                        break;
                    }
                    case 2: {
                        XMLMenuSystem.SetupArrays(true);
                    }
                    case 3: {
                        n4 = m_prevMenu;
                        break;
                    }
                    case 4: {
                        int n13 = n9;
                        m_workArray[n13] = m_workArray[n13] + 1;
                        if (m_workArray[n9] < (m_workRangeArray[n9] & 0x3F)) break;
                        if ((m_workRangeArray[n9] & 0x80) == 0) {
                            XMLMenuSystem.m_workArray[n9] = (m_workRangeArray[n9] & 0x3F) - 1;
                            break;
                        }
                        int n14 = n9;
                        m_workArray[n14] = m_workArray[n14] - (m_workRangeArray[n9] & 0x3F);
                        break;
                    }
                    case 5: {
                        int n15 = n9;
                        m_workArray[n15] = m_workArray[n15] - 1;
                        if (m_workArray[n9] >= 0) break;
                        if ((m_workRangeArray[n9] & 0x80) == 0) {
                            XMLMenuSystem.m_workArray[n9] = 0;
                            break;
                        }
                        XMLMenuSystem.m_workArray[n9] = (m_workRangeArray[n9] & 0x3F) - 1;
                        break;
                    }
                    case 6: {
                        bl = true;
                        n3 = n9;
                        XMLMenuSystem.SetupArrays(true);
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        XMLMenuSystem.m_globalArray[n10] = n9;
                        break;
                    }
                }
                n5 |= 1 << n8;
            }
            if (n7 != 255) {
                n2 = XMLMenuSystem.onMenuAction(m_menuSystemId, m_currMenu, n2, n7);
            }
            n2 &= ~n5;
            if (n4 >= 0) {
                XMLMenuSystem.SetMenu(n4);
            }
            if (bl) {
                XMLMenuSystem.onExit(m_menuSystemId, n3);
                return n2;
            }
            int n16 = m_selection;
            if (m_selectionNumber != 0) {
                if ((n2 & 1) != 0) {
                    m_selection += n6 << 14 >> 26;
                }
                if ((n2 & 2) != 0) {
                    m_selection += n6 << 8 >> 26;
                }
                if ((n2 & 4) != 0) {
                    m_selection += n6 << 26 >> 26;
                    m_offsetDraw = 0;
                }
                if ((n2 & 8) != 0) {
                    m_selection += n6 << 20 >> 26;
                    m_offsetDraw = 0;
                }
                if (m_selection != n16) {
                    m_selection = XMLMenuSystem.onMenuSelectionChange(m_menuSystemId, m_currMenu, m_selection);
                }
                if (m_scrollValues[7] > 0) {
                    int n17 = m_compiledData[m_scrollValues[9] + m_selection * 2 + 0] & 0xFF | (m_compiledData[m_scrollValues[9] + m_selection * 2 + 1] & 0xFF) << 8;
                    while (n17 < m_scrollValues[6] && m_scrollValues[5] > 0) {
                        m_scrollValues[5] = m_scrollValues[5] - 1;
                        XMLMenuSystem.m_scrollValues[6] = m_compiledData[m_scrollValues[9] + m_scrollValues[5] * 2 + 0] & 0xFF | (m_compiledData[m_scrollValues[9] + m_scrollValues[5] * 2 + 1] & 0xFF) << 8;
                    }
                    while (n17 > m_scrollValues[6] + m_scrollValues[8] && m_scrollValues[5] < m_scrollValues[7]) {
                        m_scrollValues[5] = m_scrollValues[5] + 1;
                        XMLMenuSystem.m_scrollValues[6] = m_compiledData[m_scrollValues[9] + m_scrollValues[5] * 2 + 0] & 0xFF | (m_compiledData[m_scrollValues[9] + m_scrollValues[5] * 2 + 1] & 0xFF) << 8;
                    }
                }
            }
        }
        if (m_scrollValues[7] < 0) {
            if ((n2 & 4) != 0 && (m_menuTextBlockCurrentLine -= m_menuTextBlockVisibleLines) < 0) {
                m_menuTextBlockCurrentLine = 0;
            }
            if ((n2 & 8) != 0 && m_menuTextBlockCurrentLine + m_menuTextBlockVisibleLines < m_menuTextBlockTotalLines) {
                m_menuTextBlockCurrentLine += m_menuTextBlockVisibleLines;
            }
        }
        XMLMenuSystem.HandleFreeScroll(n2, 1, 0);
        if (m_selectionNumber == 0) {
            XMLMenuSystem.HandleFreeScroll(n2, 4, 5);
        }
        if ((m_currMenu == 12 || m_currMenu == 13) && m_menuSystemId == 3 && (n2 & 0x20) != 0) {
            XMLMenuSystem.SetMenu(0);
        }
        return n2;
    }

    private static void HandleFreeScroll(int n2, int n3, int n4) {
        if (m_scrollValues[n4 + 2] > 0) {
            if ((n2 & n3) != 0) {
                int n5 = n4 + 0;
                m_scrollValues[n5] = m_scrollValues[n5] - 1;
                if (m_scrollValues[n4 + 0] < 0) {
                    XMLMenuSystem.m_scrollValues[n4 + 0] = 0;
                }
            }
            if ((n2 & n3 + n3) != 0) {
                int n6 = n4 + 0;
                m_scrollValues[n6] = m_scrollValues[n6] + 1;
                if (m_scrollValues[n4 + 0] > m_scrollValues[n4 + 2]) {
                    XMLMenuSystem.m_scrollValues[n4 + 0] = m_scrollValues[n4 + 2];
                }
            }
            XMLMenuSystem.m_scrollValues[n4 + 1] = m_compiledData[m_scrollValues[n4 + 4] + m_scrollValues[n4 + 0] * 2 + 0] & 0xFF | (m_compiledData[m_scrollValues[n4 + 4] + m_scrollValues[n4 + 0] * 2 + 1] & 0xFF) << 8;
        }
    }

    public static boolean writeRMSMenu() {
        System.gc();
        byte[] byArray = new byte[16];
        byArray[0] = (byte)m_globalArray[0];
        byArray[1] = (byte)m_globalArray[1];
        byArray[2] = (byte)m_globalArray[2];
        byArray[3] = (byte)m_globalArray[3];
        byArray[4] = (byte)m_globalArray[4];
        SDKUtils.saveRecord(99, byArray);
        return true;
    }

    private static boolean readRMSMenu() {
        byte[] byArray;
        boolean bl = true;
        try {
            byArray = SDKUtils.loadRecord(99);
            if (byArray != null) {
                XMLMenuSystem.m_globalArray[0] = byArray[0];
                XMLMenuSystem.m_globalArray[1] = byArray[1];
                XMLMenuSystem.m_globalArray[2] = byArray[2];
                XMLMenuSystem.m_globalArray[3] = byArray[3];
                XMLMenuSystem.m_globalArray[4] = byArray[4];
                MainFrame.soundSetOnOff(m_globalArray[1] == 0);
                MainFrame.vibrateSetOnOff(m_globalArray[2] == 0);
            } else {
                bl = false;
                MainFrame.vibrateSetOnOff(true);
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        byArray = null;
        System.gc();
        return bl;
    }

    private static void setupLoadingImage() {
        if (m_loadingFontHeight == 0) {
            m_menuGraphics = m_loadingImageGraphics;
            m_menuGraphics.setClip(0, 0, 352, 20);
            m_menuGraphics.setColor(0xFFFFFF);
            m_menuGraphics.fillRect(0, 0, 352, 20);
            SDKUtils.getHeaderString(m_globalArray[0], 5, m_tempSDKString);
            int n2 = FONT_MEDIUM;
            XMLMenuSystem.DrawMenuText(176, 0, n2, m_tempSDKString, 0, m_tempSDKString.length(), FONTPAL_BLACK, 255, 17);
            m_loadingFontHeight = (m_compiledData[m_compiledDataFonts + n2 * 6 + 1] & 0xFF) + m_compiledData[m_compiledDataFonts + n2 * 6 + 4];
        }
    }

    public static void drawLoading(SDKGraphics sDKGraphics, int n2, int n3) {
        int n4 = 416 - (m_loadingFontHeight + 8) * 2 + 6;
        sDKGraphics.setClip(0, 0, 352, 416);
        sDKGraphics.setColor(0xFFFFFF);
        sDKGraphics.fillRect(0, 0, 352, 416);
        n4 = (416 - (m_loadingFontHeight + 8)) / 2;
        if (m_loadingFontHeight > 0) {
            sDKGraphics.drawImage(m_loadingImage, 0, n4, 20);
        }
        sDKGraphics.setColor(0);
        sDKGraphics.drawRect(86, n4 + 2 + m_loadingFontHeight, 179, 5);
        if (n2 > 0) {
            if (n2 > n3) {
                n2 = n3;
            }
            int n5 = 176 * n2 / n3;
            sDKGraphics.fillRect(88, n4 + 4 + m_loadingFontHeight, n5, 2);
        }
    }

    private static int onCreate(int n2, int n3) {
        try {
            switch (n2) {
                case 1: {
                    if (m_globalArray[3] == 0) {
                        XMLMenuSystem.m_globalArray[3] = 1;
                        n3 = 31;
                        m_backFromGame = true;
                        XMLMenuSystem.writeRMSMenu();
                    }
                    if (Game.m_menuGameMode == 3 && (Game.m_stillInTournament || Game.m_ttPlaying)) {
                        n3 = 23;
                    }
                    if (Game.m_menuGameMode >= 5) {
                        n3 = Game.m_tutorialOn ? 8 : 7;
                        m_backFromGame = true;
                    }
                    if (Game.m_menuGameMode <= 5) break;
                    n3 = 8;
                    m_backFromGame = true;
                    break;
                }
                case 3: {
                    if (Game.m_menuGameMode <= 3) {
                        boolean bl = false;
                        if (Game.m_loadType == 0) {
                            if (Game.m_menuGameMode == 3) {
                                if (Game.m_ttPlaying) {
                                    Game.restoreGame(2);
                                    bl = true;
                                }
                            } else if (Game.m_menuGameMode == 2) {
                                if (Game.m_pnPlaying) {
                                    Game.restoreGame(1);
                                    bl = true;
                                }
                            } else if (Game.m_menuGameMode == 0) {
                                Game.restoreGame(3);
                                bl = true;
                            } else if (Game.m_menuGameMode == 1) {
                                Game.restoreGame(4);
                                bl = true;
                            }
                        }
                        if (Game.gameType == 1) {
                            Game.getStats(Game.teams[0], Game.teams[1], true);
                            Game.createBowlersList();
                            m_prevMenu = 4;
                            n3 = 4;
                        } else {
                            Game.getStats(Game.teams[1], Game.teams[0], true);
                            Game.createBowlersList();
                            n3 = 3;
                        }
                        if (bl) {
                            Game.setGameControl(41);
                            break;
                        }
                        if (Game.m_loadType == 0) {
                            Game.initMatch();
                        }
                        break;
                    }
                    Game.menuResetVariables();
                    Game.m_tutorialStage = 0;
                    Game.teams[0] = 0;
                    Game.teams[1] = 1;
                    Game.maxOvers = 1;
                    Game.currentOver = 1;
                    Game.currentBowler = 0;
                    Game.m_difficulty = 1;
                    Game.initMatch();
                    if (Game.gameType == 1) {
                        Game.m_gamePrevControl = 7;
                        n3 = 11;
                        XMLMenuSystem.m_globalArray[15] = 502;
                        XMLMenuSystem.m_globalArray[16] = 0;
                    } else {
                        Game.bowlsLeft = 6;
                        Game.currentBowler = Game.m_menuBowlersList[0];
                        n3 = 3;
                    }
                    if (Game.m_menuGameMode >= 6) {
                        n3 = 9;
                        XMLMenuSystem.setTutorialMessage();
                    }
                    Game.setInitialBatBowl();
                    Game.lastFielderFormation = 0;
                    break;
                }
                case 2: {
                    n3 = 0;
                }
            }
        }
        catch (Exception exception) {
            MainFrame.m_loadError = 1;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            MainFrame.m_loadError = 1;
        }
        catch (Error error) {
            MainFrame.m_loadError = 1;
        }
        return n3;
    }

    private static void onDestroy(int n2) {
        switch (n2) {
            case 1: {
                XMLMenuSystem.setupLoadingImage();
                break;
            }
            case 3: {
                XMLMenuSystem.setupLoadingImage();
                break;
            }
            case 2: {
                XMLMenuSystem.setupLoadingImage();
            }
        }
    }

    private static void onMenuInit(int n2, int n3) {
        block93: {
            m_scrollUp = 0;
            m_scrollDown = 0;
            XMLMenuSystem.m_workArray[235] = m_scrollUp;
            XMLMenuSystem.m_workArray[236] = m_scrollDown;
            block0 : switch (n2) {
                case 1: {
                    switch (n3) {
                        case 2: {
                            m_backFromGame = false;
                            break;
                        }
                        case 7: {
                            if (m_backFromGame) {
                                XMLMenuSystem.setSoftKeys(6, 472);
                            }
                            Game.m_menuGameMode = 5;
                            Game.m_tutorialOn = false;
                            break;
                        }
                        case 8: {
                            if (m_backFromGame) {
                                XMLMenuSystem.setSoftKeys(6, 472);
                            }
                            Game.m_menuGameMode = 5;
                            Game.m_tutorialOn = true;
                            break;
                        }
                        case 11: {
                            XMLMenuSystem.m_workArray[101] = Game.teams[0];
                            Game.getStats(Game.teams[0], Game.teams[0], false);
                            XMLMenuSystem.m_workArray[0] = -1;
                            XMLMenuSystem.populateSquad(Game.teams[0]);
                            m_flashCounter = 0;
                            break;
                        }
                        case 30: {
                            XMLMenuSystem.m_workArray[100] = 4288390;
                            XMLMenuSystem.m_workArray[101] = 3233127;
                            XMLMenuSystem.m_workArray[6] = 0;
                            XMLMenuSystem.m_workArray[7] = 1;
                            XMLMenuSystem.m_workArray[8] = 0;
                            if (m_globalArray[5] == 0) {
                                XMLMenuSystem.m_workArray[9] = 0;
                                XMLMenuSystem.populateTable(0, m_globalArray[5]);
                                break;
                            }
                            XMLMenuSystem.m_workArray[9] = 5;
                            XMLMenuSystem.populateTable(5, m_globalArray[5]);
                            break;
                        }
                        case 6: {
                            XMLMenuSystem.m_workArray[0] = 397;
                            XMLMenuSystem.m_workArray[1] = 86;
                            break;
                        }
                        case 24: {
                            Game.teams[1] = Game.getNext2020Match();
                            XMLMenuSystem.m_workArray[0] = Game.teams[0];
                            XMLMenuSystem.m_workArray[1] = Game.teams[1];
                            XMLMenuSystem.m_workArray[2] = Game.m_batBowField[m_workArray[0] * 3 + 0];
                            XMLMenuSystem.m_workArray[3] = Game.m_batBowField[m_workArray[0] * 3 + 1];
                            XMLMenuSystem.m_workArray[4] = Game.m_batBowField[m_workArray[0] * 3 + 2];
                            XMLMenuSystem.m_workArray[5] = Game.m_batBowField[m_workArray[1] * 3 + 0];
                            XMLMenuSystem.m_workArray[6] = Game.m_batBowField[m_workArray[1] * 3 + 1];
                            XMLMenuSystem.m_workArray[7] = Game.m_batBowField[m_workArray[1] * 3 + 2];
                        }
                        case 23: {
                            XMLMenuSystem.m_workArray[50] = 0;
                            if (!Game.m_ttPlaying) break;
                            XMLMenuSystem.m_workArray[50] = 1;
                            break;
                        }
                        case 21: {
                            Game.initMatch();
                            XMLMenuSystem.m_workArray[0] = 0;
                            XMLMenuSystem.m_workArray[1] = Game.m_pnTeams[0];
                            XMLMenuSystem.m_workArray[2] = Game.m_batBowField[m_workArray[1] * 3 + 0];
                            XMLMenuSystem.m_workArray[3] = Game.m_batBowField[m_workArray[1] * 3 + 1];
                            XMLMenuSystem.m_workArray[4] = Game.m_batBowField[m_workArray[1] * 3 + 2];
                            break;
                        }
                        case 10: {
                            Game.initMatch();
                            XMLMenuSystem.m_workArray[0] = 0;
                            XMLMenuSystem.m_workArray[8] = Game.m_pnTeams[0];
                            XMLMenuSystem.m_workArray[2] = Game.m_batBowField[m_workArray[8] * 3 + 0];
                            XMLMenuSystem.m_workArray[3] = Game.m_batBowField[m_workArray[8] * 3 + 1];
                            XMLMenuSystem.m_workArray[4] = Game.m_batBowField[m_workArray[8] * 3 + 2];
                            XMLMenuSystem.m_workArray[1] = 1;
                            XMLMenuSystem.m_workArray[9] = Game.m_pnTeams[1];
                            XMLMenuSystem.m_workArray[5] = Game.m_batBowField[m_workArray[9] * 3 + 0];
                            XMLMenuSystem.m_workArray[6] = Game.m_batBowField[m_workArray[9] * 3 + 1];
                            XMLMenuSystem.m_workArray[7] = Game.m_batBowField[m_workArray[9] * 3 + 2];
                            break;
                        }
                        case 25: {
                            XMLMenuSystem.populateFixtures(0, 0);
                            XMLMenuSystem.m_workArray[24] = 0;
                            break;
                        }
                        case 26: {
                            XMLMenuSystem.populateFixtures(1, 0);
                            XMLMenuSystem.m_workArray[24] = 0;
                            break;
                        }
                        case 27: {
                            XMLMenuSystem.populateFixtures(2, 0);
                            XMLMenuSystem.m_workArray[24] = 0;
                            break;
                        }
                        case 28: {
                            XMLMenuSystem.populateFixtures(3, 0);
                            XMLMenuSystem.m_workArray[24] = 0;
                            break;
                        }
                        case 12: 
                        case 13: 
                        case 14: {
                            XMLMenuSystem.m_workArray[20] = Game.m_menuGameMode == 3 ? 450 : 452;
                            XMLMenuSystem.m_workArray[2] = Game.teams[0];
                            XMLMenuSystem.m_workArray[3] = Game.teams[1];
                            if (Game.gameType == 1) {
                                XMLMenuSystem.m_workArray[10] = 448;
                                break;
                            }
                            XMLMenuSystem.m_workArray[10] = 449;
                            break;
                        }
                        case 32: 
                        case 33: {
                            m_selection = 1;
                            break;
                        }
                        case 16: {
                            XMLMenuSystem.m_workArray[2] = m_globalArray[8] * 6 + m_globalArray[7];
                            XMLMenuSystem.m_workArray[4] = 1;
                            if (Game.m_challengeUnlocked[m_globalArray[8]] == m_globalArray[7]) {
                                XMLMenuSystem.m_workArray[4] = 0;
                                break;
                            }
                            if (m_globalArray[7] > Game.m_challengeUnlocked[m_globalArray[8]]) {
                                XMLMenuSystem.m_workArray[3] = 0;
                                break;
                            }
                            XMLMenuSystem.m_workArray[3] = 1;
                            break;
                        }
                        case 15: {
                            Game.m_menuGameMode = 0;
                            if (!Game.m_chPlaying) break;
                            XMLMenuSystem.SetMenu(22);
                            break;
                        }
                        case 17: {
                            XMLMenuSystem.m_workArray[0] = Game.m_challengeNum % 6;
                            XMLMenuSystem.m_workArray[1] = Game.m_challengeNum / 6;
                            XMLMenuSystem.m_workArray[2] = Game.m_challengeNum;
                            break;
                        }
                        case 18: {
                            Game.m_menuGameMode = 1;
                            if (Game.m_tmPlaying) {
                                XMLMenuSystem.SetMenu(22);
                                break;
                            }
                            XMLMenuSystem.m_workArray[2] = m_globalArray[11] * 6 + m_globalArray[10];
                            XMLMenuSystem.m_workArray[4] = 1;
                            if (Game.m_testMatchUnlocked[m_globalArray[11]] == m_globalArray[10]) {
                                XMLMenuSystem.m_workArray[4] = 0;
                            } else {
                                XMLMenuSystem.m_workArray[3] = m_globalArray[10] > Game.m_testMatchUnlocked[m_globalArray[11]] ? 0 : 1;
                            }
                            if (m_globalArray[10] != 5 || m_workArray[3] != 1) break;
                            XMLMenuSystem.m_globalArray[10] = 0;
                            break;
                        }
                        case 19: {
                            XMLMenuSystem.m_workArray[0] = Game.m_testMatchNum % 6;
                            XMLMenuSystem.m_workArray[1] = Game.m_testMatchNum / 6;
                            XMLMenuSystem.m_workArray[2] = Game.m_testMatchNum;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (n3) {
                        case 0: 
                        case 20: 
                        case 24: {
                            MainFrame.soundStopAll();
                            XMLMenuSystem.m_workArray[0] = Game.teams[Game.battingTeam];
                            XMLMenuSystem.m_workArray[1] = Game.m_teamRuns[1 - Game.battingTeam] + 1;
                            XMLMenuSystem.m_workArray[2] = Game.gameTypesPlayed == 1 ? 1 : 0;
                            if (Game.m_menuGameMode == 0 && n3 == 0) {
                                XMLMenuSystem.SetMenu(20);
                            }
                            if (Game.m_menuGameMode == 1 && n3 == 0) {
                                XMLMenuSystem.SetMenu(24);
                                break block0;
                            }
                            break block93;
                        }
                        case 3: {
                            int n4;
                            int n5 = 0;
                            XMLMenuSystem.m_workArray[101] = Game.teams[0];
                            XMLMenuSystem.m_workArray[70] = 0;
                            XMLMenuSystem.m_workArray[233] = 0;
                            XMLMenuSystem.m_workArray[234] = 1;
                            if (m_scrollValues[7] > 0 && (n4 = 8 - m_scrollValues[7]) < 8 && Game.m_menuBowlersList[n4] != -1) {
                                XMLMenuSystem.m_workArray[232] = 1;
                            }
                            for (n4 = 0; n4 < 8; ++n4) {
                                if (Game.m_menuBowlersList[n4] != -1) {
                                    XMLMenuSystem.m_workArray[80 + n4] = 1;
                                    XMLMenuSystem.m_workArray[n4] = Game.m_menuBowlersList[n4];
                                    XMLMenuSystem.m_workArray[10 + n4] = Game.bowlingStats[Game.m_menuBowlersList[n4]][0];
                                    XMLMenuSystem.m_workArray[20 + n4] = Game.m_statsTable[(Game.teams[0] * 20 + Game.m_menuBowlersList[n4]) * 7 + 4];
                                    XMLMenuSystem.m_workArray[30 + n4] = Game.m_statsTable[(Game.teams[0] * 20 + Game.m_menuBowlersList[n4]) * 7 + 5];
                                    XMLMenuSystem.m_workArray[40 + n4] = m_playerNameIds[Game.teams[0] + Game.getTPInd()];
                                    XMLMenuSystem.m_workArray[60 + n4] = Game.bowlingStats[Game.m_menuBowlersList[n4]][4] == 12 ? 0 : 1;
                                    XMLMenuSystem.m_workArray[50 + n4] = (n4 & 1) == 0 ? 4288390 : 3233127;
                                    ++n5;
                                    continue;
                                }
                                XMLMenuSystem.m_workArray[80 + n4] = 0;
                                XMLMenuSystem.m_workArray[40 + n4] = 7;
                                XMLMenuSystem.m_workArray[n4] = 0;
                                XMLMenuSystem.m_workArray[10 + n4] = 0;
                                XMLMenuSystem.m_workArray[20 + n4] = 0;
                                XMLMenuSystem.m_workArray[30 + n4] = 0;
                                XMLMenuSystem.m_workArray[60 + n4] = 2;
                                XMLMenuSystem.m_workArray[50 + n4] = 1715510;
                            }
                            break block93;
                        }
                        case 4: 
                        case 5: {
                            if (m_prevMenu == 0 || m_prevMenu == 20 || m_prevMenu == 24) {
                                XMLMenuSystem.setSoftKeys(7, 9);
                            } else if (m_prevMenu == 6) {
                                XMLMenuSystem.setSoftKeys(6, 9);
                            }
                            int n6 = 0;
                            if (n3 == 5) {
                                n6 = 1;
                            }
                            XMLMenuSystem.m_workArray[22] = Game.teams[n6];
                            if (Game.gameTypesPlayed > 0) {
                                if (Game.battingTeam == n6) {
                                    XMLMenuSystem.m_workArray[233] = 1;
                                } else {
                                    XMLMenuSystem.m_workArray[234] = 1;
                                }
                            }
                            int n7 = 0;
                            for (int i2 = 0; i2 < 11; ++i2) {
                                XMLMenuSystem.m_workArray[i2] = Game.m_menuBattersList[n6][i2];
                                XMLMenuSystem.m_workArray[11 + i2] = Game.m_batsmanRuns[n6][i2];
                                XMLMenuSystem.m_workArray[31 + i2] = m_playerNameIds[Game.teams[n6] + Game.getTPInd()];
                                n7 += Game.m_batsmanRuns[n6][i2];
                                if (Game.m_batsmanAvailable[n6][i2] != 0) {
                                    XMLMenuSystem.m_workArray[120 + i2] = 0;
                                    if (Game.m_batsmanAvailable[n6][i2] == 2) {
                                        XMLMenuSystem.m_workArray[100 + i2] = 15218230;
                                        continue;
                                    }
                                    if ((i2 & 1) == 0) {
                                        XMLMenuSystem.m_workArray[100 + i2] = 4288390;
                                        continue;
                                    }
                                    XMLMenuSystem.m_workArray[100 + i2] = 3233127;
                                    continue;
                                }
                                XMLMenuSystem.m_workArray[120 + i2] = Game.m_batsmanAvailable[n6][i2];
                                XMLMenuSystem.m_workArray[100 + i2] = 1715510;
                            }
                            XMLMenuSystem.m_workArray[25] = Game.m_batsmanRuns[n6][11];
                            XMLMenuSystem.m_workArray[24] = n7 += m_workArray[25];
                            XMLMenuSystem.m_workArray[23] = Game.m_numOversPld[n6];
                            XMLMenuSystem.m_workArray[26] = Game.m_numDeliveries[n6] & 0x3F;
                            break block0;
                        }
                        case 6: {
                            XMLMenuSystem.m_workArray[0] = Game.m_resultType;
                            XMLMenuSystem.m_workArray[1] = Game.m_resultType == 4 ? 18 : Game.teams[Game.m_menuMatchWinner];
                            XMLMenuSystem.m_workArray[2] = Game.m_teamRuns[Game.m_menuMatchWinner] - Game.m_teamRuns[1 - Game.m_menuMatchWinner];
                            XMLMenuSystem.m_workArray[3] = 10 - Game.m_numBatsmenOut[Game.m_menuMatchWinner];
                            XMLMenuSystem.m_workArray[10] = Game.teams[0];
                            XMLMenuSystem.m_workArray[11] = Game.m_teamRuns[0];
                            XMLMenuSystem.m_workArray[12] = Game.m_numBatsmenOut[0];
                            XMLMenuSystem.m_workArray[13] = Game.m_numOversPld[0];
                            XMLMenuSystem.m_workArray[14] = Game.m_numDeliveries[0] & 0x3F;
                            XMLMenuSystem.m_workArray[20] = Game.teams[1];
                            XMLMenuSystem.m_workArray[21] = Game.m_teamRuns[1];
                            XMLMenuSystem.m_workArray[22] = Game.m_numBatsmenOut[1];
                            XMLMenuSystem.m_workArray[23] = Game.m_numOversPld[1];
                            XMLMenuSystem.m_workArray[24] = Game.m_numDeliveries[1] & 0x3F;
                            break block0;
                        }
                        case 7: {
                            if (Game.m_menuGameMode == 3) {
                                int n8 = Game.m_ttStage;
                                Game.progressToNext2020Stage();
                                if (Game.m_stillInTournament) {
                                    if (Game.m_menuMatchWinner == 0) {
                                        if (Game.m_resultType == 4) {
                                            if (Game.m_ttStage == 1 && Game.m_numMatchesPlayed == 0 || Game.m_ttStage == 2 && Game.m_numMatchesPlayed == 0) {
                                                XMLMenuSystem.m_workArray[1] = 10;
                                                break block0;
                                            }
                                            XMLMenuSystem.m_workArray[1] = 9;
                                            break block0;
                                        }
                                        if (Game.m_ttStage == 3 && Game.m_numMatchesPlayed == 0) {
                                            XMLMenuSystem.m_workArray[1] = 7;
                                            break block0;
                                        }
                                        if (Game.m_ttStage == 2 && Game.m_numMatchesPlayed == 0) {
                                            XMLMenuSystem.m_workArray[1] = 6;
                                            break block0;
                                        }
                                        if (Game.m_ttStage == 1 && Game.m_numMatchesPlayed == 0) {
                                            XMLMenuSystem.m_workArray[1] = 5;
                                            break block0;
                                        }
                                        XMLMenuSystem.m_workArray[1] = 0;
                                        break block0;
                                    }
                                    XMLMenuSystem.m_workArray[1] = 1;
                                    break block0;
                                }
                                if (Game.m_menuMatchWinner == 0) {
                                    if (Game.m_resultType == 4) {
                                        XMLMenuSystem.m_workArray[1] = 11;
                                        break block0;
                                    }
                                    XMLMenuSystem.m_workArray[1] = 2;
                                    break block0;
                                }
                                if (n8 == 3) {
                                    XMLMenuSystem.m_workArray[1] = 12;
                                    break block0;
                                }
                                if (n8 == 2) {
                                    XMLMenuSystem.m_workArray[1] = 8;
                                    break block0;
                                }
                                XMLMenuSystem.m_workArray[1] = 3;
                                break block0;
                            }
                            if (Game.m_menuMatchWinner == 0) {
                                if (Game.m_resultType == 4) {
                                    XMLMenuSystem.m_workArray[1] = 9;
                                    break block0;
                                }
                                XMLMenuSystem.m_workArray[1] = 0;
                                break block0;
                            }
                            XMLMenuSystem.m_workArray[1] = 1;
                            break block0;
                        }
                        case 15: {
                            if (Game.gameType == 1) {
                                XMLMenuSystem.m_workArray[0] = 500;
                                break block0;
                            }
                            XMLMenuSystem.m_workArray[0] = 501;
                            break block0;
                        }
                        case 12: 
                        case 13: {
                            if (Game.m_fieldingTutorial) {
                                XMLMenuSystem.setSoftKeys(6, 7);
                            }
                            if (Game.gameType == 0 && (Game.m_gamePrevControl == 5 || Game.m_gamePrevControl == 6 || Game.m_gamePrevControl == 29 || Game.m_fieldingTutorial)) {
                                XMLMenuSystem.m_workArray[3] = 604;
                                XMLMenuSystem.m_workArray[2] = 1;
                                XMLMenuSystem.m_workArray[6] = 0;
                            } else {
                                XMLMenuSystem.m_workArray[3] = 603;
                                XMLMenuSystem.m_workArray[2] = 0;
                                XMLMenuSystem.m_workArray[6] = 0;
                                m_selection = -10;
                            }
                            XMLMenuSystem.m_workArray[4] = 0;
                            XMLMenuSystem.m_workArray[5] = Game.fielderFormation;
                            if (m_workArray[5] > Game.m_fieldRange[1]) {
                                m_workArray[5] = m_workArray[5] - Game.m_fieldRange[3];
                                XMLMenuSystem.m_workArray[1] = 1;
                            } else {
                                XMLMenuSystem.m_workArray[1] = 0;
                            }
                            if (Game.m_fieldRestricted) {
                                XMLMenuSystem.m_workArray[10] = 0;
                                break block0;
                            }
                            XMLMenuSystem.m_workArray[10] = 1;
                            break block0;
                        }
                        case 14: 
                        case 17: {
                            m_selection = 1;
                            break block0;
                        }
                        case 18: {
                            if (Game.m_challengeStatus != 1) {
                                XMLMenuSystem.SetMenu(19);
                                break block0;
                            }
                            break block93;
                        }
                        case 22: {
                            if (Game.m_testMatchStatus != 1) {
                                XMLMenuSystem.SetMenu(23);
                                break block0;
                            }
                            break block93;
                        }
                        case 21: {
                            XMLMenuSystem.m_workArray[0] = Game.m_challengeNum % 6;
                            XMLMenuSystem.m_workArray[1] = Game.m_challengeNum / 6;
                            XMLMenuSystem.m_workArray[2] = Game.m_challengeNum;
                            for (int i3 = 0; i3 < 11; ++i3) {
                                if (Game.m_challengeTarget[i3] > 1) {
                                    XMLMenuSystem.m_workArray[3] = i3;
                                    break block0;
                                }
                                if (Game.m_challengeTarget[i3] != 1) continue;
                                XMLMenuSystem.m_workArray[3] = i3;
                            }
                            break block93;
                        }
                        case 25: {
                            XMLMenuSystem.m_workArray[0] = Game.m_testMatchNum % 6;
                            XMLMenuSystem.m_workArray[1] = Game.m_testMatchNum / 6;
                            XMLMenuSystem.m_workArray[2] = Game.m_testMatchNum;
                            for (int i4 = 0; i4 < 6; ++i4) {
                                if (Game.m_testMatchTarget[i4] > 1) {
                                    XMLMenuSystem.m_workArray[3] = i4;
                                    break block0;
                                }
                                if (Game.m_testMatchTarget[i4] != 1) continue;
                                XMLMenuSystem.m_workArray[3] = i4;
                            }
                        }
                    }
                }
            }
        }
    }

    private static void onMenuExit(int n2, int n3) {
        switch (n2) {
            case 1: {
                if (n3 == 2) {
                    switch (m_selection) {
                        case 0: {
                            Game.m_menuGameMode = 2;
                            break;
                        }
                        case 2: {
                            Game.m_menuGameMode = 3;
                        }
                    }
                    break;
                }
                if (n3 == 0) {
                    // empty if block
                }
                if (n3 == 3) {
                    XMLMenuSystem.writeRMSMenu();
                    break;
                }
                if (n3 == 9) {
                    Game.m_difficulty = m_workArray[0];
                    Game.m_menuOvers = Game.m_maxMatchOvers[m_workArray[1]];
                    Game.m_matchOversType = m_workArray[1];
                    Game.maxOvers = Game.m_menuOvers;
                    Game.m_powerPlays = m_workArray[2] == 0;
                    Game.currentOver = 1;
                    Game.m_pnPlaying = false;
                    break;
                }
                if (n3 == 20) {
                    Game.m_ttDifficulty = m_workArray[0];
                    Game.m_menuOvers = Game.m_maxMatchOvers[m_workArray[1]];
                    Game.m_matchOversType = m_workArray[1];
                    Game.m_ttMaxOvers = Game.m_menuOvers;
                    Game.m_ttPowerPlays = m_workArray[2] == 0;
                    Game.currentOver = 1;
                    Game.m_difficulty = Game.m_ttDifficulty;
                    Game.maxOvers = Game.m_ttMaxOvers;
                    Game.resetTT();
                    break;
                }
                if (n3 == 22) {
                    if (Game.m_menuGameMode != 3) break;
                    Game.teams[0] = Game.m_ttTeam;
                    break;
                }
                if (n3 == 15) {
                    XMLMenuSystem.m_globalArray[7] = Game.m_challengeUnlocked[m_globalArray[8]];
                    if (m_globalArray[7] < 6) break;
                    XMLMenuSystem.m_globalArray[7] = 5;
                    break;
                }
                if (n3 != 18) break;
                XMLMenuSystem.m_globalArray[10] = Game.m_testMatchUnlocked[m_globalArray[11]];
                if (m_globalArray[10] < 6) break;
                XMLMenuSystem.m_globalArray[10] = 5;
                break;
            }
            case 3: {
                if (n3 == 2) {
                    XMLMenuSystem.writeRMSMenu();
                }
                if (n3 != 9 || Game.m_tutorialStage != 0) break;
                ++Game.m_tutorialStage;
                XMLMenuSystem.setTutorialMessage();
                if (Game.m_menuGameMode != 8) break;
                Game.m_viewType = 1;
                MicroGame.init(3000, 0);
                MicroGame.setEvenRanges(1, 16);
                Game.createMicroGameBar();
                break;
            }
            case 2: {
                if (n3 != -8) break;
                XMLMenuSystem.loadMenuText();
            }
        }
    }

    private static int onMenuAction(int n2, int n3, int n4, int n5) {
        block227: {
            block0 : switch (n2) {
                case 1: {
                    switch (n5) {
                        case 4: {
                            if ((n4 & 3) != 0) {
                                m_soundMenuRestart = false;
                                XMLMenuSystem.m_globalArray[1] = m_workArray[0];
                                MainFrame.soundSetOnOff(m_globalArray[1] == 0);
                                MainFrame.soundPlay(13, 2);
                                break;
                            }
                            break block227;
                        }
                        case 5: {
                            if ((n4 & 3) != 0) {
                                XMLMenuSystem.m_globalArray[2] = m_workArray[1];
                                MainFrame.vibrateSetOnOff(m_globalArray[2] == 0);
                                MainFrame.vibratePlay(1000);
                                break;
                            }
                            break block227;
                        }
                        case 6: {
                            if (m_selection == 2) {
                                if (Game.m_tutorialOn) {
                                    Game.m_menuGameMode = 8;
                                }
                                Game.gameType = 0;
                            } else if (m_selection == 1) {
                                if (Game.m_tutorialOn) {
                                    Game.m_menuGameMode = 7;
                                }
                                Game.gameType = 0;
                            } else {
                                if (Game.m_tutorialOn) {
                                    Game.m_menuGameMode = 6;
                                }
                                Game.gameType = 1;
                            }
                            if ((n4 & 0x70) != 0) {
                                m_backFromGame = false;
                                break;
                            }
                            break block227;
                        }
                        case 9: {
                            int n6;
                            int n7 = 15;
                            if (m_workArray[0] == m_workArray[1]) {
                                if ((n4 & 2) != 0) {
                                    int n8 = m_selection;
                                    m_workArray[n8] = m_workArray[n8] + 1;
                                    if (m_workArray[m_selection] >= n7) {
                                        XMLMenuSystem.m_workArray[XMLMenuSystem.m_selection] = 0;
                                    }
                                } else if ((n4 & 1) != 0) {
                                    int n9 = m_selection;
                                    m_workArray[n9] = m_workArray[n9] - 1;
                                    if (m_workArray[m_selection] < 0) {
                                        XMLMenuSystem.m_workArray[XMLMenuSystem.m_selection] = n7 - 1;
                                    }
                                }
                            }
                            Game.teams[0] = n6 = Game.m_pnTeams[m_workArray[0]];
                            XMLMenuSystem.m_workArray[2] = Game.m_batBowField[n6 * 3 + 0];
                            XMLMenuSystem.m_workArray[3] = Game.m_batBowField[n6 * 3 + 1];
                            XMLMenuSystem.m_workArray[4] = Game.m_batBowField[n6 * 3 + 2];
                            XMLMenuSystem.m_workArray[8] = n6;
                            Game.teams[1] = n6 = Game.m_pnTeams[m_workArray[1]];
                            XMLMenuSystem.m_workArray[5] = Game.m_batBowField[n6 * 3 + 0];
                            XMLMenuSystem.m_workArray[6] = Game.m_batBowField[n6 * 3 + 1];
                            XMLMenuSystem.m_workArray[7] = Game.m_batBowField[n6 * 3 + 2];
                            XMLMenuSystem.m_workArray[9] = n6;
                            break;
                        }
                        case 12: {
                            Game.teams[0] = Game.m_ttTeam = Game.m_pnTeams[m_workArray[0]];
                            XMLMenuSystem.m_workArray[1] = Game.teams[0];
                            XMLMenuSystem.m_workArray[2] = Game.m_batBowField[Game.m_ttTeam * 3 + 0];
                            XMLMenuSystem.m_workArray[3] = Game.m_batBowField[Game.m_ttTeam * 3 + 1];
                            XMLMenuSystem.m_workArray[4] = Game.m_batBowField[Game.m_ttTeam * 3 + 2];
                            if (n4 != 0) {
                                Game.generateGroups();
                                Game.createMatches();
                                break;
                            }
                            break block227;
                        }
                        case 8: {
                            int n10;
                            if ((n4 & 1) != 0) {
                                if (m_workArray[0] == -1) {
                                    XMLMenuSystem.m_workArray[0] = m_selection;
                                } else if (m_workArray[0] != -1 && m_workArray[0] != m_selection) {
                                    if (m_workArray[233] == 1) {
                                        n10 = Game.m_menuPlayersList[m_workArray[0]];
                                        Game.m_menuPlayersList[XMLMenuSystem.m_workArray[0]] = Game.m_menuPlayersList[m_selection];
                                        Game.m_menuBattersList[0][XMLMenuSystem.m_workArray[0]] = Game.m_menuBattersList[0][m_selection];
                                        Game.m_menuPlayersList[XMLMenuSystem.m_selection] = n10;
                                        Game.m_menuBattersList[0][XMLMenuSystem.m_selection] = n10;
                                        XMLMenuSystem.m_workArray[0] = -1;
                                    }
                                } else {
                                    XMLMenuSystem.m_workArray[0] = -1;
                                }
                                XMLMenuSystem.populateSquad(Game.teams[0]);
                            }
                            if ((n4 & 0x50) != 0) {
                                if ((DDMath.getRandom() & 1) == 0 && Game.m_menuGameMode == 3) {
                                    Game.gameType = (DDMath.getRandom() & 1) == 0 ? 1 : 0;
                                    XMLMenuSystem.SetMenu(13);
                                } else {
                                    XMLMenuSystem.SetMenu(12);
                                }
                            } else if ((n4 & 0x20) != 0) {
                                if (Game.m_menuGameMode == 3) {
                                    XMLMenuSystem.SetMenu(24);
                                } else {
                                    XMLMenuSystem.SetMenu(10);
                                }
                            }
                            XMLMenuSystem.m_workArray[231] = m_selection == 0 ? 0 : 1;
                            XMLMenuSystem.m_workArray[232] = m_selection >= m_selectionNumber - 1 ? 0 : 1;
                            XMLMenuSystem.m_workArray[233] = 1;
                            if (m_workArray[0] >= 0) {
                                byte by;
                                n10 = m_workArray[0];
                                if (n10 == m_selection || n10 < 11 && m_selection < 11 || Game.m_menuPlayersList[n10] != (by = Game.m_wicketKeepers[Game.teams[0]]) && Game.m_menuPlayersList[m_selection] != by) break block0;
                                XMLMenuSystem.m_workArray[233] = 0;
                                break;
                            }
                            break block227;
                        }
                        case 7: {
                            if ((n4 & 0x50) != 0) {
                                Game.gameType = m_selection == 0 ? 1 : 0;
                            }
                        }
                        case 43: {
                            if ((n4 & 0x50) != 0) {
                                XMLMenuSystem.SetMenu(14);
                                break;
                            }
                            break block227;
                        }
                        case 10: {
                            if ((n4 & 0x40) != 0) {
                                XMLMenuSystem.m_globalArray[5] = m_selection;
                                break;
                            }
                            break block227;
                        }
                        case 11: {
                            int n11 = 1;
                            XMLMenuSystem.m_workArray[6] = 0;
                            XMLMenuSystem.m_workArray[7] = 0;
                            if ((n4 & 1) != 0 && m_workArray[8] > 0) {
                                m_workArray[8] = m_workArray[8] - 1;
                            } else if ((n4 & 2) != 0 && m_workArray[8] < n11) {
                                m_workArray[8] = m_workArray[8] + 1;
                            }
                            if (m_workArray[8] != 0) {
                                XMLMenuSystem.m_workArray[6] = 1;
                            }
                            if (m_workArray[8] < n11) {
                                XMLMenuSystem.m_workArray[7] = 1;
                            }
                            if (m_globalArray[5] == 0) {
                                if ((n4 & 0xC) != 0) {
                                    int n12 = m_workArray[9];
                                    if ((n4 & 4) != 0) {
                                        m_workArray[9] = m_workArray[9] - 1;
                                    } else if ((n4 & 8) != 0) {
                                        m_workArray[9] = m_workArray[9] + 1;
                                    }
                                    if (m_workArray[9] < 0) {
                                        XMLMenuSystem.m_workArray[9] = 3;
                                    }
                                    if (m_workArray[9] >= 4) {
                                        XMLMenuSystem.m_workArray[9] = 0;
                                    }
                                    if (n12 != m_workArray[9]) {
                                        XMLMenuSystem.populateTable(m_workArray[9], m_globalArray[5]);
                                        m_menuRefreshCount = 1;
                                    }
                                }
                            } else if ((n4 & 0xC) != 0) {
                                int n13 = m_workArray[9];
                                if ((n4 & 4) != 0) {
                                    m_workArray[9] = m_workArray[9] - 1;
                                } else if ((n4 & 8) != 0) {
                                    m_workArray[9] = m_workArray[9] + 1;
                                }
                                if (m_workArray[9] < 5) {
                                    XMLMenuSystem.m_workArray[9] = 6;
                                }
                                if (m_workArray[9] > 6) {
                                    XMLMenuSystem.m_workArray[9] = 5;
                                }
                                if (n13 != m_workArray[9]) {
                                    XMLMenuSystem.populateTable(m_workArray[9], m_globalArray[5]);
                                    m_menuRefreshCount = 1;
                                }
                            }
                            XMLMenuSystem.m_workArray[7] = 0;
                            XMLMenuSystem.m_workArray[6] = 0;
                            break;
                        }
                        case 13: {
                            if ((n4 & 0x50) != 0) {
                                if (Game.m_menuGameMode == 3) {
                                    Game.m_numMatchesPlayed = 0;
                                    Game.m_ttStage = 0;
                                    XMLMenuSystem.SetMenu(20);
                                    break;
                                }
                                if (Game.m_menuGameMode == 0) {
                                    Game.m_chPlaying = false;
                                    XMLMenuSystem.SetMenu(15);
                                    break;
                                }
                                if (Game.m_menuGameMode == 1) {
                                    Game.m_tmPlaying = false;
                                    XMLMenuSystem.SetMenu(18);
                                    break;
                                }
                                Game.m_pnPlaying = false;
                                Game.saveGame(0);
                                XMLMenuSystem.SetMenu(9);
                                break;
                            }
                            break block227;
                        }
                        case 20: {
                            if ((n4 & 0x50) != 0) {
                                if (m_selection != 0) {
                                    if (Game.m_ttStage != 0 || Game.m_numMatchesPlayed != 0 || Game.m_ttPlaying) {
                                        XMLMenuSystem.SetMenu(22);
                                        break;
                                    }
                                    Game.m_numMatchesPlayed = 0;
                                    Game.m_ttStage = 0;
                                    XMLMenuSystem.SetMenu(20);
                                    break;
                                }
                                if (Game.m_pnPlaying) {
                                    XMLMenuSystem.SetMenu(22);
                                    break;
                                }
                                XMLMenuSystem.SetMenu(9);
                                break;
                            }
                            break block227;
                        }
                        case 40: {
                            if ((n4 & 0x50) != 0) {
                                switch (m_globalArray[13]) {
                                    case 0: {
                                        XMLMenuSystem.m_globalArray[13] = 446;
                                        break;
                                    }
                                    case 2: {
                                        XMLMenuSystem.m_globalArray[13] = 13;
                                        break;
                                    }
                                    case 4: {
                                        XMLMenuSystem.m_globalArray[13] = 14;
                                        break;
                                    }
                                    case 6: {
                                        XMLMenuSystem.m_globalArray[13] = 402;
                                        break;
                                    }
                                    case 8: {
                                        XMLMenuSystem.m_globalArray[13] = 398;
                                        break;
                                    }
                                    case 10: {
                                        XMLMenuSystem.m_globalArray[13] = 474;
                                    }
                                }
                                XMLMenuSystem.m_globalArray[14] = XMLMenuSystem.getHelpTextBody(m_globalArray[14]);
                                break;
                            }
                            break block227;
                        }
                        case 14: {
                            if ((n4 & 1) != 0) {
                                m_workArray[24] = m_workArray[24] - 1;
                            } else if ((n4 & 2) != 0) {
                                m_workArray[24] = m_workArray[24] + 1;
                            }
                            if (m_workArray[24] < 3 && m_workArray[24] >= 0) {
                                XMLMenuSystem.populateFixtures(0, m_workArray[24]);
                                break;
                            }
                            if (m_workArray[24] < 0) {
                                XMLMenuSystem.SetMenu(28);
                                break;
                            }
                            if (m_workArray[24] > 2) {
                                XMLMenuSystem.SetMenu(26);
                                break;
                            }
                            break block227;
                        }
                        case 15: {
                            if ((n4 & 1) != 0) {
                                m_workArray[24] = m_workArray[24] - 1;
                            } else if ((n4 & 2) != 0) {
                                m_workArray[24] = m_workArray[24] + 1;
                            }
                            if (m_workArray[24] < 6 && m_workArray[24] >= 0) {
                                XMLMenuSystem.populateFixtures(1, m_workArray[24]);
                                break;
                            }
                            if (m_workArray[24] < 0) {
                                XMLMenuSystem.SetMenu(25);
                                XMLMenuSystem.m_workArray[24] = 2;
                                XMLMenuSystem.populateFixtures(0, m_workArray[24]);
                                break;
                            }
                            if (m_workArray[24] > 5) {
                                XMLMenuSystem.SetMenu(27);
                                break;
                            }
                            break block227;
                        }
                        case 16: {
                            if ((n4 & 1) != 0) {
                                m_workArray[24] = m_workArray[24] - 1;
                            } else if ((n4 & 2) != 0) {
                                m_workArray[24] = m_workArray[24] + 1;
                            }
                            if (m_workArray[24] < 2 && m_workArray[24] >= 0) {
                                XMLMenuSystem.populateFixtures(2, m_workArray[24]);
                                break;
                            }
                            if (m_workArray[24] < 0) {
                                XMLMenuSystem.SetMenu(26);
                                XMLMenuSystem.m_workArray[24] = 5;
                                XMLMenuSystem.populateFixtures(1, m_workArray[24]);
                                break;
                            }
                            if (m_workArray[24] > 1) {
                                XMLMenuSystem.SetMenu(28);
                                break;
                            }
                            break block227;
                        }
                        case 17: {
                            if ((n4 & 1) != 0) {
                                m_workArray[24] = m_workArray[24] - 1;
                            } else if ((n4 & 2) != 0) {
                                m_workArray[24] = m_workArray[24] + 1;
                            }
                            if (m_workArray[24] < 1 && m_workArray[24] >= 0) {
                                XMLMenuSystem.populateFixtures(3, m_workArray[24]);
                                break;
                            }
                            if (m_workArray[24] < 0) {
                                XMLMenuSystem.SetMenu(27);
                                XMLMenuSystem.m_workArray[24] = 1;
                                XMLMenuSystem.populateFixtures(2, m_workArray[24]);
                                break;
                            }
                            if (m_workArray[24] > 0) {
                                XMLMenuSystem.SetMenu(25);
                                break;
                            }
                            break block227;
                        }
                        case 18: {
                            if ((n4 & 0x50) != 0) {
                                if (Game.m_ttPlaying) {
                                    Game.setGameControl(4);
                                    Game.m_loadType = 0;
                                    MainFrame.m_masterNextState = 6;
                                    MainFrame.setMasterState(5);
                                    break;
                                }
                                XMLMenuSystem.SetMenu(11);
                                break;
                            }
                            break block227;
                        }
                        case 42: {
                            XMLMenuSystem.m_workArray[231] = m_menuTextBlockCurrentLine == 0 ? 0 : 1;
                            XMLMenuSystem.m_workArray[232] = m_menuTextBlockCurrentLine + m_menuTextBlockVisibleLines >= m_menuTextBlockTotalLines ? 0 : 1;
                            m_menuRefreshCount = 1;
                            break;
                        }
                        case 21: {
                            if ((n4 & 3) != 0) {
                                XMLMenuSystem.m_workArray[2] = m_workArray[1] * 6 + m_workArray[0];
                                XMLMenuSystem.m_workArray[4] = 1;
                                XMLMenuSystem.setSoftKeys(6, 9);
                                if (m_workArray[0] == Game.m_challengeUnlocked[m_workArray[1]]) {
                                    XMLMenuSystem.m_workArray[4] = 0;
                                    break;
                                }
                                if (m_workArray[0] > Game.m_challengeUnlocked[m_workArray[1]]) {
                                    XMLMenuSystem.m_workArray[3] = 0;
                                    XMLMenuSystem.setSoftKeys(7, 9);
                                    break;
                                }
                                XMLMenuSystem.m_workArray[3] = 1;
                                break;
                            }
                            break block227;
                        }
                        case 22: {
                            if ((n4 & 3) != 0) {
                                XMLMenuSystem.m_workArray[2] = m_workArray[1] * 6 + m_workArray[0];
                                XMLMenuSystem.m_workArray[4] = 1;
                                XMLMenuSystem.setSoftKeys(6, 9);
                                if (m_workArray[0] == Game.m_testMatchUnlocked[m_workArray[1]]) {
                                    XMLMenuSystem.m_workArray[4] = 0;
                                    break;
                                }
                                if (m_workArray[0] > Game.m_testMatchUnlocked[m_workArray[1]]) {
                                    XMLMenuSystem.m_workArray[3] = 0;
                                    XMLMenuSystem.setSoftKeys(7, 9);
                                    break;
                                }
                                XMLMenuSystem.m_workArray[3] = 1;
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case 3: {
                    switch (n5) {
                        case 8: {
                            if ((n4 & 3) != 0) {
                                m_soundMenuRestart = false;
                                XMLMenuSystem.m_globalArray[1] = m_workArray[0];
                                MainFrame.soundSetOnOff(m_globalArray[1] == 0);
                                if (m_globalArray[1] == 0) {
                                    MainFrame.soundPlay(0);
                                }
                            }
                            if ((n4 & 0x20) != 0) {
                                if (Game.m_menuGameMode >= 5) {
                                    XMLMenuSystem.SetMenu(1);
                                    break;
                                }
                                XMLMenuSystem.SetMenu(0);
                                break;
                            }
                            break block227;
                        }
                        case 9: {
                            if ((n4 & 3) != 0) {
                                XMLMenuSystem.m_globalArray[2] = m_workArray[1];
                                MainFrame.vibrateSetOnOff(m_globalArray[2] == 0);
                                MainFrame.vibratePlay(1000);
                            }
                            if ((n4 & 0x20) != 0) {
                                if (Game.m_menuGameMode >= 5) {
                                    XMLMenuSystem.SetMenu(1);
                                    break;
                                }
                                XMLMenuSystem.SetMenu(0);
                                break;
                            }
                            break block227;
                        }
                        case 13: {
                            if ((n4 & 3) != 0) {
                                XMLMenuSystem.m_globalArray[4] = m_workArray[2];
                            }
                            if ((n4 & 0x20) != 0) {
                                if (Game.m_menuGameMode >= 5) {
                                    XMLMenuSystem.SetMenu(1);
                                    break;
                                }
                                XMLMenuSystem.SetMenu(0);
                                break;
                            }
                            break block227;
                        }
                        case 2: {
                            if (m_prevMenu == 6) {
                                if ((n4 & 0x50) != 0) {
                                    if (Game.m_menuGameMode == 3 && Game.m_menuMatchWinner == 0 && Game.m_ttStage == 3) {
                                        Game.progressToNext2020Stage();
                                        XMLMenuSystem.SetMenu(8);
                                        break;
                                    }
                                    XMLMenuSystem.SetMenu(7);
                                    break;
                                }
                                if ((n4 & 0x20) != 0) {
                                    XMLMenuSystem.SetMenu(6);
                                }
                            } else if ((n4 & 0x50) != 0 && m_prevMenu != 0 && m_prevMenu != 20 && m_prevMenu != 24) {
                                n4 = 0;
                                Game.setInitialBatBowl();
                                if (Game.gameType == 0) {
                                    Game.m_gameNextControl = Game.bowlsLeft == 6 && !Game.wideLastBowl ? 5 : 6;
                                } else if (Game.bowlsLeft == 6 && !Game.wideLastBowl) {
                                    Game.bowlingSide = 1 - (DDMath.getRandom() & 2);
                                    Game.m_gameNextControl = 35;
                                } else {
                                    Game.m_gameNextControl = 7;
                                }
                                if (Game.m_batsmanOut) {
                                    Game.setGameControl(22);
                                } else {
                                    Game.setGameControl(Game.m_gameNextControl);
                                }
                                Game.m_batsmanOut = false;
                                if (Game.bowlsLeft == 6 && !Game.wideLastBowl) {
                                    Game.handleFieldRestriction(true);
                                }
                            } else if ((n4 & 0x20) != 0 && (m_prevMenu == 0 || m_prevMenu == 20 || m_prevMenu == 24)) {
                                XMLMenuSystem.SetMenu(0);
                            }
                            if ((n4 & 1) != 0 && m_workArray[233] != 0 || (n4 & 2) != 0 && m_workArray[234] != 0) {
                                int n14 = m_prevMenu;
                                if (n3 == 4) {
                                    XMLMenuSystem.SetMenu(5);
                                } else {
                                    XMLMenuSystem.SetMenu(4);
                                }
                                m_prevMenu = n14;
                                break;
                            }
                            break block227;
                        }
                        case 3: {
                            if ((n4 & 0x50) != 0) {
                                boolean bl = true;
                                Game.m_flash = 0;
                                if (Game.m_menuGameMode == 6) {
                                    if (Game.m_tutorialStage == 2) {
                                        MicroGame.init(3000, 3);
                                        MicroGame.setEvenRanges(1, Game.battingStats[Game.battersInPlay[Game.currentBatter]][0] / 3);
                                        Game.createMicroGameBar();
                                    } else if (Game.m_tutorialStage == 5) {
                                        Game.m_viewType = 1;
                                    } else if (Game.m_tutorialStage == 6) {
                                        Game.m_viewType = 0;
                                        bl = false;
                                        XMLMenuSystem.SetMenu(15);
                                    }
                                } else if (Game.m_menuGameMode == 7) {
                                    if (Game.m_tutorialStage == 2) {
                                        MicroGame.init(3000, 2);
                                        MicroGame.setEvenRanges(3, 8);
                                        Game.createMicroGameBar();
                                    } else if (Game.m_tutorialStage == 3) {
                                        bl = false;
                                        XMLMenuSystem.SetMenu(15);
                                    }
                                } else if (Game.m_menuGameMode == 8) {
                                    if (Game.m_tutorialStage == 1) {
                                        MicroGame.init(3000, 1);
                                        MicroGame.setEvenRanges(2, 10);
                                        Game.createMicroGameBar();
                                    } else if (Game.m_tutorialStage == 2) {
                                        Game.m_viewType = 1;
                                    } else if (Game.m_tutorialStage == 3) {
                                        Game.m_viewType = 0;
                                        bl = false;
                                        XMLMenuSystem.SetMenu(16);
                                    }
                                }
                                ++Game.m_tutorialStage;
                                XMLMenuSystem.setTutorialMessage();
                                XMLMenuSystem.m_workArray[1] = m_globalArray[13];
                                XMLMenuSystem.m_workArray[2] = m_globalArray[14];
                                if (bl) {
                                    XMLMenuSystem.SetMenu(10);
                                }
                            }
                            XMLMenuSystem.updateScrollArrows();
                            break;
                        }
                        case 4: {
                            if (Game.gameType == 0 && (Game.m_gamePrevControl == 5 || Game.m_gamePrevControl == 6 || Game.m_gamePrevControl == 29 || Game.m_fieldingTutorial)) {
                                if (m_selection == 0) {
                                    if ((n4 & 3) != 0) {
                                        m_workArray[1] = m_workArray[1] ^ 1;
                                        Game.fielderFormation = Game.m_fieldRange[m_workArray[1] * 3];
                                        XMLMenuSystem.m_workArray[5] = 0;
                                    }
                                    XMLMenuSystem.m_workArray[2] = 1;
                                    XMLMenuSystem.m_workArray[6] = 0;
                                } else {
                                    int n15 = 0;
                                    int n16 = 1;
                                    if (m_workArray[1] != 0) {
                                        n15 += 3;
                                        n16 += 3;
                                    }
                                    if (Game.m_fieldRestricted) {
                                        ++n16;
                                    }
                                    if ((n4 & 1) != 0) {
                                        --Game.fielderFormation;
                                    } else if ((n4 & 2) != 0) {
                                        ++Game.fielderFormation;
                                    }
                                    if (Game.fielderFormation < Game.m_fieldRange[n15]) {
                                        Game.fielderFormation = Game.m_fieldRange[n16];
                                    } else if (Game.fielderFormation > Game.m_fieldRange[n16]) {
                                        Game.fielderFormation = Game.m_fieldRange[n15];
                                    }
                                    XMLMenuSystem.m_workArray[2] = 0;
                                    XMLMenuSystem.m_workArray[6] = 1;
                                    XMLMenuSystem.m_workArray[5] = Game.fielderFormation - Game.m_fieldRange[n15];
                                }
                                Game.setFieldSetting();
                            } else {
                                m_selection = -10;
                            }
                            if (!Game.m_fieldingTutorial && (n4 & 0x20) != 0) {
                                XMLMenuSystem.SetMenu(0);
                                break;
                            }
                            break block227;
                        }
                        case 5: {
                            if ((n4 & 0x50) != 0) {
                                if (m_selection == 0) {
                                    Game.m_fieldRestricted = true;
                                }
                                Game.m_gameControl = 5;
                                break;
                            }
                            break block227;
                        }
                        case 42: {
                            XMLMenuSystem.updateScrollArrows();
                            break;
                        }
                        case 6: {
                            if ((n4 & 0x50) != 0) {
                                Game.currentBowler = Game.m_menuBowlersList[m_selection];
                                if (Game.m_menuGameMode < 5) {
                                    Game.initBall();
                                    m_prevMenu = 3;
                                    XMLMenuSystem.SetMenu(5);
                                } else {
                                    Game.setGameControl(5);
                                    Game.setInitialBatBowl();
                                }
                            } else if ((n4 & 1) != 0) {
                                XMLMenuSystem.m_workArray[70] = 0;
                                XMLMenuSystem.m_workArray[233] = 0;
                                XMLMenuSystem.m_workArray[234] = 1;
                            } else if ((n4 & 2) != 0) {
                                XMLMenuSystem.m_workArray[70] = 1;
                                XMLMenuSystem.m_workArray[233] = 1;
                                XMLMenuSystem.m_workArray[234] = 0;
                            }
                            if ((n4 & 0xC) != 0) {
                                int n17;
                                int n18 = 0;
                                if (m_scrollValues[7] > 0) {
                                    n17 = 8 - m_scrollValues[7];
                                    n18 = m_scrollValues[5] + n17;
                                }
                                if ((n4 & 4) != 0) {
                                    if (m_selection <= 0) {
                                        n4 &= 0xFFFFFFFB;
                                        break;
                                    }
                                    if (m_scrollValues[7] > 0 && (n17 = m_selection - 1) < m_scrollValues[5]) {
                                        XMLMenuSystem.m_workArray[232] = 1;
                                        break;
                                    }
                                }
                                if ((n4 & 8) != 0) {
                                    if (m_selection >= 7 || Game.m_menuBowlersList[m_selection + 1] == -1) {
                                        n4 &= 0xFFFFFFF7;
                                        break;
                                    }
                                    if (m_selection + 1 == n18) {
                                        ++n18;
                                    }
                                }
                                XMLMenuSystem.m_workArray[232] = 0;
                                if (m_scrollValues[7] <= 0 || n18 >= 8 || Game.m_menuBowlersList[n18] == -1) break block0;
                                XMLMenuSystem.m_workArray[232] = 1;
                                break;
                            }
                            break block227;
                        }
                        case 10: 
                        case 11: {
                            if ((n4 & 0x50) != 0) {
                                m_prevMenu = m_currMenu;
                                if (Game.gameType == 1) {
                                    XMLMenuSystem.SetMenu(4);
                                    break;
                                }
                                XMLMenuSystem.SetMenu(5);
                                break;
                            }
                            break block227;
                        }
                        case 12: {
                            if ((n4 & 0x50) != 0) {
                                if (Game.m_menuGameMode >= 5) {
                                    XMLMenuSystem.SetMenu(1);
                                    break;
                                }
                                XMLMenuSystem.SetMenu(0);
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
            }
        }
        return n4;
    }

    private static void onExit(int n2, int n3) {
        block38: {
            block0 : switch (n2) {
                case 2: {
                    switch (n3) {
                        case 0: {
                            MainFrame.soundSetOnOff(m_globalArray[1] == 0);
                            MainFrame.setMasterState(2);
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n3) {
                        case 1: {
                            SDKMIDlet.exit();
                            break;
                        }
                        case 3: {
                            if (Game.m_menuGameMode == 3) {
                                Game.m_difficulty = Game.m_ttDifficulty;
                                Game.maxOvers = Game.m_ttMaxOvers;
                                Game.teams[0] = Game.m_ttTeam;
                                XMLMenuSystem.SetMenu(23);
                                break;
                            }
                            if (Game.m_menuGameMode == 0) {
                                XMLMenuSystem.SetMenu(17);
                                break;
                            }
                            if (Game.m_menuGameMode == 1) {
                                XMLMenuSystem.SetMenu(19);
                                break;
                            }
                        }
                        case 0: {
                            Game.setGameControl(4);
                            Game.m_loadType = 0;
                            MainFrame.m_masterNextState = 6;
                            MainFrame.setMasterState(5);
                            break;
                        }
                        case 4: {
                            if (Game.m_challengeUnlocked[m_workArray[1]] < m_workArray[0]) break;
                            Game.m_menuGameMode = 0;
                            Game.m_challengeNum = m_workArray[1] * 6 + m_workArray[0];
                            Game.challengeInit(Game.m_challengeNum);
                            Game.setGameControl(4);
                            Game.m_loadType = 1;
                            MainFrame.m_masterNextState = 6;
                            MainFrame.setMasterState(5);
                            break;
                        }
                        case 5: {
                            if (Game.m_testMatchUnlocked[m_workArray[1]] < m_workArray[0]) break;
                            Game.m_menuGameMode = 1;
                            Game.m_testMatchNum = m_workArray[1] * 6 + m_workArray[0];
                            Game.testMatchInit(Game.m_testMatchNum);
                            Game.setGameControl(4);
                            Game.m_loadType = 1;
                            MainFrame.m_masterNextState = 6;
                            MainFrame.setMasterState(5);
                            break;
                        }
                        case 2: {
                            MainFrame.setMasterState(8);
                        }
                    }
                    break;
                }
                case 3: {
                    switch (n3) {
                        case 0: {
                            if (MicroGame.m_state == 1) {
                                MicroGame.resetTimeAllowed();
                            }
                            Game.m_gameControl = Game.m_gamePrevControl;
                            break block0;
                        }
                        case 1: {
                            MainFrame.setMasterState(3);
                            break block0;
                        }
                        case 3: {
                            MainFrame.setMasterState(3);
                            if (Game.m_menuGameMode == 0) {
                                MainFrame.m_loadReturnMenu = 16;
                                XMLMenuSystem.m_workArray[2] = m_globalArray[8] * 6 + m_globalArray[7];
                                break block0;
                            }
                            if (Game.m_menuGameMode == 1) {
                                MainFrame.m_loadReturnMenu = 18;
                                XMLMenuSystem.m_workArray[2] = m_globalArray[10];
                                break block0;
                            }
                            break block38;
                        }
                        case 4: {
                            if (m_selection == 1) {
                                Game.m_menuGameMode = 5;
                                Game.menuResetVariables();
                                Game.currentBowler = 0;
                                Game.initMatch();
                                if (Game.gameType == 1) {
                                    Game.setGameControl(7);
                                } else {
                                    XMLMenuSystem.SetMenu(3);
                                }
                                Game.m_menuGameMode = 5;
                                Game.currentOver = 1;
                                Game.setInitialBatBowl();
                                Game.initBall();
                                break block0;
                            }
                            if (m_selection == 0) {
                                if (Game.m_menuGameMode == 5) {
                                    Game.m_menuGameMode = Game.gameType == 1 ? 6 : 7;
                                }
                                Game.m_tutorialStage = 0;
                                XMLMenuSystem.setTutorialMessage();
                                XMLMenuSystem.SetMenu(9);
                                break block0;
                            }
                            break block38;
                        }
                        case 5: {
                            if (Game.m_batsmanOut) {
                                Game.m_batsmanOut = false;
                                Game.m_gameControl = 11;
                                break block0;
                            }
                            Game.m_gameControl = 7;
                            break block0;
                        }
                        case 6: {
                            if (Game.m_menuGameMode == 0) {
                                Game.challengeInit(Game.m_challengeNum);
                            } else {
                                Game.testMatchInit(Game.m_testMatchNum);
                            }
                            Game.setGameControl(4);
                            Game.m_loadType = 1;
                            MainFrame.m_masterNextState = 6;
                            MainFrame.setMasterState(5);
                        }
                    }
                }
            }
        }
    }

    private static void onPositionOverride(int n2, int[] nArray, int n3) {
        switch (n2) {
            case 1: {
                if (n3 != 44) break;
                XMLMenuSystem.setSquadSelectionColour();
                break;
            }
        }
        if (n3 == 35) {
            m_horOffset = 1;
        }
        if (n3 == 36) {
            m_horOffset = 0;
        }
        if (m_selected && m_horOffset == 1) {
            nArray[0] = nArray[0] + 15;
        }
        if (n3 == 38) {
            int n4 = 0;
            n4 = 160;
            if ((m_tickerOff += 2) > n4) {
                m_tickerOff -= n4;
            }
            nArray[0] = nArray[0] - m_tickerOff;
            m_menuRefreshCount = 1;
        }
        if (n3 == 39) {
            nArray[0] = nArray[0] - m_tickerOff;
            m_menuRefreshCount = 1;
        }
    }

    private static void onMenuInput(int n2, int n3, int n4) {
    }

    private static int onMenuSelectionChange(int n2, int n3, int n4) {
        return n4;
    }

    private static void onOwnerDraw(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        switch (n2) {
            case 50: {
                if (m_workArray[70] == 0) {
                    m_tempSDKString = XMLMenuSystem.GetMenuString(m_tempSDKString, 525, 1);
                    XMLMenuSystem.DrawMenuText(n3 + n5 / 8, n4, FONT_MEDIUM, m_tempSDKString, 0, m_tempSDKString.length(), 0, 255, 17);
                    m_tempSDKString = XMLMenuSystem.GetMenuString(m_tempSDKString, 525, 2);
                    XMLMenuSystem.DrawMenuText(n3 + n5 / 2, n4, FONT_MEDIUM, m_tempSDKString, 0, m_tempSDKString.length(), 0, 255, 17);
                    m_tempSDKString = XMLMenuSystem.GetMenuString(m_tempSDKString, 525, 3);
                    XMLMenuSystem.DrawMenuText(n3 + 7 * n5 / 8, n4, FONT_MEDIUM, m_tempSDKString, 0, m_tempSDKString.length(), 0, 255, 17);
                    break;
                }
                m_tempSDKString = XMLMenuSystem.GetMenuString(m_tempSDKString, 525, 4);
                XMLMenuSystem.DrawMenuText(n3 + n5 / 2, n4, FONT_MEDIUM, m_tempSDKString, 0, m_tempSDKString.length(), 0, 255, 17);
                break;
            }
            case 51: {
                if (m_workArray[80 + n7] == 0) break;
                if (m_workArray[70] == 0) {
                    int n11 = 1;
                    if (m_workArray[10 + n7] > 9) {
                        n11 = 2;
                    }
                    m_tempSDKString = new SDKString("" + m_workArray[10 + n7]);
                    XMLMenuSystem.DrawMenuText(n3 + n5 / 8, n4, 0, m_tempSDKString, 0, n11, 0, 255, 17);
                    n11 = 1;
                    if (m_workArray[20 + n7] > 9) {
                        n11 = 2;
                    }
                    m_tempSDKString = new SDKString("" + m_workArray[20 + n7]);
                    XMLMenuSystem.DrawMenuText(n3 + n5 / 2, n4, 0, m_tempSDKString, 0, n11, 0, 255, 17);
                    n11 = 1;
                    if (m_workArray[30 + n7] > 9) {
                        n11 = 2;
                    }
                    m_tempSDKString = new SDKString("" + m_workArray[30 + n7]);
                    XMLMenuSystem.DrawMenuText(n3 + 7 * n5 / 8, n4, 0, m_tempSDKString, 0, n11, 0, 255, 17);
                    break;
                }
                m_tempSDKString = XMLMenuSystem.GetMenuString(m_tempSDKString, 648, m_workArray[60 + n7]);
                XMLMenuSystem.DrawMenuText(n3 + n5 / 2, n4, 0, m_tempSDKString, 0, m_tempSDKString.length(), 0, 255, 17);
                break;
            }
            case 52: {
                m_menuGraphics.setClip(0, 0, 352, 416);
                XMLMenuSystem.m_workArray[30] = n7;
                XMLMenuSystem.m_workArray[31] = n8;
                XMLMenuSystem.m_workArray[32] = n9;
                XMLMenuSystem.m_workArray[33] = n10;
                m_tempSDKString = XMLMenuSystem.GetMenuString(m_tempSDKString, 655, 0);
                XMLMenuSystem.DrawMenuText(n3 + n5 / 2, n4, 0, m_tempSDKString, 0, m_tempSDKString.length(), 0, 255, 17);
            }
        }
    }

    private static void populateTable(int n2, int n3) {
        int[] nArray;
        int n4 = 0;
        int n5 = 0;
        if (n3 == 0) {
            nArray = new int[]{Game.m_groups[n2][0], Game.m_groups[n2][1], Game.m_groups[n2][2]};
            n5 = 1;
        } else {
            nArray = new int[]{Game.m_superEightTeamsGrouped[0 + (n2 - 5) * 4], Game.m_superEightTeamsGrouped[1 + (n2 - 5) * 4], Game.m_superEightTeamsGrouped[2 + (n2 - 5) * 4], Game.m_superEightTeamsGrouped[3 + (n2 - 5) * 4]};
            if (Game.m_ttStage != 0) {
                n5 = 1;
            }
        }
        if (n5 == 1) {
            Game.scoreSort(nArray, n3);
        }
        int n6 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            XMLMenuSystem.m_workArray[12 + n6] = 0;
            XMLMenuSystem.m_workArray[13 + n6] = 0;
            XMLMenuSystem.m_workArray[18 + n6] = n5;
            if (n5 == 0) {
                XMLMenuSystem.m_workArray[10 + n6] = 0;
                XMLMenuSystem.m_workArray[11 + n6] = 0;
                XMLMenuSystem.m_workArray[12 + n6] = 0;
                XMLMenuSystem.m_workArray[13 + n6] = 0;
                XMLMenuSystem.m_workArray[14 + n6] = 0;
                XMLMenuSystem.m_workArray[15 + n6] = 0;
                XMLMenuSystem.m_workArray[16 + n6] = 0;
                XMLMenuSystem.m_workArray[17 + n6] = 0;
                XMLMenuSystem.m_workArray[50 + n6] = 469;
            } else {
                n4 = Game.m_ttConv18To12[nArray[i2]];
                int n7 = Game.m_teamScores[n4][5][n3];
                if (n7 < 0) {
                    n7 = -n7;
                }
                XMLMenuSystem.m_workArray[10 + n6] = nArray[i2];
                XMLMenuSystem.m_workArray[11 + n6] = Game.m_teamScores[n4][0][n3];
                for (int i3 = 0; i3 < 12; ++i3) {
                    int n8 = 12 + n6;
                    m_workArray[n8] = m_workArray[n8] + (Game.m_teamScores[n4][1][n3] >> i3 & 1);
                    int n9 = 13 + n6;
                    m_workArray[n9] = m_workArray[n9] + (Game.m_teamScores[n4][2][n3] >> i3 & 1);
                    int n10 = 14 + n6;
                    m_workArray[n10] = m_workArray[n10] + (Game.m_teamScores[n4][3][n3] >> i3 & 1);
                }
                XMLMenuSystem.m_workArray[15 + n6] = Game.m_teamScores[n4][4][n3];
                XMLMenuSystem.m_workArray[16 + n6] = Game.m_teamScores[n4][5][n3] >> 16;
                XMLMenuSystem.m_workArray[17 + n6] = (n7 & 0xFFFF) * 1000 >> 16;
                XMLMenuSystem.m_workArray[50 + n6] = 16;
            }
            XMLMenuSystem.m_workArray[51 + n6] = 1;
            n6 += 10;
        }
    }

    private static void populateSquad(int n2) {
        for (int i2 = 0; i2 < 20; ++i2) {
            XMLMenuSystem.m_workArray[81 + i2] = m_playerNameIds[n2 + Game.getTPInd()];
            XMLMenuSystem.m_workArray[i2 * 4 + 1] = Game.m_menuPlayersList[i2];
            int n3 = Game.battingStats[Game.m_menuPlayersList[i2]][0] + Game.battingStats[Game.m_menuPlayersList[i2]][1] + Game.battingStats[Game.m_menuPlayersList[i2]][2] + 1;
            XMLMenuSystem.m_workArray[i2 * 4 + 2] = n3 / 3;
            n3 = Game.bowlingStats[Game.m_menuPlayersList[i2]][0] + Game.bowlingStats[Game.m_menuPlayersList[i2]][1] + Game.bowlingStats[Game.m_menuPlayersList[i2]][2] + 1;
            XMLMenuSystem.m_workArray[i2 * 4 + 3] = n3 / 3;
            XMLMenuSystem.m_workArray[i2 * 4 + 4] = i2 > 10 ? 1715510 : ((i2 & 1) == 0 ? 4288390 : 3233127);
            if (m_workArray[0] != i2) continue;
            XMLMenuSystem.m_workArray[i2 * 4 + 4] = 12069932;
        }
    }

    private static void setSquadSelectionColour() {
        if (m_workArray[0] != -1) {
            XMLMenuSystem.m_workArray[254] = 176370;
            return;
        }
        XMLMenuSystem.m_workArray[254] = 15218230;
    }

    private static void populateFixtures(int n2, int n3) {
        int n4 = 16;
        switch (n2) {
            case 0: {
                XMLMenuSystem.m_workArray[2] = n3 + 1;
                XMLMenuSystem.m_workArray[3] = 3;
                int n5 = n3 * 2;
                for (int i2 = 0; i2 < 4; ++i2) {
                    XMLMenuSystem.m_workArray[i2 * 5 + 5] = i2;
                    XMLMenuSystem.m_workArray[i2 * 5 + 6] = Game.m_groupMatches[i2][n5];
                    XMLMenuSystem.m_workArray[i2 * 5 + 7] = Game.m_groupMatches[i2][n5 + 1];
                }
                break;
            }
            case 1: {
                XMLMenuSystem.m_workArray[2] = n3 + 1;
                XMLMenuSystem.m_workArray[3] = 6;
                int n6 = n3 * 2;
                for (int i3 = 0; i3 < 2; ++i3) {
                    XMLMenuSystem.m_workArray[i3 * 5 + 5] = 5 + i3;
                    if (Game.m_ttStage < 1) {
                        XMLMenuSystem.m_workArray[i3 * 5 + 6] = 0;
                        XMLMenuSystem.m_workArray[i3 * 5 + 7] = 0;
                        XMLMenuSystem.m_workArray[50 + i3 * 2 + 0] = 469;
                        XMLMenuSystem.m_workArray[50 + i3 * 2 + 1] = 469;
                        continue;
                    }
                    if (Game.m_superEightMatches[n6 + i3][0] == Game.m_superEightTeamsGrouped[0] || Game.m_superEightMatches[n6 + i3][0] == Game.m_superEightTeamsGrouped[1] || Game.m_superEightMatches[n6 + i3][0] == Game.m_superEightTeamsGrouped[2] || Game.m_superEightMatches[n6 + i3][0] == Game.m_superEightTeamsGrouped[3]) {
                        if (i3 == 0) {
                            XMLMenuSystem.m_workArray[i3 * 5 + 6] = Game.m_superEightMatches[n6 + 0][0];
                            XMLMenuSystem.m_workArray[i3 * 5 + 7] = Game.m_superEightMatches[n6 + 0][1];
                            XMLMenuSystem.m_workArray[50 + i3 * 2 + 0] = n4;
                            XMLMenuSystem.m_workArray[50 + i3 * 2 + 1] = n4;
                            continue;
                        }
                        XMLMenuSystem.m_workArray[i3 * 5 + 6] = Game.m_superEightMatches[n6 + 0][0];
                        XMLMenuSystem.m_workArray[i3 * 5 + 7] = Game.m_superEightMatches[n6 + 0][1];
                        XMLMenuSystem.m_workArray[50 + i3 * 2 + 0] = n4;
                        XMLMenuSystem.m_workArray[50 + i3 * 2 + 1] = n4;
                        continue;
                    }
                    if (i3 == 0) {
                        XMLMenuSystem.m_workArray[i3 * 5 + 6] = Game.m_superEightMatches[n6 + 1][0];
                        XMLMenuSystem.m_workArray[i3 * 5 + 7] = Game.m_superEightMatches[n6 + 1][1];
                        XMLMenuSystem.m_workArray[50 + i3 * 2 + 0] = n4;
                        XMLMenuSystem.m_workArray[50 + i3 * 2 + 1] = n4;
                        continue;
                    }
                    XMLMenuSystem.m_workArray[i3 * 5 + 6] = Game.m_superEightMatches[n6 + 1][0];
                    XMLMenuSystem.m_workArray[i3 * 5 + 7] = Game.m_superEightMatches[n6 + 1][1];
                    XMLMenuSystem.m_workArray[50 + i3 * 2 + 0] = n4;
                    XMLMenuSystem.m_workArray[50 + i3 * 2 + 1] = n4;
                }
                break;
            }
            case 2: {
                XMLMenuSystem.m_workArray[2] = n3 + 1;
                XMLMenuSystem.m_workArray[3] = 2;
                if (Game.m_ttStage < 2) {
                    XMLMenuSystem.m_workArray[6] = 0;
                    XMLMenuSystem.m_workArray[7] = 0;
                    XMLMenuSystem.m_workArray[50] = 469;
                    XMLMenuSystem.m_workArray[51] = 469;
                    break;
                }
                XMLMenuSystem.m_workArray[6] = Game.m_semiMatches[n3 * 2];
                XMLMenuSystem.m_workArray[7] = Game.m_semiMatches[n3 * 2 + 1];
                XMLMenuSystem.m_workArray[50] = n4;
                XMLMenuSystem.m_workArray[51] = n4;
                break;
            }
            case 3: {
                if (Game.m_ttStage < 3) {
                    XMLMenuSystem.m_workArray[6] = 0;
                    XMLMenuSystem.m_workArray[7] = 0;
                    XMLMenuSystem.m_workArray[50] = 469;
                    XMLMenuSystem.m_workArray[51] = 469;
                    break;
                }
                XMLMenuSystem.m_workArray[6] = Game.m_finalists[0];
                XMLMenuSystem.m_workArray[7] = Game.m_finalists[1];
                XMLMenuSystem.m_workArray[50] = n4;
                XMLMenuSystem.m_workArray[51] = n4;
            }
        }
    }

    private static void updateScrollArrows() {
        XMLMenuSystem.m_workArray[231] = m_menuTextBlockCurrentLine == 0 ? 0 : 1;
        XMLMenuSystem.m_workArray[232] = m_menuTextBlockCurrentLine + m_menuTextBlockVisibleLines >= m_menuTextBlockTotalLines ? 0 : 1;
    }

    public static void setTutorialMessage() {
        XMLMenuSystem.m_globalArray[13] = Game.m_menuGameMode == 6 ? 577 : (Game.m_menuGameMode == 8 ? 584 : 573);
        XMLMenuSystem.m_globalArray[14] = Game.m_tutorialStage;
    }

    private static boolean initEASDK(int n2) {
        boolean bl = false;
        try {
            byte[] byArray = SDKInputStream.loadResourceAsByteArray("/hdr", null, 0);
            SDKUtils.loadTextHeader(byArray);
            n2 = SDKUtils.chooseLanguage(n2);
            SDKUtils.setCurrentLanguage(n2);
            SDKUtils.loadStringsChunk(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static void setFont(int n2) {
        XMLMenuSystem.setFont(n2, 0);
    }

    public static void setFont(int n2, int n3) {
        if (n2 != m_currentFontId || n3 != m_currentPaletteId) {
            m_resourceImages[m_compiledData[m_compiledDataFonts + n2 * 6] & 0xFF].setEAFont(n3);
            m_currentFontId = n2;
            m_currentPaletteId = n3;
        }
    }

    public static Object[] getMoreGamesFonts() {
        Object[] objectArray;
        m_compiledDataFonts = m_compiledData[8] & 0xFF | (m_compiledData[9] & 0xFF) << 8;
        objectArray = new Object[]{m_resourceImages[m_compiledData[m_compiledDataFonts + FONT_MEDIUM * 6] & 0xFF].setEAFont(FONTPAL_MOREGAMES), objectArray[0], m_resourceImages[m_compiledData[m_compiledDataFonts + FONT_MEDIUM * 6] & 0xFF].setEAFont(FONTPAL_DEFAULT), objectArray[0], objectArray[0]};
        return objectArray;
    }

    private static void getControlArrowsCoords(int n2, int[] nArray) {
    }

    public static void drawTouchArrows(SDKGraphics sDKGraphics) {
    }

    private static int getHelpTextBody(int n2) {
        int n3 = n2;
        switch (n2) {
            case 1: {
                n3 = 447;
                break;
            }
            case 3: {
                n3 = 460;
                break;
            }
            case 5: {
                n3 = 459;
                break;
            }
            case 7: {
                n3 = 461;
                break;
            }
            case 9: {
                n3 = 463;
                break;
            }
            case 11: {
                n3 = 462;
            }
        }
        return n3;
    }

    static {
        m_softKeyText = new short[2];
        m_delaySoftkeys = false;
        m_scrollValues = new int[10];
        m_posArray = new int[8];
        m_backFromGame = false;
        m_musicLoadInterruped = false;
        FONT_SMALL = 0;
        FONT_MEDIUM = 0;
        FONT_LARGE = 1;
        FONTPAL_DEFAULT = 0;
        FONTPAL_SELECTED_BUTTON = 1;
        FONTPAL_UNSELECTED_BUTTON = 2;
        FONTPAL_MOREGAMES = 3;
        FONTPAL_BLACK = 4;
        m_controlInfo = new int[32][5];
        m_pointerPosX = -1;
        m_soundMenuRestart = false;
        m_soundRestartCounter = 0;
        LSKposX = 117;
        RSKposX = 234;
        LSKRSKposY = 378;
        dontLetToPointButton = false;
        m_playerNameIdsFull = new int[]{86, 106, 326, 346, 126, 146, 166, 366, 186, 206, 226, 246, 266, 286, 306};
        m_playerNameIdsS40 = new int[]{-10, -11, -22, -23, -12, -13, -14, -24, -10, -15, -16, -17, -18, -19, -20, -10, -21, -10};
        LarrowCoords = new int[32][4];
        RarrowCoords = new int[32][4];
        arrowsCoordsIndex = 0;
        touchRightArrow = false;
    }
}

