/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKUtils;

class DDFile {
    private static final boolean DEBUG = false;
    private static int[] m_filenameToResID;
    private static int m_filenameToResIDNum;
    private static final int FTRID_HASH = 0;
    private static final int FTRID_RESID = 1;
    private static final int INVALID_RESID = -1;

    DDFile() {
    }

    public static void fileInit() {
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(0);
            int n2 = sDKInputStream.getLength() >> 2;
            m_filenameToResIDNum = n2 >> 1;
            m_filenameToResID = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                DDFile.m_filenameToResID[i2] = sDKInputStream.readInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int get16bits(String string, int n2) {
        return string.charAt(n2 + 0) & 0xFF | (string.charAt(n2 + 1) & 0xFF) << 8;
    }

    private static int SuperFastHash(String string) {
        int n2;
        int n3 = n2 = string.length();
        int n4 = 0;
        int n5 = n2 & 3;
        n2 >>>= 2;
        while (n2 > 0) {
            int n6 = DDFile.get16bits(string, n4 + 2) << 11 ^ (n3 += DDFile.get16bits(string, n4));
            n3 = n3 << 16 ^ n6;
            n4 += 4;
            n3 += n3 >>> 11;
            --n2;
        }
        switch (n5) {
            case 3: {
                n3 += DDFile.get16bits(string, n4);
                n3 ^= n3 << 16;
                n3 ^= (string.charAt(n4 + 2) & 0xFF) << 18;
                n3 += n3 >>> 11;
                break;
            }
            case 2: {
                n3 += DDFile.get16bits(string, n4);
                n3 ^= n3 << 11;
                n3 += n3 >>> 17;
                break;
            }
            case 1: {
                n3 += string.charAt(n4) & 0xFF;
                n3 ^= n3 << 10;
                n3 += n3 >>> 1;
            }
        }
        n3 ^= n3 << 3;
        n3 += n3 >>> 5;
        n3 ^= n3 << 4;
        n3 += n3 >>> 17;
        n3 ^= n3 << 25;
        n3 += n3 >>> 6;
        return n3;
    }

    private static int getResIDFromFilename(String string) {
        try {
            int n2 = DDFile.SuperFastHash(string);
            for (int i2 = 0; i2 < m_filenameToResIDNum; ++i2) {
                if (m_filenameToResID[(i2 << 1) + 0] != n2) continue;
                int n3 = m_filenameToResID[(i2 << 1) + 1];
                return n3;
            }
        }
        catch (Exception exception) {
            System.out.println("failed getResIDFromFilename " + exception);
        }
        return -1;
    }

    public static int getFileLength(String string) {
        int n2 = DDFile.getResIDFromFilename(string);
        if (n2 == -1) {
            return -1;
        }
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n2);
            return sDKInputStream.getLength();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public static SDKImage loadImage(String string) {
        SDKImage sDKImage = null;
        int n2 = DDFile.getResIDFromFilename(string);
        if (n2 == -1) {
            return sDKImage;
        }
        try {
            sDKImage = SDKInputStream.loadImageObject(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sDKImage;
    }

    public static byte[] loadFileBytes(String string, int n2) {
        int n3 = DDFile.getResIDFromFilename(string);
        if (n3 == -1) {
            return null;
        }
        return SDKInputStream.loadResourceAsByteArray(n3);
    }

    public static byte[] loadFileBytes(String string) {
        int n2 = DDFile.getResIDFromFilename(string);
        if (n2 == -1) {
            return null;
        }
        return SDKInputStream.loadResourceAsByteArray(n2);
    }

    public static short[] loadFileShorts(String string) {
        return DDFile.loadFileShorts(string, false);
    }

    public static short[] loadFileShorts(String string, boolean bl) {
        short[] sArray = null;
        int n2 = DDFile.getResIDFromFilename(string);
        if (n2 == -1) {
            return null;
        }
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n2);
            int n3 = sDKInputStream.getLength() >> 1;
            sArray = new short[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                sArray[i2] = bl ? sDKInputStream.readShortBE() : sDKInputStream.readShort();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return sArray;
    }

    public static int[] loadFileInts(String string) {
        return DDFile.loadFileInts(string, true);
    }

    public static int[] loadFileInts(String string, boolean bl) {
        int[] nArray = null;
        int n2 = DDFile.getResIDFromFilename(string);
        if (n2 == -1) {
            return null;
        }
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n2);
            int n3 = sDKInputStream.getLength() >> 2;
            nArray = new int[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                nArray[i2] = bl ? sDKInputStream.readIntBE() : sDKInputStream.readInt();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return nArray;
    }

    public static byte[] loadRMSFile(int n2) {
        return SDKUtils.loadRecord(n2);
    }

    public static boolean doesRMSFileExist(int n2) {
        return !SDKUtils.isRecordEmpty(n2);
    }

    public static void deleteRMSFile(int n2) {
        SDKUtils.removeRecord(n2);
    }

    public static boolean saveRMSFile(int n2, byte[] byArray, int n3) {
        if (byArray.length != n3) {
            // empty if block
        }
        SDKUtils.saveRecord(n2, byArray);
        return true;
    }

    public static short retrieveShort(byte[] byArray, int n2, boolean bl) {
        if (bl) {
            return (short)((byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 0] & 0xFF) << 0);
        }
        return (short)((byArray[n2 + 0] & 0xFF) << 8 | (byArray[n2 + 1] & 0xFF) << 0);
    }
}

