/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class RmsStorage {
    public RecordStore r_store;

    public void openRecStore(String name) {
        System.out.println(" open record store***************");
        try {
            this.r_store = RecordStore.openRecordStore((String)name, (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void closeRecStore() {
        System.out.println("  close the records ");
        try {
            this.r_store.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeRecords(String str) {
        System.out.println(" write records ");
        byte[] rec = str.getBytes();
        try {
            this.r_store.addRecord(rec, 0, rec.length);
            System.out.println("no of records***********************" + this.r_store.getNumRecords());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector readRecords() {
        String str = "";
        Vector<String> v = new Vector<String>();
        try {
            byte[] rec_data = new byte[4];
            for (int i = 1; i <= this.r_store.getNumRecords(); ++i) {
                if (this.r_store.getRecordSize(i) > rec_data.length) {
                    rec_data = new byte[this.r_store.getRecordSize(i)];
                }
                int length = this.r_store.getRecord(i, rec_data, 0);
                str = new String(rec_data, 0, length);
                v.addElement(str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    public void deleteRecStore(String recName) {
        if (RecordStore.listRecordStores() != null) {
            try {
                RecordStore.deleteRecordStore((String)recName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Vector readHighscoreRecords() {
        String val = "";
        Vector<String> v = new Vector<String>();
        try {
            if (this.r_store.getNumRecords() > 0) {
                Comparator comp = new Comparator();
                RecordEnumeration re = this.r_store.enumerateRecords(null, (RecordComparator)comp, false);
                while (re.hasNextElement()) {
                    String str = new String(re.nextRecord());
                    if (v == null || v.size() >= 5) continue;
                    v.addElement(str);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    class Comparator
    implements RecordComparator {
        Comparator() {
        }

        public int compare(byte[] rec1, byte[] rec2) {
            String str1 = new String(rec1);
            String str2 = new String(rec2);
            int result = str1.compareTo(str2);
            if (result == 0) {
                return 0;
            }
            if (result > 0) {
                return -1;
            }
            return 1;
        }
    }
}

