/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.game;

import javax.microedition.lcdui.Graphics;
import sk.inlogic.Level;
import sk.inlogic.MainCanvas;
import sk.inlogic.Profile;
import sk.inlogic.Sounds;
import sk.inlogic.screen.ScreenMain;
import sk.inlogic.util.Common;
import sk.inlogic.util.Keys;

public class Game {
    private ScreenMain screen;
    private int iCirclePriemer;
    private int iCirclePolomer;
    private int iOffY;
    private int iCircleMidX;
    private int iCircleMidY;
    private int iDotPriemer;
    private int iDotPolomer;
    private int iDotsMidX;
    private int iDotsMidY;
    private int iDotsRadius;
    private int[][] iDotsPositions;
    private int[] dots;
    private int iThrowDotsStartY;
    private int iOffThrowY;
    private int iThrowingIndex;
    private boolean isThrowing;
    private int posThrowingDotY;
    private int throwSpeed;
    private int iThrowAnimDotsOff;
    private int iThrowAnimDotsOffStep;
    private int iSpeedTimeCounter;
    private int iSpeedIdx;
    private boolean isWin;
    private boolean gameOverComming;
    private int gameOverCounter;
    public boolean isInited;
    public boolean bPause;

    public Game(ScreenMain screen) {
        this.screen = screen;
        this.iOffY = screen.fontMain.getHeight() << 1;
        this.iCirclePriemer = (ScreenMain.sprCover0.getHeight() >> 1) + (ScreenMain.sprCover0.getHeight() >> 2);
        this.iCirclePolomer = this.iCirclePriemer >> 1;
        this.iCircleMidX = MainCanvas.WIDTH >> 1;
        this.iCircleMidY = this.iOffY + ScreenMain.sprCover45.getHeight();
        this.iDotPriemer = this.iCirclePriemer >> 2;
        this.iDotPolomer = this.iDotPriemer >> 1;
        this.iDotsMidX = this.iCircleMidX - this.iDotPolomer;
        this.iDotsMidY = this.iCircleMidY - this.iDotPolomer;
        this.iDotsRadius = ScreenMain.sprCover0.getHeight() - this.iDotPriemer;
        this.iDotsPositions = new int[360][2];
        this.posThrowingDotY = this.iThrowDotsStartY = this.iOffY + (ScreenMain.sprCover0.getHeight() << 1) + this.iDotPolomer;
        this.throwSpeed = ScreenMain.sprCover0.getHeight() >> 3;
        this.iThrowAnimDotsOffStep = this.iDotPolomer + this.iDotPriemer >> 2;
        this.iSpeedTimeCounter = 0;
        if (this.iThrowAnimDotsOffStep == 0) {
            this.iThrowAnimDotsOffStep = 1;
        }
        for (int i = 0; i < this.iDotsPositions.length; ++i) {
            this.iDotsPositions[i][0] = this.iDotsMidX + (this.iDotsRadius * Common.COS(i) >> 8);
            this.iDotsPositions[i][1] = this.iDotsMidY + (this.iDotsRadius * Common.SIN(i) >> 8);
        }
        this.dots = new int[30];
    }

    public void init(int lvl) {
        int i;
        this.isInited = false;
        System.out.println(lvl);
        Level.loadLevel(lvl);
        this.bPause = false;
        this.gameOverComming = false;
        this.gameOverCounter = 0;
        this.iThrowingIndex = 100;
        this.isThrowing = false;
        this.iThrowAnimDotsOff = 0;
        this.posThrowingDotY = this.iThrowDotsStartY;
        this.isWin = false;
        this.iSpeedTimeCounter = 0;
        this.iSpeedIdx = 0;
        for (i = 0; i < this.dots.length; ++i) {
            this.dots[i] = -100;
        }
        for (i = 0; i < Level.throwDots; ++i) {
            this.dots[i] = -1 - i;
        }
        if (Level.circleDots != null) {
            int tmp = 0;
            for (int i2 = Level.throwDots; i2 < Level.circleDots.length + Level.throwDots; ++i2) {
                this.dots[i2] = Level.circleDots[tmp++];
            }
        }
        this.isInited = true;
    }

    public void pause() {
        if (!this.gameOverComming) {
            this.bPause = true;
            this.screen.playMusic(Sounds.MUSIC_MENU, -1);
            this.screen.getClass();
            this.screen.getClass();
            this.screen.nextScreen(1, 0);
        }
    }

    public void update(long ltick) {
        if (this.isInited) {
            if (this.gameOverComming) {
                this.gameOverCounter = (int)((long)this.gameOverCounter + ltick);
                if (this.gameOverCounter > 250) {
                    this.screen.getClass();
                    this.screen.nextScreen(2, 1);
                }
                return;
            }
            if (Level.times == null) {
                for (int i = 0; i < this.dots.length; ++i) {
                    if (this.dots[i] <= -1) continue;
                    int n = i;
                    this.dots[n] = this.dots[n] - Level.speeds[0];
                    if (this.dots[i] >= 360) {
                        this.dots[i] = 0;
                    }
                    if (this.dots[i] >= 0) continue;
                    this.dots[i] = 359;
                }
            } else {
                this.iSpeedTimeCounter = (int)((long)this.iSpeedTimeCounter + ltick);
                if (this.iSpeedTimeCounter > Level.times[this.iSpeedIdx]) {
                    this.iSpeedTimeCounter = 0;
                    ++this.iSpeedIdx;
                    if (this.iSpeedIdx >= Level.times.length) {
                        this.iSpeedIdx = 0;
                    }
                }
                for (int i = 0; i < this.dots.length; ++i) {
                    if (this.dots[i] <= -1) continue;
                    int n = i;
                    this.dots[n] = this.dots[n] - Level.speeds[this.iSpeedIdx];
                    if (this.dots[i] >= 360) {
                        this.dots[i] = 0;
                    }
                    if (this.dots[i] >= 0) continue;
                    this.dots[i] = 359;
                }
            }
            if (this.isThrowing) {
                this.posThrowingDotY -= this.throwSpeed;
                this.iThrowAnimDotsOff = this.iThrowAnimDotsOff < this.iDotPolomer + this.iDotPriemer ? (this.iThrowAnimDotsOff += this.iThrowAnimDotsOffStep) : this.iDotPolomer + this.iDotPriemer;
                if (this.posThrowingDotY <= this.iDotsPositions[90][1]) {
                    if (!this.isCollision()) {
                        this.dots[this.iThrowingIndex] = 90;
                        this.isThrowing = false;
                        this.posThrowingDotY = this.iThrowDotsStartY;
                        if (this.isLast()) {
                            this.isWin = true;
                            if (Profile.iLevel < Level.LAST_LEVEL) {
                                ++Profile.iLevel;
                                Profile.save();
                            }
                            this.bPause = false;
                            this.gameOverComming = true;
                        }
                    } else {
                        this.isWin = false;
                        this.bPause = false;
                        this.gameOverComming = true;
                    }
                }
            }
        }
    }

    private boolean isCollision() {
        for (int i = 0; i < this.dots.length; ++i) {
            if (this.dots[i] < 0 || this.dots[i] < 80 || this.dots[i] > 100) continue;
            return true;
        }
        return false;
    }

    public boolean isWin() {
        return this.isWin;
    }

    private boolean isLast() {
        for (int i = 0; i < this.dots.length; ++i) {
            if (this.dots[i] >= 0 || this.dots[i] <= -100) continue;
            return false;
        }
        return true;
    }

    public void paint(Graphics g) {
        this.screen.fontMain.drawString(g, this.screen.strTextPom[0].toCharArray(), MainCanvas.WIDTH >> 1, this.screen.fontMain.getHeight(), 3);
        g.setColor(0);
        g.fillArc(this.iCircleMidX - this.iCirclePolomer, this.iCircleMidY - this.iCirclePolomer, this.iCirclePriemer, this.iCirclePriemer, 0, 360);
        this.paintDots(g);
        this.paintThrowing(g);
        if (this.isThrowing) {
            this.paintThrowingDot(g);
        }
        this.paintCover(g);
    }

    private void paintThrowingDot(Graphics g) {
        g.setColor(0);
        g.fillArc(this.iDotsMidX, this.posThrowingDotY, this.iDotPriemer, this.iDotPriemer, 0, 360);
    }

    private void paintThrowing(Graphics g) {
        if (!this.isThrowing) {
            this.iOffThrowY = 0;
            for (int i = 0; i < this.dots.length; ++i) {
                if (this.dots[i] >= 0 || this.dots[i] <= -100) continue;
                g.setColor(0);
                g.fillArc(this.iDotsMidX, this.iThrowDotsStartY + this.iOffThrowY, this.iDotPriemer, this.iDotPriemer, 0, 360);
                this.iOffThrowY += this.iDotPriemer + this.iDotPolomer;
            }
        } else {
            this.iOffThrowY = this.iDotPriemer + this.iDotPolomer;
            for (int i = 0; i < this.dots.length; ++i) {
                if (this.dots[i] >= 0 || this.dots[i] <= -100 || i == this.iThrowingIndex) continue;
                g.setColor(0);
                g.fillArc(this.iDotsMidX, this.iThrowDotsStartY + this.iOffThrowY - this.iThrowAnimDotsOff, this.iDotPriemer, this.iDotPriemer, 0, 360);
                this.iOffThrowY += this.iDotPriemer + this.iDotPolomer;
            }
        }
    }

    private void paintDots(Graphics g) {
        for (int i = 0; i < this.dots.length; ++i) {
            if (this.dots[i] <= -1) continue;
            g.drawLine(this.iCircleMidX, this.iCircleMidY, this.iDotsPositions[this.dots[i]][0] + this.iDotPolomer, this.iDotsPositions[this.dots[i]][1] + this.iDotPolomer);
            g.fillArc(this.iDotsPositions[this.dots[i]][0], this.iDotsPositions[this.dots[i]][1], this.iDotPriemer, this.iDotPriemer, 0, 360);
        }
    }

    private void paintCover(Graphics g) {
        if (Level.covers != null) {
            if (Level.covers[0]) {
                ScreenMain.sprCover0.setTransform(0);
                ScreenMain.sprCover0.setPosition(this.iCircleMidX - (ScreenMain.sprCover0.getWidth() >> 1), this.iCircleMidY - ScreenMain.sprCover0.getHeight());
                ScreenMain.sprCover0.paint(g);
            }
            if (Level.covers[1]) {
                ScreenMain.sprCover45.setTransform(6);
                ScreenMain.sprCover45.setPosition(this.iCircleMidX - ScreenMain.sprCover45.getWidth(), this.iCircleMidY - ScreenMain.sprCover45.getHeight());
                ScreenMain.sprCover45.paint(g);
            }
            if (Level.covers[2]) {
                ScreenMain.sprCover0.setTransform(7);
                ScreenMain.sprCover0.setPosition(this.iCircleMidX, this.iCircleMidY - (ScreenMain.sprCover0.getHeight() >> 1));
                ScreenMain.sprCover0.paint(g);
            }
            if (Level.covers[3]) {
                ScreenMain.sprCover45.setTransform(3);
                ScreenMain.sprCover45.setPosition(this.iCircleMidX - ScreenMain.sprCover45.getWidth(), this.iCircleMidY);
                ScreenMain.sprCover45.paint(g);
            }
            if (Level.covers[4]) {
                ScreenMain.sprCover0.setTransform(3);
                ScreenMain.sprCover0.setPosition(this.iCircleMidX - (ScreenMain.sprCover0.getWidth() >> 1), this.iCircleMidY);
                ScreenMain.sprCover0.paint(g);
            }
            if (Level.covers[5]) {
                ScreenMain.sprCover45.setTransform(5);
                ScreenMain.sprCover45.setPosition(this.iCircleMidX, this.iCircleMidY);
                ScreenMain.sprCover45.paint(g);
            }
            if (Level.covers[6]) {
                ScreenMain.sprCover0.setTransform(4);
                ScreenMain.sprCover0.setPosition(this.iCircleMidX - ScreenMain.sprCover0.getWidth(), this.iCircleMidY - (ScreenMain.sprCover0.getHeight() >> 1));
                ScreenMain.sprCover0.paint(g);
            }
            if (Level.covers[7]) {
                ScreenMain.sprCover45.setTransform(0);
                ScreenMain.sprCover45.setPosition(this.iCircleMidX, this.iCircleMidY - ScreenMain.sprCover45.getHeight());
                ScreenMain.sprCover45.paint(g);
            }
        }
    }

    public void keyPressed(int keycode) {
        if (this.isInited && (Keys.isKeyPressed(53) || Keys.isActionPressed(5))) {
            this.Throw();
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.isInited && !this.screen.isRightButtonPressed(x, y)) {
            this.Throw();
        }
    }

    private void Throw() {
        if (!this.isThrowing && !this.gameOverComming) {
            for (int i = 0; i < this.dots.length; ++i) {
                if (this.dots[i] >= 0 || this.dots[i] <= -100) continue;
                this.iThrowingIndex = i;
                this.isThrowing = true;
                this.iThrowAnimDotsOff = 0;
                break;
            }
        }
    }
}

