/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Game;
import sk.inlogic.Jewel;
import sk.inlogic.Level;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.screen.ScreenSelectBonusLevel;
import sk.inlogic.screen.ScreenSelectLevel;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    private MainCanvas mainCanvas;
    private boolean _bNeedRepaint;
    private int _iStatus = -1;
    private int _iGameMode;
    private int interuption = 0;
    private static final int STATUS_GAME = 0;
    private static final int STATUS_INGAMEMENU = 1;
    private static final int STATUS_RESULTDIALOG = 2;
    private static final int STATUS_INSTRUCTIONS = 3;
    private static final int STATUS_TUTORIAL = 4;
    private static final int STATUS_STARTSCREEN = 5;
    private static final int STATUS_RESTARTSCREEN = 6;
    private static final int STATUS_LAST_MESSAGE = 7;
    private static final int STATUS_REALY_QUIT = 8;
    private static final int STATUS_MAIN_MENU = 9;
    private static final int STATUS_MAIN_LEVEL_SELECT = 9;
    private static final int COMP_ID_HINT = 0;
    private static final int COMP_ID_MENU = 4;
    private static final int COMP_ID_RESTART = 5;
    private static final int COMP_ID_SOUNDS = 3;
    private static final int COMP_ID_MAINMENU = 6;
    private static final int COMP_ID_INSTRUCTIONS = 1;
    private static final int COMP_ID_ARR_UP = 7;
    private static final int COMP_ID_ARR_DOWN = 8;
    private static final int TOTAL_COMP_IDS = 9;
    private Rectangle[] _rectItems = new Rectangle[9];
    private Rectangle _rectGameArea;
    private Rectangle _rectDialog;
    private Rectangle _rectLogo;
    private Rectangle _rectText;
    private Rectangle _rectTop;
    private Rectangle _rectTutorialWindow;
    private final int _iNextScreenTutorial;
    private final int _iNextScreenGoal;
    private final int _iNextScreenGame;
    private final int _iNextScreenGameMenu;
    private final int _iNextScreenGameInstructions;
    private final int _iNextScreenGameResult;
    private final int _iNextScreenGameRestart;
    private final int _iNextScreenGameRealyQuit;
    private final int _iNextScreenMainMenu;
    private int _iCycle = 10;
    private int _iOffsetX;
    private int _iOffsetY;
    private int _iOffsetXDefault = 5;
    private int _iOffsetButton = 0;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private int _iDecorTop;
    private boolean _bChangeSequence = false;
    private Image _imgBg;
    private Image _imgStar;
    private Image _imgGameLogo;
    private Image _imgTileDecor;
    private Sprite _sprArrow;
    private Sprite _sprFkButton;
    private Sprite _sprFkIcons;
    private Sprite _sprMenuButton;
    private Sprite _sprMenuIcons;
    private Sprite _sprProgressBarBg;
    private Sprite _sprProgressBarIconBg;
    private Sprite _sprProgressBarIconFg;
    private Sprite _sprWindows;
    private Sprite _sprGameDecor;
    private PreparedText _ptTitle;
    private PreparedText _ptItemName;
    private PreparedText _ptInstructions;
    private PreparedText _ptGameTutorial;
    private PreparedText _ptGameTxts;
    private PreparedText _ptGameScore;
    private PreparedText _ptGameTarget;
    private int[][] _animationSequence = new int[9][13];
    private AnimationComponent[] _animationComponents = new AnimationComponent[13];
    private int _iSelectedCompId;
    private int icount;
    private static int PROGRESWIDTH;
    private static int PROGRESH;
    private static PreparedText preparedInstructionsText;
    private int _iTextOffsetY;
    private boolean _bScrollUP = false;
    private boolean _bScrollDOWN = true;
    int level = 0;
    private int _iActualLevel;
    private boolean _bBonusPack = false;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iFinalHeight;
    private int _totalRowTiles = 0;
    private int _totalColTiles = 0;
    private int _totalRowTilesFrance = 0;
    private int _totalColTilesFrance = 0;
    int _iBw;
    private int score = 0;
    private String stars = "";
    int lvl = 0;
    int checkButton = 5;
    int checkButton2 = 5;

    public ScreenGame(MainCanvas mC, int gameMode, int level, boolean bonus) {
        this._iNextScreenTutorial = 0;
        this._iNextScreenGoal = 1;
        this._iNextScreenGame = 2;
        this._iNextScreenGameMenu = 3;
        this._iNextScreenGameInstructions = 4;
        this._iNextScreenGameResult = 5;
        this._iNextScreenGameRestart = 6;
        this._iNextScreenGameRealyQuit = 7;
        this._iNextScreenMainMenu = 8;
        this.mainCanvas = mC;
        this._iGameMode = gameMode;
        this._iActualLevel = level;
        this._bBonusPack = bonus;
        if (this._bBonusPack) {
            Level.getBonusLevel(this._iActualLevel);
        } else {
            Level.getLevel(this._iActualLevel);
        }
        this.initDimensions();
    }

    public void beforeShow() {
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initFonts();
        this.calculatePositions();
        this.preapreTxt();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.loadLevel();
        this.loadData();
        if (Level._bIsTutorial) {
            this.startAnimation(true, 4);
        } else {
            this.startAnimation(true, 5);
        }
    }

    public void afterHide() {
        RMSObjects.freeRMSConnect(this.getRMSConnectIdByGameType(this._iGameMode));
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2, 4, 7, 5, 6});
        Resources.loadSprites(new int[]{22, 1, 0, 3, 2, 12, 10, 25, 11, 13, 14, 15, 16, 17, 18, 19, 24, 20, 21});
        Resources.loadGFonts(new int[]{0, 1});
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2, 4, 7, 5, 6});
        Resources.freeSprites(new int[]{22, 1, 0, 3, 2, 12, 10, 25, 11, 13, 14, 15, 16, 17, 18, 19, 24, 20, 21});
        Resources.freeGFonts(new int[]{0, 1});
    }

    private void initDimensions() {
        this._WIDTH = this.mainCanvas.getWidth();
        this._HEIGHT = this.mainCanvas.getHeight();
    }

    private void initImages() {
        this._imgBg = Resources.resImgs[2];
        this._imgGameLogo = Resources.resImgs[4];
        this._imgStar = Resources.resImgs[7];
        this._imgTileDecor = Resources.resImgs[6];
    }

    private void initSprites() {
        this._sprFkButton = Resources.resSprs[1];
        this._sprMenuButton = Resources.resSprs[3];
        this._sprFkIcons = Resources.resSprs[0];
        this._sprMenuIcons = Resources.resSprs[2];
        this._sprProgressBarBg = Resources.resSprs[12];
        this._sprProgressBarIconBg = Resources.resSprs[24];
        this._sprProgressBarIconFg = Resources.resSprs[11];
        this._sprArrow = Resources.resSprs[22];
        this._sprWindows = Resources.resSprs[10];
        this._sprGameDecor = Resources.resSprs[25];
    }

    private void initFonts() {
        this._ptTitle = new PreparedText(Resources.resGFonts[0]);
        this._ptItemName = new PreparedText(Resources.resGFonts[0]);
        this._ptInstructions = new PreparedText(Resources.resGFonts[0]);
        this._ptGameScore = new PreparedText(Resources.resGFonts[1]);
        this._ptGameTarget = new PreparedText(Resources.resGFonts[1]);
        this._ptGameTutorial = new PreparedText(Resources.resGFonts[0]);
        this._ptGameTxts = new PreparedText(Resources.resGFonts[0]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 5;
        this._animationSequence[0][1] = 10;
        this._animationSequence[0][2] = 11;
        this._animationSequence[0][3] = 12;
        this._animationSequence[0][4] = -1;
        this._animationSequence[0][5] = -1;
        this._animationSequence[1][0] = 4;
        this._animationSequence[1][1] = 6;
        this._animationSequence[1][2] = 7;
        this._animationSequence[1][3] = 8;
        this._animationSequence[1][4] = 9;
        this._animationSequence[1][5] = 10;
        this._animationSequence[3][0] = 1;
        this._animationSequence[3][1] = 3;
        this._animationSequence[3][2] = 5;
        this._animationSequence[3][3] = 10;
        this._animationSequence[3][4] = -1;
        this._animationSequence[3][5] = -1;
        this._animationSequence[7][0] = 1;
        this._animationSequence[7][1] = 3;
        this._animationSequence[7][2] = 10;
        this._animationSequence[7][3] = -1;
        this._animationSequence[7][4] = -1;
        this._animationSequence[7][5] = -1;
        this._animationSequence[8][0] = 1;
        this._animationSequence[8][1] = 3;
        this._animationSequence[8][2] = 10;
        this._animationSequence[8][3] = 11;
        this._animationSequence[8][4] = -1;
        this._animationSequence[8][5] = -1;
        this._animationSequence[6][0] = 1;
        this._animationSequence[6][1] = 3;
        this._animationSequence[6][2] = 10;
        this._animationSequence[6][3] = 11;
        this._animationSequence[6][4] = -1;
        this._animationSequence[6][5] = -1;
        this._animationSequence[2][0] = 1;
        this._animationSequence[2][1] = 3;
        this._animationSequence[2][2] = 10;
        this._animationSequence[2][3] = 11;
        this._animationSequence[2][4] = -1;
        this._animationSequence[2][5] = -1;
        this._animationSequence[5][0] = 1;
        this._animationSequence[5][1] = 3;
        this._animationSequence[5][2] = 11;
        this._animationSequence[5][3] = -1;
        this._animationSequence[5][4] = -1;
        this._animationSequence[5][5] = -1;
        this._animationSequence[4][0] = 1;
        this._animationSequence[4][1] = 3;
        this._animationSequence[4][2] = 11;
        this._animationSequence[4][3] = -1;
        this._animationSequence[4][4] = -1;
        this._animationSequence[4][5] = -1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, new Rectangle(0, 0, 0, 0), this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this._rectDialog, this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, new Rectangle(0, 0, 0, 0), this._WIDTH, this._HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this._rectText, this._WIDTH, this._HEIGHT);
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this._rectLogo, this._WIDTH, this._HEIGHT);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this._rectTop, this._WIDTH, this._HEIGHT);
        this._animationComponents[6] = new AnimationComponent(this.mainCanvas, this._rectItems[5], this._WIDTH, this._HEIGHT);
        this._animationComponents[7] = new AnimationComponent(this.mainCanvas, this._rectItems[3], this._WIDTH, this._HEIGHT);
        this._animationComponents[8] = new AnimationComponent(this.mainCanvas, this._rectItems[1], this._WIDTH, this._HEIGHT);
        this._animationComponents[9] = new AnimationComponent(this.mainCanvas, this._rectItems[6], this._WIDTH, this._HEIGHT);
        this._animationComponents[10] = new AnimationComponent(this.mainCanvas, this._rectItems[4], this._WIDTH, this._HEIGHT);
        this._animationComponents[11] = new AnimationComponent(this.mainCanvas, this._rectItems[0], this._WIDTH, this._HEIGHT);
        this._animationComponents[12] = new AnimationComponent(this.mainCanvas, this._rectGameArea, this._WIDTH, this._HEIGHT);
        this.showAnimationComponent();
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(2);
        this._animationComponents[3].startShowAnimation(3);
        this._animationComponents[4].startShowAnimation(2);
        this._animationComponents[5].startShowAnimation(2);
        this._animationComponents[6].startShowAnimation(1);
        this._animationComponents[7].startShowAnimation(0);
        this._animationComponents[8].startShowAnimation(1);
        this._animationComponents[9].startShowAnimation(0);
        this._animationComponents[10].startShowAnimation(1);
        this._animationComponents[11].startShowAnimation(0);
        this._animationComponents[12].startShowAnimation(3);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(3);
        this._animationComponents[2].startHideAnimation(2);
        this._animationComponents[3].startHideAnimation(3);
        this._animationComponents[4].startHideAnimation(2);
        this._animationComponents[5].startHideAnimation(2);
        this._animationComponents[6].startHideAnimation(1);
        this._animationComponents[7].startHideAnimation(0);
        this._animationComponents[8].startHideAnimation(1);
        this._animationComponents[9].startHideAnimation(0);
        this._animationComponents[10].startHideAnimation(1);
        this._animationComponents[11].startHideAnimation(0);
        this._animationComponents[12].startHideAnimation(3);
    }

    private void preapreTxt() {
        String _sTmpControls = Resources.resTexts[0].getHashedString(16);
        this._ptTitle.prepareText(Resources.resTexts[0].getHashedString(22), this._rectTop.width);
        this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(25), this._rectItems[5].width);
        this._ptInstructions.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + _sTmpControls, this._rectText.width);
        this._ptInstructions.setLineHeightCorrection(-2);
        this._ptGameScore.prepareText("0", this._rectTop.width);
        this._ptGameTarget.prepareText("0", this._rectTop.width);
    }

    private void loadLevel() {
        this.lvl = this._iGameMode == Level.TYPE_BLOCKER || this._iGameMode == Level.TYPE_MIXED_TIME_AND_BLOCKS ? Level._iBlockScheme : 1;
        RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this._iActualLevel, this.lvl, Level._iGameColors);
    }

    private void loadData() {
        int rmsConnectId = this.getRMSConnectIdByGameType(0);
        RMSObjects.createRMSConnect(rmsConnectId);
        if (!this._bBonusPack) {
            RMSObjects.createRMSConnect(0);
            RMSObjects.rmsConnects[0].load();
        } else {
            RMSObjects.createRMSConnect(9);
            RMSObjects.rmsConnects[9].load();
        }
    }

    private void freeGraphics() {
        this._imgBg = null;
        this._imgGameLogo = null;
        this._sprArrow = null;
        this._sprFkButton = null;
        this._sprFkIcons = null;
        this._sprMenuButton = null;
        this._sprMenuIcons = null;
        this._sprProgressBarBg = null;
        this._sprProgressBarIconBg = null;
        this._sprProgressBarIconFg = null;
        this._sprWindows = null;
        this._sprGameDecor = null;
        this._ptTitle = null;
        this._ptItemName = null;
        this._ptInstructions = null;
    }

    private void addScoreToTable() {
        if (!this._bBonusPack) {
            PowV2ScoreItem scoreItem = new PowV2ScoreItem();
            scoreItem.powGameId = 0;
            scoreItem.scorePos = this._iActualLevel;
            scoreItem.userName = Integer.toString(this._iActualLevel);
            scoreItem.scoreValue = RMSObjects.game.getScore() >= Level._iScoreHig ? 3 : (RMSObjects.game.getScore() >= Level._iScoreMid ? 2 : 1);
            RMSObjects.localScores.userName = Integer.toString(this._iActualLevel);
            RMSObjects.localScores.insertScoreItem(scoreItem, this._iActualLevel);
            if (!RMSObjects.rmsConnects[0].isExist()) {
                RMSObjects.rmsConnects[0].create();
            }
            RMSObjects.rmsConnects[0].save();
        } else {
            PowV2ScoreItem scoreItem = new PowV2ScoreItem();
            scoreItem.powGameId = 0;
            scoreItem.scorePos = this._iActualLevel;
            scoreItem.userName = Integer.toString(this._iActualLevel);
            scoreItem.scoreValue = RMSObjects.game.getScore() >= Level._iScoreHig ? 3 : (RMSObjects.game.getScore() >= Level._iScoreMid ? 2 : 1);
            RMSObjects.localScoresBonus.userName = Integer.toString(this._iActualLevel);
            RMSObjects.localScoresBonus.insertScoreItem(scoreItem, this._iActualLevel);
            if (!RMSObjects.rmsConnects[9].isExist()) {
                RMSObjects.rmsConnects[9].create();
            }
            RMSObjects.rmsConnects[9].save();
        }
    }

    private int getRMSConnectIdByGameType(int gameType) {
        switch (0) {
            case 20: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
        }
        return 0;
    }

    public void beforeInteruption() {
        if (this._iStatus == 0) {
            this.setGameMenuStatus();
        }
        this.mainCanvas.getSoundManager().Stop();
    }

    public void afterInteruption() {
        this.mainCanvas.getSoundManager().Play(Sounds.SOUND_GAME, -1);
    }

    private void calculatePositions() {
        Jewel.SHIFT_HORIZONTAL_SEL = (Resources.resSprs[25].getWidth() >> 1) - (Resources.resSprs[13].getWidth() >> 1);
        Jewel.SHIFT_VERTICAL_SEL = (Resources.resSprs[25].getWidth() >> 1) - (Resources.resSprs[13].getWidth() >> 1);
        Jewel.BLOCKSIZE = Resources.resImgs[5].getWidth();
        Jewel.SHIFT_HORIZONTAL = (Resources.resImgs[5].getWidth() >> 1) - (Resources.resSprs[13].getWidth() >> 1);
        Jewel.SHIFT_VERTICAL = (Resources.resImgs[5].getHeight() >> 1) - (Resources.resSprs[13].getHeight() >> 1);
        Jewel.SHIFT_HORIZONTAL_FALL = (Resources.resImgs[5].getWidth() >> 1) - (Resources.resSprs[13].getWidth() >> 1);
        Jewel.SHIFT_VERTICAL_FALL = (Resources.resImgs[5].getHeight() >> 1) - 1;
        Jewel.SHIFT_HORIZONTAL_ESCAPE = (Resources.resImgs[5].getWidth() >> 1) - (Resources.resSprs[18].getWidth() >> 1);
        Jewel.SHIFT_VERTICAL_ESCAPE = (Resources.resImgs[5].getHeight() >> 1) - (Resources.resSprs[18].getHeight() >> 1);
        int _windowWidth = this._WIDTH >> 1;
        int _offsetX = _windowWidth % this._sprWindows.getWidth() > 0 ? _windowWidth % this._sprWindows.getWidth() : this._sprWindows.getWidth();
        int _offsetTopY = this._sprFkButton.getHeight();
        int _offsetBottomY = this._sprFkButton.getHeight();
        int _panelHeight = this._HEIGHT - _offsetTopY - _offsetBottomY;
        this._iOffsetX = _offsetX;
        this._iOffsetY >>= 4;
        boolean posX = false;
        int posY = this._imgGameLogo.getHeight() + this._iOffsetY;
        this._iOffsetX = _offsetX;
        int _iTmpY = (MainCanvas.HEIGHT - (Jewel.BLOCKSIZE << 3) >> 1) - this._sprProgressBarBg.getHeight() >> 1;
        this._rectTop = new Rectangle(this._iOffsetXDefault, _iTmpY, this._WIDTH - (this._iOffsetXDefault << 1), this._sprProgressBarBg.getHeight());
        int _iWidth = this._WIDTH % this._sprProgressBarBg.getWidth() == 0 ? this._WIDTH : this._WIDTH - this._WIDTH % this._sprProgressBarBg.getWidth();
        int _iOffsetXs = this._WIDTH - _iWidth >> 1;
        this._rectTop = new Rectangle(_iOffsetXs, _iTmpY, _iWidth, this._sprProgressBarBg.getHeight());
        this._rectLogo = new Rectangle(this._WIDTH >> 1, 0, this._imgGameLogo.getWidth(), this._imgGameLogo.getHeight());
        this._iFinalHeight = _panelHeight % this._sprWindows.getWidth() == 0 ? _panelHeight : _panelHeight - _panelHeight % this._sprWindows.getWidth();
        this._rectDialog = new Rectangle(_offsetX, _offsetTopY, this._WIDTH - (_offsetX << 1), this._iFinalHeight);
        this._rectText = new Rectangle(_offsetX + (this._sprFkIcons.getWidth() >> 1), _offsetTopY + this._sprFkIcons.getHeight(), this._WIDTH - (_offsetX << 1) - this._sprFkIcons.getWidth(), this._iFinalHeight - (this._sprFkIcons.getHeight() << 1));
        this._rectItems[5] = new Rectangle((this._WIDTH >> 1) - (this._sprMenuButton.getWidth() >> 1), (this._HEIGHT >> 1) - (this._sprMenuButton.getHeight() >> 1), this._sprMenuButton.getWidth(), this._sprMenuButton.getHeight());
        int pY = this._rectItems[5].y + this._rectItems[5].height;
        int pX = (this._WIDTH >> 1) - (this._sprMenuButton.getWidth() >> 1);
        int pXoffset = this._sprMenuButton.getWidth();
        this._rectItems[3] = new Rectangle(pX, pY + (this._sprMenuButton.getHeight() >> 2), this._sprMenuButton.getWidth(), this._sprMenuButton.getHeight());
        this._rectItems[1] = new Rectangle(pX - pXoffset, pY - (this._sprMenuButton.getHeight() >> 1), this._sprMenuButton.getWidth(), this._sprMenuButton.getHeight());
        this._rectItems[6] = new Rectangle(pX + pXoffset, pY - (this._sprMenuButton.getHeight() >> 1), this._sprMenuButton.getWidth(), this._sprMenuButton.getHeight());
        this._rectItems[7] = new Rectangle(this._rectDialog.getCenterX() - (this._sprArrow.getWidth() >> 1), this._rectDialog.y - this._sprArrow.getHeight(), this._sprArrow.getWidth(), this._sprFkIcons.getHeight());
        this._rectItems[8] = new Rectangle(this._rectDialog.getCenterX() - (this._sprArrow.getWidth() >> 1), this._rectDialog.y + this._rectDialog.height + (this._sprArrow.getHeight() >> 2), this._sprArrow.getWidth(), this._sprArrow.getHeight());
        this._rectItems[0] = new Rectangle(0, MainCanvas.HEIGHT - (this._sprFkButton.getWidth() << 1), this._sprFkButton.getWidth() << 1, this._sprFkButton.getHeight() << 1);
        this._rectItems[4] = new Rectangle(MainCanvas.WIDTH - (this._sprFkButton.getWidth() << 1), MainCanvas.HEIGHT - (this._sprFkButton.getHeight() << 1), this._sprFkButton.getWidth() << 1, this._sprFkButton.getHeight() << 1);
        this.calculateWindowTiles();
        this._rectGameArea = new Rectangle(MainCanvas.WIDTH - (Jewel.BLOCKSIZE << 3) >> 1, MainCanvas.HEIGHT - (Jewel.BLOCKSIZE << 3) >> 1, Jewel.BLOCKSIZE << 3, Jewel.BLOCKSIZE << 3);
        PROGRESH = 50;
        Jewel.MOVE_VELOCITY = (this._rectGameArea.width << 8) / 48;
        Jewel.DSP_BNSBOMB = Resources.resSprs[16].getWidth() - Jewel.BLOCKSIZE >> 1;
        Jewel.DSP_BNSCROSS = Resources.resSprs[17].getWidth() - Jewel.BLOCKSIZE >> 1;
        this._iDecorTop = this._rectGameArea.y;
    }

    private void calculateWindowTiles() {
        this._totalColTiles = (this._WIDTH - (this._iOffsetX << 1)) / this._sprWindows.getWidth();
        this._totalRowTiles = this._iFinalHeight / this._sprWindows.getWidth();
    }

    public void update(long lastRunLenght) {
        if (this._iStatus == 0 && this._iNextMode != 2) {
            RMSObjects.game.update(lastRunLenght);
            if (RMSObjects.game.isLevelDone()) {
                this.startAnimation(true, 2);
            } else if (RMSObjects.game.isGameOver()) {
                this.startAnimation(true, 2);
                this.icount = -1;
                if (this.getTopScore() < RMSObjects.game.getScore()) {
                    this.icount = 0;
                }
            }
            this.mainCanvas.repaint();
        }
        if (this._iStatus == 2 && this.icount >= 0) {
            ++this.icount;
            this.icount %= 10;
            this.mainCanvas.repaint();
        }
        if (this._iStatus == 3) {
            this._bNeedRepaint = false;
            this.textMove();
            if (this._bNeedRepaint) {
                this.mainCanvas.repaint();
            }
        }
        this.animationController();
        this.animationComponentsUpdate();
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == 4 ? this._iSequenceHide : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        if (this._iStatus != -1) {
            for (int i = 0; i < this._animationSequence[this._iStatus].length; ++i) {
                if (i >= this._animationSequence[this._iStatus].length || this._animationSequence[this._iStatus][i] == -1 || this._animationComponents[this._animationSequence[this._iStatus][i]] == null || this._animationComponents[this._animationSequence[this._iStatus][i]].isComponentAnimated()) continue;
                this._animationComponents[this._animationSequence[this._iStatus][i]].update();
                this.mainCanvas.repaint();
                _return = true;
            }
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                if (this._iNextMode == 9) {
                    this.startMenuScreen();
                }
                if (this._iNextMode == 9) {
                    this.startSelectLevel();
                }
                this._iSequence = this._iSequenceShow;
                this._iStatus = this._iNextMode;
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startMenuScreen() {
        ScreenMenu sg = new ScreenMenu(this.mainCanvas, 0);
        if (this.mainCanvas.getSoundManager().IsSoundOn()) {
            this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        }
        this.mainCanvas.changeLastActiveScreen(sg);
    }

    private void startSelectLevel() {
        if (!this._bBonusPack) {
            this.mainCanvas.changeLastActiveScreen(new ScreenSelectLevel(this.mainCanvas, 0));
        } else {
            this.mainCanvas.changeLastActiveScreen(new ScreenSelectBonusLevel(this.mainCanvas, 0));
        }
        this.mainCanvas.getSoundManager().Stop();
        if (this.mainCanvas.getSoundManager().IsSoundOn()) {
            this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        }
    }

    private void reset() {
        try {
            this.score = 0;
            this.stars = "";
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        switch (this._iStatus) {
            case 0: {
                this.paintGame(g);
                break;
            }
            case 1: {
                this.paintGameMenuScreen(g);
                break;
            }
            case 3: {
                this.paintInstructionsScreen(g);
                break;
            }
            case 7: {
                this.paintLastMessageScreen(g);
                break;
            }
            case 8: {
                this.paintRealyQuitScreen(g);
                break;
            }
            case 6: {
                this.paintRestartScreen(g);
                break;
            }
            case 2: {
                this.paintResultScreen(g);
                break;
            }
            case 5: {
                this.paintLevelGoalScreen(g);
                break;
            }
            case 4: {
                this.paintTutorialScreen(g);
            }
        }
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        g.drawImage(this._imgBg, 0, 0, 20);
    }

    private void paintGame(Graphics g) {
        RMSObjects.game.paint(g);
        this.paintGameDecor(g);
        this.paintGameProgressBar(g);
    }

    private void paintGameMenuScreen(Graphics g) {
        this.paintLogo(g);
        this.paintDialog(g);
    }

    private void paintInstructionsScreen(Graphics g) {
        this.paintWindow(g, false);
        this.paintInstructionsTxt(g);
        this.paintArrows(g);
    }

    private void paintLastMessageScreen(Graphics g) {
        this.paintWindow(g, false);
        this.paintLastMessageTxt(g);
    }

    private void paintRealyQuitScreen(Graphics g) {
        this.paintWindow(g, false);
        this.paintRealyQuitMessageTxt(g);
    }

    private void paintRestartScreen(Graphics g) {
        this.paintWindow(g, false);
        this.paintRestartTxt(g);
    }

    private void paintResultScreen(Graphics g) {
        this.paintWindow(g, false);
        this.paintResultTxt(g);
    }

    private void paintLevelGoalScreen(Graphics g) {
        this.paintWindow(g, false);
        this.paintLevelGoalTxt(g);
    }

    private void paintTutorialScreen(Graphics g) {
        this.paintWindow(g, true);
        this.paintTutorialTxt(g);
    }

    private void paintLogo(Graphics g) {
        g.drawImage(this._imgGameLogo, this._rectLogo.x, this._rectLogo.y, 17);
    }

    private void paintDialog(Graphics g) {
        if (this._iSelectedCompId == 5) {
            this.paintButton(g, 5, true);
        } else {
            this.paintButton(g, 5, false);
        }
        if (this._iSelectedCompId == 1) {
            this.paintButton(g, 1, true);
        } else {
            this.paintButton(g, 1, false);
        }
        if (this._iSelectedCompId == 3) {
            this.paintButton(g, 3, true);
        } else {
            this.paintButton(g, 3, false);
        }
        if (this._iSelectedCompId == 6) {
            this.paintButton(g, 6, true);
        } else {
            this.paintButton(g, 6, false);
        }
    }

    private void paintButton(Graphics g, int _iDx, boolean _bSelected) {
        switch (_iDx) {
            case 5: {
                this._sprMenuIcons.setFrame(4);
                break;
            }
            case 1: {
                this._sprMenuIcons.setFrame(0);
                break;
            }
            case 3: {
                this._sprMenuIcons.setFrame(this.mainCanvas.getSoundManager().IsSoundOn() ? 2 : 3);
                break;
            }
            case 6: {
                this._sprMenuIcons.setFrame(5);
            }
        }
        this._sprMenuButton.setFrame(0);
        this._sprMenuButton.setPosition(this._rectItems[_iDx].x, this._rectItems[_iDx].y);
        this._sprMenuIcons.setPosition(this._rectItems[_iDx].x + ((this._sprMenuButton.getWidth() >> 1) - (this._sprMenuIcons.getWidth() >> 1)), this._rectItems[_iDx].y + ((this._sprMenuButton.getHeight() >> 1) - (this._sprMenuIcons.getHeight() >> 1)));
        this._sprMenuButton.paint(g);
        this._sprMenuIcons.paint(g);
        if (_bSelected) {
            this._sprMenuButton.setFrame(1);
            this._sprMenuButton.setPosition(this._rectItems[_iDx].x, this._rectItems[_iDx].y);
            this._sprMenuButton.paint(g);
        }
    }

    private void paintGameDecor(Graphics g) {
        int _iIdx;
        this._sprGameDecor.setTransform(0);
        for (_iIdx = 0; _iIdx < 8; ++_iIdx) {
            this._sprGameDecor.setPosition(this._rectGameArea.x + _iIdx * this._sprGameDecor.getWidth(), this._iDecorTop - (this._sprGameDecor.getHeight() >> 1) - (this._sprGameDecor.getHeight() >> 1));
            this._sprGameDecor.paint(g);
        }
        this._sprGameDecor.setTransform(3);
        for (_iIdx = 0; _iIdx < 8; ++_iIdx) {
            this._sprGameDecor.setPosition(this._rectGameArea.x + _iIdx * this._sprGameDecor.getWidth(), this._iDecorTop + this._rectGameArea.height);
            this._sprGameDecor.paint(g);
        }
    }

    private void paintTitle(Graphics g) {
        this._ptTitle.drawText(g, this._rectTop, this._ptTitle.getTextHeight() >> 2, 3);
    }

    private void paintGameProgressBar(Graphics g) {
        String _sTmpTarget = "";
        String _sTmpScore = "" + RMSObjects.game.getScore() + "";
        if (this._iGameMode != 1 && this._iGameMode != 7 && this._iGameMode != 4 && this._iGameMode != 6) {
            _sTmpTarget = _sTmpTarget + "m" + (Level._iMoves - MainCanvas.moveCounter);
        } else if (this._iGameMode == 7) {
            _sTmpTarget = _sTmpTarget + "m" + (Level._iMoves - MainCanvas.moveCounter);
        } else if (this._iGameMode == 1 || this._iGameMode == 4 || this._iGameMode == 6) {
            _sTmpTarget = _sTmpTarget + " " + Integer.toString((int)Level._lTime - RMSObjects.game.getTimeInSec());
        }
        if (this._iGameMode == 3) {
            _sTmpTarget = Level._iDownfallObjCount - Game._iProgressSecondary >= 0 ? _sTmpTarget + "d" + (Level._iDownfallObjCount - Game._iProgressSecondary) : _sTmpTarget + "d0";
        }
        if (this._iGameMode == 2) {
            _sTmpTarget = Level._iEscapeObjCount - Game._iProgressSecondary >= 0 ? _sTmpTarget + "d" + (Level._iEscapeObjCount - Game._iProgressSecondary) : _sTmpTarget + "d0";
        }
        if (this._iGameMode == 6) {
            if (Level._iEscapeObjCount - Game._iProgressSecondary >= 0) {
                _sTmpTarget = _sTmpTarget + "d" + (Level._iEscapeObjCount - Game._iProgressSecondary);
                if (Level._lTime - (long)RMSObjects.game.getTimeInSec() < 10L) {
                    _sTmpTarget = _sTmpTarget + " " + Integer.toString((int)Level._lTime - RMSObjects.game.getTimeInSec());
                }
            } else {
                _sTmpTarget = _sTmpTarget + "d0";
                if (Level._lTime - (long)RMSObjects.game.getTimeInSec() < 10L) {
                    _sTmpTarget = _sTmpTarget + " " + Integer.toString((int)Level._lTime - RMSObjects.game.getTimeInSec());
                }
            }
        }
        int _iTotalPieces = this._rectTop.width / this._sprProgressBarBg.getWidth();
        int _iOffsetX = this._WIDTH - this._rectTop.width >> 1;
        for (int _iIdx = 0; _iIdx < _iTotalPieces; ++_iIdx) {
            if (_iIdx == 0) {
                this._sprProgressBarBg.setFrame(0);
            } else if (_iIdx == _iTotalPieces - 1) {
                this._sprProgressBarBg.setFrame(2);
            } else {
                this._sprProgressBarBg.setFrame(1);
            }
            this._sprProgressBarBg.setPosition(_iOffsetX + _iIdx * this._sprProgressBarBg.getWidth(), this._rectTop.y);
            this._sprProgressBarBg.paint(g);
        }
        this._sprProgressBarIconBg.setFrame(1);
        this._sprProgressBarIconBg.setPosition(this._rectTop.getCenterX() - (this._sprProgressBarIconBg.getWidth() >> 1), this._rectTop.y);
        this._sprProgressBarIconBg.paint(g);
        switch (this._iGameMode) {
            case 0: {
                this._sprProgressBarIconFg.setFrame(0);
                break;
            }
            case 1: {
                this._sprProgressBarIconFg.setFrame(1);
                break;
            }
            case 2: {
                this._sprProgressBarIconFg.setFrame(3);
                break;
            }
            case 3: {
                this._sprProgressBarIconFg.setFrame(2);
                break;
            }
            case 4: {
                this._sprProgressBarIconFg.setFrame(4);
                break;
            }
            case 5: {
                this._sprProgressBarIconFg.setFrame(4);
                break;
            }
            case 6: {
                this._sprProgressBarIconFg.setFrame(3);
                break;
            }
            case 7: {
                this._sprProgressBarIconFg.setFrame(0);
                break;
            }
            case 8: {
                this._sprProgressBarIconFg.setFrame(4);
            }
        }
        this._sprProgressBarIconFg.setPosition(this._sprProgressBarIconBg.getX() + ((this._sprProgressBarIconBg.getWidth() >> 1) - (this._sprProgressBarIconFg.getWidth() >> 1)), this._sprProgressBarIconBg.getY() + ((this._sprProgressBarIconBg.getHeight() >> 1) - (this._sprProgressBarIconFg.getHeight() >> 1)));
        this._sprProgressBarIconFg.paint(g);
        int _iOff = (this._sprProgressBarBg.getHeight() >> 1) - (this._ptGameScore.getTextHeight() >> 1);
        Rectangle _lect = new Rectangle(0, this._rectTop.y, this._WIDTH, this._sprProgressBarBg.getHeight());
        this._ptGameScore.prepareText(_sTmpScore, this._rectTop.width);
        this._ptGameScore.drawText(g, _lect, -(_iOff >> 1), 10);
        this._ptGameTarget.prepareText(_sTmpTarget, this._rectTop.width);
        this._ptGameTarget.drawText(g, _lect, -(_iOff >> 1), 6);
    }

    private void paintWindow(Graphics g, boolean _bTutorial) {
        int _actualTileX = 0;
        int _actualTileY = 0;
        for (int x = this._rectDialog.x; x < this._rectDialog.x + this._rectDialog.width; x += this._sprWindows.getWidth()) {
            for (int y = this._rectDialog.y; y < this._rectDialog.y + this._rectDialog.height; y += this._sprWindows.getWidth()) {
                this._sprWindows.setFrame(this.getWindowTileSprite(_actualTileX, _actualTileY));
                this._sprWindows.setPosition(x, y);
                this._sprWindows.paint(g);
                ++_actualTileY;
            }
            _actualTileY = 0;
            ++_actualTileX;
        }
    }

    private void paintArrows(Graphics g) {
        if (this._ptInstructions.getTextHeight() >= this._rectText.height) {
            if (this._bScrollUP) {
                this._sprArrow.setTransform(3);
                this._sprArrow.setPosition(this._rectItems[7].x, this._rectItems[7].y);
                this._sprArrow.paint(g);
            }
            if (this._bScrollDOWN) {
                this._sprArrow.setTransform(0);
                this._sprArrow.setPosition(this._rectItems[8].x, this._rectItems[8].y);
                this._sprArrow.paint(g);
            }
        }
    }

    private void paintInstructionsTxt(Graphics g) {
        this._ptInstructions.drawText(g, this._rectText, this._iTextOffsetY, 20);
    }

    private void paintTutorialTxt(Graphics g) {
        String _sTutotialTxt = "";
        if (MainCanvas.controlsTut == 0 && this.level == 0) {
            _sTutotialTxt = Resources.resTexts[0].getHashedString(29);
        } else {
            switch (this._iGameMode) {
                case 0: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(31);
                    break;
                }
                case 1: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(35);
                    break;
                }
                case 2: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(33);
                    break;
                }
                case 3: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(34);
                    break;
                }
                case 5: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(32);
                }
            }
        }
        boolean _bShitDevice = false;
        if (this._WIDTH == 176 && this._HEIGHT == 208) {
            _bShitDevice = true;
        }
        if (this._WIDTH == 176 && this._HEIGHT == 220) {
            _bShitDevice = true;
        }
        if (this._WIDTH == 208 && this._HEIGHT == 208) {
            _bShitDevice = true;
        }
        if (MainCanvas._bFranceLang) {
            _bShitDevice = true;
        }
        if (_bShitDevice) {
            Rectangle _rectTmp = new Rectangle(this._sprWindows.getWidth() >> 1, this._sprWindows.getWidth() >> 1, this._WIDTH - this._sprWindows.getWidth(), this._HEIGHT - this._sprWindows.getWidth());
            g.setColor(15411240);
            g.fillRect(0, 0, this._WIDTH, this._HEIGHT);
            this._ptGameTutorial.prepareText(_sTutotialTxt, _rectTmp.width);
            this._ptGameTutorial.setLineHeightCorrection(-2);
            this._ptGameTutorial.drawText(g, _rectTmp, 0, 17);
        } else {
            this._ptGameTutorial.prepareText(_sTutotialTxt, this._rectText.width);
            this._ptGameTutorial.setLineHeightCorrection(-2);
            this._ptGameTutorial.drawText(g, this._rectText, 0, 17);
        }
    }

    private void paintLevelGoalTxt(Graphics g) {
        String _sGoalsTxt = "";
        switch (this._iGameMode) {
            case 0: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(43) + " " + Level._iMoves + " " + Resources.resTexts[0].getHashedString(44) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 1: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level._lTime + " " + Resources.resTexts[0].getHashedString(46);
                break;
            }
            case 2: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(39) + " " + Level._iEscapeObjCount + " " + Resources.resTexts[0].getHashedString(40) + " " + Resources.resTexts[0].getHashedString(43) + " " + Level._iMoves + " " + Resources.resTexts[0].getHashedString(48) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 3: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(41) + " " + Level._iDownfallObjCount + " " + Resources.resTexts[0].getHashedString(42) + " " + Resources.resTexts[0].getHashedString(47) + " " + Level._iMoves + " " + Resources.resTexts[0].getHashedString(48) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 4: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(38) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level._lTime + " " + Resources.resTexts[0].getHashedString(46) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 5: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(38) + " " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 6: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(39) + " " + Level._iEscapeObjCount + " " + Resources.resTexts[0].getHashedString(40) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level._lTime + " " + Resources.resTexts[0].getHashedString(46) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 7: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(43) + " " + Level._iMoves + " " + Resources.resTexts[0].getHashedString(44) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level._lTime + " " + Resources.resTexts[0].getHashedString(46) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
            }
        }
        this._ptGameTxts.prepareText(_sGoalsTxt, this._rectText.width);
        this._ptGameTxts.setLineHeightCorrection(-2);
        this._ptGameTxts.drawText(g, this._rectText, 0, 3);
    }

    private void paintLastMessageTxt(Graphics g) {
        String _sLastLevelGameMessge = "";
        _sLastLevelGameMessge = !this._bBonusPack ? (MainCanvas.totalStars == 180 ? Resources.resTexts[0].getHashedString(73) + " " + Resources.resTexts[0].getHashedString(74) : Resources.resTexts[0].getHashedString(72)) : (MainCanvas.totalBonusStars == 60 ? Resources.resTexts[0].getHashedString(76) : Resources.resTexts[0].getHashedString(75));
        this._ptGameTxts.prepareText(_sLastLevelGameMessge, this._rectText.width);
        this._ptGameTxts.setLineHeightCorrection(-2);
        this._ptGameTxts.drawText(g, this._rectText, 0, 3);
    }

    private void paintRealyQuitMessageTxt(Graphics g) {
        String _sQuitQuestion = Resources.resTexts[0].getHashedString(77);
        this._ptGameTxts.prepareText(_sQuitQuestion, this._rectText.width);
        this._ptGameTxts.setLineHeightCorrection(-2);
        this._ptGameTxts.drawText(g, this._rectText, 0, 3);
    }

    private void paintRestartTxt(Graphics g) {
        String _sRestart = Resources.resTexts[0].getHashedString(78);
        this._ptGameTxts.prepareText(_sRestart, this._rectText.width);
        this._ptGameTxts.setLineHeightCorrection(-2);
        this._ptGameTxts.drawText(g, this._rectText, 0, 3);
    }

    private void paintResultTxt(Graphics g) {
        if (RMSObjects.game.isLevelDone()) {
            this.paintWinTxt(g);
        } else if (RMSObjects.game.isGameOver()) {
            this.paintLoseTxt(g);
        }
    }

    private void paintWinTxt(Graphics g) {
        int _iTmpScore = RMSObjects.game.getScore();
        int _iTmpPositionX = this._WIDTH >> 1;
        int _iTmpPositionY = this._rectDialog.y + (this._ptGameTxts.getTextHeight() >> 1) + (this._ptGameTxts.getTextHeight() >> 2);
        String _sTmpFinal = "";
        if (_iTmpScore >= Level._iScoreHig) {
            g.drawImage(this._imgStar, _iTmpPositionX - this._imgStar.getWidth(), _iTmpPositionY, 17);
            g.drawImage(this._imgStar, _iTmpPositionX, _iTmpPositionY + (this._imgStar.getHeight() >> 3), 17);
            g.drawImage(this._imgStar, _iTmpPositionX + this._imgStar.getWidth(), _iTmpPositionY, 17);
        } else if (_iTmpScore >= Level._iScoreMid) {
            g.drawImage(this._imgStar, _iTmpPositionX - (this._imgStar.getWidth() >> 1), _iTmpPositionY + (this._imgStar.getHeight() >> 3), 17);
            g.drawImage(this._imgStar, _iTmpPositionX + (this._imgStar.getWidth() >> 1), _iTmpPositionY + (this._imgStar.getHeight() >> 3), 17);
        } else if (_iTmpScore >= Level._iScoreMin) {
            g.drawImage(this._imgStar, _iTmpPositionX, _iTmpPositionY + (this._imgStar.getHeight() >> 3), 17);
        }
        this._ptGameTxts.prepareText(Resources.resTexts[0].getHashedString(56), this._rectText.width);
        this._ptGameTxts.drawText(g, this._rectDialog, -(this._ptGameTxts.getTextHeight() >> 1), 17);
        _sTmpFinal = Resources.resTexts[0].getHashedString(10) + ": " + (_iTmpScore - RMSObjects.game.getBombScore() - RMSObjects.game.getEscScore() - RMSObjects.game.getDownScore()) + "\n" + Resources.resTexts[0].getHashedString(57) + ": " + RMSObjects.game.getBombScore() + "\n" + (this._iGameMode == 2 ? Resources.resTexts[0].getHashedString(59) + ": " + RMSObjects.game.getEscScore() : "") + (this._iGameMode == 3 ? Resources.resTexts[0].getHashedString(58) + ": " + RMSObjects.game.getDownScore() : "") + "TOTAL: " + _iTmpScore;
        this._ptGameTxts.prepareText(_sTmpFinal, this._rectText.width);
        this._ptGameTxts.drawText(g, this._rectDialog, -(this._imgStar.getHeight() >> 2), 3);
    }

    private void paintLoseTxt(Graphics g) {
        int _iTmpScore = RMSObjects.game.getScore();
        String _sTmpFinal = "";
        this._ptGameTxts.prepareText(Resources.resTexts[0].getHashedString(60), this._rectText.width);
        this._ptGameTxts.drawText(g, this._rectDialog, -this._ptGameTxts.getTextHeight(), 17);
        _sTmpFinal = Resources.resTexts[0].getHashedString(52) + "\n";
        switch (RMSObjects.game.getLoseMode()) {
            case 1: {
                _sTmpFinal = _sTmpFinal + Resources.resTexts[0].getHashedString(63);
                break;
            }
            case 3: {
                _sTmpFinal = _sTmpFinal + Resources.resTexts[0].getHashedString(64);
                break;
            }
            case 4: {
                _sTmpFinal = _sTmpFinal + Resources.resTexts[0].getHashedString(62);
                break;
            }
            case 2: {
                _sTmpFinal = _sTmpFinal + Resources.resTexts[0].getHashedString(61);
                break;
            }
            default: {
                _sTmpFinal = _sTmpFinal + Resources.resTexts[0].getHashedString(61);
            }
        }
        _sTmpFinal = _sTmpFinal + "\n\nTOTAL : " + _iTmpScore;
        this._ptGameTxts.prepareText(Resources.resTexts[0].getHashedString(60), this._rectText.width);
        this._ptGameTxts.prepareText(_sTmpFinal, this._rectText.width);
        this._ptGameTxts.drawText(g, this._rectDialog, this._ptGameTxts.getTextHeight() >> 2, 3);
    }

    private void paintButtonsTxt(Graphics g) {
        this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(25), this._rectItems[5].width);
        this._ptItemName.drawText(g, this._rectItems[5], this._ptItemName.getTextHeight() >> 2, 3);
        this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(22), this._rectItems[1].width);
        this._ptItemName.drawText(g, this._rectItems[1], this._ptItemName.getTextHeight() >> 2, 3);
        this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(19), this._rectItems[1].width);
        this._ptItemName.drawText(g, this._rectItems[6], this._ptItemName.getTextHeight() >> 2, 3);
        if (this.mainCanvas.getSoundManager().IsSoundOn()) {
            this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(26), this._rectItems[1].width);
        } else {
            this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(27), this._rectItems[1].width);
        }
        this._ptItemName.drawText(g, this._rectItems[3], this._ptItemName.getTextHeight() >> 2, 3);
    }

    private int getWindowTileSprite(int _x, int _y) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < this._totalColTiles - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == this._totalColTiles - 1) {
            return 2;
        }
        if (_y == this._totalRowTiles - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < this._totalRowTiles - 1 && _y > 0) {
            return 3;
        }
        if (_x == this._totalColTiles - 1 && _y < this._totalRowTiles - 1 && _y > 0) {
            return 5;
        }
        if (_y == this._totalRowTiles - 1 && _x < this._totalColTiles - 1 && _x > 0) {
            return 7;
        }
        if (_y == this._totalRowTiles - 1 && _x == this._totalColTiles - 1) {
            return 8;
        }
        return 4;
    }

    private int getWindowTileSpriteFrance(int _x, int _y) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < this._totalColTilesFrance - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == this._totalColTilesFrance - 1) {
            return 2;
        }
        if (_y == this._totalRowTilesFrance - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < this._totalRowTilesFrance - 1 && _y > 0) {
            return 3;
        }
        if (_x == this._totalColTilesFrance - 1 && _y < this._totalRowTilesFrance - 1 && _y > 0) {
            return 5;
        }
        if (_y == this._totalRowTilesFrance - 1 && _x < this._totalColTilesFrance - 1 && _x > 0) {
            return 7;
        }
        if (_y == this._totalRowTilesFrance - 1 && _x == this._totalColTilesFrance - 1) {
            return 8;
        }
        return 4;
    }

    private void paintFK(Graphics g) {
        if (this._iStatus == 0) {
            this._sprFkButton.setFrame(0);
            this._sprFkButton.setPosition(this._rectItems[4].x + (this._sprFkButton.getWidth() >> 1) - (this._sprFkButton.getWidth() >> 1) + this._sprFkButton.getWidth(), this._rectItems[4].y + (this._sprFkButton.getHeight() >> 1) - (this._sprFkButton.getHeight() >> 1) + this._sprFkButton.getWidth());
            this._sprFkButton.paint(g);
            this._sprFkIcons.setFrame(4);
            this._sprFkIcons.setPosition(this._sprFkButton.getX() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)), this._sprFkButton.getY() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)));
            this._sprFkIcons.paint(g);
        } else if (this._iStatus == 2) {
            if (RMSObjects.game.isGameOver()) {
                this._sprFkButton.setFrame(0);
                this._sprFkButton.setPosition(this._rectItems[4].x + (this._sprFkButton.getWidth() >> 1) - (this._sprFkButton.getWidth() >> 1) + this._sprFkButton.getWidth(), this._rectItems[4].y + (this._sprFkButton.getHeight() >> 1) - (this._sprFkButton.getHeight() >> 1) + this._sprFkButton.getWidth());
                this._sprFkButton.paint(g);
                this._sprFkIcons.setFrame(2);
                this._sprFkIcons.setPosition(this._sprFkButton.getX() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)), this._sprFkButton.getY() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)));
                this._sprFkIcons.paint(g);
                this._sprFkButton.setFrame(0);
                this._sprFkButton.setPosition(this._rectItems[0].x + (this._sprFkButton.getWidth() >> 1) - (this._sprFkButton.getWidth() >> 1), this._rectItems[0].y + (this._sprFkButton.getHeight() >> 1) - (this._sprFkButton.getHeight() >> 1) + this._sprFkButton.getWidth());
                this._sprFkButton.paint(g);
                this._sprFkIcons.setFrame(1);
                this._sprFkIcons.setPosition(this._sprFkButton.getX() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)), this._sprFkButton.getY() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)));
                this._sprFkIcons.paint(g);
            } else if (RMSObjects.game.isLevelDone()) {
                this._sprFkButton.setFrame(0);
                this._sprFkButton.setPosition(this._rectItems[0].x + (this._sprFkButton.getWidth() >> 1) - (this._sprFkButton.getWidth() >> 1), this._rectItems[0].y + (this._sprFkButton.getHeight() >> 1) - (this._sprFkButton.getHeight() >> 1) + this._sprFkButton.getWidth());
                this._sprFkButton.paint(g);
                this._sprFkIcons.setFrame(1);
                this._sprFkIcons.setPosition(this._sprFkButton.getX() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)), this._sprFkButton.getY() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)));
                this._sprFkIcons.paint(g);
            }
        } else if (this._iStatus == 3) {
            this._sprFkButton.setFrame(0);
            this._sprFkButton.setPosition(this._rectItems[4].x + (this._sprFkButton.getWidth() >> 1) - (this._sprFkButton.getWidth() >> 1) + this._sprFkButton.getWidth(), this._rectItems[4].y + (this._sprFkButton.getHeight() >> 1) - (this._sprFkButton.getHeight() >> 1) + this._sprFkButton.getWidth());
            this._sprFkButton.paint(g);
            this._sprFkIcons.setFrame(9);
            this._sprFkIcons.setPosition(this._sprFkButton.getX() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)), this._sprFkButton.getY() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)));
            this._sprFkIcons.paint(g);
        } else if (this._iStatus == 1) {
            this._sprFkButton.setFrame(0);
            this._sprFkButton.setPosition(this._rectItems[4].x + (this._sprFkButton.getWidth() >> 1) - (this._sprFkButton.getWidth() >> 1) + this._sprFkButton.getWidth(), this._rectItems[4].y + (this._sprFkButton.getHeight() >> 1) - (this._sprFkButton.getHeight() >> 1) + this._sprFkButton.getWidth());
            this._sprFkButton.paint(g);
            this._sprFkIcons.setFrame(9);
            this._sprFkIcons.setPosition(this._sprFkButton.getX() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)), this._sprFkButton.getY() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)));
            this._sprFkIcons.paint(g);
        } else if (this._iStatus == 4) {
            this._sprFkButton.setFrame(0);
            this._sprFkButton.setPosition(this._rectItems[0].x + (this._sprFkButton.getWidth() >> 1) - (this._sprFkButton.getWidth() >> 1), this._rectItems[0].y + (this._sprFkButton.getHeight() >> 1) - (this._sprFkButton.getHeight() >> 1) + this._sprFkButton.getWidth());
            this._sprFkButton.paint(g);
            this._sprFkIcons.setFrame(1);
            this._sprFkIcons.setPosition(this._sprFkButton.getX() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)), this._sprFkButton.getY() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)));
            this._sprFkIcons.paint(g);
        } else if (this._iStatus == 5) {
            this._sprFkButton.setFrame(0);
            this._sprFkButton.setPosition(this._rectItems[0].x + (this._sprFkButton.getWidth() >> 1) - (this._sprFkButton.getWidth() >> 1), this._rectItems[0].y + (this._sprFkButton.getHeight() >> 1) - (this._sprFkButton.getHeight() >> 1) + this._sprFkButton.getWidth());
            this._sprFkButton.paint(g);
            this._sprFkIcons.setFrame(1);
            this._sprFkIcons.setPosition(this._sprFkButton.getX() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)), this._sprFkButton.getY() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)));
            this._sprFkIcons.paint(g);
        } else if (this._iStatus == 7) {
            this._sprFkButton.setFrame(0);
            this._sprFkButton.setPosition(this._rectItems[0].x + (this._sprFkButton.getWidth() >> 1) - (this._sprFkButton.getWidth() >> 1), this._rectItems[0].y + (this._sprFkButton.getHeight() >> 1) - (this._sprFkButton.getHeight() >> 1) + this._sprFkButton.getWidth());
            this._sprFkButton.paint(g);
            this._sprFkIcons.setFrame(1);
            this._sprFkIcons.setPosition(this._sprFkButton.getX() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)), this._sprFkButton.getY() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)));
            this._sprFkIcons.paint(g);
        } else if (this._iStatus == 6) {
            this._sprFkButton.setFrame(0);
            this._sprFkButton.setPosition(this._rectItems[4].x + (this._sprFkButton.getWidth() >> 1) - (this._sprFkButton.getWidth() >> 1) + this._sprFkButton.getWidth(), this._rectItems[4].y + (this._sprFkButton.getHeight() >> 1) - (this._sprFkButton.getHeight() >> 1) + this._sprFkButton.getWidth());
            this._sprFkButton.paint(g);
            this._sprFkIcons.setFrame(2);
            this._sprFkIcons.setPosition(this._sprFkButton.getX() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)), this._sprFkButton.getY() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)));
            this._sprFkIcons.paint(g);
            this._sprFkButton.setFrame(0);
            this._sprFkButton.setPosition(this._rectItems[0].x + (this._sprFkButton.getWidth() >> 1) - (this._sprFkButton.getWidth() >> 1), this._rectItems[0].y + (this._sprFkButton.getHeight() >> 1) - (this._sprFkButton.getHeight() >> 1) + this._sprFkButton.getWidth());
            this._sprFkButton.paint(g);
            this._sprFkIcons.setFrame(1);
            this._sprFkIcons.setPosition(this._sprFkButton.getX() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)), this._sprFkButton.getY() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)));
            this._sprFkIcons.paint(g);
        } else if (this._iStatus == 8) {
            this._sprFkButton.setFrame(0);
            this._sprFkButton.setPosition(this._rectItems[4].x + (this._sprFkButton.getWidth() >> 1) - (this._sprFkButton.getWidth() >> 1) + this._sprFkButton.getWidth(), this._rectItems[4].y + (this._sprFkButton.getHeight() >> 1) - (this._sprFkButton.getHeight() >> 1) + this._sprFkButton.getWidth());
            this._sprFkButton.paint(g);
            this._sprFkIcons.setFrame(2);
            this._sprFkIcons.setPosition(this._sprFkButton.getX() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)), this._sprFkButton.getY() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)));
            this._sprFkIcons.paint(g);
            this._sprFkButton.setFrame(0);
            this._sprFkButton.setPosition(this._rectItems[0].x + (this._sprFkButton.getWidth() >> 1) - (this._sprFkButton.getWidth() >> 1), this._rectItems[0].y + (this._sprFkButton.getHeight() >> 1) - (this._sprFkButton.getHeight() >> 1) + this._sprFkButton.getWidth());
            this._sprFkButton.paint(g);
            this._sprFkIcons.setFrame(1);
            this._sprFkIcons.setPosition(this._sprFkButton.getX() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)), this._sprFkButton.getY() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)));
            this._sprFkIcons.paint(g);
        }
    }

    private int getTopScore() {
        if (!this._bBonusPack) {
            Vector scores = RMSObjects.localScores.getScoresForGame(0);
            int scoresCount = 0;
            if (scores != null) {
                scoresCount = scores.size();
            }
            PowV2ScoreItem scoreItem = null;
            if (scoresCount > 0) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(0);
                return scoreItem.scoreValue;
            }
            return 0;
        }
        Vector scores = RMSObjects.localScoresBonus.getScoresForGame(0);
        int scoresCount = 0;
        if (scores != null) {
            scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (scoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            return scoreItem.scoreValue;
        }
        return 0;
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        switch (this._iStatus) {
            case 5: {
                if (!Keys.isFKLeftCode(keyCode)) break;
                this.startAnimation(true, 0);
                break;
            }
            case 8: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.startAnimation(true, 1);
                }
                if (!Keys.isFKLeftCode(keyCode)) break;
                this.startAnimation(true, 9);
                this.reset();
                break;
            }
            case 4: {
                if (!Keys.isFKLeftCode(keyCode)) break;
                if (MainCanvas.controlsTut == 0) {
                    this.startAnimation(true, 4);
                    ++MainCanvas.controlsTut;
                    break;
                }
                if (MainCanvas.controlsTut != 1) break;
                this.startAnimation(true, 5);
                break;
            }
            case 0: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.setGameMenuStatus();
                    break;
                }
                if (Keys.isFKLeftCode(keyCode)) {
                    RMSObjects.game.showHint();
                    break;
                }
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    RMSObjects.game.moveLeft();
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    RMSObjects.game.moveRight();
                    break;
                }
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    RMSObjects.game.moveUp();
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    RMSObjects.game.moveDown();
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                RMSObjects.game.DragOrDrop();
                break;
            }
            case 1: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                this.keyReleasedMenuGame(keyCode);
                break;
            }
            case 2: {
                this.keyReleasedResult(keyCode);
                break;
            }
            case 3: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55 || !Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
                this._iTextOffsetY = 0;
                this._bScrollUP = false;
                this._bScrollDOWN = true;
                this._iSelectedCompId = 1;
                this.reset();
                break;
            }
            case 6: {
                if (Keys.isFKLeftCode(keyCode)) {
                    if (!this._bBonusPack) {
                        Level.getLevel(this._iActualLevel);
                    } else {
                        Level.getBonusLevel(this._iActualLevel);
                    }
                    MainCanvas.moveCounter = 0;
                    if (this._iGameMode == 4 || this._iGameMode == 5) {
                        RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this._iActualLevel, this.lvl, Level._iGameColors);
                    } else {
                        RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this._iActualLevel, this.lvl, Level._iGameColors);
                    }
                    this.startAnimation(true, 0);
                    this.reset();
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
                this.reset();
            }
        }
        this.mainCanvas.repaint();
    }

    private void setGameMenuStatus() {
        int rmsConnectId = this.getRMSConnectIdByGameType(0);
        if (!RMSObjects.rmsConnects[rmsConnectId].isExist()) {
            RMSObjects.rmsConnects[rmsConnectId].create();
        }
        RMSObjects.rmsConnects[rmsConnectId].save();
        this.startAnimation(true, 1);
        this._iSelectedCompId = 5;
    }

    private void keyReleasedMenuGame(int keyCode) {
        switch (this._iSelectedCompId) {
            case 5: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    this._iSelectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    this._iSelectedCompId = 1;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 3;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 6);
                this.mainCanvas.repaint();
                break;
            }
            case 3: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    this._iSelectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    this._iSelectedCompId = 1;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                if (this.mainCanvas.getSoundManager().IsSoundOn()) {
                    this.mainCanvas.getSoundManager().SetSoundOn(false);
                    Settings.musicOn = false;
                    this.mainCanvas.getSoundManager().Stop();
                    break;
                }
                this.mainCanvas.getSoundManager().SetSoundOn(true);
                Settings.musicOn = true;
                this.mainCanvas.getSoundManager().Play(Sounds.SOUND_GAME, -1);
                break;
            }
            case 1: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    this._iSelectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    this._iSelectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 3;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 3);
                break;
            }
            case 6: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    this._iSelectedCompId = 1;
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    this._iSelectedCompId = 1;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 8);
            }
        }
        if (Keys.isFKRightCode(keyCode)) {
            this.startAnimation(true, 0);
            this.reset();
        }
    }

    private void keyReleasedResult(int keyCode) {
        if (RMSObjects.game.isGameOver()) {
            if (Keys.isFKRightCode(keyCode)) {
                this.reset();
                this.stars = "";
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
                if (this.mainCanvas.getSoundManager().IsSoundOn()) {
                    this.mainCanvas.getSoundManager().Stop();
                    this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
                }
            } else if (Keys.isFKLeftCode(keyCode)) {
                this.stars = "";
                this.reset();
                if (!this._bBonusPack) {
                    Level.getLevel(this._iActualLevel);
                } else {
                    Level.getBonusLevel(this._iActualLevel);
                }
                MainCanvas.moveCounter = 0;
                if (this._iGameMode == 4 || this._iGameMode == 5) {
                    this.startAnimation(true, 5);
                    RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this._iActualLevel, this.lvl, Level._iGameColors);
                } else {
                    this.startAnimation(true, 5);
                    if (!this._bBonusPack) {
                        Level.getLevel(this._iActualLevel);
                    } else {
                        Level.getBonusLevel(this._iActualLevel);
                    }
                    RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this._iActualLevel, this.lvl, Level._iGameColors);
                }
                this.mainCanvas.getSoundManager().Stop();
                if (this.mainCanvas.getSoundManager().IsSoundOn()) {
                    this.mainCanvas.getSoundManager().Play(Sounds.SOUND_GAME, -1);
                }
            }
        } else if (RMSObjects.game.isLevelDone()) {
            if (Keys.isFKLeftCode(keyCode)) {
                this.stars = "";
                this.reset();
                this.addScoreToTable();
                this.startAnimation(true, 5);
                if (!this._bBonusPack) {
                    if (MainCanvas.slcLvl < 59) {
                        if (MainCanvas.counterX < 3) {
                            ++MainCanvas.counterX;
                            ++MainCanvas.slcLvl;
                        } else {
                            if (MainCanvas.slcLvl == 19) {
                                ++MainCanvas.slcPack;
                                MainCanvas.counterY = 0;
                            } else if (MainCanvas.slcLvl == 39) {
                                MainCanvas.counterY = 0;
                                ++MainCanvas.slcPack;
                            } else {
                                ++MainCanvas.counterY;
                            }
                            MainCanvas.counterX = 0;
                            ++MainCanvas.slcLvl;
                        }
                    }
                } else if (MainCanvas.slcLvl < 19) {
                    if (MainCanvas.counterX < 3) {
                        ++MainCanvas.counterX;
                        ++MainCanvas.slcLvl;
                    } else {
                        MainCanvas.counterX = 0;
                        ++MainCanvas.counterY;
                        ++MainCanvas.slcLvl;
                    }
                }
                this.startAnimation(true, 9);
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                this.score = RMSObjects.game.getScore();
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (this._iStatus == 0 && this._rectGameArea.contains(x, y)) {
            Game.bhint = false;
            RMSObjects.game.pointerPressed(x, y);
            return;
        }
        block5: for (int i = 0; i < this._rectItems.length; ++i) {
            if (!this.existComponentInState(i, this._iStatus) || !this._rectItems[i].contains(x, y)) continue;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 0: {
                    if (this._iStatus != 1) {
                        Keys.keyPressed(-6);
                        continue block5;
                    }
                    Keys.keyPressed(-6);
                    continue block5;
                }
                case 4: {
                    if (this._iStatus == 3) {
                        this.startAnimation(true, 1);
                        this._iTextOffsetY = 0;
                        this._bScrollUP = false;
                        this._bScrollDOWN = true;
                        this.mainCanvas.repaint();
                        continue block5;
                    }
                    Keys.keyPressed(-7);
                    continue block5;
                }
                case 3: {
                    if (this.mainCanvas.getSoundManager().IsSoundOn()) {
                        this.mainCanvas.getSoundManager().SetSoundOn(false);
                        this.mainCanvas.getSoundManager().Stop();
                    } else {
                        this.mainCanvas.getSoundManager().SetSoundOn(true);
                        this.mainCanvas.getSoundManager().Play(Sounds.SOUND_GAME, -1);
                    }
                    this.mainCanvas.repaint();
                    continue block5;
                }
                default: {
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                }
            }
        }
    }

    private boolean existComponentInState(int i, int _iStatus) {
        if (_iStatus == 0) {
            if (i == 4) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (_iStatus == 8) {
            if (i == 4) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (_iStatus == 1) {
            if (i == 0) {
                return true;
            }
            if (i == 4) {
                return true;
            }
            if (i == 5) {
                return true;
            }
            if (i == 3) {
                return true;
            }
            if (i == 1) {
                return true;
            }
            if (i == 6) {
                return true;
            }
        } else if (_iStatus == 3) {
            if (i == 4) {
                return true;
            }
        } else if (_iStatus == 2) {
            if (i == 4) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (_iStatus == 6) {
            if (i == 4) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (_iStatus == 3 ? i == 4 : (_iStatus == 5 ? i == 0 : _iStatus == 4 && i == 0)) {
            return true;
        }
        return false;
    }

    public void pointerDragged(int x, int y) {
        if (this._iStatus == 0 && this._rectGameArea.contains(x, y)) {
            RMSObjects.game.pointerPressed(x, y);
            return;
        }
        if (this._iStatus == 3) {
            if (y > MainCanvas.HEIGHT / 2 && y < MainCanvas.HEIGHT - Resources.resSprs[0].getHeight()) {
                if (x >= this._rectDialog.x && x <= this._rectDialog.x + this._rectDialog.width) {
                    this.dragDown();
                }
            } else if (y < MainCanvas.HEIGHT / 2 && y > 0 + Resources.resSprs[0].getHeight() && x >= this._rectDialog.x && x <= this._rectDialog.x + this._rectDialog.width) {
                this.dragUp();
            }
        }
        if (!this._rectItems[this._iSelectedCompId].contains(x, y)) {
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyReleased(-6);
                    break;
                }
                case 4: {
                    if (this._iStatus == 3) {
                        this.startAnimation(true, 1);
                        this._iTextOffsetY = 0;
                        this._bScrollUP = false;
                        this._bScrollDOWN = true;
                        break;
                    }
                    Keys.keyReleased(-7);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                    if (this._iStatus != 1) break;
                    this.mainCanvas.repaint();
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this._iSelectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-6)) break;
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                break;
            }
            case 4: {
                if (this._iStatus == 3) {
                    this.startAnimation(true, 1);
                    this._iTextOffsetY = 0;
                    this._bScrollUP = false;
                    this._bScrollDOWN = true;
                    break;
                }
                if (!Keys.isKeyPressed(-7)) break;
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            default: {
                if (Keys.isKeyPressed(53)) {
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
                if (this._iStatus != 1) break;
                this._iSelectedCompId = 1;
                this.mainCanvas.repaint();
            }
        }
    }

    public void textMove() {
        this._bNeedRepaint = false;
        if (this._ptInstructions.getTextHeight() < this._rectText.height) {
            return;
        }
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this._iTextOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            } else {
                this._iTextOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            }
            if (this._iTextOffsetY < 0) {
                this._iTextOffsetY = 0;
                this._bScrollUP = false;
                this._bScrollDOWN = true;
            }
            this._bNeedRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = this._ptInstructions.getTextHeight() - this._rectText.height;
            if (Resources.sysFont) {
                this._iTextOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            } else {
                this._iTextOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            }
            if (this._iTextOffsetY > maxOffsetY) {
                this._iTextOffsetY = maxOffsetY;
                this._bScrollUP = true;
                this._bScrollDOWN = false;
            }
            this._bNeedRepaint = true;
        }
        if (this._bNeedRepaint) {
            this.mainCanvas.repaint();
        }
    }

    public void dragUp() {
        if (this._ptInstructions.getTextHeight() < this._rectText.height) {
            return;
        }
        if (Resources.sysFont) {
            this._iTextOffsetY -= Font.getDefaultFont().getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        } else {
            this._iTextOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        }
        if (this._iTextOffsetY < 0) {
            this._iTextOffsetY = 0;
            this._bScrollUP = false;
            this._bScrollDOWN = true;
        }
        this._bNeedRepaint = true;
        this.mainCanvas.repaint();
    }

    public void dragDown() {
        if (this._ptInstructions.getTextHeight() < this._rectText.height) {
            return;
        }
        int maxOffsetY = this._ptInstructions.getTextHeight() - this._rectGameArea.height;
        if (Resources.sysFont) {
            this._iTextOffsetY += Font.getDefaultFont().getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        } else {
            this._iTextOffsetY += Resources.resGFonts[0].getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        }
        if (this._iTextOffsetY > maxOffsetY) {
            this._iTextOffsetY = maxOffsetY;
            this._bScrollUP = true;
            this._bScrollDOWN = false;
        }
        this._bNeedRepaint = true;
        this.mainCanvas.repaint();
    }
}

