/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Level;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenGame;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenSelectLevel
implements IScreen {
    MainCanvas mainCanvas;
    long modeDelay;
    private static final int COMP_ID_BACK = 0;
    private static final int COMP_ID_ARR_UP = 1;
    private static final int COMP_ID_ARR_DOWN = 2;
    private static final int COMP_ID_ALLLEVELS = 3;
    private static final int TOTAL_COMP_IDS = 4;
    private Rectangle[] _rectItems = new Rectangle[4];
    private Rectangle[] _rectLevel = new Rectangle[16];
    private Rectangle _rSelectedLevel;
    private Rectangle _rectLvlStars;
    private Rectangle _rectLevelBody;
    private Rectangle rectDialog;
    private Rectangle rectSelector;
    int mode;
    private int _iNextModePack1 = 0;
    private int _iNextModePack2 = 1;
    private int _iNextModePack3 = 2;
    private int _iNextModePack4 = 3;
    private int _iNextModePack5 = 4;
    private int _iNextModeMenu = 5;
    private int _iNextModeGame = 6;
    private int _iSelectedCompId;
    private int _iGameMode;
    private Rectangle rectTop;
    private Rectangle rectDown;
    private Rectangle rectBody;
    private int dy = 0;
    private int _iSelectorDx = 0;
    private int _iSelectorDy = 0;
    private int _iCounterX = 0;
    private int _iCounterY = 0;
    private int scoresCount = 0;
    private int count = 0;
    private int x = 0;
    private int y = 0;
    private int interuption = 0;
    private int selectedPack = 0;
    private int selectdLevel = 0;
    private int levelNumber = 0;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private String[] levelStars = new String[80];
    private String[] levelnames = new String[80];
    private int _iOffsetLevelX = 0;
    private int _iOffsetLevelY = 0;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private boolean _bChangeSequence = false;
    private Image _imgBg;
    private Image _imgStar;
    private Sprite _sprArrow;
    private Sprite _sprFkButton;
    private Sprite _sprFkIcons;
    private Sprite _sprLevel;
    private Sprite _sprLevelSelector;
    private Sprite _sprLevelLock;
    private Sprite _sprLevelStar;
    private Sprite _sprTwister;
    private PreparedText _ptLevelNum;
    private PreparedText _prLevelStars;
    private int[] _animationSequence = new int[4];
    private AnimationComponent[] _animationComponents = new AnimationComponent[4];
    private boolean _bShitDevice = false;
    public boolean animatedMenu = false;
    private int cycle = 10;

    public ScreenSelectLevel(MainCanvas mC, int selectedLevel) {
        this.mainCanvas = mC;
        this._iCounterX = MainCanvas.slcLvl % 4;
        this._iCounterY = MainCanvas.counterY;
        this.selectedPack = MainCanvas.slcPack;
        this.selectdLevel = MainCanvas.slcLvl;
        System.out.println("selectdLevel: " + this.selectdLevel);
        MainCanvas.totalStars = 0;
        this.initDimensions();
    }

    public void beforeShow() {
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initFonts();
        this.prepareTxt();
        this.prepareLevelStars();
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.startAnimation(true, -1);
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2, 7});
        Resources.loadSprites(new int[]{22, 1, 0, 24, 7, 6, 9, 8});
        Resources.loadGFont(1);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2, 7});
        Resources.freeSprites(new int[]{22, 1, 0, 24, 7, 6, 9, 8});
        Resources.freeGFont(1);
    }

    private void initDimensions() {
        this._WIDTH = this.mainCanvas.getWidth();
        this._HEIGHT = this.mainCanvas.getHeight();
        if (this._WIDTH == 176 && this._HEIGHT == 208) {
            this._bShitDevice = true;
        }
        if (this._WIDTH == 176 && this._HEIGHT == 220) {
            this._bShitDevice = true;
        }
        this._bShitDevice = this._WIDTH == 208 && this._HEIGHT == 208;
    }

    private void initImages() {
        this._imgBg = Resources.resImgs[2];
        this._imgStar = Resources.resImgs[7];
    }

    private void initSprites() {
        this._sprArrow = Resources.resSprs[22];
        this._sprFkButton = Resources.resSprs[1];
        this._sprFkIcons = Resources.resSprs[0];
        this._sprLevel = Resources.resSprs[24];
        this._sprLevelSelector = Resources.resSprs[7];
        this._sprLevelLock = Resources.resSprs[6];
        this._sprLevelStar = Resources.resSprs[9];
        this._sprTwister = Resources.resSprs[8];
        this._sprFkIcons = Resources.resSprs[0];
    }

    private void initFonts() {
        this._ptLevelNum = new PreparedText(Resources.resGFonts[1]);
        this._prLevelStars = new PreparedText(Resources.resGFonts[1]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0] = 0;
        this._animationSequence[1] = 1;
        this._animationSequence[2] = 2;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this._rectLevelBody, this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectDown, this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this._rectItems[0], this._WIDTH, this._HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this.rectTop, this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(2);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(2);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(3);
        this._animationComponents[2].startHideAnimation(1);
        this._animationComponents[3].startHideAnimation(2);
    }

    private void prepareTxt() {
        this._ptLevelNum.prepareText("1", this._sprLevel.getWidth());
    }

    private void freeGraphics() {
        this._imgBg = null;
        this._sprArrow = null;
        this._sprFkButton = null;
        this._sprFkIcons = null;
        this._sprLevel = null;
        this._sprLevelSelector = null;
        this._sprLevelLock = null;
        this._sprLevelStar = null;
        this._sprFkIcons = null;
        this._sprTwister = null;
        this._ptLevelNum = null;
        this._prLevelStars = null;
    }

    private void prepareLevelStars() {
        Vector scores;
        for (int i = 0; i < 80; ++i) {
            this.levelStars[i] = null;
            this.levelnames[i] = null;
        }
        RMSObjects.createRMSConnect(0);
        if (!RMSObjects.rmsConnects[0].load()) {
            RMSObjects.rmsConnects[0].create();
        }
        if ((scores = RMSObjects.localScores.getScoresForGame(0)) != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        for (int i = 0; i < 80; ++i) {
            if (i < this.scoresCount) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(i);
                this.levelStars[i] = Integer.toString(scoreItem.scoreValue);
                MainCanvas.totalStars += scoreItem.scoreValue;
                ++this.count;
                continue;
            }
            this.levelStars[i] = null;
        }
    }

    public void beforeInteruption() {
        this.mainCanvas.getSoundManager().Stop();
    }

    public void afterInteruption() {
        this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
    }

    private void calculatePositions() {
        int fkWidth = this._sprFkButton.getWidth();
        int sprArrwUpDownWidth = this._sprArrow.getWidth();
        int sprArrwUpDownHeigth = this._sprArrow.getHeight();
        int marginLeft = fkWidth;
        this.rectDialog = new Rectangle(marginLeft, 0, MainCanvas.WIDTH - (marginLeft << 1), this.mainCanvas.getHeight());
        this.rectTop = new Rectangle(0, 0, this.mainCanvas.getWidth(), this._sprFkButton.getHeight());
        this.rectDown = new Rectangle(0, this.mainCanvas.getHeight() - this._sprFkButton.getHeight(), this.mainCanvas.getWidth(), this._sprFkButton.getHeight());
        this.rectBody = new Rectangle(this._sprLevel.getWidth() / 2, this.rectTop.height, this.mainCanvas.getWidth() - this._sprLevel.getWidth() / 2, this.mainCanvas.getHeight() - this.rectTop.height - this.rectDown.height);
        this._rectItems[0] = new Rectangle(MainCanvas.WIDTH - (this._sprFkButton.getWidth() << 1), MainCanvas.HEIGHT - (this._sprFkButton.getHeight() << 1), this._sprFkButton.getWidth() << 1, this._sprFkButton.getHeight() << 1);
        this._rectItems[1] = new Rectangle(this.rectTop.getCenterX() - sprArrwUpDownWidth / 2, this.rectTop.getCenterY() - sprArrwUpDownHeigth / 2, sprArrwUpDownWidth, sprArrwUpDownHeigth);
        this._rectItems[2] = new Rectangle(this.rectDown.getCenterX() - sprArrwUpDownWidth / 2, this.rectDown.getCenterY() - sprArrwUpDownHeigth / 2, sprArrwUpDownWidth, sprArrwUpDownHeigth);
        this._rectItems[3] = new Rectangle(0, sprArrwUpDownHeigth, this.mainCanvas.getWidth(), this.mainCanvas.getHeight() - this.rectTop.height - this.rectDown.height);
        this.dy = this._sprFkButton.getHeight();
        this._iSelectorDx = this._sprLevel.getWidth();
        this._iSelectorDy = this.dy;
        int _iOffsetX = this._WIDTH % 4 == 0 ? 0 : this._WIDTH % 4 >> 1;
        int _iOffsetTop = this._sprArrow.getHeight();
        int _iOffsetBottom = this._sprArrow.getHeight();
        int _iOffsetTmpY = this._HEIGHT - _iOffsetTop - _iOffsetBottom;
        int _iOffsetY = _iOffsetTmpY % 5 == 0 ? _iOffsetTop : _iOffsetTop + _iOffsetTmpY % 5;
        this._rectLevelBody = new Rectangle(_iOffsetX, _iOffsetY, this._WIDTH - (_iOffsetX << 1), this._HEIGHT - _iOffsetTop - _iOffsetBottom);
        this._iOffsetLevelX = (this._rectLevelBody.width - this._sprLevel.getWidth() * 4) / 5;
        this._iOffsetLevelY = (this._rectLevelBody.height - this._sprLevel.getHeight() * 4) / 5;
        if (this._iOffsetLevelY < this._ptLevelNum.getTextHeight()) {
            this._iOffsetLevelY = this._ptLevelNum.getTextHeight();
        }
    }

    public void update(long lastRunLenght) {
        if (MainCanvas.interuption_nokia == 0) {
            if (this.cycle > 0) {
                --this.cycle;
            } else if (MainCanvas.nokia == 1) {
                MainCanvas.nokia = 0;
                this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
                this.cycle = 10;
            }
        }
        this.animationController();
        this.animationComponentsUpdate();
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == -1 ? this._iSequenceShow : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                this.startNextScreen(this._iNextMode);
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startNextScreen(int _nextMode) {
        if (_nextMode == this._iNextModeGame) {
            System.out.println("$startNextScreen : level : " + this.selectdLevel);
            MainCanvas.slcLvl = this.selectdLevel;
            ScreenGame sg = new ScreenGame(this.mainCanvas, this._iGameMode, this.selectdLevel, false);
            this.mainCanvas.changeLastActiveScreen(sg);
            this.mainCanvas.getSoundManager().Stop();
            if (this.mainCanvas.getSoundManager().IsSoundOn()) {
                this.mainCanvas.getSoundManager().Play(Sounds.SOUND_GAME, -1);
            }
        } else if (_nextMode == this._iNextModeMenu) {
            this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
        }
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintArrows(g);
        this.paintLvl(g);
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        g.drawImage(this._imgBg, 0, 0, 20);
    }

    private void paintLvl(Graphics g) {
        int _iTmpLvlIdx = 0;
        int _iTmpLvlStr = 0;
        int _iTmpTwisterOffsetY = (this._sprLevel.getHeight() >> 1) - (this._sprTwister.getHeight() >> 1);
        String _sTmpNumber = "";
        String _sTmpStr = "";
        if (this.selectedPack == this._iNextModePack1) {
            this.levelNumber = 0;
        } else if (this.selectedPack == this._iNextModePack2) {
            this.levelNumber = 16;
        } else if (this.selectedPack == this._iNextModePack3) {
            this.levelNumber = 32;
        } else if (this.selectedPack == this._iNextModePack4) {
            this.levelNumber = 48;
        } else if (this.selectedPack == this._iNextModePack5) {
            this.levelNumber = 64;
        }
        for (int y = 0; y < 4; ++y) {
            this.paintTwister(g, this._rectLevelBody.y + (y * this._sprLevel.getHeight() + y * this._iOffsetLevelY) + _iTmpTwisterOffsetY);
            for (int x = 0; x < 4; ++x) {
                _sTmpStr = "";
                this._sprLevel.setPosition(this._rectLevelBody.x + (x * this._sprLevel.getWidth() + (x == 0 ? this._iOffsetLevelX : (x + 1) * this._iOffsetLevelX)), this._rectLevelBody.y + (y * this._sprLevel.getHeight() + y * this._iOffsetLevelY));
                if (this.selectdLevel == _iTmpLvlIdx + this.levelNumber) {
                    this._sprLevelSelector.setPosition(this._sprLevel.getX(), this._sprLevel.getY());
                } else {
                    this._sprLevel.setFrame(1);
                }
                if (_iTmpLvlIdx < this.count + 1) {
                    this._sprLevel.setFrame(0);
                } else {
                    this._sprLevel.setFrame(1);
                }
                this._sprLevel.paint(g);
                this._rectLevel[_iTmpLvlIdx] = this._rSelectedLevel = new Rectangle(this._sprLevel.getX(), this._sprLevel.getY(), this._sprLevel.getWidth(), this._sprLevel.getHeight());
                if (_iTmpLvlIdx + this.levelNumber + 1 <= this.count + 1) {
                    _sTmpNumber = this.levelNumber < 10 ? "" + (_iTmpLvlIdx + this.levelNumber + 1) + "" : "" + (_iTmpLvlIdx + this.levelNumber + 1);
                    try {
                        _iTmpLvlStr = this.levelStars[_iTmpLvlIdx] != null ? Integer.parseInt(this.levelStars[_iTmpLvlIdx]) : 0;
                    }
                    catch (Exception r) {
                        // empty catch block
                    }
                    this._ptLevelNum.prepareText(_sTmpNumber, this._sprLevel.getWidth());
                    this._prLevelStars.prepareText(_sTmpStr, this._sprLevel.getWidth() + (this._sprLevel.getWidth() >> 2));
                    this._rectLvlStars = new Rectangle(this._sprLevel.getX(), this._rSelectedLevel.getBottom(), this._sprLevel.getWidth(), this._prLevelStars.getTextHeight());
                    this._ptLevelNum.drawText(g, this._rSelectedLevel, 0, 3);
                } else {
                    this._sprLevel.setFrame(0);
                    this._sprLevelLock.setPosition(this._sprLevel.getX(), this._sprLevel.getY());
                    this._sprLevelLock.paint(g);
                    this._sprLevel.setFrame(1);
                    this._sprLevel.paint(g);
                    this._sprLevelLock.setPosition(this._sprLevel.getX(), this._sprLevel.getY());
                    this._sprLevelLock.paint(g);
                }
                int _iPosX = this._rectLevel[_iTmpLvlIdx].getCenterX() - (this._sprLevelStar.getWidth() >> 1);
                int _iPosY = this._sprLevel.getY() + this._sprLevel.getHeight();
                if (_iTmpLvlStr == 1) {
                    this._sprLevelStar.setFrame(0);
                    this._sprLevelStar.setPosition(_iPosX - this._sprLevelStar.getWidth(), _iPosY - (this._sprLevelStar.getHeight() >> 3));
                    this._sprLevelStar.paint(g);
                    this._sprLevelStar.setFrame(1);
                    this._sprLevelStar.setPosition(_iPosX, _iPosY + (this._sprLevelStar.getHeight() >> 3));
                    this._sprLevelStar.paint(g);
                    this._sprLevelStar.setFrame(1);
                    this._sprLevelStar.setPosition(_iPosX + this._sprLevelStar.getWidth(), _iPosY - (this._sprLevelStar.getHeight() >> 3));
                    this._sprLevelStar.paint(g);
                } else if (_iTmpLvlStr == 2) {
                    this._sprLevelStar.setFrame(0);
                    this._sprLevelStar.setPosition(_iPosX - this._sprLevelStar.getWidth(), _iPosY - (this._sprLevelStar.getHeight() >> 3));
                    this._sprLevelStar.paint(g);
                    this._sprLevelStar.setFrame(0);
                    this._sprLevelStar.setPosition(_iPosX, _iPosY + (this._sprLevelStar.getHeight() >> 3));
                    this._sprLevelStar.paint(g);
                    this._sprLevelStar.setFrame(1);
                    this._sprLevelStar.setPosition(_iPosX + this._sprLevelStar.getWidth(), _iPosY - (this._sprLevelStar.getHeight() >> 3));
                    this._sprLevelStar.paint(g);
                } else if (_iTmpLvlStr == 3) {
                    this._sprLevelStar.setFrame(0);
                    this._sprLevelStar.setPosition(_iPosX - this._sprLevelStar.getWidth(), _iPosY - (this._sprLevelStar.getHeight() >> 3));
                    this._sprLevelStar.paint(g);
                    this._sprLevelStar.setFrame(0);
                    this._sprLevelStar.setPosition(_iPosX, _iPosY + (this._sprLevelStar.getHeight() >> 3));
                    this._sprLevelStar.paint(g);
                    this._sprLevelStar.setFrame(0);
                    this._sprLevelStar.setPosition(_iPosX + this._sprLevelStar.getWidth(), _iPosY - (this._sprLevelStar.getHeight() >> 3));
                    this._sprLevelStar.paint(g);
                } else {
                    this._sprLevelStar.setFrame(1);
                    this._sprLevelStar.setPosition(_iPosX - this._sprLevelStar.getWidth(), _iPosY - (this._sprLevelStar.getHeight() >> 3));
                    this._sprLevelStar.paint(g);
                    this._sprLevelStar.setFrame(1);
                    this._sprLevelStar.setPosition(_iPosX, _iPosY + (this._sprLevelStar.getHeight() >> 3));
                    this._sprLevelStar.paint(g);
                    this._sprLevelStar.setFrame(1);
                    this._sprLevelStar.setPosition(_iPosX + this._sprLevelStar.getWidth(), _iPosY - (this._sprLevelStar.getHeight() >> 3));
                    this._sprLevelStar.paint(g);
                }
                if (this.selectdLevel == _iTmpLvlIdx + this.levelNumber) {
                    if (_iTmpLvlIdx + this.levelNumber + 1 <= this.count + 1) {
                        this._sprLevelSelector.setFrame(1);
                        this._sprLevelSelector.setPosition(this._sprLevel.getX() + ((this._sprLevel.getWidth() >> 1) - (this._sprLevelSelector.getWidth() >> 1)), this._sprLevel.getY() + ((this._sprLevel.getHeight() >> 1) - (this._sprLevelSelector.getHeight() >> 1)));
                        this._sprLevelSelector.paint(g);
                    } else {
                        this._sprLevelSelector.setFrame(0);
                        this._sprLevelSelector.setPosition(this._sprLevel.getX() + ((this._sprLevel.getWidth() >> 1) - (this._sprLevelSelector.getWidth() >> 1)), this._sprLevel.getY() + ((this._sprLevel.getHeight() >> 1) - (this._sprLevelSelector.getHeight() >> 1)));
                        this._sprLevelSelector.paint(g);
                    }
                }
                ++_iTmpLvlIdx;
            }
        }
    }

    private void paintTwister(Graphics g, int _iPosY) {
        int _iWidth = this._WIDTH % this._sprTwister.getWidth() == 0 ? this._WIDTH : this._WIDTH - this._WIDTH % this._sprTwister.getWidth();
        int _iTotalPieces = _iWidth / this._sprTwister.getWidth();
        int _iOffsetX = this._WIDTH - _iWidth >> 1;
        for (int _iIdx = 0; _iIdx < _iTotalPieces; ++_iIdx) {
            if (_iIdx == 0) {
                this._sprTwister.setFrame(0);
            } else if (_iIdx == _iTotalPieces - 1) {
                this._sprTwister.setFrame(2);
            } else {
                this._sprTwister.setFrame(1);
            }
            this._sprTwister.setPosition(_iOffsetX + _iIdx * this._sprTwister.getWidth(), _iPosY);
            this._sprTwister.paint(g);
        }
    }

    private void paintArrows(Graphics g) {
        if (this.selectedPack != 0) {
            this._sprArrow.setTransform(3);
            this._sprArrow.setPosition(this.rectTop.getCenterX() - (this._sprFkButton.getWidth() >> 1), this.rectTop.getCenterY() - (this._sprFkButton.getHeight() >> 1));
            this._sprArrow.paint(g);
        }
        if (this.selectedPack != 4) {
            this._sprArrow.setTransform(0);
            this._sprArrow.setPosition(this.rectDown.getCenterX() - (this._sprFkButton.getWidth() >> 1), this.rectDown.getCenterY() - (this._sprFkButton.getHeight() >> 1));
            this._sprArrow.paint(g);
        }
    }

    private void paintFK(Graphics g) {
        this._sprFkIcons.setFrame(9);
        this._sprFkIcons.setTransform(0);
        this._sprFkButton.setPosition(this._rectItems[0].x + (this._sprFkButton.getWidth() >> 1) - (this._sprFkButton.getWidth() >> 1) + this._sprFkButton.getWidth(), this._rectItems[0].y + (this._sprFkButton.getHeight() >> 1) - (this._sprFkButton.getHeight() >> 1) + this._sprFkButton.getWidth());
        this._sprFkIcons.setPosition(this._sprFkButton.getX() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)), this._sprFkButton.getY() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)));
        this._sprFkButton.paint(g);
        this._sprFkIcons.paint(g);
    }

    public void keyPressed(int keyCode) {
        if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) {
            // empty if block
        }
    }

    public void keyReleased(int keyCode) {
        if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55 && !Keys.isFKLeftCode(keyCode)) {
            if (Keys.isFKRightCode(keyCode)) {
                this.startAnimation(true, this._iNextModeMenu);
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                if (this.selectdLevel <= this.count) {
                    MainCanvas.counterX = this._iCounterX;
                    MainCanvas.counterY = this._iCounterY;
                    Level.getLevel(this.selectdLevel);
                    this._iGameMode = Level._iGameMode;
                    MainCanvas.slcLvl = this.selectdLevel;
                    this.startAnimation(true, this._iNextModeGame);
                }
                if (this.count == 2 && this.selectdLevel == 0) {
                    Level.getLevel(this.selectdLevel);
                    this._iGameMode = Level._iGameMode;
                    MainCanvas.slcLvl = this.selectdLevel;
                    this.startAnimation(true, this._iNextModeGame);
                }
            } else if (Keys.isActionGeneratedByKey(3, keyCode)) {
                System.out.println("_iCounterX: " + this._iCounterX);
                if (this._iCounterX > 0) {
                    --this._iCounterX;
                    --MainCanvas.counterX;
                    --this.selectdLevel;
                }
            } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
                if (this._iCounterX < 3) {
                    ++this._iCounterX;
                    ++this.selectdLevel;
                    ++MainCanvas.counterX;
                }
            } else if (Keys.isActionGeneratedByKey(1, keyCode)) {
                if (this._iCounterY > 0) {
                    --this._iCounterY;
                    --MainCanvas.counterY;
                    this.selectdLevel -= 4;
                } else if (this.selectedPack > 0) {
                    this._iCounterY = 0;
                    MainCanvas.counterY = 0;
                    --this.selectedPack;
                    this.selectdLevel -= 16;
                }
            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                if (this._iCounterY < 3) {
                    ++this._iCounterY;
                    ++MainCanvas.counterY;
                    this.selectdLevel += 4;
                } else if (this.selectedPack < 4) {
                    this._iCounterY = 0;
                    MainCanvas.counterY = 0;
                    ++this.selectedPack;
                    ++MainCanvas.slcPack;
                    this.selectdLevel += 4;
                }
            }
        }
        System.out.println("selectdLevel: " + this.selectdLevel);
        this.mainCanvas.repaint();
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this._rectItems.length; ++i) {
            if (!this._rectItems[i].contains(x, y)) continue;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 1: {
                    Keys.keyPressed(50);
                    Keys.resetAllPressedKeysAndActions();
                    break;
                }
                case 2: {
                    Keys.keyPressed(56);
                    Keys.resetAllPressedKeysAndActions();
                    break;
                }
                case 0: {
                    Keys.keyPressed(-7);
                    break;
                }
                case 3: {
                    break;
                }
            }
            return;
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this._rectItems[this._iSelectedCompId].contains(x, y)) {
            switch (this._iSelectedCompId) {
                case 1: {
                    Keys.keyReleased(49);
                    break;
                }
                case 2: {
                    Keys.keyReleased(49);
                    break;
                }
                case 0: {
                    Keys.keyReleased(-7);
                    break;
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this._iSelectedCompId) {
            case 1: {
                if (this.selectedPack > 0) {
                    this._iCounterX = 0;
                    this._iCounterY = 0;
                    --this.selectedPack;
                    --MainCanvas.slcPack;
                    this.selectdLevel -= 20;
                }
                this.keyReleased(49);
                this.mainCanvas.repaint();
                break;
            }
            case 2: {
                if (this.selectedPack < 4) {
                    this._iCounterX = 0;
                    this._iCounterY = 0;
                    ++this.selectedPack;
                    ++MainCanvas.slcPack;
                    this.selectdLevel += 4;
                }
                this.keyReleased(49);
                this.mainCanvas.repaint();
                break;
            }
            case 0: {
                if (!Keys.isKeyPressed(-7)) break;
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            case 3: {
                for (int i = 0; i < this._rectLevel.length; ++i) {
                    if (this._rectLevel[i] == null || !this._rectLevel[i].contains(x, y)) continue;
                    System.out.println("containt: " + i);
                    if (i + this.selectedPack * 20 > this.count) continue;
                    Level.getLevel(i + this.selectedPack * 20);
                    this._iGameMode = Level._iGameMode;
                    if (i + this.selectedPack * 20 <= 19) {
                        MainCanvas.slcPack = 0;
                    } else if (i + this.selectedPack * 20 <= 39) {
                        MainCanvas.slcPack = 1;
                    }
                    this.selectdLevel = i + this.selectedPack * 20;
                    this.startAnimation(true, this._iNextModeGame);
                }
                this.mainCanvas.repaint();
                break;
            }
            default: {
                this.keyReleased(5);
            }
        }
    }
}

