/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenInstructions
implements IScreen {
    private MainCanvas _mainCanvas;
    private static final int COMP_ID_BACK = 0;
    private static final int COMP_ID_ARR_UP = 1;
    private static final int COMP_ID_ARR_DOWN = 2;
    private static final int TOTAL_COMP_IDS = 3;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iInteruption = 0;
    private int _iSelectedCompId;
    private int _iTextOffsetY;
    private int _iCycle = 10;
    private int _iFinalHeight;
    private int _iTotalRowTiles = 0;
    private int _iTotalColTiles = 0;
    private int _iOffsetX;
    private int _iOffsetXDefault = 5;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private int[] _animationSequence = new int[6];
    private boolean _bChangeSequence = false;
    private boolean _bNeedRepaint;
    private boolean _bScrollUP = false;
    private boolean _bScrollDOWN = true;
    private Rectangle[] _rectItems = new Rectangle[3];
    private Rectangle _rectDialog;
    private Rectangle _rectText;
    private Rectangle _rectTop;
    private Image _imgBg;
    private Sprite _sprArrow;
    private Sprite _sprFkIcons;
    private Sprite _sprFkButton;
    private Sprite _sprWindows;
    private PreparedText _ptTitle;
    private PreparedText _ptInstructions;
    private AnimationComponent[] _animationComponents = new AnimationComponent[6];
    int a;

    public ScreenInstructions(MainCanvas mC) {
        this._mainCanvas = mC;
        this.initDimensions();
    }

    public void beforeShow() {
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initFonts();
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.prepareTxt();
        this._iTextOffsetY = 0;
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2});
        Resources.loadSprites(new int[]{0, 10, 22, 1});
        Resources.loadGFont(0);
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2});
        Resources.freeSprites(new int[]{0, 10, 22, 1});
        Resources.freeGFont(0);
    }

    private void initDimensions() {
        this._WIDTH = this._mainCanvas.getWidth();
        this._HEIGHT = this._mainCanvas.getHeight();
    }

    private void initImages() {
        this._imgBg = Resources.resImgs[2];
    }

    private void initSprites() {
        this._sprArrow = Resources.resSprs[22];
        this._sprFkButton = Resources.resSprs[1];
        this._sprFkIcons = Resources.resSprs[0];
        this._sprWindows = Resources.resSprs[10];
    }

    private void initFonts() {
        this._ptTitle = new PreparedText(Resources.resGFonts[0]);
        this._ptInstructions = new PreparedText(Resources.resGFonts[0]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0] = 0;
        this._animationSequence[1] = 1;
        this._animationSequence[2] = 2;
        this._animationSequence[3] = 3;
        this._animationSequence[4] = 4;
        this._animationSequence[5] = 5;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this._mainCanvas, this._rectTop, this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this._mainCanvas, this._rectDialog, this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this._mainCanvas, this._rectText, this._WIDTH, this._HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this._mainCanvas, this._rectItems[2], this._WIDTH, this._HEIGHT);
        this._animationComponents[4] = new AnimationComponent(this._mainCanvas, this._rectItems[1], this._WIDTH, this._HEIGHT);
        this._animationComponents[5] = new AnimationComponent(this._mainCanvas, this._rectItems[0], this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(3);
        this._animationComponents[3].startShowAnimation(3);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5].startShowAnimation(1);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(3);
        this._animationComponents[3].startShowAnimation(3);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5].startShowAnimation(1);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(3);
        this._animationComponents[2].startHideAnimation(3);
        this._animationComponents[3].startHideAnimation(3);
        this._animationComponents[4].startHideAnimation(3);
        this._animationComponents[5].startHideAnimation(1);
    }

    private void prepareTxt() {
        String _sTmpControls = Resources.resTexts[0].getHashedString(16);
        this._ptInstructions.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + _sTmpControls + "\n\n", this._rectText.width);
        this._ptInstructions.setLineHeightCorrection(-2);
        this._ptTitle.prepareText(Resources.resTexts[0].getHashedString(22), this._rectTop.width);
    }

    private void freeGraphics() {
        this._imgBg = null;
        this._sprArrow = null;
        this._sprFkButton = null;
        this._sprFkIcons = null;
        this._sprWindows = null;
        this._ptTitle = null;
        this._ptInstructions = null;
    }

    public void beforeInteruption() {
        this._mainCanvas.getSoundManager().Stop();
        this._iInteruption = 1;
    }

    public void afterInteruption() {
        if (this._iInteruption == 0 && this._mainCanvas.getSoundManager().IsSoundOn()) {
            this._mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        }
    }

    private void calculatePositions() {
        this._rectTop = new Rectangle(this._iOffsetXDefault, this._sprFkIcons.getHeight() - this._sprFkIcons.getHeight(), this._WIDTH - (this._iOffsetXDefault << 1), this._sprFkIcons.getHeight());
        int _windowWidth = this._WIDTH >> 1;
        int _offsetX = _windowWidth % this._sprWindows.getWidth() > 0 ? _windowWidth % this._sprWindows.getWidth() : this._sprWindows.getWidth();
        int _offsetTopY = this._sprFkButton.getHeight();
        int _offsetBottomY = this._sprFkButton.getHeight();
        int _panelHeight = this._HEIGHT - _offsetTopY - _offsetBottomY;
        this._iOffsetX = _offsetX;
        this._iFinalHeight = _panelHeight % this._sprWindows.getWidth() == 0 ? _panelHeight : _panelHeight - _panelHeight % this._sprWindows.getWidth();
        this._rectDialog = new Rectangle(_offsetX, _offsetTopY, this._WIDTH - (_offsetX << 1), this._iFinalHeight);
        this._rectText = new Rectangle(_offsetX + (this._sprFkIcons.getWidth() >> 1), _offsetTopY + this._sprFkIcons.getHeight(), this._WIDTH - (_offsetX << 1) - this._sprFkIcons.getWidth(), this._iFinalHeight - (this._sprFkIcons.getHeight() << 1));
        this._rectItems[1] = new Rectangle(this._rectDialog.getCenterX() - (this._sprArrow.getWidth() >> 1), this._rectDialog.y - this._sprArrow.getHeight(), this._sprArrow.getWidth(), this._sprFkIcons.getHeight());
        this._rectItems[2] = new Rectangle(this._rectDialog.getCenterX() - (this._sprArrow.getWidth() >> 1), this._rectDialog.y + this._rectDialog.height + (this._sprArrow.getHeight() >> 2), this._sprArrow.getWidth(), this._sprArrow.getHeight());
        this._rectItems[0] = new Rectangle(MainCanvas.WIDTH - (this._sprFkButton.getWidth() << 1), MainCanvas.HEIGHT - (this._sprFkButton.getHeight() << 1), this._sprFkButton.getWidth() << 1, this._sprFkButton.getHeight() << 1);
        this.calculateWindowTiles();
    }

    private void calculateWindowTiles() {
        this._iTotalColTiles = this._rectDialog.width / this._sprWindows.getWidth();
        this._iTotalRowTiles = this._rectDialog.height / this._sprWindows.getWidth();
    }

    public void update(long lastRunLenght) {
        this.updateSoundInterupt();
        if (Keys.isKeyPressed(-7)) {
            this._bScrollDOWN = false;
            this._bScrollUP = false;
            this._mainCanvas.repaint();
        }
        this._bNeedRepaint = false;
        this.textMove();
        if (this._bNeedRepaint) {
            this._mainCanvas.repaint();
        }
        this.animationController();
        this.animationComponentsUpdate();
    }

    private void updateSoundInterupt() {
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == -1 ? this._iSequenceShow : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this._mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                this.startNextScreen(this._iNextMode);
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startNextScreen(int _nextMode) {
        this._mainCanvas.changeLastActiveScreen(new ScreenMenu(this._mainCanvas, 1));
    }

    private void textMove() {
        if (this._ptInstructions.getTextHeight() < this._rectText.height) {
            return;
        }
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this._iTextOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            } else {
                this._iTextOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            }
            if (this._iTextOffsetY < 0) {
                this._iTextOffsetY = 0;
                this._bScrollUP = false;
                this._bScrollDOWN = true;
            }
            this._bNeedRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = this._ptInstructions.getTextHeight() - this._rectText.height;
            if (Resources.sysFont) {
                this._iTextOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            } else {
                this._iTextOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            }
            if (this._iTextOffsetY > maxOffsetY) {
                this._iTextOffsetY = maxOffsetY;
                this._bScrollUP = true;
                this._bScrollDOWN = false;
            }
            this._bNeedRepaint = true;
        }
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintBody(g);
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        g.drawImage(this._imgBg, 0, 0, 20);
    }

    private void paintBody(Graphics g) {
        this.paintWindow(g);
        this.paintInstructions(g);
        this.paintArrows(g);
    }

    private void paintTitle(Graphics g) {
        this._ptTitle.drawText(g, this._rectTop, this._ptTitle.getTextHeight() >> 2, 3);
    }

    private void paintWindow(Graphics g) {
        int _actualTileX = 0;
        int _actualTileY = 0;
        for (int x = this._rectDialog.x; x < this._rectDialog.x + this._rectDialog.width; x += this._sprWindows.getWidth()) {
            for (int y = this._rectDialog.y; y < this._rectDialog.y + this._rectDialog.height; y += this._sprWindows.getWidth()) {
                this._sprWindows.setFrame(this.getWindowTileSprite(_actualTileX, _actualTileY));
                this._sprWindows.setPosition(x, y);
                this._sprWindows.paint(g);
                ++_actualTileY;
            }
            _actualTileY = 0;
            ++_actualTileX;
        }
    }

    private void paintInstructions(Graphics g) {
        this._ptInstructions.drawText(g, this._rectText, this._iTextOffsetY, 20);
    }

    private void paintFK(Graphics g) {
        this._sprFkIcons.setFrame(9);
        this._sprFkIcons.setTransform(0);
        this._sprFkButton.setPosition(this._rectItems[0].x + (this._sprFkButton.getWidth() >> 1) - (this._sprFkButton.getWidth() >> 1) + this._sprFkButton.getWidth(), this._rectItems[0].y + (this._sprFkButton.getHeight() >> 1) - (this._sprFkButton.getHeight() >> 1) + this._sprFkButton.getWidth());
        this._sprFkIcons.setPosition(this._sprFkButton.getX() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)), this._sprFkButton.getY() + ((this._sprFkButton.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1)));
        this._sprFkButton.paint(g);
        this._sprFkIcons.paint(g);
    }

    private int getWindowTileSprite(int _x, int _y) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < this._iTotalColTiles - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == this._iTotalColTiles - 1) {
            return 2;
        }
        if (_y == this._iTotalRowTiles - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < this._iTotalRowTiles - 1 && _y > 0) {
            return 3;
        }
        if (_x == this._iTotalColTiles - 1 && _y < this._iTotalRowTiles - 1 && _y > 0) {
            return 5;
        }
        if (_y == this._iTotalRowTiles - 1 && _x < this._iTotalColTiles - 1 && _x > 0) {
            return 7;
        }
        if (_y == this._iTotalRowTiles - 1 && _x == this._iTotalColTiles - 1) {
            return 8;
        }
        return 4;
    }

    private void paintArrows(Graphics g) {
        if (this._ptInstructions.getTextHeight() >= this._rectText.height) {
            if (this._bScrollUP) {
                this._sprArrow.setTransform(3);
                this._sprArrow.setPosition(this._rectItems[1].x, this._rectItems[1].y);
                this._sprArrow.paint(g);
            }
            if (this._bScrollDOWN) {
                this._sprArrow.setTransform(0);
                this._sprArrow.setPosition(this._rectItems[2].x, this._rectItems[2].y);
                this._sprArrow.paint(g);
            }
        }
    }

    public void keyPressed(int keyCode) {
        if (this._iInteruption == 1) {
            this._iInteruption = 0;
            this.afterInteruption();
        }
        if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) {
            // empty if block
        }
        this._mainCanvas.repaint();
    }

    public void keyReleased(int keyCode) {
        this.a = keyCode;
        if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55 && Keys.isFKRightCode(keyCode)) {
            this.startAnimation(true, 0);
            this._mainCanvas.repaint();
        }
    }

    public void pointerPressed(int x, int y) {
        block5: for (int i = 0; i < this._rectItems.length; ++i) {
            if (!this._rectItems[i].contains(x, y)) continue;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyPressed(-7);
                    continue block5;
                }
                case 1: {
                    Keys.keyPressed(50);
                    continue block5;
                }
                case 2: {
                    Keys.keyPressed(56);
                    continue block5;
                }
                default: {
                    this._mainCanvas.keyPressed(53);
                }
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this._rectItems[this._iSelectedCompId].contains(x, y)) {
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyReleased(-7);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                }
            }
        }
        if (y > MainCanvas.HEIGHT / 2 && y < MainCanvas.HEIGHT - Resources.resSprs[0].getHeight()) {
            if (x >= this._rectDialog.x && x <= this._rectDialog.x + this._rectDialog.width) {
                if (this._ptInstructions.getTextHeight() < this._rectText.height) {
                    return;
                }
                this.dragDown();
            }
        } else if (y < MainCanvas.HEIGHT / 2 && y > 0 + Resources.resSprs[0].getHeight() && x >= this._rectDialog.x && x <= this._rectDialog.x + this._rectDialog.width) {
            if (this._ptInstructions.getTextHeight() < this._rectText.height) {
                return;
            }
            this.dragUp();
        }
    }

    public void dragUp() {
        if (this._ptInstructions.getTextHeight() < this._rectText.height) {
            return;
        }
        if (Resources.sysFont) {
            this._iTextOffsetY -= Font.getDefaultFont().getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        } else {
            this._iTextOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        }
        if (this._iTextOffsetY < 0) {
            this._iTextOffsetY = 0;
            this._bScrollUP = false;
            this._bScrollDOWN = true;
        }
        this._bNeedRepaint = true;
        this._mainCanvas.repaint();
    }

    public void dragDown() {
        if (this._ptInstructions.getTextHeight() < this._rectText.height) {
            return;
        }
        int maxOffsetY = this._ptInstructions.getTextHeight() - this._rectText.height;
        if (Resources.sysFont) {
            this._iTextOffsetY += Font.getDefaultFont().getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        } else {
            this._iTextOffsetY += Resources.resGFonts[0].getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        }
        if (this._iTextOffsetY > maxOffsetY) {
            this._iTextOffsetY = maxOffsetY;
            this._bScrollUP = true;
            this._bScrollDOWN = false;
        }
        this._bNeedRepaint = true;
        this._mainCanvas.repaint();
    }

    public void pointerReleased(int x, int y) {
        switch (this._iSelectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-7)) break;
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            case 1: {
                if (!Keys.isKeyPressed(50)) break;
                this.keyReleased(50);
                Keys.keyReleased(50);
                break;
            }
            case 2: {
                if (!Keys.isKeyPressed(56)) break;
                this.keyReleased(56);
                Keys.keyReleased(56);
                break;
            }
            default: {
                if (Keys.isKeyPressed(50)) {
                    this.keyReleased(50);
                    Keys.keyReleased(50);
                }
                if (Keys.isKeyPressed(56)) {
                    this.keyReleased(56);
                    Keys.keyReleased(56);
                }
                if (!Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }
}

