@echo off

@echo executing %cd%\MAKE_RES.bat

set RES_DIR=data\gfx

rem Save and change current dir...
set MAKE_LIBS_PATH=%BUILD_PATH%\data\res

mkdir %MAKE_LIBS_PATH%\log > NUL 2> NUL

echo MAKE_LIBS_PATH %MAKE_LIBS_PATH%
call %SCRIPTS_DIR%\init.bat


@echo *** Make strings...
cd %MAKE_LIBS_PATH%
rem cd ..\..\strings\
cd %BUILD_PATH%\data\text\
call clean.bat
call export_strings.bat
call do.bat

@echo *** Export sprites...
cd %MAKE_LIBS_PATH%
cd %BUILD_PATH%\data\gfx\sprites\
call export.cmd

@echo *** Export tutorial...
cd %MAKE_LIBS_PATH%
cd %BUILD_PATH%\data\gfx\game\anims
call txt2bin.cmd

@echo *** Export diamond rankings...
cd %MAKE_LIBS_PATH%
cd %BUILD_PATH%\data\gfx\game\arrays
call txt2bin.cmd

@echo *** Export Slot minigame...
cd %MAKE_LIBS_PATH%
cd %BUILD_PATH%\data\gfx\game\minigames\slot
call export_slot

@echo *** Export roulette minigame...
cd %MAKE_LIBS_PATH%
cd %BUILD_PATH%\data\gfx\game\minigames\roulette
call export_roulette

@echo *** Export Poker minigame...
cd %MAKE_LIBS_PATH%
cd %BUILD_PATH%\data\gfx\game\minigames\poker
call export_poker

cd %MAKE_LIBS_PATH%
cd ..
cd ..

	@echo *** Create main libs...
	FOR /L %%I IN (1,1,14) DO (
		@echo   data%%I lib...
		%CPP% -P %DEFINES% %MAKE_LIBS_PATH%\data%%I.lib.txt %MAKE_LIBS_PATH%\data%%I.lib.txt
		%RESCOMPILER% %MAKE_LIBS_PATH%\data%%I.lib.txt > data%%I.lib.log
	)
	
	@echo *** Create city libs...
	FOR /L %%I IN (1,1,8) DO (
		@echo   city%%I lib...
		%CPP% -P %DEFINES% %MAKE_LIBS_PATH%\city%%I.lib.txt %MAKE_LIBS_PATH%\city%%I.lib.txt
		%RESCOMPILER% %MAKE_LIBS_PATH%\city%%I.lib.txt > city%%I.lib.log
	)	
	
	@echo *** Create background images lib...
	FOR /L %%I IN (0,1,7) DO (
		@echo   img%%I lib...	
		
		echo i%%I img%%I.h > %MAKE_LIBS_PATH%\img%%I.lib.txt
		echo +%RES_DIR%\sprites\bs\img%%I.bsprite IMAGE%%I >> %MAKE_LIBS_PATH%\img%%I.lib.txt
		echo +data\res\endoffile.xxx NUM_IMAGES >> %MAKE_LIBS_PATH%\img%%I.lib.txt	
		%RESCOMPILER% %MAKE_LIBS_PATH%\img%%I.lib.txt > img%%I.lib.log
	)	
	
	rem TEMP, TO DELETE!
	rem @echo *** Create auxiliar images lib...
	rem FOR /L %%I IN (0,1,7) DO (
	rem 	@echo   aux%%I lib...	
		
	rem 	echo aux%%I aux%%I.h > %MAKE_LIBS_PATH%\aux%%I.lib.txt
	rem 	echo +%RES_DIR%\sprites\bs\aux%%I.bsprite IMAGE%%I >> %MAKE_LIBS_PATH%\aux%%I.lib.txt
	rem 	echo +data\res\endoffile.xxx NUM_IMAGES >> %MAKE_LIBS_PATH%\aux%%I.lib.txt	
	rem 	%RESCOMPILER% %MAKE_LIBS_PATH%\aux%%I.lib.txt > aux%%I.lib.log
	rem )	
	
	rem echo auxIntro auxIntro.h > %MAKE_LIBS_PATH%\auxIntro.lib.txt
	rem echo +%RES_DIR%\sprites\bs\auxIntro.bsprite IMAGE%%I >> %MAKE_LIBS_PATH%\auxIntro.lib.txt
	rem echo +data\res\endoffile.xxx NUM_IMAGES >> %MAKE_LIBS_PATH%\auxIntro.lib.txt	
	rem %RESCOMPILER% %MAKE_LIBS_PATH%\auxIntro.lib.txt > auxIntro.lib.log	
	
	rem echo auxMap auxMap.h > %MAKE_LIBS_PATH%\auxMap.lib.txt
	rem echo +%RES_DIR%\sprites\bs\auxMap.bsprite IMAGE%%I >> %MAKE_LIBS_PATH%\auxMap.lib.txt
	rem echo +%RES_DIR%\sprites\bs\auxBallEffect.bsprite IMAGE%%I >> %MAKE_LIBS_PATH%\auxMap.lib.txt
	rem echo +data\res\endoffile.xxx NUM_IMAGES >> %MAKE_LIBS_PATH%\auxMap.lib.txt	
	rem %RESCOMPILER% %MAKE_LIBS_PATH%\auxMap.lib.txt > auxMap.lib.log		
	
	rem echo world world.h > %MAKE_LIBS_PATH%\world.lib.txt
	rem echo +%RES_DIR%\sprites\bs\map.bsprite IMAGE%%I >> %MAKE_LIBS_PATH%\world.lib.txt
	rem echo +%RES_DIR%\sprites\bs\ball_efect.bsprite IMAGE%%I >> %MAKE_LIBS_PATH%\world.lib.txt
	rem echo +%RES_DIR%\sprites\bs\ball_efectalpha.bsprite IMAGE%%I >> %MAKE_LIBS_PATH%\world.lib.txt
	rem echo +%RES_DIR%\sprites\bs\map_stripe.bsprite IMAGE%%I >> %MAKE_LIBS_PATH%\world.lib.txt
	rem echo +%RES_DIR%\sprites\bs\map_stripe_alpha.bsprite IMAGE%%I >> %MAKE_LIBS_PATH%\world.lib.txt	
	rem echo +%RES_DIR%\sprites\bs\Map_icon_location.bsprite IMAGE%%I >> %MAKE_LIBS_PATH%\world.lib.txt	
	rem echo +%RES_DIR%\sprites\bs\city_icons.bsprite IMAGE%%I >> %MAKE_LIBS_PATH%\world.lib.txt	
	rem echo +%RES_DIR%\sprites\bs\selection_lines.bsprite IMAGE%%I >> %MAKE_LIBS_PATH%\world.lib.txt	
	rem echo +%RES_DIR%\sprites\bs\selection_lines_alpha.bsprite IMAGE%%I >> %MAKE_LIBS_PATH%\world.lib.txt		
	rem echo +data\res\endoffile.xxx NUM_IMAGES >> %MAKE_LIBS_PATH%\world.lib.txt	
	rem %RESCOMPILER% %MAKE_LIBS_PATH%\world.lib.txt > world.lib.log			
	rem TEMP, TO DELETE!
	
	@echo *** Create world lib...
	%CPP% -P %DEFINES% %MAKE_LIBS_PATH%\world.lib.txt %MAKE_LIBS_PATH%\world.lib.txt
	%RESCOMPILER% %MAKE_LIBS_PATH%\world.lib.txt > world.lib.log			

	@echo *** Create sounds lib...
	rem echo TMP_SND %TMP_SND%
	rem mkdir TMP_SND > nul 2> nul
	rem %SEVENZIP2% e -y -oTMP_SND sounds\Soundpacks.zip SonyEricsson\PHB_SonyEricssonK800_MIDI\*.*
	%CPP% -P %DEFINES% %MAKE_LIBS_PATH%\sounds.lib.txt %MAKE_LIBS_PATH%\sounds.lib.txt
	%RESCOMPILER% %MAKE_LIBS_PATH%\sounds.lib.txt > sounds.lib.log
	rem rmdir /S /Q TMP_SND > nul 2> nul


	if "%MULTILANGUAGE%"=="multi" (
		%RESCOMPILER% %MAKE_LIBS_PATH%\strings_EN.lib.txt > strings_EN.lib.log
		%RESCOMPILER% %MAKE_LIBS_PATH%\strings_FR.lib.txt > strings_FR.lib.log
		%RESCOMPILER% %MAKE_LIBS_PATH%\strings_DE.lib.txt > strings_DE.lib.log
		%RESCOMPILER% %MAKE_LIBS_PATH%\strings_IT.lib.txt > strings_IT.lib.log
		%RESCOMPILER% %MAKE_LIBS_PATH%\strings_SP.lib.txt > strings_SP.lib.log
		%RESCOMPILER% %MAKE_LIBS_PATH%\strings_PT.lib.txt > strings_PT.lib.log
		%RESCOMPILER% %MAKE_LIBS_PATH%\strings_BR.lib.txt > strings_BR.lib.log
	) else (
		rem echo res\s strings.h > %MAKE_LIBS_PATH%\strings.lib.txt
		
		echo s strings.h > %MAKE_LIBS_PATH%\strings.lib.txt
		
		if "%MULTILANGUAGE%"=="true" (
			@echo *** Create multilanguage lib...
			for %%L IN (EN, FR, SP, DE, IT, PT, BR, TR) DO (
				echo +strings\bin_%%L\sp.bin    %%L_BIN >> %MAKE_LIBS_PATH%\strings.lib.txt
				echo +strings\bin_%%L\sp.off    %%L_OFF >> %MAKE_LIBS_PATH%\strings.lib.txt
				rem echo +%RES_DIR%\sprites\bs\worldroute_%%L.bsprite    %%L_MAP >> %MAKE_LIBS_PATH%\strings.lib.txt
				
				rem echo +%RES_DIR%\sprites\bs\Press0Button_%%L.bsprite    Press0Button_%%L >> %MAKE_LIBS_PATH%\strings.lib.txt
				rem echo +%RES_DIR%\sprites\bs\Press0Button_alpha_%%L.bsprite    Press0Button_alpha_%%L >> %MAKE_LIBS_PATH%\strings.lib.txt
			)
		) else (
			@echo *** Create %LANGUAGE% lib...
			if "%LANGUAGE%"=="US" (
			
				echo +data\text\bin_EN\sp.bin    %LANGUAGE%_BIN >> %MAKE_LIBS_PATH%\strings.lib.txt
				echo +data\text\bin_EN\sp.off    %LANGUAGE%_OFF >> %MAKE_LIBS_PATH%\strings.lib.txt	
				rem echo +%RES_DIR%\sprites\bs\worldroute_EN.bsprite    %LANGUAGE%_MAP >> %MAKE_LIBS_PATH%\strings.lib.txt			
				rem  echo +%RES_DIR%\sprites\bs\Press0Button_EN.bsprite    Press0Button_%LANGUAGE% >> %MAKE_LIBS_PATH%\strings.lib.txt
				rem echo +%RES_DIR%\sprites\bs\Press0Button_alpha_%%L.bsprite    Press0Button_alpha_%%L >> %MAKE_LIBS_PATH%\strings.lib.txt
				
			) else (
				echo +data\text\bin_%LANGUAGE%\sp.bin    %LANGUAGE%_BIN >> %MAKE_LIBS_PATH%\strings.lib.txt
				echo +data\text\bin_%LANGUAGE%\sp.off    %LANGUAGE%_OFF >> %MAKE_LIBS_PATH%\strings.lib.txt
				rem echo +%RES_DIR%\sprites\bs\worldroute_%LANGUAGE%.bsprite    %LANGUAGE%_MAP >> %MAKE_LIBS_PATH%\strings.lib.txt
				rem  echo +%RES_DIR%\sprites\bs\Press0Button_%LANGUAGE%.bsprite    Press0Button_%LANGUAGE% >> %MAKE_LIBS_PATH%\strings.lib.txt
				rem echo +%RES_DIR%\sprites\bs\Press0Button_alpha_%%L.bsprite    Press0Button_alpha_%%L >> %MAKE_LIBS_PATH%\strings.lib.txt
			)
		)
		echo +data\res\endoffile.xxx STRINGS_COUNT >> %MAKE_LIBS_PATH%\strings.lib.txt
		%RESCOMPILER% %MAKE_LIBS_PATH%\strings.lib.txt > strings.lib.log
	)

rem @echo *** Move logs...
move *.log %MAKE_LIBS_PATH%\log\ > NUL
move *.h   %MAKE_LIBS_PATH%\log\ > NUL
rem del .\*.xxx > NUL

@echo *** Move resources... %BUILD_PATH_RES%
md %BUILD_PATH_RES% > NUL 2> NUL
del /q %BUILD_PATH_RES%\*.* > NUL 2> NUL
move %BUILD_PATH%\d*.* %BUILD_PATH_RES%\
move %BUILD_PATH%\c*.* %BUILD_PATH_RES%\
move %BUILD_PATH%\s*.* %BUILD_PATH_RES%\
move %BUILD_PATH%\i*.* %BUILD_PATH_RES%\
move %BUILD_PATH%\w*.* %BUILD_PATH_RES%\

move %BUILD_PATH%\aux*.* %BUILD_PATH_RES%\
copy F:\Source\Anur\test2_DiamondTwister_LGKU800_KU970_KE970_U970_IGP_103_src\_master_data\res %BUILD_PATH_RES%\

@echo *** Copy icon...
copy %BUILD_PATH%\data\icon\icon.png %BUILD_PATH_RES%\i.png

cd %MAKE_LIBS_PATH%

@echo *** copy resources defines
copy %MAKE_LIBS_PATH%\log\data9.h %PRJ_DIR%\_master_src\ResPacks
copy %MAKE_LIBS_PATH%\log\data10.h %PRJ_DIR%\_master_src\ResPacks
copy %MAKE_LIBS_PATH%\log\data11.h %PRJ_DIR%\_master_src\ResPacks

if "%IGP%"=="true" (
@echo *** Copy dataIGP
copy dataIGP.* %BUILD_PATH_RES%
)

cd %PRJ_DIR%

@echo end %cd%\MAKE_RES.bat
