/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.game;

import javax.microedition.lcdui.Graphics;
import sk.inlogic.MainCanvas;
import sk.inlogic.Profile;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.screen.ScreenMain;
import sk.inlogic.util.Keys;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Game {
    private ScreenMain screen;
    private Rectangle rectTop;
    private Rectangle rectLeft;
    private Rectangle rectRight;
    private Rectangle rectBottom;
    private Rectangle dot;
    private int tmpX;
    private int tmpY;
    private int incX;
    private int incY;
    private int dotColor;
    private boolean bIncrease;
    private int score;
    private boolean bPlaying;
    private int iTotalScoreY;
    private static int MAX_SPEED = 1700;
    private static int INCREMENT;
    private int speedMultipicator;
    private int speedMultipicatorX;
    private int iClicked;
    private int rectWidth;
    private String strGameOver;
    private String strRetry;
    private String strScore;
    private String strTopScore;
    private String strPaintScore;
    private String strPaintTopScore;

    public Game(ScreenMain screen) {
        this.screen = screen;
        this.speedMultipicator = MainCanvas.HEIGHT * 10 / 320;
        this.speedMultipicatorX = MainCanvas.WIDTH * 10 / 240;
        this.speedMultipicator = MainCanvas.HEIGHT * 10 / 320;
        this.speedMultipicatorX = MainCanvas.WIDTH * 10 / 240;
        INCREMENT = 2 * this.speedMultipicator;
        this.rectWidth = ScreenMain.sprBoard.getWidth() >> 3;
        int rectOffY = ScreenMain.sprFKIcons.getHeight();
        int rectOffX = ScreenMain.sprFKIcons.getWidth();
        this.rectTop = new Rectangle(rectOffX, rectOffY, MainCanvas.WIDTH - (rectOffX << 1), this.rectWidth);
        this.rectLeft = new Rectangle(rectOffX, rectOffY, this.rectWidth, MainCanvas.HEIGHT - (rectOffY << 1));
        this.rectRight = new Rectangle(MainCanvas.WIDTH - rectOffX, rectOffY, this.rectWidth, MainCanvas.HEIGHT - (rectOffY << 1));
        this.rectBottom = new Rectangle(rectOffX, MainCanvas.HEIGHT - rectOffY - this.rectWidth, MainCanvas.WIDTH - (rectOffX << 1), this.rectWidth);
        this.dot = new Rectangle((MainCanvas.WIDTH >> 1) - (ScreenMain.sprDots.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) + (MainCanvas.HEIGHT >> 2), ScreenMain.sprDots.getWidth(), ScreenMain.sprDots.getHeight());
        this.strGameOver = Resources.resTexts[0].getHashedString(21);
        this.strRetry = Resources.resTexts[0].getHashedString(51);
        this.strScore = Resources.resTexts[0].getHashedString(48);
        this.strTopScore = Resources.resTexts[0].getHashedString(49);
    }

    public void restart() {
        this.dot.x = (MainCanvas.WIDTH >> 1) - (ScreenMain.sprDots.getWidth() >> 1);
        this.dot.y = (MainCanvas.HEIGHT >> 1) + (MainCanvas.HEIGHT >> 2);
        this.incX = RandomNum.getRandomInt(15 * this.speedMultipicatorX) + 10 * this.speedMultipicatorX;
        this.incY = -45 * this.speedMultipicator;
        this.tmpX = this.dot.x << 3;
        this.tmpY = this.dot.y << 3;
        this.iClicked = 0;
        this.dotColor = RandomNum.getRandomUInt(5);
        this.bIncrease = false;
        this.bPlaying = false;
        this.score = 0;
        this.screen.playMusic(Sounds.MUSIC_GAME, -1);
    }

    private void start() {
        this.bPlaying = true;
    }

    public void pause() {
        this.bPlaying = false;
    }

    public void update(long ltick) {
        if (this.bPlaying) {
            if (this.iClicked > 0) {
                this.iClicked = (int)((long)this.iClicked - ltick);
            } else if (this.iClicked < 0) {
                this.iClicked = 0;
            }
            this.tmpX += this.incX >> 3;
            this.tmpY += this.incY >> 3;
            this.dot.x = this.tmpX >> 3;
            this.dot.y = this.tmpY >> 3;
            if (this.bIncrease && this.dot.y < MainCanvas.HEIGHT >> 1) {
                this.bIncrease = false;
            }
            this.checkColision();
            this.checkGameOver();
        }
    }

    public void paint(Graphics g) {
        this.paintBoard(g);
        if (this.iClicked > 0) {
            g.setColor(0xFFFFFF);
            g.fillRect(this.rectBottom.x, this.rectBottom.y, this.rectBottom.width, this.rectBottom.height);
        }
        this.paintScore(g, false, 0);
        ScreenMain.sprDots.setFrame(this.dotColor);
        ScreenMain.sprDots.setPosition(this.dot.x, this.dot.y);
        ScreenMain.sprDots.paint(g);
    }

    private void paintScore(Graphics g, boolean result, int offY) {
        if (this.score < 10) {
            if (!result) {
                ScreenMain.sprNumbersBig.setFrame(this.score);
                ScreenMain.sprNumbersBig.setPosition((MainCanvas.WIDTH >> 1) - (ScreenMain.sprNumbersBig.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) - (ScreenMain.sprNumbersBig.getHeight() >> 1));
                ScreenMain.sprNumbersBig.paint(g);
            } else {
                ScreenMain.sprNumbersSmall.setFrame(0);
                ScreenMain.sprNumbersSmall.setPosition((MainCanvas.WIDTH >> 1) - ScreenMain.sprNumbersSmall.getWidth(), (MainCanvas.HEIGHT >> 1) - (ScreenMain.sprNumbersSmall.getHeight() >> 1) + offY);
                ScreenMain.sprNumbersSmall.paint(g);
                ScreenMain.sprNumbersSmall.setFrame(this.score);
                ScreenMain.sprNumbersSmall.setPosition(MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) - (ScreenMain.sprNumbersSmall.getHeight() >> 1) + offY);
                ScreenMain.sprNumbersSmall.paint(g);
            }
        } else if (this.score < 100) {
            ScreenMain.sprNumbersSmall.setFrame(this.score / 10);
            ScreenMain.sprNumbersSmall.setPosition((MainCanvas.WIDTH >> 1) - ScreenMain.sprNumbersSmall.getWidth(), (MainCanvas.HEIGHT >> 1) - (ScreenMain.sprNumbersSmall.getHeight() >> 1) + offY);
            ScreenMain.sprNumbersSmall.paint(g);
            ScreenMain.sprNumbersSmall.setFrame(this.score % 10);
            ScreenMain.sprNumbersSmall.setPosition(MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) - (ScreenMain.sprNumbersSmall.getHeight() >> 1) + offY);
            ScreenMain.sprNumbersSmall.paint(g);
        } else {
            int tmp = this.score - this.score / 100 * 100;
            ScreenMain.sprNumbersSmall.setFrame(this.score / 100);
            ScreenMain.sprNumbersSmall.setPosition((MainCanvas.WIDTH >> 1) - ScreenMain.sprNumbersSmall.getWidth() - (ScreenMain.sprNumbersSmall.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) - (ScreenMain.sprNumbersSmall.getHeight() >> 1) + offY);
            ScreenMain.sprNumbersSmall.paint(g);
            ScreenMain.sprNumbersSmall.setFrame(tmp / 10);
            ScreenMain.sprNumbersSmall.setPosition((MainCanvas.WIDTH >> 1) - (ScreenMain.sprNumbersSmall.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) - (ScreenMain.sprNumbersSmall.getHeight() >> 1) + offY);
            ScreenMain.sprNumbersSmall.paint(g);
            ScreenMain.sprNumbersSmall.setFrame(tmp % 10);
            ScreenMain.sprNumbersSmall.setPosition((MainCanvas.WIDTH >> 1) + (ScreenMain.sprNumbersSmall.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) - (ScreenMain.sprNumbersSmall.getHeight() >> 1) + offY);
            ScreenMain.sprNumbersSmall.paint(g);
        }
    }

    public void paintBoard(Graphics g) {
        int i;
        ScreenMain.sprBoard.setFrame(0);
        ScreenMain.sprBoard.setPosition(this.rectLeft.x - (ScreenMain.sprBoard.getWidth() >> 1), this.rectLeft.y - (ScreenMain.sprBoard.getHeight() >> 1));
        ScreenMain.sprBoard.paint(g);
        g.setClip(this.rectLeft.x + (ScreenMain.sprBoard.getWidth() >> 1), 0, this.rectTop.width - ScreenMain.sprBoard.getWidth(), MainCanvas.HEIGHT);
        int steps = this.rectTop.width / ScreenMain.sprBoard.getWidth() + 1;
        ScreenMain.sprBoard.setFrame(1);
        for (i = 0; i < steps; ++i) {
            ScreenMain.sprBoard.setPosition(this.rectLeft.x + (ScreenMain.sprBoard.getWidth() >> 1) + i * ScreenMain.sprBoard.getWidth(), this.rectLeft.y - (ScreenMain.sprBoard.getHeight() >> 1));
            ScreenMain.sprBoard.paint(g);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        ScreenMain.sprBoard.setFrame(2);
        ScreenMain.sprBoard.setPosition(this.rectRight.x - (ScreenMain.sprBoard.getWidth() >> 1), this.rectRight.y - (ScreenMain.sprBoard.getHeight() >> 1));
        ScreenMain.sprBoard.paint(g);
        g.setClip(0, this.rectLeft.y + (ScreenMain.sprBoard.getHeight() >> 1), MainCanvas.WIDTH, this.rectLeft.height - ScreenMain.sprBoard.getHeight());
        steps = this.rectLeft.height / ScreenMain.sprBoard.getHeight() + 1;
        ScreenMain.sprBoard.setFrame(3);
        for (i = 0; i < steps; ++i) {
            ScreenMain.sprBoard.setPosition(this.rectLeft.x - (ScreenMain.sprBoard.getWidth() >> 1), this.rectLeft.y + (ScreenMain.sprBoard.getHeight() >> 1) + i * ScreenMain.sprBoard.getHeight());
            ScreenMain.sprBoard.paint(g);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        ScreenMain.sprBoard.setFrame(6);
        ScreenMain.sprBoard.setPosition(this.rectLeft.x - (ScreenMain.sprBoard.getWidth() >> 1), this.rectBottom.y - (ScreenMain.sprBoard.getHeight() >> 1));
        ScreenMain.sprBoard.paint(g);
        g.setClip(0, this.rectRight.y + (ScreenMain.sprBoard.getHeight() >> 1), MainCanvas.WIDTH, this.rectRight.height - ScreenMain.sprBoard.getHeight());
        steps = this.rectRight.height / ScreenMain.sprBoard.getHeight() + 1;
        ScreenMain.sprBoard.setFrame(5);
        for (i = 0; i < steps; ++i) {
            ScreenMain.sprBoard.setPosition(this.rectRight.x - (ScreenMain.sprBoard.getWidth() >> 1), this.rectRight.y + (ScreenMain.sprBoard.getHeight() >> 1) + i * ScreenMain.sprBoard.getHeight());
            ScreenMain.sprBoard.paint(g);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        ScreenMain.sprBoard.setFrame(8);
        ScreenMain.sprBoard.setPosition(this.rectRight.x - (ScreenMain.sprBoard.getWidth() >> 1), this.rectBottom.y - (ScreenMain.sprBoard.getHeight() >> 1));
        ScreenMain.sprBoard.paint(g);
        g.setClip(this.rectLeft.x, 0, this.rectBottom.width, MainCanvas.HEIGHT);
        steps = this.rectBottom.width / ScreenMain.sprBoard.getWidth() + 1;
        ScreenMain.sprBoard.setFrame(7);
        for (i = 0; i < steps; ++i) {
            ScreenMain.sprBoard.setPosition(this.rectBottom.x + i * ScreenMain.sprBoard.getWidth(), this.rectBottom.y - (ScreenMain.sprBoard.getHeight() >> 1));
            ScreenMain.sprBoard.paint(g);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public void keyPressed(int keycode) {
        if (Keys.isKeyPressed(53) || Keys.isActionPressed(5)) {
            if (!this.bPlaying) {
                this.start();
            } else {
                this.iClicked = 100;
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (!this.bPlaying) {
            this.start();
        } else {
            this.iClicked = 100;
        }
    }

    private void checkColision() {
        if (this.dot.y - (this.dot.y - (this.tmpY + (this.incY >> 3) >> 3)) <= this.rectTop.y) {
            this.incY = Math.abs(this.incY);
        } else if (this.dot.x + this.dot.width - (this.dot.x - (this.tmpX + (this.incX >> 3) >> 3)) >= this.rectRight.x) {
            this.incX = -Math.abs(this.incX);
        } else if (this.dot.x - (this.dot.x - (this.tmpX + (this.incX >> 3) >> 3)) <= this.rectLeft.x) {
            this.incX = Math.abs(this.incX);
        } else if (this.dot.intersects(this.rectBottom) && this.iClicked > 0 && !this.bIncrease) {
            this.incY = -Math.abs(this.incY);
            if (this.incY - INCREMENT > -MAX_SPEED) {
                this.incY -= INCREMENT;
            }
            ++this.score;
            this.bIncrease = true;
        }
    }

    private void checkGameOver() {
        if (this.dot.y + this.dot.height >= MainCanvas.HEIGHT) {
            if (this.score > Profile.iHighScore) {
                Profile.iHighScore = this.score;
                Profile.save();
            }
            this.screen.getClass();
            this.screen.nextScreen(2, 1);
            this.screen.playMusic(Sounds.MUSIC_MENU, -1);
        }
    }

    public void initGameOver() {
        this.strPaintScore = this.strScore + " " + this.score;
        this.strPaintTopScore = this.strTopScore + " " + Profile.iHighScore;
    }

    public void paintGameOver(Graphics g) {
        this.paintBoard(g);
        this.screen.fontMain.drawString(g, this.strGameOver.toCharArray(), MainCanvas.WIDTH >> 1, this.rectTop.y + (MainCanvas.HEIGHT >> 4), 3);
        this.paintScore(g, true, -MainCanvas.HEIGHT >> 3);
        if (MainCanvas.HEIGHT < 200) {
            this.screen.fontMain.drawString(g, this.strPaintScore.toCharArray(), MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) + (ScreenMain.sprNumbersSmall.getHeight() >> 1) - (MainCanvas.HEIGHT >> 3) + this.screen.fontMain.getHeight(), 3);
            this.screen.fontMain.drawString(g, this.strPaintTopScore.toCharArray(), MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) + (ScreenMain.sprNumbersSmall.getHeight() >> 1) - (MainCanvas.HEIGHT >> 3) + (this.screen.fontMain.getHeight() << 1), 3);
            this.screen.fontMain.drawString(g, this.strRetry.toCharArray(), MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) + (ScreenMain.sprNumbersSmall.getHeight() >> 1) - (MainCanvas.HEIGHT >> 3) + (this.screen.fontMain.getHeight() << 1) + this.screen.fontMain.getHeight(), 3);
        } else {
            this.screen.fontMain.drawString(g, this.strPaintScore.toCharArray(), MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) + (ScreenMain.sprNumbersSmall.getHeight() >> 1) - (MainCanvas.HEIGHT >> 3) + (this.screen.fontMain.getHeight() << 1), 3);
            this.screen.fontMain.drawString(g, this.strPaintTopScore.toCharArray(), MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) + (ScreenMain.sprNumbersSmall.getHeight() >> 1) - (MainCanvas.HEIGHT >> 3) + (this.screen.fontMain.getHeight() << 2) - (this.screen.fontMain.getHeight() >> 1), 3);
            this.screen.fontMain.drawString(g, this.strRetry.toCharArray(), MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) + (ScreenMain.sprNumbersSmall.getHeight() >> 1) - (MainCanvas.HEIGHT >> 3) + (this.screen.fontMain.getHeight() << 2) + this.screen.fontMain.getHeight(), 3);
        }
    }
}

