/*
 * Decompiled with CFR 0.152.
 */
package SAF_GUI;

import SAF_Application.Application;
import SAF_Core.Anim;
import SAF_Core.C;
import SAF_Core.Txt;
import SAF_Util.Mat;
import SAF_Util.Util;
import javax.microedition.lcdui.Graphics;

public class LayoutBox {
    public static final String N = "";
    public static final int COORD_LEFT = 0;
    public static final int COORD_RIGHT = 1;
    public static final int COORD_TOP = 2;
    public static final int COORD_BOTTOM = 3;
    public static final int COORD_PERCENT = 4;
    public static final int SIZE_FIXED = 0;
    public static final int SIZE_PERCENT = 1;
    public static final int GUI_BORDER_TOP_LEFT = 0;
    public static final int GUI_BORDER_TOP = 1;
    public static final int GUI_BORDER_TOP_RIGHT = 2;
    public static final int GUI_BORDER_LEFT = 3;
    public static final int GUI_BORDER_RIGHT = 4;
    public static final int GUI_BORDER_BOTTOM_LEFT = 5;
    public static final int GUI_BORDER_BOTTOM = 6;
    public static final int GUI_BORDER_BOTTOM_RIGHT = 7;
    public static final int GUI_ARROW_LEFT = 8;
    public static final int GUI_ARROW_RIGHT = 9;
    public static final int GUI_ARROW_TOP = 10;
    public static final int GUI_ARROW_BOTTOM = 11;
    public static final int GUI_SELECTED_ITEM_BACKGROUND_LEFT = 12;
    public static final int GUI_SELECTED_ITEM_BACKGROUND_RIGHT = 13;
    public static final int GUI_UNSELECTED_ITEM_BACKGROUND = 14;
    public static final int GUI_DISABLED_ITEM_MASK = 15;
    public static final int BORDER_TYPE_NONE = 0;
    public static final int BORDER_TYPE_BITMAP_UP_DOWN = 1;
    public static final int BORDER_TYPE_BITMAP_LEFT_RIGHT = 2;
    public static final int BORDER_TYPE_BITMAP_FULL = 3;
    public static final int BORDER_TYPE_LINE_FULL = 4;
    public static final int BACKGROUND_TYPE_NONE = 0;
    public static final int BACKGROUND_TYPE_BITMAP_SINGLE = 1;
    public static final int BACKGROUND_TYPE_BITMAP_TEXTURE = 2;
    public static final int BACKGROUND_TYPE_SOLID = 3;
    public static final int BACKGROUND_TYPE_GRADIENT_VERTICAL = 4;
    public static final int BACKGROUND_TYPE_GRADIENT_HORIZONTAL = 5;
    public static final int ITEM_HEIGHT_TYPE_SELECTOR = -2;
    public static final int ITEM_HEIGHT_TYPE_FONT = -1;
    public static final int ITEM_HEIGHT_TYPE_FIXED = 0;
    public static final int SELECTOR_TYPE_NONE = 0;
    public static final int SELECTOR_TYPE_FULL_WIDTH = 1;
    public static final int SELECTOR_TYPE_LEFT = 2;
    public static final int SELECTOR_TYPE_RIGHT = 3;
    public static final int SELECTOR_TYPE_TEXT_START = 4;
    public static final int SELECTOR_TYPE_TEXT_END = 5;
    public static final int SELECTOR_TYPE_CENTRAL = 6;
    public static final int CFG_DEFAULT_HORIZONTAL_SCROLL_SPEED = 4;
    public static final int CFG_DEFAULT_VERTICAL_SCROLL_SPEED_F = 102400;
    private int backgroundType;
    private int backgroundColor1;
    private int backgroundColor2;
    private int backgroundAdjust;
    private int backgroundSequenceId;
    private int borderType;
    private int borderColor;
    private int textAdjust;
    private int positionX;
    private int positionY;
    private int width;
    private int height;
    private int innerMarginLeft;
    private int innerMarginRight;
    private int innerMarginTop;
    private int innerMarginBottom;
    private int currentPositionX;
    private int currentPositionY;
    private int currentWidth;
    private int currentHeight;
    private int itemMaxWidth = 0;
    private int itemHeightType = 0;
    private int itemHeight = 0;
    private Anim guiGfx = null;
    private int guiGfxPaletteId;
    private Txt txt = null;
    private int fontPaletteId;
    private int fontHighlightPaletteId;
    private boolean isClipped = false;
    private int selectorType;
    private int logoPosX;
    private int logoPosY;
    private int logoSequenceId;
    private boolean isAutoSized;
    private int clipPosX;
    private int clipPosY;
    private int clipWidth;
    private int clipHeight;

    public int getPositionX() {
        return this.positionX;
    }

    void setPositionX(int n, int n2) {
        switch (n2) {
            case 1: {
                this.positionX = C.getScreenWidth() - n;
                break;
            }
            case 4: {
                this.positionX = Mat.percentOf(n, C.getScreenWidth());
                break;
            }
            default: {
                this.positionX = n;
            }
        }
    }

    int getPositionY() {
        return this.positionY;
    }

    void setPositionY(int n, int n2) {
        switch (n2) {
            case 3: {
                this.positionY = C.getScreenHeight() - n;
                break;
            }
            case 4: {
                this.positionY = Mat.percentOf(n, C.getScreenHeight());
                break;
            }
            default: {
                this.positionY = n;
            }
        }
    }

    int getWidth() {
        return this.width;
    }

    void setWidth(int n, int n2) {
        this.width = n2 == 0 ? n : Mat.percentOf(n, C.getScreenWidth());
    }

    int getHeight() {
        return this.height;
    }

    void setHeight(int n, int n2) {
        this.height = n2 == 0 ? n : Mat.percentOf(n, C.getScreenHeight());
    }

    int getCurrentPositionX() {
        return this.currentPositionX;
    }

    public int getCurrentPositionY() {
        return this.currentPositionY;
    }

    public int getCurrentWidth() {
        return this.currentWidth;
    }

    public int getCurrentHeight() {
        return this.currentHeight;
    }

    public int getInnerMarginleft() {
        return this.innerMarginLeft;
    }

    void setInnerMarignLeft(int n) {
        this.innerMarginLeft = n;
    }

    public int getInnerMarginRight() {
        return this.innerMarginRight;
    }

    void setInnerMarginRight(int n) {
        this.innerMarginRight = n;
    }

    public int getInnerMarginTop() {
        return this.innerMarginTop;
    }

    void setInnerMarginTop(int n) {
        this.innerMarginTop = n;
    }

    public int getInnerMarginBottom() {
        return this.innerMarginBottom;
    }

    void setInnerMarginBottom(int n) {
        this.innerMarginBottom = n;
    }

    public int getTextAdjust() {
        return this.textAdjust;
    }

    void setTextAdjust(int n) {
        this.textAdjust = n;
    }

    public Txt getText() {
        return this.txt;
    }

    public void setText(Txt txt) {
        this.txt = txt;
    }

    public int getFontPaletteId() {
        return this.fontPaletteId;
    }

    public void setFontPaletteId(int n) {
        this.fontPaletteId = n;
    }

    public int getFontHighlightedPaletteId() {
        return this.fontHighlightPaletteId;
    }

    public void setfontHightlightedPaleteId(int n) {
        this.fontHighlightPaletteId = n;
    }

    public void setGuiGfx(Anim anim) {
        this.guiGfx = anim;
    }

    public Anim getGuiGfx() {
        return this.guiGfx;
    }

    public void setGuiGfxPaletteId(int n) {
        this.guiGfxPaletteId = n;
    }

    public int getGuiGfxPaletteId() {
        return this.guiGfxPaletteId;
    }

    public int getBackgroundType() {
        return this.backgroundType;
    }

    public void setBackgroundType(int n) {
        this.backgroundType = n;
    }

    public int getBackgroundColor() {
        return this.backgroundColor1;
    }

    public void setBackgroundColor(int n, int n2) {
        this.backgroundColor1 = n;
        this.backgroundColor2 = n2;
    }

    public int getBackgroundSequenceId() {
        return this.backgroundSequenceId;
    }

    public void setBackgroundSequenceId(int n) {
        this.backgroundSequenceId = n;
    }

    public int getBorderType() {
        return this.borderType;
    }

    public void setBorderType(int n) {
        this.borderType = n;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int n) {
        this.borderColor = n;
    }

    public int getItemMaxWidth() {
        return this.itemMaxWidth;
    }

    public int getItemHeight() {
        int n = 0;
        switch (this.itemHeightType) {
            case -2: {
                if (this.guiGfx == null || this.guiGfx.getFramesInSequenceCount(12) <= 0) break;
                n = this.guiGfx.getFrameHeight(12, 0);
                break;
            }
            case -1: {
                if (this.txt == null || this.txt.getFont() == null) break;
                n = this.txt.getFont().getFontHeight();
                break;
            }
            default: {
                n = this.itemHeight;
            }
        }
        return n;
    }

    public void setItemMaxWidth(int n) {
        this.itemMaxWidth = n;
    }

    public boolean isClip() {
        return this.isClipped;
    }

    public void setClip(boolean bl) {
        this.isClipped = bl;
    }

    public void setCurrentDimensions(int n, int n2, int n3, int n4) {
        this.currentPositionX = n;
        this.currentPositionY = n2;
        this.currentWidth = n3;
        this.currentHeight = n4;
    }

    private void setCurrentDimensions() {
        this.currentPositionX = this.positionX;
        this.currentPositionY = this.positionY - 5;
        this.currentWidth = this.width;
        this.currentHeight = this.height + 20;
    }

    public int getSelectorHeight() {
        if (this.guiGfx != null && this.guiGfx.getSequencesCount() > 12 && this.guiGfx.getFramesInSequenceCount(12) > 0) {
            return this.guiGfx.getFrameHeight(12, 0);
        }
        return 0;
    }

    public void init(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, int n19, int n20, int n21, int n22, int n23, int n24, int n25, int n26, int n27, int n28, int n29, int n30, int n31, int n32, int n33, int n34, int n35, int n36, int n37) {
        this.positionX = n2 == 0 ? n : Mat.percentOf(n, C.getScreenWidth());
        this.width = n4 == 0 ? C.getScreenWidth() - this.positionX - n3 : C.getScreenWidth() - this.positionX - Mat.percentOf(n3, C.getScreenWidth());
        this.positionY = n6 == 0 ? n5 : Mat.percentOf(n5, C.getScreenHeight());
        this.height = n8 == 0 ? C.getScreenHeight() - this.positionY - n7 : C.getScreenHeight() - this.positionY - Mat.percentOf(n7, C.getScreenHeight());
        this.innerMarginLeft = n9;
        this.innerMarginRight = n10;
        this.innerMarginTop = n11;
        this.innerMarginBottom = n12;
        this.textAdjust = 0;
        switch (n13) {
            case 0: {
                this.textAdjust |= 1;
                break;
            }
            case 1: {
                this.textAdjust |= 4;
                break;
            }
            case 2: {
                this.textAdjust |= 8;
            }
        }
        switch (n14) {
            case 0: {
                this.textAdjust |= 2;
                break;
            }
            case 1: {
                this.textAdjust |= 0x10;
                break;
            }
            case 2: {
                this.textAdjust |= 0x20;
            }
        }
        if (n31 == -2 || n31 == -1) {
            this.itemHeightType = n31;
        } else {
            this.itemHeightType = 0;
            this.itemHeight = n31;
        }
        this.itemMaxWidth = n32;
        this.borderType = n15;
        switch (n26) {
            case 0: {
                this.backgroundAdjust = 1;
                break;
            }
            case 1: {
                this.backgroundAdjust = 4;
                break;
            }
            case 2: {
                this.backgroundAdjust = 8;
            }
        }
        switch (n27) {
            case 0: {
                this.backgroundAdjust |= 2;
                break;
            }
            case 1: {
                this.backgroundAdjust |= 0x10;
                break;
            }
            case 2: {
                this.backgroundAdjust |= 0x20;
            }
        }
        this.borderColor = Util.getRGB(n16, n17, n18);
        this.backgroundType = n19;
        this.backgroundColor1 = Util.getRGB(n20, n21, n22);
        this.backgroundColor2 = Util.getRGB(n23, n24, n25);
        this.backgroundSequenceId = n28;
        this.selectorType = n30;
        this.isAutoSized = n29 != 0;
        this.logoPosX = n34 == 0 ? n33 : Mat.percentOf(n33, C.getScreenWidth());
        this.logoPosY = n36 == 0 ? n35 : Mat.percentOf(n35, C.getScreenHeight());
        this.logoSequenceId = n37;
    }

    public void drawLogo(Graphics graphics) {
        if (this.logoSequenceId >= 0) {
            this.guiGfx.drawFrame(graphics, this.logoSequenceId, Application.getSingleton().getAnimGlobalCounter(), this.guiGfxPaletteId, this.logoPosX, this.logoPosY, 0);
        }
    }

    public void drawBackground(Graphics graphics) {
        if (this.guiGfx == null) {
            return;
        }
        int n = this.currentPositionX;
        int n2 = this.currentPositionY;
        if ((this.backgroundAdjust & 1) != 0) {
            n += this.currentWidth >> 1;
        } else if ((this.backgroundAdjust & 8) != 0) {
            n += this.currentWidth;
        }
        if ((this.backgroundAdjust & 2) != 0) {
            n2 += this.currentHeight >> 1;
        } else if ((this.backgroundAdjust & 0x20) != 0) {
            n2 += this.currentHeight;
        }
        switch (this.backgroundType) {
            case 1: {
                if (this.backgroundSequenceId < 0) break;
                this.guiGfx.drawFrame(graphics, this.backgroundSequenceId, 0, this.getGuiGfxPaletteId(), n, n2, 0);
                break;
            }
            case 2: {
                this.ClipBox(graphics);
                if (this.backgroundSequenceId >= 0) {
                    int n3 = this.guiGfx.getFrameWidth(this.backgroundSequenceId, 0);
                    int n4 = this.guiGfx.getFrameHeight(this.backgroundSequenceId, 0);
                    for (int i = n2; i <= n2 + this.currentHeight; i += n4) {
                        for (int j = n; j <= n + this.currentWidth; j += n3) {
                            this.guiGfx.drawFrame(graphics, this.backgroundSequenceId, 0, this.getGuiGfxPaletteId(), j, i, 0);
                        }
                    }
                }
                this.ClipRestore(graphics);
                break;
            }
            case 3: {
                graphics.setColor(this.backgroundColor1);
                graphics.fillRect(this.currentPositionX + 1, this.currentPositionY + 1, this.currentWidth - 2, this.currentHeight - 2);
                break;
            }
            case 4: {
                Util.drawGradientV(graphics, this.currentPositionX, this.currentPositionY, this.currentWidth, this.currentHeight, this.backgroundColor1, this.backgroundColor2);
                break;
            }
            case 5: {
                Util.drawGradientH(graphics, this.currentPositionX, this.currentPositionY, this.currentWidth, this.currentHeight, this.backgroundColor1, this.backgroundColor2);
            }
        }
    }

    public void drawBorder(Graphics graphics) {
        switch (this.borderType) {
            case 1: {
                this.drawBorderUpDown(graphics);
                break;
            }
            case 2: {
                this.drawBorderLeftRight(graphics);
                break;
            }
            case 3: {
                this.drawBorderFull(graphics);
                break;
            }
            case 4: {
                this.drawBorderLine(graphics);
            }
        }
    }

    public void drawMenuSelector(Graphics graphics, int n) {
        this.ClipBox(graphics);
        for (int i = this.currentPositionX; i <= this.currentPositionX + this.currentWidth; i += this.guiGfx.getFrameWidth(12, 0)) {
            this.guiGfx.drawFrame(graphics, 12, Application.getSingleton().getAnimGlobalCounter(), this.guiGfxPaletteId, i, n, 0);
        }
        this.ClipRestore(graphics);
    }

    public void drawMenuSelector(Graphics graphics, int n, int n2, int n3, boolean bl) {
        if (this.selectorType == 0 || this.guiGfx == null) {
            return;
        }
        int n4 = graphics.getClipX();
        int n5 = graphics.getClipY();
        int n6 = graphics.getClipWidth();
        int n7 = graphics.getClipHeight();
        if (Application.getSingleton().getAppState() == 3) {
            graphics.setClip(this.currentPositionX - 20, this.currentPositionY - 20, this.currentWidth + 20, this.currentHeight + 35);
        } else {
            graphics.setClip(this.currentPositionX, this.currentPositionY - 5, this.currentWidth, this.currentHeight + 20);
        }
        if (bl && this.guiGfx.getFramesInSequenceCount(12) > 0) {
            switch (this.selectorType) {
                case 1: {
                    for (int i = this.currentPositionX; i <= this.currentPositionX + this.currentWidth; i += this.guiGfx.getFrameWidth(12, 0)) {
                        this.guiGfx.drawFrame(graphics, 12, Application.getSingleton().getAnimGlobalCounter(), this.guiGfxPaletteId, i, n2, 0);
                        this.guiGfx.drawFrame(graphics, 13, Application.getSingleton().getAnimGlobalCounter(), this.guiGfxPaletteId, i, n2, 0);
                    }
                    break;
                }
                case 2: {
                    this.guiGfx.drawFrame(graphics, 12, Application.getSingleton().getAnimGlobalCounter(), this.guiGfxPaletteId, this.currentPositionX, n2, 0);
                    this.guiGfx.drawFrame(graphics, 13, Application.getSingleton().getAnimGlobalCounter(), this.guiGfxPaletteId, this.currentPositionX, n2, 0);
                    break;
                }
                case 3: {
                    this.guiGfx.drawFrame(graphics, 12, Application.getSingleton().getAnimGlobalCounter(), this.guiGfxPaletteId, this.currentPositionX + this.currentWidth, n2, 0);
                    this.guiGfx.drawFrame(graphics, 13, Application.getSingleton().getAnimGlobalCounter(), this.guiGfxPaletteId, this.currentPositionX + this.currentWidth, n2, 0);
                    break;
                }
                case 4: {
                    this.guiGfx.drawFrame(graphics, 12, Application.getSingleton().getAnimGlobalCounter(), this.guiGfxPaletteId, n, n2, 0);
                    this.guiGfx.drawFrame(graphics, 13, Application.getSingleton().getAnimGlobalCounter(), this.guiGfxPaletteId, n, n2, 0);
                    break;
                }
                case 5: {
                    this.guiGfx.drawFrame(graphics, 12, Application.getSingleton().getAnimGlobalCounter(), this.guiGfxPaletteId, n + n3, n2, 0);
                    this.guiGfx.drawFrame(graphics, 13, Application.getSingleton().getAnimGlobalCounter(), this.guiGfxPaletteId, n + n3, n2, 0);
                    break;
                }
                case 6: {
                    this.guiGfx.drawFrame(graphics, 12, Application.getSingleton().getAnimGlobalCounter(), this.guiGfxPaletteId, this.currentPositionX + (this.currentWidth >> 1), n2, 0);
                    this.guiGfx.drawFrame(graphics, 13, Application.getSingleton().getAnimGlobalCounter(), this.guiGfxPaletteId, this.currentPositionX + (this.currentWidth >> 1), n2, 0);
                }
            }
        }
        graphics.setClip(n4, n5, n6, n7);
    }

    public static int getCoordXTypeFromParam(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 4;
            }
        }
        return 0;
    }

    public static int getCoordYTypeFromParam(int n) {
        switch (n) {
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
        }
        return 2;
    }

    public static int getSizeTypeFromParam(int n) {
        if (n == 1) {
            return 1;
        }
        return 0;
    }

    public static int getAnchorPointFromParam(int n, int n2) {
        int n3 = 0;
        switch (n) {
            case 0: {
                n3 |= 4;
                break;
            }
            case 1: {
                n3 |= 8;
                break;
            }
            case 2: {
                n3 |= 1;
            }
        }
        switch (n2) {
            case 0: {
                n3 |= 0x10;
                break;
            }
            case 1: {
                n3 |= 0x20;
                break;
            }
            case 2: {
                n3 |= 2;
            }
        }
        return n3;
    }

    private void drawBorderLeftRight(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        this.ClipBox(graphics);
        int n5 = this.guiGfx.getFrameHeight(3, 0);
        if (n5 > 0) {
            n4 = this.currentPositionX;
            n3 = this.currentPositionY;
            n2 = this.currentPositionY + this.currentHeight;
            for (n = n3; n < n2 + n5; n += n5) {
                this.guiGfx.drawFrame(graphics, 3, 0, this.guiGfxPaletteId, n4, n, 0);
            }
        }
        if ((n2 = this.guiGfx.getFrameHeight(4, 0)) > 0) {
            n4 = this.currentPositionX + this.currentWidth;
            n3 = this.currentPositionY;
            n = this.currentPositionY + this.currentHeight;
            for (int i = n3; i < n + n2; i += n2) {
                this.guiGfx.drawFrame(graphics, 4, 0, this.guiGfxPaletteId, n4, i, 0);
            }
        }
        this.ClipRestore(graphics);
    }

    private void drawBorderUpDown(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        this.ClipBox(graphics);
        int n5 = this.guiGfx.getFrameWidth(1, 0);
        if (n5 > 0) {
            n4 = this.currentPositionX;
            n3 = this.currentPositionY;
            n2 = this.currentPositionX + this.currentWidth;
            for (n = n4; n < n2 + n5; n += n5) {
                this.guiGfx.drawFrame(graphics, 1, 0, this.guiGfxPaletteId, n, n3, 0);
            }
        }
        if ((n2 = this.guiGfx.getFrameWidth(6, 0)) > 0) {
            n4 = this.currentPositionX;
            n3 = this.currentPositionY + this.currentHeight;
            n = this.currentPositionX + this.currentWidth;
            for (int i = n4; i < n + n2; i += n2) {
                this.guiGfx.drawFrame(graphics, 6, 0, this.guiGfxPaletteId, i, n3, 0);
            }
        }
        this.ClipRestore(graphics);
    }

    private void drawBorderLine(Graphics graphics) {
        graphics.setColor(this.getBorderColor());
        graphics.drawRect(this.currentPositionX - 1, this.currentPositionY, this.currentWidth + 1, this.currentHeight);
    }

    private void drawBorderFull(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = this.guiGfx.getFrameWidth(0, 0);
        int n10 = this.guiGfx.getFrameWidth(2, 0);
        int n11 = this.guiGfx.getFrameWidth(1, 0);
        if (n11 > 0) {
            n8 = this.currentPositionX + n9;
            n7 = this.currentPositionY;
            n6 = this.currentPositionX + this.currentWidth - n9 - n10;
            for (n5 = n8; n5 <= n6 + n11; n5 += n11) {
                this.guiGfx.drawFrame(graphics, 1, 0, this.guiGfxPaletteId, n5, n7, 0);
            }
        }
        n6 = this.guiGfx.getFrameWidth(5, 0);
        n5 = this.guiGfx.getFrameWidth(7, 0);
        int n12 = this.guiGfx.getFrameWidth(6, 0);
        if (n12 > 0) {
            n8 = this.currentPositionX + n6;
            n7 = this.currentPositionY + this.currentHeight;
            n4 = this.currentPositionX + this.currentWidth - n6 - n5;
            for (n3 = n8; n3 <= n4 + n12; n3 += n12) {
                this.guiGfx.drawFrame(graphics, 6, 0, this.guiGfxPaletteId, n3, n7, 0);
            }
        }
        n4 = this.guiGfx.getFrameHeight(0, 0);
        n3 = this.guiGfx.getFrameHeight(5, 0);
        int n13 = this.guiGfx.getFrameHeight(3, 0);
        if (n13 > 0) {
            n8 = this.currentPositionX;
            n7 = this.currentPositionY + n4;
            n2 = this.currentPositionY + this.currentHeight - n4 - n3;
            for (n = n7; n <= n2 + n13; n += n13) {
                this.guiGfx.drawFrame(graphics, 3, 0, this.guiGfxPaletteId, n8, n, 0);
            }
        }
        n2 = this.guiGfx.getFrameHeight(2, 0);
        n = this.guiGfx.getFrameHeight(7, 0);
        int n14 = this.guiGfx.getFrameHeight(4, 0);
        if (n14 > 0) {
            n8 = this.currentPositionX + this.currentWidth;
            n7 = this.currentPositionY + n2;
            int n15 = this.currentPositionY + this.currentHeight - n2 - n;
            for (int i = n7; i <= n15 + n14; i += n14) {
                this.guiGfx.drawFrame(graphics, 4, 0, this.guiGfxPaletteId, n8, i, 0);
            }
        }
        n8 = this.currentPositionX;
        n7 = this.currentPositionY;
        this.guiGfx.drawFrame(graphics, 0, 0, this.guiGfxPaletteId, n8, n7, 0);
        n8 = this.currentPositionX + this.currentWidth;
        n7 = this.currentPositionY;
        this.guiGfx.drawFrame(graphics, 2, 0, this.guiGfxPaletteId, n8, n7, 0);
        n8 = this.currentPositionX;
        n7 = this.currentPositionY + this.currentHeight;
        this.guiGfx.drawFrame(graphics, 5, 0, this.guiGfxPaletteId, n8, n7, 0);
        n8 = this.currentPositionX + this.currentWidth;
        n7 = this.currentPositionY + this.currentHeight;
        this.guiGfx.drawFrame(graphics, 7, 0, this.guiGfxPaletteId, n8, n7, 0);
    }

    public void calculateSize(int n, int n2) {
        if (this.isAutoSized) {
            int n3 = 0;
            switch (n2) {
                case 0: {
                    n3 = this.getItemHeight() * n;
                    break;
                }
                case 1: {
                    n3 = n;
                }
            }
            if ((n3 += this.getInnerMarginTop() + this.getInnerMarginBottom()) > this.getHeight()) {
                n3 = this.getHeight();
            }
            int n4 = this.getHeight() - n3 >> 1;
            this.setCurrentDimensions(this.getPositionX(), this.getPositionY() + n4, this.getWidth(), n3);
        } else {
            this.setCurrentDimensions();
        }
    }

    protected void ClipBox(Graphics graphics) {
        this.clipPosX = graphics.getClipX();
        this.clipPosY = graphics.getClipY();
        this.clipWidth = graphics.getClipWidth();
        this.clipHeight = graphics.getClipHeight();
        graphics.setClip(this.currentPositionX, this.currentPositionY, this.currentWidth, this.currentHeight);
    }

    protected void ClipRestore(Graphics graphics) {
        graphics.setClip(this.clipPosX, this.clipPosY, this.clipWidth, this.clipHeight);
    }
}

