/*
 * Decompiled with CFR 0.152.
 */
package SAF_Engine;

import SAF_Engine.Layer;
import SAF_Engine.Trigger;
import java.io.DataInputStream;

public class LayerTrigger
extends Layer {
    public static final String N = "";
    public static final byte[] ID = new byte[]{76, 84, 71};
    public Trigger[][][] triggers;
    private int[] triggersTypeInfo;

    public int getType() {
        return 3;
    }

    public int getTriggersNumInSector(int n, int n2) {
        return this.triggers[n][n2].length;
    }

    public Trigger getTrigger(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n >= this.layerSizeX * this.sectorSizeX || n2 >= this.layerSizeY * this.sectorSizeY) {
            return null;
        }
        int n4 = n / this.sectorSizeX;
        int n5 = n2 / this.sectorSizeY;
        if (this.triggers[n4][n5] == null) {
            return null;
        }
        int n6 = n - n4 * this.sectorSizeX;
        int n7 = n2 - n5 * this.sectorSizeY;
        for (int i = 0; i < this.triggers[n4][n5].length; ++i) {
            Trigger trigger = this.triggers[n4][n5][i];
            if (trigger.posX != n6 || trigger.posY != n7) continue;
            if (n3 == 0) {
                return trigger;
            }
            --n3;
        }
        return null;
    }

    public Trigger getTriggerByType(int n) {
        return this.getTriggerByType(n, 0);
    }

    public Trigger getTriggerByType(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.layerSizeX; ++i) {
            for (int j = 0; j < this.layerSizeY; ++j) {
                if (this.triggers[i][j] == null) continue;
                for (int k = 0; k < this.triggers[i][j].length; ++k) {
                    if (this.triggers[i][j][k].type != n) continue;
                    if (n3 == n2) {
                        return this.triggers[i][j][k];
                    }
                    ++n3;
                }
            }
        }
        return null;
    }

    public Trigger getTrigger(int n) {
        int n2 = 0;
        for (int i = 0; i < this.layerSizeX; ++i) {
            for (int j = 0; j < this.layerSizeY; ++j) {
                if (this.triggers[i][j] == null) continue;
                for (int k = 0; k < this.triggers[i][j].length; ++k) {
                    if (n2 == n) {
                        return this.triggers[i][j][k];
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    public Trigger getTriggerByType(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n >= this.layerSizeX * this.sectorSizeX || n2 >= this.layerSizeY * this.sectorSizeY) {
            return null;
        }
        int n4 = n / this.sectorSizeX;
        int n5 = n2 / this.sectorSizeY;
        if (this.triggers[n4][n5] == null) {
            return null;
        }
        int n6 = n - n4 * this.sectorSizeX;
        int n7 = n2 - n5 * this.sectorSizeY;
        for (int i = 0; i < this.triggers[n4][n5].length; ++i) {
            Trigger trigger = this.triggers[n4][n5][i];
            if (trigger.posX != n6 || trigger.posY != n7 || n3 >= 0 && trigger.type != n3) continue;
            return trigger;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(DataInputStream dataInputStream) {
        this.initGeneralParams(dataInputStream);
        try {
            int n;
            int n2;
            int n3;
            int n4 = dataInputStream.readUnsignedByte();
            this.triggersTypeInfo = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                this.triggersTypeInfo[n3] = dataInputStream.readUnsignedByte();
            }
            n3 = dataInputStream.readUnsignedShort();
            this.triggers = new Trigger[this.layerSizeX][this.layerSizeY][];
            for (n2 = 0; n2 < this.layerSizeY; ++n2) {
                for (n = 0; n < this.layerSizeX; ++n) {
                    this.triggers[n][n2] = null;
                }
            }
            for (int i = 0; i < n3; ++i) {
                n2 = dataInputStream.readUnsignedByte();
                n = dataInputStream.readUnsignedByte();
                int n5 = dataInputStream.readUnsignedShort();
                this.triggers[n2][n] = new Trigger[n5];
                for (int j = 0; j < n5; ++j) {
                    int n6 = dataInputStream.readUnsignedByte();
                    int n7 = dataInputStream.readUnsignedByte();
                    int n8 = dataInputStream.readUnsignedByte();
                    short[] sArray = this.triggersTypeInfo[n6] > 0 ? new short[this.triggersTypeInfo[n6]] : null;
                    for (int k = 0; k < this.triggersTypeInfo[n6]; ++k) {
                        sArray[k] = dataInputStream.readShort();
                    }
                    this.triggers[n2][n][j] = new Trigger(n6, n7, n8, sArray);
                }
            }
        }
        catch (Exception exception) {
        }
    }

    public void dispose() {
        this.gfx = null;
        this.triggers = null;
        this.triggersTypeInfo = null;
    }
}

