/*
 * Decompiled with CFR 0.152.
 */
package Game;

import SAF_Util.Mat;
import SAF_Util.Util;

public abstract class Sprite {
    public static final String N = "";
    static final byte TYPE_PLAYER = 0;
    static final byte TYPE_ENEMY = 1;
    static final byte TYPE_DUMMY = 2;
    static final byte TYPE_CITIZEN = 3;
    static final byte TYPE_CAR = 4;
    static final byte TYPE_ITEM = 5;
    static final byte TYPE_TRAFFIC_LIGHT = 6;
    static final byte DIRECTION_NONE = -1;
    static final byte DIRECTION_LEFT = 0;
    static final byte DIRECTION_RIGHT = 1;
    static final byte DIRECTION_UP = 2;
    static final byte DIRECTION_DOWN = 3;
    static final byte DIRECTION_MASK_NONE = 0;
    static final byte DIRECTION_MASK_LEFT = 8;
    static final byte DIRECTION_MASK_RIGHT = 4;
    static final byte DIRECTION_MASK_UP = 2;
    static final byte DIRECTION_MASK_DOWN = 1;
    static final byte GEOMETRY_FRONT_LEFT = 0;
    static final byte GEOMETRY_FRONT_RIGHT = 1;
    static final byte GEOMETRY_REAR_RIGHT = 2;
    static final byte GEOMETRY_REAR_LEFT = 3;
    static final byte GEOMETRY_CORNERS_COUNT = 4;
    int positionXf;
    int positionYf;
    byte direction;
    byte directionDest;
    byte type;
    boolean isVisible;
    int shX;
    int shY;
    int colCarMax;
    int colCarMin;
    private short animationLastFrameTime;
    byte animationFrameCounter;

    private void animationFrameCounterTick() {
        this.animationFrameCounter = (byte)(this.animationFrameCounter + 1);
        if (this.animationFrameCounter == 127) {
            this.animationFrameCounter = (byte)(this.animationFrameCounter ^ this.animationFrameCounter);
        }
    }

    protected void animationFrameCounterReset() {
        this.animationFrameCounter = (byte)(this.animationFrameCounter ^ this.animationFrameCounter);
        this.animationLastFrameTime = (short)(this.animationLastFrameTime ^ this.animationLastFrameTime);
    }

    void animationFrameCounterUpdate(int n) {
        this.animationLastFrameTime = (short)(this.animationLastFrameTime + n);
        if (this.animationLastFrameTime > 100) {
            this.animationLastFrameTime = (short)(this.animationLastFrameTime - 100);
            this.animationFrameCounterTick();
        }
    }

    void setDirection(byte by) {
        this.direction = by;
    }

    byte getDirectionToTarget(int n, int n2) {
        if (Mat.abs(this.positionXf - n) > Mat.abs(this.positionYf - n2)) {
            return this.positionXf > n ? (byte)0 : 1;
        }
        return this.positionYf > n2 ? (byte)2 : 3;
    }

    static byte getDirectionToTarget(int n, int n2, int n3, int n4) {
        if (Mat.abs(n - n3) > Mat.abs(n2 - n4)) {
            return n2 > n3 ? (byte)0 : 1;
        }
        return n2 > n4 ? (byte)2 : 3;
    }

    static byte getDirectionOpposite(byte by) {
        switch (by) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
        }
        return 2;
    }

    static byte getDirectionMask(byte by) {
        return (byte)(1 << 3 - by);
    }

    static byte getDirectionsCountFromMask(byte by) {
        byte by2 = 0;
        if ((by & 8) != 0) {
            by2 = (byte)(by2 + 1);
        }
        if ((by & 4) != 0) {
            by2 = (byte)(by2 + 1);
        }
        if ((by & 2) != 0) {
            by2 = (byte)(by2 + 1);
        }
        if ((by & 1) != 0) {
            by2 = (byte)(by2 + 1);
        }
        return by2;
    }

    static byte directionRandomGenerate(byte by, byte by2) {
        byte by3 = Sprite.getDirectionsCountFromMask(by);
        if (by3 > 1 && by2 != 0) {
            by = (byte)(by & ~by2);
            by3 = Sprite.getDirectionsCountFromMask(by);
        }
        if (by3 > 1) {
            int n = Util.getRandom(1, by3);
            if ((by & 8) != 0) {
                if (n == 1) {
                    return 0;
                }
                --n;
            }
            if ((by & 4) != 0) {
                if (n == 1) {
                    return 1;
                }
                --n;
            }
            if ((by & 2) != 0) {
                if (n == 1) {
                    return 2;
                }
                --n;
            }
            return 3;
        }
        if (by3 == 1) {
            if ((by & 8) != 0) {
                return 0;
            }
            if ((by & 4) != 0) {
                return 1;
            }
            if ((by & 2) != 0) {
                return 2;
            }
            return 3;
        }
        return -1;
    }

    void spatialIndicesCalculate() {
        this.shX = this.positionXf >> 10 >> 3;
        this.shY = this.positionYf >> 10 >> 3;
    }

    abstract void init();

    abstract void update(int var1);

    abstract byte getCurrentFrame();

    abstract byte getCurrentSequence();
}

