/*
 * Decompiled with CFR 0.152.
 */
package SAF_Core;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;

public class Sound {
    public static final String N = "";
    public static final byte SOUND_MAX_NUMBER = 10;
    public static final byte MAX_SIMULTANEOUS = 1;
    private static final boolean SOUND_IS_AVAILABLE = true;
    private static final byte VOLUME_MIN = 0;
    public static final byte VOLUME_MAX = 100;
    private static final byte VOLUME_LEVELS = 5;
    public static final byte TYPE_MUSIC = 0;
    public static final byte TYPE_SFX = 1;
    public static final byte TYPE_ALL = 2;
    public static final byte FORMAT_UNKNOWN = 0;
    public static final byte FORMAT_MID = 1;
    public static final byte FORMAT_MP3 = 2;
    public static final byte FORMAT_WAV = 3;
    public static final byte FORMAT_AMR = 4;
    private static Sound snd;
    private MIDlet midlet;
    private boolean isInit = false;
    private Player[] players;
    private byte[] types;
    private boolean[] isLooped;
    private byte[] volumeLevels;
    private byte maxSoundsNumber;
    private byte maxSoundsSimultaneous;

    public static Sound getSingleton() {
        if (snd == null) {
            snd = new Sound();
        }
        return snd;
    }

    public void init(MIDlet mIDlet, byte n, byte by) {
        this.maxSoundsNumber = n;
        this.maxSoundsSimultaneous = by;
        this.players = new Player[n];
        this.types = new byte[n];
        this.isLooped = new boolean[n];
        this.volumeLevels = new byte[n];
        for (int i = 0; i < n; ++i) {
            this.isLooped[i] = false;
        }
        this.midlet = mIDlet;
        this.isInit = true;
    }

    public void dispose() {
        this.stop();
        try {
            for (int i = 0; i < this.players.length; ++i) {
                this.delSound(i);
            }
        }
        catch (Exception exception) {
            this.players = null;
        }
        this.isInit = false;
    }

    public boolean isInitialized() {
        return this.isInit;
    }

    public int addSound(String string, byte by) {
        int n;
        for (n = 0; n < this.maxSoundsNumber && this.players[n] != null; ++n) {
        }
        if (n == this.maxSoundsNumber) {
            return -1;
        }
        this.types[n] = by;
        this.isLooped[n] = false;
        try {
            InputStream inputStream = this.midlet.getClass().getResourceAsStream(string.startsWith("/") ? string : "/" + string);
            this.players[n] = this.playerCreate(inputStream, this.getFormatFromName(string));
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    public void delSound(int n) {
        try {
            if (this.players[n] != null) {
                this.isLooped[n] = false;
                this.players[n] = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void play(int n, byte by, boolean bl) {
        try {
            if (by <= 0) {
                return;
            }
            if (this.players[n] != null) {
                this.isLooped[n] = bl;
                this.volumeLevels[n] = by;
                this.players[n].prefetch();
                this.players[n].setLoopCount(bl ? -1 : 1);
                VolumeControl volumeControl = (VolumeControl)this.players[n].getControl("VolumeControl");
                if (volumeControl != null) {
                    volumeControl.setLevel((int)by);
                }
                this.players[n].start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop(int n) {
        try {
            if (this.players[n] != null) {
                this.players[n].stop();
                this.players[n].deallocate();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        for (int i = 0; i < this.players.length; ++i) {
            if (this.players[i] == null) continue;
            this.stop(i);
        }
    }

    public void pause(int n) {
        try {
            boolean bl = this.isLooped[n];
            this.stop(n);
            this.isLooped[n] = bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pause() {
        for (int i = 0; i < this.players.length; ++i) {
            if (this.players[i] == null) continue;
            boolean bl = this.isLooped[i];
            this.stop(i);
            this.isLooped[i] = bl;
        }
    }

    public void resume() {
        for (int i = 0; i < this.players.length; ++i) {
            if (this.players[i] == null || !this.isLooped[i]) continue;
            this.play(i, this.volumeLevels[i], true);
        }
    }

    public boolean isPlaying(int n) {
        boolean bl = false;
        try {
            bl = this.players[n].getState() == 400;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public int getPlaingSoundsNumber() {
        int n = 0;
        for (int i = 0; i < this.players.length; ++i) {
            if (!this.isPlaying(n)) continue;
            ++n;
        }
        return n;
    }

    public static byte getVolumeLevels() {
        return 5;
    }

    public static byte getVolumeMin() {
        return 0;
    }

    public static byte getVolumeMax() {
        return 100;
    }

    public static byte getVolumeIncreased(byte by) {
        if ((by = (byte)(by + 20)) > 100) {
            return 0;
        }
        return by;
    }

    public static byte getVolumeDecreased(byte by) {
        if ((by = (byte)(by - 20)) < 0) {
            return 100;
        }
        return by;
    }

    public byte volumeChange(byte by, byte by2) {
        for (int i = 0; i < this.players.length; ++i) {
            if (this.players[i] == null || this.types[i] != by || !this.isPlaying(i)) continue;
            if (by2 <= 0) {
                this.stop(i);
                continue;
            }
            VolumeControl volumeControl = (VolumeControl)this.players[i].getControl("VolumeControl");
            if (volumeControl == null) continue;
            volumeControl.setLevel((int)by2);
        }
        return by2;
    }

    public static boolean getAvailability() {
        return true;
    }

    public static boolean getVolumeControlAvailability() {
        return true;
    }

    private Sound() {
    }

    private int getFormatFromName(String string) {
        if (string.endsWith(".mid")) {
            return 1;
        }
        if (string.endsWith(".wav")) {
            return 3;
        }
        if (string.endsWith(".mp3")) {
            return 2;
        }
        if (string.endsWith(".amr")) {
            return 4;
        }
        return 0;
    }

    private Player playerCreate(InputStream inputStream, int n) throws Exception {
        Player player = null;
        switch (n) {
            case 1: {
                player = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
                break;
            }
            case 2: {
                player = Manager.createPlayer((InputStream)inputStream, (String)"audio/mpeg");
                break;
            }
            case 3: {
                player = Manager.createPlayer((InputStream)inputStream, (String)"audio/x-wav");
                break;
            }
            case 4: {
                player = Manager.createPlayer((InputStream)inputStream, (String)"audio/amr");
            }
        }
        if (player != null) {
            player.setLoopCount(1000);
            player.realize();
            player.prefetch();
        }
        return player;
    }
}

