/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.Vect;
import SAF_Util.Util;

public class Particle {
    static final int BS = 10;
    static final int BV = 1024;
    public int positionXf;
    public int positionYf;
    public int previousPositionXf;
    public int previousPositionYf;
    public Vect initSpeedVectf;
    public int initSpeedf;
    public int initAccelerationf;
    public Vect speedVectf;
    public Vect accelerationVectf;
    public int timeMs;
    public int delayTimeMs;
    public int lifeTimeMs;
    public int initPositionXf;
    public int initPositionYf;
    public boolean isActive;
    public short sizeX;
    public short sizeY;
    public int color;
    public byte particleType;
    public int totalNumberOfFrames;
    public int gravitationSpeedY;

    public Particle(byte by) {
        this.particleType = by;
    }

    public Particle(int n, int n2, int n3, int n4, int n5, int n6, int n7, short s, short s2, int n8, int n9, int n10, int n11) {
        this.init(n, n2, n3, n4, n5, n6, n7, s, s2, n8, n9, n10, n11);
    }

    public void init(int n, int n2, int n3, int n4, int n5, int n6, int n7, short s, short s2, int n8, int n9, int n10, int n11) {
        this.initPositionXf = n;
        this.initPositionYf = n2;
        this.initSpeedf = n4;
        this.initAccelerationf = n5;
        if (n9 == 0 && n10 == 0) {
            this.speedVectf = new Vect(0, -1024);
            this.accelerationVectf = new Vect(0, -1024);
            this.speedVectf.rotate(n3 << 10);
            this.accelerationVectf.rotate(n3 << 10);
        } else {
            this.speedVectf = new Vect(n9, n10);
            this.speedVectf.normalize();
            this.speedVectf.rotate(Util.getRandom(-n11, n11) << 10);
            this.accelerationVectf = new Vect(this.speedVectf.x, this.speedVectf.y);
        }
        this.speedVectf.mulByConstF(n4);
        this.accelerationVectf.mulByConstF(n5);
        this.initSpeedVectf = new Vect(this.speedVectf.x, this.speedVectf.y);
        this.delayTimeMs = n6;
        this.lifeTimeMs = n7;
        this.sizeX = s;
        this.sizeY = s2;
        this.color = n8;
        this.reset();
    }

    public void reset() {
        this.timeMs ^= this.timeMs;
        this.previousPositionXf = this.positionXf = this.initPositionXf;
        this.previousPositionYf = this.positionYf = this.initPositionYf;
        this.gravitationSpeedY = 0;
        this.speedVectf = new Vect(this.initSpeedVectf.x, this.initSpeedVectf.y);
        this.isActive = true;
    }

    public boolean update(int n) {
        this.timeMs += n;
        if (this.isActive && this.timeMs >= this.delayTimeMs) {
            if (this.timeMs >= this.delayTimeMs + this.lifeTimeMs) {
                this.isActive = false;
            } else {
                this.speedVectf.x += this.accelerationVectf.x * n >> 10;
                this.speedVectf.y += this.accelerationVectf.y * n >> 10;
                this.previousPositionXf = this.positionXf;
                this.previousPositionYf = this.positionYf;
                this.positionXf += this.speedVectf.x * n >> 10;
                this.positionYf += this.speedVectf.y * n >> 10;
            }
        }
        return this.isActive || this.timeMs < this.delayTimeMs + this.lifeTimeMs;
    }

    public boolean isSpawned() {
        return this.timeMs >= this.delayTimeMs;
    }

    public int getCurrentFrame() {
        return this.timeMs * this.totalNumberOfFrames / this.lifeTimeMs;
    }
}

