/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.CarType;
import Game.Map;
import Game.ParticleSystem;
import Game.Polygon;
import Game.Sprite;
import Game.Vect;
import SAF_Engine.Trigger;
import SAF_Util.Mat;
import SAF_Util.Util;

public class Car
extends Sprite {
    static final byte STATE_WAITING_FOR_MOVE_TO_SPAWN_QUEUE = -3;
    static final byte STATE_WAITING_FOR_REMOVE = -2;
    static final byte STATE_UNDEFINED = -1;
    static final byte STATE_PARKED = 0;
    static final byte STATE_MOVING = 1;
    static final byte STATE_WAITING_FOR_SPAWN = 2;
    static final byte STATE_NOT_POSSIBLE_TO_STEAL = 3;
    static final byte STATE_MOVING_TURN = 4;
    static final byte STATE_OWNED_BY_PLAYER = 5;
    static final byte STATE_WAITING_FOR_MOVING_PERMISSION = 6;
    static final byte STATE_WAITING_FOR_TRAFFIC_LIGHT = 7;
    static final byte STATE_ABANDONED = 8;
    static final byte STATE_PUSHED = 9;
    static final byte STATE_WAITING_FOR_DESPAWN = 10;
    static final byte STATE_DELAY_FOR_DESPAWN = 11;
    static final byte ACTION_NONE = 0;
    static final byte ACTION_TURN_LEFT = 1;
    static final byte ACTION_TURN_RIGHT = 2;
    static final byte ACTION_THROTTLE = 4;
    static final byte ACTION_BREAKE = 8;
    static final byte ACTION_STOP = 16;
    public static final byte GEAR_N = 0;
    public static final byte GEAR_R = 1;
    public static final byte GEAR_D = 2;
    static final int DEG90F = 92160;
    static final int DEG360F = 368640;
    static final int TURN_ANGLE_F = 23040;
    static Vect v1 = new Vect(0, 1024);
    private static byte playerAction;
    static boolean isStopping;
    CarType carType;
    byte statePrevoius;
    byte state = (byte)-1;
    long stateTime = 0L;
    int energyPoints;
    int driveSpeed;
    public byte gear;
    int driveDifferenceAngleF;
    int adjustSpeed = 122880;
    int bodyAngleF;
    int proposedPositionXf;
    int proposedPositionYf;
    int proposedBodyAngleF;
    Vect delta = new Vect();
    Vect movementDeltaSec = new Vect();
    int driveMovingAngleF;
    int driveMovingSpeedF;
    Vect outerMovementNew = new Vect();
    int outerRotationSpeed;
    Polygon boundingBox;
    Polygon proposedBoundingBox;
    Vect[] geometryCurrentWheels;
    Vect[] geometryCurrentShadow;
    Vect geometryCurrentSmokeEmiterLeft;
    Vect geometryCurrentSmokeEmiterRight;
    int spawnPositionXf;
    int spawnPositionYf;
    byte spawnState;
    int spawnBodyAngle16;
    short trafficControlZoneId = (short)-1;
    short trafficControlTimeToStart;
    ParticleSystem particleSystemCarSmokeLeft;
    ParticleSystem particleSystemCarSmokeRight;
    boolean isAbandoned;
    boolean isClosed;
    int proposedbodyAngleExactF;
    int driveRotationSpeedF = 0;
    int rotationSpeedF = 0;
    int outerDifferenceAngleF;
    int aiMovingAngle = 0;
    int aiMovingDestAngle = 0;
    int aiWaitingForMoveTrialsCounter;
    Trigger lastTrigger = null;
    private static int auxSpeedCurrentF;
    private static final int AI_CIRCLE_F = 9648;
    int mtdx;
    int mtdy;
    int bodyAngleExactF;
    byte directionForbidden = (byte)-1;
    private Vect mpDefault = new Vect(0, 2048);
    Vect mp = new Vect(0, 2048);
    Vect bcRDefault = new Vect(0, -1622);
    Vect bcR = new Vect();
    Vect bcFDefault = new Vect(0, -1408);
    Vect bcF = new Vect();

    void geometryInit() {
        this.boundingBox = new Polygon(4);
        this.proposedBoundingBox = new Polygon(4);
        this.geometryCurrentWheels = new Vect[4];
        this.geometryCurrentShadow = new Vect[4];
        for (int i = 0; i < 4; ++i) {
            this.geometryCurrentWheels[i] = new Vect();
            this.geometryCurrentShadow[i] = new Vect();
        }
        this.geometryCurrentSmokeEmiterLeft = new Vect();
        this.geometryCurrentSmokeEmiterRight = new Vect();
        this.geometryUpdate();
        this.geometryVisibleUpdate();
    }

    void playerCarEnter() {
        this.proposedBodyAngleF = this.proposedbodyAngleExactF = this.bodyAngleF;
        this.bodyAngleExactF = this.proposedbodyAngleExactF;
        this.adjustMovementToBodyAngle();
        this.geometryUpdate();
        this.geometryVisibleUpdate();
        isStopping = false;
        this.isClosed = false;
        this.driveSpeed = 0;
        playerAction = 0;
        this.state = (byte)5;
    }

    void reset() {
    }

    void setAction(byte by) {
        playerAction = by;
    }

    int calcTs() {
        if (this.driveSpeed > 0) {
            int n = this.carType.turnSpeedMinF + (this.driveSpeed * this.carType.turnSpeedMultiplierF >> 10);
            if (n > this.carType.turnSpeedMaxF) {
                return this.carType.turnSpeedMaxF;
            }
            return n;
        }
        if (this.driveSpeed < 0) {
            int n = -this.carType.turnSpeedRearMinF + (this.driveSpeed * this.carType.turnSpeedMultiplierF >> 10);
            if (n < -this.carType.turnSpeedRearMaxF) {
                return -this.carType.turnSpeedRearMaxF;
            }
            return n;
        }
        return 0;
    }

    void rotationUpdate(int n) {
        if (this.driveRotationSpeedF > this.carType.turnSpeedMaxF) {
            this.driveRotationSpeedF = this.carType.turnSpeedMaxF;
        } else if (this.driveRotationSpeedF < -this.carType.turnSpeedMaxF) {
            this.driveMovingSpeedF = -this.carType.turnSpeedMaxF;
        }
        this.driveDifferenceAngleF -= this.driveRotationSpeedF * n >> 10;
        if (this.driveDifferenceAngleF < -92160) {
            this.driveDifferenceAngleF = -92160;
        } else if (this.driveDifferenceAngleF > 92160) {
            this.driveDifferenceAngleF = 92160;
        }
        this.outerDifferenceAngleF -= this.outerRotationSpeed * n >> 10;
        if (this.outerDifferenceAngleF < -368640) {
            this.outerDifferenceAngleF = -368640;
        } else if (this.outerDifferenceAngleF > 368640) {
            this.outerDifferenceAngleF = 368640;
        }
    }

    int trimAngle(int n) {
        if (n < 0) {
            n += 368640;
        } else if (n >= 368640) {
            n -= 368640;
        }
        return n;
    }

    private void throttle(int n) {
        switch (this.gear) {
            case 1: {
                if (this.driveSpeed < 0) {
                    this.driveSpeed += this.carType.breakRetardationF * n / 1000;
                    if (this.driveSpeed < 0) break;
                    this.driveSpeed = 0;
                    break;
                }
                this.gear = 0;
                break;
            }
            case 0: {
                this.gear = (byte)2;
                break;
            }
            case 2: {
                this.driveSpeed += this.carType.accelerationF * n / 1000;
                if (this.driveSpeed > this.carType.vMaxF) {
                    this.driveSpeed = this.carType.vMaxF;
                }
                this.speedClamp();
            }
        }
    }

    private void breake(int n) {
        switch (this.gear) {
            case 1: {
                this.driveSpeed -= this.carType.accelerationRearF * n / 1000;
                if (this.driveSpeed >= -this.carType.vMaxRearF) break;
                this.driveSpeed = -this.carType.vMaxRearF;
                break;
            }
            case 0: {
                this.gear = 1;
                break;
            }
            case 2: {
                if (this.driveSpeed > 0) {
                    this.driveSpeed -= this.carType.breakRetardationF * n / 1000;
                    if (this.driveSpeed >= 0) break;
                    this.driveSpeed = 0;
                    break;
                }
                this.gear = 0;
            }
        }
    }

    private void stop(int n) {
        if (this.driveSpeed > 0) {
            this.driveSpeed -= this.carType.breakRetardationF * n / 1000;
            if (this.driveSpeed < 0) {
                this.driveSpeed ^= this.driveSpeed;
            }
        } else if (this.driveSpeed < 0) {
            this.driveSpeed += this.carType.breakRetardationF * n / 1000;
            if (this.driveSpeed > 0) {
                this.driveSpeed ^= this.driveSpeed;
            }
        }
    }

    void stopNow() {
        this.driveSpeed ^= this.driveSpeed;
        this.rotationSpeedF = 0;
    }

    void adjustMovingAngle(int n) {
        int n2;
        if (this.driveDifferenceAngleF != 0) {
            n2 = this.adjustSpeed * n >> 10;
            if (this.driveDifferenceAngleF < 0) {
                this.driveDifferenceAngleF += n2;
                if (this.driveDifferenceAngleF > 0) {
                    this.driveDifferenceAngleF = 0;
                }
            } else {
                this.driveDifferenceAngleF -= n2;
                if (this.driveDifferenceAngleF < 0) {
                    this.driveDifferenceAngleF = 0;
                }
            }
        }
        if (this.outerDifferenceAngleF != 0) {
            n2 = this.adjustSpeed * n >> 10;
            if (this.outerDifferenceAngleF < 0) {
                this.outerDifferenceAngleF += n2;
                if (this.outerDifferenceAngleF > 0) {
                    this.outerDifferenceAngleF = 0;
                }
            } else {
                this.outerDifferenceAngleF -= n2;
                if (this.outerDifferenceAngleF < 0) {
                    this.outerDifferenceAngleF = 0;
                }
            }
        }
        this.driveMovingAngleF = this.proposedBodyAngleF + this.driveDifferenceAngleF + this.outerDifferenceAngleF;
    }

    void speedClamp() {
        if (this.energyPoints < this.carType.energyPoints75) {
            if (this.energyPoints < this.carType.energyPoints50) {
                if (this.energyPoints < this.carType.energyPoints25) {
                    if (this.driveSpeed > this.carType.vClamped25) {
                        this.driveSpeed = this.carType.vClamped25 - 128;
                    }
                } else if (this.driveSpeed > this.carType.vClamped50) {
                    this.driveSpeed = this.carType.vClamped50 - 128;
                }
            } else if (this.driveSpeed > this.carType.vClamped75) {
                this.driveSpeed = this.carType.vClamped75 - 128;
            }
        }
    }

    void aiMove(int n) {
        if (this.driveSpeed < 4096) {
            this.driveSpeed += 2048 * n >> 10;
            if (this.driveSpeed > 4096) {
                this.driveSpeed = 4096;
            }
        }
        auxSpeedCurrentF = this.driveSpeed * n >> 10;
        if (this.aiMovingAngle < this.aiMovingDestAngle) {
            this.aiMovingAngle += 368640 * this.driveSpeed / 9648 * n >> 10;
            if (this.aiMovingAngle > this.aiMovingDestAngle) {
                this.aiMovingAngle = this.aiMovingDestAngle;
            }
        } else if (this.aiMovingAngle > this.aiMovingDestAngle) {
            this.aiMovingAngle -= 368640 * this.driveSpeed / 9648 * n >> 10;
            if (this.aiMovingAngle < this.aiMovingDestAngle) {
                this.aiMovingAngle = this.aiMovingDestAngle;
            }
        }
        this.delta.rotate(v1, this.aiMovingAngle);
        this.delta.x = this.delta.x * auxSpeedCurrentF >> 10;
        this.delta.y = this.delta.y * auxSpeedCurrentF >> 10;
        this.proposedbodyAngleExactF = this.proposedBodyAngleF = this.roundToBodyAngle(this.aiMovingAngle);
        this.proposedPositionXf = this.positionXf + this.delta.x;
        this.proposedPositionYf = this.positionYf + this.delta.y;
        this.geometryUpdate();
        this.geometryVisibleUpdate();
        this.accept();
        this.bodyAngleExactF = this.bodyAngleF;
    }

    int roundToBodyAngle(int n) {
        int n2 = 0;
        if (n < 0) {
            n += 368640;
        }
        for (int i = 11520; i < 368640; i += 23040) {
            if (n < i) {
                return n2;
            }
            n2 += 23040;
        }
        return 0;
    }

    void update(int n) {
        this.stateTime += (long)n;
        this.animationFrameCounterUpdate(n);
    }

    void driveUpdate(int n) {
        if (!isStopping) {
            if ((playerAction & 4) != 0) {
                this.throttle(n);
            } else if ((playerAction & 8) != 0) {
                this.breake(n);
            } else if ((playerAction & 0x10) != 0) {
                isStopping = true;
                this.stop(n);
            }
            this.driveRotationSpeedF = (playerAction & 1) != 0 ? -this.calcTs() : ((playerAction & 2) != 0 ? this.calcTs() : 0);
        } else {
            this.stop(n);
        }
        this.adjustMovingAngle(n);
        if (this.driveDifferenceAngleF != 0) {
            if (this.driveSpeed > 0) {
                this.driveSpeed -= this.carType.turnRetardatiionF * n >> 10;
                if (this.driveSpeed < 0) {
                    this.driveSpeed ^= this.driveSpeed;
                }
            } else if (this.driveSpeed < 0) {
                this.driveSpeed += this.carType.turnRetardatiionF * n >> 10;
                if (this.driveSpeed > 0) {
                    this.driveSpeed ^= this.driveSpeed;
                }
            }
        }
        if (this.driveSpeed != 0) {
            this.movementDeltaSec.rotate(v1, this.driveMovingAngleF);
            this.movementDeltaSec.x = this.movementDeltaSec.x * this.driveSpeed >> 10;
            this.movementDeltaSec.y = this.movementDeltaSec.y * this.driveSpeed >> 10;
        } else {
            this.movementDeltaSec.x = 0;
            this.movementDeltaSec.y = 0;
        }
        this.mtdy = 0;
        this.mtdx = 0;
        this.move(n);
        this.rotate(n);
    }

    private void outerMovementUpdate(int n) {
        if (this.outerRotationSpeed > 0) {
            if (this.outerRotationSpeed > 204800) {
                this.outerRotationSpeed = 204800;
            }
            this.outerRotationSpeed -= 184320 * n >> 10;
            if (this.outerRotationSpeed < 0) {
                this.outerRotationSpeed = 0;
            }
        } else if (this.outerRotationSpeed < 0) {
            if (this.outerRotationSpeed < -204800) {
                this.outerRotationSpeed = -204800;
            }
            this.outerRotationSpeed += 184320 * n >> 10;
            if (this.outerRotationSpeed > 0) {
                this.outerRotationSpeed = 0;
            }
        }
        if (this.outerMovementNew.x > 0) {
            if (this.outerMovementNew.x > 8192) {
                this.outerMovementNew.x = 8192;
            }
            this.outerMovementNew.x -= 4096 * n >> 10;
            if (this.outerMovementNew.x < 0) {
                this.outerMovementNew.x = 0;
            }
        } else if (this.outerMovementNew.x < 0) {
            if (this.outerMovementNew.x < -8192) {
                this.outerMovementNew.x = -8192;
            }
            this.outerMovementNew.x += 4096 * n >> 10;
            if (this.outerMovementNew.x > 0) {
                this.outerMovementNew.x = 0;
            }
        }
        if (this.outerMovementNew.y > 0) {
            if (this.outerMovementNew.y > 8192) {
                this.outerMovementNew.y = 8192;
            }
            this.outerMovementNew.y -= 4096 * n >> 10;
            if (this.outerMovementNew.y < 0) {
                this.outerMovementNew.y = 0;
            }
        } else if (this.outerMovementNew.y < 0) {
            if (this.outerMovementNew.y < -8192) {
                this.outerMovementNew.y = -8192;
            }
            this.outerMovementNew.y += 4096 * n >> 10;
            if (this.outerMovementNew.y > 0) {
                this.outerMovementNew.y = 0;
            }
        }
    }

    int getMovementSummarySpeed() {
        Vect vect = new Vect();
        vect.x = this.movementDeltaSec.x + this.outerMovementNew.x;
        vect.y = this.movementDeltaSec.y + this.outerMovementNew.y;
        return Mat.sqrtFixedInt(vect.lengthSqr());
    }

    void applyForce(Vect vect, Vect vect2, int n) {
        vect2.normalize();
        Vect vect3 = new Vect(-vect.y, vect.x);
        vect3.normalize();
        Vect vect4 = new Vect(-vect.x, -vect.y);
        vect4.normalize();
        int n2 = vect3.dotProduct(vect2);
        int n3 = vect4.dotProduct(vect2);
        int n4 = vect.lengthSqr();
        if (n4 == 0) {
            n4 = 1;
        }
        int n5 = n2 * n / n4 * 2;
        int n6 = Mat.rad2deg10(n5) + 5120;
        this.outerRotationSpeed += n6;
        int n7 = n * n3 >> 10;
        this.outerMovementNew.x += vect4.x * n7 >> 10;
        this.outerMovementNew.y += vect4.y * n7 >> 10;
    }

    void rotate(int n) {
        this.rotationUpdate(n);
        this.rotationSpeedF = this.driveRotationSpeedF + this.outerRotationSpeed;
        this.proposedbodyAngleExactF = this.trimAngle(this.bodyAngleExactF + (this.rotationSpeedF * n >> 10));
        this.proposedBodyAngleF = this.roundToBodyAngle(this.proposedbodyAngleExactF);
        this.geometryUpdate();
    }

    void move(int n) {
        this.outerMovementUpdate(n);
        this.proposedPositionXf = this.positionXf + this.mtdx + ((this.movementDeltaSec.x + this.outerMovementNew.x) * n >> 10);
        this.proposedPositionYf = this.positionYf + this.mtdy + ((this.movementDeltaSec.y + this.outerMovementNew.y) * n >> 10);
        this.geometryUpdate();
    }

    void accept() {
        this.positionXf = this.proposedPositionXf;
        this.positionYf = this.proposedPositionYf;
        this.bodyAngleF = this.proposedBodyAngleF;
        this.bodyAngleExactF = this.proposedbodyAngleExactF;
        this.boundingBox.vertices[0].set(this.proposedBoundingBox.vertices[0]);
        this.boundingBox.vertices[1].set(this.proposedBoundingBox.vertices[1]);
        this.boundingBox.vertices[2].set(this.proposedBoundingBox.vertices[2]);
        this.boundingBox.vertices[3].set(this.proposedBoundingBox.vertices[3]);
        this.geometryVisibleUpdate();
    }

    void adjustMovementToBodyAngle() {
        this.driveDifferenceAngleF = 0;
        this.driveRotationSpeedF = 0;
        this.outerDifferenceAngleF = 0;
        this.outerRotationSpeed = 0;
    }

    void speedDecrease() {
        this.driveSpeed -= this.driveSpeed / 10;
    }

    int perspectiveTransform(int n) {
        return (n * this.carType.geometryVerticalMultipier >> 10) + this.carType.geometryVerticalOffset;
    }

    void geometryUpdate() {
        for (int i = 0; i < 4; ++i) {
            this.proposedBoundingBox.vertices[i].rotate(this.carType.geometryBody[i], this.proposedBodyAngleF);
            this.proposedBoundingBox.vertices[i].y = this.perspectiveTransform(this.proposedBoundingBox.vertices[i].y);
            this.proposedBoundingBox.vertices[i].x += this.proposedPositionXf;
            this.proposedBoundingBox.vertices[i].y += this.proposedPositionYf;
        }
        this.mp.rotate(this.mpDefault, this.proposedBodyAngleF);
        this.mp.y = this.perspectiveTransform(this.mp.y);
        this.mp.x += this.proposedPositionXf;
        this.mp.y += this.proposedPositionYf;
        if (this.mp.x < 0) {
            this.mp.x = 0;
        } else if (this.mp.x >= Map.widthTotalF) {
            this.mp.x = Map.widthTotalF - 1;
        }
        if (this.mp.y < 0) {
            this.mp.y = 0;
        } else if (this.mp.y >= Map.heightTotalF) {
            this.mp.y = Map.heightTotalF - 1;
        }
    }

    boolean isTyres() {
        return Mat.abs(this.driveDifferenceAngleF) > 51200 && this.outerMovementNew.x == 0 && this.outerMovementNew.y == 0 && this.driveSpeed > this.carType.vMaxF >> 2;
    }

    void geometryWheelsUpdateVisiblePos() {
        for (int i = 0; i < 4; ++i) {
            this.geometryCurrentWheels[i].rotate(this.carType.geometryWheels[i], this.bodyAngleExactF);
            this.geometryCurrentWheels[i].y = this.perspectiveTransform(this.geometryCurrentWheels[i].y);
            this.geometryCurrentWheels[i].x += this.positionXf;
            this.geometryCurrentWheels[i].y += this.positionYf;
        }
    }

    void geometryVisibleUpdate() {
        this.geometryCurrentSmokeEmiterLeft.rotate(this.carType.geometrySmokeEmiterLeft, this.bodyAngleF);
        this.geometryCurrentSmokeEmiterLeft.y = this.perspectiveTransform(this.geometryCurrentSmokeEmiterLeft.y);
        this.geometryCurrentSmokeEmiterLeft.y -= 256;
        this.geometryCurrentSmokeEmiterLeft.x += this.positionXf;
        this.geometryCurrentSmokeEmiterLeft.y += this.positionYf;
        this.geometryCurrentSmokeEmiterRight.rotate(this.carType.geometrySmokeEmiterRight, this.bodyAngleF);
        this.geometryCurrentSmokeEmiterRight.y = this.perspectiveTransform(this.geometryCurrentSmokeEmiterRight.y);
        this.geometryCurrentSmokeEmiterLeft.y -= 256;
        this.geometryCurrentSmokeEmiterRight.x += this.positionXf;
        this.geometryCurrentSmokeEmiterRight.y += this.positionYf;
    }

    public int getGear() {
        return this.gear;
    }

    public void setAngle(int n) {
        this.proposedBodyAngleF = this.proposedbodyAngleExactF = n * 23040;
        this.bodyAngleF = this.proposedbodyAngleExactF;
        this.bodyAngleExactF = this.proposedbodyAngleExactF;
    }

    public void setDirectionFromBodyAngle() {
        int n = this.bodyAngleF >> 10;
        if (n < 0) {
            int n2 = 0;
            ++n2;
        }
        this.direction = n > 315 ? (byte)3 : (n > 225 ? (byte)1 : (n > 135 ? (byte)2 : (n > 45 ? (byte)0 : (byte)3)));
    }

    public int getBodyAngle() {
        return this.bodyAngleF;
    }

    public int getProposedBodyAngle() {
        return this.proposedBodyAngleF;
    }

    void init(CarType carType, int n, int n2, int n3, byte by) {
        this.type = (byte)4;
        this.carType = carType;
        this.proposedPositionXf = this.positionXf = n;
        this.proposedPositionYf = this.positionYf = n2;
        this.isClosed = false;
        this.isAbandoned = false;
        this.setAngle(n3);
        this.aiMovingDestAngle = this.aiMovingAngle = this.bodyAngleF;
        this.setDirectionFromBodyAngle();
        this.stateChange(by);
        this.spawnState = by;
        this.spawnBodyAngle16 = n3;
        this.spawnPositionXf = n;
        this.spawnPositionYf = n2;
        this.energyPoints = this.carType.energyPointsMax;
        this.driveDifferenceAngleF = 0;
        this.gear = 0;
        this.particleSystemCarSmokeLeft = null;
        this.particleSystemCarSmokeRight = null;
        this.geometryInit();
        this.accept();
    }

    void init() {
    }

    byte getCurrentFrame() {
        if (Mat.abs(this.driveSpeed) > 512) {
            return (byte)(this.animationFrameCounter & 1);
        }
        return 0;
    }

    byte getCurrentSequence() {
        int n = 0;
        for (int i = 11520; i < 368640; i += 23040) {
            if (this.bodyAngleF < i) {
                return (byte)n;
            }
            ++n;
        }
        return 0;
    }

    boolean damageTake(int n) {
        this.energyPoints -= n;
        return this.energyPoints <= 0;
    }

    private void stateInit() {
        switch (this.state) {
            case 0: {
                this.isClosed = true;
                this.driveSpeed = 0;
                break;
            }
            case 8: {
                this.isAbandoned = true;
                this.driveSpeed = 0;
                break;
            }
            case 6: {
                this.driveSpeed = 0;
                break;
            }
            case 7: {
                this.driveSpeed = 0;
                this.trafficControlTimeToStart = (short)Util.getRandom(100, 500);
            }
        }
    }

    void statePrevious() {
        this.stateChange(this.statePrevoius);
    }

    void stateReset() {
        this.state = (byte)-1;
    }

    void stateChange(byte by) {
        if (by != this.state) {
            this.animationFrameCounterReset();
            this.statePrevoius = this.state;
            this.state = by;
            this.stateTime ^= this.stateTime;
            this.stateInit();
        }
    }

    byte getState() {
        return this.state;
    }
}

