/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class GameObject {
    int m_nX;
    int m_nY;
    int m_nSpeedX;
    int m_nDistanceX;
    int m_nState;
    byte m_nType;
    Momonga m_pSprite;
    int m_nAnim = -1;
    int m_nAnimFrame;
    int m_nAnimFrameTime;
    int m_nAnimTime;
    int m_nFlags;
    boolean m_bAnimEnded;
    boolean m_bDestroy;

    GameObject() {
    }

    GameObject(int n, Momonga momonga) {
        this.m_pSprite = momonga;
        this.m_nType = (byte)n;
        switch (this.m_nType) {
            case 0: {
                this.m_nFlags = 512;
                this.m_nSpeedX = -(1 + (GameLoop.rRnd_.nextInt() & Integer.MAX_VALUE) % 2 << 10);
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                this.setPosition(GameLoop.iScreenWidth_ / 2, GameLoop.iScreenHeight_ / 2);
                this.setAnim(0);
                break;
            }
            case 5: {
                this.setAnim(0);
                this.setPosition(GameLoop.iScreenWidth_ / 2, GameLoop.iScreenHeight_ - (GameLoop.m_SpritesList[2].getFrameHeight(0) + GameLoop.m_SpritesList[1].getFrameHeight(5) + 1));
                break;
            }
            case 6: {
                break;
            }
            default: {
                this.m_nFlags = 512;
            }
        }
    }

    void setState(int n) {
        this.m_nState = n;
        switch (this.m_nState) {
            case 0: {
                this.setPosition(GameLoop.iScreenWidth_ - (GameLoop.m_SpritesList[12].getFrameWidth(0) << 1), GameLoop.iScreenHeight_ - (GameLoop.m_SpritesList[17].getModuleHeight(10) >> 1));
                this.setAnim(24);
                break;
            }
            case 1: {
                GameLoop.m_nPointIndex = 0;
                this.setAnim(GameLoop.m_aFrame[GameLoop.m_nPointIndex]);
                this.setPosition(GameLoop.m_aPointX[GameLoop.m_nPointIndex], GameLoop.getSlopeHeight() + GameLoop.m_nRampOffset);
                GameLoop.m_nCameraX = 0;
                GameLoop.m_nCameraY = GameLoop.getSlopeHeight() + GameLoop.m_nRampOffset - GameLoop.iScreenHeight_ + GameLoop.m_SpritesList[12].getFrameHeight(0);
                GameLoop.m_nCameraY <<= 10;
                break;
            }
            case 2: {
                GameLoop.inpCleanInputsPool();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                GameLoop.m_nGlobalCounter = 45;
            }
        }
    }

    void update() {
        if ((this.m_nFlags & 0x100) != 0) {
            return;
        }
        if ((this.m_nFlags & 0x200) == 0) {
            this.updateAnim();
        }
        block0 : switch (this.m_nType) {
            case 0: {
                this.updateObjectCloud();
                break;
            }
            case 1: 
            case 3: {
                this.updateObjectPenguin();
                break;
            }
            case 4: {
                if (this.m_nAnimFrame != 18) break;
                GameLoop.playSound(-1, 1);
                break;
            }
            case 5: {
                break;
            }
            case 2: {
                if (GameLoop.m_Penguin.m_nState != 6 || this.m_nAnimFrameTime != 0) break;
                switch (this.m_nAnimFrame) {
                    case 0: 
                    case 1: {
                        GameLoop.m_Penguin.m_nY += 1024;
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        GameLoop.m_Penguin.m_nY -= 1024;
                        break block0;
                    }
                }
                break;
            }
        }
    }

    void updateObjectCloud() {
        if (!this.m_bDestroy) {
            this.m_nDistanceX -= this.m_nSpeedX;
            if (this.m_nDistanceX < 0) {
                this.m_bDestroy = true;
                return;
            }
            this.m_nX = GameLoop.m_nCameraX + this.m_nDistanceX;
        }
    }

    void updateObjectPenguin() {
        switch (this.m_nState) {
            case 0: {
                if (this.isAnimEnded() && this.getAnim() == 25) {
                    GameLoop.setGameSubState(1);
                    return;
                }
                if (this.getAnim() != 24) break;
                if (this.isAnimEnded()) {
                    GameLoop.playSound(-1, 1);
                    if (GameLoop.m_nIntroTimer == 0L) {
                        GameLoop.m_nIntroTimer = System.currentTimeMillis();
                    }
                    if (System.currentTimeMillis() - GameLoop.m_nIntroTimer > 50L) {
                        this.m_nX += this.m_pSprite.getAnimFrameOffsetX(this.m_nAnim, this.m_pSprite.getAnimLength(this.m_nAnim) - 1) << 10;
                        this.resetAnim();
                        GameLoop.m_nIntroTimer = System.currentTimeMillis();
                    }
                }
                if ((this.m_nX >> 10) - GameLoop.m_SpritesList[12].getFrameWidth(0) / 2 + this.m_pSprite.getAnimFrameOffsetX(24, this.m_nAnimFrame) < GameLoop.iScreenWidth_ - GameLoop.m_SpritesList[12].getFrameWidth(11)) break;
                this.m_nX = this.m_nAnimFrame > 0 ? (this.m_nX += this.m_pSprite.getAnimFrameOffsetX(24, this.m_nAnimFrame - 1) << 10) : (this.m_nX += this.m_pSprite.getAnimFrameOffsetX(24, this.m_nAnimFrame) << 10);
                GameLoop.playSound(-1, 1);
                this.setAnim(25);
                break;
            }
            case 1: {
                GameLoop.getNextPoint();
                if (GameLoop.m_nPointIndex >= GameLoop.m_aPointX.length) {
                    GameLoop.setGameSubState(2);
                    return;
                }
                int n = GameLoop.m_aFrame[GameLoop.m_nPointIndex];
                this.setAnim(n);
                this.setPosition(GameLoop.m_aPointX[GameLoop.m_nPointIndex], GameLoop.getSlopeHeight() + GameLoop.m_nRampOffset - GameLoop.m_aPointY[GameLoop.m_nPointIndex]);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                int n = 22 - (GameLoop.m_nCurrentAlpha + 90 > 0 ? GameLoop.m_nCurrentAlpha + 90 : -(GameLoop.m_nCurrentAlpha + 90)) * 23 / 180;
                if (n < 0) {
                    n = 0;
                }
                if (n > 22) {
                    n = 22;
                }
                GameLoop.m_PenguinThrust.setAnim(n);
                this.setAnim(n);
                break;
            }
        }
    }

    void paint(Graphics graphics, int n, int n2) {
        if (this.m_bDestroy) {
            return;
        }
        if (this.m_pSprite == null || this.m_nAnim == -1) {
            return;
        }
        int n3 = this.m_nX - n;
        int n4 = (GameLoop.iScreenHeight_ << 10) - this.m_nY + n2;
        this.m_pSprite.paintAnimFrame(graphics, this.m_nAnim, this.m_nAnimFrame, n3 >> 10, n4 >> 10, this.m_nFlags);
        if (this.m_nType == 1) {
            if (GameLoop.m_PenguinGlider != null) {
                GameLoop.m_PenguinGlider.paintAnimFrame(graphics, this.m_nAnim, this.m_nAnimFrame, n3 >> 10, n4 >> 10, this.m_nFlags);
            }
            if (GameLoop.m_PenguinRocket != null) {
                GameLoop.m_PenguinRocket.paintAnimFrame(graphics, this.m_nAnim, this.m_nAnimFrame, n3 >> 10, n4 >> 10, this.m_nFlags);
            }
            if (GameLoop.m_PenguinThrust != null && GameLoop.m_bIsThrustOn) {
                GameLoop.m_PenguinThrust.setPosition(n3 >> 10, n4 >> 10);
                GameLoop.m_PenguinThrust.paint(graphics);
            }
        }
    }

    void paint(Graphics graphics) {
        if (this.m_bDestroy) {
            return;
        }
        if (this.m_pSprite == null || this.m_nAnim == -1) {
            return;
        }
        this.m_pSprite.paintAnimFrame(graphics, this.m_nAnim, this.m_nAnimFrame, this.m_nX >> 10, this.m_nY >> 10, this.m_nFlags);
        if (this.m_nType == 1 && this.m_nState == 0) {
            int n = this.m_pSprite.getAnimFrameOffsetX(this.m_nAnim, this.m_nAnimFrame);
            int n2 = this.m_pSprite.getAnimFrameOffsetY(this.m_nAnim, this.m_nAnimFrame);
            int n3 = this.m_pSprite.getAnimFrameIndex(this.m_nAnim, this.m_nAnimFrame);
            if (GameLoop.m_PenguinGlider != null) {
                GameLoop.m_PenguinGlider.paintAnimFrame(graphics, n3, 0, (this.m_nX >> 10) + n, (this.m_nY >> 10) + n2, this.m_nFlags);
            }
            if (GameLoop.m_PenguinRocket != null) {
                GameLoop.m_PenguinRocket.paintAnimFrame(graphics, n3, 0, (this.m_nX >> 10) + n, (this.m_nY >> 10) + n2, this.m_nFlags);
            }
        }
    }

    void setAnim(int n) {
        if (n == this.m_nAnim) {
            return;
        }
        this.m_nAnim = n;
        this.resetAnim();
        this.updatePositionFromOffset();
    }

    short getAnim() {
        return (short)this.m_nAnim;
    }

    void resetAnim() {
        this.m_nAnimTime = 0;
        this.m_nAnimFrame = 0;
        this.m_nAnimFrameTime = 0;
        this.m_bAnimEnded = false;
    }

    void updateAnim() {
        if (this.m_pSprite == null || this.m_nAnim == -1) {
            return;
        }
        short s = this.m_pSprite.m_pAryAnimFrameTicks[this.m_nAnim][this.m_nAnimFrame];
        if (s == 0) {
            this.m_nAnimTime = 0;
            this.m_bAnimEnded = true;
            return;
        }
        ++this.m_nAnimTime;
        ++this.m_nAnimFrameTime;
        if (this.m_nAnimFrameTime >= s) {
            this.m_nAnimFrameTime = 0;
            ++this.m_nAnimFrame;
            if (this.m_nAnimFrame >= this.m_pSprite.m_pAryAnimFrames[this.m_nAnim]) {
                this.m_bAnimEnded = true;
                this.m_nAnimTime = 0;
                this.m_nAnimFrame = 0;
                this.m_nAnimFrameTime = 0;
            }
            this.updatePositionFromOffset();
        }
    }

    void updatePositionFromOffset() {
    }

    boolean isAnimEnded() {
        return this.m_nAnimTime == 0 || this.m_bAnimEnded;
    }

    void setPosition(int n, int n2) {
        this.m_nX = n << 10;
        this.m_nY = n2 << 10;
    }
}

