/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class ImageExt {
    protected Image[] m_Image;
    protected int m_nPalettes;
    protected int m_nNumColors;
    public int m_nWidth;
    public int m_nHeight;
    protected byte[] m_aryHeader;
    protected byte[][] m_aryPNGPalettes;
    protected byte[] m_aryDatas;
    protected int m_nPalette = -1;
    protected int m_nPNGLength;
    protected int m_nPalLength;
    protected byte m_nImageType;
    protected int[][] m_aryIntPalettes;

    ImageExt() {
    }

    void loadImageRGBA(byte[] byArray, int n) {
        int n2;
        int n3;
        this.m_nNumColors = byArray[n] & 0xFF;
        if (this.m_nNumColors == 0) {
            this.m_nNumColors = 256;
        }
        ++n;
        this.m_aryIntPalettes = new int[this.m_nPalettes][this.m_nNumColors];
        for (n3 = 0; n3 < this.m_nPalettes; ++n3) {
            for (n2 = 0; n2 < this.m_nNumColors; ++n2) {
                this.m_aryIntPalettes[n3][n2] = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
                n += 4;
            }
        }
        this.m_nWidth = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
        this.m_nHeight = byArray[n + 2] & 0xFF | (byArray[n + 3] & 0xFF) << 8;
        n += 4;
        n3 = this.m_nWidth * this.m_nHeight;
        this.m_aryDatas = new byte[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.m_aryDatas[n2] = byArray[n];
            ++n;
        }
    }

    void createImageRGBA(int n) {
        int n2 = this.m_nWidth * this.m_nHeight;
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.m_aryIntPalettes[n][this.m_aryDatas[i] & 0xFF];
        }
        this.m_Image[n] = Image.createRGBImage((int[])nArray, (int)this.m_nWidth, (int)this.m_nHeight, (boolean)true);
        nArray = null;
    }

    void drawRegionRGBA(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = 0;
        if ((n5 & 1) != 0) {
            n9 |= 2;
        }
        if ((n5 & 2) != 0) {
            n9 |= 1;
        }
        graphics.drawRegion(this.m_Image[this.m_nPalette], n, n2, n3, n4, n9, n6, n7, n8);
    }

    void loadImage(byte[] byArray, int n) {
        byte by = byArray[n];
        this.m_nPalettes = (byte)(byArray[n] & 0xF);
        this.m_nImageType = (byte)(byArray[n] & 0x30);
        if (this.m_nImageType == 16) {
            // empty if block
        }
        if (this.m_nImageType == 32) {
            this.loadImageRGBA(byArray, n + 1);
        }
        this.m_Image = new Image[this.m_nPalettes];
        if (this.m_nImageType == 0) {
            int n2;
            this.m_nPNGLength = byArray[n + 1] & 0xFF | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 3] & 0xFF) << 16 | (byArray[n + 4] & 0xFF) << 24;
            this.m_nPalLength = byArray[n + 5] & 0xFF | (byArray[n + 6] & 0xFF) << 8;
            n += 7;
            this.m_aryDatas = new byte[this.m_nPNGLength];
            for (n2 = 0; n2 < this.m_nPNGLength; ++n2) {
                this.m_aryDatas[n2] = (byte)(byArray[n] & 0xFF);
                ++n;
            }
            this.m_nWidth = (this.m_aryDatas[18] & 0xFF) << 8 | this.m_aryDatas[19] & 0xFF;
            this.m_nHeight = (this.m_aryDatas[22] & 0xFF) << 8 | this.m_aryDatas[23] & 0xFF;
            if (this.m_nPalettes > 1) {
                this.m_aryPNGPalettes = new byte[this.m_nPalettes][this.m_nPalLength];
                for (n2 = 0; n2 < this.m_nPalLength; ++n2) {
                    this.m_aryPNGPalettes[0][n2] = this.m_aryDatas[33 + n2];
                }
                for (n2 = 1; n2 < this.m_nPalettes; ++n2) {
                    for (int i = 0; i < this.m_nPalLength; ++i) {
                        this.m_aryPNGPalettes[n2][i] = (byte)(byArray[n] & 0xFF);
                        ++n;
                    }
                }
            }
        }
        if (this.m_nPalettes == 1) {
            this.setPalette(0);
            this.unloadDatas();
        }
    }

    void setPalette(int n) {
        if (n >= this.m_nPalettes) {
            return;
        }
        if (this.m_Image[n] == null) {
            this.loadPalette(n);
        }
        this.m_nPalette = n;
    }

    void loadPalette(int n) {
        if (n >= this.m_nPalettes) {
            return;
        }
        if (this.m_nImageType == 32) {
            if (this.m_Image[n] == null) {
                this.createImageRGBA(n);
            }
            return;
        }
        if (this.m_nPalettes > 1) {
            for (int i = 0; i < this.m_nPalLength; ++i) {
                this.m_aryDatas[33 + i] = this.m_aryPNGPalettes[n][i];
            }
        }
        this.m_Image[n] = Image.createImage((byte[])this.m_aryDatas, (int)0, (int)this.m_nPNGLength);
    }

    void drawImage(Graphics graphics, int n, int n2, int n3) {
        graphics.drawImage(this.m_Image[this.m_nPalette], n, n2, n3);
    }

    void drawRegion(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n >= this.m_nWidth) {
            return;
        }
        if (n2 >= this.m_nHeight) {
            return;
        }
        if (n + n3 <= 0) {
            return;
        }
        if (n2 + n4 <= 0) {
            return;
        }
        if (n < 0) {
            n3 += n;
            n = 0;
        }
        if (n2 < 0) {
            n4 += n2;
            n2 = 0;
        }
        if (n + n3 >= this.m_nWidth) {
            n3 = this.m_nWidth - n;
        }
        if (n2 + n4 >= this.m_nHeight) {
            n4 = this.m_nHeight - n2;
        }
        if (this.m_nImageType == 32) {
            this.drawRegionRGBA(graphics, n, n2, n3, n4, n5, n6, n7, n8);
            return;
        }
        graphics.setClip(n6, n7, n3, n4);
        if ((n5 & 1) == 0) {
            graphics.drawImage(this.m_Image[this.m_nPalette], n6 - n, n7 - n2, n8);
        }
    }

    void unloadPalette(int n) {
        this.m_Image[n] = null;
    }

    void unloadDatas() {
        this.m_aryHeader = null;
        this.m_aryIntPalettes = null;
        this.m_aryPNGPalettes = null;
        this.m_aryDatas = null;
    }
}

