/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Common;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.ResourceBundle;

public class Resources {
    private static String graphicsBaseDir = "/";
    private static String graphicsDisplayDir = "/";
    public static final int _IMG_INLOGIC_LOGO = 0;
    public static final int _IMG_MENU_LOGO = 1;
    public static final int _IMG_RES_ROTATION = 2;
    public static final int _IMG_BG_MENU = 3;
    public static final int _IMG_MENU_BUTTON = 5;
    public static final int _IMG_MENU_BUTTON_TOP = 6;
    public static final int _IMG_MENU_BUTTON_SELECT = 7;
    public static final int _IMG_GAME_OVER_WINDOW = 8;
    public static final int _IMG_GAME_TILE_BLUE = 9;
    public static final int _IMG_GAME_TILE_GREEN = 10;
    public static final int _IMG_GAME_TILE_RED = 11;
    public static final int _IMG_GAME_TILE_ORANGE = 12;
    public static final int TOTAL_IMGS = 13;
    public static Image[] resImgs = new Image[13];
    public static final int _SPR_ICONS = 0;
    public static final int _SPR_LANGUAGE = 1;
    public static final int _SPR_ARROWS = 2;
    public static final int TOTAL_SPRS = 3;
    public static Sprite[] resSprs = new Sprite[3];
    public static final int _GFONT_MAIN = 0;
    public static final int _GFONT_INST = 1;
    public static final int _GFONT_GAME_BLUE = 2;
    public static final int _GFONT_GAME_GREEN = 3;
    public static final int _GFONT_GAME_RED = 4;
    public static final int _GFONT_GAME_YELLOW = 5;
    public static final int TOTAL_GFONTS = 6;
    public static GFont[] resGFonts = new GFont[6];
    public static final int TEXT_MAIN = 0;
    public static final int TOTAL_TEXTS = 84;
    private static String langDir = "/";
    public static ResourceBundle[] resTexts = new ResourceBundle[84];
    public static final int TEXT_MAIN_INSTRUCTIONS = 1;
    public static final int TEXT_REALY_QUIT = 2;
    public static final int TEXT_MAIN_ENABLE_MUSIC = 5;
    public static final int TEXT_MAIN_YES = 6;
    public static final int TEXT_MAIN_NO = 7;
    public static final int TEXT_LEVEL = 8;
    public static final int TEXT_COMPLETED = 9;
    public static final int TEXT_SCORE = 10;
    public static final int TEXT_TIMEISUP = 11;
    public static final int TEXT_NOMOREMOVES = 12;
    public static final int TEXT_GAMEOVER = 13;
    public static final int TEXT_CONTINUE = 14;
    public static final int TEXT_NEWRECORD = 15;
    public static final int TEXT_CONTROLS_NOTOUCH = 16;
    public static final int TEXT_CONTROLS_TOUCH_1 = 17;
    public static final int TEXT_MENU_ITEMS = 18;
    public static final int TEXT_MENU = 19;
    public static final int TEXT_BACK = 20;
    public static final int TEXT_NEW_GAME = 21;
    public static final int TEXT_INSTRUCT = 22;
    public static final int TEXT_ABOUT = 23;
    public static final int TEXT_CONT = 24;
    public static final int TEXT_RESTART = 25;
    public static final int TEXT_ON = 26;
    public static final int TEXT_OFF = 27;
    public static final int TEXT_SOUNDS = 28;
    public static final int TEXT_TUTORIAL_KEYBOARD = 29;
    public static final int TEXT_TUTORIAL_TOUCH = 30;
    public static final int TEXT_TUTORIAL_MOVES = 31;
    public static final int TEXT_TUTORIAL_BLOCKS = 32;
    public static final int TEXT_TUTORIAL_ESCAPE = 33;
    public static final int TEXT_TUTORIAL_DOWNFALL = 34;
    public static final int TEXT_TUTORIAL_TIME_ATTACK = 35;
    public static final int TEXT_GOALS_SCORE_GET = 36;
    public static final int TEXT_GOALS_SCORE_POINTS = 37;
    public static final int TEXT_GOALS_BLOCKS = 38;
    public static final int TEXT_GOALS_ESCAPE_POP = 39;
    public static final int TEXT_GOALS_ESCAPE_DIAMONDS = 40;
    public static final int TEXT_GOALS_DOWNFALL_BRING = 41;
    public static final int TEXT_GOALS_DOWNFALL_DIAMONDS = 42;
    public static final int TEXT_GOALS_MOVES_MAKE = 43;
    public static final int TEXT_GOALS_MOVES_TURNS = 44;
    public static final int TEXT_GOALS_TIME_ADD_WITHIN = 45;
    public static final int TEXT_GOALS_TIME_ADD_SECONDS = 46;
    public static final int TEXT_GOALS_TURNS_ADD_WITHIN = 47;
    public static final int TEXT_GOALS_TURNS_ADD_TURNS = 48;
    public static final int TEXT_RESULT_WELL_DONE = 49;
    public static final int TEXT_RESULT_GLAMOROUS = 50;
    public static final int TEXT_RESULT_SHINY = 51;
    public static final int TEXT_RESULT_GAME_OVER = 52;
    public static final int TEXT_CONTROLS_TOUCH_2 = 53;
    public static final int TEXT_CONTROLS_KEYS = 54;
    public static final int TEXT_RESULT_TITLE = 56;
    public static final int TEXT_RESULT_BOMB_LEFT = 57;
    public static final int TEXT_RESULT_DIAMOND = 58;
    public static final int TEXT_RESULT_RING = 59;
    public static final int TEXT_RESULT_TITLE_LOSE = 60;
    public static final int TEXT_RESULT_LOSE_OUT_OF_OPTIONS = 61;
    public static final int TEXT_RESULT_LOSE_BUBBLE_ESCAPED = 62;
    public static final int TEXT_RESULT_LOSE_OUT_OF_MOVES = 63;
    public static final int TEXT_RESULT_LOSE_OUT_OF_TIMES = 64;
    public static final int TEXT_RESULT_FAIL_POINTS = 65;
    public static final int TEXT_RESULT_FAIL_BLOCKS = 66;
    public static final int TEXT_RESULT_FAIL_RING = 67;
    public static final int TEXT_RESULT_FAIL_DIAMOND = 68;
    public static final int TEXT_RESULT_FAIL_MOVES = 69;
    public static final int TEXT_CLASSIC_PACK = 70;
    public static final int TEXT_BONUS_PACK = 71;
    public static final int TEXT_LAST_MESSAGE_FAIL = 72;
    public static final int TEXT_LAST_MESSAGE_OK = 73;
    public static final int TEXT_LAST_MESSAGE_SURPRISE = 74;
    public static final int TEXT_LAST_MESSAGE_BONUS_FAIL = 75;
    public static final int TEXT_LAST_MESSAGE_BONUS_OK = 76;
    public static final int TEXT_INGAME_REALY_QUIT = 77;
    public static final int TEXT_RESTART_QUESTIONS = 78;
    public static final int TEXT_CONTR_TITLE = 79;
    public static final int TEXT_COLOR_RED = 80;
    public static final int TEXT_COLOR_BLUE = 81;
    public static final int TEXT_COLOR_GREEN = 82;
    public static final int TEXT_COLOR_ORANGE = 83;
    public static boolean sysFont;
    public static int widht;

    public static void initGraphicsDirs(int width, int height) {
        System.out.println(widht + " : " + width);
        graphicsBaseDir = "/" + width + "x" + height + "/";
        graphicsDisplayDir = "/" + width + "x" + height + "/";
        if (width == 240) {
            if (height > 320) {
                graphicsBaseDir = "/240x400/";
                graphicsDisplayDir = "/240x400/";
            } else {
                graphicsBaseDir = "/240x320/";
                graphicsDisplayDir = "/240x320/";
            }
        }
    }

    public static Image createImage(String imgName) {
        Image image = null;
        try {
            Common.trace(imgName);
            image = Image.createImage((String)imgName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return image;
    }

    public static Sprite createSprite(Image image, int slicesX, int slicesY) {
        Sprite sprite = null;
        try {
            int sprWidth = image.getWidth() / slicesX;
            int sprHeight = image.getHeight() / slicesY;
            sprite = new Sprite(image, sprWidth, sprHeight);
        }
        catch (Exception e) {
            sprite = null;
        }
        return sprite;
    }

    public static void loadImage(int imgIdx) {
        String imgPath = null;
        switch (imgIdx) {
            case 1: {
                imgPath = graphicsBaseDir + "logo.png";
                break;
            }
            case 0: {
                imgPath = graphicsBaseDir + "l.png";
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "rot.png";
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "background.png";
                break;
            }
            case 5: {
                imgPath = graphicsBaseDir + "button_menu.png";
                break;
            }
            case 6: {
                imgPath = graphicsBaseDir + "button.png";
                break;
            }
            case 7: {
                imgPath = graphicsBaseDir + "button_selector.png";
                break;
            }
            case 8: {
                imgPath = graphicsBaseDir + "window.png";
                break;
            }
            case 9: {
                imgPath = graphicsBaseDir + "c3.png";
                break;
            }
            case 10: {
                imgPath = graphicsBaseDir + "c2.png";
                break;
            }
            case 11: {
                imgPath = graphicsBaseDir + "c1.png";
                break;
            }
            case 12: {
                imgPath = graphicsBaseDir + "c4.png";
            }
        }
        if (imgPath != null && resImgs[imgIdx] == null) {
            Resources.resImgs[imgIdx] = Resources.createImage(imgPath);
        }
    }

    public static void freeImage(int imgIdx) {
        Resources.resImgs[imgIdx] = null;
    }

    public static void loadImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.loadImage(imgsIdx[i]);
        }
    }

    public static void freeImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.resImgs[imgsIdx[i]] = null;
        }
    }

    public static void loadSprite(int sprIdx) {
        String imgPath = null;
        int slicesX = 1;
        int slicesY = 1;
        switch (sprIdx) {
            case 0: {
                imgPath = graphicsBaseDir + "buttons.png";
                slicesX = 10;
                slicesY = 1;
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "language.png";
                slicesX = 4;
                slicesY = 3;
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "arrows.png";
                slicesX = 1;
                slicesY = 2;
            }
        }
        if (imgPath != null && resSprs[sprIdx] == null) {
            Resources.resSprs[sprIdx] = Resources.createSprite(Resources.createImage(imgPath), slicesX, slicesY);
        }
    }

    public static void freeSprite(int sprIdx) {
        Resources.resSprs[sprIdx] = null;
    }

    public static void loadSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.loadSprite(sprsIdx[i]);
        }
    }

    public static void freeSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.resSprs[sprsIdx[i]] = null;
        }
    }

    private static GFont createGFontMain(Image gFontImg) {
        char[] fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c2', '\u00c4', '\u00c7', '\u010c', '\u010e', '\u00cb', '\u00c9', '\u00c8', '\u00cf', '\u00cd', '\u00cc', '\u013d', '\u0147', '\u00d6', '\u00d3', '\u00d2', '\u00dc', '\u00da', '\u00d9', '\u0158', '\u0160', '\u015a', '\u0164', '\u00dd'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 1;
        switch (gFontImg.getHeight()) {
            case 22: {
                fontCharsWidth = new short[]{10, 14, 12, 10, 11, 15, 11, 6, 10, 12, 9, 15, 12, 15, 10, 15, 11, 11, 12, 11, 14, 20, 14, 13, 14, 16, 16, 15, 15, 13, 13, 12, 10, 11, 10, 9, 7, 7, 9, 12, 16, 15, 16, 12, 12, 12, 10, 11, 11, 12, 12, 14, 11, 15, 9, 20, 8, 6, 6, 6, 6, 6, 5, 3, 12, 9, 12, 10, 10, 9, 7, 10, 5, 5, 4, 4, 8, 4, 4, 10, 12, 7, 19, 11, 11, 10, 11, 10, 10, 13, 11, 0};
                break;
            }
            case 10: {
                fontCharsWidth = new short[]{4, 4, 4, 4, 3, 3, 4, 4, 1, 4, 4, 3, 5, 4, 4, 4, 4, 4, 4, 3, 4, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 2, 2, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 4, 4, 4, 4, 5, 4, 4, 5, 5, 5, 5, 4, 4, 5, 2, 2, 5, 3, 5, 3, 3, 5, 3, 1, 1, 1, 1, 2, 3, 1, 4, 1, 3, 3, 3, 4, 2, 4, 4, 4, 4, 4, 4, 4, 4};
                break;
            }
            case 13: {
                fontCharsWidth = new short[]{5, 7, 5, 5, 5, 6, 5, 5, 5, 5, 2, 5, 5, 4, 7, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 7, 5, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 2, 2, 3, 3, 2, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 4, 5, 5, 6, 5, 5, 5, 5, 5, 6, 5, 7, 4, 4, 4, 7, 7, 8, 2, 3, 3, 3, 3, 2, 1, 7, 3, 3, 3, 5, 5, 5, 4, 5, 2, 1, 2, 1, 2, 4, 4, 2, 4, 1, 5, 1, 5, 6, 4, 4, 5, 5, 6, 5, 5, 5, 5, 5, 5};
                break;
            }
            case 14: {
                fontCharsWidth = new short[]{9, 10, 9, 9, 10, 10, 9, 9, 3, 8, 10, 8, 13, 10, 9, 10, 9, 9, 10, 10, 9, 9, 14, 9, 10, 9, 10, 9, 10, 9, 10, 9, 10, 9, 10, 10, 9, 10, 9, 9, 4, 4, 6, 3, 8, 9, 10, 9, 10, 9, 10, 9, 10, 9, 10, 9, 10, 9, 10, 9, 9, 10, 9, 10, 9, 10, 10, 10, 13, 6, 7, 9, 4, 4, 9, 3, 5, 7, 8, 8, 6, 2, 3, 3, 3, 4, 6, 3, 10, 3, 10, 8, 8, 9, 5, 10, 10, 10, 10, 9, 9, 10, 9, 9};
                break;
            }
            case 16: {
                fontCharsWidth = new short[]{9, 11, 7, 8, 8, 10, 6, 6, 9, 8, 3, 5, 8, 6, 10, 9, 10, 10, 7, 9, 7, 6, 7, 7, 8, 13, 7, 8, 8, 8, 8, 9, 8, 9, 9, 8, 7, 9, 6, 6, 6, 6, 6, 3, 3, 5, 4, 3, 6, 8, 9, 9, 10, 9, 10, 9, 8, 8, 8, 8, 7, 7, 7, 7, 6, 7, 8, 8, 9, 6, 8, 7, 6, 6, 8, 7, 9, 6, 10, 4, 4, 8, 9, 5, 8, 3, 3, 3, 3, 3, 3, 2, 11, 5, 8, 7, 7, 7, 7, 7, 8, 3, 3, 3, 2, 3, 4, 5, 3, 5, 3, 5, 2, 5, 7, 4, 4, 7, 6, 7, 7, 7, 7, 7, 7, 7};
                break;
            }
            case 20: {
                fontCharsWidth = new short[]{11, 13, 12, 12, 12, 13, 12, 11, 4, 9, 13, 10, 17, 13, 12, 13, 13, 12, 12, 12, 12, 13, 17, 12, 13, 13, 13, 12, 12, 12, 13, 12, 13, 13, 12, 12, 12, 12, 13, 13, 5, 4, 7, 4, 9, 13, 13, 12, 12, 12, 13, 13, 13, 13, 13, 12, 12, 13, 13, 13, 12, 13, 11, 13, 13, 12, 11, 13, 17, 7, 7, 12, 6, 5, 12, 4, 7, 8, 9, 9, 8, 4, 3, 3, 3, 6, 4, 4, 12, 3, 12, 10, 10, 13, 5, 12, 12, 13, 13, 13, 12, 12, 12};
                break;
            }
            case 21: {
                fontCharsWidth = new short[]{11, 15, 9, 10, 11, 13, 8, 8, 11, 10, 3, 7, 10, 8, 13, 10, 12, 13, 9, 11, 8, 9, 9, 10, 10, 16, 10, 10, 10, 11, 11, 11, 10, 11, 11, 10, 10, 11, 8, 8, 8, 8, 8, 4, 4, 6, 5, 3, 8, 11, 10, 12, 12, 12, 12, 12, 10, 10, 10, 10, 10, 9, 9, 8, 8, 10, 9, 10, 11, 8, 10, 9, 8, 9, 8, 8, 11, 6, 12, 5, 5, 9, 11, 7, 11, 4, 4, 5, 4, 4, 4, 2, 15, 5, 9, 9, 10, 9, 9, 10, 9, 3, 3, 3, 3, 3, 5, 5, 3, 6, 3, 6, 3, 7, 9, 5, 5, 8, 8, 9, 8, 9, 8, 9, 8, 9};
                break;
            }
            case 15: {
                fontCharsWidth = new short[]{8, 9, 8, 8, 7, 9, 7, 2, 3, 7, 5, 11, 8, 9, 7, 9, 7, 5, 7, 8, 8, 10, 8, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 7, 8, 3, 3, 3, 6, 8, 10, 10, 11, 8, 8, 8, 8, 6, 5, 7, 7, 7, 0};
                break;
            }
            case 25: {
                fontCharsWidth = new short[]{12, 12, 13, 12, 12, 12, 16, 12, 3, 3, 12, 8, 16, 13, 16, 12, 15, 12, 8, 12, 13, 11, 17, 12, 11, 13, 11, 13, 11, 12, 14, 14, 12, 12, 12, 12, 5, 4, 4, 9, 12, 15, 15, 16, 12, 13, 12, 12, 8, 8, 13, 11, 11};
                break;
            }
            case 26: {
                fontCharsWidth = new short[]{16, 16, 17, 15, 17, 17, 16, 16, 6, 13, 16, 13, 23, 17, 17, 16, 16, 17, 16, 16, 16, 16, 23, 17, 16, 16, 17, 17, 17, 17, 16, 16, 16, 16, 17, 16, 16, 16, 17, 17, 6, 6, 10, 5, 13, 17, 16, 16, 16, 17, 17, 17, 16, 16, 16, 17, 17, 16, 16, 16, 16, 17, 16, 16, 16, 16, 16, 17, 22, 9, 11, 15, 7, 7, 15, 5, 10, 10, 13, 13, 10, 4, 4, 4, 4, 6, 9, 5, 16, 4, 16, 14, 12, 17, 7, 16, 16, 17, 16, 17, 16, 17, 17};
                break;
            }
            case 29: {
                fontCharsWidth = new short[]{18, 19, 18, 18, 20, 18, 19, 19, 5, 15, 19, 14, 25, 19, 19, 19, 18, 19, 18, 19, 18, 19, 25, 19, 18, 19, 19, 19, 19, 18, 19, 18, 18, 19, 19, 18, 19, 18, 19, 18, 7, 7, 12, 6, 15, 19, 19, 19, 19, 19, 18, 18, 19, 18, 19, 19, 18, 19, 18, 19, 18, 19, 19, 18, 19, 18, 18, 19, 25, 11, 11, 17, 8, 7, 17, 6, 12, 11, 14, 14, 11, 4, 5, 4, 5, 7, 10, 4, 18, 5, 18, 15, 15, 19, 7, 19, 19, 18, 18, 18, 18, 18, 18};
                break;
            }
            case 32: {
                fontCharsWidth = new short[]{17, 22, 14, 14, 16, 19, 12, 11, 17, 16, 4, 10, 15, 12, 21, 16, 18, 18, 13, 18, 14, 13, 15, 16, 17, 24, 16, 16, 15, 17, 16, 17, 17, 16, 17, 15, 15, 17, 12, 13, 12, 12, 12, 7, 7, 9, 9, 5, 11, 15, 17, 18, 18, 19, 18, 19, 15, 15, 16, 15, 16, 14, 14, 13, 13, 15, 15, 15, 17, 13, 16, 14, 12, 13, 15, 14, 17, 12, 19, 9, 9, 15, 18, 10, 17, 6, 6, 8, 7, 6, 6, 4, 22, 8, 14, 14, 15, 15, 15, 15, 14, 6, 5, 5, 5, 6, 9, 11, 5, 10, 5, 10, 4, 10, 15, 7, 8, 13, 13, 15, 13, 14, 13, 14, 13, 14};
                break;
            }
            case 39: {
                fontCharsWidth = new short[]{14, 19, 18, 15, 15, 22, 17, 10, 15, 17, 13, 21, 18, 22, 15, 22, 16, 16, 17, 17, 21, 30, 21, 18, 20, 23, 23, 22, 22, 19, 18, 18, 15, 15, 15, 11, 11, 10, 15, 18, 23, 23, 23, 17, 18, 18, 16, 16, 16, 17, 18, 20, 16, 21, 14, 30, 11, 8, 8, 9, 9, 7, 8, 3, 17, 14, 17, 14, 14, 12, 12, 13, 6, 5, 6, 5, 12, 5, 6, 14, 18, 11, 16, 13, 15, 16, 15, 16, 14, 15, 18, 16, 0};
                break;
            }
            case 40: {
                fontCharsWidth = new short[]{17, 18, 20, 18, 17, 19, 23, 18, 4, 4, 18, 12, 24, 18, 24, 18, 23, 19, 12, 17, 18, 18, 26, 18, 18, 18, 18, 17, 18, 18, 21, 20, 17, 18, 18, 17, 8, 4, 6, 13, 17, 24, 23, 23, 17, 18, 18, 18, 12, 12, 18, 18, 17};
                break;
            }
            case 65: {
                fontCharsWidth = new short[]{29, 28, 33, 28, 29, 28, 37, 28, 5, 8, 29, 20, 39, 28, 37, 29, 38, 29, 20, 29, 29, 28, 42, 29, 29, 30, 28, 29, 28, 27, 33, 33, 29, 29, 29, 29, 12, 8, 8, 20, 29, 37, 38, 37, 28, 29, 30, 28, 20, 20, 29, 29, 28};
                break;
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, (int)fontCharsWidth[0]);
    }

    private static GFont createGFontInfo(Image gFontImg) {
        char[] fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c2', '\u00c4', '\u00c7', '\u010c', '\u010e', '\u00cb', '\u00c9', '\u00c8', '\u00cf', '\u00cd', '\u00cc', '\u013d', '\u0147', '\u00d6', '\u00d3', '\u00d2', '\u00dc', '\u00da', '\u00d9', '\u0158', '\u0160', '\u015a', '\u0164', '\u00dd', '\u017d', '$', '#', '*', '@', '\\', '[', '(', '{', '}', ')', ']', '|', '\u2014', '\u00f7', '%', '<', '>', '+', '-', '=', ';', ',', '.', ':', '\"', '\'', '!', '?', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0110', '\u2044'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 1;
        switch (gFontImg.getHeight()) {
            case 20: {
                fontCharsWidth = new short[]{11, 8, 9, 9, 8, 8, 11, 9, 5, 8, 8, 7, 11, 9, 11, 8, 11, 8, 9, 8, 10, 11, 14, 12, 8, 11, 11, 12, 11, 12, 9, 9, 10, 8, 7, 8, 6, 5, 5, 8, 10, 11, 12, 12, 9, 9, 9, 8, 9, 8, 9, 8, 11, 8, 11, 7, 16, 5, 4, 4, 5, 5, 4, 3, 2, 9, 7, 9, 7, 7, 6, 6, 7, 3, 2, 3, 3, 3, 6, 4, 6, 9, 7, 7, 7, 8, 8, 7, 8, 8, 7, 10, 8};
                break;
            }
            case 32: {
                fontCharsWidth = new short[]{21, 14, 17, 17, 14, 14, 22, 17, 9, 14, 16, 13, 20, 17, 23, 13, 22, 16, 14, 17, 17, 21, 29, 19, 18, 19, 24, 21, 21, 22, 18, 18, 17, 15, 14, 14, 11, 10, 10, 14, 18, 22, 22, 22, 16, 17, 17, 15, 16, 16, 17, 17, 19, 16, 21, 13, 29, 12, 7, 7, 9, 9, 7, 7, 4, 15, 13, 17, 14, 12, 13, 11, 13, 6, 6, 5, 6, 5, 12, 4, 14, 17, 11, 15, 13, 14, 15, 15, 15, 14, 14, 17, 15};
                break;
            }
            case 39: {
                fontCharsWidth = new short[]{22, 14, 19, 18, 15, 15, 22, 17, 10, 15, 17, 13, 21, 18, 23, 14, 22, 16, 16, 17, 17, 21, 30, 21, 18, 20, 23, 23, 23, 21, 19, 18, 18, 15, 15, 15, 12, 10, 10, 15, 18, 23, 23, 23, 17, 18, 18, 16, 16, 16, 17, 18, 20, 16, 21, 14, 30, 11, 8, 8, 9, 9, 7, 8, 4, 16, 14, 17, 14, 14, 13, 11, 13, 6, 5, 6, 5, 5, 13, 5, 14, 18, 11, 16, 13, 15, 16, 15, 16, 14, 15, 18, 17};
                break;
            }
            case 72: {
                fontCharsWidth = new short[]{40, 27, 33, 31, 28, 26, 39, 31, 17, 26, 31, 22, 39, 30, 41, 26, 40, 28, 29, 30, 32, 37, 53, 38, 33, 36, 41, 42, 40, 40, 33, 34, 31, 27, 26, 27, 22, 18, 18, 25, 33, 41, 41, 40, 32, 31, 30, 28, 30, 29, 29, 32, 37, 29, 39, 24, 54, 18, 14, 14, 16, 17, 13, 12, 6, 29, 25, 31, 25, 26, 22, 18, 26, 10, 10, 10, 8, 10, 19, 8, 25, 32, 19, 27, 25, 26, 28, 27, 29, 25, 27, 31, 29};
                break;
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, (int)fontCharsWidth[0]);
    }

    private static GFont createGFontGame(Image gFontImg) {
        char[] fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c2', '\u00c4', '\u00c7', '\u010c', '\u010e', '\u00cb', '\u00c9', '\u00c8', '\u00cf', '\u00cd', '\u00cc', '\u013d', '\u0147', '\u00d6', '\u00d3', '\u00d2', '\u00dc', '\u00da', '\u00d9', '\u0158', '\u0160', '\u015a', '\u0164', '\u00dd'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 0;
        switch (gFontImg.getHeight()) {
            case 13: {
                fontCharsWidth = new short[]{9, 7, 8, 7, 7, 6, 10, 7, 5, 6, 7, 7, 9, 8, 9, 7, 9, 7, 7, 7, 8, 9, 12, 8, 9, 8, 9, 10, 9, 9, 8, 8, 7, 7, 6, 7, 5, 5, 5, 5, 8, 9, 10, 10, 7, 8, 8, 7, 7, 7, 7, 8, 8};
                break;
            }
            case 21: {
                fontCharsWidth = new short[]{13, 9, 12, 12, 10, 10, 14, 11, 7, 9, 10, 9, 14, 11, 14, 9, 14, 10, 10, 11, 10, 13, 18, 14, 11, 13, 14, 14, 14, 13, 12, 11, 11, 11, 10, 10, 7, 7, 6, 9, 12, 14, 13, 16, 11, 10, 11, 10, 10, 11, 10, 11, 12};
                break;
            }
            case 32: {
                fontCharsWidth = new short[]{20, 13, 17, 15, 14, 13, 21, 15, 9, 14, 15, 12, 19, 16, 21, 13, 21, 14, 14, 15, 16, 18, 26, 19, 17, 17, 21, 21, 20, 21, 17, 17, 15, 14, 14, 13, 11, 8, 10, 12, 17, 20, 21, 21, 15, 16, 16, 14, 15, 15, 16, 17, 18};
                break;
            }
            case 55: {
                fontCharsWidth = new short[]{33, 21, 28, 26, 22, 21, 34, 24, 14, 22, 24, 20, 32, 27, 34, 22, 33, 23, 24, 25, 25, 30, 44, 31, 28, 30, 34, 34, 35, 34, 28, 27, 26, 22, 21, 22, 19, 15, 15, 20, 27, 34, 32, 35, 25, 25, 26, 22, 23, 23, 27, 26, 30};
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, (int)fontCharsWidth[0]);
    }

    public static void loadGFont(int gFontIdx) {
        Image gFontImg = null;
        if (resGFonts[gFontIdx] != null) {
            return;
        }
        switch (gFontIdx) {
            case 0: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fnt.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontMain(gFontImg);
                break;
            }
            case 1: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fntInstruction.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontInfo(gFontImg);
                break;
            }
            case 2: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fntColorB.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontGame(gFontImg);
                break;
            }
            case 3: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fntColorG.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontGame(gFontImg);
                break;
            }
            case 4: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fntColorR.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontGame(gFontImg);
                break;
            }
            case 5: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fntColorO.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontGame(gFontImg);
            }
        }
    }

    public static void freeGFont(int gFontIdx) {
        Resources.resGFonts[gFontIdx] = null;
    }

    public static void loadGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.loadGFont(gFontsIdx[i]);
        }
    }

    public static void freeGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.resGFonts[gFontsIdx[i]] = null;
        }
    }

    public static void initLangDirs(String langCode) {
        langDir = "/lang/" + langCode + "/";
        if (langCode == "ru" || langCode == "cn") {
            sysFont = true;
        }
    }

    public static void loadText(int textIdx) {
        String textPath = null;
        switch (textIdx) {
            case 0: {
                textPath = langDir + "m.csr";
            }
        }
        Resources.resTexts[textIdx] = new ResourceBundle(X.singleton, textPath);
    }

    public static void freeText(int textIdx) {
        Resources.resTexts[textIdx] = null;
    }

    static {
        widht = 0;
    }
}

