/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import sk.inlogic.ColorTile;
import sk.inlogic.Resources;
import sk.inlogic.rms.RMSHandler;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Game
implements RMSHandler {
    private static final int _STATUS_INITLEVEL = 0;
    private static final int _STATUS_READY = 1;
    private static final int _STATUS_LEVELDONE = 2;
    private static final int _STATUS_GAMEOVER = 3;
    public static final int _COLOR_BLUE = 0;
    public static final int _COLOR_GREEN = 1;
    public static final int _COLOR_ORANGE = 2;
    public static final int _COLOR_RED = 3;
    public static final int _TOTAL_COLOR = 4;
    private int RANDOM_RANGE = 120;
    private int RANDOM_RATIO = 30;
    private int _iStatus;
    private int _iScore;
    private int _iDefaultTime = 3000;
    private int _iActualTime = 0;
    private int _iActualColor = 0;
    private int _iActualTextColor = 0;
    private String _sColor = "BLUE";
    public static Rectangle _rectGameArea;
    private Rectangle _rectActualColor;
    private Rectangle[] _rectColor = new Rectangle[4];
    private Image _imgTile;
    private Image _imgBorder;
    private ColorTile[] _colors = new ColorTile[4];
    private PreparedText _ptColor;
    private boolean _pressed = false;

    public Game() {
        this.initVar();
    }

    public void restartGame(Rectangle _rectArea) {
        _rectGameArea = _rectArea;
        this.initVar();
        this.initFnt();
        this.initImage();
        this.calucalteRectangles();
        for (int _iIdx = 0; _iIdx < 4; ++_iIdx) {
            this._colors[_iIdx] = new ColorTile(this._rectColor[_iIdx], _iIdx);
        }
        this.setRandomColor();
        this.reshuffle();
    }

    private void initVar() {
        this._iStatus = 0;
        this._iScore = 0;
        this._iDefaultTime = 3000;
        this._iActualTime = 0;
    }

    private void initImage() {
        if (this._imgTile == null) {
            this._imgTile = Resources.resImgs[9];
        }
        if (this._imgBorder == null) {
            this._imgBorder = Resources.resImgs[6];
        }
    }

    private void initFnt() {
        this._ptColor = new PreparedText(Resources.resGFonts[0]);
    }

    private void calucalteRectangles() {
        this._rectColor[0] = new Rectangle(Game._rectGameArea.x, Game._rectGameArea.y, this._imgTile.getWidth(), this._imgTile.getHeight());
        this._rectColor[1] = new Rectangle(Game._rectGameArea.x + this._imgTile.getWidth(), Game._rectGameArea.y, this._imgTile.getWidth(), this._imgTile.getHeight());
        this._rectColor[2] = new Rectangle(Game._rectGameArea.x, Game._rectGameArea.y + this._imgTile.getHeight(), this._imgTile.getWidth(), this._imgTile.getHeight());
        this._rectColor[3] = new Rectangle(Game._rectGameArea.x + this._imgTile.getWidth(), Game._rectGameArea.y + this._imgTile.getHeight(), this._imgTile.getWidth(), this._imgTile.getHeight());
        this._rectActualColor = new Rectangle(_rectGameArea.getCenterX() - (this._imgBorder.getWidth() >> 1), _rectGameArea.getCenterY() - (this._imgBorder.getHeight() >> 1), this._imgBorder.getWidth(), this._imgBorder.getHeight());
    }

    private void setRandomColor() {
        this._iActualColor = this.getRandomColor();
        this._iActualTextColor = this.getRandomColor();
        while (this._iActualColor == this._iActualTextColor) {
            this._iActualTextColor = this.getRandomColor();
        }
        this.setFontColor(this._iActualTextColor);
        this.setFontTxt(this._iActualColor);
        System.out.println("_iActualColor: " + this._iActualColor);
    }

    private void reshuffle() {
        int _iIdx;
        int[] _iTmpNewColor = new int[4];
        this.setRandomColor();
        for (_iIdx = 0; _iIdx < 4; ++_iIdx) {
            _iTmpNewColor[_iIdx] = this.getRandomColor();
        }
        _iTmpNewColor[0] = this.getRandomColor();
        while (_iTmpNewColor[0] == _iTmpNewColor[1]) {
            _iTmpNewColor[1] = this.getRandomColor();
        }
        while (_iTmpNewColor[0] == _iTmpNewColor[2] || _iTmpNewColor[1] == _iTmpNewColor[2]) {
            _iTmpNewColor[2] = this.getRandomColor();
        }
        while (_iTmpNewColor[0] == _iTmpNewColor[3] || _iTmpNewColor[1] == _iTmpNewColor[3] || _iTmpNewColor[2] == _iTmpNewColor[3]) {
            _iTmpNewColor[3] = this.getRandomColor();
        }
        for (_iIdx = 0; _iIdx < 4; ++_iIdx) {
            this._colors[_iIdx].setColor(_iTmpNewColor[_iIdx]);
        }
    }

    private void setFontColor(int Color) {
        switch (Color) {
            case 0: {
                this._ptColor = new PreparedText(Resources.resGFonts[2]);
                break;
            }
            case 1: {
                this._ptColor = new PreparedText(Resources.resGFonts[3]);
                break;
            }
            case 2: {
                this._ptColor = new PreparedText(Resources.resGFonts[5]);
                break;
            }
            case 3: {
                this._ptColor = new PreparedText(Resources.resGFonts[4]);
            }
        }
    }

    private void setFontTxt(int Color) {
        switch (Color) {
            case 0: {
                this._sColor = Resources.resTexts[0].getHashedString(81);
                break;
            }
            case 1: {
                this._sColor = Resources.resTexts[0].getHashedString(82);
                break;
            }
            case 2: {
                this._sColor = Resources.resTexts[0].getHashedString(83);
                break;
            }
            case 3: {
                this._sColor = Resources.resTexts[0].getHashedString(80);
            }
        }
    }

    private int getRandomColor() {
        int _iTmpColor = RandomNum.getRandomInt(this.RANDOM_RANGE, 0);
        if (_iTmpColor < 0) {
            _iTmpColor *= -1;
        }
        if (_iTmpColor < this.RANDOM_RATIO) {
            return 0;
        }
        if (_iTmpColor < 2 * this.RANDOM_RATIO) {
            return 1;
        }
        if (_iTmpColor < 3 * this.RANDOM_RATIO) {
            return 2;
        }
        if (_iTmpColor < 4 * this.RANDOM_RATIO) {
            return 3;
        }
        return 0;
    }

    public void update(long lastRunLenght) {
        if (this._iStatus != 0) {
            if (this._iStatus == 1) {
                if (this._iActualTime >= this._iDefaultTime) {
                    this._iStatus = 3;
                }
                System.out.println("_iActualTime: " + this._iActualTime);
                this._iActualTime = (int)((long)this._iActualTime + lastRunLenght);
            } else if (this._iStatus == 2 || this._iStatus == 3) {
                // empty if block
            }
        }
    }

    public void paint(Graphics g) {
        this.paintColorTiles(g);
        this.paintActualColor(g);
        this.paintRectangles(g);
    }

    private void paintColorTiles(Graphics g) {
        if (this._iStatus != 3) {
            for (int _iIdx = 0; _iIdx < 4; ++_iIdx) {
                if (this._colors[_iIdx] == null) continue;
                this._colors[_iIdx].paint(g);
            }
        }
    }

    private void paintActualColor(Graphics g) {
        this.paintColorBorder(g);
        this.paintColorTxt(g);
    }

    private void paintColorBorder(Graphics g) {
        g.drawImage(this._imgBorder, this._rectActualColor.getCenterX(), this._rectActualColor.getCenterY(), 3);
    }

    private void paintColorTxt(Graphics g) {
        this._ptColor.prepareText(this._sColor, this._rectActualColor.width);
        this._ptColor.drawText(g, this._rectActualColor, 0, 3);
    }

    private void paintRectangles(Graphics g) {
        for (int _iIdx = 0; _iIdx < 4; ++_iIdx) {
            this._ptColor.prepareText("" + this._colors[_iIdx].getColor(), this._rectActualColor.width);
            this._ptColor.drawText(g, this._rectColor[_iIdx], 0, 3);
        }
    }

    public void selectFirstColor() {
        this.checkInput(0);
    }

    public void selectSecondColor() {
        this.checkInput(1);
    }

    public void selectThirdColor() {
        this.checkInput(2);
    }

    public void selectFourthColor() {
        this.checkInput(3);
    }

    private void checkInput(int _tile) {
        if (this._iStatus == 0) {
            this._iStatus = 1;
        }
        if (this._colors[_tile].getColor() == this._iActualColor) {
            this.reshuffle();
            this.incScore(1);
            this._iActualTime = 0;
        } else {
            this._iStatus = 3;
        }
    }

    public void pointerPressed(int x, int y) {
        this._pressed = true;
    }

    public void pointerReleased(int x, int y) {
        if (this._pressed) {
            this._pressed = false;
            for (int _iIdx = 0; _iIdx < this._rectColor.length; ++_iIdx) {
                if (!this._rectColor[_iIdx].contains(x, y)) continue;
                this.checkInput(_iIdx);
                return;
            }
        }
    }

    public void incScore(int _iSc) {
        this._iScore += _iSc;
    }

    public void setScore(int _iSc) {
        this._iScore = _iSc;
    }

    public int getScore() {
        return this._iScore;
    }

    public boolean isGameOver() {
        return this._iStatus == 3;
    }

    public boolean isLevelDone() {
        return this._iStatus == 2;
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
    }
}

