/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenGame;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenMenu
implements IScreen {
    private MainCanvas mainCanvas;
    public static final int COMP_ID_PLAY = 0;
    public static final int COMP_ID_INSTRUCTIONS = 1;
    public static final int COMP_ID_SCORE = 2;
    public static final int COMP_ID_ABOUT = 3;
    private static final int COMP_ID_SETTINGS = 4;
    private static final int COMP_ID_QUIT = 5;
    public static final int COMP_ID_NONE = 6;
    private static final int TOTAL_COMP_IDS = 7;
    public static final int COMP_ID_PLAY_TXT = 0;
    public static final int COMP_ID_INSTRUCTIONS_TXT = 1;
    public static final int COMP_ID_SCORE_TXT = 2;
    public static final int COMP_ID_ABOUT_TXT = 3;
    public static final int COMP_ID_NONE_TXT = 6;
    private static final int TOTAL_COMP_IDS_TXT = 7;
    private int actualSceen = 0;
    private static final int SCREEN_MAIN_MENU = 0;
    private static final int SCREEN_INSTRUCTIONS = 1;
    private static final int SCREEN_ABOUT = 2;
    private static final int SCREEN_START_GAME = 3;
    private static final int SCREEN_QUIT_GAME = 4;
    private Rectangle[] rectItems = new Rectangle[7];
    private Rectangle[] rectItems_TXT = new Rectangle[7];
    private int[][] _animationSequence = new int[5][9];
    private AnimationComponent[] _animationComponents = new AnimationComponent[13];
    private Rectangle rectBB_BACK;
    private Rectangle rectBB_MENU;
    private Rectangle rectTopBig;
    private Rectangle rectTopLittle;
    private Rectangle rectTopLittleTXT;
    private Rectangle rectTitle;
    private Rectangle rectPanel;
    private Rectangle rectText;
    private int selectedCompId;
    private int selectorCompId;
    private int interuption = 0;
    private boolean scrollUP = false;
    private boolean scrollDOWN = true;
    private boolean needRepaint = false;
    private boolean activeButton = true;
    PreparedText _ptMenuItem;
    PreparedText navigationKeysBB;
    PreparedText title;
    PreparedText instruction;
    PreparedText _ptVersionOfGame;
    private int textOffsetY;
    private Image _imgGameLogo;
    private Image _imgCorpLogo;
    private Image _imgButton;
    private Image _imgButtonSelector;
    private Sprite _sprIcons;
    private Sprite _sprArrows;
    private static int _WIDTH = 0;
    private static int _HEIGHT = 0;
    private static int _totalRowTiles = 0;
    private static int _totalColTiles = 0;
    boolean check = false;
    int _finalHeight;
    int _off;
    int cycle = 10;
    private int musicControler = 0;
    private int _sequenceStop = 0;
    private int _sequenceShow = 1;
    private int _sequenceHide = 2;
    private int _sequence = 0;
    boolean changeSequence = false;
    private int nextScreen;
    int a;
    private boolean releasedTouch = false;
    private int sel = this.selectedCompId;
    private int s = this.selectedCompId;
    private int force = this.selectedCompId;
    int posX = 0;
    int posY = 0;

    public ScreenMenu(MainCanvas mainCanvas, int selectedItem) {
        MainCanvas.counterX = 0;
        MainCanvas.counterY = 0;
        MainCanvas.slcPack = 0;
        this.actualSceen = 0;
        this.mainCanvas = mainCanvas;
        this.initDimensions();
        this.selectedCompId = selectedItem;
        this.selectorCompId = selectedItem;
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{1, 0, 5, 7});
        Resources.loadSprites(new int[]{0, 2});
        Resources.loadGFonts(new int[]{0, 1});
        Resources.loadText(0);
        this.initImages();
        this.initSprites();
        this.initTxt();
        this.calculatePositions();
        this.prepareTxt();
        this.initAnimationSequences();
        this.initAnimationComponents();
    }

    public void afterHide() {
        this.freeGraphics();
        Resources.freeImages(new int[]{1, 0, 5, 7});
        Resources.freeSprites(new int[]{0, 2});
        Resources.freeGFonts(new int[]{0, 1});
    }

    private void initDimensions() {
        _WIDTH = this.mainCanvas.getWidth();
        _HEIGHT = this.mainCanvas.getHeight();
    }

    private void initImages() {
        this._imgGameLogo = Resources.resImgs[1];
        this._imgCorpLogo = Resources.resImgs[0];
        this._imgButton = Resources.resImgs[5];
        this._imgButtonSelector = Resources.resImgs[7];
    }

    private void initSprites() {
        this._sprArrows = Resources.resSprs[2];
        this._sprIcons = Resources.resSprs[0];
    }

    public void initTxt() {
        this._ptMenuItem = new PreparedText(Resources.resGFonts[0]);
        this._ptVersionOfGame = new PreparedText(Resources.resGFonts[1]);
        this.instruction = new PreparedText(Resources.resGFonts[1]);
        this.navigationKeysBB = new PreparedText(Resources.resGFonts[1]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 0;
        this._animationSequence[0][1] = 1;
        this._animationSequence[0][2] = 2;
        this._animationSequence[0][3] = 3;
        this._animationSequence[0][4] = 4;
        this._animationSequence[0][5] = 5;
        this._animationSequence[0][6] = 6;
        this._animationSequence[0][7] = 7;
        this._animationSequence[0][8] = 8;
        this._animationSequence[1][0] = 9;
        this._animationSequence[1][1] = 10;
        this._animationSequence[1][2] = 11;
        this._animationSequence[1][3] = 12;
        this._animationSequence[1][4] = -1;
        this._animationSequence[1][5] = -1;
        this._animationSequence[1][6] = -1;
        this._animationSequence[1][7] = -1;
        this._animationSequence[1][8] = -1;
        this._animationSequence[2][0] = 9;
        this._animationSequence[2][1] = 10;
        this._animationSequence[2][2] = 12;
        this._animationSequence[2][3] = -1;
        this._animationSequence[2][4] = -1;
        this._animationSequence[2][5] = -1;
        this._animationSequence[2][6] = -1;
        this._animationSequence[2][7] = -1;
        this._animationSequence[2][8] = -1;
        this._animationSequence[4][0] = 9;
        this._animationSequence[4][1] = 10;
        this._animationSequence[4][2] = 12;
        this._animationSequence[4][3] = 11;
        this._animationSequence[4][4] = -1;
        this._animationSequence[4][5] = -1;
        this._animationSequence[4][6] = -1;
        this._animationSequence[4][7] = -1;
        this._animationSequence[4][8] = -1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this.rectItems[0], _WIDTH, _HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectItems_TXT[0], _WIDTH, _HEIGHT);
        this._animationComponents[0].startShowAnimation(0);
        this._animationComponents[1].startShowAnimation(0);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectItems[1], _WIDTH, _HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this.rectItems_TXT[1], _WIDTH, _HEIGHT);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this.rectItems[2], _WIDTH, _HEIGHT);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this.rectItems_TXT[2], _WIDTH, _HEIGHT);
        this._animationComponents[4].startShowAnimation(0);
        this._animationComponents[5].startShowAnimation(0);
        this._animationComponents[6] = new AnimationComponent(this.mainCanvas, this.rectItems[3], _WIDTH, _HEIGHT);
        this._animationComponents[7] = new AnimationComponent(this.mainCanvas, this.rectItems_TXT[3], _WIDTH, _HEIGHT);
        this._animationComponents[6].startShowAnimation(1);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8] = new AnimationComponent(this.mainCanvas, this.rectTopBig, _WIDTH, _HEIGHT);
        this._animationComponents[8].startShowAnimation(2);
        this._animationComponents[9] = new AnimationComponent(this.mainCanvas, this.rectTopLittle, _WIDTH, _HEIGHT);
        this._animationComponents[9].startShowAnimation(2);
        this._animationComponents[10] = new AnimationComponent(this.mainCanvas, this.rectPanel, _WIDTH, _HEIGHT);
        this._animationComponents[10].startShowAnimation(3);
        this._animationComponents[11] = new AnimationComponent(this.mainCanvas, this.rectText, _WIDTH, _HEIGHT);
        this._animationComponents[11].startShowAnimation(3);
        this._animationComponents[12] = new AnimationComponent(this.mainCanvas, this.rectTopLittleTXT, _WIDTH, _HEIGHT);
        this._animationComponents[12].startShowAnimation(2);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(0);
        this._animationComponents[1].startShowAnimation(0);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(0);
        this._animationComponents[5].startShowAnimation(0);
        this._animationComponents[6].startShowAnimation(1);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8].startShowAnimation(2);
        this._animationComponents[9].startShowAnimation(2);
        this._animationComponents[10].startShowAnimation(3);
        this._animationComponents[11].startShowAnimation(3);
        this._animationComponents[12].startShowAnimation(2);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(0);
        this._animationComponents[1].startHideAnimation(0);
        this._animationComponents[2].startHideAnimation(1);
        this._animationComponents[3].startHideAnimation(1);
        this._animationComponents[4].startHideAnimation(0);
        this._animationComponents[5].startHideAnimation(0);
        this._animationComponents[6].startHideAnimation(1);
        this._animationComponents[7].startHideAnimation(1);
        this._animationComponents[8].startHideAnimation(2);
        this._animationComponents[9].startHideAnimation(2);
        this._animationComponents[10].startHideAnimation(3);
        this._animationComponents[11].startHideAnimation(3);
        this._animationComponents[12].startHideAnimation(2);
    }

    private void freeGraphics() {
        this._imgGameLogo = null;
        this._imgCorpLogo = null;
        this._imgButtonSelector = null;
        this._imgButton = null;
        this._sprIcons = null;
        this._sprArrows = null;
    }

    public void prepareTxt() {
        String controls = "";
        this.textOffsetY = 0;
        controls = Resources.resTexts[0].getHashedString(16);
        this._ptVersionOfGame.prepareText(X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + ", " + X.singleton.getAppProperty("MIDlet-Version"), this.rectPanel.width);
        this.instruction.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + controls + "\n\n", this.rectText.width);
        this.instruction.setLineHeightCorrection(-2);
    }

    public void beforeInteruption() {
        this.check = MainCanvas.soundManager.IsSoundOn();
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        this.musicControler = 0;
        System.out.println("hehe2");
    }

    private void calculatePositions() {
        int itemHeight = Resources.resGFonts[0].getHeight();
        int itemWidth = _WIDTH;
        int posX = _WIDTH >> 1;
        int posY = (_HEIGHT >> 1) - (itemHeight << 1);
        int rectPanelY = this._imgButton.getHeight();
        int rectTextOffsetX = this._sprIcons.getWidth();
        int rectTextOffsetY = this._sprIcons.getHeight();
        this.rectPanel = new Rectangle(0, rectPanelY, _WIDTH, _HEIGHT - rectPanelY);
        this.rectText = new Rectangle(rectTextOffsetX, this.rectPanel.y + rectTextOffsetY, _WIDTH - (rectTextOffsetX << 1), this.rectPanel.height - (this.rectPanel.y + rectTextOffsetY));
        this.rectTitle = new Rectangle(posX, itemHeight / 2, itemWidth, itemHeight);
        posX = 0;
        posY = this._imgGameLogo.getHeight() + (_HEIGHT - this._imgGameLogo.getHeight() - 4 * (itemHeight + (this._imgButton.getHeight() >> 1)) >> 1);
        this.rectItems[0] = new Rectangle(posX, posY, itemWidth, itemHeight);
        this.rectItems[1] = new Rectangle(posX, posY += itemHeight + (this._imgButton.getHeight() >> 1), itemWidth, itemHeight);
        this.rectItems[2] = new Rectangle(posX, posY += itemHeight + (this._imgButton.getHeight() >> 1), itemWidth, itemHeight);
        this.rectItems[3] = new Rectangle(posX, posY += itemHeight + (this._imgButton.getHeight() >> 1), itemWidth, itemHeight);
        this.rectItems[5] = new Rectangle(_WIDTH - this._sprIcons.getWidth() - (this._sprIcons.getWidth() >> 1), MainCanvas.HEIGHT - itemHeight, this._sprIcons.getWidth() + (this._sprIcons.getWidth() >> 1), itemHeight);
        this.rectItems[4] = new Rectangle(this._sprIcons.getWidth() - (this._sprIcons.getWidth() >> 1), MainCanvas.HEIGHT - itemHeight, this._sprIcons.getWidth() + (this._sprIcons.getWidth() >> 1), itemHeight);
        posX = 0;
        posY = this._imgGameLogo.getHeight() + (_HEIGHT - this._imgGameLogo.getHeight() - 4 * (itemHeight + itemHeight / 10 + this._imgButton.getHeight()) >> 1);
        this.rectItems_TXT[0] = new Rectangle(posX + (this._sprIcons.getWidth() + (this._sprIcons.getWidth() >> 2)), posY, itemWidth, itemHeight);
        this.rectItems_TXT[1] = new Rectangle(posX + (this._sprIcons.getWidth() + (this._sprIcons.getWidth() >> 2)), posY += itemHeight + (this._imgButton.getHeight() >> 1), itemWidth, itemHeight);
        this.rectItems_TXT[2] = new Rectangle(posX + (this._sprIcons.getWidth() + (this._sprIcons.getWidth() >> 2)), posY += itemHeight + (this._imgButton.getHeight() >> 1), itemWidth, itemHeight);
        this.rectItems_TXT[3] = new Rectangle(posX + (this._sprIcons.getWidth() + (this._sprIcons.getWidth() >> 2)), posY += itemHeight + (this._imgButton.getHeight() >> 1), itemWidth, itemHeight);
        this.rectBB_BACK = new Rectangle(0, MainCanvas.HEIGHT - itemHeight, _WIDTH - this._sprIcons.getWidth(), itemHeight);
        this.rectBB_MENU = new Rectangle(this._sprIcons.getWidth(), MainCanvas.HEIGHT - itemHeight, _WIDTH, itemHeight);
        this.rectTopBig = new Rectangle(_WIDTH >> 1, this.rectItems[0].y - this._imgGameLogo.getHeight() >> 1, this._imgGameLogo.getWidth(), this._imgGameLogo.getHeight());
        this.rectTopLittle = new Rectangle((_WIDTH >> 1) - (this._imgButton.getWidth() >> 1), 0, this._imgButton.getWidth(), rectPanelY);
        this.rectTopLittleTXT = new Rectangle((_WIDTH >> 1) - (this._imgButton.getWidth() >> 1), 0, this._imgButton.getWidth(), rectPanelY);
    }

    public void update(long lastRunLenght) {
        this.musicInteruptUpdate();
        this.animationController();
        this.animationComponentsUpdate();
        if (this.actualSceen == 1) {
            this.textMove();
            if (this.needRepaint) {
                this.mainCanvas.repaint();
            }
        }
    }

    private boolean animationController() {
        if (this.changeSequence) {
            if (this._sequence == this._sequenceShow) {
                this.showAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceHide) {
                this.hideAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceStop) {
                this.changeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationSequence[this.actualSceen].length; ++i) {
            if (this._animationSequence[this.actualSceen][i] == -1 || this._animationComponents[this._animationSequence[this.actualSceen][i]] == null || this._animationComponents[this._animationSequence[this.actualSceen][i]].isComponentAnimated()) continue;
            this._animationComponents[this._animationSequence[this.actualSceen][i]].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._sequence == this._sequenceHide) {
                this._sequence = this._sequenceShow;
                this.actualSceen = this.nextScreen;
                this.changeSequence = true;
            } else if (this._sequence == this._sequenceShow) {
                this._sequence = this._sequenceStop;
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextScreen) {
        this.changeSequence = changeSequencem;
        this.nextScreen = nextScreen;
        this._sequence = this._sequenceHide;
    }

    private void musicInteruptUpdate() {
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        switch (this.actualSceen) {
            case 0: {
                this.paintGameLogo(g);
                this.paintDialogItems(g);
                break;
            }
            case 1: {
                this.paintTop(g);
                this.paintInstrusctionTxt(g);
                this.paintArrows(g);
                break;
            }
            case 2: {
                this.paintTop(g);
                this.paintAboutLogo(g);
                break;
            }
            case 4: {
                this.paintQuit(g);
            }
        }
        this.paintFK(g);
    }

    public void paintBackground(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, _WIDTH, _HEIGHT);
    }

    public void paintTop(Graphics g) {
        switch (this.actualSceen) {
            case 1: {
                this._ptMenuItem.prepareText(Resources.resTexts[0].getHashedString(22), this.rectTitle.width);
                this._ptMenuItem.drawText(g, this.rectTopLittleTXT, 0, 3);
                break;
            }
            case 2: {
                this._ptMenuItem.prepareText(Resources.resTexts[0].getHashedString(23), this.rectTitle.width);
                this._ptMenuItem.drawText(g, this.rectTopLittleTXT, 0, 3);
                break;
            }
            case 4: {
                this._ptMenuItem.prepareText(Resources.resTexts[0].getHashedString(2), this.rectTitle.width);
                this._ptMenuItem.drawText(g, this.rectTopLittleTXT, 0, 3);
            }
        }
    }

    public void paintGameLogo(Graphics g) {
        g.drawImage(this._imgGameLogo, this.rectTopBig.x, this.rectTopBig.getCenterY(), 3);
    }

    private void paintButton(Graphics g, int _type, int frame, boolean active) {
        if (active) {
            g.drawImage(this._imgButtonSelector, this.rectItems[_type].getCenterX(), this.rectItems[_type].getCenterY(), 3);
        } else {
            g.drawImage(this._imgButton, this.rectItems[_type].getCenterX(), this.rectItems[_type].getCenterY(), 3);
        }
    }

    private void paintInstrusctionTxt(Graphics g) {
        this.instruction.drawText(g, this.rectText, this.textOffsetY, 20);
    }

    private void paintArrows(Graphics g) {
        if (this.scrollDOWN && this.scrollUP) {
            this._sprArrows.setPosition((this.rectPanel.x + this.rectPanel.width >> 1) - (this._sprArrows.getWidth() >> 2), this.rectPanel.y);
            this._sprArrows.setFrame(0);
            this._sprArrows.paint(g);
            this._sprArrows.setPosition((this.rectPanel.x + this.rectPanel.width >> 1) - (this._sprArrows.getWidth() >> 2), this.rectPanel.y + this.rectPanel.height - this._sprArrows.getWidth());
            this._sprArrows.setFrame(1);
            this._sprArrows.paint(g);
        } else if (!this.scrollDOWN && this.scrollUP) {
            this._sprArrows.setPosition((this.rectPanel.x + this.rectPanel.width >> 1) - (this._sprArrows.getWidth() >> 2), this.rectPanel.y);
            this._sprArrows.setFrame(0);
            this._sprArrows.paint(g);
        }
        if (this.scrollDOWN && !this.scrollUP) {
            this._sprArrows.setPosition((this.rectPanel.x + this.rectPanel.width >> 1) - (this._sprArrows.getWidth() >> 2), this.rectPanel.y + this.rectPanel.height - this._sprArrows.getWidth());
            this._sprArrows.setFrame(1);
            this._sprArrows.paint(g);
        }
    }

    private void paintAboutLogo(Graphics g) {
        g.drawImage(this._imgCorpLogo, this.rectPanel.getCenterX(), this.rectPanel.getCenterY(), 3);
        this._ptVersionOfGame.drawText(g, this.rectPanel, this._sprIcons.getHeight() << 1, 33);
    }

    private void paintQuit(Graphics g) {
        this._ptMenuItem.prepareText(Resources.resTexts[0].getHashedString(2), this.rectItems[1].width);
        this._ptMenuItem.drawText(g, this.rectText, 0, 3);
    }

    private void paintFK(Graphics g) {
        if (this.actualSceen == 0) {
            this._sprIcons.setFrame(5);
        } else {
            this._sprIcons.setFrame(9);
        }
        this._sprIcons.setPosition(this.mainCanvas.getWidth() - this._sprIcons.getWidth(), _HEIGHT - this._sprIcons.getHeight());
        this._sprIcons.paint(g);
        if (this.actualSceen == 4) {
            this._sprIcons.setFrame(7);
            this._sprIcons.setPosition(0, _HEIGHT - this._sprIcons.getHeight());
            this._sprIcons.paint(g);
        }
    }

    private void paintDialogItems(Graphics g) {
        if (this.selectedCompId == 0) {
            this.paintButton(g, this.selectedCompId, 0, true);
            this._ptMenuItem.prepareText(Resources.resTexts[0].getHashedString(21), this.rectItems[1].width);
            this._ptMenuItem.drawText(g, this.rectItems[0], 0, 3);
        } else {
            this.paintButton(g, 0, 0, false);
            this._ptMenuItem.prepareText(Resources.resTexts[0].getHashedString(21), this.rectItems[1].width);
            this._ptMenuItem.drawText(g, this.rectItems[0], 0, 3);
        }
        if (this.selectedCompId == 1) {
            this.paintButton(g, this.selectedCompId, 1, true);
            this._ptMenuItem.prepareText(Resources.resTexts[0].getHashedString(22), this.rectItems[1].width);
            this._ptMenuItem.drawText(g, this.rectItems[1], 0, 3);
        } else {
            this.paintButton(g, 1, 1, false);
            this._ptMenuItem.prepareText(Resources.resTexts[0].getHashedString(22), this.rectItems[1].width);
            this._ptMenuItem.drawText(g, this.rectItems[1], 0, 3);
        }
        if (this.selectedCompId == 2) {
            this.paintButton(g, this.selectedCompId, 1, true);
            this._ptMenuItem.prepareText(MainCanvas.soundManager.IsSoundOn() ? Resources.resTexts[0].getHashedString(26) : Resources.resTexts[0].getHashedString(27), this.rectItems[2].width);
            this._ptMenuItem.drawText(g, this.rectItems[2], 0, 3);
        } else {
            this.paintButton(g, 2, 1, false);
            this._ptMenuItem.prepareText(MainCanvas.soundManager.IsSoundOn() ? Resources.resTexts[0].getHashedString(26) : Resources.resTexts[0].getHashedString(27), this.rectItems[2].width);
            this._ptMenuItem.drawText(g, this.rectItems[2], 0, 3);
        }
        if (this.selectedCompId == 3) {
            this.paintButton(g, this.selectedCompId, 2, true);
            this._ptMenuItem.prepareText(Resources.resTexts[0].getHashedString(23), this.rectItems[3].width);
            this._ptMenuItem.drawText(g, this.rectItems[3], 0, 3);
        } else {
            this.paintButton(g, 3, 2, false);
            this._ptMenuItem.prepareText(Resources.resTexts[0].getHashedString(23), this.rectItems[3].width);
            this._ptMenuItem.drawText(g, this.rectItems[3], 0, 3);
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        block30: {
            block32: {
                block34: {
                    block33: {
                        block31: {
                            this.a = keyCode;
                            if (!this.activeButton) break block30;
                            if (!Keys.isFKRightCode(keyCode)) break block31;
                            switch (this.actualSceen) {
                                case 0: {
                                    this.startAnimation(true, 4);
                                    break;
                                }
                                case 1: {
                                    this.startAnimation(true, 0);
                                    break;
                                }
                                case 2: {
                                    this.startAnimation(true, 0);
                                    break;
                                }
                                case 4: {
                                    this.startAnimation(true, 0);
                                }
                            }
                            break block32;
                        }
                        if (!Keys.isFKLeftCode(keyCode)) break block33;
                        if (this.actualSceen == 4) {
                            X.quitApp();
                        }
                        break block32;
                    }
                    if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break block34;
                    block6 : switch (this.actualSceen) {
                        case 0: {
                            switch (this.selectedCompId) {
                                case 0: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 1;
                                        System.out.println("a teraz este dalej");
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(5, keyCode)) {
                                        ScreenGame sg = new ScreenGame(this.mainCanvas, true);
                                        this.mainCanvas.changeLastActiveScreen(sg);
                                        if (!MainCanvas.soundManager.IsSoundOn()) break block6;
                                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                                        break;
                                    }
                                    break block34;
                                }
                                case 1: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(5, keyCode)) {
                                        this.startAnimation(true, 1);
                                        break;
                                    }
                                    break block34;
                                }
                                case 2: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 1;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(5, keyCode)) {
                                        if (MainCanvas.soundManager.IsSoundOn()) {
                                            MainCanvas.soundManager.SetSoundOn(false);
                                            MainCanvas.soundManager.Stop();
                                            break;
                                        }
                                        MainCanvas.soundManager.SetSoundOn(true);
                                        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                                        break;
                                    }
                                    break block34;
                                }
                                case 3: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(5, keyCode)) {
                                        this.startAnimation(true, 2);
                                    } else {
                                        break;
                                    }
                                }
                            }
                            break;
                        }
                        case 1: {
                            if (!Keys.isActionGeneratedByKey(1, keyCode) && !Keys.isActionGeneratedByKey(2, keyCode)) break;
                        }
                    }
                }
                this.selectorCompId = this.selectedCompId;
                this.a = this.selectedCompId;
                this.force = this.selectedCompId;
            }
            this.mainCanvas.repaint();
        }
    }

    public void pointerPressed(int x, int y) {
        this.posX = x;
        this.posY = y;
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (i == 6) {
                this.selectorCompId = this.selectedCompId = 6;
                this.mainCanvas.repaint();
                break;
            }
            if (i == 6 || this.rectItems[i] == null || !this.rectItems[i].contains(x, y)) continue;
            this.sel = i <= 4 ? i : this.sel;
            this.selectedCompId = i;
            this.s = i;
            switch (this.selectedCompId) {
                case 4: {
                    break;
                }
                case 5: {
                    Keys.keyPressed(-7);
                    break;
                }
                default: {
                    this.selectorCompId = i;
                    this.a = this.selectedCompId;
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.actualSceen == 1) {
            System.out.println("SCROL");
            if (this.posY > y) {
                if (Resources.sysFont) {
                    this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                } else {
                    this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                }
                if (this.textOffsetY < 0) {
                    this.textOffsetY = 0;
                    this.scrollUP = false;
                    this.scrollDOWN = true;
                }
                this.needRepaint = true;
            } else if (this.posY < y) {
                int maxOffsetY = this.instruction.getTextHeight() - this.rectText.height;
                if (Resources.sysFont) {
                    this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                } else {
                    this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                }
                if (this.textOffsetY > maxOffsetY) {
                    this.textOffsetY = maxOffsetY;
                    this.scrollUP = true;
                    this.scrollDOWN = false;
                }
                this.needRepaint = true;
            }
        }
        if (this.selectedCompId != 6) {
            if (!this.rectItems[this.selectedCompId].contains(x, y)) {
                switch (this.selectedCompId) {
                    case 4: {
                        break;
                    }
                    case 5: {
                        Keys.keyReleased(-7);
                        break;
                    }
                    default: {
                        Keys.keyReleased(53);
                        break;
                    }
                }
            }
        } else {
            this.selectorCompId = this.selectedCompId = 6;
            this.mainCanvas.repaint();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.selectedCompId != 6) {
            switch (this.selectedCompId) {
                case 5: {
                    if (!Keys.isKeyPressed(-7)) break;
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                    break;
                }
                case 4: {
                    if (this.actualSceen != 4) break;
                    X.quitApp();
                    break;
                }
                default: {
                    this.activeButton = true;
                    if (!Keys.isKeyPressed(53)) break;
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
            }
        }
        this.selectorCompId = this.selectedCompId = 6;
        this.mainCanvas.repaint();
    }

    private void textMove() {
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY < 0) {
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
            }
            this.needRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = this.instruction.getTextHeight() - this.rectText.height;
            if (Resources.sysFont) {
                this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY > maxOffsetY) {
                this.textOffsetY = maxOffsetY;
                this.scrollUP = true;
                this.scrollDOWN = false;
            }
            this.needRepaint = true;
        }
    }
}

