/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.phone.ri.sensor;

import com.nokia.mid.appl.sa.io.common.SAPIException;
import com.nokia.mid.appl.sa.tool.Log;
import com.nokia.phone.ri.sensor.AbstractSensor;
import com.nokia.phone.ri.sensor.Accelerometer;
import com.nokia.phone.ri.sensor.ChannelImpl;
import com.nokia.phone.ri.sensor.SensorInfoImpl;
import com.nokia.sensor.interfaces.ChannelInfo;
import com.nokia.sensor.interfaces.Condition;
import com.nokia.sensor.interfaces.ConditionListener;
import com.nokia.sensor.interfaces.Data;
import com.nokia.sensor.interfaces.LimitCondition;
import com.nokia.sensor.interfaces.RangeCondition;
import com.nokia.sensor.interfaces.SensorConnection;
import com.nokia.sensor.interfaces.SensorInfo;
import com.nokia.sensor.interfaces.SensorListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SensorManagerImpl
implements Runnable,
SensorListener,
ConditionListener {
    private static final Object DUMMY = new Object();
    static boolean isDebug = true;
    private static final SensorInfoImpl[] NO_INFOS = new SensorInfoImpl[0];
    private static final String[] PERMISSIONS = new String[]{"javax.microedition.sensor.ProtectedSensor", "javax.microedition.sensor.PrivateSensor"};
    private static final String PUSHREGISTRY_ENTRY = "pushRegistryEntry";
    private static final char[] RESERVED = new char[]{';', '/', '?', ':', '@', '&', '=', '+', '$', ','};
    private static final String SCHEME_CHANNEL = "channel=";
    private static final String SCHEME_CONTEXT = "contextType=";
    private static final String SCHEME_LOCATION = "location=";
    private static final String SCHEME_MODEL = "model=";
    private static final String SCHEME_QUERY_SEP = "?";
    private static final String SCHEME_SENSOR = "sensor:";
    private static final String SCHEME_SEP = ":";
    private static final String SCHEME_SEP2 = ";";
    private static final String SCHEME_SEP3 = "&";
    private static final int SLEEP = System.getProperty("microedition.sensor.manager.sleep") == null ? 0 : Integer.parseInt(System.getProperty("microedition.sensor.manager.sleep"));
    private static final int L = "channel=".length();
    private static SensorManagerImpl _instance;
    private static Vector listenedSensorInfos;
    private static Vector listenedSensorConnections;
    private static Vector pushEntries;
    private static Vector sensorListeners;
    private static Hashtable sensors;
    private static Hashtable metConditions;
    private static Hashtable metData;

    static {
        listenedSensorInfos = new Vector();
        listenedSensorConnections = new Vector();
        pushEntries = new Vector();
        sensorListeners = new Vector();
        sensors = null;
        metConditions = null;
        metData = null;
    }

    private SensorManagerImpl() {
        new Thread(this).start();
    }

    public static SensorManagerImpl getInstance() {
        if (_instance == null) {
            _instance = new SensorManagerImpl();
        }
        return _instance;
    }

    public synchronized void addSensorListener(SensorListener listener, SensorInfo info) throws SecurityException, SAPIException {
        if (listener == null) {
            throw new NullPointerException("addSensorListener() called with null listener");
        }
        if (info == null) {
            throw new NullPointerException("addSensorListener() called with null info");
        }
        boolean isPushRegistryEntry = SensorManagerImpl.isPushRegistryEntry(info);
        SensorInfo[] infos = SensorManagerImpl.findSensors(info.getQuantity(), info.getContextType());
        if (infos.length == 0) {
            throw new IllegalArgumentException("SensorManager.addSensorListener(): an unknown SensorInfo tried to be registered.");
        }
        int i2 = 0;
        int l2 = infos.length;
        while (i2 < l2) {
            if (infos[i2] == info) break;
            ++i2;
        }
        if (i2 == l2) {
            throw new IllegalArgumentException("SensorManager.addSensorListener(): an unknown SensorInfo tried to be registered.");
        }
        int index = -1;
        index = SensorManagerImpl.getSensorListeners().indexOf(listener);
        if (index > -1) {
            Vector sensorsOfOneListener;
            block15: {
                sensorsOfOneListener = null;
                try {
                    sensorsOfOneListener = (Vector)listenedSensorInfos.elementAt(index);
                }
                catch (Exception e2) {
                    if (!isDebug) break block15;
                    e2.printStackTrace();
                }
            }
            if (sensorsOfOneListener.contains(info)) {
                if (isPushRegistryEntry) {
                    if (isDebug) {
                        System.out.println("PushRegistry entry already exists");
                    }
                    throw new RuntimeException("Sensor url to be registered already exists");
                }
                return;
            }
        } else {
            sensorListeners.addElement(listener);
            index = sensorListeners.size() - 1;
        }
        SensorManagerImpl.addInfo(info, index);
        Object o2 = DUMMY;
        boolean isAvailable = info.isAvailable();
        if (isAvailable) {
            o2 = this.getCheckedConnection(info);
        }
        SensorManagerImpl.addC(o2, index);
        if (isAvailable) {
            listener.sensorAvailable(info);
        } else {
            listener.sensorUnavailable(info);
        }
        this.notify();
    }

    public void addSensorListener(SensorListener listener, String quantity) throws SecurityException, SAPIException {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (quantity == null) {
            throw new NullPointerException();
        }
        SensorInfo[] infos = SensorManagerImpl.findSensors(quantity, null);
        int i2 = 0;
        int l2 = infos.length;
        while (i2 < l2) {
            this.addSensorListener(listener, infos[i2]);
            ++i2;
        }
    }

    public synchronized void blockUntilPushable(String url) {
        while (!SensorManagerImpl.isPushable(url)) {
            try {
                this.await();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public void conditionMet(SensorConnection sensor, Data data, Condition condition) {
        Vector entries = (Vector)sensor.getSensorInfo().getProperty(PUSHREGISTRY_ENTRY);
        String url = ConditionHandler.getMetUrl(entries, data.getChannelInfo(), condition);
        if (url == null) {
            return;
        }
        if (metConditions == null) {
            metConditions = new Hashtable();
        }
        if (metData == null) {
            metData = new Hashtable();
        }
        metConditions.put(sensor, condition);
        metData.put(sensor, data);
        this.removePushSensor(url);
        if (isDebug) {
            System.out.println("SensorManagerImpl: conditionMet " + url);
        }
        this.addPushEntry(url);
    }

    public static SensorInfo[] findSensors(String quantity, String contextType) throws SecurityException, SAPIException {
        if (!(contextType == null || contextType.equals("ambient") || contextType.equals("device") || contextType.equals("user"))) {
            throw new IllegalArgumentException("SensorManager.findSensors(): illegal contextType provided " + contextType);
        }
        Log.note("Find sensor: " + quantity);
        SensorInfo[] infos = SensorManagerImpl.findSensorsByQ(quantity);
        if (contextType == null) {
            return infos;
        }
        Vector<SensorInfo> checkedSensors = new Vector<SensorInfo>();
        int i2 = 0;
        int l2 = infos.length;
        while (i2 < l2) {
            String tmpContextType = infos[i2].getContextType();
            if (tmpContextType.equals(contextType)) {
                checkedSensors.addElement(infos[i2]);
            }
            ++i2;
        }
        int l3 = checkedSensors.size();
        if (l3 == 0) {
            return NO_INFOS;
        }
        infos = new SensorInfoImpl[l3];
        int i3 = 0;
        Enumeration e2 = checkedSensors.elements();
        while (e2.hasMoreElements()) {
            infos[i3] = (SensorInfoImpl)e2.nextElement();
            ++i3;
        }
        return infos;
    }

    public static SensorInfo[] findSensors(String url) throws SecurityException, SAPIException {
        int i2;
        if (url == null) {
            throw new NullPointerException();
        }
        if (url.startsWith(SCHEME_SENSOR)) {
            url = url.substring(SCHEME_SENSOR.length());
        }
        if (url.indexOf(SCHEME_SEP) > -1) {
            throw new IllegalArgumentException("Check the start of the url - the colon separates 'sensor' - not allowed elsewhere");
        }
        boolean isOnlyQuantity = false;
        int l2 = 0;
        int l22 = 0;
        l22 = url.indexOf(SCHEME_SEP2, l2);
        if (l22 < 0) {
            l22 = url.indexOf(SCHEME_QUERY_SEP, l2);
        }
        if (l22 < 0) {
            l22 = url.length();
            isOnlyQuantity = true;
        }
        String quantityStr = url.substring(l2, l22);
        int i3 = 0;
        int ll = RESERVED.length;
        while (i3 < ll) {
            if (quantityStr.indexOf(RESERVED[i3]) > -1) {
                throw new IllegalArgumentException("Quantity contains an illegal char =" + RESERVED[i3]);
            }
            ++i3;
        }
        if (quantityStr == null) {
            throw new IllegalArgumentException("Quantity string is null");
        }
        if (isOnlyQuantity) {
            return SensorManagerImpl.findSensors(quantityStr, null);
        }
        String contextType = null;
        if (url.indexOf(SCHEME_CONTEXT) > 0) {
            l2 = url.indexOf(SCHEME_CONTEXT) + SCHEME_CONTEXT.length();
            l22 = url.indexOf(SCHEME_SEP2, l2);
            if (l22 < 0) {
                l22 = url.indexOf(SCHEME_QUERY_SEP, l2);
            }
            if (l22 < 0) {
                l22 = url.length();
            }
            contextType = url.substring(l2, l22);
            int i4 = 0;
            int ll2 = RESERVED.length;
            while (i4 < ll2) {
                if (contextType.indexOf(RESERVED[i4]) > -1) {
                    throw new IllegalArgumentException("ContextType contains an illegal char =" + RESERVED[i4]);
                }
                ++i4;
            }
            if (isDebug) {
                System.out.println("SensorManagerImpl: findSensors(url) contextType =" + contextType);
            }
        }
        SensorInfo[] infos = SensorManagerImpl.findSensors(quantityStr, contextType);
        if (isDebug) {
            System.out.println("SensorManagerImpl: findSensors - " + infos.length + " sensors found");
        }
        if (infos.length < 1) {
            return NO_INFOS;
        }
        if (l22 == url.length()) {
            return infos;
        }
        String model = null;
        if (url.indexOf(SCHEME_MODEL) > 0) {
            l2 = url.indexOf(SCHEME_MODEL) + SCHEME_MODEL.length();
            l22 = url.indexOf(SCHEME_SEP2, l2);
            if (l22 < 0) {
                l22 = url.indexOf(SCHEME_QUERY_SEP, l2);
            }
            if (l22 < 0) {
                l22 = url.length();
            }
            model = url.substring(l2, l22);
        }
        String location = null;
        if (url.indexOf(SCHEME_LOCATION) > 0) {
            l2 = url.indexOf(SCHEME_LOCATION) + SCHEME_LOCATION.length();
            l22 = url.indexOf(SCHEME_SEP2, l2);
            if (l22 < 0) {
                l22 = url.indexOf(SCHEME_QUERY_SEP, l2);
            }
            if (l22 < 0) {
                l22 = url.length();
            }
            if (l2 > 0 && l22 > 0) {
                location = url.substring(l2, l22);
            }
        }
        if (model == null && location == null) {
            return infos;
        }
        if (model != null) {
            int size;
            Vector<SensorInfo> modelInfos = new Vector<SensorInfo>();
            i2 = 0;
            int ll3 = infos.length;
            while (i2 < ll3) {
                String infoModel = infos[i2].getModel();
                if (infoModel.equals(model)) {
                    modelInfos.addElement(infos[i2]);
                }
                ++i2;
            }
            int n2 = size = modelInfos.size() < 1 ? 0 : modelInfos.size();
            if (size < 1) {
                return NO_INFOS;
            }
            SensorInfo[] tmpInfos = new SensorInfoImpl[size];
            int i5 = 0;
            Enumeration e2 = modelInfos.elements();
            while (e2.hasMoreElements()) {
                tmpInfos[i5] = (SensorInfoImpl)e2.nextElement();
                ++i5;
            }
            if (location == null) {
                return tmpInfos;
            }
            if (tmpInfos.length < 1) {
                return NO_INFOS;
            }
            infos = tmpInfos;
        }
        Vector<SensorInfo> locationInfos = new Vector<SensorInfo>();
        i2 = 0;
        int ll4 = infos.length;
        while (i2 < ll4) {
            String infoLocation = (String)infos[i2].getProperty("location");
            if (infoLocation.equals(location)) {
                locationInfos.addElement(infos[i2]);
            }
            ++i2;
        }
        if (locationInfos.size() < 1) {
            return NO_INFOS;
        }
        infos = new SensorInfoImpl[locationInfos.size()];
        i2 = 0;
        Enumeration e3 = locationInfos.elements();
        while (e3.hasMoreElements()) {
            infos[i2] = (SensorInfoImpl)e3.nextElement();
            ++i2;
        }
        return infos;
    }

    public static SensorConnection getSensor(SensorInfo info) {
        Log.note("Getting SensorConnection");
        if (!SensorManagerImpl.isPermitted(info)) {
            throw new SecurityException("The application is not permitted to get the sensor");
        }
        SensorConnection sc = null;
        if (sensors == null) {
            sensors = new Hashtable();
        } else {
            sc = (SensorConnection)sensors.get(info);
        }
        if (sc != null) {
            return sc;
        }
        if (sc == null) {
            String className = (String)info.getProperty("com.nokia.className");
            Log.note("SensorManagerImpl: getSensor " + className);
            try {
                sc = (SensorConnection)Class.forName(className).newInstance();
            }
            catch (ClassNotFoundException e2) {
                e2.printStackTrace();
                Log.note("Sensor creation failed don't obfuscate com.nokia.phone.ri.sensor.Accelerometer. ");
                Log.note("Sensor creation failed. " + e2.toString());
                Log.note("Sensor creation failed. " + e2.getMessage());
                return null;
            }
            catch (Exception e3) {
                e3.printStackTrace();
                Log.note("Sensor creation failed. " + e3.toString());
                Log.note("Sensor creation failed. " + e3.getMessage());
                return null;
            }
        }
        Log.note("SensorManagerImpl: getSensor before activate");
        ((AbstractSensor)sc).activate();
        Log.note("SensorManagerImpl: getSensor after activate");
        sensors.put(info, sc);
        return sc;
    }

    public synchronized boolean registerUrl(String url) throws SecurityException, SAPIException {
        if (url == null) {
            throw new NullPointerException("SensorManagerImpl: registerUrl - url was null");
        }
        int i2 = url.indexOf(SCHEME_QUERY_SEP);
        String sensorUrl = i2 < 0 ? url : url.substring(0, i2);
        SensorInfo[] infos = SensorManagerImpl.findSensors(sensorUrl);
        if (isDebug) {
            System.out.println("SensorManagerImpl: registerUrl() url=" + url);
        }
        if (infos == null) {
            return false;
        }
        if (infos.length < 1) {
            return false;
        }
        i2 = 0;
        int j2 = 0;
        int l2 = infos.length;
        while (j2 < l2) {
            block11: {
                Vector entries = null;
                try {
                    entries = (Vector)infos[j2].getProperty(PUSHREGISTRY_ENTRY);
                }
                catch (Exception e2) {
                    entries = new Vector();
                }
                try {
                    ConditionHandler.insert(entries, url);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                ((SensorInfoImpl)infos[j2]).setProperty(PUSHREGISTRY_ENTRY, entries);
                try {
                    this.addSensorListener((SensorListener)_instance, infos[j2]);
                    ++i2;
                }
                catch (Exception e3) {
                    if (!isDebug) break block11;
                    e3.printStackTrace();
                }
            }
            ++j2;
        }
        return i2 > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeSensorListener(SensorListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        int index = -1;
        Vector vector = sensorListeners;
        synchronized (vector) {
            index = sensorListeners.indexOf(listener);
            if (index > -1) {
                sensorListeners.removeElementAt(index);
                listenedSensorConnections.removeElementAt(index);
                listenedSensorInfos.removeElementAt(index);
            }
        }
    }

    public void run() {
        block12: while (true) {
            try {
                Thread.sleep(SLEEP);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int i2 = 0;
                while (SensorManagerImpl.getSensorListeners().size() < 1) {
                    ++i2;
                    try {
                        this.await();
                    }
                    catch (Exception e2) {
                        if (!isDebug) continue;
                        e2.printStackTrace();
                    }
                }
                if (isDebug) {
                    System.out.println("SensorManagerImpl: run() - listeners exist");
                }
                int j2 = 0;
                Enumeration e3 = SensorManagerImpl.getSensorListeners().elements();
                while (true) {
                    if (!e3.hasMoreElements()) continue block12;
                    SensorListener sl = (SensorListener)e3.nextElement();
                    Vector sensorConnections = (Vector)SensorManagerImpl.getListenedSensorConnections().elementAt(j2);
                    int k2 = 0;
                    Enumeration e2 = sensorConnections.elements();
                    while (e2.hasMoreElements()) {
                        block23: {
                            SensorInfo info;
                            Object obj = e2.nextElement();
                            SensorConnection c2 = null;
                            if (obj == DUMMY) {
                                info = this.getSensorInfo(j2, k2);
                                c2 = this.getCheckedConnection(info);
                                if (c2 != null) {
                                    sensorConnections.setElementAt(c2, k2);
                                    if (isDebug) {
                                        System.out.println("sensorAvailable: " + info.getUrl());
                                    }
                                    sl.sensorAvailable(info);
                                }
                            } else {
                                block24: {
                                    try {
                                        c2 = (SensorConnection)obj;
                                    }
                                    catch (Exception exp) {
                                        if (isDebug) {
                                            exp.printStackTrace();
                                        }
                                        sensorConnections.setElementAt(DUMMY, k2);
                                        break block23;
                                    }
                                    try {
                                        if (!((AbstractSensor)c2).isConnected()) break block24;
                                        break block23;
                                    }
                                    catch (Exception e32) {
                                        if (!isDebug) break block24;
                                        e32.printStackTrace();
                                    }
                                }
                                info = this.getSensorInfo(j2, k2);
                                if (isDebug) {
                                    System.out.println("sensorUnavailable: " + info.getUrl());
                                }
                                sl.sensorUnavailable(info);
                                sensorConnections.setElementAt(DUMMY, k2);
                                try {
                                    c2.close();
                                }
                                catch (Exception exp) {
                                    if (!isDebug) break block23;
                                    exp.printStackTrace();
                                }
                            }
                        }
                        ++k2;
                    }
                    ++j2;
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    public void sensorAvailable(SensorInfo info) {
        String conditionUrl;
        Vector entries = (Vector)info.getProperty(PUSHREGISTRY_ENTRY);
        String url = (String)entries.elementAt(0);
        if (url.indexOf(SCHEME_QUERY_SEP) == -1) {
            this.removePushSensor(url);
            this.addPushEntry(url);
            return;
        }
        AbstractSensor sensor = (AbstractSensor)SensorManagerImpl.getSensor(info);
        int i2 = url.indexOf(SCHEME_QUERY_SEP);
        String string = conditionUrl = i2 < 0 ? null : url.substring(i2 + 1);
        if (conditionUrl == null) {
            return;
        }
        try {
            SensorManagerImpl.addPushConditions(info, url);
        }
        catch (IllegalArgumentException iae) {
            if (isDebug) {
                iae.printStackTrace();
            }
            this.removePushConditions(info);
        }
        ChannelInfo[] channelInfos = info.getChannelInfos();
        int j2 = 0;
        int l2 = channelInfos.length;
        while (j2 < l2) {
            if (((ChannelImpl)sensor.getChannel(channelInfos[j2])).getPushConditions().length > 0) {
                ((ChannelImpl)sensor.getChannel(channelInfos[j2])).setPushConditionListener(_instance);
            }
            ++j2;
        }
        if (isDebug) {
            System.out.println("SensorManagerImpl: pushConditionListener set.");
        }
        sensors.put(info, sensor);
    }

    public void sensorUnavailable(SensorInfo info) {
    }

    public void unregisterUrl(String url) {
        pushEntries.removeElement(url);
        this.removePushSensor(url);
    }

    static synchronized SensorInfo[] getSensors() {
        if (sensors == null) {
            return NO_INFOS;
        }
        int l2 = sensors.size();
        if (l2 < 1) {
            return NO_INFOS;
        }
        SensorInfo[] infos = new SensorInfoImpl[l2];
        int i2 = 0;
        Enumeration e2 = sensors.keys();
        while (e2.hasMoreElements()) {
            infos[i2] = (SensorInfoImpl)e2.nextElement();
            ++i2;
        }
        return infos;
    }

    static synchronized void removeSensor(SensorInfo info) {
        if (sensors.containsKey(info)) {
            SensorConnection c2 = null;
            try {
                c2 = SensorManagerImpl.getSensor(info);
            }
            catch (Exception exception) {
                // empty catch block
            }
            sensors.remove(info);
            if (metConditions != null) {
                metConditions.remove(c2);
            }
            if (metData != null) {
                metData.remove(c2);
            }
        }
    }

    static synchronized boolean sendPendingNotification(SensorConnection sensor, ConditionListener listener) {
        if (!metConditions.containsKey(sensor)) {
            return false;
        }
        if (!metData.containsKey(sensor)) {
            return false;
        }
        listener.conditionMet(sensor, (Data)metData.get(sensor), (Condition)metConditions.get(sensor));
        metConditions.remove(sensor);
        metData.remove(sensor);
        return true;
    }

    private static synchronized void addC(Object obj, int index) {
        Object o2 = SensorManagerImpl.getListenedSensorConnections().size() <= index ? null : SensorManagerImpl.getListenedSensorConnections().elementAt(index);
        Vector<Object> v2 = o2 == null ? new Vector<Object>() : (Vector<Object>)o2;
        v2.addElement(obj);
        if (o2 == null) {
            SensorManagerImpl.getListenedSensorConnections().addElement(v2);
        } else {
            SensorManagerImpl.getListenedSensorConnections().setElementAt(v2, index);
        }
    }

    private static synchronized void addInfo(SensorInfo info, int index) {
        Object o2 = SensorManagerImpl.getListenedSensorInfos().size() <= index ? null : SensorManagerImpl.getListenedSensorInfos().elementAt(index);
        Vector<SensorInfo> v2 = o2 == null ? new Vector<SensorInfo>() : (Vector<SensorInfo>)o2;
        v2.addElement(info);
        if (o2 == null) {
            SensorManagerImpl.getListenedSensorInfos().addElement(v2);
        } else {
            SensorManagerImpl.getListenedSensorInfos().setElementAt(v2, index);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void addPushConditions(SensorInfo info, String queryPartUrl) {
        channelUrl = null;
        i = queryPartUrl.indexOf("channel=");
        if (i >= 0) ** GOTO lbl9
        throw new IllegalArgumentException("sensorUrl corrupted: channels missing");
lbl-1000:
        // 1 sources

        {
            j = queryPartUrl.indexOf("channel=", i + 1);
            channelUrl = j < 0 ? queryPartUrl.substring(i) : queryPartUrl.substring(i, j - 1);
            SensorManagerImpl.addPushConditionsOfOneChannel(info, channelUrl);
            i = queryPartUrl.indexOf("channel=", i + 1);
lbl9:
            // 2 sources

            ** while (i >= 0)
        }
lbl10:
        // 1 sources

    }

    private static void addPushConditionsOfOneChannel(SensorInfo info, String channelUrl) {
        int i2 = channelUrl.indexOf(SCHEME_SEP3);
        if (i2 < L) {
            return;
        }
        String channelName = channelUrl.substring(L, i2);
        ChannelInfo channelInfo = ((SensorInfoImpl)info).getChannelInfo(channelName);
        String conditionsStr = channelUrl.substring(i2 + 1);
        Vector conditions = SensorManagerImpl.getConditions(conditionsStr);
        SensorConnection sc = null;
        try {
            sc = SensorManagerImpl.getSensor(info);
        }
        catch (Exception exception) {
            // empty catch block
        }
        i2 = 0;
        try {
            int l2 = conditions.size();
            while (i2 < l2) {
                ((ChannelImpl)sc.getChannel(channelInfo)).addPushCondition((Condition)conditions.elementAt(i2));
                ++i2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private synchronized void addPushEntry(String url) {
        if (!pushEntries.contains(url)) {
            if (isDebug) {
                System.out.println("SensorManagerImpl: addPushEntry");
            }
            pushEntries.addElement(url);
        }
        this.notify();
    }

    private synchronized void await() {
        block2: {
            try {
                this.wait();
            }
            catch (Exception e2) {
                if (!isDebug) break block2;
                e2.printStackTrace();
            }
        }
    }

    private static SensorInfo[] findSensorsByQ(String quantity) throws SecurityException, SAPIException {
        if (quantity != null) {
            return SensorManagerImpl.getOkInfos(quantity);
        }
        SensorInfo[] infos = new SensorInfo[]{Accelerometer.createSensorInfo()};
        return infos;
    }

    private SensorConnection getCheckedConnection(SensorInfo info) {
        block11: {
            SensorConnection c2;
            block10: {
                c2 = null;
                try {
                    c2 = SensorManagerImpl.getSensor(info);
                    if (isDebug) {
                        System.out.println("SensorManagerImpl:getCheckedConnection - connection got= " + c2);
                    }
                }
                catch (Exception exp) {
                    if (isDebug) {
                        exp.printStackTrace();
                    }
                    return null;
                }
                try {
                    if (((AbstractSensor)c2).isConnected()) {
                        return c2;
                    }
                }
                catch (Exception e2) {
                    if (!isDebug) break block10;
                    e2.printStackTrace();
                }
            }
            if (c2 != null) {
                try {
                    c2.close();
                }
                catch (Exception exp) {
                    if (!isDebug) break block11;
                    exp.printStackTrace();
                }
            }
        }
        return null;
    }

    private static Vector getConditions(String conditionsStr) {
        String oneCondition = null;
        int i2 = 0;
        int j2 = 0;
        Vector<Condition> conditions = new Vector<Condition>();
        while ((j2 = conditionsStr.indexOf(SCHEME_SEP3, i2 + 1)) >= 0) {
            int k2 = conditionsStr.indexOf(SCHEME_SEP3, j2 + 1);
            oneCondition = k2 < 0 ? conditionsStr.substring(i2) : conditionsStr.substring(i2, k2);
            i2 = k2 < 0 ? j2 : k2;
            Condition cond = ChannelImpl.getCondition(oneCondition);
            if (cond == null) {
                throw new IllegalArgumentException("Sensor url is corrupted: check conditions");
            }
            if (isDebug) {
                System.out.println("SensorManagerImpl:addPushConditionsOfOneChannel " + ChannelImpl.getUrl(cond));
            }
            ++i2;
            conditions.addElement(cond);
        }
        return conditions;
    }

    private static synchronized Vector getListenedSensorConnections() {
        return listenedSensorConnections;
    }

    private static synchronized Vector getListenedSensorInfos() {
        return listenedSensorInfos;
    }

    private static SensorInfo[] getOkInfos(String quantity) throws SAPIException {
        SensorInfo info = null;
        if (quantity.equals("acceleration")) {
            info = Accelerometer.createSensorInfo();
        }
        if (info != null) {
            SensorInfo[] infos = new SensorInfo[]{info};
            return infos;
        }
        return NO_INFOS;
    }

    private synchronized SensorInfo getSensorInfo(int index, int index2) {
        Object o2;
        Object v0 = o2 = SensorManagerImpl.getListenedSensorInfos().size() <= index ? null : SensorManagerImpl.getListenedSensorInfos().elementAt(index);
        if (o2 == null) {
            return null;
        }
        Vector sensorsToBeMonitored = o2;
        if (sensorsToBeMonitored.size() < 1) {
            return null;
        }
        Object v1 = o2 = sensorsToBeMonitored.size() <= index2 ? null : sensorsToBeMonitored.elementAt(index2);
        if (o2 == null) {
            return null;
        }
        return o2;
    }

    private static synchronized Vector getSensorListeners() {
        return sensorListeners;
    }

    private static boolean isPermitted(SensorInfo info) {
        Object o2 = null;
        try {
            o2 = info.getProperty("com.nokia.permission");
        }
        catch (Exception e2) {
            return true;
        }
        int permission = 1;
        try {
            permission = Integer.parseInt((String)o2);
        }
        catch (Exception e3) {
            return true;
        }
        return permission == 1;
    }

    private static synchronized boolean isPushable(String url) {
        return pushEntries.contains(url);
    }

    private static boolean isPushRegistryEntry(SensorInfo info) {
        try {
            ((SensorInfoImpl)info).getProperty(PUSHREGISTRY_ENTRY);
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private synchronized void removePushConditions(SensorInfo info) {
        AbstractSensor sensor = (AbstractSensor)SensorManagerImpl.getSensor(info);
        ChannelInfo[] ch = info.getChannelInfos();
        int i2 = 0;
        int l2 = ch.length;
        while (i2 < l2) {
            ChannelImpl channel = (ChannelImpl)sensor.getChannel(ch[i2]);
            channel.removeAllPushConditions();
            channel.removePushConditionListener();
            ++i2;
        }
    }

    private synchronized void removePushSensor(String url) {
        block6: {
            int index = sensorListeners.indexOf(this);
            if (index == -1) {
                return;
            }
            try {
                Vector sensorsOfOneListener = (Vector)listenedSensorInfos.elementAt(index);
                Enumeration e2 = sensorsOfOneListener.elements();
                while (e2.hasMoreElements()) {
                    Vector v2;
                    Object o2 = e2.nextElement();
                    SensorInfoImpl info = (SensorInfoImpl)o2;
                    Object o22 = info.getProperty(PUSHREGISTRY_ENTRY);
                    if (o22 == null || !(v2 = (Vector)o22).contains(url)) continue;
                    if (url.indexOf(SCHEME_QUERY_SEP) > -1) {
                        this.removePushConditions(info);
                    }
                    sensorsOfOneListener.removeElement(info);
                }
                if (sensorsOfOneListener.size() < 1) {
                    this.removeSensorListener(this);
                }
            }
            catch (Exception e3) {
                if (!isDebug) break block6;
                e3.printStackTrace();
            }
        }
    }

    private static class ConditionHandler {
        private ConditionHandler() {
        }

        public static void insert(Vector entries, String url) {
            int i2 = 0;
            int l2 = entries.size();
            while (i2 < l2) {
                if (!ConditionHandler.isLessSpecific((String)entries.elementAt(i2), url)) {
                    entries.setElementAt(url, i2);
                    return;
                }
                ++i2;
            }
            entries.addElement(url);
        }

        public static String getMetUrl(Vector entries, ChannelInfo channel, Condition condition) {
            if (entries == null) {
                return null;
            }
            int i2 = 0;
            int l2 = entries.size();
            while (i2 < l2) {
                String url = (String)entries.elementAt(i2);
                if (ConditionHandler.isMetUrl(url, channel, condition)) {
                    return url;
                }
                ++i2;
            }
            return null;
        }

        private static boolean isLessSpecific(String url1, String url2) {
            if (url1.indexOf(SensorManagerImpl.SCHEME_MODEL) > url2.indexOf(SensorManagerImpl.SCHEME_MODEL)) {
                return true;
            }
            if (url2.indexOf(SensorManagerImpl.SCHEME_MODEL) > url1.indexOf(SensorManagerImpl.SCHEME_MODEL)) {
                return false;
            }
            if (url1.indexOf(SensorManagerImpl.SCHEME_CONTEXT) > url2.indexOf(SensorManagerImpl.SCHEME_CONTEXT)) {
                return true;
            }
            if (url2.indexOf(SensorManagerImpl.SCHEME_CONTEXT) > url1.indexOf(SensorManagerImpl.SCHEME_CONTEXT)) {
                return true;
            }
            if (url1.indexOf(SensorManagerImpl.SCHEME_LOCATION) > url2.indexOf(SensorManagerImpl.SCHEME_CONTEXT)) {
                return true;
            }
            if (url2.indexOf(SensorManagerImpl.SCHEME_LOCATION) > url1.indexOf(SensorManagerImpl.SCHEME_CONTEXT)) {
                return false;
            }
            throw new IllegalArgumentException("The same push entry already exists.");
        }

        private static boolean isMetUrl(String url, ChannelInfo channel, Condition condition) {
            String queryPartUrl;
            int j2 = url.indexOf(SensorManagerImpl.SCHEME_QUERY_SEP);
            String string = queryPartUrl = j2 < 0 ? null : url.substring(j2 + 1);
            if (queryPartUrl == null) {
                return false;
            }
            int i2 = 0;
            while (i2 >= 0) {
                j2 = queryPartUrl.indexOf(SensorManagerImpl.SCHEME_CHANNEL, i2 + 1);
                String channelUrl = j2 < 0 ? queryPartUrl.substring(i2) : queryPartUrl.substring(i2, j2 - 1);
                int ii = channelUrl.indexOf(SensorManagerImpl.SCHEME_SEP3);
                if (ii < L) {
                    return false;
                }
                String channelName = channelUrl.substring(L, ii);
                if (channelName.equals(channel.getName())) {
                    String conditionsStr = channelUrl.substring(ii + 1);
                    Vector conditions = SensorManagerImpl.getConditions(conditionsStr);
                    int ind = 0;
                    int l2 = conditions.size();
                    while (ind < l2) {
                        Condition cond = (Condition)conditions.elementAt(ind);
                        if (condition instanceof LimitCondition) {
                            if (!(cond instanceof LimitCondition)) {
                                return false;
                            }
                            LimitCondition c1 = (LimitCondition)cond;
                            LimitCondition c2 = (LimitCondition)condition;
                            if (!c1.getOperator().equals(c2.getOperator())) {
                                return false;
                            }
                            return c1.getLimit() == c2.getLimit();
                        }
                        if (condition instanceof RangeCondition) {
                            if (!(cond instanceof RangeCondition)) {
                                return false;
                            }
                            RangeCondition c1 = (RangeCondition)cond;
                            RangeCondition c2 = (RangeCondition)condition;
                            if (!c1.getLowerOp().equals(c2.getLowerOp())) {
                                return false;
                            }
                            if (!c1.getUpperOp().equals(c2.getUpperOp())) {
                                return false;
                            }
                            if (c1.getLowerLimit() != c2.getLowerLimit()) {
                                return false;
                            }
                            return c1.getUpperLimit() == c2.getUpperLimit();
                        }
                        ++ind;
                    }
                }
                i2 = queryPartUrl.indexOf(SensorManagerImpl.SCHEME_CHANNEL, i2 + 1);
            }
            return false;
        }
    }
}

