/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.utils;

import com.nokia.mid.appl.sa.tool.Log;
import com.nokia.mid.s40.codec.DataDecoder;
import com.nokia.mid.s40.codec.DataEncoder;
import com.nokia.mid.s40.io.LocalMessageProtocolConnection;
import com.nokia.mid.s40.io.LocalMessageProtocolMessage;
import java.io.IOException;
import java.util.Vector;

public class CommonMessagesS40Codec {
    private static final long RANGE_SEPARATOR = -1L;
    private static final int INVALID_NUM_START = -1;
    public static final String METHOD_COMMON = "Common";
    public static final String METHOD_PROTOCOL_VERSION = "ProtocolVersion";
    public static final String METHOD_ERROR = "Error";
    public static final String METHOD_NOT_RECOGNIZED = "MethodNotRecognized";
    public static final String NOT_ALLOWED = "NotAllowed";
    public static final String MESSAGE_DATA_ERROR = "MessageDataError";
    public static final String PROTOCOL_VERSION_NOT_NEGOTIATED = "ProtocolVersionNotNegotiated";
    public static final String DATA_ENCODING = "Conv-BEB";
    public static LocalMessageProtocolConnection LMPC = null;

    public static byte[] createErrorMessage(String status) {
        try {
            DataEncoder writer = new DataEncoder(DATA_ENCODING);
            writer.putStart(14, "event");
            writer.put(13, "name", METHOD_COMMON);
            writer.putStart(14, "message");
            writer.put(13, "name", METHOD_ERROR);
            writer.put(10, "status", status);
            writer.putEnd(14, "message");
            writer.putEnd(14, "event");
            return writer.getData();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static String[] parseCommonMessage(byte[] msg, int offset, int length) {
        String value = null;
        String[] ret = null;
        try {
            DataDecoder reader = new DataDecoder(DATA_ENCODING, msg, offset, length);
            reader.getStart(14);
            value = reader.getString(13);
            if (value.equalsIgnoreCase(METHOD_COMMON)) {
                reader.getStart(14);
                value = reader.getString(13);
                if (value.equalsIgnoreCase(METHOD_ERROR)) {
                    value = reader.getString(10);
                    ret = new String[]{METHOD_ERROR, value};
                } else if (value.equalsIgnoreCase(METHOD_PROTOCOL_VERSION) && reader.getType() == 10 && (reader.getName().equals("version") || reader.getName().equals("versions"))) {
                    value = reader.getString(10);
                    ret = new String[]{METHOD_PROTOCOL_VERSION, value};
                }
            }
            reader.getEnd(14);
            reader.getEnd(14);
        }
        catch (IOException ioe) {
            ret = null;
        }
        if (ret == null) {
            throw new IllegalArgumentException("Invalid common message");
        }
        return ret;
    }

    public static String compareVersions(String clientVersions, String serverVersions) {
        try {
            Vector[] clientVs = CommonMessagesS40Codec.convertFromVersionString(clientVersions);
            Vector[] serverVs = CommonMessagesS40Codec.convertFromVersionString(serverVersions);
            long[] preferred = CommonMessagesS40Codec.findPreferred(clientVs, serverVs);
            return CommonMessagesS40Codec.convertToVersionString(preferred);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid version list syntax (#2)");
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IllegalArgumentException("Invalid version list syntax (#1)");
        }
    }

    public static String negotiateVersion(LocalMessageProtocolConnection conn, String clientVersions) throws IOException {
        byte[] req = CommonMessagesS40Codec.createVersionRequest(clientVersions);
        Log.note("negotiateVersion SEND", req, req.length);
        conn.send(req, 0, req.length);
        LocalMessageProtocolMessage msg = conn.newMessage(null);
        conn.receive(msg);
        Log.note("negotiateVersion RECV", msg.getData(), msg.getLength());
        String[] respFields = CommonMessagesS40Codec.parseCommonMessage(msg.getData(), 0, msg.getLength());
        if (respFields == null || respFields.length < 2 || !respFields[0].equalsIgnoreCase(METHOD_PROTOCOL_VERSION)) {
            throw new IOException("Invalid response");
        }
        if (respFields[1].length() == 0) {
            return null;
        }
        return respFields[1];
    }

    public static byte[] createVersionRequest(String versions) throws IOException {
        return CommonMessagesS40Codec.createVersionMessage(versions, true);
    }

    public static byte[] createVersionResponse(String version) throws IOException {
        return CommonMessagesS40Codec.createVersionMessage(version, false);
    }

    private static byte[] createVersionMessage(String versionString, boolean request) throws IOException {
        if (versionString == null) {
            if (request) {
                throw new NullPointerException();
            }
            versionString = "";
        }
        DataEncoder writer = new DataEncoder(DATA_ENCODING);
        writer.putStart(14, "event");
        writer.put(13, "name", METHOD_COMMON);
        writer.putStart(14, "message");
        writer.put(13, "name", METHOD_PROTOCOL_VERSION);
        if (request) {
            writer.put(10, "versions", versionString);
        } else {
            writer.put(10, "version", versionString);
        }
        writer.putEnd(14, "message");
        writer.putEnd(14, "event");
        return writer.getData();
    }

    public static boolean isValidVersionsString(String versionStr) {
        try {
            CommonMessagesS40Codec.convertFromVersionString(versionStr);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static Vector[] convertFromVersionString(String versionStr) {
        int majorsCount = 1;
        boolean ignore = false;
        int i2 = 0;
        while (i2 < versionStr.length()) {
            switch (versionStr.charAt(i2)) {
                case ',': {
                    if (ignore) break;
                    ++majorsCount;
                    break;
                }
                case '[': {
                    ignore = true;
                    break;
                }
                case ']': {
                    ignore = false;
                    break;
                }
            }
            ++i2;
        }
        Vector[] versions = new Vector[majorsCount];
        int majorIndex = -1;
        int length = versionStr.length();
        int numBeginOffset = -1;
        int numEndOffset = 0;
        char ch = '\u0000';
        boolean majorPhase = true;
        boolean invalidString = false;
        boolean valueList = false;
        String newNumStr = null;
        int i3 = 0;
        while (i3 < length && !invalidString) {
            ch = versionStr.charAt(i3);
            if (Character.isDigit(ch)) {
                if (numBeginOffset == -1) {
                    numBeginOffset = i3;
                    numEndOffset = i3 - 1;
                }
                ++numEndOffset;
            } else {
                block29: {
                    if (majorPhase) {
                        if (ch == '.') {
                            newNumStr = versionStr.substring(numBeginOffset, numEndOffset + 1);
                            versions[++majorIndex] = new Vector();
                            majorPhase = false;
                            break block29;
                        } else {
                            invalidString = true;
                            break;
                        }
                    }
                    if (ch == '[') {
                        valueList = true;
                    } else if (ch == ']') {
                        if (!valueList || numBeginOffset == -1) {
                            invalidString = true;
                            break;
                        }
                        newNumStr = versionStr.substring(numBeginOffset, numEndOffset + 1);
                        valueList = false;
                    } else if (ch == ',') {
                        if (numBeginOffset > -1) {
                            newNumStr = versionStr.substring(numBeginOffset, numEndOffset + 1);
                        }
                        if (!valueList) {
                            majorPhase = true;
                        }
                    } else if (ch == '-' && valueList) {
                        newNumStr = versionStr.substring(numBeginOffset, numEndOffset + 1);
                        versions[majorIndex].addElement(new Long(Long.parseLong(newNumStr)));
                        newNumStr = null;
                        numBeginOffset = -1;
                        versions[majorIndex].addElement(new Long(-1L));
                    } else {
                        invalidString = true;
                    }
                }
                if (newNumStr != null) {
                    versions[majorIndex].addElement(new Long(Long.parseLong(newNumStr)));
                    newNumStr = null;
                    numBeginOffset = -1;
                }
            }
            ++i3;
        }
        if (numBeginOffset > -1) {
            newNumStr = versionStr.substring(numBeginOffset, numEndOffset + 1);
            versions[majorIndex].addElement(new Long(Long.parseLong(newNumStr)));
        }
        i3 = 0;
        while (i3 < versions.length) {
            if (versions[i3] == null || versions[i3].size() <= 1) {
                invalidString = true;
                break;
            }
            ++i3;
        }
        if (invalidString) {
            throw new IllegalArgumentException("Invalid version list syntax (#3)");
        }
        return versions;
    }

    static long[] findPreferred(Vector[] clientVersions, Vector[] serverVersions) {
        long clientMajor = 0L;
        long serverMajor = 0L;
        int i2 = 0;
        int j2 = 0;
        i2 = 0;
        while (i2 < clientVersions.length) {
            clientMajor = (Long)clientVersions[i2].elementAt(0);
            Vector clientMinors = clientVersions[i2];
            j2 = 0;
            while (j2 < serverVersions.length) {
                serverMajor = (Long)serverVersions[j2].elementAt(0);
                if (clientMajor == serverMajor) {
                    Vector serverMinors = serverVersions[j2];
                    int k2 = 1;
                    while (k2 < clientMinors.size()) {
                        long cRangeBegin = (Long)clientMinors.elementAt(k2);
                        long cRangeEnd = 0L;
                        if (k2 < clientMinors.size() - 2) {
                            cRangeEnd = (Long)clientMinors.elementAt(k2 + 1);
                            if (cRangeEnd == -1L) {
                                cRangeEnd = (Long)clientMinors.elementAt(k2 + 2);
                                k2 += 2;
                            } else {
                                cRangeEnd = cRangeBegin;
                            }
                        } else {
                            cRangeEnd = cRangeBegin;
                        }
                        int l2 = 1;
                        while (l2 < serverMinors.size()) {
                            long sRangeBegin = (Long)serverMinors.elementAt(l2);
                            long sRangeEnd = 0L;
                            if (l2 < serverMinors.size() - 2) {
                                sRangeEnd = (Long)serverMinors.elementAt(l2 + 1);
                                if (sRangeEnd == -1L) {
                                    sRangeEnd = (Long)serverMinors.elementAt(l2 + 2);
                                    l2 += 2;
                                } else {
                                    sRangeEnd = sRangeBegin;
                                }
                            } else {
                                sRangeEnd = sRangeBegin;
                            }
                            long maxCommon = CommonMessagesS40Codec.maxCommonNumber(cRangeBegin, cRangeEnd, sRangeBegin, sRangeEnd);
                            if (maxCommon != -1L) {
                                return new long[]{clientMajor, maxCommon};
                            }
                            ++l2;
                        }
                        ++k2;
                    }
                }
                ++j2;
            }
            ++i2;
        }
        return null;
    }

    static long maxCommonNumber(long aBegin, long aEnd, long bBegin, long bEnd) {
        while (aEnd >= aBegin) {
            if (aEnd >= bBegin && aEnd <= bEnd) {
                return aEnd;
            }
            --aEnd;
        }
        return -1L;
    }

    static String convertToVersionString(long[] version) {
        if (version == null) {
            return null;
        }
        StringBuffer versionStr = new StringBuffer();
        versionStr.append(version[0]);
        versionStr.append('.');
        versionStr.append(version[1]);
        return versionStr.toString();
    }

    public static void writeCommonMessageHeader(DataEncoder writer, String method, String clientId) throws IOException {
        CommonMessagesS40Codec.writeCommonMessageHeader(writer, method, clientId, null);
    }

    public static void writeCommonMessageHeader(DataEncoder writer, String method, String clientId, Integer txId) throws IOException {
        writer.putStart(14, "event");
        writer.put(13, "name", method);
        if (txId != null) {
            writer.put(2, "trans_id", (long)txId.intValue());
        }
        writer.put(10, "client_id", clientId);
    }
}

