/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.phone.ri.sensor;

import com.nokia.phone.ri.sensor.AbstractSensor;
import com.nokia.sensor.interfaces.ChannelInfo;
import com.nokia.sensor.interfaces.SensorInfo;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;

final class SensorInfoImpl
implements SensorInfo {
    static final int PUBLIC_SENSOR = 1;
    static final int PRIVATE_SENSOR = 2;
    static final int PROTECTED_SENSOR = 4;
    private static final String[] NO_PROPERTIES = new String[0];
    private static final String SCHEME_SENSOR = "sensor:";
    private static final String SCHEME_CONTEXT_TYPE = "contextType=";
    private static final String SCHEME_MODEL = "model=";
    private static final String SCHEME_LOCATION = "location=";
    private static final String SCHEME_SEP = ";";
    private final ChannelInfo[] channelInfos;
    private final int connectionType;
    private final String contextType;
    private final String description;
    private final String locationString;
    private static Vector mainContextTypes = new Vector();
    private int prefDataRate = 0;
    private final String model;
    private Hashtable properties;
    private final String quantity;
    private final String url;

    static {
        mainContextTypes.addElement("ambient");
        mainContextTypes.addElement("vehicle");
        mainContextTypes.addElement("device");
        mainContextTypes.addElement("user");
    }

    SensorInfoImpl(Hashtable properties, String quantity, String contextType, int connectionType, String model, ChannelInfo[] channels, String description) {
        if (!mainContextTypes.contains(contextType)) {
            throw new IllegalArgumentException("Context type is not valid.");
        }
        if (quantity == null) {
            throw new NullPointerException("Quantity is null");
        }
        if (contextType == null) {
            throw new NullPointerException("ContextType is null");
        }
        if (channels == null) {
            throw new NullPointerException("Channels are null");
        }
        if (description == null) {
            throw new NullPointerException("Description is null");
        }
        this.quantity = quantity;
        this.contextType = contextType;
        this.connectionType = connectionType;
        this.model = model;
        this.description = description;
        this.locationString = null;
        this.channelInfos = channels;
        this.url = this.createUrl();
        this.properties = properties;
    }

    public ChannelInfo[] getChannelInfos() {
        return this.channelInfos;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public String getContextType() {
        return this.contextType;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMaxBufferSize() {
        return 1;
    }

    public String getModel() {
        return this.model;
    }

    public synchronized String[] getPropertyNames() {
        if (this.properties == null) {
            return NO_PROPERTIES;
        }
        String[] keys = new String[this.properties.size()];
        int i2 = 0;
        Enumeration e2 = this.properties.keys();
        while (e2.hasMoreElements()) {
            keys[i2] = (String)e2.nextElement();
            ++i2;
        }
        return keys;
    }

    public synchronized Object getProperty(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.properties == null) {
            throw new IllegalArgumentException();
        }
        if (this.properties.get(key) == null) {
            throw new IllegalArgumentException("Property with key " + key + " not found.");
        }
        return this.properties.get(key);
    }

    public String getQuantity() {
        return this.quantity;
    }

    public final String getUrl() {
        return this.url;
    }

    public boolean isAvailable() {
        try {
            AbstractSensor sensor = (AbstractSensor)Connector.open((String)this.getUrl());
            boolean isAvailable = sensor.isConnected();
            sensor.close();
            return isAvailable;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public boolean isAvailabilityPushSupported() {
        return true;
    }

    public boolean isConditionPushSupported() {
        return true;
    }

    ChannelInfo getChannelInfo(String name) {
        int i2 = 0;
        int l2 = this.channelInfos.length;
        while (i2 < l2) {
            if (this.channelInfos[i2].getName().equals(name)) {
                return this.channelInfos[i2];
            }
            ++i2;
        }
        return null;
    }

    synchronized void setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(key, value);
    }

    private String createUrl() {
        if (this.locationString == null) {
            return SCHEME_SENSOR + this.quantity + SCHEME_SEP + SCHEME_CONTEXT_TYPE + this.contextType + SCHEME_SEP + SCHEME_MODEL + this.model;
        }
        return SCHEME_SENSOR + this.quantity + SCHEME_SEP + SCHEME_CONTEXT_TYPE + this.contextType + SCHEME_SEP + SCHEME_MODEL + this.model + SCHEME_SEP + SCHEME_LOCATION + this.locationString;
    }

    public int getSampleRate() {
        return this.prefDataRate;
    }

    public void setSampleRate(int dataPerSec) {
        this.prefDataRate = dataPerSec > ((Float)this.properties.get("maxSamplingRate")).intValue() ? ((Float)this.properties.get("maxSamplingRate")).intValue() : dataPerSec;
    }
}

