/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.phone.ri.sensor;

import com.nokia.mid.appl.sa.io.common.SAPIException;
import com.nokia.mid.appl.sa.tool.Log;
import com.nokia.mid.s40.codec.DataDecoder;
import com.nokia.mid.s40.codec.DataEncoder;
import com.nokia.mid.s40.io.LocalMessageProtocolConnection;
import com.nokia.mid.s40.io.SharedLocalProtocolMemory;
import com.nokia.phone.ri.sensor.AbstractSensor;
import com.nokia.phone.ri.sensor.ChannelInfoImpl;
import com.nokia.phone.ri.sensor.DataImpl;
import com.nokia.phone.ri.sensor.SensorInfoImpl;
import com.nokia.sensor.interfaces.ChannelInfo;
import com.nokia.sensor.interfaces.MeasurementRange;
import com.nokia.sensor.interfaces.SensorInfo;
import com.nokia.sensor.interfaces.Unit;
import com.nokia.utils.CommonMessagesS40Codec;
import com.nokia.utils.S40SAPICodec;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.io.Connector;

public class Accelerometer
extends AbstractSensor {
    public static final int TRANSID_FINDSENSOR = 101;
    public static final int TRANSID_SET_DATANOTIFICATION = 102;
    public static final String QUANTITIY_ACCELERATION = "acceleration";
    public static final String LOCATION_PHONE = "phone";
    public static final String MODEL_LINEARACCELEROMETERA = "LinearAccelerometerA";
    private static ChannelInfo[] channel_info = null;
    private static SensorInfoImpl sensorInfoInstance = null;
    public static LocalMessageProtocolConnection LMPC = null;
    private static int[] errors = new int[0];
    private int latestSize = 0;
    private boolean lostData = false;
    byte[] arrLastData = new byte[16];
    int timestamp;
    float axis_x;
    float axis_y;
    float axis_z;
    static /* synthetic */ Class class$0;

    public Accelerometer() throws SAPIException {
        if (AbstractSensor.POOL_SIZE > 0) {
            this.initDataPool();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SensorInfo createSensorInfo() {
        boolean isOk;
        SensorInfoImpl sensInfo = null;
        channel_info = null;
        Hashtable<String, Object> tblSensorInfo = new Hashtable<String, Object>();
        if (sensorInfoInstance != null) {
            return sensorInfoInstance;
        }
        if (LMPC == null) {
            try {
                LMPC = (LocalMessageProtocolConnection)Connector.open((String)S40SAPICodec.URI_SENSOR);
            }
            catch (IOException e2) {
                Log.note("Internal: IOE: Accelerometer:createSensorInfo:DataEncoder in METHOD_FINDSENSOR request.");
                Log.note("Internal: IOE: Accelerometer:createSensorInfo:Connector in open LocalMessageProtocolConnection. Err:" + e2.getMessage());
                return null;
            }
        }
        if (!(isOk = Accelerometer.verifyVersion())) {
            Log.note("Internal: Accelerometer:createSensorInfo in wrong version of requested SAPI.");
            Accelerometer.addError(2);
            return null;
        }
        DataEncoder writer = null;
        try {
            writer = new DataEncoder("Conv-BEB");
            writer.putStart(14, "event");
            writer.put(13, "name", "FindSensors");
            writer.put(5, "trans_id", 101L);
            writer.put(11, "quantity", QUANTITIY_ACCELERATION);
            writer.put(11, "context_type", "user");
            writer.put(11, "location", LOCATION_PHONE);
            writer.put(11, "model", MODEL_LINEARACCELEROMETERA);
            writer.putEnd(14, "event");
        }
        catch (IOException ioe) {
            Log.note("Internal: IOE: Accelerometer:createSensorInfo:DataEncoder in METHOD_FINDSENSOR request.");
            Accelerometer.addError(4);
            return null;
        }
        try {
            byte[] dataResp = S40SAPICodec.doSAPIRequest(LMPC, writer.getData());
            if (dataResp == null) {
                Log.note("Internal: IAE: Accelerometer:createSensorInfo:DataEncoder could not create request data for FindSensors");
                Accelerometer.addError(3);
                return null;
            }
            try {
                String value = null;
                DataDecoder reader = new DataDecoder("Conv-BEB", dataResp, 0, dataResp.length);
                reader.getStart(14);
                value = reader.getString(13);
                if (!value.equalsIgnoreCase("FindSensors")) {
                    Log.note("Internal: Wrong Resp Value: Accelerometer:createSensorInfo:DataDecode in verify requested method. Request FindSensors response from " + value);
                    Accelerometer.addError(3);
                    return null;
                }
                reader.getInteger(5);
                value = reader.getString(10);
                if (!value.equals(S40SAPICodec.STATUS_OK)) {
                    Log.note("Internal: IOE: Accelerometer:createSensorInfo:DataEncoder in METHOD_FINDSENSOR response value [" + value + "].");
                    Accelerometer.addError(3);
                }
                int sensor_count = (int)reader.getInteger(5);
                reader.getStart(16);
                reader.getStart(14);
                tblSensorInfo.put("com.nokia.permission", new Integer(1));
                tblSensorInfo.put("com.nokia.className", "com.nokia.phone.ri.sensor.Accelerometer");
                tblSensorInfo.put("sensor_uid", new Integer((int)reader.getInteger(5)));
                tblSensorInfo.put("context_type", reader.getString(11));
                tblSensorInfo.put("quantity", reader.getString(11));
                tblSensorInfo.put("model", reader.getString(11));
                tblSensorInfo.put("connection_type", new Integer((int)reader.getInteger(5)));
                tblSensorInfo.put("description", reader.getString(11));
                tblSensorInfo.put("location", reader.getString(11));
                tblSensorInfo.put("vendor", reader.getString(11));
                tblSensorInfo.put("version", reader.getString(11));
                tblSensorInfo.put("maxSamplingRate", new Float(reader.getFloat(8)));
                tblSensorInfo.put("min_interval", new Integer((int)reader.getInteger(7)));
                tblSensorInfo.put("access_type", reader.getString(11));
                tblSensorInfo.put("availability", new Boolean(reader.getBoolean()));
                tblSensorInfo.put("channel_count", new Integer((int)reader.getInteger(5)));
                reader.getStart(16);
                channel_info = new ChannelInfoImpl[((Integer)tblSensorInfo.get("channel_count")).intValue()];
                int cnt_chan = 0;
                block13: while (true) {
                    if (cnt_chan >= channel_info.length) {
                        reader.getEnd(16);
                        try {
                            sensInfo = new SensorInfoImpl(tblSensorInfo, (String)tblSensorInfo.get("quantity"), (String)tblSensorInfo.get("context_type"), (Integer)tblSensorInfo.get("connection_type"), (String)tblSensorInfo.get("model"), channel_info, (String)tblSensorInfo.get("description"));
                            break;
                        }
                        catch (IllegalArgumentException e3) {
                            Log.note("Internal: IAE: Accelerometer:createSensorInfo:SensorInfoImpl() in Constuctor. Err:" + e3.getMessage());
                            Accelerometer.addError(3);
                            return null;
                        }
                        catch (NullPointerException e4) {
                            Log.note("Internal: NPE: Accelerometer:createSensorInfo:SensorInfoImpl() in Constuctor. Err:" + ((Throwable)e4).getMessage());
                            Accelerometer.addError(3);
                            return null;
                        }
                    }
                    reader.getStart(14);
                    String channel_name = reader.getString(11);
                    float accuracy = (float)reader.getFloat(8);
                    int data_type = 1;
                    reader.getInteger(5);
                    int scale = (int)reader.getInteger(4);
                    String unit = reader.getString(11);
                    int range_count = (int)reader.getInteger(5);
                    reader.getStart(16);
                    MeasurementRange[] measurement_range = new MeasurementRange[range_count];
                    int cnt_measure = 0;
                    while (true) {
                        if (cnt_measure >= measurement_range.length) {
                            reader.getEnd(16);
                            reader.getEnd(14);
                            Accelerometer.channel_info[cnt_chan] = new ChannelInfoImpl(channel_name, scale, Unit.getUnit(unit), accuracy, data_type, measurement_range);
                            ++cnt_chan;
                            continue block13;
                        }
                        reader.getStart(14);
                        double smallest_value = reader.getFloat(9);
                        double largest_value = reader.getFloat(9);
                        double resolution = reader.getFloat(9);
                        reader.getEnd(14);
                        measurement_range[cnt_measure] = new MeasurementRange(smallest_value, largest_value, resolution);
                        ++cnt_measure;
                    }
                    break;
                }
                reader.getEnd(14);
            }
            catch (IllegalArgumentException e5) {
                Log.note("Internal: IAE: Accelerometer:createSensorInfo:DataDecoder creating request. Err:" + e5.getMessage());
                Accelerometer.addError(3);
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException e6) {
            Log.note("Internal: OOB: Accelerometer:createSensorInfo:DataEncoder could not create request data for FindSensors . Err:" + e6.getMessage());
            Accelerometer.addError(3);
            return null;
        }
        catch (IOException e7) {
            Log.note("Internal: IOE: Accelerometer:createSensorInfo:DataEncoder could not create request data for FindSensors . Err:" + e7.getMessage());
            Accelerometer.addError(3);
            return null;
        }
        catch (NullPointerException e8) {
            Log.note("Internal: NPE: Accelerometer:createSensorInfo:DataEncoder could not create request data for FindSensors . Err:" + ((Throwable)e8).getMessage());
            Accelerometer.addError(3);
            return null;
        }
        AbstractSensor.sensorInfo = sensInfo;
        return sensInfo;
    }

    byte[] getCommand() {
        return null;
    }

    void readValues(DataImpl[] data) throws IOException {
        byte[] arrSize;
        int dataSize;
        if (data[0].getDoubleValues().length == 0) {
            int i2 = 0;
            while (i2 < data.length) {
                Log.note("Set data item: " + i2);
                data[i2].set(1, false, false, false);
                ++i2;
            }
        }
        this.lostData = this.latestSize >= (dataSize = ((arrSize = this.sm.read(4, 0))[3] << 24) + ((arrSize[2] & 0xFF) << 16) + ((arrSize[1] & 0xFF) << 8) + (arrSize[0] & 0xFF)) - 16;
        if (dataSize < 16) {
            return;
        }
        System.arraycopy(this.sm.read(16, dataSize - 16), 0, this.arrLastData, 0, 16);
        Log.note("REC MaxSise:" + dataSize + " Data:" + new String(this.arrLastData));
        this.timestamp = (this.arrLastData[3] << 24) + ((this.arrLastData[2] & 0xFF) << 16) + ((this.arrLastData[1] & 0xFF) << 8) + (this.arrLastData[0] & 0xFF);
        this.axis_x = Float.intBitsToFloat((this.arrLastData[7] << 24) + ((this.arrLastData[6] & 0xFF) << 16) + ((this.arrLastData[5] & 0xFF) << 8) + (this.arrLastData[4] & 0xFF));
        this.axis_y = Float.intBitsToFloat((this.arrLastData[11] << 24) + ((this.arrLastData[10] & 0xFF) << 16) + ((this.arrLastData[9] & 0xFF) << 8) + (this.arrLastData[8] & 0xFF));
        this.axis_z = Float.intBitsToFloat((this.arrLastData[15] << 24) + ((this.arrLastData[14] & 0xFF) << 16) + ((this.arrLastData[13] & 0xFF) << 8) + (this.arrLastData[12] & 0xFF));
        Log.note("Formatted1 Data: X:" + this.axis_x + " Y:" + this.axis_y + " Z:" + this.axis_z);
        int i3 = 0;
        while (i3 < data.length) {
            if (data[i3].getChannelInfo().getDataType() == 2) {
                if (data[i3].getChannelInfo().getName().equals("axis_x")) {
                    data[i3].addIntValue((int)this.axis_x, false);
                    Log.note("Add axis_x: " + data[i3].getIntValues()[0]);
                } else if (data[i3].getChannelInfo().getName().equals("axis_y")) {
                    data[i3].addIntValue((int)this.axis_y, false);
                    Log.note("Add axis_y: " + data[i3].getIntValues()[0]);
                } else if (data[i3].getChannelInfo().getName().equals("axis_z")) {
                    data[i3].addIntValue((int)this.axis_z, false);
                    Log.note("Add axis_z: " + data[i3].getIntValues()[0]);
                }
            } else if (data[i3].getChannelInfo().getDataType() == 1) {
                if (data[i3].getChannelInfo().getName().equals("axis_x")) {
                    data[i3].addDoubleValue(this.axis_x, false);
                } else if (data[i3].getChannelInfo().getName().equals("axis_y")) {
                    data[i3].addDoubleValue(this.axis_y, false);
                } else if (data[i3].getChannelInfo().getName().equals("axis_z")) {
                    data[i3].addDoubleValue(this.axis_z, false);
                }
            } else {
                Accelerometer.addError(1);
                return;
            }
            ++i3;
        }
    }

    private static void addError(int errorID) {
        errors = new int[errors.length + 1];
        int i2 = 0;
        while (i2 < errors.length - 1) {
            if (errors[i2] == errorID) {
                return;
            }
            ++i2;
        }
    }

    public int[] getErrorCodes() {
        return errors;
    }

    public String getErrorText(int errorCode) {
        return SAPIException.getErrorText(errorCode);
    }

    private static boolean verifyVersion() {
        Hashtable<String, String> tbl = new Hashtable<String, String>();
        tbl.put("version", "1.0.0");
        byte[] data = Accelerometer.doCommonSAPIRequest("ProtocolVersion", tbl);
        if (data == null) {
            return false;
        }
        String[] resp = CommonMessagesS40Codec.parseCommonMessage(data, 0, data.length);
        return !resp[0].equals("Error");
    }

    private static byte[] doCommonSAPIRequest(String type, Hashtable vals) {
        Log.note("Start Send; ProtocolVersion Request");
        byte[] data = null;
        try {
            data = CommonMessagesS40Codec.createVersionRequest("1.0");
        }
        catch (IOException e2) {
            Log.note("IOE; IOE when open connection to Open connection to Appearance API with URL Link: " + S40SAPICodec.URI_SENSOR + "\nErrLog: " + e2.getMessage());
            return null;
        }
        try {
            LMPC.send(data, 0, data.length);
        }
        catch (ArrayIndexOutOfBoundsException e3) {
            Log.note("AIOOBE", "The offset or length are negative or would result in an attempt to move beyond the end of the supplied data buffer.\nErrLog: " + e3.getMessage());
            return null;
        }
        catch (IOException e4) {
            Log.note("IOE; I/O error occurs, or the connection is closed.\nErrLog: " + e4.getMessage());
            return null;
        }
        catch (NullPointerException e5) {
            Log.note("NPE; data is null.\nErrLog: " + ((Throwable)e5).getMessage());
            return null;
        }
        Log.note("Receive; Receiving ProtocolVersion Response");
        data = new byte[1024];
        int dataSize = 0;
        try {
            dataSize = LMPC.receive(data);
        }
        catch (IOException e6) {
            Log.note("IOE; I/O error during receiving of ProtolVersion.\nErrLog: " + e6.getMessage());
            return null;
        }
        byte[] shData = new byte[dataSize];
        int i2 = 0;
        while (i2 < dataSize) {
            shData[i2] = data[i2];
            ++i2;
        }
        return shData;
    }

    public boolean closeSAPI() throws IOException {
        DataDecoder reader;
        boolean fail;
        block9: {
            fail = false;
            StringBuffer stringBuffer = new StringBuffer("Closing ");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.nokia.phone.ri.sensor.Accelerometer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.note(stringBuffer.append(clazz.getName()).toString());
            Log.note("Start Req: UnregisterNotifications");
            DataEncoder writer = null;
            try {
                writer = new DataEncoder("Conv-BEB");
                writer.putStart(14, "event");
                writer.put(13, "name", "UnregisterNotifications");
                writer.put(5, "trans_id", 1003L);
                writer.put(5, "registration_id", (long)AbstractSensor.REGISTRATION_ID);
                writer.putEnd(14, "event");
            }
            catch (IOException ioe) {
                Accelerometer.addError(4);
                fail = true;
            }
            Log.note("Start Req: UnregisterNotifications");
            byte[] dataResp = S40SAPICodec.doSAPIRequest(LMPC, writer.getData());
            reader = new DataDecoder("Conv-BEB", dataResp, 0, dataResp.length);
            reader.getStart(14);
            String value = reader.getString(13);
            int trans_id = (int)reader.getInteger(5);
            String status = reader.getString(10);
            if (status.equals("OK")) break block9;
            return true;
        }
        try {
            reader.getEnd(14);
        }
        catch (IllegalArgumentException e2) {
            Log.note("IOE in Encoding of RegisterForDataNotification. " + e2.getMessage());
            Accelerometer.addError(3);
            fail = true;
        }
        return fail;
    }

    public boolean registerSAPI() {
        Log.note("Init sensor");
        if (this.sm != null) {
            return true;
        }
        boolean fail = false;
        int i2 = 0;
        int limit = 10;
        if (this instanceof Accelerometer) {
            DataDecoder reader;
            block9: {
                Log.note("Start Req: RegisterForDataNotification");
                DataEncoder writer = null;
                try {
                    writer = new DataEncoder("Conv-BEB");
                    writer.putStart(14, "event");
                    writer.put(13, "name", "RegisterForDataNotification");
                    writer.put(5, "trans_id", 102L);
                    writer.put(5, "sensor_uid", (long)((Integer)this.getSensorInfo().getProperty("sensor_uid")).intValue());
                    writer.put(7, "interval", (long)((Integer)this.getSensorInfo().getProperty("min_interval")).intValue());
                    writer.putEnd(14, "event");
                }
                catch (IOException e2) {
                    Log.note("IOE in Encoding of RegisterForDataNotification. " + e2.getMessage());
                    return true;
                }
                Log.note("Start Resp: RegisterForDataNotification");
                try {
                    byte[] dataResp = S40SAPICodec.doSAPIRequest(LMPC, writer.getData());
                    reader = new DataDecoder("Conv-BEB", dataResp, 0, dataResp.length);
                    reader.getStart(14);
                    String value = reader.getString(13);
                    reader.getInteger(5);
                    String status = reader.getString(10);
                    if (status.equals("OK")) break block9;
                    Log.note("Status = " + status + " in response RegisterForDataNotification");
                    return true;
                }
                catch (IOException e3) {
                    Log.note("IOE in Decoding of RegisterForDataNotification. " + e3.getMessage());
                    return true;
                }
            }
            AbstractSensor.REGISTRATION_ID = (int)reader.getInteger(5);
            AbstractSensor.SHARED_MEM_URL = reader.getString(12);
            AbstractSensor.MAX_BUFFER = (int)reader.getInteger(7);
            reader.getEnd(14);
        }
        try {
            Log.note("Try to open Shared Memeore access to: " + AbstractSensor.SHARED_MEM_URL);
            this.sm = SharedLocalProtocolMemory.open(LMPC, AbstractSensor.SHARED_MEM_URL, 1);
            fail = false;
        }
        catch (Exception e4) {
            ++i2;
            Log.note("Exception while opening SharedMemory" + e4.getMessage());
            fail = true;
        }
        return fail;
    }
}

