/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.phone.ri.sensor;

import com.nokia.phone.ri.sensor.AbstractSensor;
import com.nokia.phone.ri.sensor.DataImpl;
import com.nokia.phone.ri.sensor.SensorManagerImpl;
import com.nokia.sensor.interfaces.Channel;
import com.nokia.sensor.interfaces.ChannelInfo;
import com.nokia.sensor.interfaces.Condition;
import com.nokia.sensor.interfaces.ConditionListener;
import com.nokia.sensor.interfaces.Data;
import com.nokia.sensor.interfaces.LimitCondition;
import com.nokia.sensor.interfaces.ObjectCondition;
import com.nokia.sensor.interfaces.RangeCondition;
import com.nokia.sensor.interfaces.SensorConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.PushRegistry;

class ChannelImpl
implements Channel {
    private final ChannelInfo channelInfo;
    private ConditionListener conditionListenerPush = null;
    private Vector conditionListeners;
    private Vector conditionListenerConditions;
    private Vector pushConditions = null;
    private final SensorConnection sensor;
    private static final int CLOSED = 12;
    private static final Condition[] NO_CONDITIONS = new Condition[0];
    private static final int[] NO_TIMESTAMPS = new int[0];
    private static final boolean[] NO_VALIDITIES = new boolean[0];
    private static final String SCHEME_CHANNEL = "channel=";
    private static final String SCHEME_SEP2 = "&";
    private static final String SCHEME_LIMIT = "limit=";
    private static final String SCHEME_OP = "op=";
    private static final String SCHEME_LOWER = "lowerLimit=";
    private static final String SCHEME_LOWER_OP = "lowerOp=";
    private static final String SCHEME_UPPER = "upperLimit=";
    private static final String SCHEME_UPPER_OP = "upperOp=";
    private static final int L_LIMIT = "limit=".length();
    private static final int L_OP = "op=".length();
    private static final int L_LOWER = "lowerLimit=".length();
    private static final int L_UPPER = "upperLimit=".length();

    public ChannelImpl(SensorConnection sc, ChannelInfo info) {
        this.channelInfo = info;
        this.sensor = sc;
    }

    public synchronized void addCondition(ConditionListener listener, Condition condition) {
        int index;
        if (listener == null) {
            throw new NullPointerException("Channel: listener was null");
        }
        if (condition == null) {
            String[] o2 = PushRegistry.listConnections((boolean)true);
            if (o2 == null) {
                throw new NullPointerException("Channel: condition was null");
            }
            if (o2.length < 1) {
                throw new NullPointerException("Channel: condition was null");
            }
            SensorManagerImpl.sendPendingNotification(this.sensor, listener);
            return;
        }
        if ((this.sensor.getState() & 0xC) > 0) {
            throw new IllegalStateException("Condition tried to be added to the CLOSED connection");
        }
        int dataType = this.channelInfo.getDataType();
        if (dataType == 4) {
            if (condition instanceof LimitCondition | condition instanceof RangeCondition) {
                throw new IllegalArgumentException("Channel: numeric condition not accepted to object type of channel");
            }
        } else if (condition instanceof ObjectCondition) {
            throw new IllegalArgumentException("Channel: ObjectCondition not accepted to numeric value channel");
        }
        if (this.conditionListeners == null) {
            this.conditionListeners = new Vector();
            this.conditionListenerConditions = new Vector();
        }
        if ((index = this.conditionListeners.indexOf(listener)) < 0) {
            this.conditionListeners.addElement(listener);
            Vector<Condition> tmpConditions = new Vector<Condition>();
            tmpConditions.addElement(condition);
            this.conditionListenerConditions.addElement(tmpConditions);
            ((AbstractSensor)this.sensor).setMonitoring(true);
            return;
        }
        Vector tmpConditions = (Vector)this.conditionListenerConditions.elementAt(index);
        if (tmpConditions.contains(condition)) {
            return;
        }
        tmpConditions.addElement(condition);
        this.conditionListenerConditions.setElementAt(tmpConditions, index);
    }

    public ChannelInfo getChannelInfo() {
        return this.channelInfo;
    }

    public synchronized Condition[] getConditions(ConditionListener listener) {
        if (listener == null) {
            throw new NullPointerException("getConditions() called with null listener");
        }
        if (this.conditionListeners == null) {
            return NO_CONDITIONS;
        }
        int index = -1;
        index = this.conditionListeners.indexOf(listener);
        if (index < 0) {
            return NO_CONDITIONS;
        }
        Object o2 = this.conditionListenerConditions.elementAt(index);
        if (o2 == null) {
            return NO_CONDITIONS;
        }
        Vector tmpConditions = (Vector)o2;
        int l2 = tmpConditions.size();
        if (l2 < 1) {
            return NO_CONDITIONS;
        }
        Condition[] conds = new Condition[l2];
        int i2 = 0;
        while (i2 < l2) {
            conds[i2] = (Condition)tmpConditions.elementAt(i2);
            ++i2;
        }
        return conds;
    }

    public String getChannelUrl() {
        if (this.conditionListenerConditions == null) {
            return "";
        }
        int l2 = this.conditionListenerConditions.size();
        if (l2 < 1) {
            return "";
        }
        StringBuffer urlBuf = new StringBuffer(SCHEME_CHANNEL + this.channelInfo.getName() + SCHEME_SEP2);
        Hashtable<String, String> uniqueConditions = new Hashtable<String, String>();
        int i2 = 0;
        while (i2 < l2) {
            Vector tmpConditions = (Vector)this.conditionListenerConditions.elementAt(i2);
            int j2 = 0;
            int l22 = tmpConditions.size();
            while (j2 < l22) {
                String url = ChannelImpl.getUrl((Condition)tmpConditions.elementAt(j2));
                if (!uniqueConditions.containsKey(url)) {
                    uniqueConditions.put(url, url);
                }
                ++j2;
            }
            ++i2;
        }
        Enumeration e2 = uniqueConditions.elements();
        while (e2.hasMoreElements()) {
            urlBuf.append(e2.nextElement() + (e2.hasMoreElements() ? SCHEME_SEP2 : ""));
        }
        return urlBuf.toString();
    }

    public synchronized void removeAllConditions() {
        if ((this.sensor.getState() & 0xC) > 0) {
            throw new IllegalStateException("removeAllCondition called  - connection CLOSED");
        }
        this.conditionListeners = null;
        this.conditionListenerConditions = null;
        ((AbstractSensor)this.sensor).setMonitoring(false);
    }

    public synchronized void removeCondition(ConditionListener listener, Condition condition) {
        if (listener == null) {
            throw new NullPointerException("Channel:removeCondition - listener is null");
        }
        if (condition == null) {
            throw new NullPointerException("Channel:removeCondition - condition is null");
        }
        if ((this.sensor.getState() & 0xC) > 0) {
            throw new IllegalStateException("removeCondition called  - connection CLOSED");
        }
        if (this.conditionListeners == null) {
            return;
        }
        int index = this.conditionListeners.indexOf(listener);
        if (index < 0) {
            return;
        }
        Vector tmpConditions = (Vector)this.conditionListenerConditions.elementAt(index);
        int index2 = tmpConditions.indexOf(condition);
        if (index2 < 0) {
            return;
        }
        tmpConditions.removeElementAt(index2);
        if (tmpConditions.size() < 1) {
            this.removeConditionListener(listener);
            return;
        }
        this.conditionListenerConditions.setElementAt(tmpConditions, index);
    }

    public synchronized void removeConditionListener(ConditionListener listener) {
        if ((this.sensor.getState() & 0xC) > 0) {
            throw new IllegalStateException("removeConditionListener called  - connection CLOSED");
        }
        if (listener == null) {
            throw new NullPointerException("removeConditionListener() called with null listener");
        }
        if (this.conditionListeners == null) {
            return;
        }
        int index = this.conditionListeners.indexOf(listener);
        if (index < 0) {
            return;
        }
        this.conditionListeners.removeElementAt(index);
        this.conditionListenerConditions.removeElementAt(index);
        if (this.conditionListeners.size() < 1) {
            ((AbstractSensor)this.sensor).setMonitoring(false);
        }
    }

    synchronized void addPushCondition(Condition condition) {
        if (this.pushConditions == null) {
            this.pushConditions = new Vector();
        }
        if (this.pushConditions.contains(condition)) {
            return;
        }
        this.pushConditions.addElement(condition);
    }

    static Condition getCondition(String url) {
        if (url == null) {
            throw new NullPointerException();
        }
        String doubleStr = null;
        try {
            if (url.indexOf(SCHEME_LOWER) > -1) {
                int i2 = url.indexOf(SCHEME_SEP2);
                doubleStr = url.substring(L_LOWER, i2);
                double lower = Double.parseDouble(doubleStr);
                String lowerOp = "";
                i2 = url.indexOf(SCHEME_UPPER);
                doubleStr = url.substring(i2 + L_UPPER);
                double upper = Double.parseDouble(doubleStr);
                String upperOp = "";
                return new RangeCondition(lower, lowerOp, upper, upperOp);
            }
            if (url.indexOf(SCHEME_LIMIT) == -1) {
                throw new IllegalArgumentException("Given Condition URL " + url + " was corrupted.");
            }
            if (url.indexOf(SCHEME_OP) > -1) {
                int i3 = url.indexOf(SCHEME_SEP2);
                doubleStr = url.substring(L_LIMIT, i3);
                double limit = Double.parseDouble(doubleStr);
                i3 = url.indexOf(SCHEME_OP);
                String op = url.substring(i3 + L_OP);
                return new LimitCondition(limit, op);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("getCondition() with url " + url + " failed.");
    }

    synchronized ConditionListener getPushConditionListener() {
        return this.conditionListenerPush;
    }

    synchronized Condition[] getPushConditions() {
        if (this.pushConditions == null) {
            return NO_CONDITIONS;
        }
        Condition[] conditions = new Condition[this.pushConditions.size()];
        int i2 = 0;
        Enumeration e2 = this.pushConditions.elements();
        while (e2.hasMoreElements()) {
            conditions[i2] = (Condition)e2.nextElement();
            ++i2;
        }
        return conditions;
    }

    static String getUrl(Condition condition) {
        if (condition instanceof LimitCondition) {
            LimitCondition c2 = (LimitCondition)condition;
            return SCHEME_LIMIT + c2.getLimit() + SCHEME_SEP2 + SCHEME_OP + c2.getOperator();
        }
        if (condition instanceof RangeCondition) {
            RangeCondition c3 = (RangeCondition)condition;
            return SCHEME_LOWER + c3.getLowerLimit() + SCHEME_SEP2 + SCHEME_LOWER_OP + c3.getLowerOp() + SCHEME_SEP2 + SCHEME_UPPER + c3.getUpperLimit() + SCHEME_SEP2 + SCHEME_UPPER_OP + c3.getUpperOp();
        }
        return "";
    }

    synchronized boolean isMonitoring() {
        if (this.conditionListeners == null) {
            return false;
        }
        return this.conditionListeners.size() > 0;
    }

    void monitorDoubleValue(SensorConnection sc, double value) {
        double[] tmpValues = new double[]{value};
        this.checkConditions(sc, tmpValues, value);
    }

    void monitorIntValue(SensorConnection sc, int value) {
        int[] tmpValues = new int[]{value};
        this.checkConditions(sc, tmpValues, value);
    }

    void monitorObjectValue(SensorConnection sc, Object value) {
        Object[] tmpValues = new Object[]{value};
        if (this.conditionListenerConditions != null) {
            int i2 = 0;
            while (i2 < this.conditionListenerConditions.size()) {
                Vector tmpConditions = (Vector)this.conditionListenerConditions.elementAt(i2);
                ConditionListener listener = (ConditionListener)this.conditionListeners.elementAt(i2);
                int j2 = 0;
                while (j2 < tmpConditions.size()) {
                    Condition cond = (Condition)tmpConditions.elementAt(j2);
                    if (cond.isMet(value)) {
                        if (SensorManagerImpl.isDebug) {
                            System.out.println(cond + " met: " + value);
                        }
                        this.triggerConditionMet(sc, listener, tmpValues, cond);
                        tmpConditions.removeElement(cond);
                        --j2;
                    }
                    ++j2;
                }
                if (tmpConditions.size() == 0) {
                    --i2;
                }
                if (this.conditionListenerConditions == null || this.conditionListenerConditions.size() < 1) break;
                ++i2;
            }
        }
        if (this.getPushConditionListener() == null) {
            return;
        }
        Condition[] conditions = this.getPushConditions();
        int i3 = 0;
        while (i3 < conditions.length) {
            if (conditions[i3].isMet(value)) {
                this.triggerConditionMetPush(sc, tmpValues, conditions[i3]);
                return;
            }
            ++i3;
        }
    }

    synchronized void removeAllPushConditions() {
        if (this.pushConditions == null) {
            return;
        }
        this.pushConditions.removeAllElements();
    }

    synchronized void removePushConditionListener() {
        this.conditionListenerPush = null;
        ((AbstractSensor)this.sensor).setMonitoring(false);
    }

    synchronized void setPushConditionListener(ConditionListener listener) {
        this.conditionListenerPush = listener;
        ((AbstractSensor)this.sensor).setMonitoring(true);
    }

    private void checkConditions(SensorConnection sc, Object tmpValues, double value) {
        block11: {
            try {
                if (this.conditionListenerConditions == null) break block11;
                int i2 = 0;
                while (i2 < this.conditionListenerConditions.size()) {
                    Vector tmpConditions = (Vector)this.conditionListenerConditions.elementAt(i2);
                    ConditionListener listener = (ConditionListener)this.conditionListeners.elementAt(i2);
                    int j2 = 0;
                    while (j2 < tmpConditions.size()) {
                        Condition cond = (Condition)tmpConditions.elementAt(j2);
                        if (cond.isMet(value)) {
                            if (SensorManagerImpl.isDebug) {
                                System.out.println(cond + " met: " + value);
                            }
                            this.triggerConditionMet(sc, listener, tmpValues, cond);
                            tmpConditions.removeElement(cond);
                            --j2;
                        }
                        ++j2;
                    }
                    if (tmpConditions.size() == 0) {
                        --i2;
                    }
                    if (this.conditionListenerConditions != null && this.conditionListenerConditions.size() >= 1) {
                        ++i2;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        if (this.getPushConditionListener() == null) {
            return;
        }
        Condition[] conditions = this.getPushConditions();
        int i3 = 0;
        while (i3 < conditions.length) {
            if (conditions[i3].isMet(value)) {
                this.triggerConditionMetPush(sc, tmpValues, conditions[i3]);
                return;
            }
            ++i3;
        }
    }

    private void conditionMetPush(SensorConnection sensor, Data data, Condition condition) {
        if (this.getPushConditionListener() != null) {
            this.getPushConditionListener().conditionMet(sensor, data, condition);
        }
    }

    private void triggerConditionMet(SensorConnection sc, ConditionListener listener, Object value, Condition condition) {
        int[] timestamps = new int[1];
        long startTime = System.currentTimeMillis();
        boolean[] validities = new boolean[]{true};
        DataImpl dm = new DataImpl(this.channelInfo, value, startTime, timestamps, validities);
        listener.conditionMet(sc, dm, condition);
        this.removeCondition(listener, condition);
    }

    private void triggerConditionMetPush(SensorConnection sc, Object value, Condition condition) {
        DataImpl dm = DataImpl.valueOf(this.channelInfo, value, NO_TIMESTAMPS, NO_VALIDITIES);
        this.conditionMetPush(sc, dm, condition);
    }
}

