/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.phone.ri.sensor;

import com.nokia.sensor.interfaces.ChannelInfo;
import com.nokia.sensor.interfaces.MeasurementRange;
import com.nokia.sensor.interfaces.Unit;

public class ChannelInfoImpl
implements ChannelInfo {
    private final float accuracy;
    private final int dataType;
    private final String name;
    private static final MeasurementRange[] NO_RANGES = new MeasurementRange[0];
    private final MeasurementRange[] ranges;
    private final int scale;
    private final Unit unit;

    public ChannelInfoImpl(String name, int scale, Unit unit, float accuracy, int dataType, MeasurementRange[] ranges) {
        if (name == null) {
            throw new NullPointerException("Channel name cannot be null.");
        }
        this.name = name;
        this.scale = scale;
        if (unit == null) {
            throw new NullPointerException("Channel unit cannot be null.");
        }
        this.unit = unit;
        if (0.0f > accuracy | accuracy >= 1.0f) {
            throw new IllegalArgumentException("Channel accuracy should be 0<=accuracy<1 - the given accuracy was " + accuracy + ".");
        }
        this.accuracy = accuracy;
        if (dataType != 4 && dataType != 2 && dataType != 1) {
            throw new IllegalArgumentException("Channel dataType was not TYPE_INT/TYPE_DOUBLE/TYPE_OBJECT");
        }
        this.dataType = dataType;
        if (ranges == null) {
            throw new NullPointerException();
        }
        this.ranges = ranges;
    }

    public float getAccuracy() {
        return this.accuracy;
    }

    public int getDataType() {
        return this.dataType;
    }

    public String getName() {
        return this.name;
    }

    public MeasurementRange[] getMeasurementRanges() {
        if (this.dataType == 4) {
            return NO_RANGES;
        }
        return this.ranges;
    }

    public int getScale() {
        return this.scale;
    }

    public Unit getUnit() {
        return this.unit;
    }
}

