/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.phone.ri.sensor;

import com.nokia.mid.appl.sa.tool.Log;
import com.nokia.mid.s40.io.SharedLocalProtocolMemory;
import com.nokia.phone.ri.sensor.Accelerometer;
import com.nokia.phone.ri.sensor.ChannelImpl;
import com.nokia.phone.ri.sensor.DataImpl;
import com.nokia.phone.ri.sensor.DataPool;
import com.nokia.phone.ri.sensor.SensorManagerImpl;
import com.nokia.sensor.interfaces.Channel;
import com.nokia.sensor.interfaces.ChannelInfo;
import com.nokia.sensor.interfaces.Data;
import com.nokia.sensor.interfaces.DataListener;
import com.nokia.sensor.interfaces.MeasurementRange;
import com.nokia.sensor.interfaces.SensorConnection;
import com.nokia.sensor.interfaces.SensorInfo;
import java.io.IOException;
import java.util.Hashtable;

abstract class AbstractSensor
implements SensorConnection,
Runnable {
    public SharedLocalProtocolMemory sm = null;
    static final int[] NO_CODES = new int[0];
    DataImpl[] data = null;
    static SensorInfo sensorInfo;
    static final IllegalArgumentException EXP;
    static final String CLOSE_STR = "#CLOSE#######";
    static final String PROP_CLASS_NAME = "com.nokia.className";
    static final String PROP_INTERNAL_URL = "com.nokia.internalUrl";
    static final String PROP_PERMISSION = "com.nokia.permission";
    static final int POOL_SIZE;
    static final int STATE_CLOSING = 8;
    private static final int CLOSED = 12;
    private static final Preferences DEF_PREFS;
    private static final Data[] NO_DATA;
    static int MAX_BUFFER;
    static String SHARED_MEM_URL;
    static int REGISTRATION_ID;
    private Hashtable channels = new Hashtable();
    private DataListener dataListener = null;
    private DataPool dataPool;
    private static boolean isDebug;
    private boolean isGettingData = false;
    private boolean isMonitoring = false;
    private int ioeCount = 0;
    private Object lock = new Object();
    private Preferences prefs = DEF_PREFS;
    private int state = 1;
    private long startTimestamp = -1L;

    static {
        EXP = new IllegalArgumentException();
        POOL_SIZE = System.getProperty("microedition.sensor.pool.size") == null ? 1 : Integer.parseInt(System.getProperty("microedition.sensor.pool.size"));
        DEF_PREFS = new Preferences(1, 0L, false, false, false);
        NO_DATA = new DataImpl[0];
        MAX_BUFFER = 256;
        SHARED_MEM_URL = null;
        REGISTRATION_ID = -1;
        isDebug = SensorManagerImpl.isDebug;
    }

    AbstractSensor() {
    }

    public void close() throws IOException {
        block8: {
            if (this.getState() == 4) {
                return;
            }
            if (this.getState() == 8) {
                this.setState(4);
                return;
            }
            try {
                this.setState(8);
                SensorManagerImpl.removeSensor(this.getSensorInfo());
                this.sm.close();
                this.doClose();
                if (this instanceof Accelerometer) {
                    if (((Accelerometer)this).closeSAPI()) {
                        Log.note("Accelerometer UnregisterForDataNotification failed.");
                    } else {
                        Log.note("Accelerometer UnregisterForDataNotification success.");
                    }
                } else {
                    Log.note("NO Accelerometer found.");
                }
                this.setState(4);
            }
            catch (Throwable t2) {
                if (!(t2 instanceof Exception)) break block8;
                ((Exception)t2).printStackTrace();
            }
        }
    }

    public Channel getChannel(ChannelInfo info) {
        if (info == null) {
            throw new NullPointerException("SensorConnection.getChannel() called with null info");
        }
        ChannelInfo[] channelInfos = this.getSensorInfo().getChannelInfos();
        int i2 = 0;
        int l2 = channelInfos.length;
        while (i2 < l2) {
            if (info == channelInfos[i2]) break;
            if (i2 == l2 - 1) {
                throw new IllegalArgumentException("Given info not found amongst valid ChannelInfo objects");
            }
            ++i2;
        }
        if (this.channels.containsKey(info)) {
            return (Channel)this.channels.get(info);
        }
        ChannelImpl channel = new ChannelImpl(this, info);
        this.channels.put(info, channel);
        return channel;
    }

    public Data[] getData(int bufferSize) throws IOException {
        Data[] d2;
        while ((d2 = this.getData2(bufferSize)).length == 0) {
        }
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data[] getData(int bufferSize, long bufferingPeriod, boolean isTimestampIncluded, boolean isUncertaintyIncluded, boolean isValidityIncluded) throws IOException {
        if ((this.getState() & 0xC) > 0) {
            throw new IOException();
        }
        if (this.getState() != 1) {
            throw new IllegalStateException();
        }
        if (bufferSize < 1 && bufferingPeriod < 1L) {
            throw new IllegalArgumentException("getData: bufferSize<1 && bufferingPeriod<1");
        }
        if (bufferSize > this.getSensorInfo().getMaxBufferSize()) {
            throw new IllegalArgumentException("getData: bufferSize too big =" + bufferSize);
        }
        this.setDataPreferences(bufferSize, bufferingPeriod, isTimestampIncluded, isUncertaintyIncluded, isValidityIncluded);
        this.setGettingData(true);
        while (this.isGettingData()) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object = this.getLock();
        synchronized (object) {
            if (isDebug) {
                Log.note("AbstractSensor: returning populated data");
            }
            if (this.getErrorCount() > 0) {
                this.resetErrorCount();
                throw new IOException();
            }
            if ((this.getState() & 0xC) > 0) {
                throw new IOException();
            }
            return this.getPopulatedData();
        }
    }

    public SensorInfo getSensorInfo() {
        return sensorInfo;
    }

    public synchronized int getState() {
        if (this.state == 8) {
            return 4;
        }
        return this.state;
    }

    public synchronized void removeDataListener() {
        if ((this.getState() & 0xC) > 0) {
            throw new IllegalStateException();
        }
        this.dataListener = null;
        this.setState(1);
        this.setGettingData(false);
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void setDataListener(DataListener listener, int bufferSize) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (bufferSize < 1) {
            throw new IllegalArgumentException("setDataListener: bufferSize<1");
        }
        if (bufferSize > MAX_BUFFER) {
            throw new IllegalArgumentException("setDataListener: bufferSize too big =" + MAX_BUFFER);
        }
        this.setDataListener(listener, bufferSize, -1L, false, false, false);
    }

    public synchronized void setDataListener(DataListener listener, int bufferSize, long bufferingPeriod, boolean isTimestampIncluded, boolean isUncertaintyIncluded, boolean isValidityIncluded) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (bufferSize < 1 && bufferingPeriod < 1L) {
            throw new IllegalArgumentException("setDataListener: bufferSize<1 && bufferingPeriod<1");
        }
        if (bufferSize > this.getSensorInfo().getMaxBufferSize()) {
            throw new IllegalArgumentException("setDataListener: bufferSize too big =" + bufferSize);
        }
        this.dataListener = listener;
        this.setState(2);
        this.setDataPreferences(bufferSize, bufferingPeriod, isTimestampIncluded, isUncertaintyIncluded, isValidityIncluded);
        this.notify();
    }

    void activate() {
        this.doActivate();
    }

    void doActivate() {
        if (this instanceof Accelerometer && ((Accelerometer)this).registerSAPI()) {
            Log.note("Create acc instance failed.");
            return;
        }
        Log.note("Start data fetch thread");
        new Thread(this).start();
    }

    synchronized void doClose() {
        boolean closed = false;
        int i2 = 0;
        do {
            ++i2;
            try {
                this.sm.close();
                closed = true;
            }
            catch (Exception e2) {
                if (!isDebug) continue;
                e2.printStackTrace();
            }
        } while (!closed && i2 < 10);
    }

    abstract byte[] getCommand();

    Object getLock() {
        return this.lock;
    }

    void initDataPool() {
        this.dataPool = new DataPool(this.getSensorInfo(), POOL_SIZE);
    }

    boolean isAvailable() {
        int count;
        block5: {
            count = 0;
            try {
                count = this.sm.getSize();
                if (count > 0) break block5;
                return false;
            }
            catch (Exception e2) {
                if (isDebug) {
                    e2.printStackTrace();
                }
                return false;
            }
        }
        byte[] b2 = this.sm.read(count, 0);
        if (isDebug) {
            Log.note("AbstractSensor: isAvailable");
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    boolean isConnected() {
        if ((this.getState() & 0xC) > 0) {
            return false;
        }
        int i2 = 0;
        while (i2 < 5) {
            if (this.isAvailable()) break;
            if (i2 > 3) {
                if (isDebug) {
                    Log.note("AbstractSensor: isConnected: is not available");
                }
                return false;
            }
            ++i2;
        }
        int bufferSize = 10;
        int maxInvalidCount = 3;
        Data[] d2 = new Data[]{};
        try {
            d2 = this.getData(bufferSize, -1L, false, false, true);
        }
        catch (Exception e2) {
            if (isDebug) {
                Log.note("AbstractSensor: " + this + " getData() fails");
                e2.printStackTrace();
            }
            return false;
        }
        if (d2.length == 0) {
            return false;
        }
        int j2 = 0;
        int l2 = d2.length;
        while (j2 < l2) {
            block25: {
                int invalid = 0;
                if (d2[j2].getChannelInfo().getDataType() == 1) {
                    double[] dArray = d2[j2].getDoubleValues();
                    try {
                        int i3 = 0;
                        while (i3 < bufferSize) {
                            if ((invalid += d2[j2].isValid(i3) ? 0 : 1) > maxInvalidCount) {
                                if (isDebug) {
                                    Log.note("AbstractSensor: invalid data value count exceeded limit - NOT connected");
                                }
                                return false;
                            }
                            ++i3;
                        }
                    }
                    catch (Exception e3) {
                        if (!isDebug) break block25;
                        e3.printStackTrace();
                    }
                } else if (d2[j2].getChannelInfo().getDataType() == 2) {
                    int[] nArray = d2[j2].getIntValues();
                    int i4 = 0;
                    while (i4 < bufferSize) {
                        if (isDebug) {
                            Log.note("AbstractSensor:isConnected value[" + i4 + "] =" + nArray[i4] + " valid=" + d2[j2].isValid(i4));
                        }
                        if ((invalid += d2[j2].isValid(i4) ? 0 : 1) > maxInvalidCount) {
                            return false;
                        }
                        ++i4;
                    }
                } else if (d2[j2].getChannelInfo().getDataType() == 4) {
                    Object[] objectArray = d2[j2].getObjectValues();
                    int i5 = 0;
                    while (i5 < bufferSize) {
                        if (isDebug) {
                            Log.note("AbstractSensor:isConnected value[" + i5 + "] =" + objectArray[i5] + " valid=" + d2[j2].isValid(i5));
                        }
                        if ((invalid += d2[j2].isValid(i5) ? 0 : 1) > maxInvalidCount) {
                            return false;
                        }
                        ++i5;
                    }
                }
            }
            ++j2;
        }
        return true;
    }

    boolean isInRange(ChannelInfo channel, double value) {
        MeasurementRange[] ranges = channel.getMeasurementRanges();
        int i2 = 0;
        int l2 = ranges.length;
        while (i2 < l2) {
            if (value < ranges[i2].getSmallestValue()) {
                return false;
            }
            if (value > ranges[i2].getLargestValue()) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    void populate() {
        int size = 0;
        this.resetErrorCount();
        long timestamp = 0L;
        long tmpTimestamp = 0L;
        while ((tmpTimestamp = this.getStartTimestamp()) != timestamp) {
            timestamp = tmpTimestamp;
            size = this.getResolvedSize();
            this.setDataImpl(size);
            long bufferingPeriod = this.prefs.getBufferingPeriod();
            if (bufferingPeriod > 0L) {
                int i2;
                block15: {
                    long startTime = System.currentTimeMillis();
                    i2 = 0;
                    try {
                        while (i2 < size && (this.getState() & 0xC) < 1 && System.currentTimeMillis() - startTime < bufferingPeriod && timestamp == this.getStartTimestamp()) {
                            this.readValues(this.data);
                            ++i2;
                        }
                    }
                    catch (IOException ioe) {
                        if (isDebug) {
                            Log.note("IOE, reading values. " + ioe.getMessage());
                        }
                        this.addErrorCount();
                    }
                    catch (Exception e2) {
                        if (!isDebug) break block15;
                        e2.printStackTrace();
                    }
                }
                if (i2 >= size - 1) continue;
                int j2 = 0;
                int l2 = this.data.length;
                while (j2 < l2) {
                    this.data[j2].truncate();
                    ++j2;
                }
                continue;
            }
            if (isDebug) {
                Log.note("AbstractSensor:populate - bufferSize = " + size);
            }
            try {
                int i3 = 0;
                while (i3 < size && (this.getState() & 0xC) < 1 && timestamp == this.getStartTimestamp()) {
                    this.readValues(this.data);
                    ++i3;
                }
            }
            catch (IOException ioe) {
                if (isDebug) {
                    Log.note("IOE, reading values. " + ioe.getMessage());
                }
                this.addErrorCount();
            }
            catch (Exception e3) {
                if (isDebug) {
                    e3.printStackTrace();
                }
                Log.error("Abstract Sensor populate: " + e3.toString());
            }
        }
    }

    abstract void readValues(DataImpl[] var1) throws IOException;

    synchronized void setMonitoring(boolean isMonitoring) {
        if (isMonitoring) {
            this.isMonitoring = isMonitoring;
            this.notify();
            return;
        }
        ChannelInfo[] channelInfos = this.getSensorInfo().getChannelInfos();
        int i2 = 0;
        int l2 = channelInfos.length;
        while (i2 < l2) {
            ChannelImpl channel = (ChannelImpl)this.getChannel(channelInfos[i2]);
            if (channel.isMonitoring()) {
                return;
            }
            if (channel.getPushConditionListener() != null) {
                return;
            }
            ++i2;
        }
        this.isMonitoring = isMonitoring;
    }

    synchronized void setState(int state) throws IllegalStateException {
        int exState = this.getState();
        if (state == exState) {
            return;
        }
        switch (exState) {
            case 8: {
                if (state == 4) {
                    this.state = state;
                    return;
                }
                throw new IllegalStateException(this.getMsg(exState, state));
            }
            case 4: {
                if (state == 4) {
                    return;
                }
                if (state == 8) {
                    return;
                }
                throw new IllegalStateException(this.getMsg(exState, state));
            }
            case 1: {
                switch (state) {
                    case 2: 
                    case 4: 
                    case 8: {
                        this.state = state;
                        return;
                    }
                }
                throw new IllegalStateException(this.getMsg(exState, state));
            }
            case 2: {
                switch (state) {
                    case 1: 
                    case 4: 
                    case 8: {
                        this.state = state;
                        return;
                    }
                }
                throw new IllegalStateException(this.getMsg(exState, state));
            }
        }
    }

    private synchronized void addErrorCount() {
        ++this.ioeCount;
    }

    private long getBufferingPeriod() {
        return this.prefs.getBufferingPeriod();
    }

    private int getBufferSize() {
        return this.prefs.getBufferSize();
    }

    private Data[] getData2(int bufferSize) throws IOException {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("getData: bufferSize<1");
        }
        if (bufferSize > this.getSensorInfo().getMaxBufferSize()) {
            throw new IllegalArgumentException("getData: bufferSize too big =" + bufferSize);
        }
        return this.getData(bufferSize, -1L, false, false, false);
    }

    private DataImpl[] getDataImpl(int size) {
        ChannelInfo[] channel = this.getSensorInfo().getChannelInfos();
        DataImpl[] d2 = new DataImpl[channel.length];
        int i2 = 0;
        int l2 = channel.length;
        while (i2 < l2) {
            block3: {
                try {
                    d2[i2] = new DataImpl(channel[i2], size, this.isTimestampIncluded(), this.isUncertaintyIncluded(), this.isValidityIncluded());
                }
                catch (Exception e2) {
                    if (!isDebug) break block3;
                    e2.printStackTrace();
                }
            }
            ++i2;
        }
        return d2;
    }

    private synchronized DataListener getDataListener() {
        return this.dataListener;
    }

    private synchronized int getErrorCount() {
        return this.ioeCount;
    }

    private String getMsg(int exState, int state) {
        return "State was tried to be changed: " + this.getState(exState) + " -> " + this.getState(state);
    }

    private Data[] getPopulatedData() {
        if (this.data == null) {
            return NO_DATA;
        }
        if (this.data.length > 0) {
            return this.data;
        }
        return NO_DATA;
    }

    private synchronized int getResolvedSize() {
        int maxBufferSize;
        int size = this.getBufferSize();
        long bufferingPeriod = this.getBufferingPeriod();
        float maxSamplingRate = ((Float)this.getSensorInfo().getProperty("maxSamplingRate")).floatValue();
        if (size < 1) {
            size = (int)((float)bufferingPeriod * maxSamplingRate / 1000.0f);
        }
        return size > (maxBufferSize = this.getSensorInfo().getMaxBufferSize()) ? maxBufferSize : size;
    }

    private synchronized long getStartTimestamp() {
        return this.startTimestamp;
    }

    private String getState(int state) {
        switch (state) {
            case 1: {
                return "OPENED";
            }
            case 2: {
                return "LISTENING";
            }
            case 4: {
                return "CLOSED";
            }
            case 8: {
                return "CLOSING";
            }
        }
        return "";
    }

    private synchronized boolean isGettingData() {
        return this.isGettingData;
    }

    private synchronized boolean isMonitoring() {
        return this.isMonitoring;
    }

    private synchronized void resetErrorCount() {
        this.ioeCount = 0;
    }

    private synchronized boolean isOkToPopulate() {
        if (this.getDataListener() != null) {
            return true;
        }
        if (this.isMonitoring()) {
            return true;
        }
        return this.isGettingData();
    }

    private boolean isTimestampIncluded() {
        return this.prefs.isTimestampIncluded();
    }

    private boolean isUncertaintyIncluded() {
        return this.prefs.isUncertaintyIncluded();
    }

    private boolean isValidityIncluded() {
        return this.prefs.isValidityIncluded();
    }

    private synchronized void setDataImpl(int size) {
        if (POOL_SIZE > 0) {
            this.data = this.dataPool.get(size, this.isTimestampIncluded(), this.isUncertaintyIncluded(), this.isValidityIncluded());
            return;
        }
        this.data = this.getDataImpl(size);
    }

    private synchronized void setDataPreferences(int bufferSize, long bufferingPeriod, boolean isTimestampIncluded, boolean isUncertaintyIncluded, boolean isValidityIncluded) {
        this.setStartTimestamp();
        if (this.prefs.isOk(bufferSize, bufferingPeriod, isTimestampIncluded, isUncertaintyIncluded, isValidityIncluded)) {
            return;
        }
        if (!(bufferSize != 1 || bufferingPeriod != 0L || isTimestampIncluded || isUncertaintyIncluded || isValidityIncluded)) {
            this.prefs = DEF_PREFS;
            return;
        }
        this.prefs = new Preferences(bufferSize, bufferingPeriod, isTimestampIncluded, isUncertaintyIncluded, isValidityIncluded);
    }

    private synchronized void setGettingData(boolean isGettingData) {
        this.isGettingData = isGettingData;
        this.notify();
    }

    private synchronized void setStartTimestamp() {
        this.startTimestamp = System.currentTimeMillis();
    }

    public abstract /* synthetic */ String getErrorText(int var1);

    public abstract /* synthetic */ int[] getErrorCodes();

    private static class Preferences {
        private final int bufferSize;
        private final long bufferingPeriod;
        private final boolean isTimestampIncluded;
        private final boolean isUncertaintyIncluded;
        private final boolean isValidityIncluded;

        Preferences(int bufferSize, long bufferingPeriod, boolean isTimestampIncluded, boolean isUncertaintyIncluded, boolean isValidityIncluded) {
            this.bufferSize = bufferSize;
            this.bufferingPeriod = bufferingPeriod;
            this.isTimestampIncluded = isTimestampIncluded;
            this.isUncertaintyIncluded = isUncertaintyIncluded;
            this.isValidityIncluded = isValidityIncluded;
        }

        final int getBufferSize() {
            return this.bufferSize;
        }

        final long getBufferingPeriod() {
            return this.bufferingPeriod;
        }

        final boolean isTimestampIncluded() {
            return this.isTimestampIncluded;
        }

        final boolean isUncertaintyIncluded() {
            return this.isUncertaintyIncluded;
        }

        final boolean isValidityIncluded() {
            return this.isValidityIncluded;
        }

        boolean isOk(Preferences prefs) {
            return this.isOk(prefs.getBufferSize(), prefs.getBufferingPeriod(), prefs.isTimestampIncluded(), prefs.isUncertaintyIncluded(), prefs.isValidityIncluded());
        }

        boolean isOk(int bufferSize, long bufferingPeriod, boolean isTimestampIncluded, boolean isUncertaintyIncluded, boolean isValidityIncluded) {
            if (bufferSize != this.bufferSize) {
                return false;
            }
            if (bufferingPeriod != this.bufferingPeriod) {
                return false;
            }
            if (isTimestampIncluded != this.isTimestampIncluded) {
                return false;
            }
            if (isUncertaintyIncluded != this.isUncertaintyIncluded) {
                return false;
            }
            return isValidityIncluded ^ this.isValidityIncluded;
        }
    }
}

