/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.s40.io;

import com.nokia.mid.s40.io.LocalMessageProtocolConnection;
import java.io.IOException;
import javax.microedition.io.Connection;

public class SharedLocalProtocolMemory {
    private int slpmMemPtr = 0;
    private int slpmFileDes = 0;
    private int msgSockDes = 0;
    private int slpmSize = 0;
    private int slpmMode = 0;
    private int isServer = 0;
    private String slpmUri = null;
    private static final int SLPM_NONE = 0;
    private static final int SLPM_TRUE = 1;
    private static final int SLPM_FALSE = 0;
    public static final int SLPM_READ = 1;
    public static final int SLPM_WRITE = 2;
    public static final int SLPM_READWRITE = 3;

    private SharedLocalProtocolMemory(int n2) throws IOException {
        this.slpmSize = n2;
        this.isServer = 1;
        try {
            this.nCreate();
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
    }

    private SharedLocalProtocolMemory(LocalMessageProtocolConnection localMessageProtocolConnection, String string, int n2) throws IOException {
        this.slpmMode = n2;
        this.slpmUri = string;
        try {
            this.nOpen((Connection)localMessageProtocolConnection);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
    }

    public static SharedLocalProtocolMemory create(int n2) throws IOException, IllegalArgumentException {
        try {
            SharedLocalProtocolMemory sharedLocalProtocolMemory = new SharedLocalProtocolMemory(n2);
            return sharedLocalProtocolMemory;
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(illegalArgumentException.getMessage());
        }
    }

    public static SharedLocalProtocolMemory open(LocalMessageProtocolConnection localMessageProtocolConnection, String string, int n2) throws IOException, IllegalArgumentException {
        if (localMessageProtocolConnection == null) {
            throw new IllegalArgumentException("SharedLocalProtocolMemory: Connection cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("SharedLocalProtocolMemory: URI cannot be null");
        }
        try {
            SharedLocalProtocolMemory sharedLocalProtocolMemory = new SharedLocalProtocolMemory(localMessageProtocolConnection, string, n2);
            return sharedLocalProtocolMemory;
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(illegalArgumentException.getMessage());
        }
    }

    public void attach(LocalMessageProtocolConnection localMessageProtocolConnection, int n2) throws IOException, IllegalArgumentException {
        if (localMessageProtocolConnection == null) {
            throw new IllegalArgumentException("SharedLocalProtocolMemory: Connection cannot be null");
        }
        try {
            this.slpmMode = n2;
            this.nAttach((Connection)localMessageProtocolConnection);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(illegalArgumentException.getMessage());
        }
    }

    public byte[] read(int n2, int n3) throws IOException {
        byte[] byArray = null;
        if (this.slpmMode == 2) {
            throw new IOException("SharedLocalProtocolMemory: Mode should be read");
        }
        byArray = this.nRead(n2, n3);
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException, IllegalArgumentException {
        if (byArray == null) {
            throw new IllegalArgumentException("SharedLocalProtocolMemory: Data cannot be null");
        }
        if (this.slpmMode == 1) {
            throw new IOException("SharedLocalProtocolMemory: Mode should be write");
        }
        if (byArray.length < n2) {
            throw new IOException("SharedLocalProtocolMemory: Write out of bound");
        }
        this.nWrite(byArray, n2, n3);
    }

    public void close() throws IOException {
        if (this.slpmFileDes == 0) {
            throw new IOException("SharedLocalProtocolMemory: No shared memory to close");
        }
        this.nClose();
    }

    public String getURI() throws IOException {
        if (this.slpmSize == 0) {
            throw new IOException("SharedLocalProtocolMemory: Connection Closed");
        }
        return this.slpmUri;
    }

    public int getSize() throws IOException {
        if (this.slpmSize == 0) {
            throw new IOException("SharedLocalProtocolMemory: Connection Closed");
        }
        return this.slpmSize;
    }

    private native void nCreate() throws IOException;

    private native void nOpen(Connection var1) throws IOException;

    private native void nAttach(Connection var1) throws IOException;

    private native void nClose() throws IOException;

    private native byte[] nRead(int var1, int var2) throws IOException;

    private native void nWrite(byte[] var1, int var2, int var3) throws IOException;
}

