/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.appl.sa.tool;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import javax.microedition.io.CommConnection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.midlet.MIDlet;

public class Log {
    private static final int FILE_INDX = 0;
    private static final int SYSOUT_INDX = 1;
    private static final int COMM_INDX = 2;
    private static PrintStream[] streams = new PrintStream[3];
    private static FileConnection fileConn = null;
    private static CommConnection commConn = null;
    private static final String DEFAULT_COM_PORT_ID = "USB1";
    public static final boolean TEST = true;
    public static final boolean IMPL = false;
    public static final boolean MSGS = true;
    public static final int MAX_HEX_LEN = 512;
    private static String id;
    public static boolean LOG_ENABLED;

    static {
        LOG_ENABLED = false;
    }

    public static void setFileLogger(boolean enabled, String filenamePrefix) throws IOException, SecurityException {
        if (enabled) {
            Log.openFileConnection(filenamePrefix);
        } else {
            if (streams[0] != null) {
                streams[0].close();
                Log.streams[0] = null;
            }
            if (fileConn != null) {
                try {
                    fileConn.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                fileConn = null;
            }
        }
    }

    public static void setCommPortLogger(boolean enabled, String commPortId) throws IOException, SecurityException {
        if (commPortId == null) {
            commPortId = DEFAULT_COM_PORT_ID;
        }
        if (enabled) {
            Log.openCommConnection(commPortId);
        } else {
            if (streams[2] != null) {
                streams[2].close();
                Log.streams[2] = null;
            }
            if (commConn != null) {
                try {
                    commConn.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                commConn = null;
            }
        }
    }

    private static void openCommConnection(String commPortId) throws IOException, SecurityException {
        String portIds = System.getProperty("microedition.commports");
        if (portIds == null || portIds.indexOf(commPortId) == -1) {
            throw new IOException("COM port not available: " + commPortId);
        }
        commConn = (CommConnection)Connector.open((String)("comm:" + commPortId));
        Log.streams[2] = new PrintStream(commConn.openOutputStream());
    }

    private static void openFileConnection(String filenamePrefix) throws IOException, SecurityException {
        if (!System.getProperty("microedition.io.file.FileConnection.version").equals("1.0")) {
            throw new IOException("FileConnection not available");
        }
        String filename = Log.createLogFilename(filenamePrefix);
        String[] pathProperties = new String[]{"fileconn.dir.memorycard", "fileconn.dir.recordings"};
        String path = null;
        int i2 = 0;
        while (i2 < pathProperties.length) {
            block8: {
                path = System.getProperty(pathProperties[i2]);
                try {
                    if (path == null) {
                        if (i2 >= pathProperties.length - 1) {
                            throw new IOException("Path not available: " + pathProperties[i2]);
                        }
                        break block8;
                    }
                    FileConnection fConn = (FileConnection)Connector.open((String)(String.valueOf(path) + filename), (int)2);
                    fConn.create();
                    Log.streams[0] = new PrintStream(fConn.openDataOutputStream());
                    fileConn = fConn;
                    break;
                }
                catch (SecurityException se) {
                    if (i2 == pathProperties.length - 1) {
                        throw se;
                    }
                }
                catch (IOException ioe) {
                    if (i2 != pathProperties.length - 1) break block8;
                    throw ioe;
                }
            }
            ++i2;
        }
    }

    private static String createLogFilename(String filenamePrefix) {
        StringBuffer fn = new StringBuffer(filenamePrefix);
        fn.append('_');
        Log.appendTimeStamp(fn, true);
        fn.append(".log");
        return fn.toString();
    }

    private static void append2Digits(StringBuffer sb, int num) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
    }

    private static final void print2Digits(PrintStream ps, int num) {
        if (num < 10) {
            ps.print('0');
        }
        ps.print(num);
    }

    public static void appendTimeStamp(StringBuffer sb, boolean includeDate) {
        Calendar c2 = Calendar.getInstance();
        if (includeDate) {
            int day = c2.get(5);
            int month = c2.get(2) + 1;
            int year = c2.get(1);
            Log.append2Digits(sb, day);
            Log.append2Digits(sb, month);
            sb.append(year);
            sb.append('_');
        }
        int hour = c2.get(11);
        int mins = c2.get(12);
        int secs = c2.get(13);
        Log.append2Digits(sb, hour);
        Log.append2Digits(sb, mins);
        Log.append2Digits(sb, secs);
    }

    public static void printTimeStamp(PrintStream ps, boolean includeDate) {
        Calendar c2 = Calendar.getInstance();
        if (includeDate) {
            int day = c2.get(5);
            int month = c2.get(2) + 1;
            int year = c2.get(1);
            Log.print2Digits(ps, day);
            Log.print2Digits(ps, month);
            ps.print(year);
            ps.print('_');
        }
        int hour = c2.get(11);
        int mins = c2.get(12);
        int secs = c2.get(13);
        Log.print2Digits(ps, hour);
        Log.print2Digits(ps, mins);
        Log.print2Digits(ps, secs);
    }

    public static void setConsoleLogger(boolean enabled) {
        Log.streams[1] = enabled ? System.out : null;
    }

    public static boolean isUsingFiles() {
        return streams[0] != null;
    }

    public static boolean isUsingConsole() {
        return streams[1] != null;
    }

    public static boolean isUsingCommConn() {
        return streams[2] != null;
    }

    public static synchronized void print(boolean printObj, String message, Object obj, String loggerName, String levelName) {
        String objStr;
        if (!LOG_ENABLED) {
            return;
        }
        String string = objStr = obj == null ? "NULL" : obj.toString();
        if (message == null) {
            message = "";
        }
        int i2 = 0;
        while (i2 < streams.length) {
            PrintStream ps = streams[i2];
            if (ps != null) {
                Log.printTimeStamp(ps, false);
                ps.print(' ');
                if (loggerName != null) {
                    ps.print('[');
                    ps.print(loggerName);
                    ps.print("] ");
                }
                ps.print(levelName);
                ps.print(' ');
                ps.print(message);
                if (printObj) {
                    ps.print(": ");
                    ps.print(objStr);
                }
                ps.println();
                ps.flush();
            }
            ++i2;
        }
    }

    private static void print(boolean error, boolean printObj, String message, Object obj) {
        Log.print(printObj, message, obj, null, error ? "**ERROR**" : "TRACE");
    }

    public static void note(String message) {
        Log.print(false, false, message, null);
    }

    public static void note(String message, Object value) {
        Log.print(false, true, message, value);
    }

    public static void note(String message, int value) {
        Log.print(false, true, message, new Integer(value));
    }

    public static void note(String message, long value) {
        Log.print(false, true, message, new Long(value));
    }

    public static void note(String message, boolean value) {
        Log.print(false, true, message, new Boolean(value));
    }

    public static void error(String message) {
        Log.print(true, false, message, null);
    }

    public static void error(String message, Object value) {
        Log.print(true, true, message, value);
    }

    public static void error(String message, int value) {
        Log.print(true, true, message, new Integer(value));
    }

    public static void error(String message, long value) {
        Log.print(true, true, message, new Long(value));
    }

    public static void error(String message, boolean value) {
        Log.print(true, true, message, new Boolean(value));
    }

    public static void note(String message, byte[] data, int len) {
        Log.print(false, true, message, Log.bytes2hex(data, 0, len, true));
    }

    public static final String bytes2hex(byte[] data, int offset, int len, boolean limit) {
        if (len > 512) {
            len = 512;
        } else {
            limit = false;
        }
        StringBuffer sb = new StringBuffer(2 * len + (limit ? 3 : 0));
        int lastIndx = offset + len;
        int i2 = offset;
        while (i2 < lastIndx) {
            int b2 = data[i2] & 0xFF;
            if (b2 < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(b2));
            ++i2;
        }
        if (limit) {
            sb.append("...");
        }
        return sb.toString();
    }

    public static String getId() {
        return id;
    }

    public static boolean initLogging(MIDlet midlet) {
        return Log.initLogging(midlet, null);
    }

    public static boolean initLogging(MIDlet midlet, String id) {
        int lastDot;
        if (id == null && (lastDot = (id = midlet.getClass().getName()).lastIndexOf(46)) > -1) {
            id = id.substring(lastDot + 1);
        }
        Log.id = id;
        try {
            if (Log.isEnabled(midlet, id, "logfile", false)) {
                Log.setFileLogger(true, id);
            } else {
                Log.setFileLogger(false, id);
            }
            if (Log.isEnabled(midlet, id, "logsysout", false)) {
                Log.setConsoleLogger(true);
            } else {
                Log.setConsoleLogger(false);
            }
            if (Log.isEnabled(midlet, id, "logcomm", false)) {
                Log.setCommPortLogger(true, midlet.getAppProperty("logcomm-id"));
            } else {
                Log.setCommPortLogger(false, null);
            }
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private static final boolean isEnabled(MIDlet midlet, String id, String attrName, boolean defaultValue) {
        String value;
        String origAttrName = attrName;
        if (id != null) {
            attrName = String.valueOf(id) + "-" + attrName;
        }
        if ((value = midlet.getAppProperty(attrName)) == null) {
            if (id != null) {
                return Log.isEnabled(midlet, null, origAttrName, defaultValue);
            }
            return defaultValue;
        }
        return value.equalsIgnoreCase("enabled");
    }

    public static final void closeLogging() {
        try {
            Log.setFileLogger(false, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Log.setCommPortLogger(false, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

