/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.startupsequence;

import com.gamelion.speedx.Debug;
import com.gamelion.speedx.IGameState;
import com.gamelion.speedx.SpeedXMIDlet;
import com.gamelion.speedx.startupsequence.LoadingThread;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class StartupSequence
implements IGameState {
    private static final int STATE_FADE_IN = 0;
    private static final int STATE_FADE_OUT = 1;
    private static final int STATE_WAIT = 2;
    private static final float FADE_TIME = 0.5f;
    private SpeedXMIDlet midlet;
    private LoadingThread workerThread;
    private Image logo;
    private int state;
    private float timer;
    private float alpha;
    private boolean skipFrame;

    public StartupSequence(SpeedXMIDlet midlet) {
        this.midlet = midlet;
    }

    public void onEnter() {
        try {
            this.logo = Image.createImage((String)"/splash.png");
        }
        catch (Exception ex) {
            Debug.error(ex, "failed to load gamelion logo");
        }
        this.skipFrame = true;
        this.state = 0;
        this.timer = 0.0f;
    }

    public void onLeave() {
        this.logo = null;
        System.gc();
        if (!this.workerThread.finished()) {
            Debug.error("loading thread still running!");
        }
        this.workerThread = null;
    }

    public void onUpdate(float dt) {
        if (this.skipFrame) {
            this.skipFrame = false;
            return;
        }
        switch (this.state) {
            case 0: {
                this.alpha = 1.0f - this.timer / 0.5f;
                if (!(this.timer > 0.5f)) break;
                this.state = 2;
                this.workerThread = new LoadingThread(this.midlet);
                this.workerThread.start();
                this.alpha = 0.0f;
                break;
            }
            case 1: {
                this.alpha = this.timer / 0.5f;
                if (!(this.timer > 0.5f)) break;
                this.midlet.changeState(1);
                this.alpha = 1.0f;
                break;
            }
            case 2: {
                if (!this.workerThread.finished()) break;
                this.state = 1;
                this.timer = 0.0f;
            }
        }
        this.timer += dt;
    }

    public void onRepaint(Graphics g) {
        int width = this.midlet.canvas().getWidth();
        int height = this.midlet.canvas().getHeight();
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, width, height);
        g.drawImage(this.logo, width / 2, height / 2, 3);
        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
        int a = (int)(this.alpha * 255.0f);
        dg.setARGBColor(a << 24);
        g.fillRect(0, 0, width, height);
    }

    public void onPointerPressed(int x, int y) {
    }

    public void onPointerDragged(int x, int y) {
    }

    public void onPointerReleased(int x, int y) {
    }

    public void onKeyPressed(int code) {
    }

    public void onKeyReleased(int code) {
    }

    public void onFocusChanged(boolean focused) {
    }
}

