/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx;

public class Debug {
    public static final int TRACE = 0;
    public static final int WARN = 1;
    public static final int ERROR = 2;
    private static int level = 3;

    public static void trace(String message) {
        Debug.doLog(0, message);
    }

    public static void warn(String message) {
        Debug.doLog(1, message);
    }

    public static void error(String message) {
        Debug.doLog(2, message);
    }

    public static void error(Exception ex, String message) {
        Debug.doLog(2, message);
        Debug.doLog(2, ex.getMessage());
        ex.printStackTrace();
    }

    public static void setLevel(int lvl) {
        level = lvl;
    }

    private static void doLog(int lvl, String message) {
        if (lvl >= level) {
            System.out.print('[');
            if (lvl == 0) {
                System.out.print("trace");
            } else if (lvl == 1) {
                System.out.print("warn");
            } else if (lvl == 2) {
                System.out.print("error");
            }
            System.out.print(']');
            System.out.print(' ');
            System.out.print(message);
            System.out.println();
        }
    }
}

