/*
 * Decompiled with CFR 0.152.
 */
package com.gamelion.speedx.textdisplay.test;

import com.gamelion.speedx.Debug;
import com.gamelion.speedx.textdisplay.IParserListener;
import com.gamelion.speedx.textdisplay.Parser;
import com.gamelion.speedx.textdisplay.Tokenizer;

public class Test
implements IParserListener {
    private Tokenizer tokenizer;
    private Parser parser;

    public void run() {
        Debug.setLevel(0);
        this.tokenizer = new Tokenizer();
        this.tokenize(" a abc ab1_ [ ] a[a a[]a a[b]a");
        System.out.println("==================================");
        this.parser = new Parser(this);
        this.parser.parse("[align left][align right][align center][align justify][break][image 1.png][font 1_font.xml]. test sequence.");
    }

    private void tokenize(String str) {
        this.tokenizer.tokenize(str);
        while (true) {
            int token;
            if ((token = this.tokenizer.nextToken()) == 1) {
                System.out.print("l.brace ");
                continue;
            }
            if (token == 2) {
                System.out.print("r.brace ");
                continue;
            }
            if (token == 0) {
                System.out.print("s.(" + this.tokenizer.stringToken() + ") ");
                continue;
            }
            if (token == 3) break;
        }
    }

    public static void main(String[] args) {
        Test t = new Test();
        t.run();
    }

    public void onText(String text) {
        System.out.println("text: " + text);
    }

    public void onImage(String imageName) {
        System.out.println("image: " + imageName);
    }

    public void onLayoutChange(int layoutType) {
        System.out.println("layoutType: " + layoutType);
    }

    public void onFontChange(String fontName) {
        System.out.println("fontName: " + fontName);
    }

    public void onBreak() {
        System.out.println("break");
    }
}

